/*
 * Decompiled with CFR 0.152.
 */
package sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import sql.SQLHelper;
import util.TestException;
import util.TestHelper;

public class DiscDBManager {
    private static String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    private static String protocol = "jdbc:derby:";
    private static String dbName = "test";
    private static boolean dbExist = false;

    public static String getDriver() {
        return driver;
    }

    public static String getUrl() {
        return protocol + dbName;
    }

    public static String getDBName() {
        return dbName;
    }

    public static synchronized Connection getConnection() throws SQLException {
        Connection conn = null;
        if (!dbExist) {
            conn = DriverManager.getConnection(protocol + dbName + ";create=true");
            dbExist = true;
        } else {
            conn = DriverManager.getConnection(protocol + dbName);
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public static void shutDownDB() {
        block2: {
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) break block2;
                SQLHelper.printSQLException(se);
                throw new TestException("Shutdown failed:" + TestHelper.getStackTrace((Throwable)se));
            }
        }
    }

    static {
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("Unable to load the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)cnfe));
        }
        catch (InstantiationException ie) {
            throw new TestException("Unable to instantiate the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)ie));
        }
        catch (IllegalAccessException iae) {
            throw new TestException("Not allowed to access the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)iae));
        }
    }
}

