/*
 * Decompiled with CFR 0.152.
 */
package sql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import sql.ClientDiscDBManager;
import sql.GFEDBManager;
import sql.SQLHelper;

public class FunctionTest {
    protected static int maxNumOfTries = 1;

    protected static Connection getDefaultConnection() throws SQLException {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection("jdbc:default:connection");
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return conn;
    }

    protected static Connection getDerbyConnection() throws SQLException {
        return ClientDiscDBManager.getConnection();
    }

    public static ResultSet readPortfolioDerby(int tid) throws SQLException {
        Connection conn = FunctionTest.getDerbyConnection();
        PreparedStatement ps1 = conn.prepareStatement("select * from trade.portfolio where tid = ?");
        ps1.setInt(1, tid);
        return ps1.executeQuery();
    }

    public static ResultSet readPortfolioGfxd(int tid) throws SQLException {
        Connection conn = FunctionTest.getGfxdConnection();
        PreparedStatement ps1 = conn.prepareStatement("select * from trade.portfolio where tid = ?");
        ps1.setInt(1, tid);
        return ps1.executeQuery();
    }

    protected static Connection getGfxdConnection() throws SQLException {
        return GFEDBManager.getConnection();
    }

    public static BigDecimal multiply(BigDecimal cash) {
        return cash.multiply(new BigDecimal(Double.toString(1.01)));
    }

    public static BigDecimal multiply2(BigDecimal cash) {
        return cash.multiply(new BigDecimal(Double.toString(1.001)));
    }

    public static int getMaxCid(int tid) throws SQLException {
        boolean[] success = new boolean[1];
        int cid = 0;
        cid = FunctionTest.getMaxCid(tid, success);
        while (!success[0]) {
            cid = FunctionTest.getMaxCid(tid, success);
        }
        return cid;
    }

    private static int getMaxCid(int tid, boolean[] success) throws SQLException {
        int cid = 0;
        Connection conn = FunctionTest.getDefaultConnection();
        PreparedStatement ps1 = null;
        success[0] = true;
        try {
            ps1 = conn.prepareStatement("select max(cid) as lastcid from trade.networth where tid= ? ");
            ps1.setInt(1, tid);
            ResultSet rs = ps1.executeQuery();
            if (rs.next()) {
                cid = rs.getInt("LASTCID");
            }
            rs.close();
            conn.close();
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01")) {
                System.out.println("remote node is down during the query, need to retry");
                success[0] = false;
            }
            throw se;
        }
        return cid;
    }

    public static int month(Date since) {
        Calendar c = Calendar.getInstance();
        c.setTime(since);
        return c.get(2);
    }
}

