/*
 * Decompiled with CFR 0.152.
 */
package sql;

import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.FabricSecurityPrms;
import hydra.gemfirexd.NetworkServerHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import sql.GFEDBManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.sqlutil.ResultSetHelper;
import sql.wan.SQLWanPrms;
import util.TestException;
import util.TestHelper;

public class GFEDBClientManager {
    protected static String driver = "com.pivotal.gemfirexd.jdbc.ClientDriver";
    protected static String protocol = "jdbc:gemfirexd://";
    private static String userPrefix = "thr_";
    protected static boolean useGemFireXDHA = TestConfig.tab().booleanAt(SQLPrms.useGemFireXDHA, false);
    protected static boolean useGfxdConfig = TestConfig.tab().booleanAt(SQLPrms.useGfxdConfig, false);
    private static NetworkServerHelper.Endpoint fixedEndpoint = null;
    private static Map<String, ArrayList<Integer>> map;
    private static String[] hostNames;
    private static boolean isWanTest;
    public static boolean isSingleHop;
    protected static final String singleHop = "single-hop-enabled";
    protected static final String LOG_FILE_NAME = "log-file";
    protected static final String connectionReadTimeout = "180";
    protected static final String repeatableReadTimeout = "1200";

    public static synchronized void initAvailHostPort() {
        if (map == null) {
            map = (HashMap)SQLBB.getBB().getSharedMap().get((Object)"serverPorts");
        }
        hostNames = map.keySet().toArray(new String[0]);
    }

    public static synchronized Connection getConnection() throws SQLException {
        StringBuffer hostName = new StringBuffer();
        int[] port = new int[1];
        GFEDBClientManager.getInfo(hostName, port);
        Connection conn = GFEDBClientManager.getConnection(hostName.toString(), port[0]);
        Log.getLogWriter().info("This connection connected to hostname " + hostName + " port: " + port[0]);
        ResultSet rs = conn.createStatement().executeQuery("values dsid()");
        Log.getLogWriter().info("This connects to actual server " + ResultSetHelper.listToString(ResultSetHelper.asList(rs, false)));
        return conn;
    }

    private static synchronized Connection getConnection(String hostName, int port) throws SQLException {
        Properties p = new Properties();
        return GFEDBClientManager.getConnection(hostName, port, p);
    }

    public static synchronized Connection getConnection(Properties info) throws SQLException {
        StringBuffer hostName = new StringBuffer();
        int[] port = new int[1];
        GFEDBClientManager.getInfo(hostName, port);
        return GFEDBClientManager.getConnection(hostName.toString(), port[0], info);
    }

    public static synchronized Connection getConnection(String hostName, int port, Properties info) throws SQLException {
        if (isSingleHop) {
            info.setProperty(singleHop, "true");
            info.setProperty("read-timeout", connectionReadTimeout);
        }
        info.setProperty(LOG_FILE_NAME, GFEDBClientManager.getLogFile());
        Connection conn = DriverManager.getConnection(protocol + hostName + ":" + port, info);
        conn.setAutoCommit(false);
        return conn;
    }

    protected static synchronized String getLogFile() {
        return System.getProperty("user.dir") + "/vm_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getMyClientName() + "_" + RemoteTestModule.getMyPid() + "_client.log";
    }

    public static synchronized Connection getTxConnection() throws SQLException {
        StringBuffer hostName = new StringBuffer();
        int[] port = new int[1];
        GFEDBClientManager.getInfo(hostName, port);
        return GFEDBClientManager.getTxConnection(hostName.toString(), port[0]);
    }

    protected static void getInfo(StringBuffer hostName, int[] port) {
        if (useGfxdConfig) {
            if (fixedEndpoint == null) {
                fixedEndpoint = GFEDBClientManager.getEndpoint();
            }
            if (SQLTest.random.nextBoolean()) {
                hostName.append(GFEDBClientManager.getHostNameFromEndpoint(fixedEndpoint));
                port[0] = GFEDBClientManager.getPortFromEndpoint(fixedEndpoint);
            } else {
                NetworkServerHelper.Endpoint e = GFEDBClientManager.getEndpoint();
                hostName.append(GFEDBClientManager.getHostNameFromEndpoint(e));
                port[0] = GFEDBClientManager.getPortFromEndpoint(e);
            }
        } else {
            hostName.append(GFEDBClientManager.getHostName());
            port[0] = GFEDBClientManager.getPort(hostName.toString());
        }
        Log.getLogWriter().info("will connect to hostname " + hostName + " port: " + port[0]);
    }

    private static NetworkServerHelper.Endpoint getEndpoint() {
        if (!isWanTest) {
            if (isSingleHop) {
                return (NetworkServerHelper.Endpoint)NetworkServerHelper.getNetworkLocatorEndpoints().get(0);
            }
            List endpoints = SQLTest.isHATest ? NetworkServerHelper.getNetworkLocatorEndpoints() : NetworkServerHelper.getNetworkServerEndpoints();
            return (NetworkServerHelper.Endpoint)endpoints.get(SQLTest.random.nextInt(endpoints.size()));
        }
        List<NetworkServerHelper.Endpoint> endpoints = SQLTest.isHATest ? NetworkServerHelper.getNetworkLocatorEndpointsInWanSite() : NetworkServerHelper.getNetworkServerEndpointsInWanSite();
        Log.getLogWriter().info("Endpoints of this wan site for this client is " + endpoints);
        return endpoints.get(SQLTest.random.nextInt(endpoints.size()));
    }

    private static synchronized Connection getTxConnection(String hostName, int port) throws SQLException {
        Properties p = new Properties();
        return GFEDBClientManager.getTxConnection(hostName, port, p);
    }

    private static synchronized Connection getTxConnection(String hostName, int port, Properties info) throws SQLException {
        return GFEDBClientManager.getTxConnection(hostName, port, info, GFEDBManager.Isolation.READ_COMMITTED);
    }

    private static Connection getTxConnection(String hostName, int port, Properties info, GFEDBManager.Isolation isolation) throws SQLException {
        if (isSingleHop) {
            info.setProperty(singleHop, "true");
            info.setProperty("read-timeout", connectionReadTimeout);
        }
        info.setProperty(LOG_FILE_NAME, GFEDBClientManager.getLogFile());
        Connection conn = DriverManager.getConnection(protocol + hostName + ":" + port, info);
        switch (isolation) {
            case NONE: {
                conn.setTransactionIsolation(0);
                return conn;
            }
            case READ_COMMITTED: {
                conn.setTransactionIsolation(2);
                break;
            }
            case REPEATABLE_READ: {
                conn.setTransactionIsolation(4);
                break;
            }
            default: {
                throw new TestException("test issue -- unknow Isolation lever");
            }
        }
        conn.setAutoCommit(false);
        return conn;
    }

    private static synchronized Connection getRRTxConnection(String hostName, int port, Properties info) throws SQLException {
        return GFEDBClientManager.getTxConnection(hostName, port, info, GFEDBManager.Isolation.REPEATABLE_READ);
    }

    protected static String getHostNameFromEndpoint(NetworkServerHelper.Endpoint e) {
        return e.getHost();
    }

    protected static int getPortFromEndpoint(NetworkServerHelper.Endpoint e) {
        return e.getPort();
    }

    public static synchronized Connection getTxConnection(Properties info) throws SQLException {
        StringBuffer hostName = new StringBuffer();
        int[] port = new int[1];
        GFEDBClientManager.getInfo(hostName, port);
        return GFEDBClientManager.getTxConnection(hostName.toString(), port[0], info);
    }

    public static String getDriver() {
        return driver;
    }

    public static String getProtocol() {
        return protocol;
    }

    public static void closeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to release the connection " + TestHelper.getStackTrace((Throwable)e));
        }
    }

    private static String getHostName() {
        if (hostNames != null) {
            return hostNames[SQLTest.random.nextInt(hostNames.length)];
        }
        throw new TestException("no server bridge node available");
    }

    private static int getPort(String name) {
        ArrayList<Integer> ports = map.get(name);
        return ports.get(SQLTest.random.nextInt(ports.size()));
    }

    public static synchronized Connection getSuperUserConnection() throws SQLException {
        String user = TestConfig.tab().stringAt(FabricSecurityPrms.user, "superUser");
        String passwd = TestConfig.tab().stringAt(FabricSecurityPrms.password, "superUser");
        String superUser = ";user=" + user + ";password=" + passwd;
        Log.getLogWriter().info("get connection using this credential: " + superUser);
        Properties p = new Properties();
        p.setProperty("user", user);
        p.setProperty("password", passwd);
        return GFEDBClientManager.getConnection(p);
    }

    public static synchronized Connection getAuthConnection(int thrId) throws SQLException {
        String user;
        String passwd = user = userPrefix + thrId;
        String userAuth = ";user=" + user + ";password=" + passwd;
        Log.getLogWriter().info("current gfxd connection use the following credential: " + userAuth);
        Properties p = new Properties();
        p.setProperty("user", user);
        p.setProperty("password", passwd);
        return GFEDBClientManager.getConnection(p);
    }

    public static synchronized Connection getInvalidAuthConnection(int thrId) throws SQLException {
        String user = userPrefix + thrId;
        String passwd = user + "x";
        String userAuth = ";user=" + user + ";password=" + passwd;
        Log.getLogWriter().info("current gfxd connection use the following credential: " + userAuth);
        Properties p = new Properties();
        p.setProperty("user", user);
        p.setProperty("password", passwd);
        return GFEDBClientManager.getConnection(p);
    }

    public static synchronized Connection getNoneAuthConnection(int thrId) throws SQLException {
        Log.getLogWriter().info("current gfxd connection use no credential");
        return GFEDBClientManager.getConnection();
    }

    public static synchronized Connection getAuthConnection(String user) throws SQLException {
        String passwd = user;
        String userAuth = ";user=" + user + ";password=" + passwd;
        Log.getLogWriter().info("current gfxd connection use the following credential: " + userAuth);
        Properties p = new Properties();
        p.setProperty("user", user);
        p.setProperty("password", passwd);
        return GFEDBClientManager.getConnection(p);
    }

    public static synchronized Connection getAuthConnection(String user, String passwd) throws SQLException {
        String userAuth = ";user=" + user + ";password=" + passwd;
        Log.getLogWriter().info("current gfxd connection use the following credential: " + userAuth);
        Properties p = new Properties();
        p.setProperty("user", user);
        p.setProperty("password", passwd);
        return GFEDBClientManager.getConnection(p);
    }

    public static synchronized Connection getTxConnection(GFEDBManager.Isolation isolation) throws SQLException {
        switch (isolation) {
            case NONE: {
                Connection conn = GFEDBClientManager.getConnection();
                conn.setTransactionIsolation(0);
                return conn;
            }
            case READ_COMMITTED: {
                return GFEDBClientManager.getReadCommittedConnection();
            }
            case REPEATABLE_READ: {
                return GFEDBClientManager.getRepeatableReadConnection();
            }
        }
        throw new TestException("test issue -- unknow Isolation lever");
    }

    public static Connection getReadCommittedConnection() throws SQLException {
        StringBuffer hostName = new StringBuffer();
        int[] port = new int[1];
        GFEDBClientManager.getInfo(hostName, port);
        Connection conn = GFEDBClientManager.getTxConnection(hostName.toString(), port[0]);
        if (SQLTest.random.nextInt(20) == 1) {
            conn.setTransactionIsolation(1);
        } else {
            conn.setTransactionIsolation(2);
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public static Connection getRepeatableReadConnection() throws SQLException {
        StringBuffer hostName = new StringBuffer();
        int[] port = new int[1];
        GFEDBClientManager.getInfo(hostName, port);
        Properties p = new Properties();
        p = new Properties();
        p.setProperty("read-timeout", repeatableReadTimeout);
        Connection conn = GFEDBClientManager.getTxConnection(hostName.toString(), port[0], p);
        conn.setTransactionIsolation(4);
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getMyConnection() throws SQLException {
        StringBuffer hostName = new StringBuffer();
        int[] port = new int[1];
        GFEDBClientManager.getInfo(hostName, port);
        return GFEDBClientManager.getConnection(hostName.toString(), port[0]);
    }

    public static synchronized Connection getRRTxConnection(Properties info) throws SQLException {
        StringBuffer hostName = new StringBuffer();
        int[] port = new int[1];
        GFEDBClientManager.getInfo(hostName, port);
        return GFEDBClientManager.getRRTxConnection(hostName.toString(), port[0], info);
    }

    public static Properties getExtraConnProp() {
        Properties p = new Properties();
        if (isSingleHop) {
            p.setProperty(singleHop, "true");
            p.setProperty("read-timeout", connectionReadTimeout);
        }
        p.setProperty(LOG_FILE_NAME, GFEDBClientManager.getLogFile());
        return p;
    }

    static {
        isWanTest = TestConfig.tab().booleanAt(SQLWanPrms.isWanTest, false);
        isSingleHop = TestConfig.tab().booleanAt(SQLPrms.isSingleHop, false);
        driver = TestConfig.tab().stringAt(SQLPrms.clientDriver, "com.pivotal.gemfirexd.jdbc.ClientDriver");
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("Unable to load the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)cnfe));
        }
        catch (InstantiationException ie) {
            throw new TestException("Unable to instantiate the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)ie));
        }
        catch (IllegalAccessException iae) {
            throw new TestException("Not allowed to access the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)iae));
        }
        if (!useGfxdConfig) {
            GFEDBClientManager.initAvailHostPort();
        }
    }
}

