/*
 * Decompiled with CFR 0.152.
 */
package sql;

import hydra.Log;
import hydra.TestConfig;
import hydra.gemfirexd.FabricSecurityPrms;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import util.TestException;
import util.TestHelper;

public class GFEDBManager {
    private static String driver = "com.pivotal.gemfirexd.jdbc.EmbeddedDriver";
    private static String protocol = "jdbc:gemfirexd:";
    private static String dbName = "";
    private static boolean hasTx = TestConfig.tab().booleanAt(SQLPrms.hasTx, false);

    public static synchronized Connection getConnection() throws SQLException {
        if (SQLTest.random.nextInt(100) == 1) {
            System.setProperty("gemfirexd.table-default-partitioned", "true");
        }
        Connection conn = DriverManager.getConnection(protocol + dbName);
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getTxConnection() throws SQLException {
        if (SQLTest.random.nextInt(100) == 1) {
            System.setProperty("gemfirexd.table-default-partitioned", "true");
        }
        Connection conn = DriverManager.getConnection(protocol + dbName);
        if (SQLTest.random.nextInt(20) == 1) {
            conn.setTransactionIsolation(1);
        } else {
            conn.setTransactionIsolation(2);
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getTxConnection(Properties info) throws SQLException {
        Connection conn = DriverManager.getConnection(protocol + dbName, info);
        if (SQLTest.random.nextInt(20) == 1) {
            conn.setTransactionIsolation(1);
        } else {
            conn.setTransactionIsolation(2);
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getRRTxConnection(Properties info) throws SQLException {
        Connection conn = DriverManager.getConnection(protocol + dbName, info);
        conn.setTransactionIsolation(4);
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getConnection(Properties info) throws SQLException {
        if (info != null && SQLTest.random.nextBoolean()) {
            info.setProperty("disable-streaming", "false");
        }
        Connection conn = DriverManager.getConnection(protocol + dbName, info);
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getRestartConnection(Properties info) throws SQLException {
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("Unable to load the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)cnfe));
        }
        catch (InstantiationException ie) {
            throw new TestException("Unable to instantiate the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)ie));
        }
        catch (IllegalAccessException iae) {
            throw new TestException("Not allowed to access the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)iae));
        }
        if (info != null) {
            if (SQLTest.random.nextBoolean()) {
                info.setProperty("disable-streaming", "false");
            }
            info.setProperty("table-default-partitioned", "true");
        } else {
            System.setProperty("gemfirexd.table-default-partitioned", "true");
        }
        Connection conn = DriverManager.getConnection(protocol + dbName, info);
        conn.setAutoCommit(false);
        return conn;
    }

    public static String getDriver() {
        return driver;
    }

    public static String getUrl() {
        return protocol + dbName;
    }

    public static void shutDownDB() {
        block3: {
            try {
                if (SQLTest.testSecurity) {
                    GFEDBManager.shutDownDB("superUser", "superUser");
                    return;
                }
                DriverManager.getConnection(protocol + ";shutdown=true");
                Log.getLogWriter().info("gfxdbric has been shut down");
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) break block3;
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public static void shutDownDB(String user, String passwd) {
        block2: {
            try {
                Log.getLogWriter().info("shutting down as : ;user=" + user + ";passwprd=" + passwd);
                DriverManager.getConnection(protocol + ";user=" + user + ";password=" + passwd + ";shutdown=true");
                Log.getLogWriter().info("gfxdbric has been shut down");
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) break block2;
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public static void closeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to release the connection " + TestHelper.getStackTrace((Throwable)e));
        }
    }

    public static synchronized Connection getSuperUserConnection() throws SQLException {
        Connection conn = null;
        String user = TestConfig.tab().stringAt(FabricSecurityPrms.user, "superUser");
        String passwd = TestConfig.tab().stringAt(FabricSecurityPrms.password, "superUser");
        String superUser = ";user=" + user + ";password=" + passwd;
        Log.getLogWriter().info("get connection using this credential: " + superUser);
        Properties p = new Properties();
        p.setProperty("user", user);
        p.setProperty("password", passwd);
        p.setProperty("table-default-partitioned", "true");
        conn = DriverManager.getConnection(protocol + dbName, p);
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getAuthConnection(int thrId) throws SQLException {
        Connection conn = null;
        String userAuth = ";user=thr_" + thrId + ";password=thr_" + thrId;
        Log.getLogWriter().info("current gfxd connection use the following credential: " + userAuth);
        conn = DriverManager.getConnection(protocol + dbName + userAuth);
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getInvalidAuthConnection(int thrId) throws SQLException {
        Connection conn = null;
        String userAuth = ";user=thr_" + thrId + ";password=thr_" + ++thrId;
        Log.getLogWriter().info("current gfxd connection use the following credential: " + userAuth);
        conn = DriverManager.getConnection(protocol + dbName + userAuth);
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getNoneAuthConnection(int thrId) throws SQLException {
        Log.getLogWriter().info("current gfxd connection use no credential");
        return GFEDBManager.getConnection();
    }

    public static synchronized Connection getAuthConnection(String user) throws SQLException {
        Connection conn = null;
        String userAuth = ";user=" + user + ";password=" + user;
        Log.getLogWriter().info("current connection use the following credential: " + userAuth);
        conn = DriverManager.getConnection(protocol + dbName + userAuth);
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getAuthConnection(String user, String password) throws SQLException {
        Connection conn = null;
        String userAuth = ";user=" + user + ";password=" + password;
        Log.getLogWriter().info("current connection use the following credential: " + userAuth);
        conn = DriverManager.getConnection(protocol + dbName + userAuth);
        conn.setAutoCommit(false);
        return conn;
    }

    public static Connection getReadCommittedConnection() throws SQLException {
        Connection conn = null;
        if (SQLTest.hasJSON) {
            Properties info = new Properties();
            info.setProperty("sync-commits", "true");
            conn = DriverManager.getConnection(protocol + dbName, info);
        } else {
            conn = DriverManager.getConnection(protocol + dbName);
        }
        if (SQLTest.random.nextInt(20) == 1) {
            conn.setTransactionIsolation(1);
        } else {
            conn.setTransactionIsolation(2);
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public static Connection getReadCommittedConnection(Properties info) throws SQLException {
        if (SQLTest.hasJSON) {
            info.setProperty("sync-commits", "true");
        }
        Connection conn = DriverManager.getConnection(protocol + dbName, info);
        if (SQLTest.random.nextInt(20) == 1) {
            conn.setTransactionIsolation(1);
        } else {
            conn.setTransactionIsolation(2);
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public static Connection getRepeatableReadConnection() throws SQLException {
        Connection conn = DriverManager.getConnection(protocol + dbName);
        conn.setTransactionIsolation(4);
        conn.setAutoCommit(false);
        return conn;
    }

    public static Connection getRepeatableReadConnection(Properties info) throws SQLException {
        Connection conn = DriverManager.getConnection(protocol + dbName, info);
        conn.setTransactionIsolation(4);
        conn.setAutoCommit(false);
        return conn;
    }

    public static synchronized Connection getTxConnection(Isolation isolation) throws SQLException {
        switch (isolation) {
            case NONE: {
                Connection conn = GFEDBManager.getConnection();
                conn.setTransactionIsolation(0);
                return conn;
            }
            case READ_COMMITTED: {
                return GFEDBManager.getReadCommittedConnection();
            }
            case REPEATABLE_READ: {
                return GFEDBManager.getRepeatableReadConnection();
            }
        }
        throw new TestException("test issue -- unknow Isolation lever");
    }

    public static synchronized Connection getTxConnection(Isolation isolation, Properties info) throws SQLException {
        switch (isolation) {
            case NONE: {
                Connection conn = GFEDBManager.getConnection(info);
                conn.setTransactionIsolation(0);
                return conn;
            }
            case READ_COMMITTED: {
                return GFEDBManager.getReadCommittedConnection(info);
            }
            case REPEATABLE_READ: {
                return GFEDBManager.getRepeatableReadConnection(info);
            }
        }
        throw new TestException("test issue -- unknow Isolation lever");
    }

    static {
        driver = TestConfig.tab().stringAt(SQLPrms.driver, "com.pivotal.gemfirexd.jdbc.EmbeddedDriver");
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new TestException("Unable to load the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)cnfe));
        }
        catch (InstantiationException ie) {
            throw new TestException("Unable to instantiate the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)ie));
        }
        catch (IllegalAccessException iae) {
            throw new TestException("Not allowed to access the JDBC driver " + driver + ":" + TestHelper.getStackTrace((Throwable)iae));
        }
    }

    public static enum Isolation {
        NONE,
        READ_COMMITTED,
        REPEATABLE_READ;

    }
}

