/*
 * Decompiled with CFR 0.152.
 */
package sql;

import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.HashMap;
import sql.SQLBB;
import sql.SQLPrms;
import sql.SQLTest;
import sql.sqlDAP.DAPHelper;
import sql.sqlDAP.SQLDAPTest;
import sql.sqlTx.SQLTxPartitionInfoBB;
import util.TestException;

public class PartitionClause {
    protected static SharedMap partitionMap = SQLBB.getBB().getSharedMap();
    protected static boolean testServerGroups = TestConfig.tab().booleanAt(SQLPrms.testServerGroups, false);
    protected static boolean withReplicatedTables = TestConfig.tab().booleanAt(SQLPrms.withReplicatedTables, false);
    protected static boolean testServerGroupsInheritence = SQLTest.testServerGroupsInheritence;
    protected static SharedCounters counters = SQLBB.getBB().getSharedCounters();
    protected static boolean testMultiTableJoin = TestConfig.tab().booleanAt(SQLPrms.testMultiTableJoin, false);
    static final boolean isConcUpdateTx = TestConfig.tab().booleanAt(SQLPrms.isConcUpdateTx, false);
    private static int sellordersClause = -1;
    private static SharedMap partitionInfoMap = SQLTxPartitionInfoBB.getBB().getSharedMap();
    static String tradeSchemaSG = SQLTest.tradeSchemaSG;
    static boolean isTicket46996Fixed = false;
    static boolean isTicket46993Fixed = false;
    static boolean isTicket46990Fixed = false;
    static boolean ticket47289resolved = true;
    static HashMap<String, String> hdfsExtnParams = SQLTest.hasHdfs ? (HashMap)SQLBB.getBB().getSharedMap().get((Object)"hdfsExtnParams") : null;
    protected static String[] customersPartitionClause = new String[]{" ", " partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17)) ", " partition by list (tid) (VALUES (0, 1, 3, 4, 5), VALUES (6, 10, 11), VALUES (12, 15, 17)) ", " partition by list (tid) (VALUES (14, 1, 2, 10, 4, 5), VALUES (6, 7, 16, 9, 3, 11), VALUES (12, 13, 0, 15, 8, 17)) ", " partition by range (since) (VALUES BETWEEN CAST('1998-01-01'  AS DATE) AND CAST('2000-08-11' AS DATE),  VALUES BETWEEN CAST('2003-09-01' AS DATE) AND  CAST('2007-12-31' AS DATE) ) ", " partition by (month(since)) ", " partition by column (cust_name) ", SQLDAPTest.cidByRange ? " partition by range (cid) " + DAPHelper.getCidRangePartition() + " BUCKETS " + (SQLTest.numOfStores + 1) + " " : " partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 100000) ", " replicate "};
    protected static String[] securitiesPartitionClause = new String[]{" ", " partition by range (sec_id) ( VALUES BETWEEN 0 AND 409, VALUES BETWEEN 409 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1477, VALUES BETWEEN 1477 AND 1700, VALUES BETWEEN 1700 AND 100000) ", " partition by list (tid) (VALUES (14, 1, 2, 10, 4, 5), VALUES (6, 7, 16, 9, 3, 11), VALUES (12, 13, 0, 15, 8, 17)) ", " partition by range (price) (VALUES BETWEEN 0.0 AND 25.0,  VALUES BETWEEN 25.0  AND 35.0 , VALUES BETWEEN 35.0  AND 49.0, VALUES BETWEEN 49.0  AND 69.0 , VALUES BETWEEN 69.0 AND 100.0) ", " partition by column (sec_id, price) ", " partition by range (symbol) (VALUES BETWEEN 'A' AND 'K', VALUES BETWEEN 'K' AND 'R', VALUES BETWEEN 'R' AND 'a', VALUES BETWEEN 'a' AND 'l', VALUES BETWEEN 'l' AND 'zzzzzzz')", " partition by list (exchange) (VALUES ('nasdaq'), VALUES ('nye', 'amex'), VALUES ('lse', 'fse', 'hkse', 'tse')) ", " replicate "};
    protected static String[] networthPartitionClause = new String[]{" ", SQLDAPTest.cidByRange ? " partition by range (cid) " + DAPHelper.getCidRangePartition() + " BUCKETS " + (SQLTest.numOfStores + 1) + " " : " partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 100000) ", " partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17)) ", " partition by column (cash) ", " partition by range (securities)  ( VALUES BETWEEN 0.0 AND 9999.0, VALUES BETWEEN 12009.0 AND 31002.0, VALUES BETWEEN 31933.0 AND 51251.5, VALUES BETWEEN 51291.1 AND 71677.3, VALUES BETWEEN 71678.0 AND 100000.9) ", " partition by column(loanLimit, availloan)", " partition by (cash + securities + tid) ", " replicate "};
    protected static String[] portfolioPartitionClause = new String[]{" ", SQLDAPTest.cidByRange ? " partition by range (cid) " + DAPHelper.getCidRangePartition() + " BUCKETS " + (SQLTest.numOfStores + 1) + " " : " partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 100000) ", " partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17)) ", " partition by column (qty) ", " partition by column (qty, availQty) ", " partition by range (subTotal)  ( VALUES BETWEEN 0.0 AND 9999.0, VALUES BETWEEN 12009.0 AND 31002.0, VALUES BETWEEN 31933.0 AND 51251.5, VALUES BETWEEN 51291.1 AND 71677.3, VALUES BETWEEN 71678.0 AND 100000.9) ", " partition by range (sid) ( VALUES BETWEEN 0 AND 409, VALUES BETWEEN 409 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1477, VALUES BETWEEN 1477 AND 1700, VALUES BETWEEN 1700 AND 100000) ", " replicate "};
    protected static String[] sellordersPartitionClause = new String[]{" ", SQLDAPTest.cidByRange ? " partition by range (cid) " + DAPHelper.getCidRangePartition() + " BUCKETS " + (SQLTest.numOfStores + 1) + " " : " partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 100000) ", " partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17)) ", " partition by column (qty) ", " partition by range (ask) (VALUES BETWEEN 0.0 AND 25.0, VALUES BETWEEN 25.0  AND 35.0 , VALUES BETWEEN 35.0  AND 49.0, VALUES BETWEEN 49.0  AND 69.0 , VALUES BETWEEN 69.0 AND 100.0) ", " partition by column (ask, status) ", " partition by column (order_time, status) ", " partition by column (sid, order_time, ask) ", " replicate "};
    protected static String[] buyordersPartitionClause = new String[]{" ", " partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 100000) ", SQLDAPTest.tidByList ? " partition by list (tid) " + DAPHelper.getTidListPartition() + " BUCKETS " + ((ArrayList[])SQLBB.getBB().getSharedMap().get((Object)"tidListArray")).length + " " : " partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17)) ", " partition by range (sid) ( VALUES BETWEEN 0 AND 409, VALUES BETWEEN 409 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1477, VALUES BETWEEN 1477 AND 1700, VALUES BETWEEN 1700 AND 100000) ", " partition by range (bid) (VALUES BETWEEN 0.0 AND 25.0,  VALUES BETWEEN 25.0  AND 35.0 , VALUES BETWEEN 35.0  AND 49.0, VALUES BETWEEN 49.0  AND 69.0 , VALUES BETWEEN 69.0 AND 100.0) ", " partition by column (bid, ordertime) ", " partition by column (ordertime, status) ", " replicate "};
    protected static String[] txhistoryPartitionClause = new String[]{" ", " partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 100000) ", SQLDAPTest.tidByList ? " partition by list (tid) " + DAPHelper.getTidListPartition() + " BUCKETS " + ((ArrayList[])SQLBB.getBB().getSharedMap().get((Object)"tidListArray")).length + " " : " partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17)) ", " replicate "};
    protected static String[] companiesPartitionClause = new String[]{" ", " partition by column (uid) ", SQLTest.random.nextBoolean() ? " partition by list (companytype) (VALUES (0, 1), VALUES (2), VALUES (3), VALUES (5, 7), VALUES (6), VALUES (8), VALUES (4), VALUES (9)) " : " partition by list (companytype) (VALUES (0, 1), VALUES (2), VALUES (3), VALUES (5, 7), VALUES (6), VALUES (8), VALUES (4)) ", isTicket46996Fixed ? " partition by range (trade.getLowPrice(histprice)) (VALUES BETWEEN 0.0 AND 25.0,  VALUES BETWEEN 25.0  AND 35.0 , VALUES BETWEEN 35.0  AND 49.0, VALUES BETWEEN 49.0  AND 69.0 , VALUES BETWEEN 69.0 AND 100.0) " : " partition by column(histprice)", " partition by column (companyname) ", " partition by range (symbol) (VALUES BETWEEN 'a' AND 'd', VALUES BETWEEN 'd' AND 'i', VALUES BETWEEN 'i' AND 'k', VALUES BETWEEN 'k' AND 'o', VALUES BETWEEN 'o' AND 'r', VALUES BETWEEN 'r' AND 'u', VALUES BETWEEN 'u' AND'zzzzzzz')", SQLTest.random.nextBoolean() ? " partition by list (exchange) (VALUES ('nasdaq'), VALUES ('nye', 'amex'), VALUES ('lse'),  VALUES ('fse'), VALUES ('hkse'), VALUES ('tse')) " : " partition by list (exchange) (VALUES ('nasdaq'), VALUES ('nye'), VALUES ('lse'),  VALUES ('fse'), VALUES ('hkse'), VALUES ('tse')) ", isTicket46993Fixed ? " partition by (trade.getHighPrice(histprice))" : " partition by column(histprice)", " partition by column(companyinfo)", isTicket46990Fixed ? " partition by range (note) (VALUES BETWEEN '!' AND ')', VALUES BETWEEN '(' AND '0', VALUES BETWEEN '0' AND '=', VALUES BETWEEN '=' AND 'A', VALUES BETWEEN 'A' AND 'K', VALUES BETWEEN 'K' AND 'Z', VALUES BETWEEN 'Z' AND 'c', VALUES BETWEEN 'c' AND 'r', VALUES BETWEEN 'r' AND 'z', VALUES BETWEEN 'z' AND '~')" : " partition by column (note) ", " partition by column(asset, companytype)", " partition by column(logo)", " partition by column(uuid)", " replicate "};

    protected static void writeCustomersPartitionToBB(int whichClause) {
        ArrayList<String> partitionKey = new ArrayList<String>();
        int customersPRs = 2;
        switch (whichClause) {
            case 0: {
                partitionKey.add("cid");
                partitionMap.put((Object)"custPartitionOn", (Object)"hash");
                counters.decrement(SQLBB.numOfPRs);
                --customersPRs;
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.CUSTOMERSSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 1: {
                partitionKey.add("tid");
                break;
            }
            case 2: {
                partitionKey.add("tid");
                break;
            }
            case 3: {
                partitionKey.add("tid");
                break;
            }
            case 4: {
                partitionKey.add("since");
                break;
            }
            case 5: {
                partitionKey.add("since");
                break;
            }
            case 6: {
                partitionKey.add("cust_name");
                break;
            }
            case 7: {
                partitionKey.add("cid");
                partitionMap.put((Object)"custPartitionOn", (Object)"range");
                counters.decrement(SQLBB.numOfPRs);
                --customersPRs;
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.CUSTOMERSSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 8: {
                counters.subtract(SQLBB.numOfPRs, 2L);
                customersPRs = 0;
                break;
            }
            default: {
                throw new TestException("Unknown partitionKey " + whichClause);
            }
        }
        counters.add(SQLBB.numOfPRs, 2L);
        partitionMap.put((Object)"customersPartition", partitionKey);
        if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.CUSTOMERSSTORENAME") != null) {
            counters.add(SQLBB.numOfPRs, 2L);
            if (hdfsExtnParams.get("TRADE.CUSTOMERSEVICTIONCRITERIA") == null && whichClause != 0 && whichClause != 7) {
                counters.subtract(SQLBB.numOfPRs, 1L);
            }
        }
        Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS ignoring colocation" : " "));
        if (SQLTest.hasCustomersDup) {
            counters.add(SQLBB.numOfPRs, (long)customersPRs);
            Log.getLogWriter().info("Adding trade.customersdup's number of PRs: " + customersPRs);
        }
        SQLBB.getBB().getSharedMap().put((Object)"custNumOfPRs", (Object)customersPRs);
    }

    protected static void writeCustomersPartitionSGToBB(int whichClause, String sg) {
        PartitionClause.writeCustomersPartitionToBB(whichClause);
        if (testServerGroupsInheritence && sg.equals("default")) {
            sg = (String)partitionMap.get((Object)tradeSchemaSG);
        }
        partitionMap.put((Object)"customersSG", (Object)sg);
    }

    protected static void writeSecuritiesPartitionToBB(int whichClause) {
        ArrayList<String> partitionKey = new ArrayList<String>();
        switch (whichClause) {
            case 0: {
                partitionKey.add("sec_id");
                counters.decrement(SQLBB.numOfPRs);
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.SECURITIESSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 1: {
                partitionKey.add("sec_id");
                counters.decrement(SQLBB.numOfPRs);
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.SECURITIESSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 2: {
                partitionKey.add("tid");
                break;
            }
            case 3: {
                partitionKey.add("price");
                break;
            }
            case 4: {
                partitionKey.add("price");
                partitionKey.add("sec_id");
                break;
            }
            case 5: {
                partitionKey.add("symbol");
                if (ticket47289resolved) {
                    counters.decrement(SQLBB.numOfPRs);
                }
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.SECURITIESSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                if (hdfsExtnParams.get("TRADE.SECURITIESEVICTIONCRITERIA") == null) break;
                counters.increment(SQLBB.numOfPRs);
                counters.increment(SQLBB.numOfPRs);
                break;
            }
            case 6: {
                partitionKey.add("exchange");
                if (ticket47289resolved) {
                    counters.decrement(SQLBB.numOfPRs);
                }
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.SECURITIESSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                if (hdfsExtnParams.get("TRADE.SECURITIESEVICTIONCRITERIA") == null) break;
                counters.increment(SQLBB.numOfPRs);
                counters.increment(SQLBB.numOfPRs);
                break;
            }
            case 7: {
                counters.subtract(SQLBB.numOfPRs, 3L);
                break;
            }
            default: {
                throw new TestException("Unknown partitionKey " + whichClause);
            }
        }
        counters.add(SQLBB.numOfPRs, 3L);
        partitionMap.put((Object)"securitiesPartition", partitionKey);
        if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.SECURITIESSTORENAME") != null) {
            counters.add(SQLBB.numOfPRs, 3L);
            if (hdfsExtnParams.get("TRADE.SECURITIESEVICTIONCRITERIA") == null) {
                if (whichClause == 0 || whichClause == 1 || whichClause == 5 || whichClause == 6) {
                    counters.subtract(SQLBB.numOfPRs, 1L);
                } else {
                    counters.subtract(SQLBB.numOfPRs, 2L);
                }
            }
        }
        Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS ignoring colocation" : " "));
    }

    protected static void writeSecuritiesPartitionSGToBB(int whichClause, String sg) {
        PartitionClause.writeSecuritiesPartitionToBB(whichClause);
        if (testServerGroupsInheritence && sg.equals("default")) {
            sg = (String)partitionMap.get((Object)tradeSchemaSG);
        }
        partitionMap.put((Object)"securitiesSG", (Object)sg);
    }

    protected static void writeNetworthPartitionToBB(int whichClause) {
        ArrayList<String> partitionKey = new ArrayList<String>();
        int netwPRs = 2;
        switch (whichClause) {
            case 0: {
                partitionKey.add("cid");
                partitionMap.put((Object)"netPartitionOn", (Object)"default");
                counters.decrement(SQLBB.numOfPRs);
                --netwPRs;
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.NETWORTHSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 1: {
                partitionKey.add("cid");
                partitionMap.put((Object)"netPartitionOn", (Object)"range");
                counters.decrement(SQLBB.numOfPRs);
                --netwPRs;
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.NETWORTHSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 2: {
                partitionKey.add("tid");
                break;
            }
            case 3: {
                partitionKey.add("cash");
                break;
            }
            case 4: {
                partitionKey.add("securities");
                break;
            }
            case 5: {
                partitionKey.add("loanLimit");
                partitionKey.add("availloan");
                break;
            }
            case 6: {
                partitionKey.add("cash");
                partitionKey.add("securities");
                partitionKey.add("tid");
                break;
            }
            case 7: {
                counters.subtract(SQLBB.numOfPRs, 2L);
                netwPRs = 0;
                break;
            }
            default: {
                throw new TestException("Unknown partitionKey " + whichClause);
            }
        }
        counters.add(SQLBB.numOfPRs, 2L);
        partitionMap.put((Object)"networthPartition", partitionKey);
        if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.NETWORTHSTORENAME") != null) {
            counters.add(SQLBB.numOfPRs, 2L);
            if (hdfsExtnParams.get("TRADE.NETWORTHEVICTIONCRITERIA") == null && whichClause != 0 && whichClause != 1) {
                counters.subtract(SQLBB.numOfPRs, 1L);
            }
        }
        SQLBB.getBB().getSharedMap().put((Object)"networthNumOfPRs", (Object)netwPRs);
        Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS ignoring colocation" : " "));
    }

    protected static void writeNetworthPartitionSGToBB(int whichClause, String sg) {
        PartitionClause.writeNetworthPartitionToBB(whichClause);
        if (testServerGroupsInheritence && sg.equals("default")) {
            sg = (String)partitionMap.get((Object)tradeSchemaSG);
        }
        partitionMap.put((Object)"networthSG", (Object)sg);
    }

    protected static void writePortfolioPartitionToBB(int whichClause) {
        ArrayList<String> partitionKey = new ArrayList<String>();
        int portfolioPRs = 2;
        switch (whichClause) {
            case 0: {
                ArrayList custPartition = (ArrayList)partitionMap.get((Object)"customersPartition");
                ArrayList secPartition = (ArrayList)partitionMap.get((Object)"securitiesPartition");
                if (custPartition.contains("cid") && custPartition.size() == 1) {
                    partitionKey.add("cid");
                } else if (secPartition.contains("sec_id") && secPartition.size() == 1) {
                    partitionKey.add("sid");
                } else {
                    partitionKey.add("cid");
                    partitionKey.add("sid");
                }
                counters.decrement(SQLBB.numOfPRs);
                --portfolioPRs;
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.PORTFOLIOSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 1: {
                partitionKey.add("cid");
                partitionMap.put((Object)"portfPartitionOn", (Object)"range");
                counters.decrement(SQLBB.numOfPRs);
                --portfolioPRs;
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.PORTFOLIOSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 2: {
                partitionKey.add("tid");
                break;
            }
            case 3: {
                partitionKey.add("qty");
                break;
            }
            case 4: {
                partitionKey.add("qty");
                partitionKey.add("availQty");
                break;
            }
            case 5: {
                partitionKey.add("subTotal");
                break;
            }
            case 6: {
                partitionKey.add("sid");
                partitionMap.put((Object)"portfPartitionOn", (Object)"wrongRange");
                counters.decrement(SQLBB.numOfPRs);
                --portfolioPRs;
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.PORTFOLIOSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 7: {
                counters.subtract(SQLBB.numOfPRs, 2L);
                portfolioPRs = 0;
                break;
            }
            default: {
                throw new TestException("Unknown partitionKey " + whichClause);
            }
        }
        counters.add(SQLBB.numOfPRs, 2L);
        partitionMap.put((Object)"portfolioPartition", partitionKey);
        if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.PORTFOLIOSTORENAME") != null) {
            counters.add(SQLBB.numOfPRs, 2L);
            if (hdfsExtnParams.get("TRADE.PORTFOLIOEVICTIONCRITERIA") == null && whichClause != 0 && whichClause != 1 && whichClause != 6 && whichClause != 7) {
                counters.subtract(SQLBB.numOfPRs, 1L);
            }
        }
        Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS ignoring colocation" : " "));
        boolean reproduce50116 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50116, true);
        if (SQLTest.hasPortfolioV1 && !reproduce50116) {
            counters.add(SQLBB.numOfPRs, (long)portfolioPRs);
            Log.getLogWriter().info("add num of PR for portfoliov1 table: " + portfolioPRs + " as original portfoilio is not dropped to work around #50116");
        }
    }

    protected static void writePortfolioPartitionSGToBB(int whichClause, String sg) {
        if (testServerGroupsInheritence && sg.equals("default")) {
            sg = (String)partitionMap.get((Object)tradeSchemaSG);
        }
        if (whichClause != 0) {
            PartitionClause.writePortfolioPartitionToBB(whichClause);
        } else {
            ArrayList<String> partitionKey = new ArrayList<String>();
            ArrayList custPartition = (ArrayList)partitionMap.get((Object)"customersPartition");
            ArrayList secPartition = (ArrayList)partitionMap.get((Object)"securitiesPartition");
            String custSG = (String)partitionMap.get((Object)"customersSG");
            String secSG = (String)partitionMap.get((Object)"securitiesSG");
            if (custPartition.contains("cid") && custPartition.size() == 1 && sg.equals(custSG)) {
                partitionKey.add("cid");
            } else if (secPartition.contains("sec_id") && secPartition.size() == 1 && sg.equals(secSG)) {
                partitionKey.add("sid");
            } else {
                partitionKey.add("cid");
                partitionKey.add("sid");
            }
            counters.increment(SQLBB.numOfPRs);
            partitionMap.put((Object)"portfolioPartition", partitionKey);
            partitionMap.put((Object)"portfPartitionOn", (Object)"default");
            Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs));
        }
        partitionMap.put((Object)"portfolioSG", (Object)sg);
    }

    protected static void writeSellordersPartitionToBB(int whichClause) {
        ArrayList<String> partitionKey = new ArrayList<String>();
        switch (whichClause) {
            case 0: {
                ArrayList portfolioPartition = (ArrayList)partitionMap.get((Object)"portfolioPartition");
                if (portfolioPartition.contains("cid") && portfolioPartition.contains("sid") && portfolioPartition.size() == 2) {
                    partitionKey.add("cid");
                    partitionKey.add("sid");
                    break;
                }
                if (testMultiTableJoin) {
                    partitionKey.add("cid");
                    break;
                }
                partitionKey.add("oid");
                counters.decrement(SQLBB.numOfPRs);
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.SELLORDERSSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 1: {
                partitionKey.add("cid");
                partitionMap.put((Object)"soPartitionOn", (Object)"range");
                break;
            }
            case 2: {
                partitionKey.add("tid");
                break;
            }
            case 3: {
                partitionKey.add("qty");
                break;
            }
            case 4: {
                partitionKey.add("ask");
                break;
            }
            case 5: {
                partitionKey.add("ask");
                partitionKey.add("status");
                break;
            }
            case 6: {
                partitionKey.add("order_time");
                partitionKey.add("status");
                break;
            }
            case 7: {
                partitionKey.add("sid");
                partitionKey.add("order_time");
                partitionKey.add("ask");
                break;
            }
            case 8: {
                counters.subtract(SQLBB.numOfPRs, 2L);
                break;
            }
            default: {
                throw new TestException("Unknown partitionKey " + whichClause);
            }
        }
        counters.add(SQLBB.numOfPRs, 2L);
        partitionMap.put((Object)"sellordersPartition", partitionKey);
        if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.SELLORDERSSTORENAME") != null) {
            counters.add(SQLBB.numOfPRs, 2L);
            if (hdfsExtnParams.get("TRADE.SELLORDERSEVICTIONCRITERIA") == null && whichClause != 0) {
                counters.subtract(SQLBB.numOfPRs, 1L);
            }
        }
        Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS ignoring colocation" : " "));
    }

    protected static void writeSellordersPartitionSGToBB(int whichClause, String sg) {
        if (testServerGroupsInheritence && sg.equals("default")) {
            sg = (String)partitionMap.get((Object)tradeSchemaSG);
        }
        if (whichClause != 0) {
            PartitionClause.writeSellordersPartitionToBB(whichClause);
        } else {
            ArrayList<String> partitionKey = new ArrayList<String>();
            ArrayList portfolioPartition = (ArrayList)partitionMap.get((Object)"portfolioPartition");
            String portfolioSG = (String)partitionMap.get((Object)"portfolioSG");
            if (portfolioPartition.contains("cid") && portfolioPartition.contains("sid") && portfolioPartition.size() == 2 && sg.equals(portfolioSG)) {
                partitionKey.add("cid");
                partitionKey.add("sid");
            } else if (testMultiTableJoin) {
                partitionKey.add("cid");
            } else {
                partitionKey.add("oid");
                counters.decrement(SQLBB.numOfPRs);
            }
            counters.add(SQLBB.numOfPRs, 2L);
            partitionMap.put((Object)"sellordersPartition", partitionKey);
            partitionMap.put((Object)"soPartitionOn", (Object)"default");
            Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs));
        }
        partitionMap.put((Object)"sellordersSG", (Object)sg);
    }

    protected static void writeBuyordersPartitionToBB(int whichClause) {
        ArrayList<String> partitionKey = new ArrayList<String>();
        switch (whichClause) {
            case 0: {
                ArrayList custPartition = (ArrayList)partitionMap.get((Object)"customersPartition");
                ArrayList secPartition = (ArrayList)partitionMap.get((Object)"securitiesPartition");
                if (custPartition.contains("cid") && custPartition.size() == 1) {
                    partitionKey.add("cid");
                    break;
                }
                if (testMultiTableJoin) {
                    partitionKey.add("cid");
                    break;
                }
                if (secPartition.contains("sec_id") && secPartition.size() == 1) {
                    partitionKey.add("sid");
                    break;
                }
                partitionKey.add("oid");
                counters.decrement(SQLBB.numOfPRs);
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.BUYORDERSSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 1: {
                partitionKey.add("cid");
                break;
            }
            case 2: {
                partitionKey.add("tid");
                break;
            }
            case 3: {
                partitionKey.add("sid");
                break;
            }
            case 4: {
                partitionKey.add("bid");
                break;
            }
            case 5: {
                partitionKey.add("bid");
                partitionKey.add("ordertime");
                break;
            }
            case 6: {
                partitionKey.add("ordertime");
                partitionKey.add("status");
                break;
            }
            case 7: {
                counters.subtract(SQLBB.numOfPRs, 2L);
                break;
            }
            default: {
                throw new TestException("Unknown partitionKey " + whichClause);
            }
        }
        counters.add(SQLBB.numOfPRs, 2L);
        partitionMap.put((Object)"buyordersPartition", partitionKey);
        if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.BUYORDERSSTORENAME") != null) {
            counters.add(SQLBB.numOfPRs, 2L);
            if (hdfsExtnParams.get("TRADE.BUYORDERSEVICTIONCRITERIA") == null && whichClause != 0) {
                counters.subtract(SQLBB.numOfPRs, 1L);
            }
        }
        Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS ignoring colocation" : " "));
    }

    protected static void writeBuyordersPartitionSGToBB(int whichClause, String sg) {
        if (testServerGroupsInheritence && sg.equals("default")) {
            sg = (String)partitionMap.get((Object)tradeSchemaSG);
        }
        if (whichClause != 0) {
            PartitionClause.writeBuyordersPartitionToBB(whichClause);
        } else {
            ArrayList<String> partitionKey = new ArrayList<String>();
            ArrayList custPartition = (ArrayList)partitionMap.get((Object)"customersPartition");
            ArrayList secPartition = (ArrayList)partitionMap.get((Object)"securitiesPartition");
            String custSG = (String)partitionMap.get((Object)"customersSG");
            String secSG = (String)partitionMap.get((Object)"securitiesSG");
            if (custPartition.contains("cid") && custPartition.size() == 1 && sg.equals(custSG)) {
                partitionKey.add("cid");
            } else if (testMultiTableJoin) {
                partitionKey.add("cid");
            } else if (secPartition.contains("sec_id") && secPartition.size() == 1 && sg.equals(secSG)) {
                partitionKey.add("sid");
            } else {
                partitionKey.add("oid");
                counters.decrement(SQLBB.numOfPRs);
            }
            counters.add(SQLBB.numOfPRs, 2L);
            partitionMap.put((Object)"buyordersPartition", partitionKey);
            Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs));
        }
        partitionMap.put((Object)"buyordersSG", (Object)sg);
    }

    protected static void writeTxhistoryPartitionToBB(int whichClause) {
        ArrayList<String> partitionKey = new ArrayList<String>();
        switch (whichClause) {
            case 0: {
                if (!testMultiTableJoin) break;
                partitionKey.add("cid");
                break;
            }
            case 1: {
                partitionKey.add("cid");
                break;
            }
            case 2: {
                partitionKey.add("tid");
                break;
            }
            case 3: {
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            default: {
                throw new TestException("Unknown partitionKey " + whichClause);
            }
        }
        counters.increment(SQLBB.numOfPRs);
        partitionMap.put((Object)"txhistoryPartition", partitionKey);
        if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.TXHISTORYSTORENAME") != null) {
            counters.increment(SQLBB.numOfPRs);
            if (SQLTest.testMultipleUniqueIndex) {
                counters.add(SQLBB.numOfPRs, 4L);
                if (hdfsExtnParams.get("TRADE.TXHISTORYEVICTIONCRITERIA") == null) {
                    if (whichClause == 0 || whichClause == 1) {
                        counters.subtract(SQLBB.numOfPRs, 3L);
                    } else {
                        counters.subtract(SQLBB.numOfPRs, 2L);
                    }
                }
            }
        }
        Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS ignoring colocation" : " "));
    }

    protected static void writeTxhistoryPartitionSGToBB(int whichClause, String sg) {
        PartitionClause.writeTxhistoryPartitionToBB(whichClause);
        if (testServerGroupsInheritence && sg.equals("default")) {
            sg = (String)partitionMap.get((Object)tradeSchemaSG);
        }
        partitionMap.put((Object)"txhistorySG", (Object)sg);
    }

    protected static void writeCompaniesPartitionToBB(int whichClause) {
        ArrayList<String> partitionKey = new ArrayList<String>();
        switch (whichClause) {
            case 0: {
                partitionKey.add("symbol");
                partitionKey.add("exchange");
                counters.decrement(SQLBB.numOfPRs);
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.COMPANIESSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 1: {
                partitionKey.add("_uid");
                break;
            }
            case 2: {
                partitionKey.add("companytype");
                break;
            }
            case 3: {
                partitionKey.add("histprice");
                break;
            }
            case 4: {
                partitionKey.add("companyname");
                break;
            }
            case 5: {
                partitionKey.add("symbol");
                counters.decrement(SQLBB.numOfPRs);
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.COMPANIESSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 6: {
                partitionKey.add("exchange");
                counters.decrement(SQLBB.numOfPRs);
                if (!SQLTest.hasHdfs || hdfsExtnParams.get("TRADE.COMPANIESSTORENAME") == null) break;
                counters.decrement(SQLBB.numOfPRs);
                break;
            }
            case 7: {
                partitionKey.add("histprice");
                break;
            }
            case 8: {
                partitionKey.add("companyinfo");
                break;
            }
            case 9: {
                partitionKey.add("note");
                break;
            }
            case 10: {
                partitionKey.add("asset");
                partitionKey.add("companytype");
                break;
            }
            case 11: {
                partitionKey.add("logo");
                break;
            }
            case 12: {
                partitionKey.add("uuid");
                break;
            }
            case 13: {
                counters.subtract(SQLBB.numOfPRs, 2L);
                break;
            }
            default: {
                throw new TestException("Unknown partitionKey " + whichClause);
            }
        }
        counters.add(SQLBB.numOfPRs, 2L);
        partitionMap.put((Object)"companiesPartition", partitionKey);
        if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.COMPANIESSTORENAME") != null) {
            counters.add(SQLBB.numOfPRs, 2L);
            if (hdfsExtnParams.get("TRADE.COMPANIESEVICTIONCRITERIA") == null && whichClause != 0 && whichClause != 5 && whichClause != 6) {
                counters.subtract(SQLBB.numOfPRs, 1L);
            }
        }
        Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS ignoring colocation" : " "));
    }

    protected static void writeCompaniesPartitionSGToBB(int whichClause, String sg) {
        PartitionClause.writeCompaniesPartitionToBB(whichClause);
        if (testServerGroupsInheritence && sg.equals("default")) {
            sg = (String)partitionMap.get((Object)tradeSchemaSG);
        }
        partitionMap.put((Object)"companiesSG", (Object)sg);
    }

    public static String getPartitionClause(String tableInfo) {
        String soClause;
        String partitionClause = null;
        String[] strArray = tableInfo.split(":");
        String tableName = strArray[0];
        String partition = strArray[1];
        String serverGroup = null;
        if (testServerGroups && strArray.length > 2) {
            serverGroup = PartitionClause.processServerGroup(strArray[2]);
            Log.getLogWriter().info("server group is " + serverGroup);
        }
        if (tableName.equalsIgnoreCase("trade.customers")) {
            int whichClause;
            if (partition.equals("random")) {
                whichClause = withReplicatedTables ? SQLTest.random.nextInt(customersPartitionClause.length) : SQLTest.random.nextInt(customersPartitionClause.length - 1);
                if (isConcUpdateTx && whichClause == 6) {
                    whichClause = 5;
                }
            } else {
                whichClause = partition.equals("replicate") ? customersPartitionClause.length - 1 : Integer.parseInt(partition);
            }
            if (whichClause == customersPartitionClause.length - 1) {
                partitionInfoMap.put((Object)tableName, (Object)"replicate");
            } else {
                partitionInfoMap.put((Object)tableName, (Object)"any");
            }
            partitionClause = PartitionClause.getPartitionSG(customersPartitionClause[whichClause], serverGroup);
            if (!testServerGroups) {
                PartitionClause.writeCustomersPartitionToBB(whichClause);
            } else {
                PartitionClause.writeCustomersPartitionSGToBB(whichClause, serverGroup);
            }
            Log.getLogWriter().info("getPartitionClause customers: whichClause is " + whichClause + " and partition is " + partitionClause);
        } else if (tableName.equalsIgnoreCase("trade.securities")) {
            int whichClause = partition.equals("random") ? (withReplicatedTables ? SQLTest.random.nextInt(securitiesPartitionClause.length) : SQLTest.random.nextInt(securitiesPartitionClause.length - 1)) : (partition.equals("replicate") ? securitiesPartitionClause.length - 1 : Integer.parseInt(partition));
            if (whichClause == securitiesPartitionClause.length - 1) {
                partitionInfoMap.put((Object)tableName, (Object)"replicate");
            } else {
                partitionInfoMap.put((Object)tableName, (Object)"any");
            }
            partitionClause = PartitionClause.getPartitionSG(securitiesPartitionClause[whichClause], serverGroup);
            if (!testServerGroups) {
                PartitionClause.writeSecuritiesPartitionToBB(whichClause);
            } else {
                PartitionClause.writeSecuritiesPartitionSGToBB(whichClause, serverGroup);
            }
            Log.getLogWriter().info("getPartitionClause securities: whichClause is " + whichClause + " and partition is " + partitionClause);
        } else if (tableName.equalsIgnoreCase("trade.portfolio")) {
            String portfClause;
            int whichClause;
            if (partition.equals("random")) {
                whichClause = SQLDAPTest.cidByRange ? 1 : (withReplicatedTables ? SQLTest.random.nextInt(portfolioPartitionClause.length) : SQLTest.random.nextInt(portfolioPartitionClause.length - 1));
                if (isConcUpdateTx && (whichClause == 3 || whichClause == 4)) {
                    whichClause = 2;
                }
            } else {
                whichClause = partition.equals("replicate") ? portfolioPartitionClause.length - 1 : Integer.parseInt(partition);
            }
            if (SQLTest.hasHdfs && whichClause == 0) {
                ++whichClause;
            }
            if (whichClause == portfolioPartitionClause.length - 1) {
                partitionInfoMap.put((Object)tableName, (Object)"replicate");
            } else {
                partitionInfoMap.put((Object)tableName, (Object)"any");
            }
            if (!testServerGroups) {
                PartitionClause.writePortfolioPartitionToBB(whichClause);
            } else {
                PartitionClause.writePortfolioPartitionSGToBB(whichClause, serverGroup);
            }
            if (testServerGroupsInheritence && whichClause == 1 && ((ArrayList)partitionMap.get((Object)"customersPartition")).size() == 1 && ((ArrayList)partitionMap.get((Object)"customersPartition")).contains("cid") && ((String)partitionMap.get((Object)"custPartitionOn")).equals("range") && ((String)partitionMap.get((Object)"portfolioSG")).equals(partitionMap.get((Object)"customersSG"))) {
                portfClause = portfolioPartitionClause[whichClause] + " colocate with (trade.customers)";
                partitionClause = PartitionClause.getPartitionSG(portfClause, serverGroup);
            } else if (testMultiTableJoin) {
                portfClause = null;
                portfClause = ((String)partitionInfoMap.get((Object)"trade.customers")).equalsIgnoreCase("replicate") ? " partition by column (cid) " : " partition by column (cid) colocate with (trade.customers)";
                partitionClause = PartitionClause.getPartitionSG(portfClause, serverGroup);
            } else {
                partitionClause = PartitionClause.getPartitionSG(portfolioPartitionClause[whichClause], serverGroup);
            }
            if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.PORTFOLIOSTORENAME") != null && partitionClause.contains(" colocate ")) {
                counters.decrement(SQLBB.numOfPRs);
                Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS including colocation for PORTFOLIO" : " "));
            }
            Log.getLogWriter().info("getPartitionClause portfolio: whichClause is " + whichClause + " and partition is " + partitionClause);
        } else if (tableName.equalsIgnoreCase("trade.networth")) {
            int whichClause;
            String netClause = null;
            if (partition.equals("random")) {
                whichClause = withReplicatedTables ? SQLTest.random.nextInt(networthPartitionClause.length) : SQLTest.random.nextInt(networthPartitionClause.length - 1);
                boolean hasProcedure = TestConfig.tab().booleanAt(SQLPrms.hasProcedure, false);
                if (hasProcedure && whichClause == 3) {
                    ++whichClause;
                }
                if (isConcUpdateTx && (whichClause == 4 || whichClause == 6)) {
                    whichClause = 5;
                }
            } else {
                whichClause = partition.equals("replicate") ? networthPartitionClause.length - 1 : Integer.parseInt(partition);
            }
            if (SQLTest.hasHdfs && whichClause == 0) {
                ++whichClause;
            }
            if (whichClause == networthPartitionClause.length - 1) {
                partitionInfoMap.put((Object)tableName, (Object)"replicate");
            } else {
                partitionInfoMap.put((Object)tableName, (Object)"any");
            }
            if (!testServerGroups) {
                PartitionClause.writeNetworthPartitionToBB(whichClause);
            } else {
                PartitionClause.writeNetworthPartitionSGToBB(whichClause, serverGroup);
            }
            if (testServerGroupsInheritence && whichClause == 1 && ((ArrayList)partitionMap.get((Object)"customersPartition")).size() == 1 && ((ArrayList)partitionMap.get((Object)"customersPartition")).contains("cid") && ((String)partitionMap.get((Object)"custPartitionOn")).equals("range") && ((String)partitionMap.get((Object)"networthSG")).equals(partitionMap.get((Object)"customersSG"))) {
                netClause = ((String)partitionInfoMap.get((Object)tableName)).equalsIgnoreCase("replicate") ? networthPartitionClause[whichClause] : networthPartitionClause[whichClause] + " colocate with (trade.customers)";
                partitionClause = PartitionClause.getPartitionSG(netClause, serverGroup);
            } else if (testMultiTableJoin) {
                netClause = ((String)partitionInfoMap.get((Object)"trade.customers")).equalsIgnoreCase("replicate") ? " partition by column (cid) " : " partition by column (cid) colocate with (trade.customers)";
                partitionClause = PartitionClause.getPartitionSG(netClause, serverGroup);
            } else {
                partitionClause = PartitionClause.getPartitionSG(networthPartitionClause[whichClause], serverGroup);
            }
            if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.NETWORTHSTORENAME") != null && partitionClause.contains(" colocate")) {
                counters.decrement(SQLBB.numOfPRs);
                Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS including colocation for NETWORTH" : " "));
            }
            Log.getLogWriter().info("getPartitionClause networth: whichClause is " + whichClause + " and partition is " + partitionClause);
        } else if (tableName.equalsIgnoreCase("trade.sellorders")) {
            int whichClause;
            if (partition.equals("random")) {
                whichClause = withReplicatedTables ? SQLTest.random.nextInt(sellordersPartitionClause.length) : SQLTest.random.nextInt(sellordersPartitionClause.length - 1);
                if (isConcUpdateTx && (whichClause == 4 || whichClause == 5 || whichClause == 7)) {
                    whichClause = 6;
                }
            } else {
                whichClause = partition.equals("replicate") ? sellordersPartitionClause.length - 1 : Integer.parseInt(partition);
            }
            if (SQLTest.hasHdfs && whichClause == 0) {
                ++whichClause;
            }
            if (whichClause == sellordersPartitionClause.length - 1) {
                partitionInfoMap.put((Object)tableName, (Object)"replicate");
            } else {
                partitionInfoMap.put((Object)tableName, (Object)"any");
            }
            if (!testServerGroups) {
                PartitionClause.writeSellordersPartitionToBB(whichClause);
            } else {
                PartitionClause.writeSellordersPartitionSGToBB(whichClause, serverGroup);
            }
            if (testServerGroupsInheritence && whichClause == 1 && ((ArrayList)partitionMap.get((Object)"customersPartition")).size() == 1 && ((ArrayList)partitionMap.get((Object)"customersPartition")).contains("cid") && ((String)partitionMap.get((Object)"custPartitionOn")).equals("range") && ((String)partitionMap.get((Object)"sellordersSG")).equals(partitionMap.get((Object)"customersSG"))) {
                soClause = sellordersPartitionClause[whichClause] + " colocate with (trade.customers)";
                partitionClause = PartitionClause.getPartitionSG(soClause, serverGroup);
            } else if (testServerGroupsInheritence && whichClause == 1 && ((ArrayList)partitionMap.get((Object)"portfolioPartition")).size() == 1 && ((ArrayList)partitionMap.get((Object)"portfolioPartition")).contains("cid") && ((String)partitionMap.get((Object)"portfPartitionOn")).equals("range") && ((String)partitionMap.get((Object)"sellordersSG")).equals(partitionMap.get((Object)"portfolioSG"))) {
                soClause = sellordersPartitionClause[whichClause] + " colocate with (trade.portfolio)";
                partitionClause = PartitionClause.getPartitionSG(soClause, serverGroup);
            } else if (testMultiTableJoin) {
                soClause = null;
                soClause = ((String)partitionInfoMap.get((Object)"trade.customers")).equalsIgnoreCase("replicate") ? " partition by column (cid) colocate with (trade.portfolio)" : " partition by column (cid) colocate with (trade.customers)";
                partitionClause = PartitionClause.getPartitionSG(soClause, serverGroup);
            } else {
                partitionClause = PartitionClause.getPartitionSG(sellordersPartitionClause[whichClause], serverGroup);
            }
            sellordersClause = whichClause;
            if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.SELLORDERSSTORENAME") != null && partitionClause.contains(" colocate ")) {
                counters.decrement(SQLBB.numOfPRs);
                Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS including colocation for SELLORDERS" : " "));
            }
            Log.getLogWriter().info("getPartitionClause sellorders: whichClause is " + whichClause + " and partition is " + partitionClause);
        } else if (tableName.equalsIgnoreCase("trade.buyorders")) {
            int whichClause = partition.equals("random") ? (SQLDAPTest.tidByList ? 2 : (withReplicatedTables ? SQLTest.random.nextInt(buyordersPartitionClause.length) : SQLTest.random.nextInt(buyordersPartitionClause.length - 1))) : (partition.equals("replicate") ? buyordersPartitionClause.length - 1 : Integer.parseInt(partition));
            if (SQLTest.hasHdfs && whichClause == 0) {
                ++whichClause;
            }
            if (whichClause == buyordersPartitionClause.length - 1) {
                partitionInfoMap.put((Object)tableName, (Object)"replicate");
            } else {
                partitionInfoMap.put((Object)tableName, (Object)"any");
            }
            if (!testServerGroups) {
                PartitionClause.writeBuyordersPartitionToBB(whichClause);
            } else {
                PartitionClause.writeBuyordersPartitionSGToBB(whichClause, serverGroup);
            }
            if (testMultiTableJoin) {
                String boClause = null;
                boClause = ((String)partitionInfoMap.get((Object)"trade.customers")).equalsIgnoreCase("replicate") ? " partition by column (cid) " : " partition by column (cid) colocate with (trade.customers)";
                partitionClause = PartitionClause.getPartitionSG(boClause, serverGroup);
            } else {
                partitionClause = PartitionClause.getPartitionSG(buyordersPartitionClause[whichClause], serverGroup);
            }
            if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.BUYORDERSSTORENAME") != null && partitionClause.contains(" colocate ")) {
                counters.decrement(SQLBB.numOfPRs);
                Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS including colocation for BUYORDERS" : " "));
            }
            Log.getLogWriter().info("getPartitionClause buyorders: whichClause is " + whichClause + " and partition is " + partitionClause);
        } else if (tableName.equalsIgnoreCase("trade.txhistory")) {
            int whichClause = partition.equals("random") ? (withReplicatedTables ? SQLTest.random.nextInt(txhistoryPartitionClause.length) : SQLTest.random.nextInt(txhistoryPartitionClause.length - 1)) : (partition.equals("replicate") ? txhistoryPartitionClause.length - 1 : Integer.parseInt(partition));
            if (SQLTest.testMultipleUniqueIndex && SQLTest.hasHdfs && whichClause == 0) {
                ++whichClause;
            }
            if (whichClause == txhistoryPartitionClause.length - 1) {
                partitionInfoMap.put((Object)tableName, (Object)"replicate");
            } else {
                partitionInfoMap.put((Object)tableName, (Object)"any");
            }
            if (testMultiTableJoin) {
                String historyClause = null;
                historyClause = ((String)partitionInfoMap.get((Object)"trade.customers")).equalsIgnoreCase("replicate") ? " partition by column (cid) " : " partition by column (cid) colocate with (trade.customers)";
                partitionClause = PartitionClause.getPartitionSG(historyClause, serverGroup);
            } else {
                partitionClause = PartitionClause.getPartitionSG(txhistoryPartitionClause[whichClause], serverGroup);
            }
            if (!testServerGroups) {
                PartitionClause.writeTxhistoryPartitionToBB(whichClause);
            } else {
                PartitionClause.writeTxhistoryPartitionSGToBB(whichClause, serverGroup);
            }
            if (SQLTest.hasHdfs && hdfsExtnParams.get("TRADE.TXHISTORYSTORENAME") != null && partitionClause.contains(" colocate ")) {
                counters.decrement(SQLBB.numOfPRs);
                Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS including colocation for TXHISTORY" : " "));
            }
            Log.getLogWriter().info("getPartitionClause txhistory: whichClause is " + whichClause + " and partition is " + partitionClause);
        } else if (tableName.equalsIgnoreCase("trade.companies")) {
            int whichClause = partition.equals("random") ? (withReplicatedTables ? SQLTest.random.nextInt(companiesPartitionClause.length) : SQLTest.random.nextInt(companiesPartitionClause.length - 1)) : (partition.equals("replicate") ? companiesPartitionClause.length - 1 : Integer.parseInt(partition));
            if (SQLTest.hasHdfs && whichClause == 0) {
                ++whichClause;
            }
            if (whichClause == companiesPartitionClause.length - 1) {
                partitionInfoMap.put((Object)tableName, (Object)"replicate");
            } else {
                partitionInfoMap.put((Object)tableName, (Object)"any");
            }
            partitionClause = PartitionClause.getPartitionSG(companiesPartitionClause[whichClause], serverGroup);
            if (!testServerGroups) {
                PartitionClause.writeCompaniesPartitionToBB(whichClause);
            } else {
                PartitionClause.writeCompaniesPartitionSGToBB(whichClause, serverGroup);
            }
            Log.getLogWriter().info("getPartitionClause companies: whichClause is " + whichClause + " and partition is " + partitionClause);
        } else if (tableName.equalsIgnoreCase("trade.sellordersdup")) {
            int whichClause = sellordersClause;
            if (whichClause == sellordersPartitionClause.length - 1) {
                partitionInfoMap.put((Object)tableName, (Object)"replicate");
            } else {
                partitionInfoMap.put((Object)tableName, (Object)"any");
            }
            if (!testServerGroups) {
                PartitionClause.writeSellordersPartitionToBB(whichClause);
            } else {
                PartitionClause.writeSellordersPartitionSGToBB(whichClause, serverGroup);
            }
            if (testServerGroupsInheritence && whichClause == 1 && ((ArrayList)partitionMap.get((Object)"customersPartition")).size() == 1 && ((ArrayList)partitionMap.get((Object)"customersPartition")).contains("cid") && ((String)partitionMap.get((Object)"custPartitionOn")).equals("range") && ((String)partitionMap.get((Object)"sellordersSG")).equals(partitionMap.get((Object)"customersSG"))) {
                soClause = sellordersPartitionClause[whichClause] + " colocate with (trade.customers)";
                partitionClause = PartitionClause.getPartitionSG(soClause, serverGroup);
            } else if (testServerGroupsInheritence && whichClause == 1 && ((ArrayList)partitionMap.get((Object)"portfolioPartition")).size() == 1 && ((ArrayList)partitionMap.get((Object)"portfolioPartition")).contains("cid") && ((String)partitionMap.get((Object)"portfPartitionOn")).equals("range") && ((String)partitionMap.get((Object)"sellordersSG")).equals(partitionMap.get((Object)"portfolioSG"))) {
                soClause = sellordersPartitionClause[whichClause] + " colocate with (trade.portfolio)";
                partitionClause = PartitionClause.getPartitionSG(soClause, serverGroup);
            } else if (testMultiTableJoin) {
                soClause = " partition by column (cid) colocate with (trade.customers)";
                partitionClause = PartitionClause.getPartitionSG(soClause, serverGroup);
            } else {
                partitionClause = PartitionClause.getPartitionSG(sellordersPartitionClause[whichClause], serverGroup);
            }
            Log.getLogWriter().info("getPartitionClause sellordersdup: whichClause is " + whichClause + " and partition is " + partitionClause);
        } else if (tableName.equalsIgnoreCase("emp.department")) {
            partitionClause = partition.equals("replicate") ? " replicate " : " ";
        } else if (tableName.equalsIgnoreCase("emp.employees")) {
            if (partition.equals("replicate")) {
                partitionClause = " replicate ";
            } else {
                partitionClause = " partition by column (eid) ";
                ArrayList<String> partitionKey = new ArrayList<String>();
                partitionKey.add("eid");
                counters.add(SQLBB.numOfPRs, 1L);
                if (SQLTest.hasHdfs && hdfsExtnParams.get("EMP.EMPLOYEESSTORENAME") != null && partitionClause.contains(" colocate ")) {
                    counters.add(SQLBB.numOfPRs, 1L);
                    Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs) + (SQLTest.hasHdfs ? " after calculating PR for HDFS including colocation for EMPLOYEES" : " "));
                }
                if (!testServerGroups) {
                    partitionMap.put((Object)"empemployeesPartition", partitionKey);
                    Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs));
                } else {
                    String sg = serverGroup;
                    if (testServerGroupsInheritence && sg.equals("default")) {
                        sg = (String)partitionMap.get((Object)tradeSchemaSG);
                    }
                    partitionMap.put((Object)"employeesSG", (Object)sg);
                }
            }
        } else if (tableName.equalsIgnoreCase("trade.customerprofile")) {
            if (partition.equals("replicate")) {
                partitionClause = " replicate ";
            } else {
                partitionClause = " partition by column (cid) ";
                if (testMultiTableJoin) {
                    counters.increment(SQLBB.numOfPRs);
                    Log.getLogWriter().info("customerprofile is partitioned on cid");
                    Log.getLogWriter().info("numOfPRs now is " + counters.read(SQLBB.numOfPRs));
                }
            }
        } else if (tableName.equalsIgnoreCase("trade.trades")) {
            partitionClause = partition.equals("replicate") ? " replicate " : " ";
        } else if (tableName.equalsIgnoreCase("default1.employees")) {
            partitionClause = partition.equals("replicate") ? " replicate " : " ";
        } else {
            throw new TestException("Test issue, wrong table name in getPartitionClause method.");
        }
        if (partitionClause.contains("BUCKETS") && partitionClause.contains("colocate")) {
            String a = partitionClause.substring(0, partitionClause.indexOf("BUCKETS") - 1);
            String b = partitionClause.substring(partitionClause.indexOf("BUCKETS"), partitionClause.indexOf("colocate") - 1);
            if (!partitionClause.contains("SERVER GROUPS")) {
                String c = partitionClause.substring(partitionClause.indexOf("colocate"));
                partitionClause = a + c + " " + b;
            } else {
                String c = partitionClause.substring(partitionClause.indexOf("colocate"), partitionClause.indexOf("SERVER GROUPS") - 1);
                String s = partitionClause.substring(partitionClause.indexOf("SERVER GROUPS"));
                partitionClause = a + c + " " + b + s;
            }
        }
        return partitionClause;
    }

    public static String processServerGroup(String serverGroup) {
        if (serverGroup.equals("random")) {
            ArrayList groups = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"serverGroup_tables");
            String[] group = (String[])groups.get(SQLTest.random.nextInt(groups.size()));
            serverGroup = SQLTest.random.nextBoolean() ? group[SQLTest.random.nextInt(group.length)] : "default";
            Log.getLogWriter().info("random server group is " + serverGroup);
        } else {
            serverGroup = serverGroup.replace('.', ',');
            Log.getLogWriter().info("server group is " + serverGroup);
        }
        return serverGroup;
    }

    public static String getPartitionSG(String partitionClause, String sg) {
        if (sg != null && !sg.equals("default")) {
            return partitionClause + " SERVER GROUPS (" + sg + ") ";
        }
        return partitionClause;
    }
}

