/*
 * Decompiled with CFR 0.152.
 */
package sql;

import hydra.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import sql.SQLHelper;

public class ProcedureTest {
    protected static int maxNumOfTries = 1;

    protected static Connection getDefaultConnection() {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection("jdbc:default:connection");
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return conn;
    }

    public static void selectCustomers(int tid, ResultSet[] rs) throws SQLException {
        Connection conn = ProcedureTest.getDefaultConnection();
        PreparedStatement ps1 = conn.prepareStatement("select * from trade.customers where tid= ?");
        ps1.setInt(1, tid);
        rs[0] = ps1.executeQuery();
        conn.close();
    }

    public static void queryCustomers(int tid, String inputJson, String[] outputJson) throws SQLException {
        PreparedStatement ps3;
        ResultSet rs3;
        Connection conn = ProcedureTest.getDefaultConnection();
        String customerList = ",";
        String buyorderList = ",";
        Log.getLogWriter().info("comparing customer.buyorder_json and buyorder table  where TID:" + tid + " and STATUS:'open' ");
        PreparedStatement ps1 = conn.prepareStatement("select json_evalPath (buyorder_json,'$..buyorder[?(@.status == open)].oid')  as listOfCustomerWithOpenStatus  , cid from trade.customers where tid= " + tid + " and json_evalPath (buyorder_json,'$..buyorder[?(@.status == open)]') is not null ");
        ResultSet rs = ps1.executeQuery();
        while (rs.next()) {
            customerList = "," + rs.getString(1) + ",";
            buyorderList = ",";
            int cid = rs.getInt(2);
            PreparedStatement ps2 = conn.prepareStatement("select oid  as listOfCustomerWithOpenStatus from trade.buyorders where tid= " + tid + " and status = 'open' and cid = " + cid);
            ResultSet rs2 = ps2.executeQuery();
            while (rs2.next()) {
                String currOid = rs2.getString(1);
                if (customerList.contains("," + currOid + ",")) {
                    customerList = customerList.replace("," + currOid + ",", ",");
                    continue;
                }
                buyorderList = buyorderList + currOid + ",";
            }
            if (customerList.equals(buyorderList)) continue;
            throw new SQLException("Data mismatch found between customer.buyorder_json  and buyorder. Oid's missing from customer.buyorder_json:" + buyorderList + " Unexpected Oid's in customer.buyorder_json:" + customerList);
        }
        if (inputJson != null && (rs3 = (ps3 = conn.prepareStatement("select  networth_json  from trade.customers where cast(networth_json as varchar(500)) = '" + inputJson + "'")).executeQuery()).next()) {
            outputJson[0] = rs3.getString(1);
            if (!outputJson[0].equalsIgnoreCase(inputJson)) {
                throw new SQLException("queryCustomers - Inout Parameter Mismatch. Input param is: " + inputJson + " outputParam is " + outputJson[0]);
            }
        }
        conn.close();
    }

    public static void longRunningProcedure(int tid, ResultSet[] rs) throws SQLException {
        Connection conn = ProcedureTest.getDefaultConnection();
        PreparedStatement ps1 = conn.prepareStatement("select * from trade.customers where tid= ?");
        ps1.setInt(1, tid);
        rs[0] = ps1.executeQuery();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        conn.close();
    }

    public static void addInterest(int tid) throws SQLException {
        Connection conn = ProcedureTest.getDefaultConnection();
        PreparedStatement ps1 = conn.prepareStatement("update trade.networth set cash=trade.multiply(cash) where cash>=10000 and cash < 1000000 and tid= ?");
        PreparedStatement ps2 = conn.prepareStatement("update trade.networth set cash=cash*1.02 where cash<10000 and cash >=1000 and tid= ?");
        PreparedStatement ps3 = conn.prepareStatement("update trade.networth set cash=cash*1.03 where cash<1000 and tid= ?");
        if (tid % 11 == 1) {
            ps1.setInt(1, tid);
            ps2.setInt(1, tid);
            ps3.setInt(1, tid);
            ps1.execute();
            ps3.execute();
        } else {
            ps1.setInt(1, tid);
            ps2.setInt(1, tid);
            ps3.setInt(1, tid);
            ps1.execute();
            int num = ps2.executeUpdate();
            ps3.execute();
            System.out.println("ps2 warning is " + ps2.getWarnings() + " ps2 updated " + num + " of rows.");
        }
        conn.close();
    }

    public static void addInterest2() throws SQLException {
        Connection conn = ProcedureTest.getDefaultConnection();
        PreparedStatement ps1 = conn.prepareStatement("update trade.networth set cash=trade.multiply(cash)");
        ps1.execute();
        conn.close();
    }

    public static void testInOutParam(int tid, BigDecimal[] maxCash, int[] inOut, ResultSet[] rs, ResultSet[] rs2) throws SQLException {
        boolean[] success = new boolean[1];
        ProcedureTest.testInOutParam(tid, maxCash, inOut, rs, rs2, success);
        while (!success[0]) {
            ProcedureTest.testInOutParam(tid, maxCash, inOut, rs, rs2, success);
        }
    }

    private static void testInOutParam(int tid, BigDecimal[] maxCash, int[] inOut, ResultSet[] rs, ResultSet[] rs2, boolean[] success) throws SQLException {
        Connection conn = ProcedureTest.getDefaultConnection();
        success[0] = true;
        try {
            PreparedStatement ps1 = conn.prepareStatement("select * from trade.networth where tid= ? order by cash desc");
            ps1.setInt(1, tid);
            rs[0] = ps1.executeQuery();
            PreparedStatement ps2 = conn.prepareStatement("select * from trade.portfolio where tid= ?");
            ps2.setInt(1, tid);
            rs2[0] = ps2.executeQuery();
            PreparedStatement ps3 = conn.prepareStatement("select max(cash + securities-(loanlimit-availloan))  as net from trade.networth where tid = ?");
            ps3.setInt(1, tid);
            ResultSet rs3 = ps3.executeQuery();
            if (rs3.next()) {
                maxCash[0] = rs3.getBigDecimal("NET");
            }
            inOut[0] = inOut[0] + 1;
            System.out.println("inOut is " + inOut[0]);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01")) {
                System.out.println("remote node is down during the query, need to retry");
                success[0] = false;
            }
            throw se;
        }
    }
}

