/*
 * Decompiled with CFR 0.152.
 */
package sql;

import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import hdfs.HDFSUtilBB;
import hydra.Log;
import hydra.TestConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.derby.tools.ij;
import sql.ClientDiscDBManager;
import sql.DBType;
import sql.DiscDBManager;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlTx.SQLTxPrms;
import util.StopStartPrms;
import util.TestException;
import util.TestHelper;

public class SQLHelper {
    static boolean isHATest = TestConfig.tab().longAt(StopStartPrms.numVMsToStop, 0L) > 0L ? true : TestConfig.tab().booleanAt(SQLPrms.rebalanceBuckets, false);
    protected static boolean useWriterForWriteThrough = TestConfig.tab().booleanAt(SQLPrms.useWriterForWriteThrough, false);
    public static String lockIssueSQLState = "LOCKISSUE";
    static boolean isOfflineTest = TestConfig.tab().booleanAt(SQLPrms.isOfflineTest, false);
    static boolean setCriticalHeap = SQLTest.setCriticalHeap;
    static boolean batchingWithSecondaryData = !TestConfig.tab().booleanAt(SQLTxPrms.nobatching, true);
    public static boolean supportHAInTxn = false;

    public static void printSQLException(SQLException e) {
        while (e != null) {
            Log.getLogWriter().info("SQLException: State: " + e.getSQLState());
            Log.getLogWriter().info("severity: " + e.getErrorCode());
            Log.getLogWriter().info(e.getMessage());
            e = e.getNextException();
        }
    }

    public static void printSQLWarning(SQLWarning w) {
        while (w != null) {
            Log.getLogWriter().info("SQLWarning: State: " + w.getSQLState());
            Log.getLogWriter().info("errorCode: " + w.getErrorCode());
            Log.getLogWriter().info(w.getMessage());
            w = w.getNextWarning();
        }
    }

    public static boolean isSameRootSQLException(String derbySQLState, SQLException gfxdSe) {
        while (gfxdSe != null) {
            if (gfxdSe.getSQLState().equalsIgnoreCase(derbySQLState) || gfxdSe.getMessage().contains(derbySQLState)) {
                return true;
            }
            gfxdSe = gfxdSe.getNextException();
        }
        return false;
    }

    public static void handleSQLException(SQLException se) {
        SQLHelper.printSQLException(se);
        Throwable cause = TestHelper.findCause((Throwable)se, HDFSIOException.class);
        if (!useWriterForWriteThrough || !se.getSQLState().equals(lockIssueSQLState)) {
            if (setCriticalHeap && se.getSQLState().equals("XCL54")) {
                Log.getLogWriter().warning("memory runs low and get query cancellation exception");
                boolean[] getCanceled = (boolean[])SQLTest.getCanceled.get();
                if (getCanceled == null) {
                    getCanceled = new boolean[]{true};
                }
                SQLTest.getCanceled.set((Object)getCanceled);
                return;
            }
            if (!SQLTest.hasTx && SQLTest.setTx && !SQLTest.testUniqueKeys && se.getSQLState().equals("X0Z02")) {
                Log.getLogWriter().warning("Got expected conflict exception X0Z02 for non unique keys testings for original tests");
                return;
            }
            if (!SQLTest.hasTx && SQLTest.setTx && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                if (!SQLTest.hasDerbyServer) {
                    Log.getLogWriter().warning("Got expected node failure exception for non unique keys testings for original tests");
                    boolean[] getNodeFailure = (boolean[])SQLTest.getNodeFailure.get();
                    if (getNodeFailure == null) {
                        getNodeFailure = new boolean[]{true};
                    }
                    SQLTest.getNodeFailure.set((Object)getNodeFailure);
                } else {
                    Log.getLogWriter().warning("Got expected node failure exception when testings for original tests");
                    boolean[] getNodeFailure = (boolean[])SQLTest.getNodeFailure.get();
                    if (getNodeFailure == null) {
                        getNodeFailure = new boolean[]{true};
                    }
                    SQLTest.getNodeFailure.set((Object)getNodeFailure);
                }
                return;
            }
            if (se.getSQLState().equals("X0Z30") && cause != null && HDFSUtilBB.getBB().getSharedCounters().read(HDFSUtilBB.recycleInProgress) > 0L) {
                Log.getLogWriter().info("handleSQLException caught SQLException(X0Z30) Caused by: HDFSIOException.  Expected, continuing test");
                throw new TestException("Execute SQL statement failed with: " + se.getSQLState(), (Throwable)se);
            }
            throw new TestException("Execute SQL statement failed with: " + se.getSQLState() + " " + TestHelper.getStackTrace((Throwable)se));
        }
        Log.getLogWriter().info("Writer got lock timeout trying write to back_end DB, abort this operation");
    }

    public static void handleDerbySQLException(SQLException se, List<SQLException> exceptionList) {
        SQLHelper.printSQLException(se);
        exceptionList.add(se);
    }

    public static void handleSQLException(DBType dbType, SQLException se, List<SQLException> exceptionList) {
        switch (dbType) {
            case DERBY: {
                SQLHelper.handleDerbySQLException(se, exceptionList);
                break;
            }
            case GFXD: {
                SQLHelper.handleGFGFXDException(se, exceptionList);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void handleGFGFXDException(SQLException se, List<SQLException> exceptionList) {
        Throwable cause;
        SQLException seCause = null;
        if (isOfflineTest && (se.getSQLState().equals("X0Z09") || se.getSQLState().equals("X0Z08") || se.getSQLState().equals("23503") && (cause = se.getCause()) != null && cause instanceof SQLException && ((seCause = (SQLException)cause).getSQLState().equals("X0Z09") || seCause.getSQLState().equals("X0Z08")))) {
            SQLHelper.printSQLException(se);
            if (seCause == null) throw new TestException("got unexpected exception: " + se.getSQLState());
            throw new TestException("got expected exception: " + se.getSQLState() + ':' + seCause.getSQLState());
        }
        if (setCriticalHeap && se.getSQLState().equals("XCL54")) {
            Log.getLogWriter().warning("memory runs low and get query cancellation exception");
            boolean[] getCanceled = (boolean[])SQLTest.getCanceled.get();
            getCanceled[0] = true;
            SQLTest.getCanceled.set((Object)getCanceled);
            return;
        }
        if (SQLTest.setTx) {
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                Log.getLogWriter().warning("possibly got node failure exception or bucket moved exception");
                boolean[] getNodeFailure = (boolean[])SQLTest.getNodeFailure.get();
                if (getNodeFailure == null) {
                    getNodeFailure = new boolean[]{true};
                }
                SQLTest.getNodeFailure.set((Object)getNodeFailure);
                return;
            }
            if (SQLTest.testEviction && se.getSQLState().equals("X0Z02") && SQLTest.workaround51582) {
                Log.getLogWriter().info("possibly got #51582");
                boolean[] getEvictionConflict = (boolean[])SQLTest.getEvictionConflict.get();
                if (getEvictionConflict == null) {
                    getEvictionConflict = new boolean[]{true};
                }
                SQLTest.getEvictionConflict.set((Object)getEvictionConflict);
                return;
            }
        }
        if (exceptionList.size() == 0) {
            SQLHelper.handleSQLException(se);
        }
        SQLHelper.printSQLException(se);
        int firstIndex = 0;
        SQLException derbySe = exceptionList.get(firstIndex);
        if (derbySe.getSQLState().equalsIgnoreCase(se.getSQLState())) {
            if (derbySe.getSQLState().equals("38000")) {
                if (!derbySe.getNextException().getSQLState().equals(se.getNextException().getSQLState())) throw new TestException("Not the expected SQLException, might be a miss or an extra exception encountered: \nthe expected deby SQLException: State: " + derbySe.getSQLState() + "\nseverity: " + derbySe.getErrorCode() + "\nmessage: " + derbySe.getMessage() + "\ngemfirexd SQLException: State: " + se.getSQLState() + "\nseverity: " + se.getErrorCode() + "\nmessage: " + se.getMessage() + TestHelper.getStackTrace((Throwable)se));
                exceptionList.remove(firstIndex);
                return;
            } else {
                exceptionList.remove(firstIndex);
            }
            return;
        } else {
            if (!derbySe.getSQLState().equals("38000") && !derbySe.getSQLState().equals("XJ208")) throw new TestException("Not the expected SQLException, might be a miss or an extra exception encountered: \nthe expected deby SQLException: State: " + derbySe.getSQLState() + "\nseverity: " + derbySe.getErrorCode() + "\nmessage: " + derbySe.getMessage() + "\n" + TestHelper.getStackTrace((Throwable)derbySe) + "\ngemfirexd SQLException: State: " + se.getSQLState() + "\nseverity: " + se.getErrorCode() + "\nmessage: " + se.getMessage() + TestHelper.getStackTrace((Throwable)se));
            if ((derbySe = derbySe.getNextException()) == null) return;
            if (!derbySe.getSQLState().equalsIgnoreCase(se.getSQLState())) throw new TestException("Not the expected SQLException, might be a miss or an extra exception encountered: \nthe expected deby SQLException: State: " + derbySe.getSQLState() + "\nseverity: " + derbySe.getErrorCode() + "\nmessage: " + derbySe.getMessage() + "\ngemfirexd SQLException: State: " + se.getSQLState() + "\nseverity: " + se.getErrorCode() + "\nmessage: " + se.getMessage() + TestHelper.getStackTrace((Throwable)se));
            exceptionList.remove(firstIndex);
        }
    }

    public static void handleGFETxSQLException(SQLException se, List<SQLException> exceptionList) {
        SQLHelper.printSQLException(se);
        exceptionList.add(se);
    }

    public static void handleDerbyTxSQLException(SQLException se, List<SQLException> exceptionList) {
        SQLHelper.printSQLException(se);
        exceptionList.add(se);
    }

    public static void handleMissedSQLException(List<SQLException> exceptionList) {
        boolean[] getEvictionConflict;
        boolean[] getNodeFailure;
        if (setCriticalHeap) {
            boolean[] getCanceled = (boolean[])SQLTest.getCanceled.get();
            if (getCanceled == null) {
                SQLTest.getCanceled.set((Object)new boolean[1]);
            } else if (getCanceled[0]) {
                Log.getLogWriter().info("memory runs low -- avoiding the comparison of expected exceptions");
                return;
            }
        }
        if (SQLTest.setTx && isHATest && (getNodeFailure = (boolean[])SQLTest.getNodeFailure.get()) != null && getNodeFailure[0]) {
            Log.getLogWriter().info("getNodeFailure -- avoiding the comparison of expected exceptions");
            return;
        }
        if (SQLTest.setTx && SQLTest.testEviction && SQLTest.workaround51582 && (getEvictionConflict = (boolean[])SQLTest.getEvictionConflict.get()) != null && getEvictionConflict[0]) {
            Log.getLogWriter().info("get conflict excpetion with eviction -- avoiding the comparison of expected exceptions");
            return;
        }
        if (exceptionList.size() > 0) {
            int firstIndex = 0;
            SQLException derbySe = exceptionList.get(firstIndex);
            Log.getLogWriter().info("Here are additional derby exceptions that are missed by GFE");
            for (int i = 0; i < exceptionList.size(); ++i) {
                SQLHelper.printSQLException(exceptionList.get(i));
            }
            throw new TestException("GemFireXD missed the expected SQL exceptions thrown by derby: the expected deby SQLException: State: " + derbySe.getSQLState() + "\nseverity: " + derbySe.getErrorCode() + "\nmessage: " + derbySe.getMessage() + TestHelper.getStackTrace((Throwable)exceptionList.get(0)));
        }
    }

    public static void handleMissedSQLException(SQLException se) {
        Log.getLogWriter().info("Here is the exception that is missed");
        SQLHelper.printSQLException(se);
        throw new TestException("The missed SQL exception is: State: " + se.getSQLState() + "\nseverity: " + se.getErrorCode() + "\nmessage: " + se.getMessage() + TestHelper.getStackTrace((Throwable)se));
    }

    private static String getStack(Throwable te) {
        if (te != null) {
            return TestHelper.getStackTrace((Throwable)te);
        }
        return "";
    }

    public static boolean checkDerbyException(Connection conn, SQLException se) {
        SQLHelper.printSQLException(se);
        if (!SQLHelper.isDerbyConn(conn, se)) {
            Log.getLogWriter().info("Not derby connection, do not retry");
            return true;
        }
        if (se.getSQLState().equals("40001") || se.getSQLState().equals("38000") && (se.getMessage().contains("lock could not be obtained ") || se.getNextException().getSQLState().equals("40001")) || se.getSQLState().equals("XJ208") && (se.getMessage().contains("lock could not be obtained ") || se.getNextException().getSQLState().equals("40001"))) {
            Log.getLogWriter().info("detected the deadlock, may try it again");
            return false;
        }
        if (se.getSQLState().equals("40XL1") || se.getSQLState().equals("XJ208") && se.getNextException().getSQLState().equals("40XL1") || se.getSQLState().equals("38000") && se.getNextException().getSQLState().equals("40XL1")) {
            Log.getLogWriter().info("detected could not obtain lock, may try it again");
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                SQLHelper.handleSQLException(e);
            }
            return false;
        }
        if (se.getSQLState().equals("08006")) {
            Log.getLogWriter().info("detected Read timed out, need to get a new connection");
            SQLTest.resetDerbyConnection.set((Object)true);
            return false;
        }
        if (se.getSQLState().equals("08003")) {
            Log.getLogWriter().info("detected current connection is lost, possibly due to reade time out,  need to abort this op and acquire a new connection");
            SQLTest.resetDerbyConnection.set((Object)true);
            return false;
        }
        return true;
    }

    public static boolean checkGFXDException(Connection conn, SQLException se) {
        if (SQLHelper.isDerbyConn(conn, se)) {
            return SQLHelper.checkGFXDException(true, se);
        }
        return SQLHelper.checkGFXDException(false, se);
    }

    public static boolean checkGFXDException(boolean isDerbyConn, SQLException se) {
        if (isDerbyConn) {
            Log.getLogWriter().info("Not GFXD connection and not X0Z01, do not retry");
            return true;
        }
        if (se.getSQLState().equals("X0Z01") && isHATest) {
            Log.getLogWriter().warning("GFXD_NODE_SHUTDOWN happened and need to retry the query");
            return false;
        }
        if (isOfflineTest && (se.getSQLState().equals("X0Z09") || se.getSQLState().equals("X0Z08"))) {
            Log.getLogWriter().warning("Got expected Offline exception, continuing test");
            return false;
        }
        if (setCriticalHeap && se.getSQLState().equals("XCL54")) {
            Log.getLogWriter().warning("memory runs low and get query cancellation exception");
            boolean[] getCanceled = (boolean[])SQLTest.getCanceled.get();
            getCanceled[0] = true;
            SQLTest.getCanceled.set((Object)getCanceled);
            return false;
        }
        return true;
    }

    public static boolean isAlterTableException(Connection conn, SQLException se) {
        if ((se.getSQLState().equals("42X04") || se.getSQLState().equals("42X14") || se.getSQLState().equals("42802")) && SQLTest.alterTableDropColumn) {
            Log.getLogWriter().info("got expected missing column issue in alter table");
            return true;
        }
        return false;
    }

    public static boolean isDerbyConn(Connection conn) {
        if (conn == null) {
            throw new TestException("Test issue, connection not set");
        }
        String url = null;
        try {
            url = conn.getMetaData().getURL();
        }
        catch (SQLException se) {
            if (conn.getClass().getName().startsWith("org.apache.derby")) {
                return true;
            }
            if (conn.getClass().getName().startsWith("com.pivotal.gemfirexd")) {
                return false;
            }
            throw new TestException("Not able to get url" + TestHelper.getStackTrace((Throwable)se));
        }
        return url.contains(DiscDBManager.getUrl()) || url.contains(ClientDiscDBManager.getUrl());
    }

    public static boolean isDerbyConn(Connection conn, SQLException origEx) {
        String url = null;
        try {
            url = conn.getMetaData().getURL();
        }
        catch (SQLException se) {
            if (conn.getClass().getName().startsWith("org.apache.derby")) {
                return true;
            }
            if (conn.getClass().getName().startsWith("com.pivotal.gemfirexd")) {
                return false;
            }
            throw new TestException("Not able to get url " + TestHelper.getStackTrace((Throwable)se), (Throwable)origEx);
        }
        return url.contains(DiscDBManager.getUrl()) || url.contains(ClientDiscDBManager.getUrl());
    }

    public static void removeSameExceptions(List<SQLException> se1, List<SQLException> se2) {
        ArrayList<SQLException> se2Copies = new ArrayList<SQLException>(se2);
        Iterator<SQLException> se1Iter = se1.iterator();
        block0: while (se1Iter.hasNext()) {
            SQLException se = se1Iter.next();
            Iterator<SQLException> se2Iter = se2Copies.iterator();
            while (se2Iter.hasNext()) {
                SQLException se2Copy = se2Iter.next();
                if (!se.getSQLState().equalsIgnoreCase(se2Copy.getSQLState())) continue;
                se1Iter.remove();
                se2Iter.remove();
                continue block0;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void compareExceptions(SQLException dse, SQLException sse) {
        if (dse == null && sse == null) {
            return;
        }
        if (dse != null && sse != null) {
            if (!dse.getSQLState().equalsIgnoreCase(sse.getSQLState())) {
                Log.getLogWriter().warning("compare exceptions failed");
                Log.getLogWriter().info("derby excetpion:");
                SQLHelper.printSQLException(dse);
                Log.getLogWriter().info("gfxd excetpion:");
                SQLHelper.printSQLException(sse);
                throw new TestException("Exceptions are not same -- for derby: " + TestHelper.getStackTrace((Throwable)dse) + "\n for gfxd: " + TestHelper.getStackTrace((Throwable)sse));
            }
            Log.getLogWriter().info("got the same exceptions from derby and gfxd");
            return;
        }
        if (dse == null) {
            Log.getLogWriter().warning("compare exceptions failed");
            SQLHelper.printSQLException(sse);
            throw new TestException("gfxd got the exception, but derby did not\n" + TestHelper.getStackTrace((Throwable)sse));
        }
        SQLHelper.printSQLException(dse);
        if (batchingWithSecondaryData) {
            Log.getLogWriter().warning("derby got the exception but gfxd did not, will check if commit failed when batching is enabled");
            ArrayList exs = (ArrayList)SQLDistTxTest.derbyExceptionsWithBatching.get();
            exs.add(dse);
            SQLDistTxTest.derbyExceptionsWithBatching.set((Object)exs);
            return;
        }
        Log.getLogWriter().warning("compare exceptions failed");
        throw new TestException("derby got the exception, but gfxd did not\n" + TestHelper.getStackTrace((Throwable)dse));
    }

    public static void compareExceptionLists(List<SQLException> dEx, List<SQLException> sEx) {
        if (sEx.size() != dEx.size()) {
            throw new TestException("gfxd and derby does not perform same operations");
        }
        for (int i = 0; i < sEx.size(); ++i) {
            if (sEx.get(i) != null && sEx.get(i).getSQLState().equals("23513") && dEx.get(i) == null) {
                Log.getLogWriter().info("Got additional check straint violation, which is expected as delete could occur earlier for derby and derby will miss the check violation");
                continue;
            }
            SQLHelper.compareExceptions(dEx.get(i), sEx.get(i));
        }
    }

    public static void executeSQL(Connection conn, String sqlCommand, boolean doLog) throws SQLException {
        Statement stmt = conn.createStatement();
        if (doLog) {
            Log.getLogWriter().info("sql command: " + sqlCommand);
        }
        stmt.executeUpdate(sqlCommand);
        if (doLog) {
            Log.getLogWriter().info("completed sql command: " + sqlCommand);
        }
    }

    public static int runSQLScript(Connection conn, String sqlFilePath, boolean failOnError) {
        return SQLHelper.runSQLScript(conn, sqlFilePath, 180, failOnError, true);
    }

    public static int runSQLScript(Connection conn, String sqlFilePath, int maxSecs, boolean failOnError, boolean logOutput) {
        InputStream sqlScriptStream = ClassLoader.getSystemResourceAsStream(sqlFilePath);
        if (sqlScriptStream == null) {
            throw new TestException("Could not find " + sqlFilePath + " under classpath " + System.getProperty("java.class.path"));
        }
        ByteArrayOutputStream sqlOutStream = new ByteArrayOutputStream(20480);
        int returnStatus = 0;
        try {
            Log.getLogWriter().info("about to run " + sqlFilePath + " on connection " + conn.toString());
            returnStatus = com.pivotal.gemfirexd.internal.tools.ij.runScript((Connection)conn, (InputStream)sqlScriptStream, (String)"US-ASCII", (OutputStream)sqlOutStream, (String)"US-ASCII");
            Log.getLogWriter().info("done running " + sqlFilePath + " with returnStatus=" + returnStatus);
            if (!conn.isClosed() && !conn.getAutoCommit()) {
                conn.commit();
            }
            sqlScriptStream.close();
        }
        catch (UnsupportedEncodingException uee) {
            throw new TestException("Test Exception:", (Throwable)uee);
        }
        catch (IOException ioe) {
            throw new TestException("Test Exception:", (Throwable)ioe);
        }
        catch (SQLException sqle) {
            throw new TestException("SQL Exception in " + sqlFilePath + ":" + sqlOutStream.toString(), (Throwable)sqle);
        }
        if (logOutput || returnStatus != 0) {
            Log.getLogWriter().info("sql output: " + sqlOutStream.toString());
        }
        if (returnStatus != 0 && failOnError) {
            throw new TestException("SQL Exception on " + sqlFilePath + " " + sqlOutStream.toString());
        }
        return returnStatus;
    }

    public static int runSameSQLScript(Connection conn, InputStream sqlScriptStream, boolean failOnError, boolean logOutput) {
        return SQLHelper.runSameSQLScript(conn, sqlScriptStream, 180, failOnError, logOutput);
    }

    public static int runSameSQLScript(Connection conn, InputStream sqlScriptStream, int maxSecs, boolean failOnError, boolean logOutput) {
        ByteArrayOutputStream sqlOutStream = new ByteArrayOutputStream(20480);
        int returnStatus = 0;
        try {
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().info("about to run script on connection " + conn.toString());
            }
            returnStatus = com.pivotal.gemfirexd.internal.tools.ij.runScript((Connection)conn, (InputStream)sqlScriptStream, (String)"US-ASCII", (OutputStream)sqlOutStream, (String)"US-ASCII");
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().info("done running script with returnStatus=" + returnStatus);
            }
            if (!conn.isClosed() && !conn.getAutoCommit()) {
                conn.commit();
            }
            sqlScriptStream.close();
        }
        catch (UnsupportedEncodingException uee) {
            throw new TestException("Test Exception:", (Throwable)uee);
        }
        catch (IOException ioe) {
            throw new TestException("Test Exception:", (Throwable)ioe);
        }
        catch (SQLException sqle) {
            throw new TestException("SQL Exception in running script" + sqlOutStream.toString(), (Throwable)sqle);
        }
        if (logOutput || returnStatus != 0) {
            Log.getLogWriter().info("sql output: " + sqlOutStream.toString());
        }
        if (returnStatus != 0 && failOnError) {
            throw new TestException("SQL Exception on running script " + sqlOutStream.toString());
        }
        return returnStatus;
    }

    public static int runDerbySQLScript(Connection conn, String sqlFilePath, boolean failOnError) {
        return SQLHelper.runDerbySQLScript(conn, sqlFilePath, 180, failOnError, true);
    }

    public static int runDerbySQLScript(Connection conn, String sqlFilePath, int maxSecs, boolean failOnError, boolean logOutput) {
        InputStream sqlScriptStream = ClassLoader.getSystemResourceAsStream(sqlFilePath);
        if (sqlScriptStream == null) {
            throw new TestException("Could not find " + sqlFilePath + " under classpath " + System.getProperty("java.class.path"));
        }
        ByteArrayOutputStream sqlOutStream = new ByteArrayOutputStream(20480);
        int returnStatus = 0;
        try {
            Log.getLogWriter().info("about to run " + sqlFilePath + " on connection " + conn.toString());
            returnStatus = ij.runScript((Connection)conn, (InputStream)sqlScriptStream, (String)"US-ASCII", (OutputStream)sqlOutStream, (String)"US-ASCII");
            Log.getLogWriter().info("done running " + sqlFilePath + " with returnStatus=" + returnStatus);
            if (!conn.isClosed() && !conn.getAutoCommit()) {
                conn.commit();
            }
            sqlScriptStream.close();
        }
        catch (UnsupportedEncodingException uee) {
            throw new TestException("Test Exception:", (Throwable)uee);
        }
        catch (IOException ioe) {
            throw new TestException("Test Exception:", (Throwable)ioe);
        }
        catch (SQLException sqle) {
            throw new TestException("SQL Exception in " + sqlFilePath + ":" + sqlOutStream.toString(), (Throwable)sqle);
        }
        if (logOutput || returnStatus != 0) {
            Log.getLogWriter().info("sql output: " + sqlOutStream.toString());
        }
        if (returnStatus != 0 && failOnError) {
            throw new TestException("SQL Exception on " + sqlFilePath + " " + sqlOutStream.toString());
        }
        return returnStatus;
    }

    public static void compareTxSQLException(SQLException gfxdse, SQLException derbyse) {
        if (gfxdse != null) {
            Log.getLogWriter().info("gfxd exception");
            SQLHelper.printSQLException(gfxdse);
        }
        if (derbyse != null) {
            Log.getLogWriter().info("derby exception");
            SQLHelper.printSQLException(derbyse);
        }
        if (gfxdse != null && derbyse != null && derbyse.getSQLState().equals("40XL1") && gfxdse.getSQLState().equals("X0Z02")) {
            Log.getLogWriter().info("derby and gfxd both get lock not held exception");
        } else {
            SQLHelper.compareExceptions(derbyse, gfxdse);
        }
    }

    public static boolean isThinClient(Connection gConn) {
        try {
            String driverName = gConn.getMetaData().getDriverName();
            if (driverName.contains("Client JDBC Driver")) {
                return true;
            }
            if (driverName.contains("Embedded JDBC Driver")) {
                return false;
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        throw new TestException("not able to get correct driver name");
    }

    public static boolean gotTXNodeFailureException(SQLException se) {
        boolean isTicket48176Fixed = true;
        if (se.getSQLState().equalsIgnoreCase("X0Z05") || se.getSQLState().equalsIgnoreCase("X0Z16") || se.getSQLState().equalsIgnoreCase("40XD2") || se.getSQLState().equalsIgnoreCase("40XD0") || se.getSQLState().equalsIgnoreCase("X0Z01") && !isTicket48176Fixed) {
            if (SQLTest.hasTx) {
                SQLDistTxTest.needNewConnAfterNodeFailure.set((Object)true);
                Log.getLogWriter().info("needNewConnAfterNodeFailure is set to true");
            }
            return true;
        }
        return false;
    }

    public static boolean gotTXNodeFailureTestException(TestException te) {
        boolean isTicket48176Fixed = true;
        if (te.getMessage().contains("X0Z05") || te.getMessage().contains("X0Z16") || te.getMessage().contains("40XD2") || te.getMessage().contains("40XD0") || te.getMessage().contains("X0Z01") && !isTicket48176Fixed) {
            if (SQLTest.hasTx) {
                SQLDistTxTest.needNewConnAfterNodeFailure.set((Object)true);
                Log.getLogWriter().info("needNewConnAfterNodeFailure is set to true");
            }
            return true;
        }
        return false;
    }

    public static void closeResultSet(ResultSet rs, Connection conn) {
        boolean rsclosed = true;
        if (AbstractDMLStmt.isSingleHop && rs != null) {
            try {
                rs.close();
            }
            catch (SQLException se) {
                if (SQLHelper.isDerbyConn(conn) && !SQLHelper.checkDerbyException(conn, se)) {
                    rsclosed = false;
                }
                if (!SQLHelper.isDerbyConn(conn) && !SQLHelper.checkGFXDException(conn, se)) {
                    rsclosed = false;
                }
                if (!SQLHelper.isDerbyConn(conn) && AbstractDMLStmt.gfxdtxHANotReady && isHATest && SQLTest.hasTx && SQLHelper.gotTXNodeFailureException(se)) {
                    rsclosed = false;
                }
                Log.getLogWriter().info("close resultset failed with: ");
                SQLHelper.printSQLException(se);
            }
        }
        if (!rsclosed) {
            Log.getLogWriter().info("Could not close resultset");
        }
    }
}

