/*
 * Decompiled with CFR 0.152.
 */
package sql;

import hydra.BasePrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sql.SQLBB;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.sqlutil.DDLStmtsFactory;
import sql.sqlutil.DMLStmtsFactory;
import sql.sqlutil.GFXDTxHelper;
import sql.sqlutil.JoinTableStmtsFactory;
import util.TestException;

public class SQLPrms
extends BasePrms {
    public static final String HDFS_EXTN_PARAMS = "hdfsExtnParams";
    public static final String HDFS_TRIGGER = "hdfsTriggers";
    public static final String HDFS_TRIGGER_STMT = "hdfsTriggersPrepStmt";
    public static final String CREATE_ONLY_TRIGGERS = "CreateOnlyTriggers";
    public static final String MAP_REDUCE_CLASSES = "mapReduceClasses";
    public static Long driver;
    public static Long clientDriver;
    public static Long populateWithbatch;
    public static Long dmlTables;
    public static Long verifyByTid;
    public static Long joinTables;
    public static Long initialRowCount;
    public static Long createTablesStatements;
    public static Long gfeDDLExtension;
    public static Long createDiskStore;
    public static Long gfePersistExtension;
    public static Long loaderDDLExtension;
    public static Long createSchemas;
    public static Long hdfsDDLExtn;
    public static Long testUniqueKeys;
    public static Long randomData;
    public static Long hasNetworth;
    public static Long isSingleDMLThread;
    public static Long usingTrigger;
    public static Long queryAnyTime;
    public static Long dmlOperations;
    public static Long cycleVMTarget;
    public static Long rebalanceBuckets;
    public static Long waitTimeBeforeNextCycleVM;
    public static Long killInterval;
    public static Long createIndex;
    public static Long dropIndex;
    public static Long verifyIndex;
    public static Long renameIndex;
    public static Long initCustomersSizePerThread;
    public static Long initSecuritiesSizePerThread;
    public static Long testPartitionBy;
    public static Long serverGroups;
    public static Long storeHosts;
    public static Long testServerGroups;
    public static Long withReplicatedTables;
    public static Long testServerGroupsInheritence;
    public static Long schemaDefaultServerGroup;
    public static Long testUniqIndex;
    public static Long ddlOperations;
    public static Long redundancyClause;
    public static Long populateTableUsingFunction;
    public static Long populateThruLoader;
    public static Long testSecurity;
    public static Long totalAccessorThreads;
    public static Long totalStoreThreads;
    public static Long useDefaultValue;
    public static Long testInitDDLReplay;
    public static Long multiThreadsCreateTables;
    public static Long enableQueueConflation;
    public static Long enableQueuePersistence;
    public static Long hasProcedure;
    public static Long hasAsyncDBSync;
    public static Long hasAsyncEventListener;
    public static Long hasHDFS;
    public static Long hasJSON;
    public static Long hdfsMrJob;
    public static Long supportDuplicateTables;
    public static Long updateWriteOnlyMr;
    public static Long ticket49794fixed;
    public static Long hasTx;
    public static Long setTx;
    public static Long byCidRange;
    public static Long byTidList;
    public static Long singleRowTx;
    public static Long numOfStores;
    public static Long numOfWorkers;
    public static Long totalCids;
    public static Long useBUILTINSchema;
    public static Long useLDAPSchema;
    public static Long oneOpPerTx;
    public static Long maxSymbolLength;
    public static Long minSymbolLength;
    public static Long testLoaderCreateRandomRow;
    public static Long useWriterForWriteThrough;
    public static Long backendDB_url;
    public static Long testMultiTableJoin;
    public static Long useGemFireXDHA;
    public static Long useGfxdConfig;
    public static Long independentSubqueryOnly;
    public static Long hasMultiSystemUsers;
    public static Long hasRoutineInSecurityTest;
    public static Long usePublicAsGrantees;
    public static Long isOfflineTest;
    public static Long testEviction;
    public static Long useHeapPercentage;
    public static Long initEvictionHeapPercent;
    public static Long isConcUpdateTx;
    public static Long setCriticalHeap;
    public static Long forceCompaction;
    public static Long useMultipleAsyncEventListener;
    public static Long isSingleHop;
    public static Long limitNumberOfSubquery;
    public static Long addListenerUsingAlterTable;
    public static Long isTicket45071fixed;
    public static Long isTicket42669fixed;
    public static Long cycleVms;
    public static Long generateIdAlways;
    public static Long generateDefaultId;
    public static Long createTableWithGeneratedId;
    public static Long dropProc;
    public static Long dropFunc;
    public static Long batchPreparedStmt;
    public static Long ticket45938fixed;
    public static Long isTableSecuritiesReplicated;
    public static Long loadUseCase2LargeDataFile;
    public static Long toReproduce46311;
    public static Long toReproduce39455;
    public static Long toReproduce50010;
    public static Long toReproduce50001;
    public static Long toReproduce50115;
    public static Long toReproduce50116;
    public static Long toReproduce50118;
    public static Long toReproduce50547;
    public static Long toReproduce50546;
    public static Long toReproduce50550;
    public static Long toReproduce50609;
    public static Long toReproduce50607;
    public static Long toReproduce50608;
    public static Long toReproduce50610;
    public static Long toReproduce50649;
    public static Long toReproduce50658;
    public static Long toReproduce50676;
    public static Long toReproduce50710;
    public static Long toReproduce50962;
    public static Long toReproduce51113;
    public static Long toReproduce51276;
    public static Long toReproduce51249;
    public static Long toReproduce51090;
    public static Long toReproduce51255;
    public static Long toReproduce43511;
    public static Long workAround49565;
    public static Long useOldListAgg;
    public static Long useListAggNewImpl;
    public static Long useListAggPreparedStmt;
    public static Long useC3P0ConnectionPool;
    public static Long useDBCPConnectionPool;
    public static Long useTomcatConnectionPool;
    public static Long alterTableDropColumn;
    public static Long hasCompanies;
    public static Long isOffheap;
    public static long mixOffheapTables;
    public static Long randomizeOffHeap;
    public static Long ticket46799fixed;
    public static Long ticket46803fixed;
    public static Long ticket46980fixed;
    public static Long workaround51582;
    public static Long disableUpdateStatement48248;
    public static Long testworkaroundFor51519;
    public static Long companiesTableDDLExtension;
    public static Long companiesTableRedundancy;
    public static Long gfeCompaniesPersistExtension;
    public static Long noNullClob;
    public static Long isFunctionalTest;
    public static Long logDML;
    public static Long tradeToMarketWithDefaultId;
    public static Long skipConstraints;
    public static Long allowUpdateOnPartitionColumn;
    public static Long sqlFilePath;
    public static Long createRecursiveTrigger;
    public static Long useDefaultDiskStoreForOverflow;
    public static Long sleepSecondBeforeShutdown;
    public static Long portfoliov1Statement;
    public static Long hasPortfolioV1;
    public static Long hasCustomersDup;
    public static Long evictionHeapPercentage;
    public static Long syncHAForOfflineTest;
    public static Long useMD5Checksum;
    public static Long testMultipleUniqueIndex;
    public static Long verifyUsingOrderBy;
    public static Long allowConcDDLDMLOps;
    public static Long limitConcDDLOps;
    public static Long dumpThreads;
    public static Long dumpThreadsInterval;
    public static Long dumpThreadsTotalTime;
    public static Long addSecidInProjection;
    public static Long failAtUpdateCountDiff;
    public static Long useNewTables;
    public static Long hasSecondaryTables;
    public static Long isParallelDBSynchronizer;
    public static Long queryHDFSWhileVerifyingResults;
    public static Long setIdentityColumn;
    public static Long insertInBB;
    public static Long traceFlags;
    public static Long dumpBackingMap;
    public static long mbeanTest;
    public static Long sqlfireDiskStorePath;
    public static Long useGenericSQLModel;
    public static Long host;
    public static Long port;
    public static Long alterTableDMLs;

    public static int[] getTables() {
        String[] strArr = SQLPrms.getTableNames();
        int[] tableArr = new int[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            tableArr[i] = DMLStmtsFactory.getInt(strArr[i]);
        }
        return tableArr;
    }

    public static int[] getDDLs() {
        int i;
        HydraVector ddls = TestConfig.tab().vecAt(ddlOperations, new HydraVector());
        int[] ddlArr = new int[ddls.size()];
        String[] strArr = new String[ddls.size()];
        for (i = 0; i < ddls.size(); ++i) {
            strArr[i] = (String)ddls.elementAt(i);
        }
        for (i = 0; i < strArr.length; ++i) {
            ddlArr[i] = DDLStmtsFactory.getInt(strArr[i]);
        }
        return ddlArr;
    }

    public static int[] getJoinTables() {
        String[] strArr = SQLPrms.getJoinTableNames();
        int[] tableArr = new int[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            tableArr[i] = JoinTableStmtsFactory.getInt(strArr[i]);
        }
        return tableArr;
    }

    public static String[] getTableNames() {
        HydraVector tables = SQLPrms.tasktab().vecAt(dmlTables, TestConfig.tab().vecAt(dmlTables, new HydraVector()));
        String[] strArr = new String[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            strArr[i] = (String)tables.elementAt(i);
        }
        return strArr;
    }

    public static int[] getInitialRowCountToPopulateTable() {
        HydraVector counts = SQLPrms.tasktab().vecAt(initialRowCount, TestConfig.tab().vecAt(initialRowCount, new HydraVector()));
        int size = counts.size();
        int defaultCountSize = 1000;
        boolean useDefaultCount = false;
        if (counts.size() == 0) {
            HydraVector tables = SQLPrms.tasktab().vecAt(dmlTables, TestConfig.tab().vecAt(dmlTables, new HydraVector()));
            size = tables.size();
            useDefaultCount = true;
        }
        int[] intArr = new int[size];
        for (int i = 0; i < size; ++i) {
            intArr[i] = useDefaultCount ? defaultCountSize : Integer.parseInt((String)counts.elementAt(i));
        }
        return intArr;
    }

    public static String[] getJoinTableNames() {
        HydraVector tables = TestConfig.tab().vecAt(joinTables, new HydraVector());
        String[] strArr = new String[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            strArr[i] = (String)tables.elementAt(i);
        }
        return strArr;
    }

    public static String[] getCreateTablesStatements(boolean forDerby) {
        HydraVector statements = TestConfig.tab().vecAt(createTablesStatements, new HydraVector());
        String[] strArr = new String[statements.size()];
        for (int i = 0; i < statements.size(); ++i) {
            boolean incrementBy;
            boolean startWith;
            strArr[i] = (String)statements.elementAt(i);
            if (forDerby || !SQLTest.createTableWithGeneratedId) continue;
            if (strArr[i].contains("create table trade.customers")) {
                startWith = SQLTest.random.nextBoolean();
                incrementBy = SQLTest.random.nextBoolean();
                strArr[i] = "create table trade.customers (cid int not null GENERATED BY DEFAULT AS IDENTITY " + (startWith || incrementBy ? "(" : "") + (startWith ? "START WITH 1 " : "") + (startWith && incrementBy ? "," : "") + (incrementBy ? "INCREMENT BY 1 " : "") + (startWith || incrementBy ? ")" : "") + ", cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))";
                continue;
            }
            if (!strArr[i].contains("create table trade.sellorders")) continue;
            startWith = SQLTest.random.nextBoolean();
            incrementBy = SQLTest.random.nextBoolean();
            strArr[i] = "create table trade.sellorders (oid int not null GENERATED BY DEFAULT AS IDENTITY " + (startWith || incrementBy ? "(" : "") + (startWith ? "START WITH 1 " : "") + (startWith && incrementBy ? "," : "") + (incrementBy ? "INCREMENT BY 1 " : "") + (startWith || incrementBy ? ")" : "") + " constraint orders_pk primary key, cid int, sid int, qty int, ask decimal (30, 20), order_time timestamp, status varchar(10), " + "tid int, constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict, " + "constraint status_ch check (status in ('cancelled', 'open', 'filled')))";
        }
        return strArr;
    }

    public static String[] getGFEDDL() {
        int i;
        String[] tables = SQLPrms.getCreateTablesStatements(false);
        for (i = 0; i < tables.length; ++i) {
            String currentTable = tables[i].substring(0, tables[i].indexOf("(")).toLowerCase();
            if (!SQLTest.hasJSON || !currentTable.contains("trade.securities") && !currentTable.contains("trade.buyorders") && !currentTable.contains("trade.networth") && !currentTable.contains("trade.customers")) continue;
            tables[i] = tables[i].trim().substring(0, tables[i].trim().length() - 1);
            String tableName = tables[i].substring(0, tables[i].indexOf("(")).toLowerCase();
            if (tableName.contains("trade.customers")) {
                int n = i;
                tables[n] = tables[n] + " , json_details json , networth_json json , buyorder_json json )";
                continue;
            }
            int n = i;
            tables[n] = tables[n] + " , json_details json )";
        }
        String[] finalDDL = AbstractDMLStmt.byTidList ? SQLPrms.getGFEDDLByTidList(tables) : (AbstractDMLStmt.byCidRange ? SQLPrms.getGFEDDLByCidRange(tables) : SQLPrms.getGFEDDL(tables));
        if (SQLTest.isOffheap) {
            for (i = 0; i < finalDDL.length; ++i) {
                if (finalDDL[i].toLowerCase().indexOf(" OFFHEAP ".toLowerCase()) >= 0) continue;
                finalDDL[i] = finalDDL[i] + " OFFHEAP ";
            }
        }
        return finalDDL;
    }

    public static void setHdfsDDL(String[] ddlString) {
        SQLPrms.getHdfsDDLExtn(ddlString);
    }

    public static String[] getHdfsDDL(String[] ddlString) {
        String[] hdfsDDL = SQLPrms.getHdfsDDLExtn(ddlString);
        for (int i = 0; i < ddlString.length && i < hdfsDDL.length; ++i) {
            ddlString[i] = ddlString[i] + hdfsDDL[i];
            Log.getLogWriter().info("hdfs extention: " + hdfsDDL[i]);
        }
        return ddlString;
    }

    private static String[] getGFEDDL(String[] tables) {
        HydraVector statements = TestConfig.tab().vecAt(gfeDDLExtension, new HydraVector());
        if (statements.size() == 0) {
            return tables;
        }
        String[] strArr = new String[statements.size()];
        for (int i = 0; i < statements.size(); ++i) {
            strArr[i] = tables[i] + " " + (String)statements.elementAt(i);
        }
        return strArr;
    }

    public static String[] getDiskStoreDDL() {
        HydraVector statements = TestConfig.tab().vecAt(createDiskStore, new HydraVector());
        if (statements.size() == 0) {
            return null;
        }
        String[] strArr = new String[statements.size()];
        for (int i = 0; i < statements.size(); ++i) {
            strArr[i] = (String)statements.elementAt(i);
        }
        return strArr;
    }

    public static String getRedundancyClause(int i) {
        HydraVector statements = TestConfig.tab().vecAt(redundancyClause, new HydraVector());
        if (statements.size() == 0) {
            return " ";
        }
        if (i > statements.size()) {
            throw new TestException("incorrect redundancy setting in the test config");
        }
        return (String)statements.elementAt(i);
    }

    private static String[] getGFEDDLByTidList(String[] tables) {
        HydraVector statements = TestConfig.tab().vecAt(gfeDDLExtension, new HydraVector());
        if (statements.size() == 0) {
            throw new TestException("configuration issue, partition by list is not set");
        }
        String[] strArr = new String[statements.size()];
        for (int i = 0; i < statements.size(); ++i) {
            String gfePartition = (String)statements.elementAt(i);
            strArr[i] = tables[i] + " " + gfePartition;
            if (gfePartition.contains("partition by list (tid)")) {
                if (i == 0) {
                    int n = i;
                    strArr[n] = strArr[n] + GFXDTxHelper.getTidListPartition() + SQLPrms.getRedundancyClause(i);
                    continue;
                }
                int n = i;
                strArr[n] = strArr[n] + GFXDTxHelper.getTidListPartition() + "colocate with (trade.securities)" + SQLPrms.getRedundancyClause(i);
                continue;
            }
            if (!gfePartition.contains("replicate")) continue;
            String tableName = null;
            if (tables[i].contains("create table trade.customers")) {
                tableName = "customers";
            } else if (tables[i].contains("create table trade.securities")) {
                tableName = "securities";
            } else if (tables[i].contains("create table trade.portfolio")) {
                tableName = "portfolio";
            } else if (tables[i].contains("create table trade.networth")) {
                tableName = "networth";
            } else if (tables[i].contains("create table trade.sellorders")) {
                tableName = "sellorders";
            } else if (tables[i].contains("create table trade.buyorders")) {
                tableName = "buyorders";
            } else if (tables[i].contains("create table trade.txhistory")) {
                tableName = "txhistory";
            }
            SQLBB.getBB().getSharedMap().put((Object)(tableName + "replicate"), (Object)true);
        }
        return strArr;
    }

    private static String[] getGFEDDLByCidRange(String[] tables) {
        HydraVector statements = TestConfig.tab().vecAt(gfeDDLExtension, new HydraVector());
        if (statements.size() == 0) {
            throw new TestException("configuration issue, partition by cid range is not set");
        }
        String[] strArr = new String[statements.size()];
        for (int i = 0; i < statements.size(); ++i) {
            String gfePartition = (String)statements.elementAt(i);
            strArr[i] = tables[i] + " " + gfePartition;
            if (gfePartition.contains("partition by range (cid) ")) {
                if (i == 1) {
                    int n = i;
                    strArr[n] = strArr[n] + GFXDTxHelper.getCidRangePartition() + SQLPrms.getRedundancyClause(i);
                    continue;
                }
                int n = i;
                strArr[n] = strArr[n] + GFXDTxHelper.getCidRangePartition() + "colocate with (trade.customers)" + SQLPrms.getRedundancyClause(i);
                continue;
            }
            if (!gfePartition.contains("replicate")) continue;
            String tableName = null;
            if (tables[i].contains("create table trade.customers")) {
                tableName = "customers";
            } else if (tables[i].contains("create table trade.securities")) {
                tableName = "securities";
            } else if (tables[i].contains("create table trade.portfolio")) {
                tableName = "portfolio";
            } else if (tables[i].contains("create table trade.networth")) {
                tableName = "networth";
            } else if (tables[i].contains("create table trade.sellorders")) {
                tableName = "sellorders";
            } else if (tables[i].contains("create table trade.buyorders")) {
                tableName = "buyorders";
            } else if (tables[i].contains("create table trade.txhistory")) {
                tableName = "txhistory";
            }
            SQLBB.getBB().getSharedMap().put((Object)(tableName + "replicate"), (Object)true);
        }
        return strArr;
    }

    public static String[] getGFESchemas() {
        HydraVector statements = TestConfig.tab().vecAt(createSchemas, new HydraVector());
        String sg = TestConfig.tab().stringAt(schemaDefaultServerGroup, "random");
        Log.getLogWriter().info("sg is " + sg);
        String[] strArr = new String[statements.size()];
        for (int i = 0; i < statements.size(); ++i) {
            strArr[i] = (String)statements.elementAt(i);
            if (i != 0 || !SQLTest.testServerGroupsInheritence) continue;
            if (sg.equals("random")) {
                ArrayList groups = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"serverGroup_tables");
                String[] sGroups = (String[])groups.get(SQLTest.random.nextInt(groups.size()));
                sg = sGroups[SQLTest.random.nextInt(sGroups.length)];
            } else {
                sg = sg.replace('.', ',');
            }
            SQLBB.getBB().getSharedMap().put((Object)SQLTest.tradeSchemaSG, (Object)sg);
            if (!sg.equals("default")) {
                int n = i;
                strArr[n] = strArr[n] + " DEFAULT SERVER GROUPS (" + sg + ") ";
                continue;
            }
            if (!SQLTest.hasAsyncDBSync && !SQLTest.isWanTest || !SQLTest.isHATest) continue;
            int n = i;
            strArr[n] = strArr[n] + " DEFAULT SERVER GROUPS (SG1,SG2,SG3,SG4) ";
        }
        return strArr;
    }

    public static String[] getSchemas() {
        HydraVector statements = TestConfig.tab().vecAt(createSchemas, new HydraVector());
        String[] strArr = new String[statements.size()];
        for (int i = 0; i < statements.size(); ++i) {
            strArr[i] = (String)statements.elementAt(i);
        }
        return strArr;
    }

    public static String[] getHdfsDDLExtn(String[] ddlString) {
        HydraVector statements = TestConfig.tab().vecAt(hdfsDDLExtn, new HydraVector());
        if (statements.size() == 0) {
            return null;
        }
        String[] strArr = new String[statements.size()];
        HashMap<String, String> hdfsExtnParams = new HashMap<String, String>();
        for (int i = 0; i < statements.size(); ++i) {
            strArr[i] = ((String)statements.elementAt(i)).toUpperCase();
            strArr[i] = strArr[i].replaceAll(" +", " ");
            int tableNameStartIndex = ddlString[i].toUpperCase().indexOf("TABLE");
            int tableNameEndIndex = ddlString[i].indexOf("(", tableNameStartIndex);
            String tableName = ddlString[i].substring(tableNameStartIndex + 6, tableNameEndIndex).trim().toUpperCase();
            if (strArr[i].contains("BY CRITERIA")) {
                int sqlPredicateStartIndex = strArr[i].indexOf("EVICTION BY CRITERIA") + 22;
                int sqlPredicateEndIndex = 0;
                if (strArr[i].contains("CASCADE")) {
                    hdfsExtnParams.put(tableName + "CASCADE", "CASCADE");
                    sqlPredicateEndIndex = strArr[i].indexOf("CASCADE", sqlPredicateStartIndex);
                } else if (strArr[i].contains("EVICT INCOMING") || strArr[i].contains("EVICTION FREQUENCY")) {
                    sqlPredicateEndIndex = strArr[i].indexOf("EVICT", sqlPredicateStartIndex);
                } else if (strArr[i].contains("HDFSSTORE")) {
                    sqlPredicateEndIndex = strArr[i].indexOf("HDFSSTORE");
                }
                String sqlPredicate = strArr[i].substring(sqlPredicateStartIndex, sqlPredicateEndIndex - 2).trim();
                hdfsExtnParams.put(tableName + "EVICTIONCRITERIA", sqlPredicate);
            }
            if (strArr[i].contains("EVICT INCOMING")) {
                hdfsExtnParams.put(tableName + "EVICTINCOMING", "EVICT INCOMING");
            }
            if (strArr[i].contains(" START ")) {
                int timestampStartIndex = strArr[i].indexOf(" START ") + 7;
                int timestampEndIndex1 = strArr[i].indexOf(" ", timestampStartIndex);
                int timestampEndIndex2 = strArr[i].indexOf("'", timestampEndIndex1 + 2) + 1;
                String timestamp = strArr[i].substring(timestampStartIndex, timestampEndIndex2).trim();
                hdfsExtnParams.put(tableName + "STARTTIME", timestamp);
            }
            if (strArr[i].contains("EVICTION FREQUENCY")) {
                int frequencyStartIndex = strArr[i].indexOf("EVICTION FREQUENCY") + 19;
                int frequencyEndIndex1 = strArr[i].indexOf(" ", frequencyStartIndex) + 1;
                int frequencyEndIndex2 = strArr[i].indexOf(" ", frequencyEndIndex1);
                String frequency = strArr[i].substring(frequencyStartIndex, frequencyEndIndex2);
                hdfsExtnParams.put(tableName + "FREQUENCY", frequency);
            }
            if (strArr[i].contains("WRITEONLY")) {
                hdfsExtnParams.put(tableName + "WRITEONLY", "WRITEONLY");
            }
            if (!strArr[i].contains("HDFSSTORE")) continue;
            int storeNameStartIndex = strArr[i].indexOf("HDFSSTORE") + 11;
            int storeNameEndIndex = strArr[i].indexOf(")", storeNameStartIndex);
            String storeName = strArr[i].substring(storeNameStartIndex, storeNameEndIndex);
            hdfsExtnParams.put(tableName + "STORENAME", storeName);
        }
        SQLBB.getBB().getSharedMap().put((Object)HDFS_EXTN_PARAMS, hdfsExtnParams);
        Log.getLogWriter().info("HDFS extension params in BB : " + hdfsExtnParams);
        return strArr;
    }

    public static String[] prepareFullSetTableCreateStmt() {
        String[] statements = SQLPrms.getCreateTablesStatements(true);
        Pattern pattern = Pattern.compile("([a-z]*\\.[a-z]*)| constraint ([a-z]*_[a-z]*)");
        for (int i = 0; i < statements.length; ++i) {
            StringBuffer statementAfterMatching = new StringBuffer();
            statements[i] = statements[i].trim().replaceAll(" +", " ").toLowerCase();
            Matcher patternMatcher = pattern.matcher(statements[i]);
            while (patternMatcher.find()) {
                if (patternMatcher.group().equalsIgnoreCase("trade.uuid") || patternMatcher.group().equalsIgnoreCase("trade.udtprice")) continue;
                patternMatcher.appendReplacement(statementAfterMatching, patternMatcher.group() + SQLTest.DUPLICATE_TABLE_SUFFIX);
            }
            patternMatcher.appendTail(statementAfterMatching);
            statements[i] = statementAfterMatching.toString();
            statements[i] = statements[i].replaceAll(",? (constraint [a-z_]* )?foreign key \\([a-z_, ]*\\) references [a-z._]* \\([a-z_, ]*\\)[ ]?(on delete restrict)?", "");
            if (SQLTest.hdfsMrJob) {
                statements[i] = statements[i].replaceAll(",?( constraint [a-z_]* )? ?primary key( ?\\(+[a-z_, ]*\\)?)?", " ");
                statements[i] = statements[i].replaceAll(", constraint [a-z _,\\(\\)\\' <>=0]*", ")");
            }
            statements[i] = statements[i] + " replicate";
        }
        return statements;
    }

    public static void setTriggerStmtInMap() {
        HashMap<String, String> TriggerStmt = new HashMap<String, String>();
        String identityStr = SQLPrms.hasIdentityColumn() ? "DEFAULT , " : "";
        TriggerStmt.put("trade.securities_insert", " INSERT INTO TRADE.SECURITIES_FULLDATASET VALUES (  " + identityStr + " NEWROW.SEC_ID ,  NEWROW.SYMBOL ,     NEWROW.PRICE ,      NEWROW.EXCHANGE ,  NEWROW.TID )");
        TriggerStmt.put("trade.customers_insert", " INSERT INTO TRADE.CUSTOMERS_FULLDATASET  VALUES (  " + identityStr + " NEWROW.CID ,     NEWROW.CUST_NAME ,  NEWROW.SINCE ,      NEWROW.ADDR ,      NEWROW.TID )");
        TriggerStmt.put("trade.networth_insert", " INSERT INTO TRADE.NETWORTH_FULLDATASET   VALUES (  NEWROW.CID ,     NEWROW.CASH ,       NEWROW.SECURITIES , NEWROW.LOANLIMIT , NEWROW.AVAILLOAN ,  NEWROW.TID )");
        TriggerStmt.put("trade.portfolio_insert", " INSERT INTO TRADE.PORTFOLIO_FULLDATASET  VALUES (  NEWROW.CID ,     NEWROW.SID ,        NEWROW.QTY ,        NEWROW.AVAILQTY ,  NEWROW.SUBTOTAL ,   NEWROW.TID )");
        TriggerStmt.put("trade.sellorders_insert", " INSERT INTO TRADE.SELLORDERS_FULLDATASET VALUES (  NEWROW.OID ,     NEWROW.CID ,        NEWROW.SID ,        NEWROW.QTY ,       NEWROW.ASK ,        NEWROW.ORDER_TIME ,  NEWROW.STATUS ,  NEWROW.TID )");
        TriggerStmt.put("trade.buyorders_insert", " INSERT INTO TRADE.BUYORDERS_FULLDATASET  VALUES (  NEWROW.OID ,     NEWROW.CID ,        NEWROW.SID ,        NEWROW.QTY ,       NEWROW.BID ,        NEWROW.ORDERTIME ,   NEWROW.STATUS ,  NEWROW.TID )");
        TriggerStmt.put("trade.txhistory_insert", " INSERT INTO TRADE.TXHISTORY_FULLDATASET  VALUES (  NEWROW.CID,      NEWROW.OID,         NEWROW.SID,         NEWROW.QTY,        NEWROW.PRICE,       NEWROW.ORDERTIME,    NEWROW.TYPE,     NEWROW.TID)");
        TriggerStmt.put("trade.trades_insert", " INSERT INTO TRADE.TRADES_FULLDATASET     VALUES (  NEWROW.TID,      NEWROW.CID,         NEWROW.EID,         NEWROW.TRADEDATE)");
        TriggerStmt.put("trade.companies_insert", " INSERT INTO TRADE.COMPANIES_FULLDATASET  SELECT * FROM  TRADE.COMPANIES WHERE SYMBOL =  NEWROW.SYMBOL  AND EXCHANGE = NEWROW.EXCHANGE");
        TriggerStmt.put("trade.securities_delete", "DELETE FROM TRADE.SECURITIES_FULLDATASET WHERE  SEC_ID =  OLDROW.SEC_ID");
        TriggerStmt.put("trade.customers_delete", "DELETE FROM TRADE.CUSTOMERS_FULLDATASET  WHERE CID=OLDROW.CID");
        TriggerStmt.put("trade.networth_delete", "DELETE FROM TRADE.NETWORTH_FULLDATASET   WHERE CID=OLDROW.CID");
        TriggerStmt.put("trade.portfolio_delete", "DELETE FROM TRADE.PORTFOLIO_FULLDATASET  WHERE CID=OLDROW.CID AND SID =OLDROW.SID");
        TriggerStmt.put("trade.sellorders_delete", "DELETE FROM TRADE.SELLORDERS_FULLDATASET WHERE OID=OLDROW.OID ");
        TriggerStmt.put("trade.buyorders_delete", "DELETE FROM TRADE.BUYORDERS_FULLDATASET  WHERE OID=OLDROW.OID ");
        TriggerStmt.put("trade.txhistory_delete", "DELETE FROM TRADE.TXHISTORY_FULLDATASET  WHERE NVL(CID,0) = NVL(OLDROW.CID,0) AND NVL(OID,0) = NVL(OLDROW.OID,0) AND NVL(SID,0)=NVL(OLDROW.SID,0) AND    NVL(QTY,0)=NVL(OLDROW.QTY,0) AND NVL(PRICE,0) = NVL(OLDROW.PRICE,0) AND NVL(ORDERTIME,'2013-09-19 15:51:26') = NVL(OLDROW.ORDERTIME,'2013-09-19 15:51:26') AND NVL(TYPE,' ') = NVL(OLDROW.TYPE, ' ') AND NVL(TID,0)=NVL(OLDROW.TID,0)");
        TriggerStmt.put("trade.trades_delete", "DELETE FROM TRADE.TRADES_FULLDATASET     WHERE TID=OLDROW.TID");
        TriggerStmt.put("trade.companies_delete", "DELETE FROM TRADE.COMPANIES_FULLDATASET  WHERE SYMBOL=OLDROW.SYMBOL AND EXCHANGE = OLDROW.EXCHANGE");
        SQLBB.getBB().getSharedMap().put((Object)HDFS_TRIGGER_STMT, TriggerStmt);
    }

    public static String[] prepareTriggerStmt() {
        ArrayList<String> triggerStmt = new ArrayList<String>();
        String[] statements = SQLPrms.getCreateTablesStatements(true);
        String[] tableNames = SQLPrms.getTableNames();
        ArrayList<String> StrTriggerName = new ArrayList<String>();
        String insertOp = "_insert";
        String deleteOp = "_delete";
        boolean j = false;
        int tableIndex = 0;
        String insertTriggerStmt = "CREATE  TRIGGER  $TABLENAME_INSERTTRIGGER AFTER INSERT ON $TABLENAME REFERENCING NEW AS NEWROW FOR EACH ROW  $INSERT ";
        String deleteTriggerStmt = "CREATE  TRIGGER  $TABLENAME_DELETETRIGGER AFTER DELETE ON $TABLENAME REFERENCING OLD AS OLDROW  FOR EACH ROW $DELETE";
        String updateTriggerStmt = "CREATE  TRIGGER  $TABLENAME_DELETEFORUPDATE AFTER UPDATE ON $TABLENAME REFERENCING NEW AS NEWROW OLD AS OLDROW FOR EACH ROW  $DELETE";
        String updateTriggerStmt1 = "CREATE  TRIGGER  $TABLENAME_INSERTFORUPDATE AFTER UPDATE ON $TABLENAME REFERENCING NEW AS NEWROW OLD AS OLDROW FOR EACH ROW $INSERT";
        HashMap triggerPrepStmt = (HashMap)SQLBB.getBB().getSharedMap().get((Object)HDFS_TRIGGER_STMT);
        for (int i = 0; i < statements.length && tableIndex < tableNames.length; ++tableIndex, ++i) {
            String tableName = tableNames[tableIndex].toLowerCase();
            triggerStmt.add(insertTriggerStmt.replaceAll("\\$TABLENAME", tableName).replaceAll("\\$INSERT", (String)triggerPrepStmt.get(tableName + insertOp)));
            if (!SQLTest.updateWriteOnlyMr) {
                triggerStmt.add(updateTriggerStmt.replaceAll("\\$TABLENAME", tableName).replaceAll("\\$DELETE", (String)triggerPrepStmt.get(tableName + deleteOp)));
            }
            triggerStmt.add(updateTriggerStmt1.replaceAll("\\$TABLENAME", tableName).replaceAll("\\$INSERT", (String)triggerPrepStmt.get(tableName + insertOp)));
            if (!SQLTest.updateWriteOnlyMr) {
                triggerStmt.add(deleteTriggerStmt.replaceAll("\\$TABLENAME", tableName).replaceAll("\\$DELETE", (String)triggerPrepStmt.get(tableName + deleteOp)));
            }
            StrTriggerName.add(tableNames[tableIndex] + "_INSERTTRIGGER");
            if (!SQLTest.updateWriteOnlyMr) {
                StrTriggerName.add(tableNames[tableIndex] + "_DELETEFORUPDATE");
            }
            StrTriggerName.add(tableNames[tableIndex] + "_INSERTFORUPDATE");
            if (SQLTest.updateWriteOnlyMr) continue;
            StrTriggerName.add(tableNames[tableIndex] + "_DELETETRIGGER");
        }
        SQLBB.getBB().getSharedMap().put((Object)HDFS_TRIGGER, StrTriggerName);
        return triggerStmt.toArray(new String[triggerStmt.size()]);
    }

    public static long getRandSeed() {
        long seed = -1L;
        Object val = TestConfig.tab().get(Prms.randomSeed);
        seed = val != null && val instanceof Long ? (Long)val : (val != null && val instanceof String ? Long.parseLong((String)val) : System.currentTimeMillis());
        String clientName = System.getProperty("clientName");
        if (clientName != null) {
            seed += (long)RemoteTestModule.getMyVmid();
        }
        return seed;
    }

    public static boolean hasIdentityColumn() {
        Long key = setIdentityColumn;
        return SQLPrms.tasktab().booleanAt(key, SQLPrms.tab().booleanAt(key, false));
    }

    public static String getSqlFilePath() {
        if (SQLPrms.tasktab().get(sqlFilePath) != null) {
            return SQLPrms.tasktab().stringAt(sqlFilePath);
        }
        return SQLPrms.tab().stringAt(sqlFilePath);
    }

    public static boolean isInsertInBB() {
        Long key = insertInBB;
        return SQLPrms.tasktab().booleanAt(key, SQLPrms.tab().booleanAt(key, true));
    }

    public static String getTraceFlags() {
        return SQLPrms.tasktab().stringAt(traceFlags, SQLPrms.tab().stringAt(traceFlags, null));
    }

    public static boolean getDumpBackingMap() {
        Long key = dumpBackingMap;
        boolean value = SQLPrms.tasktab().booleanAt(key, SQLPrms.tab().booleanAt(key, false));
        return value;
    }

    public static boolean isMBeanTest() {
        return SQLPrms.tab().booleanAt(Long.valueOf(mbeanTest), false);
    }

    static {
        SQLPrms.setValues(SQLPrms.class);
    }
}

