/*
 * Decompiled with CFR 0.152.
 */
package sql;

import cacheperf.comparisons.gemfirexd.QueryUtil;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import hydra.ClientVmInfo;
import hydra.DerbyServerHelper;
import hydra.EnvHelper;
import hydra.GemFireDescription;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.AnyCyclicBarrier;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedLock;
import hydra.blackboard.SharedMap;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.FabricServerPrms;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.GfxdHelper;
import hydra.gemfirexd.GfxdHelperPrms;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import splitBrain.SplitBrainBB;
import splitBrain.SplitBrainPrms;
import sql.ClientDiscDBManager;
import sql.DBType;
import sql.DiscDBManager;
import sql.GFEDBClientManager;
import sql.GFEDBManager;
import sql.PartitionClause;
import sql.PersistBB;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.ddlStatements.DDLStmtIF;
import sql.ddlStatements.FunctionDDLStmt;
import sql.ddlStatements.IndexDDLStmt;
import sql.ddlStatements.ProcedureDDLStmt;
import sql.ddlStatements.Procedures;
import sql.dmlStatements.DMLStmtIF;
import sql.dmlStatements.TradeCustomersDMLStmt;
import sql.generic.SQLOldTest;
import sql.hdfs.HDFSSqlTest;
import sql.hdfs.HDFSTestPrms;
import sql.hdfs.TriggerQueryObserver;
import sql.joinStatements.JoinTableStmtIF;
import sql.mbeans.listener.CallBackListener;
import sql.rollingUpgrade.SQLRollingUpgradeBB;
import sql.rollingUpgrade.SQLRollingUpgradePrms;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlutil.DDLStmtsFactory;
import sql.sqlutil.DMLStmtsFactory;
import sql.sqlutil.JoinTableStmtsFactory;
import sql.sqlutil.PooledConnectionC3P0;
import sql.sqlutil.PooledConnectionDBCP;
import sql.sqlutil.PooledConnectionTomcat;
import sql.sqlutil.ResultSetHelper;
import sql.wan.SQLWanBB;
import sql.wan.SQLWanPrms;
import sql.wan.WanTest;
import util.PRObserver;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class SQLTest {
    public static String dbSynchStore = "DBSynchStore";
    public static final Random random = new Random(SQLPrms.getRandSeed());
    protected static SQLTest sqlTest;
    protected static HDFSSqlTest hdfsSqlTest;
    protected static String insertCustomersSQL;
    protected static Connection discConn;
    public static boolean hasDerbyServer;
    public static boolean testUniqueKeys;
    public static boolean randomData;
    public static boolean hasNetworth;
    public static AtomicBoolean fabricServerStarted;
    public static boolean isSerial;
    public static boolean isSingleDMLThread;
    public static boolean usingTrigger;
    public static boolean queryAnyTime;
    protected static long killInterval;
    protected static DMLStmtsFactory dmlFactory;
    protected static DDLStmtsFactory ddlFactory;
    protected static JoinTableStmtsFactory joinFactory;
    public static boolean createIndex;
    public static boolean testPartitionBy;
    public static boolean testServerGroups;
    public static boolean testServerGroupsInheritence;
    protected static int numOfReplay;
    public static boolean testUniqIndex;
    protected static int[] dmlTables;
    protected static int[] ddls;
    public static boolean populateThruLoader;
    public static boolean testSecurity;
    protected static String[] tables;
    protected static HashMap<String, List<String>> tableCols;
    protected static boolean tableColsSet;
    protected static String roles;
    protected static boolean testInitDDLReplay;
    public static boolean multiThreadsCreateTables;
    public static String sgDBSync;
    public static String asyncDBSyncId;
    public static boolean hasAsyncDBSync;
    public static boolean hasAsyncEventListener;
    public static boolean hasHdfs;
    public static boolean hasJSON;
    public static boolean updateWriteOnlyMr;
    public static boolean hdfsMrJob;
    public static boolean supportDuplicateTables;
    public static boolean rebalanceBuckets;
    public static boolean isHATest;
    public static boolean isEdge;
    public static int numOfStores;
    public static int numOfWorkers;
    public static boolean hasPersistentTables;
    public static boolean isWanTest;
    protected static boolean useWriterForWriteThrough;
    protected static boolean testLoaderCreateRandomRow;
    public static boolean hasTx;
    public static boolean isOfflineTest;
    public static String tradeSchemaSG;
    public static boolean testEviction;
    public static boolean useHeapPercentage;
    public static boolean setCriticalHeap;
    public static HydraThreadLocal getCanceled;
    public static HydraThreadLocal getNodeFailure;
    public static HydraThreadLocal getEvictionConflict;
    public static boolean useMultipleAsyncEventListener;
    public static boolean withReplicatedTables;
    protected static int maxResultWaitSec;
    public static boolean addListenerUsingAlterTable;
    protected static boolean cycleVms;
    public static boolean generateIdAlways;
    public static boolean generateDefaultId;
    public static boolean createTableWithGeneratedId;
    public static boolean dropProc;
    public static boolean dropFunc;
    public static int ddlThread;
    public static final String CUSTNUMOFPRS = "custNumOfPRs";
    public static final String NETWORTHNUMOFPRS = "networthNumOfPRs";
    public static final String SECNUMOFPRS = "secNumOfPRs";
    public static final String PORTNUMOFPRS = "portNumOfPRs";
    public static final String SONUMOFPRS = "soNumOfPRs";
    public static final String BONUMOFPRS = "boNumOfPRs";
    public static final String TXHISTORYNUMOFPRS = "txhistoryNumOfPRs";
    public static boolean ticket45938fixed;
    public static boolean disableUpdateStatement48248;
    public static boolean testMultipleUniqueIndex;
    public static HydraThreadLocal derbyConnection;
    public static HydraThreadLocal resetDerbyConnection;
    public static boolean alterTableDropColumn;
    public static boolean hasCompanies;
    public static boolean ticket46803fixed;
    public static boolean reproduceTicket46689;
    public static HydraThreadLocal alterTableException;
    public static boolean networkPartitionDetectionEnabled;
    public static Cache gemfireCache;
    public static String losingSideHost;
    public static boolean populateWithbatch;
    public static FabricServer oldFabricServer;
    public static boolean isLocator;
    public static String companyTable;
    public static String hasRedundancy;
    public static String cycleVMTarget;
    public static int waitTimeBeforeNextCycleVM;
    public static long lastCycledTime;
    public static final String LASTCYCLEDTIME = "lastCycledTime";
    public static boolean testWanUniqueness;
    public static boolean setIdentityColumn;
    static boolean useDefaultDiskStoreForOverflow;
    public static double percentage;
    public static boolean ticket49794fixed;
    public static boolean useC3P0;
    public static boolean useDBCP;
    public static boolean useTomcatConnPool;
    protected static boolean useGfxdConfig;
    public static final String PORTFOLIOV1READY = "portfoliov1IsReady";
    public static volatile boolean portfoliov1IsReady;
    public static boolean hasPortfolioV1;
    public static boolean hasCustomersDup;
    private static String portfoliov1;
    public static boolean failAtUpdateCount;
    protected static boolean workAround49565;
    public static final String SOCKETLEASETIME = "socket-lease-time";
    public static final String HOSTDATA = "host-data";
    public static final String PERSISTDD = "persist-dd";
    public static final String SERVERGROUP = "server-groups";
    public static final String XCL54 = "XCL54";
    public static final String X0Z01 = "X0Z01";
    private static final String FS;
    public static boolean firstEntry;
    private static String diskCompatibilityDiskStorePath;
    public static final boolean useRandomConfHdfsStore;
    public static String createTablePortfolioStmt;
    public static String createTableCustomersStmt;
    public static boolean useNewTables;
    public static String[] cachedGfeDDLs;
    public static boolean waitForLocatorUpgrade;
    public static boolean locatorUpgradeCompleted;
    public static boolean useGenericSQL;
    public static SQLOldTest sqlGen;
    public static final int THOUSAND = 1000;
    public static final String REBALANCE = "rebalance";
    public static final String NEEDMOREDATANODES = "needMoreDataNodes";
    public static final String LRUMEMSIZE = "LRUMEMSIZE";
    public static boolean setTx;
    public static boolean verifyUsingOrderBy;
    public static double initEvictionHeap;
    public static boolean workaround51582;
    public static boolean accessorUpgradeCompleted;
    public static boolean storeUpgradeCompleted;
    public static boolean verifyByTid;
    private static final String restartedStoreVmIDsKey = "restartedStoreVmIDs";
    public static String oraclePassword;
    public static String DUPLICATE_TABLE_SUFFIX;
    public static String MR_TABLE_SUFFIX;
    public static boolean isOffheap;
    public static boolean randomizeOffHeap;
    public static final String OFFHEAPCLAUSE = " OFFHEAP ";
    public static boolean allowConcDDLDMLOps;
    public static boolean limitConcDDLOps;
    public static boolean forceCompaction;
    public static boolean syncHAForOfflineTest;
    private static List<ClientVmInfo> vmListForOfflineTest;
    public static boolean dumpThreads;
    public static int dumpThreadsInterval;
    public static int dumpThreadsTotalTime;
    public static boolean enableConcurrencyCheck;
    public static String ENABLECONCURRENCYCHECKS;
    private static boolean isTicket51584Fixed;
    public static boolean reproduceTicket51628;
    private static List<CallBackListener> listeners;
    protected static SharedLock lock;

    public static void HydraTask_createGfxdLocatorTask() {
        isLocator = true;
        FabricServerHelper.createLocator();
    }

    public static void HydraTask_startGfxdLocatorTask() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        FabricServerHelper.startLocator(networkServerConfig);
    }

    public static void HydraTask_setTraceFlagsTask() {
        new SQLTest().setTraceFlags(true);
    }

    public static void HydraTask_unsetTraceFlagsTask() {
        new SQLTest().setTraceFlags(false);
    }

    public static void HydraTask_stopGfxdLocatorTask() {
        FabricServerHelper.stopLocator();
    }

    public static void HydraTask_reStartGfxdTask() {
        if (isLocator) {
            SQLTest.HydraTask_startGfxdLocatorTask();
        } else {
            MasterController.sleepForMs((int)30000);
            sqlTest.startFabricServer();
        }
    }

    public static synchronized void HydraTask_initialize() {
        SQLTest.HydraTask_initializeGFXD();
    }

    public static synchronized void HydraTask_initializeGFXD() {
        if (sqlTest == null) {
            sqlTest = new SQLTest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            String gemfireName = System.getProperty("gemfireName");
            GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
            roles = gfd.getRoles();
        }
        sqlTest.initialize();
    }

    public static synchronized void HydraTask_initializeFabricServer() {
        if (sqlTest == null) {
            sqlTest = new SQLTest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
        }
        sqlTest.initialize();
    }

    protected void initialize() {
        hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
        testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
        randomData = TestConfig.tab().booleanAt(SQLPrms.randomData, false);
        isSerial = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        waitForLocatorUpgrade = TestConfig.tab().booleanAt(SQLRollingUpgradePrms.waitForLocatorUpgrade, false);
        if (isSerial) {
            testUniqueKeys = false;
            this.log().info("For serial testing, testUniquekeys is set to " + testUniqueKeys);
        }
        isSingleDMLThread = TestConfig.tab().booleanAt(SQLPrms.isSingleDMLThread, false);
        usingTrigger = TestConfig.tab().booleanAt(SQLPrms.usingTrigger, false);
        queryAnyTime = TestConfig.tab().booleanAt(SQLPrms.queryAnyTime, true);
        hasNetworth = TestConfig.tab().booleanAt(SQLPrms.hasNetworth, true);
        if (setCriticalHeap) {
            boolean[] opCanceled = new boolean[]{false};
            getCanceled.set((Object)opCanceled);
        }
        if (hasHdfs) {
            hdfsSqlTest = new HDFSSqlTest();
        }
    }

    protected String getOraclePassword() {
        int aVal = 97;
        int length = 8;
        char[] charArray = new char[length];
        for (int j = 0; j < length; ++j) {
            charArray[j] = (char)(random.nextInt(26) + aVal);
        }
        String password = new String(charArray);
        this.log().info("oracle password for trade is " + password);
        return password;
    }

    public static void HydraTask_initialize_replay() {
        int sleepMS = 30000;
        if (numOfReplay == 0) {
            Log.getLogWriter().info("sleep for " + sleepMS / 1000 + " sec and wait for other ddl message");
            MasterController.sleepForMs((int)sleepMS);
            if (sqlTest == null) {
                sqlTest = new SQLTest();
                PRObserver.installObserverHook();
                PRObserver.initialize((int)RemoteTestModule.getMyVmid());
                sqlTest.createGFXDDB();
            }
            ++numOfReplay;
        }
        MasterController.sleepForMs((int)sleepMS);
    }

    public static void HydraTask_initialize_replayHA() throws Exception {
        Object initDelayed = SQLBB.getBB().getSharedMap().get((Object)("initDelayed_" + RemoteTestModule.getMyVmid()));
        if (initDelayed == null) {
            SQLBB.getBB().getSharedMap().put((Object)("initDelayed_" + RemoteTestModule.getMyVmid()), (Object)"true");
            Log.getLogWriter().info("first time for init DDL replay, do nothing");
            return;
        }
        if (sqlTest == null) {
            sqlTest = new SQLTest();
            int numOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            sqlTest.createGFXDDB();
            ArrayList<ClientVmInfo> vms = new ArrayList<ClientVmInfo>();
            vms.add(new ClientVmInfo(RemoteTestModule.getMyVmid()));
            PRObserver.waitForRebalRecov(vms, (int)1, (int)numOfPRs, null, null, (boolean)false);
            StopStartVMs.StopStart_initTask();
        }
        int sleepMS = 30000;
        Log.getLogWriter().info("sleep for " + sleepMS / 1000 + " sec");
        MasterController.sleepForMs((int)sleepMS);
    }

    public static void HydraTask_increaseHeapNodeStart() {
        int addNode;
        int sleepMS = 30000;
        if (numOfReplay == 0 && (addNode = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.addNewDataNodes)) == 1) {
            Boolean needToStartNow = (Boolean)SQLBB.getBB().getSharedMap().get((Object)NEEDMOREDATANODES);
            if (needToStartNow != null && needToStartNow.booleanValue() && sqlTest == null) {
                sqlTest = new SQLTest();
                sqlTest.startFabricServerWithRebalance();
                ++numOfReplay;
                PRObserver.installObserverHook();
                PRObserver.initialize((int)RemoteTestModule.getMyVmid());
                MasterController.sleepForMs((int)sleepMS);
                sqlTest.setNeedMoreDataNodes(false);
            }
            SQLBB.getBB().getSharedCounters().zero(SQLBB.addNewDataNodes);
        }
        MasterController.sleepForMs((int)sleepMS);
    }

    public static void HydraTask_startFabricServerWithRebalance() {
        if (numOfReplay == 0) {
            if (sqlTest == null) {
                sqlTest = new SQLTest();
            }
            sqlTest.startFabricServerWithRebalance();
            ++numOfReplay;
        }
    }

    protected void startFabricServerWithRebalance() {
        Log.getLogWriter().info("Starting the fabric server");
        Properties p = FabricServerHelper.getBootProperties();
        if (p != null && "false".equalsIgnoreCase(p.getProperty(HOSTDATA)) && "true".equalsIgnoreCase(p.getProperty(PERSISTDD))) {
            p.setProperty(PERSISTDD, "false");
        }
        if (p != null && isTicket51584Fixed) {
            Log.getLogWriter().info("setting rebalance to true");
            p.setProperty(REBALANCE, "true");
        }
        this.startFabricServer(p);
        if (!isTicket51584Fixed) {
            this.callRebalanceBucket();
        }
    }

    protected void setNeedMoreDataNodes(boolean moreNode) {
        this.getLock();
        SQLBB.getBB().getSharedMap().put((Object)NEEDMOREDATANODES, (Object)moreNode);
        Log.getLogWriter().info("needMoreDataNodes is set to " + moreNode);
        this.releaseLock();
    }

    protected void callRebalanceBucket() {
        try {
            Connection conn = this.getGFEConnection();
            String sql = "{call sys.rebalance_all_buckets()}";
            this.log().info("executing " + sql);
            CallableStatement cs = conn.prepareCall(sql);
            cs.execute();
            this.log().info("executed " + sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_initForServerGroup() {
        sqlTest.initForServerGroup();
    }

    protected void initForServerGroup() {
        int numOfHosts = TestConfig.tab().intAt(SQLPrms.storeHosts, 6);
        String[] group1 = new String[]{"SG1", "SG1,SG2", "SG1,SG3", "SG1,SG4", "SG1,SG2,SG3", "SG1,SG2,SG4", "SG1,SG3,SG4", "default"};
        String[] group2 = new String[]{"SG2", "SG1,SG2", "SG2,SG3", "SG2,SG4", "SG2,SG3,SG4", "SG1,SG2,SG3", "SG1,SG2,SG4", "default"};
        String[] group3 = new String[]{"SG3", "SG2,SG3", "SG1,SG3", "SG3,SG4", "SG1,SG3,SG4", "SG1,SG2,SG3", "SG2,SG3,SG4", "default"};
        String[] group4 = new String[]{"SG4", "SG2,SG4", "SG3,SG4", "SG1,SG4", "SG1,SG2,SG4", "SG1,SG3,SG4", "SG2,SG3,SG4", "default"};
        ArrayList<String[]> groups = new ArrayList<String[]>();
        groups.add(0, group1);
        groups.add(1, group2);
        groups.add(2, group3);
        groups.add(3, group4);
        SQLBB.getBB().getSharedMap().put((Object)"serverGroup_tables", groups);
        if (numOfHosts < groups.size()) {
            throw new TestException("Test issues, not enough data hosts to host the necessary server groups");
        }
        ArrayList<String> sgs = new ArrayList<String>();
        for (int i = 0; i < numOfHosts; ++i) {
            String[] group;
            if (i < groups.size()) {
                group = (String[])groups.get(i);
                int whichOne = random.nextInt(group.length - 1);
                sgs.add(i, group[whichOne]);
                Log.getLogWriter().info("group[" + i + "] is " + group[whichOne]);
                continue;
            }
            group = (String[])groups.get(random.nextInt(groups.size()));
            sgs.add(i, group[random.nextInt(group.length)]);
        }
        SQLBB.getBB().getSharedMap().put((Object)"serverGroups", sgs);
    }

    public static synchronized void HydraTask_createDiscDB() {
        if (sqlTest == null) {
            sqlTest = new SQLTest();
        }
        sqlTest.createDiscDB();
    }

    protected void createDiscDB() {
        if (hasDerbyServer && discConn == null) {
            while (true) {
                try {
                    discConn = this.getFirstDiscConnection();
                }
                catch (SQLException se) {
                    Log.getLogWriter().info("Not able to connect to Derby server yet, Derby server may not be ready.");
                    SQLHelper.printSQLException(se);
                    int sleepMS = 10000;
                    MasterController.sleepForMs((int)sleepMS);
                    continue;
                }
                break;
            }
        }
    }

    public static synchronized void HydraTask_createDiscSchemas() {
        sqlTest.createDiscSchemas();
    }

    public static void HydraTask_createDuplicateDiscSchemas() {
        sqlTest.createDuplicateDiscSchemas();
    }

    protected void createDuplicateDiscSchemas() {
        if (!hasDerbyServer) {
            return;
        }
        Connection conn = this.getDiscConnection();
        try {
            String isoLevel;
            int isolation = conn.getTransactionIsolation();
            switch (isolation) {
                case 0: {
                    isoLevel = "TRANSACTION_NONE";
                    break;
                }
                case 2: {
                    isoLevel = "TRANSACTION_READ_COMMITTED";
                    break;
                }
                case 4: {
                    isoLevel = "TRANSACTION_REPEATABLE_READ";
                    break;
                }
                case 8: {
                    isoLevel = "TRANSACTION_SERIALIZABLE";
                    break;
                }
                default: {
                    isoLevel = "unknown";
                }
            }
            Log.getLogWriter().info("Derby default cconnection isolation level is " + isoLevel);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Log.getLogWriter().info("creating duplicate schemas on disc.");
        this.createDuplicateSchemas(conn);
        Log.getLogWriter().info("done creating duplicate schemas on disc with proper exception.");
        this.closeDiscConnection(conn);
    }

    protected void createDiscSchemas() {
        if (!hasDerbyServer) {
            return;
        }
        Connection conn = this.getDiscConnection("superUser");
        Log.getLogWriter().info("creating schemas on disc.");
        this.createSchemas(conn);
        Log.getLogWriter().info("done creating schemas on disc.");
        this.closeDiscConnection(conn);
    }

    public static void HydraTask_createGFESchemas() {
        if (useGenericSQL) {
            sqlGen.createGFESchemas();
        } else {
            sqlTest.createGFESchemas();
        }
    }

    public static void HydraTask_createDuplicateGFESchemas() {
        sqlTest.createDuplicateGFESchemas();
    }

    protected void createGFESchemas() {
        ddlThread = this.getMyTid();
        Connection conn = this.getGFEConnection();
        Log.getLogWriter().info("testServerGroupsInheritence is set to " + testServerGroupsInheritence);
        Log.getLogWriter().info("creating schemas in gfe.");
        if (!testServerGroupsInheritence) {
            this.createSchemas(conn);
        } else {
            String[] schemas = SQLPrms.getGFESchemas();
            this.createSchemas(conn, schemas);
        }
        Log.getLogWriter().info("done creating schemas in gfe.");
        this.closeGFEConnection(conn);
    }

    protected void createDuplicateGFESchemas() {
        Connection conn = this.getGFEConnection();
        Log.getLogWriter().info("creating duplicate schemas in gfe.");
        this.createDuplicateSchemas(conn);
        Log.getLogWriter().info("done creating duplicate schemas in gfe with expected exception.");
    }

    protected void createDuplicateSchemas(Connection conn) {
        int i;
        String[] schemas = SQLPrms.getSchemas();
        boolean gotExpectedException = false;
        try {
            Statement s = conn.createStatement();
            for (i = 0; i < schemas.length; ++i) {
                try {
                    s.execute(schemas[i]);
                    continue;
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    if (!"X0Y68".equals(se.getSQLState())) continue;
                    Log.getLogWriter().info("Got expected schema existing SQLException. \n");
                    gotExpectedException = true;
                }
            }
            s.close();
            this.commit(conn);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to create schemas\n" + TestHelper.getStackTrace((Throwable)se));
        }
        if (!gotExpectedException) {
            throw new TestException("Did not get the expected SQLException as we created trade schema twice.\n");
        }
        StringBuffer aStr = new StringBuffer("Created schemas \n");
        for (i = 0; i < schemas.length; ++i) {
            String o = schemas[i];
            aStr.append(o.toString() + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    protected void createSchemas(Connection conn) {
        String[] schemas = SQLPrms.getSchemas();
        this.createSchemas(conn, schemas);
    }

    protected void createSchemas(Connection conn, String[] schemas) {
        int i;
        String ddlThread = "thr_" + this.getMyTid();
        try {
            Statement s = conn.createStatement();
            for (i = 0; i < schemas.length; ++i) {
                if (testSecurity) {
                    s.execute(schemas[i] + " AUTHORIZATION " + ddlThread);
                    continue;
                }
                s.execute(schemas[i]);
            }
            s.close();
            this.commit(conn);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Y68")) {
                Log.getLogWriter().info("got schema existing exception if multiple threads try to create schema, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
        StringBuffer aStr = new StringBuffer("Created schemas \n");
        for (i = 0; i < schemas.length; ++i) {
            String o = schemas[i];
            aStr.append(o.toString() + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    protected void createTradeSchema(Connection conn) {
        try {
            Statement s = conn.createStatement();
            s.execute("create schema trade");
            s.close();
            this.commit(conn);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to create trade schema on disc " + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public static synchronized void HydraTask_createTables() {
        sqlTest.createFuncMonth();
        sqlTest.createBothTables();
    }

    protected void createBothTables() {
        if (!hasDerbyServer) {
            Connection gConn = this.getGFEConnection();
            this.createTables(gConn);
            this.closeGFEConnection(gConn);
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.createTables(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static synchronized void HydraTask_createDiscTables() {
        sqlTest.createDiscTables();
    }

    protected void createDiscTables() {
        if (!hasDerbyServer) {
            return;
        }
        Connection conn = this.getDiscConnection();
        this.log().info("creating tables in derby db.");
        this.createTables(conn);
        this.log().info("done creating tables in derby db.");
        this.closeDiscConnection(conn);
    }

    public static void HydraTask_createGFETables() {
        sqlTest.createFuncMonth();
        if (useGenericSQL) {
            sqlGen.createGFETables();
        } else {
            sqlTest.createGFETables();
        }
        if (supportDuplicateTables) {
            Boolean createOnlyTrigger = SQLBB.getBB().getSharedMap().get((Object)"CreateOnlyTriggers") != null;
            if (createOnlyTrigger.booleanValue()) {
                sqlTest.createTriggers();
                SQLBB.getBB().getSharedMap().put((Object)"CreateOnlyTriggers", (Object)false);
            } else {
                sqlTest.createDuplicateTables();
                sqlTest.createTriggers();
            }
        }
    }

    protected void createGFETables() {
        Connection conn = this.getGFEConnection();
        Log.getLogWriter().info("dropping tables in gfe.");
        this.dropTables(conn);
        this.executeListener("CLOSE", "PRINT_CONN");
        Log.getLogWriter().info("done dropping tables in gfe");
        Log.getLogWriter().info("creating tables in gfe.");
        this.createTables(conn);
        Log.getLogWriter().info("done creating tables in gfe.");
        this.closeGFEConnection(conn);
        if (hasHdfs) {
            SharedCounters counter = SQLBB.getBB().getSharedCounters();
            counter.increment(SQLBB.createTableDone);
        }
    }

    public static synchronized void HydraTask_dropAllTables() {
        if (SQLBB.getBB().getSharedMap().get((Object)"hdfsTriggers") != null && supportDuplicateTables) {
            sqlTest.dropTriggers();
            sqlTest.truncateDuplicateTables(DUPLICATE_TABLE_SUFFIX);
            SQLBB.getBB().getSharedMap().put((Object)"CreateOnlyTriggers", (Object)true);
        }
        sqlTest.dropAllTables();
    }

    protected void dropAllTables() {
        Log.getLogWriter().info("dropping all tables in gfe.");
        Connection conn = this.getGFEConnection();
        String tableName = "";
        String[] createTablestmt = SQLPrms.getCreateTablesStatements(true);
        String dropStatement = "DROP  TABLE ";
        try {
            Statement s = conn.createStatement();
            for (int i = createTablestmt.length - 1; i >= 0; --i) {
                int tableNameStartIndex = createTablestmt[i].toUpperCase().indexOf("TABLE");
                int tableNameEndIndex = createTablestmt[i].indexOf("(", tableNameStartIndex);
                tableName = createTablestmt[i].substring(tableNameStartIndex + 6, tableNameEndIndex).trim().toUpperCase();
                this.log().info("executing statement : " + dropStatement + tableName);
                s.execute(dropStatement + tableName);
                this.log().info("executing statement : " + dropStatement + tableName + " completed");
            }
            s.execute("drop function if exists month");
            s.close();
            this.closeGFEConnection(conn);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to drop table: " + tableName + TestHelper.getStackTrace((Throwable)se));
        }
        Log.getLogWriter().info("done dropping all tables in gfe.");
    }

    public static synchronized void HydraTask_truncateDuplicateTables() {
        sqlTest.truncateDuplicateTables(DUPLICATE_TABLE_SUFFIX);
    }

    public static synchronized void HydraTask_truncateMrTables() {
        sqlTest.truncateDuplicateTables(MR_TABLE_SUFFIX);
    }

    protected void truncateDuplicateTables(String suffix) {
        Log.getLogWriter().info("Truncating all tables from gfe.");
        Connection conn = this.getGFEConnection();
        String tableName = "";
        String[] createTablestmt = SQLPrms.getCreateTablesStatements(true);
        String truncateStatement = "TRUNCATE  TABLE ";
        try {
            Statement s = conn.createStatement();
            for (int i = 0; i < createTablestmt.length; ++i) {
                int tableNameStartIndex = createTablestmt[i].toUpperCase().indexOf("TABLE");
                int tableNameEndIndex = createTablestmt[i].indexOf("(", tableNameStartIndex);
                tableName = createTablestmt[i].substring(tableNameStartIndex + 6, tableNameEndIndex).trim().toUpperCase();
                tableName = tableName + suffix;
                this.log().info("executing statement : " + truncateStatement + tableName);
                s.execute(truncateStatement + tableName);
                this.log().info("executing statement : " + truncateStatement + tableName + " completed");
            }
            s.close();
            this.closeGFEConnection(conn);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to Truncate table: " + tableName + TestHelper.getStackTrace((Throwable)se));
        }
        Log.getLogWriter().info("done truncating all tables from gfe.");
    }

    protected void dropTables(Connection conn) {
        String sql = null;
        ArrayList<String> tables = new ArrayList<String>();
        tables.add("trade.txhistory");
        tables.add("trade.buyorders");
        tables.add("trade.sellorders");
        tables.add("trade.portfolio");
        tables.add("trade.networth");
        tables.add("trade.customers");
        tables.add("trade.securities");
        boolean testDropTableIfExists = random.nextBoolean();
        sql = testDropTableIfExists ? "drop table if exists " : "drop table ";
        try {
            for (String table : tables) {
                Statement s = conn.createStatement();
                s.execute(sql + table);
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("42Y55") && !testDropTableIfExists) {
                Log.getLogWriter().info("Got expected table not exists exception, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    public static synchronized void HydraTask_dropMrTables() {
        sqlTest.dropMrTables();
    }

    protected void dropMrTables() {
        Connection conn = this.getGFEConnection();
        String sql = null;
        ArrayList<String> tables = new ArrayList<String>();
        tables.add("trade.txhistory_hdfs");
        tables.add("trade.buyorders_hdfs");
        tables.add("trade.sellorders_hdfs");
        tables.add("trade.portfolio_hdfs");
        tables.add("trade.networth_hdfs");
        tables.add("trade.customers_hdfs");
        tables.add("trade.securities_hdfs");
        tables.add("emp.employees_hdfs");
        tables.add("trade.trades_hdfs");
        sql = "drop table if exists ";
        try {
            for (String table : tables) {
                Statement s = conn.createStatement();
                s.execute(sql + table);
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("42Y55")) {
                Log.getLogWriter().info("Got expected table not exists exception, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void createTables(Connection conn) {
        int i;
        String url;
        try {
            String driver = conn.getMetaData().getDriverName();
            url = conn.getMetaData().getURL();
            Log.getLogWriter().info("Driver name is " + driver + " url is " + url);
        }
        catch (SQLException se) {
            throw new TestException("Not able to get driver name" + TestHelper.getStackTrace((Throwable)se));
        }
        String[] derbyTables = SQLPrms.getCreateTablesStatements(true);
        String[] tableNames = SQLPrms.getTableNames();
        String[] gfeDDL = null;
        try {
            Statement s = conn.createStatement();
            if (url.equals(DiscDBManager.getUrl()) || url.equals(ClientDiscDBManager.getUrl())) {
                for (i = 0; i < derbyTables.length; ++i) {
                    Log.getLogWriter().info("about to create table " + derbyTables[i]);
                    s.execute(derbyTables[i]);
                }
            } else if (url.equals(GFEDBManager.getUrl()) || url.startsWith(GFEDBClientManager.getProtocol())) {
                if (hasHdfs) {
                    SQLPrms.setHdfsDDL(SQLPrms.getCreateTablesStatements(false));
                }
                gfeDDL = !testPartitionBy ? SQLPrms.getGFEDDL() : this.getGFEDDLPartition();
                if (hasHdfs) {
                    Log.getLogWriter().info("creating hdfs extn...");
                    gfeDDL = SQLPrms.getHdfsDDL(gfeDDL);
                }
                if (isOffheap && randomizeOffHeap) {
                    throw new TestException("SqlPrms.isOffheap and SqlPrms.randomizeOffHeap are both set to true");
                }
                if (isOffheap) {
                    Log.getLogWriter().info("enabling offheap.");
                    for (i = 0; i < gfeDDL.length; ++i) {
                        if (gfeDDL[i].toLowerCase().indexOf(OFFHEAPCLAUSE.toLowerCase()) >= 0) continue;
                        int n = i;
                        gfeDDL[n] = gfeDDL[n] + OFFHEAPCLAUSE;
                    }
                }
                if (randomizeOffHeap) {
                    Log.getLogWriter().info("Randomizing off-heap in some tables but not others");
                    for (i = 0; i < gfeDDL.length; ++i) {
                        if (gfeDDL[i].toLowerCase().indexOf(OFFHEAPCLAUSE.toLowerCase()) >= 0 || TestConfig.tab().getRandGen().nextInt(1, 100) > 50) continue;
                        int n = i;
                        gfeDDL[n] = gfeDDL[n] + OFFHEAPCLAUSE;
                    }
                }
                if (enableConcurrencyCheck) {
                    i = 0;
                    while (i < gfeDDL.length) {
                        int n = i++;
                        gfeDDL[n] = gfeDDL[n] + ENABLECONCURRENCYCHECKS;
                    }
                }
                for (i = 0; i < gfeDDL.length; ++i) {
                    if (hasAsyncDBSync) {
                        String ddl = gfeDDL[i].toUpperCase();
                        if (ddl.contains("REPLICATE")) {
                            if (ddl.contains("SERVER GROUPS") && !ddl.contains(sgDBSync)) {
                                int index = ddl.indexOf("SERVER GROUPS");
                                StringBuffer start = new StringBuffer(gfeDDL[i].substring(0, index - 1));
                                StringBuffer sb = new StringBuffer(gfeDDL[i].substring(index));
                                sb.insert(sb.indexOf("SG"), sgDBSync + ",");
                                gfeDDL[i] = start.append(sb).toString();
                            }
                            if (!ddl.contains("SERVER GROUPS") && testServerGroupsInheritence && !((String)SQLBB.getBB().getSharedMap().get((Object)tradeSchemaSG)).equalsIgnoreCase("default")) {
                                int n = i;
                                gfeDDL[n] = gfeDDL[n] + "SERVER GROUPS (" + sgDBSync + "," + SQLBB.getBB().getSharedMap().get((Object)tradeSchemaSG) + ")";
                            } else if (!ddl.contains("SERVER GROUPS") && testServerGroupsInheritence && ((String)SQLBB.getBB().getSharedMap().get((Object)tradeSchemaSG)).equalsIgnoreCase("default")) {
                                int n = i;
                                gfeDDL[n] = gfeDDL[n] + "SERVER GROUPS (" + sgDBSync + ",SG1,SG2,SG3,SG4)";
                            }
                        }
                        if (hasAsyncEventListener) {
                            if (!useMultipleAsyncEventListener) {
                                if (!addListenerUsingAlterTable) {
                                    String basicListener = "BasicAsyncListener";
                                    int n = i;
                                    gfeDDL[n] = gfeDDL[n] + "AsyncEventListener(" + basicListener + ")";
                                }
                            } else if (i < tableNames.length) {
                                if (!tableNames[i].toLowerCase().contains("v1")) {
                                    String[] str = tableNames[i].split("\\.");
                                    String tableName = str[1];
                                    String tableListener = tableName.substring(0, 1).toUpperCase() + tableName.substring(1) + "AsyncListener";
                                    int n = i;
                                    gfeDDL[n] = gfeDDL[n] + "AsyncEventListener(" + tableListener + ")";
                                }
                            } else if (gfeDDL[i].contains("default1")) {
                                int n = i;
                                gfeDDL[n] = gfeDDL[n] + "AsyncEventListener(EmployeesAsyncListener)";
                            }
                        } else {
                            int n = i;
                            gfeDDL[n] = gfeDDL[n] + "AsyncEventListener(" + asyncDBSyncId + ")";
                        }
                    }
                    if (useNewTables) {
                        cachedGfeDDLs = gfeDDL;
                    }
                    if (hasPortfolioV1 && gfeDDL[i].contains("create table trade.portfolio ")) {
                        createTablePortfolioStmt = gfeDDL[i];
                    }
                    if (hasCustomersDup && gfeDDL[i].contains("create table trade.customers ")) {
                        createTableCustomersStmt = gfeDDL[i];
                    }
                    this.executeListener("CLOSE", "PRINT_CONN");
                    Log.getLogWriter().info("About to create table " + gfeDDL[i]);
                    try {
                        s.execute(gfeDDL[i]);
                        continue;
                    }
                    catch (SQLException se) {
                        if (multiThreadsCreateTables && se.getSQLState().equalsIgnoreCase("X0Y32")) {
                            Log.getLogWriter().info("Got the expected exception, continuing tests");
                            continue;
                        }
                        if (se.getSQLState().equalsIgnoreCase("X0Y99")) {
                            SQLHelper.printSQLException(se);
                            Log.getLogWriter().info("Got the expected exception X0Y99, continuing tests");
                            String sql = "drop table trade.securities";
                            s.execute(sql);
                            Log.getLogWriter().info(sql);
                            s.execute(derbyTables[0]);
                            Log.getLogWriter().info(derbyTables[0]);
                            Log.getLogWriter().info("about to recreate table " + gfeDDL[i]);
                            s.execute(gfeDDL[i]);
                            continue;
                        }
                        SQLHelper.printSQLException(se);
                        throw new TestException("Not able to create tables\n" + TestHelper.getStackTrace((Throwable)se));
                    }
                }
            } else {
                throw new TestException("Got incorrect url or setting.");
            }
            this.executeListener("CLOSE", "PRINT_CONN");
            s.close();
            this.commit(conn);
            this.executeListener("CLOSE", "PRINT_CONN");
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to create tables\n" + TestHelper.getStackTrace((Throwable)se));
        }
        StringBuffer aStr = new StringBuffer("Created tables \n");
        if (url.equals(DiscDBManager.getUrl()) || url.equals(ClientDiscDBManager.getUrl())) {
            for (i = 0; i < tables.length; ++i) {
                aStr.append(tables[i] + "\n");
            }
        } else if (url.equals(GFEDBManager.getUrl()) || url.startsWith(GFEDBClientManager.getProtocol())) {
            for (i = 0; i < gfeDDL.length; ++i) {
                aStr.append(gfeDDL[i] + "\n");
            }
        }
        Log.getLogWriter().info(aStr.toString());
        if (url.equals(DiscDBManager.getUrl()) || url.equals(ClientDiscDBManager.getUrl())) {
            this.createDerbyIndex(conn);
        }
    }

    protected void setNumOfPRs() {
        Properties p = FabricServerHelper.getBootProperties();
        if (p != null && "true".equalsIgnoreCase(p.getProperty(HOSTDATA))) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SharedCounters counter = SQLBB.getBB().getSharedCounters();
                    TestHelper.waitForCounter((Blackboard)SQLBB.getBB(), (String)"SQLBB.createTableDone", (int)SQLBB.createTableDone, (long)1L, (boolean)false, (long)-1L, (long)2000L);
                    if (counter.incrementAndRead(SQLBB.calculatedNumOfPPs) == 1L) {
                        GemFireCacheImpl cache = Misc.getGemFireCache();
                        Set prSet = cache.getPartitionedRegions();
                        int numOfPRs = 0;
                        if (prSet != null) {
                            numOfPRs = prSet.size();
                            HashSet<String> prNames = new HashSet<String>();
                            for (PartitionedRegion pr : prSet) {
                                if (pr.getRedundantCopies() == 0) {
                                    --numOfPRs;
                                    SQLTest.this.log().info("remove " + pr.getFullPath() + " from numOfPR calculation as there is no redundancy/recovery for this region");
                                    continue;
                                }
                                prNames.add(pr.getFullPath());
                            }
                            counter.zero(SQLBB.numOfPRs);
                            counter.add(SQLBB.numOfPRs, (long)numOfPRs);
                            SQLTest.this.log().info("setting numOfPRs in cluster to " + numOfPRs + ", PRs = " + prNames);
                        }
                    }
                }
            }).start();
        } else {
            this.log().info("Not a datastore node");
        }
    }

    protected void createTables(Connection dConn, Connection gConn) {
        int i;
        String[] derbyTables = SQLPrms.getCreateTablesStatements(true);
        String[] gfeDDL = SQLPrms.getGFEDDL();
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        try {
            Statement d = dConn.createStatement();
            Log.getLogWriter().info("Creating tables in derby");
            for (i = 0; i < derbyTables.length; ++i) {
                try {
                    d.execute(derbyTables[i]);
                    Log.getLogWriter().info("Created table: " + derbyTables[i]);
                    continue;
                }
                catch (SQLException se) {
                    SQLHelper.handleDerbySQLException(se, exList);
                }
            }
            d.close();
            this.commit(dConn);
        }
        catch (SQLException se) {
            SQLHelper.handleDerbySQLException(se, exList);
        }
        try {
            Statement g = gConn.createStatement();
            Log.getLogWriter().info("Creating tables in gemfirexd");
            for (i = 0; i < derbyTables.length; ++i) {
                try {
                    g.execute(gfeDDL[i]);
                    Log.getLogWriter().info("Created table: " + gfeDDL[i]);
                    continue;
                }
                catch (SQLException se) {
                    SQLHelper.handleGFGFXDException(se, exList);
                }
            }
            g.close();
            this.commit(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
        SQLHelper.handleMissedSQLException(exList);
        Log.getLogWriter().info("successfully created tables on both derby and gemfirexd");
    }

    protected void createDiscTradeTables() {
        if (!hasDerbyServer) {
            return;
        }
        Connection conn = this.getDiscConnection();
        try {
            this.createDiscTradeCustomers(conn);
            this.commit(conn);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to create Trade tables on disc " + TestHelper.getStackTrace((Throwable)se));
        }
    }

    protected void createDiscTradeCustomers(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table trade.customers (cid int, cust_name varchar(100), since date, addr varchar(100))");
        s.close();
    }

    protected Connection getFirstDiscConnection() throws SQLException {
        Connection conn = null;
        conn = testSecurity ? ClientDiscDBManager.getAuthConnection(this.getMyTid()) : ClientDiscDBManager.getConnection();
        return conn;
    }

    protected Connection getDiscConnection() {
        Connection conn = (Connection)derbyConnection.get();
        if (conn == null || ((Boolean)resetDerbyConnection.get()).booleanValue()) {
            Log.getLogWriter().info("derbyConnection is not set yet");
            try {
                conn = testSecurity ? ClientDiscDBManager.getAuthConnection(this.getMyTid()) : ClientDiscDBManager.getConnection();
            }
            catch (SQLException e) {
                SQLHelper.printSQLException(e);
                throw new TestException("Not able to get Derby Connection:\n " + TestHelper.getStackTrace((Throwable)e));
            }
            derbyConnection.set((Object)conn);
            resetDerbyConnection.set((Object)false);
        }
        return conn;
    }

    protected Connection getDiscConnection(String user) {
        Connection conn = null;
        try {
            conn = testSecurity ? ClientDiscDBManager.getAuthConnection(user) : ClientDiscDBManager.getConnection();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get Derby Connection:\n " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected void closeDiscConnection(Connection conn) {
        this.closeDiscConnection(conn, false);
    }

    protected void closeDiscConnection(Connection conn, boolean end) {
        if (end) {
            try {
                conn.close();
                Log.getLogWriter().info("closing the connection");
            }
            catch (SQLException e) {
                SQLHelper.printSQLException(e);
                throw new TestException("Not able to release the connection " + TestHelper.getStackTrace((Throwable)e));
            }
        }
    }

    protected void createDerbyIndex(Connection dConn) {
        if (!hasDerbyServer) {
            this.log().info("does not have derby db in the test run, no derby index created");
            return;
        }
        String[] tableNames = SQLPrms.getTableNames();
        int i = 0;
        for (String table : tableNames) {
            if (table.equalsIgnoreCase("trade.companies") || table.equalsIgnoreCase("trade.portfoliov1")) continue;
            String sql = "create index indextid" + i + " on " + table + " (tid)";
            try {
                dConn.createStatement().execute(sql);
                this.log().info(sql);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            ++i;
        }
        this.commit(dConn);
    }

    protected void createDerbyIndexOnCompanies(Connection dConn) {
        if (!hasDerbyServer) {
            this.log().info("does not have derby db in the test run, no derby index created");
            return;
        }
        String sql = "create index trade.indexcompaniestid on trade.companies (tid)";
        try {
            this.log().info(sql);
            dConn.createStatement().execute(sql);
            this.log().info("executed " + sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.commit(dConn);
    }

    protected void listIndexCreated(Connection conn, String schema, String table) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        ResultSet rs = metaData.getIndexInfo(null, schema.toUpperCase(), table.toUpperCase(), false, true);
        Log.getLogWriter().info("From jdbc call, index names for " + schema + "." + table + " in " + (SQLHelper.isDerbyConn(conn) ? "derby: " : "gfxd: ") + ResultSetHelper.listToString(ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn))));
        rs.close();
        if (!SQLHelper.isDerbyConn(conn)) {
            rs = conn.createStatement().executeQuery("select * from sys.indexes where schemaname='" + schema.toUpperCase() + "' and tablename ='" + table.toUpperCase() + "'");
            Log.getLogWriter().info("From system table, index names for " + schema + "." + table + " in " + (SQLHelper.isDerbyConn(conn) ? "derby: " : "gfxd: ") + ResultSetHelper.listToString(ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn))));
            rs.close();
        }
    }

    public static synchronized void HydraTask_startFabricServer() {
        sqlTest.startFabricServer();
    }

    public static synchronized void HydraTask_startFabricServer_Once() {
        if (!fabricServerStarted.get()) {
            fabricServerStarted.set(true);
            sqlTest.startFabricServer();
        }
    }

    public void startFabricServer() {
        Log.getLogWriter().info("Starting the fabric server");
        Properties p = FabricServerHelper.getBootProperties();
        if (p != null && "false".equalsIgnoreCase(p.getProperty(HOSTDATA)) && "true".equalsIgnoreCase(p.getProperty(PERSISTDD))) {
            p.setProperty(PERSISTDD, "false");
        }
        if (p != null && setTx) {
            p.setProperty("sync-commits", "true");
        }
        this.startFabricServer(p);
        if (hasHdfs) {
            this.setNumOfPRs();
        }
    }

    public void startFabricServer(Properties p) {
        boolean started = false;
        while (!started) {
            try {
                FabricServerHelper.startFabricServer(p);
                started = true;
            }
            catch (HydraRuntimeException hre) {
                if (hre.getCause() != null && hre.getCause() instanceof SQLException && ((SQLException)hre.getCause()).getSQLState().equalsIgnoreCase("XBM09") && isHATest) {
                    int msToSleep = 20000;
                    this.log().info("not able to restart the server due to XBM09, will try to restart after " + msToSleep / 1000 + " seconds");
                    this.clearPRObserverCount();
                    MasterController.sleepForMs((int)msToSleep);
                    continue;
                }
                throw hre;
            }
        }
    }

    protected void startFabricServerSG() {
        String sg = this.getSGForNode();
        Log.getLogWriter().info("Starting the fabric server");
        Properties p = FabricServerHelper.getBootProperties();
        if (p != null && "false".equalsIgnoreCase(p.getProperty(HOSTDATA))) {
            throw new TestException("test configure issue: fabric server sg must be a data node");
        }
        if (!sg.equals("default")) {
            p.setProperty(SERVERGROUP, sg);
        }
        this.startFabricServer(p);
    }

    protected void clearPRObserverCount() {
        PRObserver.installObserverHook();
        PRObserver.initialize((int)RemoteTestModule.getMyVmid());
    }

    protected void startFabricServerSGDBSynchronizer() {
        this.setClientVmInfoForDBSynchronizerNode();
        Log.getLogWriter().info("Starting the fabric server");
        Properties p = FabricServerHelper.getBootProperties();
        if (p != null && "false".equalsIgnoreCase(p.getProperty(HOSTDATA))) {
            throw new TestException("test configure issue: fabric server sg must be a data node");
        }
        p.setProperty(SERVERGROUP, sgDBSync);
        Log.getLogWriter().info("This server is in " + sgDBSync);
        this.startFabricServer(p);
    }

    public static synchronized void HydraTask_stopFabricServer() {
        sqlTest.stopFabricServer();
    }

    protected void stopFabricServer() {
        FabricServerHelper.stopFabricServer();
    }

    public static synchronized void HydraTask_createGFEDB() {
        sqlTest.createGFEDB();
    }

    public static synchronized void HydraTask_createGFEDBForAccessors() {
        sqlTest.createGFEDBForAccessors();
    }

    public static void HydraTask_createGFEDataStore() {
        sqlTest.createGFEDataStore();
    }

    public static synchronized void HydraTask_createGFXDDB() {
        sqlTest.createGFXDDB();
    }

    public static synchronized void HydraTask_createGFXDDBForAccessors() {
        sqlTest.createGFXDDBForAccessors();
    }

    public static synchronized void HydraTask_createGFXDDBSG() {
        sqlTest.createGFXDDBSG();
    }

    public static synchronized void HydraTask_startFabricServerSG() {
        sqlTest.startFabricServerSG();
    }

    public static synchronized void HydraTask_createGFXDDBSGDBSynchronizer() {
        sqlTest.createGFXDDBSGDBSynchronizer();
    }

    public static synchronized void HydraTask_startFabricServerSGDBSynchronizer() {
        sqlTest.startFabricServerSGDBSynchronizer();
    }

    public static synchronized void HydraTask_createDBSynchronizer() {
        if (sqlTest == null) {
            sqlTest = new SQLTest();
        }
        sqlTest.createDBSynchronizer();
    }

    public static synchronized void HydraTask_createDiskStores() {
        sqlTest.createDiskStores();
    }

    protected void createGFXDDB() {
        Properties info = this.getGemFireProperties();
        info.setProperty(HOSTDATA, "true");
        if (workAround49565) {
            info.setProperty(SOCKETLEASETIME, "10000");
        }
        if (setTx) {
            info.setProperty("sync-commits", "true");
        }
        Log.getLogWriter().info("Connecting with properties: " + info);
        this.startGFXDDB(info);
    }

    protected void startGFXDDB(Properties info) {
        boolean started = false;
        Connection conn = null;
        while (!started) {
            try {
                conn = this.getGFEConnection(info);
                started = true;
            }
            catch (SQLException se) {
                if (se.getSQLState().equalsIgnoreCase("XBM09") && isHATest) {
                    int msToSleep = 20000;
                    this.log().info("not able to restart the server due to XBM09, will try to restart after " + msToSleep / 1000 + " seconds");
                    this.clearPRObserverCount();
                    MasterController.sleepForMs((int)msToSleep);
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
        this.closeGFEConnection(conn);
    }

    protected void createGFXDDBForAccessors() {
        Properties info = this.getGemFireProperties();
        info.setProperty(HOSTDATA, "false");
        info.setProperty(PERSISTDD, "false");
        if (setTx) {
            info.setProperty("sync-commits", "true");
        }
        if (workAround49565) {
            info.setProperty(SOCKETLEASETIME, "10000");
        }
        Log.getLogWriter().info("Connecting with properties: " + info);
        Connection conn = null;
        try {
            conn = this.getGFEConnection(info);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.closeGFEConnection(conn);
    }

    public static synchronized void HydraTask_reCreateGFXDDB() throws SQLException {
        sqlTest.reCreateGFXDDB();
    }

    public static synchronized void HydraTask_reCreateGFXDDBForAccessors() throws SQLException {
        sqlTest.reCreateGFXDDBForAccessors();
    }

    protected void reCreateGFXDDB() throws SQLException {
        Properties info = this.getGemFireProperties();
        info.setProperty(HOSTDATA, "true");
        if (workAround49565) {
            info.setProperty(SOCKETLEASETIME, "10000");
        }
        Log.getLogWriter().info("Connecting with properties: " + info);
        Connection conn = GFEDBManager.getRestartConnection(info);
        this.closeGFEConnection(conn);
    }

    protected void reCreateGFXDDBForAccessors() throws SQLException {
        Properties info = this.getGemFireProperties();
        info.setProperty(HOSTDATA, "false");
        info.setProperty(PERSISTDD, "false");
        if (workAround49565) {
            info.setProperty(SOCKETLEASETIME, "10000");
        }
        Log.getLogWriter().info("Connecting with properties: " + info);
        Connection conn = GFEDBManager.getRestartConnection(info);
        this.closeGFEConnection(conn);
    }

    protected void createGFXDDBSG() {
        Properties info = this.getGemFireProperties();
        String sg = this.getSGForNode();
        if (!sg.equals("default")) {
            info.setProperty(SERVERGROUP, sg);
        }
        info.setProperty(HOSTDATA, "true");
        if (workAround49565) {
            info.setProperty(SOCKETLEASETIME, "10000");
        }
        Log.getLogWriter().info("Connecting with properties: " + info);
        this.startGFXDDB(info);
    }

    protected String getSGForNode() {
        HydraVector vec = TestConfig.tab().vecAt(SQLPrms.serverGroups);
        int whichOne = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.dataStoreCount);
        whichOne = whichOne <= vec.size() ? --whichOne : vec.size() - 1;
        String sg = (String)((HydraVector)vec.elementAt(whichOne)).elementAt(0);
        if (sg.startsWith("random")) {
            ArrayList serverGroups = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"serverGroups");
            if (whichOne >= serverGroups.size()) {
                whichOne = random.nextInt(serverGroups.size());
            }
            sg = (String)serverGroups.get(whichOne);
        }
        Log.getLogWriter().info("This data store is in " + sg);
        return sg;
    }

    protected void createGFXDDBSGDBSynchronizer() {
        Properties info = this.getGemFireProperties();
        this.setClientVmInfoForDBSynchronizerNode();
        Log.getLogWriter().info("This data store is in " + sgDBSync);
        info.setProperty(SERVERGROUP, sgDBSync);
        info.setProperty(HOSTDATA, "true");
        if (workAround49565) {
            info.setProperty(SOCKETLEASETIME, "10000");
        }
        Log.getLogWriter().info("Connecting with properties: " + info);
        this.startGFXDDB(info);
    }

    protected void setClientVmInfoForDBSynchronizerNode() {
        ClientVmInfo target = new ClientVmInfo(RemoteTestModule.getMyVmid());
        int num = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.asynchDBTargetVm);
        if (num == 1) {
            SQLBB.getBB().getSharedMap().put((Object)"asyncDBTarget1", (Object)target);
            Log.getLogWriter().info("asyncDBTarget1: client vmID is " + target.getVmid());
        } else {
            ClientVmInfo target1 = (ClientVmInfo)SQLBB.getBB().getSharedMap().get((Object)"asyncDBTarget1");
            if (target1 != null && target1.getVmid() == RemoteTestModule.getMyVmid()) {
                SQLBB.getBB().getSharedMap().put((Object)"asyncDBTarget1", (Object)target);
                Log.getLogWriter().info("asyncDBTarget1: client vmID is " + target.getVmid());
            } else {
                SQLBB.getBB().getSharedMap().put((Object)"asyncDBTarget2", (Object)target);
                Log.getLogWriter().info("asyncDBTarget2: client vmID is " + target.getVmid());
            }
        }
    }

    protected void createDiskStores() {
        Connection conn = this.getGFEConnection();
        this.createDiskStores(conn);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    protected void createDiskStores(Connection conn) {
        try {
            Statement stmt = conn.createStatement();
            String[] diskStores = SQLPrms.getDiskStoreDDL();
            if (diskStores == null) {
                Log.getLogWriter().info("No disk store setting in this test");
                return;
            }
            String maxlogsize = " maxlogsize 2";
            for (int i = 0; i < diskStores.length; ++i) {
                Log.getLogWriter().info("about to create diskstore " + diskStores[i] + maxlogsize);
                stmt.execute(diskStores[i] + maxlogsize);
            }
        }
        catch (SQLException sqle) {
            SQLHelper.handleSQLException(sqle);
        }
    }

    protected void createDBSynchronizer() {
        Connection conn = this.getGFEConnection();
        this.createNewDBSynchronizer(conn);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    protected void createNewDBSynchronizer(Connection conn) {
        String INIT_PARAM_STR = "org.apache.derby.jdbc.ClientDriver,jdbc:derby://" + DerbyServerHelper.getEndpoint().getHost() + ":" + DerbyServerHelper.getEndpoint().getPort() + "/" + ClientDiscDBManager.getDBName() + ";create=true";
        boolean enablePersistence = TestConfig.tab().booleanAt(SQLPrms.enableQueuePersistence, false);
        this.createNewDBSynchronizer(conn, INIT_PARAM_STR, enablePersistence);
    }

    protected void createNewDBSynchronizer(Connection conn, String INIT_PARAM_STR, boolean enablePersistence) {
        String className = "com.pivotal.gemfirexd.callbacks.DBSynchronizer";
        int batchSize = random.nextInt(1000) + 100;
        int batchTimeInterval = random.nextInt(1000) + 1000;
        boolean enableBatchConflation = TestConfig.tab().booleanAt(SQLPrms.enableQueueConflation, false);
        boolean isParallelDBSynchronizer = TestConfig.tab().booleanAt(SQLPrms.isParallelDBSynchronizer, false);
        int maxQueueMem = random.nextInt(100) + 100;
        int alert_Threshold = random.nextInt(1000) + 1000;
        boolean manualStart = random.nextBoolean();
        boolean diskSynchronous = random.nextBoolean();
        StringBuilder str = new StringBuilder();
        str.append("CREATE asyncEventListener ");
        str.append(asyncDBSyncId);
        str.append(" ( listenerclass '");
        str.append(className);
        str.append("' initparams '" + INIT_PARAM_STR + "'");
        if (random.nextBoolean()) {
            if (manualStart) {
                str.append(" MANUALSTART " + manualStart);
                Log.getLogWriter().info("DBSynchronizer MANUALSTART is " + manualStart);
            } else {
                Log.getLogWriter().info("DBSynchronizer MANUALSTART uses default");
            }
            if (random.nextBoolean()) {
                str.append(" ENABLEBATCHCONFLATION " + enableBatchConflation);
                Log.getLogWriter().info("DBSynchronizer ENABLEBATCHCONFLATION is " + enableBatchConflation);
            } else {
                Log.getLogWriter().info("DBSynchronizer ENABLEBATCHCONFLATION uses default");
            }
            if (random.nextBoolean()) {
                str.append(" BATCHSIZE " + batchSize);
                Log.getLogWriter().info("DBSynchronizer BATCHSIZE is " + batchSize);
            } else {
                Log.getLogWriter().info("DBSynchronizer BATCHSIZE uses default");
            }
            if (random.nextBoolean()) {
                str.append(" BATCHTIMEINTERVAL " + batchTimeInterval);
                Log.getLogWriter().info("DBSynchronizer BATCHTIMEINTERVAL is " + batchTimeInterval);
            } else {
                Log.getLogWriter().info("DBSynchronizer BATCHTIMEINTERVAL uses default");
            }
            if (random.nextBoolean()) {
                str.append(" ENABLEPERSISTENCE " + enablePersistence);
                Log.getLogWriter().info("DBSynchronizer ENABLEPERSISTENCE is " + enablePersistence);
                if (enablePersistence) {
                    if (random.nextBoolean()) {
                        str.append(" DISKSYNCHRONOUS " + diskSynchronous);
                        Log.getLogWriter().info("DBSynchronizer DISKSYNCHRONOUS is " + diskSynchronous);
                    } else {
                        Log.getLogWriter().info("DBSynchronizer DISKSYNCHRONOUS uses default");
                    }
                }
            } else {
                Log.getLogWriter().info("DBSynchronizer ENABLEPERSISTENCE uses default");
            }
            if (random.nextBoolean()) {
                str.append(" DISKSTORENAME " + dbSynchStore);
                Log.getLogWriter().info("DBSynchronizer DISKSTORENAME is " + dbSynchStore);
            } else {
                Log.getLogWriter().info("DBSynchronizer DISKSTORENAME  uses default");
            }
            if (random.nextBoolean()) {
                str.append(" MAXQUEUEMEMORY " + maxQueueMem);
                Log.getLogWriter().info("DBSynchronizer MAXQUEUEMEMORY is " + maxQueueMem);
            } else {
                Log.getLogWriter().info("DBSynchronizer MAXQUEUEMEMORY uses default");
            }
            if (random.nextBoolean()) {
                str.append(" ALERTTHRESHOLD " + alert_Threshold);
                Log.getLogWriter().info("DBSynchronizer ALERTTHRESHOLD is " + alert_Threshold);
            } else {
                Log.getLogWriter().info("DBSynchronizer ALERTTHRESHOLD uses default");
            }
        }
        if (isParallelDBSynchronizer) {
            str.append(" ISPARALLEL " + isParallelDBSynchronizer);
        }
        str.append(" ) ");
        Log.getLogWriter().info("DBSynchronizer uses default settings");
        str.append("SERVER GROUPS ( " + sgDBSync + " )");
        try {
            Statement s = conn.createStatement();
            s.execute(str.toString());
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        Log.getLogWriter().info(str.toString());
    }

    public static void HydraTask_startDBSynchronizer() {
        sqlTest.startDBSynchronizer();
    }

    protected void startDBSynchronizer() {
        boolean useNewApi = true;
        Connection conn = this.getGFEConnection();
        if (useNewApi) {
            this.startNewDBSynchronizer(conn);
        } else {
            this.startDBSynchronizer(conn);
        }
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    protected void startDBSynchronizer(Connection conn) {
        try {
            String startDBSynchronizer = "call SYS.START_ASYNC_EVENT_LISTENER( ? )";
            CallableStatement cs = conn.prepareCall(startDBSynchronizer);
            cs.setString(1, asyncDBSyncId);
            cs.execute();
            Log.getLogWriter().info(startDBSynchronizer + " for " + asyncDBSyncId);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void startNewDBSynchronizer(Connection conn) {
        try {
            String startDBSynchronizer = "call SYS.START_ASYNC_EVENT_LISTENER( ? )";
            CallableStatement cs = conn.prepareCall(startDBSynchronizer);
            cs.setString(1, asyncDBSyncId.toUpperCase());
            cs.execute();
            Log.getLogWriter().info(startDBSynchronizer + " for " + asyncDBSyncId.toUpperCase());
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_populateTablesDBSynchronizer() {
        sqlTest.populateTablesDBSynchronizer();
    }

    protected void populateTablesDBSynchronizer() {
        Connection gConn = this.getGFEConnection();
        this.populateTables(null, gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_doDMLOpDBSynchronizer() {
        sqlTest.doDMLOpDBSynchronizer();
    }

    protected void doDMLOpDBSynchronizer() {
        Connection gConn = this.getGFEConnection();
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (setTx && isHATest) {
            this.resetNodeFailureFlag();
        }
        if (setTx && testEviction) {
            this.resetEvictionConflictFlag();
        }
        this.doDMLOp(null, gConn);
        this.commit(gConn);
    }

    public static void HydraTask_checkGatewayQueueEmpty() {
        sqlTest.checkGatewayQueueEmpty();
    }

    protected void checkGatewayQueueEmpty() {
        int sleepTime = 10000;
        GemFireCacheImpl cache = Misc.getGemFireCache();
        Set senders = cache.getGatewaySenders();
        for (GatewaySender sender : senders) {
            while (((AbstractGatewaySender)sender).getQueue().size() != 0) {
                Log.getLogWriter().info("region queue for sender " + sender.getId() + " is not drained yet," + " wait for " + sleepTime / 1000 + " sec");
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static void HydraTask_checkAsyncEventQueueEmpty() {
        sqlTest.checkAsyncEventQueueEmpty();
    }

    protected void checkAsyncEventQueueEmpty() {
        int sleepTime = 10000;
        GemFireCacheImpl cache = Misc.getGemFireCache();
        Set queues = cache.getAsyncEventQueues();
        for (AsyncEventQueue queue : queues) {
            AsyncEventQueueImpl queueImpl = (AsyncEventQueueImpl)queue;
            SerialGatewaySenderImpl sender = (SerialGatewaySenderImpl)queueImpl.getSender();
            String regionQueueName = sender.getQueue().getRegion().getName();
            while (sender.getQueue().size() != 0) {
                Log.getLogWriter().info("region queue for " + regionQueueName + " is not drained yet," + " wait for " + sleepTime / 1000 + " sec");
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static void HydraTask_checkAsyncEventQueueEmptyForParallel() {
        sqlTest.checkAsyncEventQueueEmptyForParallel();
    }

    protected void checkAsyncEventQueueEmptyForParallel() {
        int sleepTime = 10000;
        GemFireCacheImpl cache = Misc.getGemFireCache();
        Set queues = cache.getAsyncEventQueues();
        for (AsyncEventQueue queue : queues) {
            AsyncEventQueueImpl queueImpl = (AsyncEventQueueImpl)queue;
            if (queueImpl.getSender() instanceof ParallelGatewaySenderImpl) {
                ParallelGatewaySenderImpl sender = (ParallelGatewaySenderImpl)queueImpl.getSender();
                while (sender.getQueue().size() != 0) {
                    Log.getLogWriter().info("region queue is not drained yet. Queue Size is " + sender.getQueue().size() + " wait for " + sleepTime / 1000 + " sec");
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                continue;
            }
            Log.getLogWriter().info("region queue are not parallel sender queues");
        }
    }

    public static void HydraTask_putLastKeyDBSynchronizer() {
        sqlTest.putLastKeyDBSynchronizer();
    }

    public static void HydraTask_putLastKeyAsyncEventListener() {
        sqlTest.putLastKeyDBSynchronizer();
    }

    protected void putLastKeyDBSynchronizer() {
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.putLastKeyDBSynchronizer(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_putLastKeyOracleDBSynchronizer() throws SQLException {
        sqlTest.putLastKeyOracleDBSynchronizer();
    }

    protected void putLastKeyOracleDBSynchronizer() throws SQLException {
        Connection oraConn = this.getOracleConnection();
        Connection gConn = this.getGFEConnection();
        this.putLastKeyDBSynchronizer(oraConn, gConn);
        this.closeDiscConnection(oraConn);
        this.closeGFEConnection(gConn);
    }

    protected void putLastKeyDBSynchronizer(Connection dConn, Connection gConn) {
        boolean isTicket44009Fixed = true;
        int last_key = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.defaultEmployeesPrimary);
        try {
            String insert_last_key = "insert into default1.employees values (" + last_key + ", null, null, null, null)";
            Log.getLogWriter().info("last_key is " + last_key);
            Statement stmt = gConn.createStatement();
            stmt.execute(insert_last_key);
            this.commit(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        int i = 0;
        block4: while (true) {
            try {
                while (true) {
                    int sleepMs = 30000;
                    MasterController.sleepForMs((int)sleepMs);
                    Log.getLogWriter().info("waiting for " + sleepMs / 1000 + " seconds, before verifying the last_key");
                    if (!isTicket44009Fixed && ++i > 5) {
                        Log.getLogWriter().info("start to verfiy before the last key is put into derby");
                        this.verifyResultSetsDBSynchronizer();
                    }
                    String getLastKey = "select max (eid) as MAXEID from default1.employees";
                    Statement stmt = dConn.createStatement();
                    ResultSet rs = stmt.executeQuery(getLastKey);
                    if (rs.next() && rs.getInt("MAXEID") == last_key) {
                        rs.close();
                        this.commit(dConn);
                        break block4;
                    }
                    Log.getLogWriter().info("last_key not ready yet");
                }
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(dConn, se)) {
                    Log.getLogWriter().info("detected the deadlock, will try it again");
                    continue;
                }
                SQLHelper.handleSQLException(se);
                continue;
            }
            break;
        }
    }

    public static void HydraTask_verifyResultSetsDBSynchronizer() {
        sqlTest.verifyResultSetsDBSynchronizer();
    }

    protected void verifyResultSetsDBSynchronizer() {
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.verifyResultSets(dConn, gConn);
    }

    protected Properties getGemFireProperties() {
        Properties p = GfxdHelper.getConnectionProperties();
        p.setProperty("table-default-partitioned", "true");
        return p;
    }

    protected void createGFEDB() {
        this.createGFXDDB();
    }

    protected void createGFEDBForAccessors() {
        this.createGFXDDBForAccessors();
    }

    protected void createGFEDataStore() {
        HydraVector vec = TestConfig.tab().vecAt(SQLPrms.serverGroups);
        int whichOne = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.dataStoreCount);
        whichOne = whichOne <= vec.size() ? --whichOne : vec.size() - 1;
        String sg = (String)((HydraVector)vec.elementAt(whichOne)).elementAt(0);
        if (sg.startsWith("random")) {
            ArrayList serverGroups = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"serverGroups");
            if (whichOne >= serverGroups.size()) {
                whichOne = random.nextInt(serverGroups.size());
            }
            sg = (String)serverGroups.get(whichOne);
        }
        Properties info = this.getGemFireProperties();
        Log.getLogWriter().info("This data store is in " + sg);
        if (!sg.equals("default")) {
            info.setProperty(SERVERGROUP, sg);
        }
        info.setProperty(HOSTDATA, "true");
        if (workAround49565) {
            info.setProperty(SOCKETLEASETIME, "10000");
        }
        this.startGFXDDB(info);
    }

    protected void createGFETradeCustomers(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table customers (id int, cust_name varchar(100), vol int, since date, addr varchar(100))");
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_initializeNetworkPartitionSettings() {
        networkPartitionDetectionEnabled = TestConfig.tab().booleanAt(FabricServerPrms.enableNetworkPartitionDetection, true);
        Class<SQLTest> clazz = SQLTest.class;
        synchronized (SQLTest.class) {
            if (gemfireCache == null) {
                gemfireCache = Misc.getGemFireCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            String losingPartition = TestConfig.tab().stringAt(SplitBrainPrms.losingPartition);
            losingSideHost = TestConfig.getInstance().getHostDescription(losingPartition).getHostName();
            SplitBrainBB.putLosingSideHost((String)losingSideHost);
            oldFabricServer = FabricServerHelper.getFabricServer();
            Log.getLogWriter().info("Partition on " + losingPartition + " running on " + losingSideHost + " is not expected to survive the network Partition");
            if (RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost)) {
                SplitBrainBB.addExpectForcedDisconnect((int)RemoteTestModule.getMyVmid());
                if (!(RemoteTestModule.getMyClientName().startsWith("accessor") || RemoteTestModule.getMyClientName().startsWith("peerClient") || RemoteTestModule.getMyClientName().startsWith("client"))) {
                    SplitBrainBB.addExpectedReconnectedClient((int)RemoteTestModule.getMyVmid());
                }
            }
            return;
        }
    }

    public Connection getGFEConnection() {
        Connection conn = null;
        if (isEdge) {
            conn = this.getGFXDClientConnection();
            return conn;
        }
        if (!hasTx && setTx) {
            Properties p = new Properties();
            if (!reproduceTicket51628) {
                p.put("sync-commits", "true");
                this.log().info("using connection property : sync-commits set to true");
            }
            try {
                conn = GFEDBManager.getConnection(p);
                this.executeListener("CREATE", "NETWORK_STATE");
                Log.getLogWriter().info("using product default isolation Connection.TRANSACTION_READ_COMMITTED ");
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)se));
            }
        }
        try {
            conn = GFEDBManager.getConnection();
            conn.setTransactionIsolation(0);
            this.log().info("Connection isolation is set to 0 and getTransactionIsolation() is " + conn.getTransactionIsolation());
            this.executeListener("CREATE", "NETWORK_STATE");
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getGFEConnection(Properties info) throws SQLException {
        Connection conn = null;
        try {
            if (isEdge) {
                conn = this.getGFXDClientConnection(info);
            } else {
                conn = GFEDBManager.getConnection(info);
                this.executeListener("CREATE", "NETWORK_STATE");
            }
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            if (e.getSQLState().equalsIgnoreCase("XBM09")) {
                throw e;
            }
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getGFXDClientConnection() {
        Connection conn = null;
        try {
            if (useC3P0 && useGfxdConfig) {
                conn = PooledConnectionC3P0.getConnection();
            } else if (useDBCP && useGfxdConfig) {
                conn = PooledConnectionDBCP.getConnection();
            } else if (useTomcatConnPool & useGfxdConfig) {
                conn = PooledConnectionTomcat.getConnection();
            } else if (!hasTx && setTx) {
                Properties p = new Properties();
                if (!reproduceTicket51628) {
                    p.put("sync-commits", "true");
                    this.log().info("using connection property : sync-commits set to true");
                }
                boolean gotTxnConn = false;
                while (!gotTxnConn) {
                    try {
                        conn = GFEDBClientManager.getConnection(p);
                        gotTxnConn = true;
                    }
                    catch (SQLException se) {
                        if (SQLHelper.gotTXNodeFailureException(se) && isHATest) {
                            Log.getLogWriter().info("failed to get connection due to node failure, need to retry");
                            continue;
                        }
                        SQLHelper.handleSQLException(se);
                    }
                }
                Log.getLogWriter().info("using product default isolation Connection.TRANSACTION_READ_COMMITTED ");
            } else {
                boolean gotTxnNoneConn = false;
                while (!gotTxnNoneConn) {
                    try {
                        conn = GFEDBClientManager.getConnection();
                        conn.setTransactionIsolation(0);
                        gotTxnNoneConn = true;
                    }
                    catch (SQLException se) {
                        if (SQLHelper.gotTXNodeFailureException(se) && isHATest) {
                            Log.getLogWriter().info("set isolation failed on default txn isolation connection, need to retry");
                            continue;
                        }
                        SQLHelper.handleSQLException(se);
                    }
                }
                this.log().info("Connection isolation is set to 0 and getTransactionIsolation() is " + conn.getTransactionIsolation());
            }
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get the connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected Connection getGFXDClientConnection(Properties info) throws SQLException {
        Connection conn = null;
        try {
            conn = GFEDBClientManager.getConnection(info);
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get the connection " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    public void closeGFEConnection(Connection conn) {
        try {
            conn.close();
            this.executeListener("CLOSE", "NETWORK_STATE");
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to release the connection " + TestHelper.getStackTrace((Throwable)e));
        }
    }

    public static void HydraTask_createFunctionToPopulate() {
        sqlTest.createFunctionToPopulate();
    }

    protected void createFunctionToPopulate() {
        Connection gConn = this.getHdfsQueryConnection();
        try {
            FunctionDDLStmt.createFuncPortf(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_populateTables() {
        sqlTest.populateTables();
    }

    protected void populateTables() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        if (useGenericSQL) {
            this.log().info("Calling generic populate table as  useGenericSQL=" + useGenericSQL);
            sqlGen.populateTables(dConn, gConn);
        } else {
            this.populateTables(dConn, gConn);
        }
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_populateCustomersTable() {
        sqlTest.populateCustomersTable();
    }

    protected void populateCustomersTable() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.populateCustomersTable(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void populateCustomersTable(Connection dConn, Connection gConn) {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        new TradeCustomersDMLStmt().populate(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        this.executeListener("CLOSE", "PRINT_CONN");
        SQLHelper.handleMissedSQLException(exList);
    }

    protected void populateTables(Connection dConn, Connection gConn) {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        for (int i = 0; i < dmlTables.length; ++i) {
            if (dmlTables[i] != 13) {
                DMLStmtIF dmlStmt = dmlFactory.createDMLStmt(dmlTables[i]);
                dmlStmt.populate(dConn, gConn);
                this.commit(dConn);
                this.commit(gConn);
                this.executeListener("CLOSE", "PRINT_CONN");
            }
            if (!isSerial || dConn == null) continue;
            this.waitForBarrier();
        }
        SQLHelper.handleMissedSQLException(exList);
    }

    public static void HydraTask_doOp() {
        sqlTest.doOps();
    }

    protected void doOps() {
        boolean dmlOp;
        int num = 10;
        boolean bl = dmlOp = random.nextInt(num) != 0;
        if (dmlOp) {
            this.doDMLOp();
        } else {
            this.doDDLOp();
        }
    }

    public static void HydraTask_doDMLOp() {
        sqlTest.doDMLOp();
    }

    public static void HydraTask_doDDLOp() {
        sqlTest.doDDLOp();
    }

    public static void HydraTask_doDMLOpInInit() {
        sqlTest.doDMLOpInInit();
    }

    protected void doDMLOpInInit() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        int rep = 20;
        for (int i = 0; i < rep; ++i) {
            this.doDMLOp(dConn, gConn);
        }
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    public static void HydraTask_queryOnJoinOp() {
        sqlTest.queryOnJoinOp();
    }

    protected void doDMLOp() {
        if (networkPartitionDetectionEnabled) {
            this.doDMLOp_HandlePartition();
        } else {
            Connection dConn = null;
            if (hasDerbyServer) {
                dConn = this.getDiscConnection();
            }
            Connection gConn = this.getHdfsQueryConnection();
            if (useGenericSQL) {
                sqlGen.doDMLOp(dConn, gConn);
            } else {
                this.doDMLOp(dConn, gConn);
            }
            if (dConn != null) {
                this.closeDiscConnection(dConn);
            }
            this.closeGFEConnection(gConn);
        }
        Log.getLogWriter().info("done dmlOp");
    }

    protected void resetCanceledFlag() {
        boolean[] getCanceled = (boolean[])SQLTest.getCanceled.get();
        if (getCanceled != null && getCanceled[0]) {
            getCanceled[0] = false;
            SQLTest.getCanceled.set((Object)getCanceled);
            Log.getLogWriter().info("getCanceled is reset for new ops");
            Boolean needMoreNode = (Boolean)SQLBB.getBB().getSharedMap().get((Object)NEEDMOREDATANODES);
            if (needMoreNode == null || needMoreNode != null && !needMoreNode.booleanValue()) {
                this.setNeedMoreDataNodes(true);
            }
        }
    }

    protected void resetNodeFailureFlag() {
        boolean[] getNodeFailure = (boolean[])SQLTest.getNodeFailure.get();
        if (getNodeFailure != null && getNodeFailure[0]) {
            getNodeFailure[0] = false;
            SQLTest.getNodeFailure.set((Object)getNodeFailure);
            Log.getLogWriter().info("getNodeFailure is reset for new ops");
        }
    }

    protected void resetEvictionConflictFlag() {
        boolean[] getEvictionConflict = (boolean[])SQLTest.getEvictionConflict.get();
        if (getEvictionConflict != null && getEvictionConflict[0]) {
            getEvictionConflict[0] = false;
            SQLTest.getEvictionConflict.set((Object)getEvictionConflict);
            Log.getLogWriter().info("getEvictionConflict is reset for new ops");
        }
    }

    public void doDMLOp_HandlePartition() {
        Log.getLogWriter().info("performing dmlOp, myTid is " + this.getMyTid());
        int table = dmlTables[random.nextInt(dmlTables.length)];
        DMLStmtIF dmlStmt = dmlFactory.createDMLStmt(table);
        int numOfOp = random.nextInt(5) + 1;
        int size = 1;
        Connection dConn = null;
        try {
            if (hasDerbyServer) {
                dConn = this.getDiscConnection();
            }
            Connection gConn = this.getHdfsQueryConnection();
            String operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations);
            if (operation.equals("insert")) {
                for (int i = 0; i < numOfOp; ++i) {
                    if (setCriticalHeap) {
                        this.resetCanceledFlag();
                    }
                    if (setTx && isHATest) {
                        this.resetNodeFailureFlag();
                    }
                    if (setTx && testEviction) {
                        this.resetEvictionConflictFlag();
                    }
                    dmlStmt.insert(dConn, gConn, size);
                    this.commit(dConn);
                    this.commit(gConn);
                }
            } else if (operation.equals("put")) {
                for (int i = 0; i < numOfOp; ++i) {
                    if (setCriticalHeap) {
                        this.resetCanceledFlag();
                    }
                    if (setTx && isHATest) {
                        this.resetNodeFailureFlag();
                    }
                    if (setTx && testEviction) {
                        this.resetEvictionConflictFlag();
                    }
                    dmlStmt.put(dConn, gConn, size);
                    this.commit(dConn);
                    this.commit(gConn);
                }
            } else if (operation.equals("update")) {
                for (int i = 0; i < numOfOp; ++i) {
                    if (setCriticalHeap) {
                        this.resetCanceledFlag();
                    }
                    if (setTx && isHATest) {
                        this.resetNodeFailureFlag();
                    }
                    if (setTx && testEviction) {
                        this.resetEvictionConflictFlag();
                    }
                    dmlStmt.update(dConn, gConn, size);
                    this.commit(dConn);
                    this.commit(gConn);
                }
            } else if (operation.equals("delete")) {
                if (setCriticalHeap) {
                    this.resetCanceledFlag();
                }
                if (setTx && isHATest) {
                    this.resetNodeFailureFlag();
                }
                if (setTx && testEviction) {
                    this.resetEvictionConflictFlag();
                }
                dmlStmt.delete(dConn, gConn);
            } else if (operation.equals("query")) {
                if (setCriticalHeap) {
                    this.resetCanceledFlag();
                }
                if (setTx && isHATest) {
                    this.resetNodeFailureFlag();
                }
                if (setTx && testEviction) {
                    this.resetEvictionConflictFlag();
                }
                dmlStmt.query(dConn, gConn);
            } else {
                throw new TestException("Unknown entry operation: " + operation);
            }
            this.commit(dConn);
            this.commit(gConn);
            if (dConn != null) {
                this.closeDiscConnection(dConn);
            }
            this.closeGFEConnection(gConn);
        }
        catch (Throwable t) {
            boolean networkPartitionHappened;
            boolean forcedDisconnect = ((GemFireCacheImpl)gemfireCache).forcedDisconnect();
            Throwable disconnectCause = ((GemFireCacheImpl)gemfireCache).getDisconnectCause();
            String disconnectException = "com.gemstone.gemfire.ForcedDisconnectException";
            Log.getLogWriter().info("ForcedDisconnect:" + forcedDisconnect);
            Log.getLogWriter().info("DisconnectCause: " + ((GemFireCacheImpl)gemfireCache).getDisconnectCause());
            boolean bl = networkPartitionHappened = t.toString().indexOf("has declared that a network partition has occurred") != -1;
            if (!(forcedDisconnect && disconnectCause != null && disconnectCause.toString().indexOf(disconnectException) >= 0 || networkPartitionHappened)) {
                Log.getLogWriter().info("My clientName= " + RemoteTestModule.getMyClientName());
                if (RemoteTestModule.getMyClientName().contains("accessor")) {
                    Log.getLogWriter().info("This is accessor node. Check if the No DatastoreException is expected");
                    boolean expectNoDatastoreExceptionOnAccessor = TestConfig.tab().booleanAt(SplitBrainPrms.expectNoDatastoreExceptionOnAccessor, false);
                    if (expectNoDatastoreExceptionOnAccessor) {
                        Log.getLogWriter().info("Checking if the exception is caused by no datastore found.");
                        if (t.toString().contains("No Datastore found in the Distributed System")) {
                            Log.getLogWriter().info("the exception is caused by no datastore found.");
                            Log.getLogWriter().info("Hit the expected exception No Datastore found in the Distributed System");
                            throw new StopSchedulingTaskOnClientOrder("Network partition has happened and accessor has Hit the expected exception No Datastore found in the Distributed System");
                        }
                    }
                }
                throw new TestException("Following error occurred while executing " + t.toString());
            }
            SplitBrainBB.addDisconnectedClient((int)RemoteTestModule.getMyVmid());
            if (!RemoteTestModule.getMyHost().equalsIgnoreCase(losingSideHost)) {
                throw new TestException("This VM is not supposed to get forced disconnect exception");
            }
            throw new StopSchedulingTaskOnClientOrder("Network partition has happened");
        }
    }

    public static void HydraTask_checkForceDisconnect() {
        boolean forcedDisconnect = ((GemFireCacheImpl)gemfireCache).forcedDisconnect();
        Throwable disconnectCause = ((GemFireCacheImpl)gemfireCache).getDisconnectCause();
        if (forcedDisconnect || disconnectCause != null) {
            SplitBrainBB.addDisconnectedClient((int)RemoteTestModule.getMyVmid());
            throw new StopSchedulingTaskOnClientOrder("Network partition has happened");
        }
        MasterController.sleepForMs((int)5000);
    }

    public static synchronized void HydraTask_verifyLosingPartition() {
        Set disconnectedClients = SplitBrainBB.getForcedDisconnectList();
        Set expectedDisconnectList = SplitBrainBB.getExpectForcedDisconnects();
        StringBuffer aStr = new StringBuffer();
        if (!disconnectedClients.equals(expectedDisconnectList)) {
            aStr.append("Expected forcedDisconnects in clientVms [ " + expectedDisconnectList + " ] but the following clientVms had forcedDisconnects [" + disconnectedClients + "]\n");
        } else {
            Log.getLogWriter().info("All expected clientVms in losing partition were forcefully disconnected [ " + disconnectedClients + " ].  No other vms were forcibly disconnected\n");
        }
        try {
            TestHelper.checkForEventError((Blackboard)SplitBrainBB.getBB());
        }
        catch (TestException te) {
            aStr.append("Listener encountered exceptions, first Exception = \n" + (Object)((Object)te));
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
    }

    protected boolean waitForReconnect() {
        boolean reconnected = false;
        for (int i = 0; i < 3; ++i) {
            if (oldFabricServer.isReconnecting()) {
                Log.getLogWriter().info("Fabric server is reconnecting");
                try {
                    reconnected = oldFabricServer.waitUntilReconnected(4L, TimeUnit.MINUTES);
                    continue;
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            if (i + 1 < 3) {
                Log.getLogWriter().info("Fabric server was not in a reconnecting state");
                Log.getLogWriter().info("Looping and waiting for 30 secs to see if it goes into reconnecting state.");
                try {
                    Thread.sleep(30000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new TestException(e.toString());
                }
            }
            Log.getLogWriter().info("Fabric server never went into reconnecting state");
            Log.getLogWriter().info("Continuing test with assumption that it already got reconnected.");
            reconnected = true;
        }
        return oldFabricServer.status().compareTo((Enum)FabricService.State.RUNNING) == 0;
    }

    public static synchronized void HydraTask_waitForReconnect() {
        boolean reconnected = sqlTest.waitForReconnect();
        if (reconnected) {
            SplitBrainBB.addReconnectedClient((int)RemoteTestModule.getMyVmid());
        } else if (!(RemoteTestModule.getMyClientName().startsWith("accessor") || RemoteTestModule.getMyClientName().startsWith("peerClient") || RemoteTestModule.getMyClientName().startsWith("client"))) {
            throw new TestException("Wait for reconnect returned false");
        }
    }

    public static synchronized void HydraTask_verifyReconnect() {
        Set expectedReconnectList = SplitBrainBB.getExpectedReconnectList();
        Set reconnectedClients = SplitBrainBB.getReconnectedList();
        StringBuffer aStr = new StringBuffer();
        if (!expectedReconnectList.equals(reconnectedClients)) {
            aStr.append("Expected all clients to reconnect but only these did: " + reconnectedClients + ".   expected list is " + expectedReconnectList + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        sqlTest.reconnected();
    }

    public static void HydraTask_verifyDMLExecution() {
        SQLTest.HydraTask_doDMLOp();
    }

    protected void reconnected() {
        Connection gConn;
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        if ((gConn = this.getHdfsQueryConnection()) == null || hasDerbyServer && dConn == null) {
            throw new TestException("After reconnect connections were found to be null. dConn =  " + dConn + " gConn = " + gConn);
        }
    }

    protected void doDMLOp(Connection dConn, Connection gConn) {
        Log.getLogWriter().info("doDMLOp-performing dmlOp, myTid is " + this.getMyTid());
        int table = dmlTables[random.nextInt(dmlTables.length)];
        DMLStmtIF dmlStmt = dmlFactory.createDMLStmt(table);
        int numOfOp = random.nextInt(5) + 1;
        int size = 1;
        String operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations);
        Log.getLogWriter().info("doDMLOp-operation=" + operation + "  numOfOp=" + numOfOp);
        if (hasPortfolioV1) {
            Boolean value;
            if (!portfoliov1IsReady && (value = (Boolean)SQLBB.getBB().getSharedMap().get((Object)PORTFOLIOV1READY)) != null) {
                portfoliov1IsReady = value;
                Log.getLogWriter().info("portfoliov1IsReady is set to " + portfoliov1IsReady);
            }
            if (!portfoliov1IsReady && table == 13) {
                Log.getLogWriter().info("Trade.portfoliov1 is not ready yet, abort this op");
                return;
            }
            if (portfoliov1IsReady && table == 3 && (operation.equals("insert") || operation.equals("put") || operation.equals("update") || operation.equals("delete"))) {
                Log.getLogWriter().info("Table 'TRADE.PORTFOLIO' has been dropped and View 'TRADE.PORTFOLIO' is not updatable");
                return;
            }
        }
        if (operation.equals("insert")) {
            for (int i = 0; i < numOfOp; ++i) {
                if (setCriticalHeap) {
                    this.resetCanceledFlag();
                }
                if (setTx && isHATest) {
                    this.resetNodeFailureFlag();
                }
                if (setTx && testEviction) {
                    this.resetEvictionConflictFlag();
                }
                dmlStmt.insert(dConn, gConn, size);
                if (setTx && isHATest) {
                    this.commit(gConn);
                    this.commit(dConn);
                    return;
                }
                this.commit(dConn);
                this.commit(gConn);
            }
        } else if (operation.equals("put")) {
            for (int i = 0; i < numOfOp; ++i) {
                if (setCriticalHeap) {
                    this.resetCanceledFlag();
                }
                if (setTx && isHATest) {
                    this.resetNodeFailureFlag();
                }
                if (setTx && testEviction) {
                    this.resetEvictionConflictFlag();
                }
                dmlStmt.put(dConn, gConn, size);
                if (setTx && isHATest) {
                    this.commit(gConn);
                    this.commit(dConn);
                    return;
                }
                this.commit(dConn);
                this.commit(gConn);
            }
        } else if (operation.equals("update")) {
            for (int i = 0; i < numOfOp; ++i) {
                if (setCriticalHeap) {
                    this.resetCanceledFlag();
                }
                if (setTx && isHATest) {
                    this.resetNodeFailureFlag();
                }
                if (setTx && testEviction) {
                    this.resetEvictionConflictFlag();
                }
                dmlStmt.update(dConn, gConn, size);
                if (setTx && isHATest) {
                    this.commit(gConn);
                    this.commit(dConn);
                    return;
                }
                this.commit(dConn);
                this.commit(gConn);
            }
        } else if (operation.equals("delete")) {
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            if (setTx && isHATest) {
                this.resetNodeFailureFlag();
            }
            if (setTx && testEviction) {
                this.resetEvictionConflictFlag();
            }
            dmlStmt.delete(dConn, gConn);
            if (setTx && isHATest) {
                this.commit(gConn);
                this.commit(dConn);
                return;
            }
        } else if (operation.equals("query")) {
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            if (setTx && isHATest) {
                this.resetNodeFailureFlag();
            }
            if (setTx && testEviction) {
                this.resetEvictionConflictFlag();
            }
            dmlStmt.query(dConn, gConn);
            if (setTx && isHATest) {
                this.commit(gConn);
                this.commit(dConn);
                return;
            }
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        this.commit(dConn);
        this.commit(gConn);
    }

    public static void HydraTask_createIndex() {
        sqlTest.createIndex();
    }

    protected void createIndex() {
        Connection gConn = this.getGFEConnection();
        this.createIndex(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void createIndex(Connection conn) {
        if (createIndex) {
            IndexDDLStmt indexStmt = new IndexDDLStmt();
            indexStmt.doDDLOp(null, conn);
        }
    }

    protected void doDDLOp() {
        Log.getLogWriter().info("performing ddlOp, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (setTx && isHATest) {
            this.resetNodeFailureFlag();
        }
        if (setTx && testEviction) {
            this.resetEvictionConflictFlag();
        }
        this.doDDLOp(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done ddlOp");
    }

    protected void doDDLOp(Connection dConn, Connection gConn) {
        int ddl = ddls[random.nextInt(ddls.length)];
        DDLStmtIF ddlStmt = ddlFactory.createDDLStmt(ddl);
        ddlStmt.doDDLOp(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
    }

    protected void queryOnJoinOp() {
        Log.getLogWriter().info("performing queryOnJoin, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (setTx && isHATest) {
            this.resetNodeFailureFlag();
        }
        if (setTx && testEviction) {
            this.resetEvictionConflictFlag();
        }
        this.queryOnJoinOp(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    protected void queryOnJoinOp(Connection dConn, Connection gConn) {
        int[] joinTables = SQLPrms.getJoinTables();
        int join = joinTables[random.nextInt(joinTables.length)];
        JoinTableStmtIF joinQueryStmt = joinFactory.createQueryStmt(join);
        joinQueryStmt.query(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
    }

    public static void HydraTask_simpleTest() {
        sqlTest.simpleTest();
    }

    protected void simpleTest() {
        Connection conn = this.getGFEConnection();
        ResultSet rs = this.getQuery(conn);
        SQLHelper.closeResultSet(rs, conn);
        this.closeGFEConnection(conn);
    }

    protected ResultSet getQuery(Connection conn) {
        ResultSet rs1 = null;
        String queryString = "select * from trade.customers where (cid >= ?)";
        try {
            PreparedStatement query1 = conn.prepareStatement(queryString);
            query1.setInt(1, 0);
            rs1 = query1.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return rs1;
    }

    protected boolean verifyResultSets(ResultSet rs1, ResultSet rs2) {
        return ResultSetHelper.compareResultSets(rs1, rs2);
    }

    protected void cleanConnection(Connection gConn) {
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void verifyResultSets() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verification of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            this.cleanConnection(this.getGFEConnection());
            return;
        }
        Connection gConn = null;
        gConn = this.getHdfsQueryConnection();
        if (setTx && isHATest) {
            this.resetNodeFailureFlag();
        }
        Connection dConn = this.getDiscConnection();
        this.verifyResultSets(dConn, gConn);
        if (verifyUsingOrderBy) {
            this.dumpHeap();
        }
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_VerifyResultSetsStandalone() {
        sqlTest.verifyResultSetsStandalone();
    }

    public void verifyResultSetsStandalone() {
        boolean throwException = false;
        String hostName = TestConfig.tab().stringAt(SQLPrms.host);
        String port = TestConfig.tab().stringAt(SQLPrms.port);
        StringBuffer str = new StringBuffer();
        String schemaTableName = null;
        String selectQuery = "select * from ";
        try {
            Connection gConn = DriverManager.getConnection("jdbc:gemfirexd://" + hostName + ":" + port + "/");
            String query1 = "select tableschemaname, tablename from sys.systables where tabletype = 'T' and tableschemaname != 'SYSSTAT' and tablename like '%_TMP'";
            String query2 = "select tableschemaname, tablename from sys.systables where tabletype = 'T' and tableschemaname != 'SYSSTAT' and tablename not like '%_TMP'";
            ArrayList<String[]> tables = this.getTableNames(gConn, query1);
            for (String[] table : tables) {
                try {
                    Log.getLogWriter().info("verifyResultSets-verifyResultSets-schema " + table[0] + " and table " + table[1]);
                    schemaTableName = table[0] + "." + table[1];
                    this.compareResults(gConn, selectQuery + schemaTableName, selectQuery + schemaTableName.replace("_TMP", ""), schemaTableName, schemaTableName.replace("_TMP", ""));
                }
                catch (TestException te) {
                    Log.getLogWriter().info("verifyResultSets-do not throw Exception yet, until all tables are verified");
                    throwException = true;
                    str.append(te.getMessage() + "\n");
                }
            }
            if (throwException) {
                throw new TestException("verifyResultSets-verify results failed: " + str);
            }
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get connection " + TestHelper.getStackTrace((Throwable)e));
        }
    }

    protected void verifyResultSets(Connection dConn, Connection gConn) {
        if (dConn == null) {
            Log.getLogWriter().info("Connection to disc db is null, could not verify results");
            return;
        }
        boolean throwException = false;
        StringBuffer str = new StringBuffer();
        ArrayList<String[]> tables = this.getTableNames(gConn);
        for (String[] table : tables) {
            try {
                Log.getLogWriter().info("verifyResultSets-verifyResultSets-schema " + table[0] + " and table " + table[1]);
                this.verifyResultSets(dConn, gConn, table[0], table[1]);
            }
            catch (TestException te) {
                if (verifyUsingOrderBy) {
                    throw te;
                }
                Log.getLogWriter().info("verifyResultSets-do not throw Exception yet, until all tables are verified");
                throwException = true;
                str.append(te.getMessage() + "\n");
            }
        }
        if (throwException) {
            throw new TestException("verifyResultSets-verify results failed: " + str);
        }
    }

    protected void jsonVerification(Connection gConn) {
        boolean throwException = false;
        StringBuffer str = new StringBuffer();
        String[] tables = SQLPrms.getTableNames();
        int i = 0;
        for (String table : tables) {
            try {
                ResultSet tableRs;
                ResultSet jsonRs;
                Log.getLogWriter().info("verifyResultSets-verify JSON Column with remaining column Data for  " + table);
                String jsonSelect = "select " + this.getAllColumnsFromJson(gConn, table) + " from " + tables;
                String tableSelect = "select " + this.getAllColumnsExceptJson(gConn, table) + " from " + table;
                Log.getLogWriter().info("json select is " + jsonSelect + " and table select is " + tableSelect);
                try {
                    jsonRs = gConn.createStatement().executeQuery(jsonSelect);
                    tableRs = gConn.createStatement().executeQuery(tableSelect);
                }
                catch (SQLException se) {
                    throw new TestException(TestHelper.getStackTrace((Throwable)se));
                }
                ResultSetHelper.compareResultSets(ResultSetHelper.asList(jsonRs, false), ResultSetHelper.asList(tableRs, false), "JSON columns ", table + " columns");
            }
            catch (TestException te) {
                Log.getLogWriter().info("verifyResultSets-do not throw Exception yet, until all tables are verified");
                throwException = true;
                str.append(te.getMessage() + "\n");
            }
            ++i;
        }
        if (throwException) {
            throw new TestException("verifyResultSets-verify results failed: " + str);
        }
    }

    protected Connection getHdfsQueryConnection() {
        Connection gConn;
        if (hasHdfs) {
            try {
                Properties info = new Properties();
                info.setProperty("query-HDFS", "true");
                gConn = this.getGFEConnection(info);
                Log.getLogWriter().info("Get gfxd connection with properties=" + info + ", connection=" + gConn);
            }
            catch (SQLException e) {
                throw new TestException("Not able to get connection with query-HDFS=true connection property " + TestHelper.getStackTrace((Throwable)e));
            }
        } else {
            gConn = this.getGFEConnection();
        }
        return gConn;
    }

    public static void HydraTask_verifyNonEvictDestroyTablesResultSets() {
        sqlTest.verifyNonEvictDestroyTablesResultSets();
    }

    protected void verifyNonEvictDestroyTablesResultSets() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verification of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            this.cleanConnection(this.getGFEConnection());
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.verifyNonEvictDestroyTablesResultSets(dConn, gConn);
    }

    protected void verifyNonEvictDestroyTablesResultSets(Connection dConn, Connection gConn) {
        if (dConn == null) {
            Log.getLogWriter().info("Connection to disc db is null, could not verify results");
            return;
        }
        boolean throwException = false;
        StringBuffer str = new StringBuffer();
        ArrayList<String[]> tables = this.getTableNames(gConn);
        for (String[] table : tables) {
            try {
                Log.getLogWriter().info("schema " + table[0] + " and table " + table[1]);
                if (!table[1].equalsIgnoreCase("customers") && !table[1].equalsIgnoreCase("securities") && !table[1].equalsIgnoreCase("portfolio")) continue;
                this.verifyResultSets(dConn, gConn, table[0], table[1]);
            }
            catch (TestException te) {
                Log.getLogWriter().info("do not throw Exception yet, until all tables are verified");
                throwException = true;
                str.append(te.getMessage() + "\n");
            }
        }
        if (throwException) {
            throw new TestException("verify results failed: " + str);
        }
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void verifyResultSets(Connection dConn, Connection gConn, String schema, String table) {
        String select = null;
        String finalSelectQuery = null;
        select = alterTableDropColumn ? this.getSelectWithDroppedColumns(gConn, schema, table) : (!table.equalsIgnoreCase("companies") ? (setIdentityColumn ? (table.equalsIgnoreCase("securities") ? "select sec_id, symbol, price, exchange, tid from " + schema + "." + table : (hasJSON ? "select " + this.getAllColumnsExceptJson(gConn, schema + "." + table) + "  from " + schema + "." + table : "select * from " + schema + "." + table)) : (hasJSON ? "select " + this.getAllColumnsExceptJson(gConn, schema + "." + table) + "  from " + schema + "." + table : "select * from " + schema + "." + table)) : "select symbol, exchange, companytype,  uid, uuid, companyname, companyinfo, note, histPrice, asset, logo, tid from " + schema + "." + table);
        if (table.equalsIgnoreCase("companies")) {
            int base = 5;
            int maxiumWanSites = 5;
            if (numOfWorkers <= base) throw new TestException("Test needs to have more than " + base + " of workers");
            String sql = null;
            for (int i = 0; i < (isWanTest ? maxiumWanSites * numOfWorkers : numOfWorkers) / base; ++i) {
                sql = select + " where tid >= " + base * i + " and tid < " + base * (i + 1);
                this.verifyResultSets(dConn, gConn, schema, table, sql, hasHdfs);
            }
            sql = select + " where tid >= " + base * (numOfWorkers / base);
            this.verifyResultSets(dConn, gConn, schema, table, sql, hasHdfs);
        } else {
            if (verifyByTid) {
                finalSelectQuery = select;
                select = select + " where tid = " + this.getMyTid();
            }
            this.verifyResultSets(dConn, gConn, schema, table, select, hasHdfs);
        }
        boolean verifyIndex = TestConfig.tab().booleanAt(SQLPrms.verifyIndex, false);
        if (verifyIndex && !table.equalsIgnoreCase("companies")) {
            if (verifyByTid) {
                select = finalSelectQuery;
            }
            Log.getLogWriter().info("Verify data using index for " + schema + "." + table);
            if (verifyByTid && this.getMyTid() == 0 || !verifyByTid) {
                this.verifyIndexResultSet(dConn, gConn, schema, table, select);
            }
        }
        if (!ticket45938fixed && hasTx) {
            Log.getLogWriter().info("avoid hitting #45938, continue testing");
            return;
        }
        select = "select count (*) from " + schema + "." + table;
        if (verifyByTid && this.getMyTid() == 0 || !verifyByTid) {
            this.verifyResultSets(dConn, gConn, schema, table, select, hasHdfs);
        }
        if (!verifyUsingOrderBy || !table.contains("customers".toUpperCase()) && !table.contains("networth".toUpperCase())) return;
        this.dumpHeap();
    }

    protected void dumpHeap() {
        String fn = null;
        String dir = TestConfig.getInstance().getClientDescription(RemoteTestModule.getMyClientName()).getVmDescription().getHostDescription().getUserDir();
        int pid = RemoteTestModule.getMyPid();
        fn = HostHelper.getLocalHostOS() == HostHelper.OSType.unix ? dir + "/java_" + HostHelper.getLocalHost() + "_" + pid + ".hprof" : dir + "\\java_" + HostHelper.getLocalHost() + "_" + pid + ".hprof";
        Log.getLogWriter().info("fn is " + fn);
        File f = new File(fn);
        if (f.exists()) {
            Log.getLogWriter().info("Deleting " + fn);
        }
        if (f.delete()) {
            Log.getLogWriter().info("Deleted " + fn);
        }
        ProcessMgr.dumpHeap((String)HostHelper.getIPAddress().getHostName(), (int)pid, (String)dir, null);
    }

    private String getAllColumnsExceptJson(Connection conn, String tableName) {
        String columnNameList = "";
        List<String[]> columnList = this.getColumnNameAndType(conn, tableName.split("\\.")[0], tableName.split("\\.")[1]);
        for (String[] columnDetails : columnList) {
            if (columnDetails[0].toLowerCase().contains("json")) continue;
            columnNameList = columnNameList + columnDetails[0] + " ";
        }
        columnNameList = columnNameList.trim().replace(" ", ",");
        return columnNameList;
    }

    private String getAllColumnsFromJson(Connection conn, String tableName) {
        String columnNameList = "";
        List<String[]> columnList = this.getColumnNameAndType(conn, tableName.split("\\.")[0], tableName.split("\\.")[1]);
        for (String[] columnDetails : columnList) {
            if (columnDetails[0].equalsIgnoreCase("json_details")) continue;
            columnNameList = columnNameList + "cast(json_fetchAttribute(json_details, '" + columnDetails[0] + "') as " + columnDetails[1] + ") as " + columnDetails[0] + "#";
        }
        columnNameList = columnNameList.trim().replace("#", ",");
        return columnNameList;
    }

    protected void verifyResultSets(Connection dConn, Connection gConn, String schema, String table, String select, boolean hasHdfs) {
        if (hasHdfs) {
            Map hdfsExtnMap = (Map)SQLBB.getBB().getSharedMap().get((Object)"hdfsExtnParams");
            String key = schema.toUpperCase() + "." + table.toUpperCase() + "EVICTIONCRITERIA";
            String selectOperational = select;
            String selectNonOperational = select;
            if (hdfsExtnMap.get(key) != null) {
                if (hasJSON && (select.toLowerCase().contains("securities") || select.toLowerCase().contains("buyorder"))) {
                    selectOperational = select + " where 1 =2 ";
                } else {
                    selectOperational = select + " where " + hdfsSqlTest.getReversedSqlPredicate((String)hdfsExtnMap.get(key));
                    selectNonOperational = select + " where " + (String)hdfsExtnMap.get(key);
                }
                this.log().info("verifyResultSets-Verifying Operational Data with " + selectOperational);
                this.verifyResultSets(dConn, gConn, schema, table, selectOperational);
                this.log().info("verifyResultSets-Verifying Non Operational Data with " + selectNonOperational);
                this.verifyResultSets(dConn, gConn, schema, table, selectNonOperational);
            } else {
                boolean queryHDFS = TestConfig.tab().booleanAt(SQLPrms.queryHDFSWhileVerifyingResults, true);
                if (!queryHDFS) {
                    select = select + "  -- GEMFIREXD-PROPERTIES queryHDFS=false";
                }
                this.verifyResultSets(dConn, gConn, schema, table, select);
            }
        } else {
            if (verifyUsingOrderBy && !select.contains("select count")) {
                select = select + this.getOrderByClause(gConn, schema, table);
            }
            this.verifyResultSets(dConn, gConn, schema, table, select);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void verifyResultSets(Connection dConn, Connection gConn, String schema, String table, String select) {
        block15: {
            gRS = null;
            try {
                this.log().info("verifyResultSets-executing " + select + " in derby");
                dRS = dConn.createStatement().executeQuery(select);
                this.log().info("verifyResultSets-executed " + select + " in derby");
                try {
                    this.log().info("verifyResultSets-executing " + select + " in gfxd");
                    gRS = gConn.createStatement().executeQuery(select);
                    this.log().info("verifyResultSets-executed " + select + " in gfxd");
                    ** GOTO lbl22
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    if (!SQLHelper.checkGFXDException(gConn, se)) {
                        Log.getLogWriter().info("could not get resultset due to HA");
                        dRS.close();
                        SQLHelper.closeResultSet(gRS, gConn);
                        this.commit(dConn);
                        this.commit(gConn);
                        return;
                    }
                    SQLHelper.handleSQLException(se);
lbl22:
                    // 2 sources

                    if (SQLTest.useWriterForWriteThrough && table.equalsIgnoreCase("txhistory")) {
                        ResultSetHelper.compareDuplicateResultSets(dRS, gRS);
                    }
                    if (SQLTest.isHATest && !SQLTest.setTx && table.equalsIgnoreCase("txhistory") && SQLHelper.isThinClient(gConn)) {
                        Log.getLogWriter().info("will not compare results for table without primary key in HA test when using thin client driver to avoid #44929");
                    }
                    if (SQLTest.isHATest && table.equalsIgnoreCase("txhistory") && SQLTest.hasAsyncDBSync) {
                        Log.getLogWriter().info("will not compare results for the table without primary key in HA test when using dbsync to avoid #45696");
                    }
                    if (SQLTest.verifyUsingOrderBy) {
                        ResultSetHelper.compareSortedResultSets(dRS, gRS);
                    }
                    if (SQLTest.alterTableDropColumn) {
                        ResultSetHelper.compareResultSets(dRS, gRS);
                    }
                    if (SQLTest.hasTx && this.needNewConnection() && gRS == null) {
                        Log.getLogWriter().info("will not compare results -- failed to get results in gfxd due to node failure");
                    }
                    ResultSetHelper.compareResultSets(dRS, gRS);
                }
                SQLHelper.closeResultSet(gRS, gConn);
                this.commit(dConn);
                this.commit(gConn);
                break block15;
                {
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                }
            }
            finally {
                SQLHelper.closeResultSet(gRS, gConn);
                this.commit(dConn);
                this.commit(gConn);
            }
        }
    }

    protected void verifyIndexResultSet(Connection dConn, Connection gConn, String schema, String table, String select) {
        String sql = null;
        List<String[]> colInfo = this.getColumnNameAndType(gConn, schema, table);
        if (colInfo.size() == 0 && setCriticalHeap) {
            boolean[] getCanceled = (boolean[])SQLTest.getCanceled.get();
            if (getCanceled != null && getCanceled[0]) {
                this.log().info("could not get column info from the table due to critical heap cancelled event, abort this op");
                return;
            }
            throw new TestException("could not get column info from metadata");
        }
        int whichCol1 = random.nextInt(colInfo.size());
        int whichCol2 = (whichCol1 + 1) % colInfo.size();
        int whichCol3 = random.nextInt(colInfo.size());
        String colName1 = colInfo.get(whichCol1)[0];
        String colName2 = colInfo.get(whichCol2)[0];
        String colName3 = colInfo.get(whichCol3)[0];
        int colType1 = Integer.valueOf(colInfo.get(whichCol1)[1]);
        int colType2 = Integer.valueOf(colInfo.get(whichCol2)[1]);
        String crtria1 = colName1 + this.getCriteriaForType(colType1);
        String crtria2 = colName2 + this.getCriteriaForType(colType2);
        sql = verifyByTid ? "select " + colName1 + "," + colName2 + "," + colName3 + " from  " + schema + "." + table + " where " + crtria1 + " and " + crtria2 : select + " where " + crtria1 + " or " + crtria2;
        if (verifyUsingOrderBy && !sql.contains("select count")) {
            sql = sql + this.getOrderByClause(gConn, schema, table);
        }
        this.verifyResultSets(dConn, gConn, schema, table, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectWithDroppedColumns(Connection conn, String schema, String table) {
        String sql = "select * from " + schema + "." + table;
        StringBuilder select = new StringBuilder();
        select.append("select ");
        ResultSet rs = null;
        try {
            rs = conn.createStatement().executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numColumns = rsmd.getColumnCount();
            for (int i = 1; i < numColumns + 1; ++i) {
                if (i < numColumns) {
                    select.append(rsmd.getColumnName(i) + ", ");
                    continue;
                }
                select.append(rsmd.getColumnName(i) + " ");
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            SQLHelper.closeResultSet(rs, conn);
        }
        select.append("from " + schema + "." + table);
        return select.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getOrderByClause(Connection conn, String schema, String table) {
        StringBuilder orderby = new StringBuilder();
        orderby.append(" order by ");
        ResultSet rs = null;
        try {
            if (table.equalsIgnoreCase("txhistory")) {
                String sql = "select * from " + schema + "." + table;
                rs = conn.createStatement().executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                int numColumns = rsmd.getColumnCount();
                for (int i = 1; i < numColumns + 1; ++i) {
                    orderby.append(rsmd.getColumnName(i) + ", ");
                }
            } else {
                DatabaseMetaData dbmd = conn.getMetaData();
                rs = dbmd.getPrimaryKeys(null, schema, table);
                ArrayList<String> primaryKeyColumns = new ArrayList<String>();
                while (rs.next()) {
                    String columnName = rs.getString(4);
                    orderby.append(columnName + ", ");
                    primaryKeyColumns.add(columnName);
                }
            }
            SQLHelper.closeResultSet(rs, conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            SQLHelper.closeResultSet(rs, conn);
        }
        orderby.deleteCharAt(orderby.lastIndexOf(","));
        return orderby.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String[]> getColumnNameAndType(Connection conn, String schema, String table) {
        ArrayList<String[]> colList = new ArrayList<String[]>();
        String sql = "select * from " + schema + "." + table + " where 1=0";
        ResultSet rs = null;
        try {
            rs = conn.createStatement().executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numColumns = rsmd.getColumnCount();
            for (int i = 1; i < numColumns + 1; ++i) {
                String[] c = new String[]{rsmd.getColumnName(i), rsmd.getColumnType(i) + ""};
                colList.add(c);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            SQLHelper.closeResultSet(rs, conn);
        }
        return colList;
    }

    protected String getCriteriaForType(int type) {
        switch (type) {
            case 4: {
                return " >= 0 ";
            }
            case 3: {
                return " >= 0.0 ";
            }
            case 12: {
                return " != 'abcxyx' ";
            }
            case 1: {
                return " != 'abcxyx' ";
            }
            case 91: {
                return " <= CURRENT_DATE ";
            }
            case 92: {
                return " <= CURRENT_TIME ";
            }
            case 93: {
                return " <= CURRENT_TIMESTAMP ";
            }
        }
        return " >= 0 ";
    }

    public static void HydraTask_verifyResultSets() {
        sqlTest.verifyResultSets();
    }

    public static void HydraTask_clearTables() {
        sqlTest.clearTables();
    }

    public static void HydraTask_clearTablesInOrder() {
        sqlTest.clearTablesInOrder();
    }

    protected void clearTables() {
        if (!hasDerbyServer) {
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        if (random.nextBoolean() && hasNetworth) {
            this.clearTablesInOrder(dConn, gConn);
        } else {
            this.clearTables(dConn, gConn);
        }
        this.commit(dConn);
        this.commit(gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void clearTablesInOrder() {
        if (!hasDerbyServer) {
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.clearTablesInOrder(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void clearTablesInOrder(Connection dConn, Connection gConn) {
        this.clearTables(dConn, gConn, "trade", "buyorders");
        this.clearTables(dConn, gConn, "trade", "txhistory");
        this.clearTables(dConn, gConn, "trade", "sellorders");
        this.clearTables(dConn, gConn, "trade", "portfolio");
        this.clearTables(dConn, gConn, "trade", "networth");
        this.clearTables(dConn, gConn, "trade", "customers");
        this.clearTables(dConn, gConn, "trade", "securities");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTables(Connection dConn, Connection gConn) {
        if (dConn == null) {
            return;
        }
        ResultSet rs = null;
        try {
            rs = gConn.createStatement().executeQuery("select tableschemaname, tablename from sys.systables where tabletype = 'T' and tableschemaname != 'SYSSTAT' ");
            if (!setTx) {
                while (rs.next()) {
                    String schemaName = rs.getString(1);
                    String tableName = rs.getString(2);
                    this.clearTables(dConn, gConn, schemaName, tableName);
                }
            } else {
                List<Struct> rsList = ResultSetHelper.asList(rs, false);
                for (Struct info : rsList) {
                    this.clearTables(dConn, gConn, (String)info.get("tableschemaname".toUpperCase()), (String)info.get("tableName".toUpperCase()));
                }
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            SQLHelper.closeResultSet(rs, gConn);
        }
    }

    protected void clearTables(Connection dConn, Connection gConn, String schema, String table) {
        int dCount = 0;
        int gCount = 0;
        SQLException dse = null;
        SQLException sse = null;
        String delete = "delete from " + schema + "." + table;
        Log.getLogWriter().info(delete);
        try {
            if (dConn != null) {
                dCount = dConn.createStatement().executeUpdate(delete);
                Log.getLogWriter().info("derby deleted " + dCount + " rows.");
            }
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return;
            }
            if (se.getSQLState().equalsIgnoreCase("23503")) {
                Log.getLogWriter().info("could not delete due to delete restrict in derby");
            }
            if (se.getSQLState().equalsIgnoreCase("XCL48")) {
                Log.getLogWriter().info("could not truncate due to foreign key reference in derby");
            }
            dse = se;
        }
        try {
            gCount = gConn.createStatement().executeUpdate(delete);
            Log.getLogWriter().info("gemfirexd deleted " + gCount + " rows.");
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("23503")) {
                Log.getLogWriter().info("could not delete due to delete restrict in gfxd");
            }
            if (se.getSQLState().equalsIgnoreCase("XCL48")) {
                Log.getLogWriter().info("could not truncate due to foreign key reference in gfxd");
            }
            if (setTx && se.getSQLState().equalsIgnoreCase("X0Z02")) {
                Log.getLogWriter().info("Got expected conflict exception using txn");
                return;
            }
            sse = se;
        }
        SQLHelper.compareExceptions(dse, sse);
        this.commit(dConn);
        this.commit(gConn);
    }

    protected void dropTables(Connection dConn, Connection gConn) {
    }

    public void commit(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            boolean[] getEvictionConflict;
            boolean[] getNodeFailure;
            boolean[] getCanceled;
            if (setCriticalHeap && (getCanceled = (boolean[])SQLTest.getCanceled.get()) != null && getCanceled[0] && SQLHelper.isDerbyConn(conn)) {
                Log.getLogWriter().info("memory runs low in gfxd, rollback the corresponding derby ops");
                conn.rollback();
                return;
            }
            if (!hasTx && setTx && isHATest && (getNodeFailure = (boolean[])SQLTest.getNodeFailure.get()) != null && getNodeFailure[0] && SQLHelper.isDerbyConn(conn)) {
                Log.getLogWriter().info("got node failure exception in gfxd, rollback the corresponding derby ops");
                conn.rollback();
                return;
            }
            if (!hasTx && setTx && testEviction && workaround51582 && (getEvictionConflict = (boolean[])SQLTest.getEvictionConflict.get()) != null && getEvictionConflict[0] && SQLHelper.isDerbyConn(conn)) {
                Log.getLogWriter().info("got conflict exception in gfxd, rollback the corresponding derby ops");
                conn.rollback();
                return;
            }
            String name = SQLHelper.isDerbyConn(conn) ? "derby " : "gfxd ";
            Log.getLogWriter().info("committing the ops for " + name);
            conn.commit();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se) && se.getSQLState().equalsIgnoreCase("08003")) {
                Log.getLogWriter().info("detected current connection is lost, possibly due to reade time out");
                return;
            }
            if (!hasTx && setTx && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                if (setTx) {
                    Log.getLogWriter().warning("got node failure exception or bucket moved exception during commit");
                    boolean[] getNodeFailure = (boolean[])SQLTest.getNodeFailure.get();
                    if (getNodeFailure == null) {
                        getNodeFailure = new boolean[]{true};
                    }
                    SQLTest.getNodeFailure.set((Object)getNodeFailure);
                    return;
                }
            }
            if (!hasTx && setTx && isOfflineTest && se.getSQLState().equals("X0Z03") && se.getCause() != null && (se.getCause().getMessage().contains("X0Z09") || se.getCause().getMessage().contains("X0Z08"))) {
                Log.getLogWriter().warning("ready-only txn could not commit as dml op hit offline exception");
                boolean[] getNodeFailure = (boolean[])SQLTest.getNodeFailure.get();
                if (getNodeFailure == null) {
                    getNodeFailure = new boolean[]{true};
                }
                SQLTest.getNodeFailure.set((Object)getNodeFailure);
                return;
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected boolean needNewConnection() {
        if (!hasTx) {
            return false;
        }
        Boolean needNewConn = (Boolean)SQLDistTxTest.needNewConnAfterNodeFailure.get();
        return needNewConn != null && needNewConn != false;
    }

    protected int getMyTid() {
        if (testWanUniqueness) {
            return WanTest.myWanSite;
        }
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        return myTid;
    }

    public static void HydraTask_stopVms() {
        sqlTest.stopVms();
    }

    protected void stopVms() {
        int numToKill = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
        List<ClientVmInfo> vms = this.stopVMs(numToKill, "store");
        vmListForOfflineTest = vms;
    }

    protected List<ClientVmInfo> stopVMs(int numToKill, String target) {
        Object[] tmpArr = StopStartVMs.getOtherVMs((int)numToKill, (String)target);
        List vmList = (List)tmpArr[0];
        List stopModeList = (List)tmpArr[1];
        for (ClientVmInfo client : vmList) {
            PRObserver.initialize((int)client.getVmid());
        }
        if (vmList.size() != 0) {
            StopStartVMs.stopVMs((List)vmList, (List)stopModeList);
        }
        return vmList;
    }

    public static void HydraTask_startVms() {
        sqlTest.startVms();
    }

    protected void startVms() {
        int numOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
        this.startVms(numOfPRs);
    }

    protected void startVms(int numOfPRs) {
        List<ClientVmInfo> vms = vmListForOfflineTest;
        if (vms == null) {
            throw new TestException("vmListForOfflineTest is set to " + vmListForOfflineTest);
        }
        StopStartVMs.startVMs(vms);
        Log.getLogWriter().info("Total number of PR is " + numOfPRs);
        PRObserver.waitForRebalRecov(vms, (int)1, (int)numOfPRs, null, null, (boolean)false);
    }

    public static void HydraTask_cycleRemainingStoreVms() {
        boolean accessorUpgradeWaiting;
        int numOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
        boolean bl = storeUpgradeCompleted = SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.storeUpgradeComplete) == 1L;
        if (storeUpgradeCompleted) {
            return;
        }
        Set restartedStoreVms = null;
        restartedStoreVms = (Set)SQLRollingUpgradeBB.getBB().getSharedMap().get((Object)restartedStoreVmIDsKey);
        if (restartedStoreVms == null) {
            MasterController.sleepForMs((int)5000);
            return;
        }
        boolean bl2 = accessorUpgradeWaiting = SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.accessorUpgradeWaiting) == 1L;
        if (accessorUpgradeWaiting) {
            MasterController.sleepForMs((int)2000);
            return;
        }
        List vmInfoList = StopStartVMs.getAllVMs();
        long recycling = SQLRollingUpgradeBB.getBB().getSharedCounters().incrementAndRead(SQLRollingUpgradeBB.recycling);
        if (recycling != 1L) {
            SQLRollingUpgradeBB.getBB().getSharedCounters().decrement(SQLRollingUpgradeBB.recycling);
            MasterController.sleepForMs((int)5000);
            SQLRollingUpgradeBB.getBB().getSharedCounters().setIfLarger(SQLRollingUpgradeBB.remainingStoreUpgradeWaiting, 1L);
            return;
        }
        vmInfoList = StopStartVMs.getMatchVMs((List)vmInfoList, (String)"store");
        ArrayList<ClientVmInfo> vmsToRestart = new ArrayList<ClientVmInfo>();
        ArrayList stopModes = new ArrayList();
        while (vmInfoList.size() != 0) {
            ClientVmInfo vmInfo = null;
            if (vmInfoList.size() != 0) {
                vmInfo = (ClientVmInfo)vmInfoList.get(0);
                vmInfoList.remove(0);
            }
            if (!restartedStoreVms.contains(vmInfo.getVmid())) {
                vmsToRestart = new ArrayList();
                vmsToRestart.add(vmInfo);
                PRObserver.initialize((int)vmInfo.getVmid());
                StopStartVMs.stopVM((ClientVmInfo)vmInfo, (String)"nice_exit");
                Log.getLogWriter().info("Sleeping for 2 seconds to allow ops to run...");
                MasterController.sleepForMs((int)2000);
                StopStartVMs.startVM((ClientVmInfo)vmInfo);
                PRObserver.waitForRebalRecov(vmsToRestart, (int)1, (int)numOfPRs, null, null, (boolean)false);
            }
            Log.getLogWriter().info("Store VMs size: " + vmInfoList.size());
        }
        SQLRollingUpgradeBB.getBB().getSharedCounters().zero(SQLRollingUpgradeBB.recycling);
        SQLRollingUpgradeBB.getBB().getSharedCounters().zero(SQLRollingUpgradeBB.remainingStoreUpgradeWaiting);
        SQLRollingUpgradeBB.getBB().getSharedCounters().increment(SQLRollingUpgradeBB.storeUpgradeComplete);
    }

    private boolean waitForOtherControllers() {
        boolean remainingStoreUpgradeWaiting;
        boolean accessorUpgradeWaiting;
        boolean bl = locatorUpgradeCompleted = SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.locatorUpgradeComplete) == 1L;
        if (!locatorUpgradeCompleted) {
            TestHelper.waitForCounter((Blackboard)SQLRollingUpgradeBB.getBB(), (String)"SQLRollingUpgradeBB.locatorUpgradeComplete", (int)SQLRollingUpgradeBB.locatorUpgradeComplete, (long)1L, (boolean)true, (long)-1L, (long)2000L);
            locatorUpgradeCompleted = true;
        }
        boolean bl2 = accessorUpgradeWaiting = SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.accessorUpgradeWaiting) == 1L;
        if (accessorUpgradeWaiting) {
            MasterController.sleepForMs((int)2000);
            return true;
        }
        boolean bl3 = remainingStoreUpgradeWaiting = SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.remainingStoreUpgradeWaiting) == 1L;
        if (remainingStoreUpgradeWaiting) {
            MasterController.sleepForMs((int)2000);
            return true;
        }
        long recycling = SQLRollingUpgradeBB.getBB().getSharedCounters().incrementAndRead(SQLRollingUpgradeBB.recycling);
        if (recycling != 1L) {
            SQLRollingUpgradeBB.getBB().getSharedCounters().decrement(SQLRollingUpgradeBB.recycling);
            MasterController.sleepForMs((int)5000);
            return true;
        }
        return false;
    }

    public static void HydraTask_cycleStoreVms() {
        if (cycleVms) {
            sqlTest.cycleStoreVms();
        }
    }

    protected void cycleStoreVms() {
        if (!cycleVms) {
            Log.getLogWriter().warning("cycleVms sets to false, no node will be brought down in the test run");
            return;
        }
        if (waitForLocatorUpgrade && this.waitForOtherControllers()) {
            return;
        }
        int numToKill = TestConfig.tab().intAt(StopStartPrms.numVMsToStop, 1);
        int numOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
        List<ClientVmInfo> vms = null;
        if (SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.stopStartVms) == 1L) {
            block21: {
                Object vmCycled = SQLBB.getBB().getSharedMap().get((Object)"vmCycled");
                if (testInitDDLReplay && vmCycled == null) {
                    Object waitedForInitDDLReplay = SQLBB.getBB().getSharedMap().get((Object)"waitedForInitDDLReplay");
                    if (waitedForInitDDLReplay == null) {
                        long startTime = System.currentTimeMillis();
                        SQLBB.getBB().getSharedMap().put((Object)"cycleInitDDLReplayVMStartTime", (Object)startTime);
                        int sleepMS = 120000;
                        Log.getLogWriter().info("allow  " + sleepMS / 1000 + " seconds" + " for initial DDL replay vms to start up");
                        MasterController.sleepForMs((int)sleepMS);
                        SQLBB.getBB().getSharedMap().put((Object)"waitedForInitDDLReplay", (Object)"true");
                        try {
                            vms = this.stopStartVMs(numToKill);
                        }
                        catch (TestException te) {
                            long now = System.currentTimeMillis();
                            Log.getLogWriter().warning("Initial DDL replay was not ready for " + (now - startTime) / 1000L + " seconds ");
                            SQLBB.getBB().getSharedCounters().zero(SQLBB.stopStartVms);
                            return;
                        }
                    }
                    while (true) {
                        try {
                            vms = this.stopStartVMs(numToKill);
                            break block21;
                        }
                        catch (TestException te) {
                            long startTime = (Long)SQLBB.getBB().getSharedMap().get((Object)"cycleInitDDLReplayVMStartTime");
                            long now = System.currentTimeMillis();
                            Log.getLogWriter().warning("VMs for initial DDL replay was not ready for " + (now - startTime) / 1000L + " seconds ");
                            int sleepMS = 30000;
                            MasterController.sleepForMs((int)sleepMS);
                            Log.getLogWriter().info("allow another " + sleepMS / 1000 + " seconds" + " for initial DDL replay vms to start up");
                            continue;
                        }
                        break;
                    }
                }
                Long lastCycledTimeFromBB = (Long)SQLBB.getBB().getSharedMap().get((Object)LASTCYCLEDTIME);
                if (lastCycledTimeFromBB == null) {
                    int sleepMS = 20000;
                    Log.getLogWriter().info("allow  " + sleepMS / 1000 + " seconds before killing others");
                    MasterController.sleepForMs((int)sleepMS);
                } else if (lastCycledTimeFromBB > lastCycledTime) {
                    lastCycledTime = lastCycledTimeFromBB;
                    this.log().info("update last cycled vms is set to " + lastCycledTime);
                }
                if (lastCycledTime != 0L) {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastCycledTime < (long)(waitTimeBeforeNextCycleVM * 1000)) {
                        SQLBB.getBB().getSharedCounters().zero(SQLBB.stopStartVms);
                        return;
                    }
                    this.log().info("cycle vms starts at: " + currentTime);
                }
                vms = this.stopStartVMs(numToKill);
            }
            if (vms == null || vms.size() == 0) {
                Log.getLogWriter().info("no vm being chosen to be stopped");
                SQLBB.getBB().getSharedCounters().zero(SQLBB.stopStartVms);
                return;
            }
            if (waitForLocatorUpgrade) {
                HashSet<Integer> restartedStoreVms = null;
                restartedStoreVms = (HashSet<Integer>)SQLRollingUpgradeBB.getBB().getSharedMap().get((Object)restartedStoreVmIDsKey);
                if (restartedStoreVms == null) {
                    restartedStoreVms = new HashSet<Integer>();
                }
                for (ClientVmInfo info : vms) {
                    if (restartedStoreVms.contains(info.getVmid())) continue;
                    restartedStoreVms.add(info.getVmid());
                }
                SQLRollingUpgradeBB.getBB().getSharedMap().put((Object)restartedStoreVmIDsKey, restartedStoreVms);
            }
            Log.getLogWriter().info("Total number of PR is " + numOfPRs);
            if (numOfPRs > 0) {
                PRObserver.waitForRebalRecov(vms, (int)1, (int)numOfPRs, null, null, (boolean)false);
            }
            long currentTime = System.currentTimeMillis();
            this.log().info("cycle vms finishes at: " + currentTime);
            SQLBB.getBB().getSharedMap().put((Object)LASTCYCLEDTIME, (Object)currentTime);
            SQLBB.getBB().getSharedMap().put((Object)"vmCycled", (Object)"true");
            SQLBB.getBB().getSharedCounters().zero(SQLBB.stopStartVms);
        }
        if (waitForLocatorUpgrade) {
            SQLRollingUpgradeBB.getBB().getSharedCounters().zero(SQLRollingUpgradeBB.recycling);
        }
    }

    public static void HydraTask_cycleAccessorVms() {
        waitForLocatorUpgrade = TestConfig.tab().booleanAt(SQLRollingUpgradePrms.waitForLocatorUpgrade, false);
        if (!cycleVms) {
            Log.getLogWriter().warning("cycleVms sets to false, no node will be brought down in the test run");
            return;
        }
        if (waitForLocatorUpgrade) {
            boolean bl = locatorUpgradeCompleted = SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.locatorUpgradeComplete) == 1L;
            if (!locatorUpgradeCompleted) {
                return;
            }
        }
        boolean bl = accessorUpgradeCompleted = SQLRollingUpgradeBB.getBB().getSharedCounters().read(SQLRollingUpgradeBB.accessorUpgradeComplete) == 1L;
        if (accessorUpgradeCompleted) {
            return;
        }
        long recycling = SQLRollingUpgradeBB.getBB().getSharedCounters().incrementAndRead(SQLRollingUpgradeBB.recycling);
        if (recycling != 1L) {
            SQLRollingUpgradeBB.getBB().getSharedCounters().decrement(SQLRollingUpgradeBB.recycling);
            SQLRollingUpgradeBB.getBB().getSharedCounters().setIfLarger(SQLRollingUpgradeBB.accessorUpgradeWaiting, 1L);
            TestHelper.waitForCounter((Blackboard)SQLRollingUpgradeBB.getBB(), (String)"SQLRollingUpgradeBB.recycling", (int)SQLRollingUpgradeBB.recycling, (long)0L, (boolean)true, (long)-1L, (long)1000L);
        }
        List vms = null;
        int sleepMS = 20000;
        Log.getLogWriter().info("allow  " + sleepMS / 1000 + " seconds before killing others");
        MasterController.sleepForMs((int)sleepMS);
        vms = StopStartVMs.getMatchVMs((List)StopStartVMs.getAllVMs(), (String)"accessor");
        while (vms.size() != 0) {
            ClientVmInfo vmInfo = null;
            if (vms.size() != 0) {
                vmInfo = (ClientVmInfo)vms.get(0);
                vms.remove(0);
            }
            MasterController.sleepForMs((int)10000);
            StopStartVMs.stopVM((ClientVmInfo)vmInfo, (String)"nice_exit");
            StopStartVMs.startVM((ClientVmInfo)vmInfo);
            Log.getLogWriter().info("Accessor VMs size: " + vms.size());
        }
        SQLRollingUpgradeBB.getBB().getSharedCounters().increment(SQLRollingUpgradeBB.accessorUpgradeComplete);
        SQLRollingUpgradeBB.getBB().getSharedCounters().zero(SQLRollingUpgradeBB.recycling);
        SQLRollingUpgradeBB.getBB().getSharedCounters().zero(SQLRollingUpgradeBB.accessorUpgradeWaiting);
    }

    protected List<ClientVmInfo> stopStartVMs(int numToKill) {
        return this.stopStartVMs(numToKill, cycleVMTarget);
    }

    protected List<ClientVmInfo> stopStartVMs(int numToKill, String target) {
        List stopModeList;
        List vmList;
        Object[] tmpArr = StopStartVMs.getOtherVMs((int)numToKill, (String)target);
        Object vm1 = SQLBB.getBB().getSharedMap().get((Object)"asyncDBTarget1");
        Object vm2 = SQLBB.getBB().getSharedMap().get((Object)"asyncDBTarget2");
        if (vm1 == null && vm2 == null) {
            vmList = (List)tmpArr[0];
            stopModeList = (List)tmpArr[1];
            for (ClientVmInfo client : vmList) {
                PRObserver.initialize((int)client.getVmid());
            }
        } else {
            vmList = (List)tmpArr[0];
            stopModeList = (List)tmpArr[1];
            for (int i = 0; i < vmList.size(); ++i) {
                if (((ClientVmInfo)vmList.get(i)).getVmid().intValue() == ((ClientVmInfo)vm1).getVmid().intValue() || ((ClientVmInfo)vmList.get(i)).getVmid().intValue() == ((ClientVmInfo)vm2).getVmid().intValue()) {
                    Log.getLogWriter().info("remove the vm " + ((ClientVmInfo)vmList.get(i)).getVmid() + " from the stop list");
                    vmList.remove(i);
                    continue;
                }
                PRObserver.initialize((int)((ClientVmInfo)vmList.get(i)).getVmid());
            }
        }
        if (vmList.size() != 0) {
            StopStartVMs.stopStartVMs((List)vmList, (List)stopModeList);
        }
        return vmList;
    }

    public static void HydraTask_cycleAsynchDBVm() {
        sqlTest.cycleAsynchDBVm();
    }

    protected void cycleAsynchDBVm() {
        int sleepMS = 20000;
        Log.getLogWriter().info("allow  " + sleepMS / 1000 + " seconds before killing others");
        MasterController.sleepForMs((int)sleepMS);
        ClientVmInfo target = random.nextBoolean() ? (ClientVmInfo)SQLBB.getBB().getSharedMap().get((Object)"asyncDBTarget1") : (ClientVmInfo)SQLBB.getBB().getSharedMap().get((Object)"asyncDBTarget2");
        String stopMode = TestConfig.tab().stringAt(StopStartPrms.stopModes);
        ArrayList<ClientVmInfo> vmList = new ArrayList<ClientVmInfo>();
        vmList.add(target);
        ArrayList<String> stopModeList = new ArrayList<String>();
        stopModeList.add(stopMode);
        this.cycleAsynchDBVm(vmList, stopModeList);
    }

    protected void cycleAsynchDBVm(List<ClientVmInfo> vmList, List<String> stopModeList) {
        for (ClientVmInfo client : vmList) {
            PRObserver.initialize((int)client.getVmid());
        }
        StopStartVMs.stopStartVMs(vmList, stopModeList);
    }

    public static void HydraTask_bounceAllVMs() {
        List vmInfoList = StopStartVMs.getAllVMs();
        ArrayList<String> stopModeList = new ArrayList<String>();
        for (int i = 0; i < vmInfoList.size(); ++i) {
            stopModeList.add("MEAN_EXIT");
        }
        if (vmInfoList.size() != 0) {
            StopStartVMs.stopStartVMs((List)vmInfoList, stopModeList);
        }
    }

    public static void HydraTask_bounceAllVMsExcludeLocators() {
        SQLTest.bounceAllVMsExcludeTargets("locator");
    }

    public static void HydraTask_bounceAllVMsExcludeClients() {
        SQLTest.bounceAllVMsExcludeTargets("client");
    }

    protected static void bounceAllVMsExcludeTargets(String targets) {
        List vmInfoList = StopStartVMs.getAllVMs();
        Stack<Integer> excludedVMs = new Stack<Integer>();
        int index = 0;
        for (ClientVmInfo info : vmInfoList) {
            if (info.getClientName().indexOf(targets) >= 0) {
                excludedVMs.push(index);
            }
            ++index;
        }
        while (excludedVMs.size() > 0) {
            index = (Integer)excludedVMs.pop();
            Log.getLogWriter().info("removing from vmInfoList: " + ((ClientVmInfo)vmInfoList.get(index)).getClientName());
            vmInfoList.remove(index);
        }
        ArrayList<String> stopModeList = new ArrayList<String>();
        for (int i = 0; i < vmInfoList.size(); ++i) {
            Log.getLogWriter().info(((ClientVmInfo)vmInfoList.get(i)).getClientName());
            stopModeList.add("MEAN_EXIT");
        }
        if (vmInfoList.size() != 0) {
            StopStartVMs.stopStartVMs((List)vmInfoList, stopModeList);
        }
    }

    public static void HydraTask_doDerbyIndexOp() {
        sqlTest.doDerbyIndexOp();
    }

    protected void doDerbyIndexOp() {
        if (hasDerbyServer) {
            Connection dConn = this.getDiscConnection();
            IndexDDLStmt.doDerbyIndexOp(dConn);
        }
    }

    public static void HydraTask_createUniqIndex() {
        sqlTest.createUniqIndex();
    }

    protected void createUniqIndex() {
        Connection gConn = this.getGFEConnection();
        if (testUniqIndex && hasCompanies) {
            this.addSecuritiesUniqConstraint(gConn);
        }
        IndexDDLStmt.createUniqIndex(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createFuncForProcedures() {
        sqlTest.createFuncForProcedures();
    }

    protected void createFuncForProcedures() {
        Log.getLogWriter().info("performing create function multiply Op, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getHdfsQueryConnection();
        try {
            FunctionDDLStmt.createFuncMultiply(dConn);
            FunctionDDLStmt.createFuncMultiply(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (dConn != null) {
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createFuncForSubquery() {
        sqlTest.createFuncForSubquery();
    }

    protected void createFuncForSubquery() {
        Log.getLogWriter().info("performing create function maxCid Op, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getHdfsQueryConnection();
        try {
            FunctionDDLStmt.createFuncMaxCid(dConn);
            FunctionDDLStmt.createFuncMaxCid(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (dConn != null) {
            this.commit(dConn);
            this.closeDiscConnection(dConn);
        }
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createProcedures() {
        sqlTest.createProcedures();
    }

    protected void createProcedures() {
        Log.getLogWriter().info("performing create procedure Op, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.createProcedures(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_createJSONProcedures() {
        sqlTest.createJSONProcedures();
    }

    protected void createJSONProcedures() {
        Log.getLogWriter().info("performing create procedure Op, myTid is " + this.getMyTid());
        ProcedureDDLStmt procStmt = new ProcedureDDLStmt();
        Connection gConn = this.getGFEConnection();
        procStmt.createJSONDDL(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void createProcedures(Connection dConn, Connection gConn) {
        ProcedureDDLStmt procStmt = new ProcedureDDLStmt();
        procStmt.createDDLs(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
    }

    public static void HydraTask_callProcedures() {
        sqlTest.callProcedures();
    }

    public static void HydraTask_callJSONProcedures() {
        sqlTest.callJSONProcedures();
    }

    protected void callJSONProcedures() {
        Log.getLogWriter().info("call procedures, myTid is " + this.getMyTid());
        Connection gConn = this.getGFEConnection();
        this.callProcedures(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void callProcedures() {
        Log.getLogWriter().info("call procedures, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.callProcedures(dConn, gConn);
        if (hasDerbyServer) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void callProcedures(Connection gConn) {
        try {
            Procedures.callJsonProcedure(gConn, this.getMyTid());
            this.commit(gConn);
        }
        catch (SQLException se) {
            throw new TestException(TestHelper.getStackTrace((Throwable)se));
        }
    }

    protected void callProcedures(Connection dConn, Connection gConn) {
        Procedures.callProcedures(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
    }

    public static void HydraTask_verifyFuncSubquery() {
        sqlTest.verifyFuncSubquery();
    }

    protected void verifyFuncSubquery() {
        String subquery = "select * from trade.customers c where c.cid = trade.maxCid(" + this.getMyTid() + " )";
        Log.getLogWriter().info("verifying query results using function in subquery, myTid is " + this.getMyTid());
        Connection dConn = null;
        ResultSet derbyRS = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        try {
            if (dConn != null) {
                Log.getLogWriter().info("in Derby, executing " + subquery);
                PreparedStatement psDerby = dConn.prepareStatement(subquery);
                psDerby.execute();
                derbyRS = psDerby.getResultSet();
                Log.getLogWriter().info("Got result set from derby");
            }
            Log.getLogWriter().info("in gemfirexd, executing " + subquery);
            CallableStatement psGFE = gConn.prepareCall(subquery);
            psGFE.execute();
            ResultSet gfeRS = psGFE.getResultSet();
            Log.getLogWriter().info("Got result set from gemfirexd");
            boolean success = false;
            if (dConn != null) {
                success = this.verifyResultSets(derbyRS, gfeRS);
                while (!success) {
                    Log.getLogWriter().info("Not able to verify subquery (with function) results");
                    success = this.verifyResultSets(derbyRS, gfeRS);
                }
            }
            SQLHelper.closeResultSet(gfeRS, gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.commit(dConn);
        this.commit(gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_verifyProcedures() {
        sqlTest.verifyProcedures();
    }

    protected void verifyProcedures() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verify of query results through created procedure call due to manageDerbyServer as false, myTid=" + this.getMyTid());
            this.cleanConnection(this.getGFEConnection());
            return;
        }
        Log.getLogWriter().info("verifying query results through created procedure call, myTid is " + this.getMyTid());
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.verifyProcedures(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void verifyProcedures(Connection dConn, Connection gConn) {
        try {
            CallableStatement csDerby = dConn.prepareCall("{call trade.show_customers(?)}");
            csDerby.setInt(1, this.getMyTid());
            csDerby.execute();
            ResultSet derbyRS = csDerby.getResultSet();
            Log.getLogWriter().info("Got result set from derby");
            CallableStatement csGFE = gConn.prepareCall("{call trade.show_customers(?)}");
            csGFE.setInt(1, this.getMyTid());
            csGFE.execute();
            ResultSet gfeRS = csGFE.getResultSet();
            Log.getLogWriter().info("Got result set from gemfirexd");
            if (gfeRS == null) {
                Log.getLogWriter().info("Gfe result is null");
            }
            if (derbyRS == null) {
                throw new TestException(" Derby result is null");
            }
            boolean success = this.verifyResultSets(derbyRS, gfeRS);
            while (!success) {
                Log.getLogWriter().info("Not able to verify procedure results");
                success = this.verifyResultSets(derbyRS, gfeRS);
            }
            SQLHelper.closeResultSet(gfeRS, gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_setTableCols() {
        sqlTest.setTableCols();
    }

    protected void setTableCols() {
        Connection gConn = this.getGFEConnection();
        SQLTest.setTableCols(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static synchronized void setTableCols(Connection conn) {
        if (tableColsSet) {
            Log.getLogWriter().info("table columns are already set");
            return;
        }
        try {
            for (int i = 0; i < tables.length; ++i) {
                if (tables[i].toLowerCase().contains(portfoliov1)) continue;
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("select * from " + tables[i]);
                ResultSetMetaData rsmd = rs.getMetaData();
                int numCols = rsmd.getColumnCount();
                ArrayList<String> colNames = new ArrayList<String>();
                rs.close();
                Log.getLogWriter().info("setting columnNames for table " + tables[i]);
                for (int j = 0; j < numCols; ++j) {
                    if (tables[i].contains("companies") && (rsmd.getColumnName(j + 1).equalsIgnoreCase("histprice") || rsmd.getColumnName(j + 1).equalsIgnoreCase("uuid") || rsmd.getColumnName(j + 1).equalsIgnoreCase("companyinfo"))) continue;
                    String columnName = rsmd.getColumnName(j + 1);
                    colNames.add(columnName);
                    Log.getLogWriter().info("colNames[" + j + "] is " + columnName);
                }
                tableCols.put(tables[i], colNames);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        SQLBB.getBB().getSharedMap().put((Object)"tableCols", tableCols);
        Log.getLogWriter().info("sets up table columns information for index creation");
        tableColsSet = true;
    }

    protected static void setTableCols(Connection conn, String tableName) throws SQLException {
        if (!tableColsSet) {
            throw new TestException("Test issue, needs to run setTableCols(Connection) first ");
        }
        tableCols = (HashMap)SQLBB.getBB().getSharedMap().get((Object)"tableCols");
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select * from " + tableName);
        ResultSetMetaData rsmd = rs.getMetaData();
        int numCols = rsmd.getColumnCount();
        ArrayList<String> colNames = new ArrayList<String>();
        rs.close();
        Log.getLogWriter().info("setting columnNames for table " + tableName);
        for (int j = 0; j < numCols; ++j) {
            if (tableName.contains("companies") && (rsmd.getColumnName(j + 1).equalsIgnoreCase("histprice") || rsmd.getColumnName(j + 1).equalsIgnoreCase("uuid") || rsmd.getColumnName(j + 1).equalsIgnoreCase("companyinfo"))) continue;
            String columnName = rsmd.getColumnName(j + 1);
            colNames.add(columnName);
            Log.getLogWriter().info("colNames[" + j + "] is " + columnName);
        }
        tableCols.put(tableName, colNames);
        SQLBB.getBB().getSharedMap().put((Object)"tableCols", tableCols);
        Log.getLogWriter().info("sets up table columns information for index creation");
    }

    protected String[] getGFEDDLPartition() {
        int i;
        Log.getLogWriter().info("in SQLTest.getGFEDDLPartition()");
        String[] tables = SQLPrms.getCreateTablesStatements(false);
        HydraVector statements = TestConfig.tab().vecAt(SQLPrms.gfeDDLExtension, new HydraVector());
        HydraVector redundancyClause = TestConfig.tab().vecAt(SQLPrms.redundancyClause, new HydraVector());
        if (statements.size() == 0) {
            return tables;
        }
        String[] strArr = new String[statements.size()];
        for (i = 0; i < statements.size(); ++i) {
            if (testUniqIndex) {
                tables[0] = "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))";
            }
            String currentTable = tables[i].substring(0, tables[i].indexOf("(")).toLowerCase();
            if (hasJSON && (currentTable.contains("trade.securities") || currentTable.contains("trade.buyorders") || currentTable.contains("trade.networth") || currentTable.contains("trade.customers"))) {
                tables[i] = tables[i].trim().substring(0, tables[i].trim().length() - 1);
                if (currentTable.contains("trade.customers")) {
                    int n = i;
                    tables[n] = tables[n] + " , json_details json , networth_json json , buyorder_json json )";
                } else {
                    int n = i;
                    tables[n] = tables[n] + " , json_details json )";
                }
            }
            String tableName = (String)statements.elementAt(i);
            String partition = this.getTablePartition(tableName);
            if (redundancyClause.size() > 0) {
                strArr[i] = tables[i] + " " + partition + this.getRedundancyClause(partition, (String)redundancyClause.elementAt(i));
                SQLBB.getBB().getSharedMap().put((Object)hasRedundancy, (Object)true);
                continue;
            }
            strArr[i] = tables[i] + " " + partition;
            SQLBB.getBB().getSharedMap().put((Object)hasRedundancy, (Object)false);
        }
        for (i = 0; i < statements.size(); ++i) {
            String tableName = (String)statements.elementAt(i);
            int n = i;
            strArr[n] = strArr[n] + SQLTest.getPersistence(i) + (useHeapPercentage ? (alterTableDropColumn ? SQLTest.getEvictionHeapPercentageOverflowForAlterTable() : SQLTest.getEvictionHeapPercentageOverflow()) : SQLTest.getEvictionOverflow(tableName));
        }
        return strArr;
    }

    private static String getPersistence(int i) {
        HydraVector statements = TestConfig.tab().vecAt(SQLPrms.gfePersistExtension, new HydraVector());
        if (statements.size() == 0) {
            return " ";
        }
        if (i > statements.size()) {
            throw new TestException("incorrect persist tables in the test config");
        }
        return (String)statements.elementAt(i);
    }

    public static String getEvictionOverflow(String tableName) {
        String eviction = SQLTest.getEvictionOverflow();
        String megabyte = "";
        if (eviction.contains(LRUMEMSIZE)) {
            for (int i = 0; i < eviction.length(); ++i) {
                Character chars = Character.valueOf(eviction.charAt(i));
                if (!Character.isDigit(chars.charValue())) continue;
                megabyte = megabyte + chars;
            }
        }
        if (megabyte.length() > 0) {
            SQLBB.getBB().getSharedMap().put((Object)(tableName + LRUMEMSIZE), (Object)Integer.parseInt(megabyte));
        }
        return eviction;
    }

    public static String getEvictionOverflow() {
        if (!testEviction) {
            return " ";
        }
        StringBuilder sb = new StringBuilder();
        int a = random.nextInt(2);
        switch (a) {
            case 0: {
                int maxMb = 2;
                sb.append(" eviction by LRUMEMSIZE " + (random.nextInt(maxMb) + 1) + " ");
                break;
            }
            case 1: {
                sb.append(" eviction by LRUCOUNT " + (random.nextInt(100) + 500) + " ");
                break;
            }
            default: {
                throw new TestException("this should not happen");
            }
        }
        sb.append("evictaction overflow " + SQLTest.getSynchronous() + (useDefaultDiskStoreForOverflow ? "" : "'OverflowDiskStore'"));
        return sb.toString();
    }

    public static String getEvictionHeapPercentageOverflow() {
        if (!testEviction) {
            return " ";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" eviction by LRUHEAPPERCENT ");
        sb.append("evictaction overflow " + SQLTest.getSynchronous() + (useDefaultDiskStoreForOverflow ? "" : "'OverflowDiskStore'"));
        return sb.toString();
    }

    public static String getEvictionHeapPercentageOverflowForAlterTable() {
        if (!testEviction) {
            return " ";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" eviction by LRUHEAPPERCENT ");
        sb.append("evictaction overflow ");
        return sb.toString();
    }

    public static void HydraTask_setHeapPercentage() {
        if (useHeapPercentage) {
            if (alterTableDropColumn) {
                double percentage = (double)(random.nextInt(5) + 20) * 1.1;
                sqlTest.setHeapPercentage(percentage);
            } else {
                sqlTest.setHeapPercentage();
            }
        } else {
            Log.getLogWriter().info("eviction heap percentage is not set");
        }
    }

    protected void setHeapPercentage() {
        if (percentage == 0.0) {
            percentage = ((double)random.nextInt(5) + initEvictionHeap) * 1.1;
        }
        this.setHeapPercentage(percentage);
    }

    protected void setHeapPercentage(double percentage) {
        Connection gConn = this.getGFEConnection();
        this.setHeapPercentage(gConn, percentage, null);
        this.closeGFEConnection(gConn);
    }

    protected void setHeapPercentage(Connection gConn, double percentage, String serverGroup) {
        String sql = "CALL SYS.SET_EVICTION_HEAP_PERCENTAGE_SG(?, ?)";
        this.setHeapPercentage(gConn, percentage, null, sql);
        if (isOffheap) {
            sql = "CALL SYS.SET_EVICTION_OFFHEAP_PERCENTAGE_SG(?, ?)";
            this.setHeapPercentage(gConn, percentage, null, sql);
        }
    }

    protected void setHeapPercentage(Connection gConn, double percentage, String serverGroup, String sql) {
        try {
            CallableStatement cs = gConn.prepareCall(sql);
            Log.getLogWriter().info(sql + " with args " + percentage + ", " + serverGroup);
            cs.setDouble(1, percentage);
            if (serverGroup == null) {
                cs.setNull(2, 12);
            } else {
                cs.setString(2, serverGroup);
            }
            cs.executeUpdate();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_setCriticalHeapPercentage() {
        sqlTest.setCriticalHeapPercentage();
    }

    protected void setCriticalHeapPercentage() {
        Connection gConn = this.getGFEConnection();
        if (setCriticalHeap) {
            this.setCriticalHeapPercentage(gConn);
        } else {
            Log.getLogWriter().info("No critical heap is set");
        }
        this.closeGFEConnection(gConn);
    }

    protected void setCriticalHeapPercentage(Connection gConn) {
        double percentage = ((double)random.nextInt(5) + (initEvictionHeap + 10.0)) * 1.05;
        this.setCriticalHeapPercentage(gConn, percentage, null);
    }

    protected void setCriticalHeapPercentage(Connection gConn, double percentage, String serverGroup) {
        String sql = "CALL SYS.SET_CRITICAL_HEAP_PERCENTAGE_SG(?, ?)";
        this.setCriticalHeapPercentage(gConn, percentage, serverGroup, sql);
        if (isOffheap) {
            sql = "CALL SYS.SET_CRITICAL_OFFHEAP_PERCENTAGE_SG(?, ?)";
            this.setCriticalHeapPercentage(gConn, percentage, serverGroup, sql);
        }
    }

    protected void setCriticalHeapPercentage(Connection gConn, double percentage, String serverGroup, String sql) {
        try {
            Log.getLogWriter().info(sql + " with args " + percentage + ", " + serverGroup);
            CallableStatement cs = gConn.prepareCall(sql);
            cs.setDouble(1, percentage);
            if (serverGroup == null) {
                cs.setNull(2, 12);
            } else {
                cs.setString(2, serverGroup);
            }
            cs.executeUpdate();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected Connection getConnectionSetTrace() throws SQLException {
        if (testSecurity) {
            if (!isEdge) {
                return GFEDBManager.getSuperUserConnection();
            }
            return GFEDBClientManager.getSuperUserConnection();
        }
        return this.getGFEConnection();
    }

    private static String getSynchronous() {
        return random.nextBoolean() ? "asynchronous " : "synchronous ";
    }

    private static String getLoader(int i) {
        HydraVector statements = TestConfig.tab().vecAt(SQLPrms.loaderDDLExtension, new HydraVector());
        if (statements.size() == 0) {
            return " ";
        }
        if (i > statements.size()) {
            throw new TestException("incorrect loader setting in the test config");
        }
        return (String)statements.elementAt(i);
    }

    protected String getTablePartition(String tableName) {
        Log.getLogWriter().info("tableName is " + tableName);
        return PartitionClause.getPartitionClause(tableName);
    }

    protected String getRedundancyClause(String tablePartition, String redundancyClause) {
        if (tablePartition.contains("replicate") || redundancyClause == null) {
            return " ";
        }
        return redundancyClause;
    }

    public static void HydraTask_addLoader() {
        sqlTest.addLoader();
    }

    protected void addLoader() {
        if (!populateThruLoader && !testLoaderCreateRandomRow) {
            Log.getLogWriter().info("no loader is attached");
            return;
        }
        Connection conn = this.getGFEConnection();
        String schemaName = "trade";
        String tableName = "buyorders";
        String loader = "sql.loader.BuyOrdersLoader";
        String initStr = testLoaderCreateRandomRow ? "createRandomRow" : null;
        try {
            this.addLoader(conn, schemaName, tableName, loader, initStr);
            this.commit(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void addLoader(Connection conn, String schemaName, String tableName, String functionStr, String initInfoStr) throws SQLException {
        CallableStatement cs = conn.prepareCall("CALL SYS.ATTACH_LOADER(?,?,?,?)");
        Log.getLogWriter().info("CALL SYS.ATTACH_LOADER(" + schemaName + ", " + tableName + ", " + functionStr + ", " + initInfoStr + ")");
        cs.setString(1, schemaName);
        cs.setString(2, tableName);
        cs.setString(3, functionStr);
        cs.setString(4, initInfoStr);
        cs.execute();
    }

    public static void HydraTask_populateThruLoader() {
        if (setTx) {
            sqlTest.populateThruLoader();
            return;
        }
        int number = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.populateThruLoader);
        int oneOutOfHowMany = 6;
        if (number == 1 || random.nextInt(oneOutOfHowMany) == 1) {
            sqlTest.populateThruLoader();
        }
    }

    protected void populateThruLoader() {
        Connection gConn = this.getGFEConnection();
        this.populateThruLoader(gConn);
        if (setTx) {
            this.commit(gConn);
        }
    }

    protected void populateThruLoader(Connection gConn) {
        if (!populateThruLoader) {
            Log.getLogWriter().info("data were inserted instead of being loaded");
            return;
        }
        try {
            int maxOidInserted = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeBuyOrdersPrimary);
            String get = "select * from trade.buyorders where oid =? ";
            PreparedStatement ps = gConn.prepareStatement(get);
            if (!setTx) {
                for (int i = -1; i <= maxOidInserted + 1; ++i) {
                    this.loadThruGet(ps, i);
                }
            } else {
                ResultSet rs = this.getDiscConnection().createStatement().executeQuery("select oid from trade.buyorders where tid = " + this.getMyTid());
                List<Struct> oidlist = ResultSetHelper.asList(rs, true);
                for (Struct oid : oidlist) {
                    this.loadThruGet(ps, (Integer)oid.get("OID"));
                }
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("42X05")) {
                Log.getLogWriter().info("buyorders does not exists in this test");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void loadThruGet(PreparedStatement ps, int i) throws SQLException {
        ps.setInt(1, i);
        ResultSet rs = ps.executeQuery();
        if (testPartitionBy) {
            List<Struct> resultList = ResultSetHelper.asList(rs, false);
            if (resultList.size() > 0) {
                if (i < 1) {
                    Log.getLogWriter().info("row being loaded is " + ResultSetHelper.listToString(resultList));
                    throw new TestException("loader loaded a non existing row from the back_end database: " + ResultSetHelper.listToString(resultList));
                }
                Log.getLogWriter().info("data have been loaded for oid: " + i);
            } else {
                Log.getLogWriter().info("data may not have been loaded for oid: " + i);
            }
        }
        rs.close();
    }

    public static void HydraTask_createRandomRowsThruLoader() {
        sqlTest.createRandomRowsThruLoader();
    }

    protected void createRandomRowsThruLoader() {
        if (!testLoaderCreateRandomRow) {
            Log.getLogWriter().info("not a load test");
            return;
        }
        try {
            Connection gConn = this.getGFEConnection();
            int maxOidInserted = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeBuyOrdersPrimary);
            int numOfKeys = 100;
            int newMaxOid = (int)SQLBB.getBB().getSharedCounters().add(SQLBB.tradeBuyOrdersPrimary, (long)numOfKeys);
            String get = "select * from trade.buyorders where oid =? ";
            PreparedStatement ps = gConn.prepareStatement(get);
            for (int i = maxOidInserted; i <= newMaxOid + 1; ++i) {
                ps.setInt(1, i);
                ResultSet rs = ps.executeQuery();
                rs.close();
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("42X05")) {
                Log.getLogWriter().info("buyorders does not exists in this test");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_shutDownDB() {
        sqlTest.shutDownDB();
    }

    protected void shutDownDB() {
        if (hasDerbyServer && !hasPersistentTables) {
            ClientDiscDBManager.shutDownDB();
        }
        GFEDBManager.shutDownDB();
    }

    public static void HydraTask_shutDownAllFabricServers() {
        sqlTest.shutDownAllFabricServers();
    }

    protected void shutDownAllFabricServers() {
        Log.getLogWriter().info("shuting down all FabricServers");
        FabricServerHelper.shutDownAllFabricServers(300);
        while (!FabricServerHelper.isFabricServerStopped()) {
            Log.getLogWriter().info("Waiting for 5 sec as for shutdown of FabricServer");
            MasterController.sleepForMs((int)5000);
        }
        Log.getLogWriter().info("Completed shutdown of FabricServer...");
    }

    protected void waitForBarrier() {
        AnyCyclicBarrier barrier = AnyCyclicBarrier.lookup((int)numOfWorkers, (String)"barrier");
        Log.getLogWriter().info("Waiting for " + numOfWorkers + " to meet at barrier");
        barrier.await();
    }

    protected void createFuncMonth() {
        Connection conn = this.getGFEConnection();
        this.createFuncMonth(conn);
    }

    protected void createFuncMonth(Connection conn) {
        String sql = "create function month(DP1 Date) RETURNS INTEGER PARAMETER STYLE JAVA LANGUAGE JAVA NO SQL EXTERNAL NAME 'sql.FunctionTest.month'";
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException se) {
            if (multiThreadsCreateTables && se.getSQLState().equalsIgnoreCase("X0Y68")) {
                Log.getLogWriter().info("Got the expected exception, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
        Log.getLogWriter().info("created function month for partition by expression case");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<String[]> getTableNames(Connection conn) {
        ArrayList<String[]> tables = new ArrayList<String[]>();
        ResultSet rs = null;
        try {
            rs = conn.createStatement().executeQuery("select tableschemaname, tablename from sys.systables where tabletype = 'T' and tableschemaname != 'SYSSTAT'");
            while (rs.next()) {
                String[] str = new String[]{rs.getString(1), rs.getString(2)};
                tables.add(str);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            SQLHelper.closeResultSet(rs, conn);
        }
        return tables;
    }

    protected void compareResults(Connection gConn, String query1, String query2, String table1, String table2) throws TestException {
        List<Struct> list1 = SQLTest.getResultSetTest(gConn, query1);
        List<Struct> list2 = SQLTest.getResultSetTest(gConn, query2);
        ResultSetHelper.compareResultSets(list1, list2, table1, table2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<String[]> getTableNames(Connection conn, String query) {
        ArrayList<String[]> tables = new ArrayList<String[]>();
        ResultSet rs = null;
        try {
            rs = conn.createStatement().executeQuery(query);
            while (rs.next()) {
                String[] str = new String[]{rs.getString(1), rs.getString(2)};
                tables.add(str);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            SQLHelper.closeResultSet(rs, conn);
        }
        return tables;
    }

    protected void getLock() {
        if (lock == null) {
            lock = SQLBB.getBB().getSharedLock();
        }
        lock.lock();
    }

    protected void releaseLock() {
        lock.unlock();
    }

    public static void HydraTask_runSQLScript() {
        if (sqlTest == null) {
            sqlTest = new SQLTest();
        }
        sqlTest.runSQLScript(true);
    }

    public static void HydraTask_runSQLScriptContinueOnError() {
        sqlTest.runSQLScript(false);
    }

    protected void runSQLScript(boolean failOnError) {
        String sqlFilePath = SQLPrms.getSqlFilePath();
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
            Log.getLogWriter().info("running sql script " + sqlFilePath + " on derby");
            SQLHelper.runSQLScript(dConn, sqlFilePath, failOnError);
        }
        Connection gConn = this.getGFEConnection();
        Log.getLogWriter().info("running sql script " + sqlFilePath + " on gfe");
        SQLHelper.runSQLScript(gConn, sqlFilePath, failOnError);
    }

    protected Connection getConnection(DBType dbType) {
        switch (dbType) {
            case DERBY: {
                return this.getDiscConnection();
            }
            case GFXD: {
                return this.getGFEConnection();
            }
        }
        throw new IllegalArgumentException("Invalid DB Type " + (Object)((Object)dbType));
    }

    protected void closeConnection(Connection conn, DBType dbType) {
        switch (dbType) {
            case DERBY: {
                this.closeDiscConnection(conn);
                break;
            }
            case GFXD: {
                this.closeGFEConnection(conn);
            }
        }
    }

    public static void HydraTask_createMaxTimestamp() {
        sqlTest.createMaxTimestamp();
    }

    protected void createMaxTimestamp() {
        Connection gConn = this.getGFEConnection();
        try {
            String createTableStmt = "create table trade.sample (id int not null constraint sample_pk primary key, stime timestamp, num int)";
            if (isOffheap) {
                createTableStmt = createTableStmt + OFFHEAPCLAUSE;
            }
            gConn.createStatement().execute(createTableStmt);
            Statement stmt = gConn.createStatement();
            String createIndexStmt = "create index sampleIndex on trade.sample (stime)";
            String createIndexNumStmt = "create index sampleNumIndex on trade.sample (num)";
            stmt.executeUpdate(createIndexStmt);
            stmt.executeUpdate(createIndexNumStmt);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_insertMaxTimestamp() {
        sqlTest.insertMaxTimestamp();
    }

    protected void insertMaxTimestamp() {
        String insert = "insert into trade.sample values (?,?,?)";
        Connection gConn = this.getGFEConnection();
        try {
            PreparedStatement stmt = gConn.prepareStatement(insert);
            int size = 10000;
            for (int i = 0; i < size; ++i) {
                int key = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.tradeCustomersPrimary);
                int num = random.nextInt();
                Timestamp time = new Timestamp(System.currentTimeMillis());
                stmt.setInt(1, key);
                stmt.setTimestamp(2, time);
                stmt.setInt(3, num);
                stmt.executeUpdate();
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_queryMaxTimestamp() {
        sqlTest.queryMaxTimestamp();
    }

    protected void queryMaxTimestamp() {
        ResultSet rs;
        PreparedStatement stmt;
        Connection gConn = this.getGFEConnection();
        String query = "select max(num) from trade.sample";
        try {
            Log.getLogWriter().info(query);
            stmt = gConn.prepareStatement(query);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                ResultSetHelper.sendBucketDumpMessage();
                throw new TestException(query + " after index created fails to get data");
            }
            int num = rs.getInt(1);
            Log.getLogWriter().info("max num is " + num);
            rs.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        query = "select max(stime) from trade.sample";
        try {
            Log.getLogWriter().info(query);
            stmt = gConn.prepareStatement(query);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new TestException(query + " after index created fails to get data");
            }
            Timestamp time = rs.getTimestamp(1);
            Log.getLogWriter().info("max stime is " + time);
            rs.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        query = "select avg(num) from trade.sample";
        try {
            Log.getLogWriter().info(query);
            stmt = gConn.prepareStatement(query);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                ResultSetHelper.sendBucketDumpMessage();
                throw new TestException(query + " after index created fail to get data");
            }
            Object num = rs.getObject(1);
            Log.getLogWriter().info("avg num is " + num);
            rs.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_checkFKConstraints() {
        if (!withReplicatedTables) {
            sqlTest.checkFKConstraints();
        }
    }

    protected void checkFKConstraints() {
        Connection gConn = this.getGFEConnection();
        this.checkFKConstraints(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void checkFKConstraints(Connection gConn) {
        if (!hasNetworth) {
            return;
        }
        List<Struct> buyorders = null;
        List<Struct> sellorders = null;
        List<Struct> portfolio = null;
        List<Struct> networth = null;
        List<Struct> customers = null;
        List<Struct> securities = null;
        List<Integer> buyordersCid = null;
        List<Integer> buyordersSid = null;
        List<Integer> sellordersCid = null;
        List<Integer> sellordersSid = null;
        List<String> sellordersCidSid = null;
        List<Integer> portfolioCid = null;
        List<Integer> portfolioSid = null;
        List<String> portfolioCidSid = null;
        List<Integer> networthCid = null;
        List<Integer> customersCid = null;
        List<Integer> securitiesSid = null;
        try {
            String sql = "select tableschemaname, tablename from sys.systables where tabletype = 'T' and tableschemaname not like 'SYS%'";
            ResultSet rs = gConn.createStatement().executeQuery(sql);
            Log.getLogWriter().info(sql);
            List<Struct> list = ResultSetHelper.asList(rs, false);
            SQLHelper.closeResultSet(rs, gConn);
            Log.getLogWriter().info(ResultSetHelper.listToString(list));
            for (Struct e : list) {
                Object[] table = e.getFieldValues();
                Log.getLogWriter().info("table name is " + table[1]);
                if ("buyorders".equalsIgnoreCase((String)table[1])) {
                    buyorders = this.getResultSet(gConn, (String)table[0], (String)table[1]);
                    continue;
                }
                if ("sellorders".equalsIgnoreCase((String)table[1])) {
                    sellorders = this.getResultSet(gConn, (String)table[0], (String)table[1]);
                    continue;
                }
                if ("portfolio".equalsIgnoreCase((String)table[1])) {
                    portfolio = this.getResultSet(gConn, (String)table[0], (String)table[1]);
                    continue;
                }
                if ("networth".equalsIgnoreCase((String)table[1])) {
                    networth = this.getResultSet(gConn, (String)table[0], (String)table[1]);
                    continue;
                }
                if ("customers".equalsIgnoreCase((String)table[1])) {
                    customers = this.getResultSet(gConn, (String)table[0], (String)table[1]);
                    continue;
                }
                if (!"securities".equalsIgnoreCase((String)table[1])) continue;
                securities = this.getResultSet(gConn, (String)table[0], (String)table[1]);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (buyorders != null) {
            buyordersCid = this.getCidFromRS(buyorders);
            buyordersSid = this.getSidFromRS(buyorders);
        }
        if (sellorders != null) {
            sellordersCid = this.getCidFromRS(sellorders);
            sellordersSid = this.getSidFromRS(sellorders);
            sellordersCidSid = this.getCidSidFromRS(sellorders);
        }
        if (portfolio != null) {
            portfolioCid = this.getCidFromRS(portfolio);
            portfolioSid = this.getSidFromRS(portfolio);
            portfolioCidSid = this.getCidSidFromRS(portfolio);
        }
        if (networth != null) {
            networthCid = this.getCidFromRS(networth);
        }
        if (customers != null) {
            customersCid = this.getCidFromRS(customers);
        }
        if (securities != null) {
            securitiesSid = this.getSecidFromRS(securities);
        }
        StringBuilder str = new StringBuilder();
        Log.getLogWriter().info("verify networth cid\n");
        StringBuilder violation = this.checkFKConstraint(customersCid, networthCid);
        if (violation.length() != 0) {
            str.append("networth has following cids which do not have a parent: ");
            str.append((CharSequence)violation);
        }
        Log.getLogWriter().info("verify portfolio cid\n");
        violation = this.checkFKConstraint(customersCid, portfolioCid);
        if (violation.length() != 0) {
            str.append("\nportfolio has following cids which do not have a parent: ");
            str.append((CharSequence)violation);
        }
        Log.getLogWriter().info("verify sellorders cid\n");
        violation = this.checkFKConstraint(customersCid, sellordersCid);
        if (violation.length() != 0) {
            str.append("\nsellorders has following cids which do not have a parent: ");
            str.append((CharSequence)violation);
        }
        Log.getLogWriter().info("verify buyorders cid\n");
        violation = this.checkFKConstraint(customersCid, buyordersCid);
        if (violation.length() != 0) {
            str.append("\nbuyorders has following cids which do not have a parent: ");
            str.append((CharSequence)violation);
        }
        Log.getLogWriter().info("verify portfolio sid\n");
        violation = this.checkFKConstraint(securitiesSid, portfolioSid);
        if (violation.length() != 0) {
            str.append("\nportfolio has following sids which do not have a parent: ");
            str.append((CharSequence)violation);
        }
        Log.getLogWriter().info("verify sellorders sid\n");
        violation = this.checkFKConstraint(securitiesSid, sellordersSid);
        if (violation.length() != 0) {
            str.append("\nsellorders has following sids which do not have a parent: ");
            str.append((CharSequence)violation);
        }
        Log.getLogWriter().info("verify buyorders sid\n");
        violation = this.checkFKConstraint(securitiesSid, buyordersSid);
        if (violation.length() != 0) {
            str.append("\nbuyorders has following sids which do not have a parent: ");
            str.append((CharSequence)violation);
        }
        Log.getLogWriter().info("verify sellorders cid_sid\n");
        violation = this.checkCompositeFKConstraint(portfolioCidSid, sellordersCidSid);
        if (violation.length() != 0) {
            str.append("\nsellorders has following cid_sid pair which do not have a parent: ");
            str.append((CharSequence)violation);
        }
        if (str.length() != 0) {
            throw new TestException("the foreign key constraint violation detected: " + str.toString());
        }
    }

    protected List<Struct> getResultSet(Connection gConn, String schema, String table) {
        String select = "select * from " + schema + "." + table;
        return this.getResultSet(gConn, select);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Struct> getResultSet(Connection gConn, String sqlQuery) {
        List<Struct> list;
        ResultSet rs = null;
        try {
            Log.getLogWriter().info(sqlQuery);
            rs = gConn.createStatement().executeQuery(sqlQuery);
            list = ResultSetHelper.asList(rs, false);
        }
        catch (SQLException se) {
            try {
                SQLHelper.handleSQLException(se);
            }
            catch (Throwable throwable) {
                SQLHelper.closeResultSet(rs, gConn);
                this.commit(gConn);
                throw throwable;
            }
            SQLHelper.closeResultSet(rs, gConn);
            this.commit(gConn);
            return null;
        }
        SQLHelper.closeResultSet(rs, gConn);
        this.commit(gConn);
        return list;
    }

    protected List<Integer> getCidFromRS(List<Struct> alist) {
        ArrayList<Integer> cids = new ArrayList<Integer>();
        for (Struct row : alist) {
            cids.add((Integer)row.get("CID"));
        }
        return cids;
    }

    protected List<Integer> getSidFromRS(List<Struct> alist) {
        ArrayList<Integer> cids = new ArrayList<Integer>();
        for (Struct row : alist) {
            cids.add((Integer)row.get("SID"));
        }
        return cids;
    }

    protected List<Integer> getSecidFromRS(List<Struct> alist) {
        ArrayList<Integer> cids = new ArrayList<Integer>();
        for (Struct row : alist) {
            cids.add((Integer)row.get("SEC_ID"));
        }
        return cids;
    }

    protected List<String> getCidSidFromRS(List<Struct> alist) {
        ArrayList<String> cidsids = new ArrayList<String>();
        for (Struct row : alist) {
            int cid = (Integer)row.get("CID");
            int sid = (Integer)row.get("SID");
            cidsids.add(cid + "_" + sid);
        }
        return cidsids;
    }

    protected StringBuilder checkFKConstraint(List<Integer> parent, List<Integer> child) {
        StringBuilder str = new StringBuilder();
        for (int c : child) {
            if (parent.contains(c)) continue;
            str.append(c + ", ");
        }
        return str;
    }

    protected StringBuilder checkCompositeFKConstraint(List<String> parent, List<String> child) {
        StringBuilder str = new StringBuilder();
        for (String c : child) {
            if (parent.contains(c)) continue;
            str.append(c + ", ");
        }
        return str;
    }

    public static void HydraTask_checkUniqConstraints() {
        if (!withReplicatedTables) {
            sqlTest.checkUniqConstraints();
        }
    }

    protected void checkUniqConstraints() {
        Connection gConn = this.getGFEConnection();
        this.checkUniqConstraints(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void checkUniqConstraints(Connection gConn) {
        List<Struct> uniqRS = this.getUniqKeys(gConn);
        List<Struct> uniqDistinictRS = this.getUniqDistinctKeys(gConn);
        ResultSetHelper.compareResultSets(uniqRS, uniqDistinictRS, "unique fields", "unique fields using distinct");
        Log.getLogWriter().info("verified the unique key constraints");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Struct> getUniqKeys(Connection gConn) {
        ResultSet rs = null;
        try {
            String select = "select symbol, exchange from trade.securities";
            Log.getLogWriter().info(select);
            rs = gConn.createStatement().executeQuery(select);
            List<Struct> list = ResultSetHelper.asList(rs, false);
            SQLHelper.closeResultSet(rs, gConn);
            this.commit(gConn);
            return list;
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            SQLHelper.closeResultSet(rs, gConn);
            this.commit(gConn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Struct> getUniqDistinctKeys(Connection gConn) {
        ResultSet rs = null;
        try {
            String select = "select distinct symbol, exchange from trade.securities";
            Log.getLogWriter().info(select);
            rs = gConn.createStatement().executeQuery(select);
            List<Struct> list = ResultSetHelper.asList(rs, false);
            SQLHelper.closeResultSet(rs, gConn);
            this.commit(gConn);
            return list;
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            SQLHelper.closeResultSet(rs, gConn);
            this.commit(gConn);
        }
        return null;
    }

    public static void HydraTask_checkConstraints() {
        if (!withReplicatedTables) {
            sqlTest.checkConstraints();
        }
    }

    protected void checkConstraints() {
        Connection gConn = this.getGFEConnection();
        this.checkUniqConstraints(gConn);
        this.checkFKConstraints(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void waitBeforeShutdown() {
        int sleepSec = TestConfig.tab().intAt(SQLPrms.sleepSecondBeforeShutdown, 300);
        Log.getLogWriter().info("sleep " + sleepSec + " seconds before shut down");
        MasterController.sleepForMs((int)(sleepSec * 1000));
    }

    public static void dumpResults() {
        try {
            ResultSetHelper.dumpLocalBucket();
        }
        catch (Exception e) {
            Log.getLogWriter().info(TestHelper.getStackTrace((Throwable)e));
        }
        try {
            ResultSetHelper.sendResultMessage();
        }
        catch (Exception e) {
            Log.getLogWriter().info(TestHelper.getStackTrace((Throwable)e));
        }
        if (hasDerbyServer && RemoteTestModule.getMyVmid() == 1) {
            SQLTest.dumpDerbyResults();
        }
    }

    public static void dumpDerbyResults() {
        new SQLTest().dumpDerbyTables();
    }

    private Connection getDerbyConnForDump() throws SQLException {
        if (testSecurity) {
            return ClientDiscDBManager.getSuperUserConnection();
        }
        return ClientDiscDBManager.getConnection();
    }

    private void dumpDerbyTables() {
        Connection dConn = null;
        List<Struct> myList = null;
        boolean success = true;
        try {
            dConn = this.getDerbyConnForDump();
            ResultSet rs = dConn.createStatement().executeQuery("select SCHEMANAME, tablename from sys.systables t, sys.sysschemas s where t.schemaid = s.schemaid and tabletype = 'T' and schemaname not like 'SYS%'");
            List<Struct> rsList = ResultSetHelper.asList(rs, true);
            for (Struct info : rsList) {
                String schemaName = (String)info.get("SCHEMANAME");
                String tableName = (String)info.get("TABLENAME");
                int count = 0;
                do {
                    try {
                        ++count;
                        dConn = this.getDerbyConnForDump();
                        myList = this.getResultSet(dConn, schemaName, tableName);
                        Log.getLogWriter().info("dump derby result set for table " + schemaName + "." + tableName);
                        Log.getLogWriter().info(ResultSetHelper.listToString(myList));
                        success = true;
                    }
                    catch (TestException te) {
                        Log.getLogWriter().info("dump derby table failed\n" + TestHelper.getStackTrace((Throwable)te));
                        success = false;
                        if (te.getMessage().contains("Error connecting to server")) {
                            Log.getLogWriter().info("derby has been shut down by master, there are no more dumps");
                            return;
                        }
                        MasterController.sleepForMs((int)1000);
                    }
                } while (!success && count < 2);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void dumpThreads() {
        long now;
        long start = System.currentTimeMillis();
        int time = dumpThreadsTotalTime * 1000;
        do {
            Log.getLogWriter().info("waiting for " + dumpThreadsInterval / 1000 + "seconds");
            MasterController.sleepForMs((int)dumpThreadsInterval);
            this.runDumpRunScript();
        } while ((now = System.currentTimeMillis()) - start < (long)time);
    }

    protected void runDumpRunScript() {
        File[] files;
        File currDir = new File(System.getProperty("user.dir"));
        for (File aFile : files = currDir.listFiles()) {
            if (!aFile.getName().equals("dumprun.sh") && !aFile.getName().equals("dumprun.bat")) continue;
            try {
                String cmd = aFile.getCanonicalPath();
                try {
                    Log.getLogWriter().info("Running dumprun scripts");
                    String cmdResult = ProcessMgr.fgexec((String)cmd, (int)0);
                    Log.getLogWriter().info("Result is " + cmdResult);
                }
                catch (HydraRuntimeException e) {
                    this.log().info("dumprun cmd " + cmd + " failed ", (Throwable)e);
                }
            }
            catch (IOException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
        }
    }

    public static void HydraTask_writePersistToBB() {
        sqlTest.writePersistToBB();
    }

    protected void writePersistToBB() {
        Connection gConn = this.getGFEConnection();
        this.writePersistToBB(gConn);
        this.closeGFEConnection(gConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePersistToBB(Connection gConn) {
        List<Struct> list = null;
        ResultSet rs = null;
        try {
            rs = gConn.createStatement().executeQuery("select tableschemaname, tablename from sys.systables where tabletype = 'T' ");
            while (rs.next()) {
                String schemaName = rs.getString(1);
                String tableName = rs.getString(2);
                list = this.getResultSet(gConn, schemaName, tableName);
                PersistBB.getBB().getSharedMap().put((Object)(schemaName + "_" + tableName), list);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            SQLHelper.closeResultSet(rs, gConn);
        }
    }

    public static void HydraTask_verifyPersistFromBB() {
        sqlTest.verifyPersistFromBB();
    }

    protected void verifyPersistFromBB() {
        Connection gConn = this.getGFEConnection();
        this.verifyPersistFromBB(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void verifyPersistFromBB(Connection gConn) {
        List<Struct> myList = null;
        List persistList = null;
        boolean throwException = false;
        StringBuffer str = new StringBuffer();
        try {
            ResultSet rs = gConn.createStatement().executeQuery("select tableschemaname, tablename from sys.systables where tabletype = 'T' and tableschemaname not like 'SYS%'");
            while (rs.next()) {
                String schemaName = rs.getString(1);
                String tableName = rs.getString(2);
                myList = this.getResultSet(gConn, schemaName, tableName);
                persistList = (List)PersistBB.getBB().getSharedMap().get((Object)(schemaName + "_" + tableName));
                try {
                    Log.getLogWriter().info("comparing result set for table " + schemaName + "." + tableName);
                    ResultSetHelper.compareResultSets(persistList, myList, "previous", "current");
                }
                catch (TestException te) {
                    Log.getLogWriter().info("do not throw Exception yet, until all tables are verified");
                    throwException = true;
                    str.append(te.getMessage() + "\n");
                }
            }
            if (throwException) {
                throw new TestException("verify results failed: " + str);
            }
            rs.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_verifyScrollableResultSet() {
        int chance = 5;
        if (random.nextInt(chance) == 1) {
            sqlTest.verifyScrollableResultSet();
        } else {
            sqlTest.doDMLOp();
        }
    }

    protected void verifyScrollableResultSet() {
        if (!hasDerbyServer) {
            Connection gConn = this.getGFEConnection();
            this.verifyScrollableResultSet(gConn);
            this.commit(gConn);
            this.closeGFEConnection(gConn);
            return;
        }
        if (!testUniqueKeys) {
            Log.getLogWriter().info("Could not verify results");
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.verifyScrollableResultSet(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
        this.closeDiscConnection(dConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyScrollableResultSet(Connection dConn, Connection gConn) {
        int maxCid = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary);
        int cid = random.nextInt(maxCid);
        int tid = this.getMyTid();
        String[] sql = new String[]{"select * from trade.networth where cid < " + cid + " and tid= " + tid + " order by cid", "select * from trade.customers where cid < " + cid + " and tid= " + tid + " order by cid", "select * from trade.portfolio where cid < " + cid + " and tid= " + tid + " order by cid, sid", "select * from trade.sellorders where cid < " + cid + " and tid= " + tid + " order by oid", "select * from trade.buyorders where cid < " + cid + " and tid= " + tid + " order by oid"};
        int whichOne = random.nextInt(sql.length);
        Statement d_stat = null;
        Statement s_stat = null;
        ResultSet derbyRs = null;
        ResultSet gfxdRs = null;
        try {
            d_stat = dConn.createStatement(1004, 1007);
            s_stat = gConn.createStatement(1004, 1007);
            Log.getLogWriter().info(sql[whichOne]);
            derbyRs = d_stat.executeQuery(sql[whichOne]);
            gfxdRs = s_stat.executeQuery(sql[whichOne]);
            int totalRows = 0;
            while (gfxdRs.next()) {
                ++totalRows;
            }
            gfxdRs.first();
            Log.getLogWriter().info("gfxd total rows are " + totalRows);
            boolean success = this.verifyScrollableRs(derbyRs, gfxdRs, tid, totalRows);
            if (!success) {
                derbyRs.first();
                gfxdRs.first();
                ResultSetHelper.compareSortedResultSets(derbyRs, gfxdRs);
            }
            d_stat.close();
            s_stat.close();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                Log.getLogWriter().info("gets derby lock issue, abort this operation");
                return;
            }
            if (!SQLHelper.checkGFXDException(gConn, se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("could not process scrollable rs due to node failure");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
        finally {
            try {
                if (d_stat != null) {
                    d_stat.close();
                }
                if (derbyRs != null) {
                    derbyRs.close();
                }
                if (s_stat != null) {
                    s_stat.close();
                }
                if (gfxdRs != null) {
                    gfxdRs.close();
                }
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean verifyScrollableRs(ResultSet derbyRs, ResultSet gfxdRs, int tid, int totalRows) {
        boolean success;
        int firstHalf;
        block20: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            if (totalRows != 0) break block16;
                            if (derbyRs.first()) {
                                Log.getLogWriter().warning("gfxd returns 0 rows, but derby returns rows");
                                ResultSetHelper.compareSortedResultSets(derbyRs, gfxdRs);
                            }
                            boolean bl = true;
                            return bl;
                        }
                        if (totalRows != 1) break block17;
                        derbyRs.first();
                        gfxdRs.first();
                        boolean bl = this.verifyRow(derbyRs, gfxdRs);
                        return bl;
                    }
                    firstHalf = totalRows / 2;
                    derbyRs.absolute(-(totalRows - firstHalf));
                    gfxdRs.absolute(-(totalRows - firstHalf));
                    success = this.verifyRow(derbyRs, gfxdRs);
                    if (success) break block18;
                    boolean bl = success;
                    return bl;
                }
                while (derbyRs.next()) {
                    gfxdRs.next();
                    success = this.verifyRow(derbyRs, gfxdRs);
                    if (success) continue;
                    boolean bl = success;
                    return bl;
                }
                derbyRs.absolute(firstHalf);
                gfxdRs.absolute(firstHalf);
                success = this.verifyRow(derbyRs, gfxdRs);
                if (success) break block19;
                boolean bl = success;
                return bl;
            }
            while (derbyRs.previous()) {
                gfxdRs.previous();
                success = this.verifyRow(derbyRs, gfxdRs);
                if (success) continue;
                boolean bl = success;
                return bl;
            }
            derbyRs.last();
            gfxdRs.last();
            success = this.verifyRow(derbyRs, gfxdRs);
            if (success) break block20;
            boolean bl = success;
            return bl;
        }
        try {
            derbyRs.relative(-firstHalf);
            gfxdRs.relative(-firstHalf);
            success = this.verifyRow(derbyRs, gfxdRs);
            if (!success) {
                boolean bl = success;
                return bl;
            }
        }
        catch (SQLException se) {
            block21: {
                if (!se.getSQLState().equalsIgnoreCase(X0Z01) || !isHATest) break block21;
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("could not process scrollable rs due to node failure");
                boolean bl = false;
                return bl;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean verifyRow(ResultSet derbyRs, ResultSet gfxdRs) {
        try {
            int derbyCid = derbyRs.getInt("CID");
            int gfxdCid = gfxdRs.getInt("CID");
            if (derbyCid != gfxdCid) {
                Log.getLogWriter().warning("Scrollable resultsets in gfxd gets different result sets: derbyRs gets " + derbyCid + " but gfxdRs gets " + gfxdCid);
            }
            return derbyCid == gfxdCid;
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            return false;
        }
    }

    protected void verifyScrollableResultSet(Connection gConn) {
        int maxCid = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary);
        int cid = random.nextInt(maxCid);
        int tid = this.getMyTid();
        String[] sql = new String[]{"select * from trade.networth where cid > " + cid, "select * from trade.customers where cid > " + cid + " order by cid", "select * from trade.portfolio where cid > " + cid + " order by cid, sid", "select * from trade.sellorders where cid > " + cid, "select * from trade.buyorders where cid > " + cid + " order by oid"};
        int whichOne = random.nextInt(sql.length);
        try {
            Statement s_stat = gConn.createStatement(1004, 1007);
            Log.getLogWriter().info(sql[whichOne]);
            ResultSet gfxdRs = s_stat.executeQuery(sql[whichOne]);
            int totalRows = 0;
            while (gfxdRs.next()) {
                ++totalRows;
            }
            Log.getLogWriter().info("gfxd total rows are " + totalRows);
            if (random.nextBoolean()) {
                this.processScrollableRs(gfxdRs, tid, totalRows);
            } else {
                this.verifyScrollableRs(gfxdRs, totalRows);
            }
            s_stat.close();
        }
        catch (SQLException se) {
            if (se.getSQLState().equals(X0Z01)) {
                Log.getLogWriter().info("could not process the row due to node failure, continuing the test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void verifyScrollableRs(ResultSet gfxdRs, int size) {
        try {
            gfxdRs.beforeFirst();
        }
        catch (SQLException se) {
            if (se.getSQLState().equals(X0Z01) && isHATest) {
                Log.getLogWriter().info("could not process resultset due to node failure");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
        List<Struct> list1 = ResultSetHelper.asList(gfxdRs, false);
        if (list1 == null) {
            Log.getLogWriter().info("could not process resultset due to node failure");
            return;
        }
        try {
            if (size > 1) {
                gfxdRs.absolute(random.nextInt(size));
                int sleepMs = 2000;
                MasterController.sleepForMs((int)sleepMs);
                gfxdRs.beforeFirst();
            } else {
                gfxdRs.beforeFirst();
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equals(X0Z01) && isHATest) {
                Log.getLogWriter().info("could not process resultset due to node failure");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
        List<Struct> list2 = ResultSetHelper.asList(gfxdRs, false);
        if (list2 == null) {
            Log.getLogWriter().info("could not process resultset due to node failure");
            return;
        }
        ResultSetHelper.compareResultSets(list1, list2, "firstScrolllableRs", "secondScrollableRs");
    }

    protected boolean processScrollableRs(ResultSet gfxdRs, int tid, int totalRows) {
        try {
            if (totalRows == 0) {
                return true;
            }
            if (totalRows == 1) {
                gfxdRs.first();
                return this.processRow(gfxdRs);
            }
            int firstHalf = totalRows / 2;
            gfxdRs.absolute(-(totalRows - firstHalf));
            boolean success = this.processRow(gfxdRs);
            if (!success) {
                return success;
            }
            while (gfxdRs.next()) {
                success = this.processRow(gfxdRs);
                if (success) continue;
                return success;
            }
            gfxdRs.absolute(firstHalf);
            success = this.processRow(gfxdRs);
            if (!success) {
                return success;
            }
            while (gfxdRs.previous()) {
                success = this.processRow(gfxdRs);
                if (success) continue;
                return success;
            }
            gfxdRs.last();
            success = this.processRow(gfxdRs);
            if (!success) {
                return success;
            }
            gfxdRs.first();
            success = this.processRow(gfxdRs);
            if (!success) {
                return success;
            }
        }
        catch (SQLException se) {
            if (!SQLHelper.checkGFXDException(false, se)) {
                return true;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean processRow(ResultSet gfxdRs) {
        try {
            if (alterTableDropColumn) {
                ResultSetMetaData rsmd = gfxdRs.getMetaData();
                int numOfColumns = rsmd.getColumnCount();
                for (int i = 0; i < numOfColumns; ++i) {
                    gfxdRs.getObject(i + 1);
                }
            } else {
                int cid = gfxdRs.getInt("CID");
                gfxdRs.getObject(3);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    public static void HydraTask_alterTableAddColumn() {
        sqlTest.alterTableAddColumn();
    }

    protected void alterTableAddColumn() {
        Connection gConn = this.getGFEConnection();
        this.addColumn(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_alterCustomersTableAddColumn() throws SQLException {
        sqlTest.alterCustomersTableAddColumn();
    }

    protected void alterCustomersTableAddColumn() throws SQLException {
        if (!hasDerbyServer) {
            Connection gConn = this.getGFEConnection();
            this.addColumnCustomersTable(gConn);
            this.commit(gConn);
            this.closeGFEConnection(gConn);
            return;
        }
        Connection dConn = this.getDiscConnection();
        this.addColumnCustomersTable(dConn);
        this.commit(dConn);
        this.closeDiscConnection(dConn);
        Connection gConn = this.getGFEConnection();
        this.addColumnCustomersTable(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void addColumnCustomersTable(Connection conn) throws SQLException {
        String addColumn = "alter table trade.customers add column cid_1 bigint";
        try {
            conn.createStatement().execute(addColumn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        Log.getLogWriter().info("executed " + addColumn + " in " + (SQLHelper.isDerbyConn(conn) ? "derby " : "gfxd "));
    }

    public static void HydraTask_createIndexOnAddedColumn() {
        sqlTest.createIndexOnAddedColumn();
    }

    protected void createIndexOnAddedColumn() {
        Connection gConn = this.getGFEConnection();
        this.createIndexOnAddedColumn(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void createIndexOnAddedColumn(Connection gConn) {
        String sql = "create index indexcid_1 on trade.customers (cid_1)";
        try {
            this.log().info(sql);
            this.executeStatement(gConn, sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void addColumn(Connection conn) {
        try {
            ResultSet rs = conn.createStatement().executeQuery("select tablename from sys.systables where tabletype = 'T' and tableschemaname='TRADE'");
            while (rs.next()) {
                String tableName = rs.getString(1);
                if (tableName.equalsIgnoreCase("txhistory")) continue;
                this.addColumn(conn, tableName);
            }
            rs.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void addColumn(Connection conn, String tableName) throws SQLException {
        String columnDef = (String)SQLBB.getBB().getSharedMap().get((Object)("dropColumn" + tableName));
        String addColumn = "alter table trade." + tableName + " add column " + columnDef;
        try {
            conn.createStatement().execute(addColumn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        Log.getLogWriter().info("added the column " + columnDef + " to the table " + tableName);
    }

    protected void addColumn(Connection conn, String schema, String tableName, String columnName, String dataType) {
        String sql = "alter table trade." + tableName + " add column " + columnName + " " + dataType + " not null";
        this.addColumn(conn, sql, true);
        sql = "alter table trade." + tableName + " add column " + columnName + " " + dataType + (dataType.toUpperCase().startsWith("VARCHAR") ? " default 'a' not null" : " ");
        this.addColumn(conn, sql, false);
        Log.getLogWriter().info("added the column " + columnName + " to the table " + tableName);
    }

    protected void addColumn(Connection conn, String sql, boolean expectNotNullFailure) {
        try {
            conn.createStatement().execute(sql);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42601") && expectNotNullFailure) {
                this.log().info("got expected not null column with default value failure");
            }
            if (reproduceTicket46689) {
                if (se.getSQLState().equals("X0X95")) {
                    this.log().info("got expected exception, continuing testing");
                }
                throw new TestException("got #46889, alter table does not get expected X0X95 when result set is not closed");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_alterTableDropColumn() {
        if (useGenericSQL) {
            sqlGen.alterTable();
        } else {
            sqlTest.alterTableDropColumn();
        }
    }

    protected void alterTableDropColumn() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.dropColumn(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void dropColumn(Connection dConn, Connection gConn) {
        try {
            ResultSet rs = gConn.createStatement().executeQuery("select tablename from sys.systables where tabletype = 'T' and tableschemaname='TRADE'");
            while (rs.next()) {
                String tableName = rs.getString(1);
                if (tableName.equalsIgnoreCase("txhistory") || tableName.equalsIgnoreCase("TRADES")) continue;
                this.dropColumn(dConn, gConn, tableName);
                this.commit(dConn);
                this.commit(gConn);
            }
            rs.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void dropColumn(Connection dConn, Connection gConn, String tableName) throws SQLException {
        Struct aColumn;
        ResultSet columns = null;
        DatabaseMetaData meta = gConn.getMetaData();
        SQLException derbyException = null;
        SQLException gfxdException = null;
        columns = meta.getColumns(null, "TRADE", tableName, null);
        List<Struct> columnList = ResultSetHelper.asList(columns, false);
        SQLHelper.closeResultSet(columns, gConn);
        this.log().info("columns are " + ResultSetHelper.listToString(columnList));
        String columnType = null;
        String columnName = null;
        do {
            aColumn = columnList.get(random.nextInt(columnList.size()));
            columnType = (String)aColumn.get("TYPE_NAME");
        } while ((columnName = (String)aColumn.get("COLUMN_NAME")).equals("TID"));
        if (hasDerbyServer) {
            try {
                this.dropColumn(dConn, tableName, columnName);
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(dConn, se)) {
                    dConn.rollback();
                    this.log().info("could not finish op, roll back the operation in derby");
                    return;
                }
                derbyException = se;
                SQLHelper.printSQLException(se);
            }
            try {
                this.dropColumn(gConn, tableName, columnName);
            }
            catch (SQLException se) {
                gfxdException = se;
                SQLHelper.printSQLException(se);
            }
            if (gfxdException != null) {
                if (gfxdException.getSQLState().equals(X0Z01) && isHATest) {
                    dConn.rollback();
                    return;
                }
                if (gfxdException.getSQLState().equals("0A000") && this.isPartitionedColumn(tableName, columnName)) {
                    dConn.rollback();
                    this.log().info("roll back the operations in derby");
                    return;
                }
                if (gfxdException.getSQLState().equals("0A000") && this.isPrimaryKeyColumn(tableName, columnName)) {
                    dConn.rollback();
                    this.log().info("roll back the operations in derby");
                    return;
                }
            }
            SQLHelper.compareExceptions(derbyException, gfxdException);
            SQLBB.getBB().getSharedMap().put((Object)("dropColumn" + tableName), (Object)(columnName + " " + columnType));
        } else {
            try {
                this.dropColumn(gConn, tableName, columnName);
            }
            catch (SQLException se) {
                gfxdException = se;
                SQLHelper.printSQLException(se);
            }
            if (gfxdException != null) {
                if (gfxdException.getSQLState().equals(X0Z01) && isHATest) {
                    return;
                }
                if (gfxdException.getSQLState().equals("0A000") && this.isPartitionedColumn(tableName, columnName)) {
                    return;
                }
                if (gfxdException.getSQLState().equals("0A000") && this.isPrimaryKeyColumn(tableName, columnName)) {
                    return;
                }
                if (gfxdException.getSQLState().equals("X0Y25")) {
                    this.log().info("drop column with data got expected excetpion, continuing tests");
                }
            }
        }
    }

    protected boolean isPartitionedColumn(String tableName, String columnName) {
        ArrayList partitionKeys = new ArrayList();
        SharedMap partitionMap = SQLBB.getBB().getSharedMap();
        SharedMap wanPartitionMap = SQLWanBB.getBB().getSharedMap();
        if (!isWanTest) {
            partitionKeys = (ArrayList)partitionMap.get((Object)(tableName.toLowerCase() + "Partition"));
        } else {
            int myWanSite = this.getMyWanSite();
            partitionKeys = (ArrayList)wanPartitionMap.get((Object)(myWanSite + "_" + tableName.toLowerCase() + "Partition"));
        }
        String partitionField = columnName.toLowerCase();
        if (partitionField.equals("subtotal")) {
            partitionField = "subTotal";
        }
        if (partitionField.equals("loanlimit")) {
            partitionField = "loanLimit";
        }
        if (partitionField.equals("uid")) {
            partitionField = "_uid";
        }
        if (partitionField.equals("availqty")) {
            partitionField = "availQty";
        }
        if (partitionKeys.contains(partitionField)) {
            this.log().info(columnName + " is a partitioned column of " + tableName);
            return true;
        }
        this.log().info(columnName + " is not a partitioned column of " + tableName);
        return false;
    }

    protected boolean isPrimaryKeyColumn(String tableName, String columnName) {
        if (tableName.equalsIgnoreCase("customers") && columnName.equalsIgnoreCase("CID")) {
            return true;
        }
        if (tableName.equalsIgnoreCase("securities") && columnName.equalsIgnoreCase("SEC_ID")) {
            return true;
        }
        if (tableName.equalsIgnoreCase("networth") && columnName.equalsIgnoreCase("CID")) {
            return true;
        }
        if (tableName.equalsIgnoreCase("portfolio") && (columnName.equalsIgnoreCase("CID") || columnName.equalsIgnoreCase("SID"))) {
            return true;
        }
        if (tableName.equalsIgnoreCase("sellorders") && columnName.equalsIgnoreCase("OID")) {
            return true;
        }
        if (tableName.equalsIgnoreCase("buyorders") && columnName.equalsIgnoreCase("OID")) {
            return true;
        }
        if (tableName.equalsIgnoreCase("companies") && (columnName.equalsIgnoreCase("SYMBOL") || columnName.equalsIgnoreCase("Exchange"))) {
            return true;
        }
        if (tableName.equalsIgnoreCase("customerprofile") && columnName.equalsIgnoreCase("CID")) {
            return true;
        }
        return tableName.equalsIgnoreCase("sellordersdup") && columnName.equalsIgnoreCase("OID");
    }

    protected void dropColumn(Connection conn, String tableName, String columnName) throws SQLException {
        String dropColumn = "alter table trade." + tableName + " drop" + (random.nextBoolean() ? " column " : " ") + columnName + " RESTRICT ";
        Log.getLogWriter().info("in " + (SQLHelper.isDerbyConn(conn) ? "derby " : "gfxd ") + "dropping the column " + columnName + " in table " + tableName);
        conn.createStatement().execute(dropColumn);
    }

    public static void HydraTask_updateAddedColumn() {
        sqlTest.updateAddedColumn();
    }

    protected void updateAddedColumn() {
        Connection gConn = this.getGFEConnection();
        this.updateColumn(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void updateColumn(Connection conn) {
        try {
            ResultSet rs = conn.createStatement().executeQuery("select tablename from sys.systables where tabletype = 'T' and tableschemaname='TRADE'");
            while (rs.next()) {
                String tableName = rs.getString(1);
                if (tableName.equalsIgnoreCase("txhistory")) continue;
                this.updateColumn(conn, tableName);
            }
            rs.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void updateColumn(Connection conn, String tableName) throws SQLException {
        String columnDef = (String)SQLBB.getBB().getSharedMap().get((Object)("dropColumn" + tableName));
        String[] column = columnDef.split(" ");
        this.updateColumn(conn, tableName, tableName, column[1]);
    }

    protected void updateColumn(Connection conn, String tableName, String columnName, String type) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        String update = null;
        PreparedStatement ps = null;
        if (tableName.equalsIgnoreCase("customers")) {
            sql = "select cid, " + columnName + " from trade." + tableName;
            update = "update trade.customers set " + columnName + " =? where cid = ?";
            ps = conn.prepareStatement(update);
            rs = conn.createStatement().executeQuery(sql);
            while (rs.next()) {
                ps.setObject(1, rs.getObject(2));
                ps.setInt(2, rs.getInt(1));
                ps.execute();
            }
            rs.close();
        }
    }

    public static void HydraTask_verifyDropColumn() {
        sqlTest.verifyDropColumn();
    }

    protected void verifyDropColumn() {
        Connection gConn = this.getGFEConnection();
        this.verifyDropColumn(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void verifyDropColumn(Connection conn) {
        try {
            ResultSet rs = conn.createStatement().executeQuery("select tablename from sys.systables where tabletype = 'T' and tableschemaname='TRADE'");
            while (rs.next()) {
                String tableName = rs.getString(1);
                if (tableName.equalsIgnoreCase("txhistory")) continue;
                this.verifyDropColumn(conn, tableName);
            }
            rs.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void verifyDropColumn(Connection conn, String tableName) throws SQLException {
        String select;
        block2: {
            String columnDef = (String)SQLBB.getBB().getSharedMap().get((Object)("dropColumn" + tableName));
            String[] column = columnDef.split(" ");
            String columnName = column[0];
            select = "select " + columnName + " from trade." + tableName;
            try {
                conn.createStatement().execute(select);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (!se.getCause().equals("42X04") || !alterTableDropColumn) break block2;
                Log.getLogWriter().info("get the expected exception after drop column, continuing tests");
                return;
            }
        }
        throw new TestException(select + " does not get exception after the column is dropped");
    }

    public static void HydraTask_alterTableGenerateIdAlways() {
        sqlTest.alterTableGenerateIdAlways();
    }

    protected void alterTableGenerateIdAlways() {
        Connection gConn = this.getGFEConnection();
        this.alterTableGenerateIdAlways(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void alterTableGenerateIdAlways(Connection conn) {
        try {
            String sql = "alter table trade.customers ALTER" + (random.nextBoolean() ? " column " : " ") + "cid SET GENERATED ALWAYS AS IDENTITY ";
            Log.getLogWriter().info(sql);
            conn.createStatement().execute(sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_dropCompositUniqueKeyColumns() {
        sqlTest.dropCompositUniqueKeyColumns();
    }

    protected void dropCompositUniqueKeyColumns() {
        Connection gConn = this.getGFEConnection();
        boolean ableToDropSymbolCol = this.dropCompositUniqueKeyColumn(gConn, false);
        if (!ableToDropSymbolCol) {
            return;
        }
        this.removeUniqueKeyContraint(gConn);
        this.dropCompositUniqueKeyColumn(gConn, true);
        this.verifyColumnDropped(gConn, "trade", "securities", "symbol");
        this.addColumn(gConn, "trade", "securities", "symbol", "varchar (10)");
        this.getDataForDroppedColumn(gConn, "trade", "securities", "symbol");
        this.addBackUQConstraint(gConn, "trade", "securities");
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_dropCompositUniqueKeyConstraint() {
        sqlTest.dropCompositUniqueKeyConstraint();
    }

    protected void dropCompositUniqueKeyConstraint() {
        Connection gConn = this.getGFEConnection();
        this.removeUniqueKeyContraint(gConn);
        this.addBackUQConstraint(gConn, "trade", "securities");
        this.closeGFEConnection(gConn);
    }

    protected void addBackUQConstraint(Connection conn, String schema, String tableName) {
        String sql = "alter table trade." + tableName + " add constraint sec_uq unique (symbol, exchange)";
        try {
            conn.createStatement().execute(sql);
            this.log().info(sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void getDataForDroppedColumn(Connection gConn, String schema, String table, String droppedColumnName) {
        String sql = null;
        ResultSet rs = null;
        List<Struct> data = null;
        String[] primaryKey = new String[2];
        List<Struct> keyList = null;
        DatabaseMetaData meta = null;
        try {
            meta = gConn.getMetaData();
            rs = meta.getPrimaryKeys(null, schema, table.toUpperCase());
            keyList = ResultSetHelper.asList(rs, false);
            rs.close();
            if (hasDerbyServer) {
                Connection dConn = this.getDiscConnection();
                meta = dConn.getMetaData();
                rs = meta.getPrimaryKeys(null, null, table.toUpperCase());
            }
            keyList = ResultSetHelper.asList(rs, true);
            SQLHelper.closeResultSet(rs, gConn);
            int i = 0;
            for (Struct key : keyList) {
                primaryKey[i] = (String)key.get("COLUMN_NAME");
                ++i;
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (hasDerbyServer) {
            try {
                sql = "select " + primaryKey[0] + ", " + (keyList.size() == 2 ? primaryKey[1] + ", " : "") + droppedColumnName + " from " + schema + "." + table;
                rs = this.getDiscConnection().createStatement().executeQuery(sql);
                data = ResultSetHelper.asList(rs, true);
                if (data == null) {
                    throw new TestException("test issue, make sure derby result could be gotten");
                }
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
        try {
            if (keyList.size() == 1) {
                sql = "update " + schema + "." + table + " set " + droppedColumnName + " = ? where " + primaryKey[0] + " = ?";
            } else if (keyList.size() == 2) {
                sql = "update " + schema + "." + table + " set " + droppedColumnName + " = ? where " + primaryKey[0] + " = ? and " + primaryKey[1] + " = ?";
            } else {
                throw new TestException("primary key list has wrong size " + keyList.size());
            }
            PreparedStatement ps = gConn.prepareStatement(sql);
            this.log().info(sql);
            for (Struct row : data) {
                ps.setObject(1, row.get(droppedColumnName.toUpperCase()));
                ps.setObject(2, row.get(primaryKey[0]));
                if (keyList.size() == 2) {
                    ps.setObject(3, row.get(primaryKey[1]));
                }
                ps.addBatch();
            }
            ps.executeBatch();
            ps.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyColumnDropped(Connection gConn, String schema, String table, String droppedcolumnName) {
        String sql = "select " + droppedcolumnName + " from " + schema + "." + table;
        ResultSet rs = null;
        try {
            rs = gConn.createStatement().executeQuery(sql);
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("42X04") && alterTableDropColumn) {
                this.log().info("Got expected exception for dropped column");
            } else {
                SQLHelper.handleSQLException(se);
            }
        }
        finally {
            SQLHelper.closeResultSet(rs, gConn);
        }
        if (hasDerbyServer) {
            try {
                rs = gConn.createStatement().executeQuery("select * from " + schema + "." + table);
                ResultSetMetaData rmd = rs.getMetaData();
                int columnSize = rmd.getColumnCount();
                StringBuilder columnNames = new StringBuilder();
                for (int i = 1; i <= columnSize; ++i) {
                    if (i < columnSize) {
                        columnNames.append(rmd.getColumnName(i) + ", ");
                        continue;
                    }
                    columnNames.append(rmd.getColumnName(i));
                }
                sql = "select " + columnNames.toString() + " from " + schema + "." + table;
                this.log().info(sql);
                ResultSet derbyRs = this.getDiscConnection().createStatement().executeQuery(sql);
                ResultSetHelper.compareResultSets(derbyRs, rs);
                if (!reproduceTicket46689) {
                    rs.close();
                    derbyRs.close();
                }
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected boolean dropCompositUniqueKeyColumn(Connection conn, boolean constraintDropped) {
        try {
            boolean withRestrict = random.nextBoolean();
            withRestrict = true;
            String sql = "alter table trade.securities drop" + (random.nextBoolean() ? " column " : " ") + "symbol " + (withRestrict ? " restrict " : " ");
            Log.getLogWriter().info(sql);
            conn.createStatement().execute(sql);
            if (!constraintDropped) {
                throw new TestException("does not get expected exception for unique constraint when dropping a unique key column");
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("X0Y25")) {
                if (!constraintDropped) {
                    Log.getLogWriter().info("got expected exception when dropping column with constraint");
                }
                throw new TestException("got unexpected exception dropping column after constraint has been dropped" + TestHelper.getStackTrace((Throwable)se));
            }
            if (se.getSQLState().equals("0A000") && this.partitionedOnSymbol()) {
                Log.getLogWriter().info("could not drop column due to paritioned key");
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean partitionedOnSymbol() {
        ArrayList partitionKey = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"securitiesPartition");
        for (String column : partitionKey) {
            if (!column.equalsIgnoreCase("symbol")) continue;
            return true;
        }
        return false;
    }

    protected void removeUniqueKeyContraint(Connection conn) {
        try {
            String sql = "alter table trade.securities drop unique SEC_UQ ";
            Log.getLogWriter().info(sql);
            conn.createStatement().execute(sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_exportTables() {
        sqlTest.exportTables();
    }

    protected void exportTables() {
        Connection gConn = this.getGFEConnection();
        this.exportTables(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void exportTables(Connection conn) {
        ArrayList<String[]> tables = this.getTableNames(conn);
        for (String[] table : tables) {
            this.exportTable(conn, table[0], table[1]);
        }
    }

    protected void exportTable(Connection conn, String schema, String table) {
        String exportTable = "CALL SYSCS_UTIL.EXPORT_TABLE (?, ?, ?, null, null, null)";
        try {
            CallableStatement cs = conn.prepareCall(exportTable);
            cs.setString(1, schema);
            cs.setString(2, table);
            cs.setString(3, FabricServerHelper.getFabricServerDescription().getSysDir() + "/" + table.toUpperCase() + ".file");
            cs.execute();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_truncateTables() {
        if (supportDuplicateTables) {
            sqlTest.dropTriggers();
            sqlTest.truncateDuplicateTables(DUPLICATE_TABLE_SUFFIX);
        }
        sqlTest.truncateTables();
        if (supportDuplicateTables) {
            sqlTest.createTriggers();
        }
    }

    protected void truncateTables() {
        Connection gConn = this.getGFEConnection();
        if (this.getMyTid() == ddlThread) {
            this.truncateTables(gConn);
        } else {
            this.performConcurrentDMLOps(gConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void truncateTables(Connection conn) {
        ArrayList<String[]> tables = this.getTableNames(conn);
        for (String[] table : tables) {
            this.truncateTable(conn, table[0], table[1], true);
        }
    }

    protected void performConcurrentDMLOps(Connection conn) {
        int numOfOps = 20;
        for (int i = 0; i < numOfOps; ++i) {
            this.doDMLOp(null, conn);
        }
    }

    public static void HydraTask_truncateTablesInOrder() {
        if (supportDuplicateTables) {
            sqlTest.dropTriggers();
        }
        sqlTest.truncateTablesInOrder();
        if (supportDuplicateTables) {
            sqlTest.createTriggers();
        }
    }

    protected void truncateTablesInOrder() {
        Connection gConn = this.getGFEConnection();
        this.truncateTablesInOrder(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void truncateTablesInOrder(Connection conn) {
        String[] tables;
        String schema = "trade";
        for (String table : tables = new String[]{"txhistory", "sellorders", "buyorders", "portfolio", "networth", "customers", "securities"}) {
            this.truncateTable(conn, schema, table, false);
        }
    }

    protected void truncateTable(Connection conn, String schema, String table, boolean expectException) {
        String truncate = "truncate table " + schema + "." + table;
        try {
            Log.getLogWriter().info("executing " + truncate);
            conn.createStatement().executeUpdate(truncate);
            Log.getLogWriter().info("finished " + truncate);
        }
        catch (SQLException se) {
            if (expectException && se.getSQLState().equals("XCL48")) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("failed to execute " + truncate);
            }
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_verifyTruncatedTables() {
        sqlTest.verifyTruncatedTables();
    }

    protected void verifyTruncatedTables() {
        Connection gConn = this.getGFEConnection();
        this.verifyTruncatedTables(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void verifyTruncatedTables(Connection conn) {
        ArrayList<String[]> tables = this.getTableNames(conn);
        for (String[] table : tables) {
            this.verifyTruncatedTable(conn, table[0], table[1], false);
        }
    }

    protected void verifyTruncatedTable(Connection conn, String schema, String table, boolean expectException) {
        String sql = "select * from " + schema + "." + table;
        try {
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Log.getLogWriter().info(sql);
            List<Struct> list = ResultSetHelper.asList(rs, false);
            SQLHelper.closeResultSet(rs, conn);
            if (list.size() > 0) {
                throw new TestException("after truncate table, the following rows are still in the table:\n" + ResultSetHelper.listToString(list));
            }
            Log.getLogWriter().info("verified that the table " + table + " has been truncated");
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_alterTableGenerateDefaultId() {
        sqlTest.alterTableGenerateDefaultId();
    }

    protected void alterTableGenerateDefaultId() {
        Connection gConn = this.getGFEConnection();
        this.alterTableGenerateDefaultId(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void alterTableGenerateDefaultId(Connection conn) {
        int startKey = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary);
        boolean setIncrement = random.nextBoolean();
        try {
            String increment = null;
            if (setIncrement) {
                increment = "alter table trade.customers ALTER" + (random.nextBoolean() ? " column " : " ") + "cid" + " SET INCREMENT BY 1 ";
            }
            if (increment != null) {
                Log.getLogWriter().info(increment);
                conn.createStatement().execute(increment);
            }
            String restart = null;
            if (startKey != 0 || !setIncrement || random.nextBoolean()) {
                restart = "alter table trade.customers ALTER" + (random.nextBoolean() ? " column " : " ") + "cid" + " RESTART WITH " + ++startKey;
            }
            if (restart != null) {
                Log.getLogWriter().info(restart);
                conn.createStatement().execute(restart);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_repopulateAfterTruncateTable() {
        sqlTest.repopulateAfterTruncateTable();
    }

    protected void repopulateAfterTruncateTable() {
        Connection gConn = this.getGFEConnection();
        this.repopulateAfterTruncateTable(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void repopulateAfterTruncateTable(Connection conn) {
        String[] tables;
        String schema = "trade";
        for (String table : tables = new String[]{"customers", "securities", "networth", "portfolio", "buyorders", "sellorders", "txhistory"}) {
            if (random.nextBoolean()) {
                this.importTable(conn, schema, table);
                continue;
            }
            this.importTableEx(conn, schema, table);
        }
    }

    protected void importTable(Connection conn, String schema, String table) {
        String importTable = "CALL SYSCS_UTIL.IMPORT_TABLE (?, ?, ?, null, null, null, 0)";
        Log.getLogWriter().info(importTable + " with table " + table);
        try {
            CallableStatement cs = conn.prepareCall(importTable);
            cs.setString(1, schema);
            cs.setString(2, table);
            cs.setString(3, FabricServerHelper.getFabricServerDescription().getSysDir() + "/" + table.toUpperCase() + ".file");
            cs.execute();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void importTableEx(Connection conn, String schema, String table) {
        String importTable = "CALL SYSCS_UTIL.IMPORT_TABLE_EX (?, ?, ?, null, null, null, 0, 0, 6, 0, null, null)";
        Log.getLogWriter().info(importTable + " with table " + table);
        try {
            CallableStatement cs = conn.prepareCall(importTable);
            cs.setString(1, schema);
            cs.setString(2, table);
            cs.setString(3, FabricServerHelper.getFabricServerDescription().getSysDir() + "/" + table.toUpperCase() + ".file");
            cs.execute();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_verifyTicket46046() {
        sqlTest.verifyTicket46046();
    }

    protected void verifyTicket46046() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.verifyTicket46046(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyTicket46046(Connection dConn, Connection gConn) {
        Log.getLogWriter().info("verifying ticket #46046, myTid is " + this.getMyTid());
        try {
            String select = "select cust_name from trade.customers";
            ResultSet rs = gConn.createStatement().executeQuery(select);
            String name = null;
            if (!rs.next()) {
                throw new TestException("no rows in customers table yet");
            }
            name = rs.getString(1);
            rs.close();
            Log.getLogWriter().info("cust_name is: " + name + ".");
            select = "select * from trade.customers where cust_name = '" + name.trim() + "'";
            Log.getLogWriter().info(select);
            ResultSet dRS = dConn.createStatement().executeQuery(select);
            ResultSet sRS = gConn.createStatement().executeQuery(select);
            List<Struct> dList = ResultSetHelper.asList(dRS, true);
            List<Struct> sList = ResultSetHelper.asList(sRS, true);
            ResultSetHelper.compareResultSets(dList, sList);
            SQLHelper.closeResultSet(sRS, gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        finally {
            this.commit(dConn);
            this.commit(gConn);
        }
    }

    protected LogWriter log() {
        return Log.getLogWriter();
    }

    public static void HydraTask_createUDTPriceType() {
        sqlTest.createUDTPriceType();
    }

    protected void createUDTPriceType() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
            this.createUDTPriceType(dConn);
        }
        Connection gConn = this.getGFEConnection();
        this.createUDTPriceType(gConn);
        this.commit(dConn);
        this.commit(gConn);
    }

    protected void createUDTPriceType(Connection conn) {
        String sql = "CREATE TYPE trade.UDTPrice EXTERNAL NAME 'sql.sqlutil.UDTPrice' LANGUAGE JAVA";
        this.log().info("executing " + sql);
        try {
            conn.createStatement().execute(sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_createUUIDType() {
        sqlTest.createUUIDType();
    }

    protected void createUUIDType() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
            this.createUUIDType(dConn);
        }
        Connection gConn = this.getGFEConnection();
        this.createUUIDType(gConn);
        this.commit(dConn);
        this.commit(gConn);
    }

    protected void createUUIDType(Connection conn) {
        String sql = "CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA";
        this.log().info("executing " + sql);
        try {
            conn.createStatement().execute(sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_dropCompaniesFK() {
        sqlTest.dropCompaniesFK();
    }

    protected void dropCompaniesFK() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.dropCompaniesFK(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done drop fk Op");
    }

    protected void dropCompaniesFK(Connection dConn, Connection gConn) {
        if (dConn != null) {
            this.log().info("derby executing ");
            this.dropCompaniesFK(dConn);
        }
        this.log().info("gfxd executing ");
        this.dropCompaniesFK(gConn);
    }

    protected void dropCompaniesFK(Connection conn) {
        String sql = "alter table trade.companies drop " + (random.nextBoolean() ? "foreign key" : "constraint") + " comp_fk ";
        try {
            this.log().info("executing " + sql);
            conn.createStatement().execute(sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_addCompaniesFK() {
        if (ticket46803fixed) {
            sqlTest.addCompaniesFK();
        }
    }

    protected void addCompaniesFK() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.addCompaniesFK(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done add fk Op");
    }

    protected void addCompaniesFK(Connection dConn, Connection gConn) {
        String sql = "alter table trade.companies add constraint comp_fk foreign key (symbol, exchange) references trade.securities (symbol, exchange) on delete restrict";
        boolean rollback = false;
        try {
            if (dConn != null) {
                this.log().info("derby executing " + sql);
                dConn.createStatement().execute(sql);
            }
            this.log().info("gfxd executing " + sql);
            gConn.createStatement().execute(sql);
        }
        catch (SQLException se) {
            if ((se.getSQLState().equalsIgnoreCase("42ZB6") || se.getSQLState().equalsIgnoreCase("0A000")) && this.isPartitionedOnSubsetOfSecuritiesUniqueKey()) {
                this.log().info("could not add foreign key constraint when parent is partitioned on the subset of unique key columns, roll back this op");
                rollback = true;
            }
            if (se.getSQLState().equalsIgnoreCase("X0Y45") && setTx && dConn == null) {
                this.log().info("could not add fk constarint using txn without derby server");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
        if (rollback) {
            try {
                if (dConn != null) {
                    this.log().info("derby rollback " + sql);
                    dConn.rollback();
                }
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected boolean isPartitionedOnSubsetOfSecuritiesUniqueKey() {
        ArrayList secPartition = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"securitiesPartition");
        return secPartition.contains("symbol") || secPartition.contains("exchange");
    }

    public static void hydraTask_createUDTPriceFunctions() {
        sqlTest.createUDTPriceFunctions();
    }

    protected void createUDTPriceFunctions() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.createUDTPriceFunction(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done create function for UDTPrice");
    }

    protected void createUDTPriceFunction(Connection dConn, Connection gConn) {
        if (dConn != null) {
            this.log().info("derby executing");
            this.createUDTPriceFunction(dConn);
        }
        this.log().info("gfxd executing");
        this.createUDTPriceFunction(gConn);
    }

    protected void createUDTPriceFunction(Connection conn) {
        String getLowPrice = "create function trade.getLowPrice(DP1 trade.UDTPrice) RETURNS NUMERIC PARAMETER STYLE JAVA LANGUAGE JAVA NO SQL EXTERNAL NAME 'sql.sqlutil.UDTPrice.getLowPrice'";
        String getHighPrice = "create function trade.getHighPrice(DP1 trade.UDTPrice) RETURNS NUMERIC PARAMETER STYLE JAVA LANGUAGE JAVA NO SQL EXTERNAL NAME 'sql.sqlutil.UDTPrice.getHighPrice'";
        try {
            this.log().info("xecuting " + getLowPrice);
            this.executeStatement(conn, getLowPrice);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        try {
            this.log().info("executing " + getHighPrice);
            this.executeStatement(conn, getHighPrice);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void executeStatement(Connection conn, String sql) throws SQLException {
        conn.createStatement().execute(sql);
    }

    public static void HydraTask_createIndexOnCompanies() {
        sqlTest.createIndexOnCompanies();
    }

    protected void createIndexOnCompanies() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.createIndexOnCompanies(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        if (dConn != null) {
            try {
                this.listIndexCreated(dConn, "trade", "companies");
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
        try {
            this.listIndexCreated(gConn, "trade", "companies");
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.commit(dConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
        this.closeDiscConnection(dConn);
    }

    protected void createIndexOnCompanies(Connection dConn, Connection gConn) {
        String sql = "create index trade.indexcompaniestid on trade.companies (tid)";
        try {
            this.log().info(sql);
            if (dConn != null) {
                this.executeStatement(dConn, sql);
            }
            this.executeStatement(gConn, sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_createCompaniesTable() {
        sqlTest.createCompaniesTable();
    }

    protected void createCompaniesTable() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.createCompaniesTable(dConn, gConn);
        this.commit(dConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
        this.closeDiscConnection(dConn);
    }

    protected void createCompaniesTable(Connection dConn, Connection gConn) {
        String sql = "create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol, exchange), constraint comp_fk foreign key (symbol, exchange) references trade.securities (symbol, exchange) on delete restrict)";
        try {
            this.log().info(sql);
            if (dConn != null) {
                this.executeStatement(dConn, sql);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        boolean reproduce51726 = false;
        if (reproduce51726) {
            String wrongPartition = " partition by range (symbol) (VALUES BETWEEN 'a' AND 'd', VALUES BETWEEN 'd' AND 'i', VALUES BETWEEN 'i' AND 'k', VALUES BETWEEN 'k' AND 'o', VALUES BETWEEN 'n' AND 'r', VALUES BETWEEN 'r' AND 'u', VALUES BETWEEN 'u' AND'zzzzzzz')";
            try {
                this.log().info("in gfxd executing " + sql + wrongPartition);
                this.executeStatement(gConn, sql + wrongPartition);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("22003")) {
                    this.log().info("got expected exception for range partitioning");
                }
                SQLHelper.handleSQLException(se);
            }
        }
        String companiesPartition = " ";
        if (testPartitionBy) {
            companiesPartition = this.getTablePartition(TestConfig.tab().stringAt(SQLPrms.companiesTableDDLExtension, "trade.companies:random"));
        }
        String companiesDDLExtension = companiesPartition + this.getRedundancyClause(companiesPartition, TestConfig.tab().stringAt(SQLPrms.companiesTableRedundancy, " ")) + SQLTest.getCompaniesPersistence();
        if (enableConcurrencyCheck) {
            companiesDDLExtension = companiesDDLExtension + ENABLECONCURRENCYCHECKS;
        }
        sql = sql + (hasAsyncDBSync ? this.getCompaniesAsyncEventListenerExtension(companiesDDLExtension) : companiesDDLExtension);
        try {
            this.log().info("in gfxd executing " + sql);
            this.executeStatement(gConn, sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (dConn != null) {
            this.createDerbyIndexOnCompanies(dConn);
        }
    }

    protected String getCompaniesAsyncEventListenerExtension(String gfeDDL) {
        if (hasAsyncDBSync) {
            String ddl = gfeDDL.toUpperCase();
            if (ddl.contains("REPLICATE")) {
                if (ddl.contains("SERVER GROUPS") && !ddl.contains(sgDBSync)) {
                    int index = ddl.indexOf("SERVER GROUPS");
                    StringBuffer start = new StringBuffer(gfeDDL.substring(0, index - 1));
                    StringBuffer sb = new StringBuffer(gfeDDL.substring(index));
                    sb.insert(sb.indexOf("SG"), sgDBSync + ",");
                    gfeDDL = start.append(sb).toString();
                }
                if (!ddl.contains("SERVER GROUPS") && testServerGroupsInheritence && !((String)SQLBB.getBB().getSharedMap().get((Object)tradeSchemaSG)).equalsIgnoreCase("default")) {
                    gfeDDL = gfeDDL + "SERVER GROUPS (" + sgDBSync + "," + SQLBB.getBB().getSharedMap().get((Object)tradeSchemaSG) + ")";
                } else if (!ddl.contains("SERVER GROUPS") && testServerGroupsInheritence && ((String)SQLBB.getBB().getSharedMap().get((Object)tradeSchemaSG)).equalsIgnoreCase("default")) {
                    gfeDDL = gfeDDL + "SERVER GROUPS (" + sgDBSync + ",SG1,SG2,SG3,SG4)";
                }
            }
            if (hasAsyncEventListener) {
                throw new TestException("Test issue: Trade.Companies does not implement AsyncEventListen yet");
            }
            gfeDDL = gfeDDL + "AsyncEventListener(" + asyncDBSyncId + ")";
        }
        return gfeDDL;
    }

    protected static String getCompaniesPersistence() {
        String persistCompanies = TestConfig.tab().stringAt(SQLPrms.gfeCompaniesPersistExtension, "");
        return persistCompanies;
    }

    protected void addSecuritiesUniqConstraint(Connection gConn) {
        String sql = "alter table trade.securities add CONSTRAINT sec_uq unique (symbol, exchange)";
        try {
            this.log().info(sql);
            this.executeStatement(gConn, sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected int getMyWanSite() {
        if (isWanTest) {
            return WanTest.myWanSite;
        }
        return -1;
    }

    public static synchronized void HydraTask_createOracleDBSynchronizer() throws SQLException {
        sqlTest.createOracleDBSynchronizer();
    }

    protected void createOracleDBSynchronizer() throws SQLException {
        Connection conn = this.getGFEConnection();
        this.createOracleDBSynchronizer(conn);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    protected void createOracleDBSynchronizer(Connection conn) {
        String oracle_init = "oracle.jdbc.OracleDriver,jdbc:oracle:thin:trade/" + oraclePassword + "@w1-gst-dev29.gemstone.com:1521:wdc11";
        boolean enablePersistence = true;
        this.createNewDBSynchronizer(conn, oracle_init, enablePersistence);
    }

    protected Connection getSystemOracleConnection() throws SQLException {
        System.setProperty("java.security.egd", "file:///dev/urandom");
        QueryUtil.loadDriver(QueryUtil.oracleDriver());
        String url = "jdbc:oracle:thin:system/apple@" + this.getDBServer() + ":1521:" + this.getDBName();
        Log.getLogWriter().info("Connecting to " + url);
        Connection conn = DriverManager.getConnection(url);
        conn.setAutoCommit(false);
        return conn;
    }

    protected Connection getOracleConnection() throws SQLException {
        System.setProperty("java.security.egd", "file:///dev/urandom");
        QueryUtil.loadDriver(QueryUtil.oracleDriver());
        String url = "jdbc:oracle:thin:trade/" + oraclePassword + "@" + this.getDBServer() + ":1521:" + this.getDBName();
        Log.getLogWriter().info("Connecting to " + url);
        Connection conn = DriverManager.getConnection(url);
        conn.setAutoCommit(false);
        return conn;
    }

    protected String getDBServer() {
        return "w2-gst-dev29.gemstone.com";
    }

    protected String getDBName() {
        return "wdc11";
    }

    public static void HydraTask_cleanupOracleRun() throws SQLException {
        if (sqlTest == null) {
            sqlTest = new SQLTest();
        }
        sqlTest.cleanupOracleRun();
    }

    protected void cleanupOracleRun() throws SQLException {
        Connection oracleConn = this.getSystemOracleConnection();
        this.cleanupOracleRun(oracleConn);
        this.closeConnection(oracleConn);
    }

    protected void closeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to release the connection " + TestHelper.getStackTrace((Throwable)e));
        }
    }

    protected void cleanupOracleRun(Connection conn) throws SQLException {
        Connection tradeconn = this.getOracleConnection();
        this.closeConnection(tradeconn);
        Statement st = conn.createStatement();
        String sql = "select sid, serial# from v$session where username ='trade'";
        this.log().info(sql);
        ResultSet rs = st.executeQuery(sql);
        List<Struct> rsList = ResultSetHelper.asList(rs, false);
        String session = null;
        for (Struct row : rsList) {
            Object[] values = row.getFieldValues();
            session = values[0].toString() + "," + values[1].toString();
            this.log().info("session is " + session);
            if (session == null) continue;
            sql = "alter system kill session '" + session + "'";
            this.log().info(sql);
            st.execute(sql);
        }
        sql = "drop user trade cascade";
        this.log().info(sql);
        st.execute(sql);
        sql = "drop user emp cascade";
        this.log().info(sql);
        st.execute(sql);
        sql = "drop user default1 cascade";
        this.log().info(sql);
        st.execute(sql);
    }

    protected void dropOracleUsers(Connection conn) throws SQLException {
        block11: {
            String sql;
            Statement st;
            block10: {
                block9: {
                    block8: {
                        try {
                            Connection tradeconn = this.getOracleConnection();
                            this.closeConnection(tradeconn);
                        }
                        catch (SQLException se) {
                            SQLHelper.printSQLException(se);
                            if (!se.getMessage().contains("ORA-01017")) break block8;
                            Log.getLogWriter().info("invalid user/password, either others are running the test, or the previous run was successful. continue testing");
                            return;
                        }
                    }
                    try {
                        st = conn.createStatement();
                        sql = "drop user trade cascade";
                        this.log().info(sql);
                        st.execute(sql);
                    }
                    catch (SQLException se) {
                        SQLHelper.printSQLException(se);
                        if (!se.getMessage().contains("ORA-01918")) break block9;
                        Log.getLogWriter().info("user trade has been dropped, continue testing");
                    }
                }
                try {
                    st = conn.createStatement();
                    sql = "drop user emp cascade";
                    this.log().info(sql);
                    st.execute(sql);
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    if (!se.getMessage().contains("ORA-01918")) break block10;
                    Log.getLogWriter().info("user trade has been dropped, continue testing");
                }
            }
            try {
                st = conn.createStatement();
                sql = "drop user default1 cascade";
                this.log().info(sql);
                st.execute(sql);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (!se.getMessage().contains("ORA-01918")) break block11;
                Log.getLogWriter().info("user trade has been dropped, continue testing");
            }
        }
    }

    public static void HydraTask_dropOracleUsers() throws SQLException {
        if (sqlTest == null) {
            sqlTest = new SQLTest();
        }
        sqlTest.dropOracleUsers();
    }

    protected void dropOracleUsers() throws SQLException {
        Connection oracleConn = this.getSystemOracleConnection();
        this.dropOracleUsers(oracleConn);
        this.closeConnection(oracleConn);
    }

    public static void HydraTask_createOracleUsers() throws SQLException {
        sqlTest.createOracleUsers();
    }

    protected void createOracleUsers() throws SQLException {
        Connection conn = this.getSystemOracleConnection();
        this.createOracleUsers(conn);
        this.closeConnection(conn);
    }

    protected void createOracleUsers(Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        String sql = "CREATE USER trade IDENTIFIED BY " + oraclePassword;
        this.log().info(sql);
        st.execute(sql);
        sql = "CREATE USER emp IDENTIFIED BY " + oraclePassword;
        this.log().info(sql);
        st.execute(sql);
        sql = "CREATE USER default1 IDENTIFIED BY " + oraclePassword;
        this.log().info(sql);
        st.execute(sql);
        sql = "GRANT UNLIMITED TABLESPACE TO trade";
        this.log().info(sql);
        st.execute(sql);
        sql = "GRANT UNLIMITED TABLESPACE TO emp";
        this.log().info(sql);
        st.execute(sql);
        sql = "GRANT UNLIMITED TABLESPACE TO default1";
        this.log().info(sql);
        st.execute(sql);
        sql = "GRANT all privileges TO trade";
        this.log().info(sql);
        st.execute(sql);
        conn.commit();
    }

    public static void HydraTask_createOracleTables() throws SQLException {
        sqlTest.createOracleTables();
    }

    protected void createOracleTables() throws SQLException {
        Connection conn = this.getSystemOracleConnection();
        this.createOracleTables(conn);
        this.closeConnection(conn);
    }

    protected void createOracleTables(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        String[] tables = SQLPrms.getCreateTablesStatements(true);
        for (int i = 0; i < tables.length; ++i) {
            String sql = tables[i];
            sql = sql.replaceAll("on delete restrict", "");
            Log.getLogWriter().info("about to create table in oracle: " + sql);
            s.execute(sql);
            if (sql.contains("create table emp.department")) {
                sql = "GRANT all on emp.department TO trade";
                this.log().info(sql);
                s.execute(sql);
                continue;
            }
            if (sql.contains("create table emp.employees")) {
                sql = "GRANT all on emp.employees TO trade";
                this.log().info(sql);
                s.execute(sql);
                continue;
            }
            if (!sql.contains("create table default1.employees")) continue;
            sql = "GRANT all on default1.employees TO trade";
            this.log().info(sql);
            s.execute(sql);
        }
        conn.commit();
    }

    public static void HydraTask_verifyResultSetsOracleDBSynchronizer() throws SQLException {
        sqlTest.verifyResultSetsOracleDBSynchronizer();
    }

    protected void verifyResultSetsOracleDBSynchronizer() throws SQLException {
        Connection oraConn = this.getOracleConnection();
        Connection gConn = this.getGFEConnection();
        this.verifyResultSets(oraConn, gConn);
        this.closeConnection(oraConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_stopOracleDBSynchronizer() throws SQLException {
        if (sqlTest == null) {
            sqlTest = new SQLTest();
        }
        sqlTest.stopOracleDBSynchronizer();
    }

    protected void stopOracleDBSynchronizer() throws SQLException {
        Connection gConn = this.getGFEConnection();
        this.stopOracleDBSynchronizer(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void stopOracleDBSynchronizer(Connection conn) throws SQLException {
        String stopDBSynchronizer = "call SYS.STOP_ASYNC_EVENT_LISTENER( ? )";
        CallableStatement cs = conn.prepareCall(stopDBSynchronizer);
        cs.setString(1, asyncDBSyncId.toUpperCase());
        cs.execute();
        Log.getLogWriter().info(stopDBSynchronizer + " for " + asyncDBSyncId.toUpperCase());
    }

    public static synchronized void HydraTask_createDuplicateTables() {
        sqlTest.createDuplicateTables();
        SQLPrms.setTriggerStmtInMap();
        sqlTest.createTriggers();
    }

    protected void createDuplicateTables() {
        Connection gConn = this.getGFEConnection();
        String[] fullsetTablecreateStmt = SQLPrms.prepareFullSetTableCreateStmt();
        SQLPrms.setTriggerStmtInMap();
        try {
            Statement s = gConn.createStatement();
            for (int i = 0; i < fullsetTablecreateStmt.length; ++i) {
                Log.getLogWriter().info("Creating full data set duplicate table :" + fullsetTablecreateStmt[i]);
                s.execute(fullsetTablecreateStmt[i]);
            }
            s.close();
            this.commit(gConn);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to create Duplicate tables\n" + TestHelper.getStackTrace((Throwable)se));
        }
        this.closeGFEConnection(gConn);
    }

    public static synchronized void HydraTask_createMRTables() {
        sqlTest.createMRTables();
    }

    protected void createMRTables() {
        Connection gConn = this.getGFEConnection();
        String[] fullsetTablecreateStmt = SQLPrms.prepareFullSetTableCreateStmt();
        try {
            Statement s = gConn.createStatement();
            for (int i = 0; i < fullsetTablecreateStmt.length; ++i) {
                fullsetTablecreateStmt[i] = fullsetTablecreateStmt[i].replace("fulldataset", "HDFS");
                fullsetTablecreateStmt[i] = fullsetTablecreateStmt[i].toUpperCase().replaceAll(" HDFSSTORE *", " ");
                Log.getLogWriter().info("Creating MR  table :" + fullsetTablecreateStmt[i]);
                s.execute(fullsetTablecreateStmt[i]);
            }
            s.close();
            this.commit(gConn);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to create Duplicate tables\n" + TestHelper.getStackTrace((Throwable)se));
        }
        this.closeGFEConnection(gConn);
    }

    public static synchronized void HydraTask_createTriggerOnTables() {
        sqlTest.createTriggers();
    }

    protected void createTriggers() {
        Connection gConn = this.getGFEConnection();
        String[] triggerCreateStmt = SQLPrms.prepareTriggerStmt();
        try {
            Statement s = gConn.createStatement();
            for (int i = 0; i < triggerCreateStmt.length; ++i) {
                Log.getLogWriter().info("Executing... " + triggerCreateStmt[i]);
                s.execute(triggerCreateStmt[i]);
            }
            s.close();
            this.commit(gConn);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to create trigger " + TestHelper.getStackTrace((Throwable)se));
        }
        this.closeGFEConnection(gConn);
    }

    public static synchronized void HydraTask_setTriggerObserver() {
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new TriggerQueryObserver());
    }

    protected void dropTriggers() {
        Log.getLogWriter().info("function dropTriggers Started");
        ArrayList triggerNames = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"hdfsTriggers");
        Connection gConn = this.getGFEConnection();
        Iterator triggerNameiterator = triggerNames.iterator();
        try {
            Statement s = gConn.createStatement();
            while (triggerNameiterator.hasNext()) {
                String stmt = "DROP TRIGGER  IF EXISTS " + triggerNameiterator.next();
                Log.getLogWriter().info("Executing... " + stmt);
                s.execute(stmt);
            }
            s.close();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to drop trigger " + TestHelper.getStackTrace((Throwable)se));
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("function dropTriggers Completed");
    }

    public static void HydraTask_verifyTotalRowsinTables() {
        hdfsSqlTest.verifyTotalRowsinTables();
    }

    public static void HydraTask_executeSubSelectInPutOnEmptyTable() {
        sqlTest.dropTriggers();
        sqlTest.truncateDuplicateTables(DUPLICATE_TABLE_SUFFIX);
        sqlTest.executeSubSelectInPut(true);
        Log.getLogWriter().info("executeSubSelectInPut completed on Empty tables. ");
    }

    public static void HydraTask_executeSubSelectInPutOnTableWithData() {
        sqlTest.dropConstraint();
        sqlTest.executeSubSelectInPut(false);
        Log.getLogWriter().info("executeSubSelectInPut completed on tables with Data. ");
    }

    protected void executeSubSelectInPut(boolean onEmptyTable) {
        String[] tableNames;
        for (String tableName : tableNames = SQLPrms.getTableNames()) {
            if (tableName.equalsIgnoreCase("trade.txhistory") && (!tableName.equalsIgnoreCase("trade.txhistory") || !onEmptyTable)) continue;
            this.executePutOnTable(tableName);
        }
    }

    protected void executePutOnTable(String tableName) {
        Connection gConn = this.getGFEConnection();
        String putUpdate = " ";
        try {
            Statement s = gConn.createStatement();
            putUpdate = "PUT INTO " + tableName + DUPLICATE_TABLE_SUFFIX + " SELECT * FROM " + tableName + "-- GEMFIREXD-PROPERTIES queryHDFS=true ";
            Log.getLogWriter().info("Executing ...." + putUpdate);
            s.executeUpdate(putUpdate);
            Log.getLogWriter().info("Execution  completed on table " + tableName);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to execute query : " + putUpdate + "\n Exception : " + TestHelper.getStackTrace((Throwable)se));
        }
        this.closeGFEConnection(gConn);
    }

    protected void dropConstraint() {
        Connection gConn = this.getGFEConnection();
        try {
            String constraintDropCmd = " select 'alter table ' ||  TABLESCHEMANAME || '.' || TABLENAME  || ' drop constraint ' || CONSTRAINTNAME  as constraintToDrop from sys.systables t , sys.SYSCONSTRAINTS c where t.TABLEID = c.tableID AND (C.TYPE ='U' OR C.TYPE ='F')";
            Statement s = gConn.createStatement();
            ResultSet rs = s.executeQuery(constraintDropCmd);
            while (rs.next()) {
                try {
                    Log.getLogWriter().info("Executing..." + rs.getString("constraintToDrop"));
                    Statement executeStmt = gConn.createStatement();
                    executeStmt.execute(rs.getString("constraintToDrop"));
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                }
            }
            SQLHelper.closeResultSet(rs, gConn);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
        }
    }

    protected void setTraceFlags(boolean on) {
        if (ddlThread != RemoteTestModule.getCurrentThread().getThreadId()) {
            return;
        }
        try {
            String[] traces;
            String traceFlags = SQLPrms.getTraceFlags();
            Connection conn = this.getConnectionSetTrace();
            PreparedStatement ps = conn.prepareStatement("call sys.SET_TRACE_FLAG(?,?)");
            for (String trace : traces = traceFlags.split(",")) {
                ps.setString(1, trace);
                ps.setBoolean(2, on ? Boolean.TRUE : Boolean.FALSE);
                ps.execute();
                Log.getLogWriter().info((on ? "Enabled" : "Disabled") + trace + " trace");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static List<String> getHdfsTables() {
        Map hdfsExtnMap = (Map)SQLBB.getBB().getSharedMap().get((Object)"hdfsExtnParams");
        ArrayList<String> hdfsTables = new ArrayList<String>();
        for (int i = 0; i < tables.length; ++i) {
            String table = tables[i];
            String hdfsSchemaTable = table.toUpperCase();
            if (hdfsExtnMap.get(hdfsSchemaTable + "STORENAME") == null) {
                Log.getLogWriter().info("skipping " + table + " since it is not configured with HDFS");
                continue;
            }
            hdfsTables.add(table);
        }
        return hdfsTables;
    }

    public static void HydraTask_flushQueuesHDFS() {
        if (useRandomConfHdfsStore) {
            return;
        }
        List<String> hdfsTables = SQLTest.getHdfsTables();
        ArrayList<Thread> flushThreads = new ArrayList<Thread>();
        for (String table : hdfsTables) {
            flushThreads.add(sqlTest.flushQueuesHDFS(table));
        }
        for (Thread fthread : flushThreads) {
            try {
                fthread.join(maxResultWaitSec - 60);
            }
            catch (InterruptedException e) {
                throw new TestException("flushQueuesHFDS caught " + e + " " + TestHelper.getStackTrace((Throwable)e));
            }
        }
        Log.getLogWriter().info("all threads have completed flushQueuesHDFS");
        String taskType = RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString();
        if (!taskType.equalsIgnoreCase("TASK")) {
            try {
                GemFireCacheImpl cache = Misc.getGemFireCache();
                Set queues = cache.getAsyncEventQueues();
                for (AsyncEventQueue queue : queues) {
                    AsyncEventQueueImpl queueImpl = (AsyncEventQueueImpl)queue;
                    SerialGatewaySenderImpl sender = (SerialGatewaySenderImpl)queueImpl.getSender();
                    String regionQueueName = sender.getQueue().getRegion().getName();
                    if (sender.getQueue().size() == 0) continue;
                    throw new TestException("Expected HDFS AEQ to be empty for " + regionQueueName + " but found " + sender.getQueue().size() + " entries");
                }
            }
            catch (CacheClosedException cce) {
                Log.getLogWriter().info("thin clients cannot verify AEQ sizes, continuing ...");
            }
        }
    }

    public Thread flushQueuesHDFS(final String tableName) {
        final Connection conn = this.getGFEConnection();
        String threadName = "HDFS Queue Flush for " + tableName;
        Thread thr = new Thread(new Runnable(){

            @Override
            public void run() {
                long startTime;
                try {
                    int timeToWait = maxResultWaitSec - 60;
                    PreparedStatement ps = conn.prepareStatement("call sys.HDFS_FLUSH_QUEUE(?,?)");
                    ps.setString(1, tableName);
                    ps.setInt(2, timeToWait);
                    Log.getLogWriter().info("Invoking HDFS_FLUSH_QUEUE for " + tableName);
                    startTime = System.currentTimeMillis();
                    ps.execute();
                }
                catch (Throwable t) {
                    throw new TestException("Unexpected Exception thrown while invoking HDFS_FLUSH_QUEUE for " + tableName + ", " + t);
                }
                long timeToRun = System.currentTimeMillis() - startTime;
                Log.getLogWriter().info("Completed HDFS_FLUSH_QUEUE for " + tableName + ", flush took " + timeToRun + "ms");
            }
        }, threadName);
        thr.start();
        return thr;
    }

    public static void HydraTask_forceCompactionHDFS() {
        List<String> hdfsTables = SQLTest.getHdfsTables();
        ArrayList<Thread> compactionThreads = new ArrayList<Thread>();
        for (String table : hdfsTables) {
            compactionThreads.add(sqlTest.forceCompactionHDFS(table));
        }
        for (Thread cthread : compactionThreads) {
            try {
                cthread.join(maxResultWaitSec - 60);
            }
            catch (InterruptedException e) {
                throw new TestException("forceCompactionHDFS caught " + e + " " + TestHelper.getStackTrace((Throwable)e));
            }
        }
        Log.getLogWriter().info("all threads have completed forceCompactionsHDFS");
    }

    public Thread forceCompactionHDFS(final String tableName) {
        String threadName = "HDFS Force Compaction Thread for " + tableName;
        final Connection conn = this.getGFEConnection();
        Thread thr = new Thread(new Runnable(){

            @Override
            public void run() {
                long startTime;
                try {
                    int timeToWait = maxResultWaitSec - 60;
                    PreparedStatement ps = conn.prepareStatement("call sys.HDFS_FORCE_COMPACTION(?,?)");
                    ps.setString(1, tableName);
                    ps.setInt(2, timeToWait);
                    Log.getLogWriter().info("Invoking HDFS_FORCE_COMPACTION for " + tableName);
                    startTime = System.currentTimeMillis();
                    ps.execute();
                }
                catch (Throwable t) {
                    throw new TestException("Unexpected Exception thrown while invoking HDFS_FORCE_COMPACTION for " + tableName + ", " + t);
                }
                long timeToRun = System.currentTimeMillis() - startTime;
                Log.getLogWriter().info("Completed HDFS_FORCE_COMPACTION for " + tableName + " major compaction took " + timeToRun + "ms");
            }
        }, threadName);
        thr.start();
        return thr;
    }

    public static void HydraTask_forceWriteOnlyFileRollover() {
        List<String> hdfsTables = SQLTest.getHdfsTables();
        SQLTest.forceWriteOnlyFileRollover(hdfsTables);
    }

    public static void forceWriteOnlyFileRollover(List<String> hdfsTables) {
        SQLTest.forceWriteOnlyFileRollover(hdfsTables, -1);
    }

    public static void forceWriteOnlyFileRollover(List<String> hdfsTables, int minSizeForRollover) {
        ArrayList<Thread> rolloverThreads = new ArrayList<Thread>();
        for (String table : hdfsTables) {
            rolloverThreads.add(sqlTest.forceWriteOnlyFileRollover(table, minSizeForRollover));
        }
        for (Thread rolloverThread : rolloverThreads) {
            try {
                rolloverThread.join(maxResultWaitSec - 60);
            }
            catch (InterruptedException e) {
                throw new TestException("forceWriteOnlyFileRollover caught " + e + " " + TestHelper.getStackTrace((Throwable)e));
            }
        }
        Log.getLogWriter().info("all threads have completed HDFS_FORCE_WRITEONLY_FILEROLLOVER");
    }

    public Thread forceWriteOnlyFileRollover(final String tableName, final int minSizeForRollover) {
        final Connection conn = this.getGFXDClientConnection();
        String threadName = "HDFS_FORCE_WRITEONLY_FILEROLLOVER " + tableName;
        Thread thr = new Thread(new Runnable(){

            @Override
            public void run() {
                long startTime;
                try {
                    PreparedStatement ps = conn.prepareStatement("call sys.HDFS_FORCE_WRITEONLY_FILEROLLOVER(?,?)");
                    ps.setString(1, tableName);
                    ps.setInt(2, minSizeForRollover);
                    Log.getLogWriter().info("Invoking HDFS_FORCE_WRITEONLY_ROLLOVER for " + tableName);
                    startTime = System.currentTimeMillis();
                    ps.execute();
                }
                catch (Throwable t) {
                    throw new TestException("Unexpected Exception thrown while invoking HDFS_FORCE_WRITEONLY_FILEROLLOVER for " + tableName + ", " + t);
                }
                long timeToRun = System.currentTimeMillis() - startTime;
                Log.getLogWriter().info("Completed HDFS_FORCE_WRITEONLY_FILEROLLOVER for " + tableName + ", rollover took " + timeToRun + "ms");
            }
        }, threadName);
        thr.start();
        return thr;
    }

    public static void HydraTask_createHDFSSTORE() {
        hdfsSqlTest.createHdfsStore();
    }

    public static void HydraTask_dropHDFSSTORE() {
        hdfsSqlTest.dropHdfsStore();
    }

    public static void HydraTask_verifyHdfsOperationalData() {
        if (SQLBB.getBB().getSharedCounters().read(SQLBB.triggerInvocationCounter) > 0L) {
            Log.getLogWriter().info("trigger Invoked but not completed " + SQLBB.getBB().getSharedCounters().read(SQLBB.triggerInvocationCounter) + " Times");
        }
        hdfsSqlTest.verifyHdfsOperationData();
    }

    public static void HydraTask_verifyHdfsNonOperationData() {
        hdfsSqlTest.verifyHdfsNonOperationData();
    }

    public static void HydraTask_setHDFSEvictionObserver() {
        hdfsSqlTest.setHDFSEvictionObserver();
    }

    public static void HydraTask_executeMR() {
        hdfsSqlTest.setMapReduceClassName();
        hdfsSqlTest.executeMR();
    }

    public static void HydraTask_verifyHdfsDataUsingMR() {
        hdfsSqlTest.verifyHdfsDataUsingMR();
    }

    public static void HydraTask_forceCompaction() {
        if (useRandomConfHdfsStore) {
            return;
        }
        sqlTest.forceCompaction();
    }

    public static void HydraTask_alterEvictionFrequency() {
        hdfsSqlTest.alterEvictionFrequency();
    }

    protected synchronized void forceCompaction() {
        if (!forceCompaction) {
            return;
        }
        Log.getLogWriter().info("inside force compaction");
        GemFireCacheImpl cacheImpl = Misc.getGemFireCache();
        if (cacheImpl != null && !cacheImpl.isClosed()) {
            for (DiskStoreImpl store : cacheImpl.listDiskStoresIncludingRegionOwned()) {
                Log.getLogWriter().info("starting force compaction for " + store);
                boolean status = store.forceCompaction();
                Log.getLogWriter().info("force compaction for " + store + (status ? " done " : " not executed "));
            }
        }
    }

    public void executeListener(String event, String listenerName) {
        Log.getLogWriter().info("Listeners are : " + listeners + " ListenerName : " + listenerName);
        for (CallBackListener listener : listeners) {
            if (!listenerName.equals(listener.getName())) continue;
            listener.execute(event);
        }
    }

    protected void addListener(CallBackListener callBackListener) {
        if (SQLPrms.isMBeanTest()) {
            Log.getLogWriter().info("Adding Listener : " + callBackListener);
            listeners.add(callBackListener);
        }
    }

    public static void HydraTask_dumpHDFSTable() {
        String wanId = "";
        if (isWanTest) {
            if (hdfsSqlTest != null) {
                wanId = hdfsSqlTest.getMyWanSite() + "";
            } else {
                Log.getLogWriter().info("HydraTask_dumpHDFSTable: hdfsSqlTest is null");
                return;
            }
        }
        Log.getLogWriter().info("HydraTask_dumpHDFSTable: will only be executed once i.e. from \"client1\" or \"accessor1\". Currently called from: " + RemoteTestModule.getMyClientName());
        if (RemoteTestModule.getMyClientName().contains("client1") || RemoteTestModule.getMyClientName().contains("accessor1")) {
            HDFSSqlTest.dumpHDFSTable(wanId);
        }
    }

    public static void HydraTask_verifyUniqeIndexData() {
        if (!testMultipleUniqueIndex) {
            return;
        }
        sqlTest.verifyUniqeIndexData();
    }

    protected synchronized void verifyUniqeIndexData() {
        Connection gConn = this.getGFEConnection();
        Connection dConn = this.getDiscConnection();
        List<Struct> gfxdResult = this.getResultSet(gConn, "select * from trade.txhistory -- SQLFIRE-PROPERTIES queryHDFS=true \n where oid > 0 and cid > 0  ");
        List<Struct> derbyResult = this.getResultSet(dConn, "select * from trade.txhistory  where oid > 0 and cid > 0");
        Log.getLogWriter().info("Comparing Derby and sqlf Data for query - select * from trade.txhistory -- SQLFIRE-PROPERTIES queryHDFS=true \n where oid > 0 and cid >0 ");
        ResultSetHelper.compareResultSets(derbyResult, gfxdResult);
        gfxdResult = this.getResultSet(gConn, "select * from trade.txhistory  -- SQLFIRE-PROPERTIES queryHDFS=false \n where oid > 0 and cid > 0 ");
        derbyResult = this.getResultSet(dConn, "select * from trade.txhistory  where oid > 0 and cid  > 0 ");
        Log.getLogWriter().info("Comparing Derby and sqlf Data for query - select * from trade.txhistory -- SQLFIRE-PROPERTIES queryHDFS=false \n where oid > 0 and cid > 0 ");
        ResultSetHelper.compareResultSets(derbyResult, gfxdResult);
        gfxdResult = this.getResultSet(gConn, "select * from trade.txhistory -- SQLFIRE-PROPERTIES queryHDFS=true \n where cid > 0  and sid > 0");
        derbyResult = this.getResultSet(dConn, "select * from trade.txhistory  where cid > 0 and sid >0 ");
        Log.getLogWriter().info("Comparing Derby and sqlf Data for query - select * from trade.txhistory -- SQLFIRE-PROPERTIES queryHDFS=true \n where cid > 0 and sid >0 ");
        ResultSetHelper.compareResultSets(derbyResult, gfxdResult);
        gfxdResult = this.getResultSet(gConn, "select * from trade.txhistory -- SQLFIRE-PROPERTIES queryHDFS=false \n where cid > 0 and sid >0 ");
        derbyResult = this.getResultSet(dConn, "select * from trade.txhistory  where cid > 0 and sid >0 ");
        Log.getLogWriter().info("Comparing Derby and sqlf Data for query - select * from trade.txhistory -- SQLFIRE-PROPERTIES queryHDFS=false \n where cid > 0 and sid >0 ");
        ResultSetHelper.compareResultSets(derbyResult, gfxdResult);
    }

    public static void HydraTask_alterTableSetHdfsStore() {
        sqlTest.alterTableSetHdfsStore("sqlhdfsstore");
    }

    public static void HydraTask_detachHdfsStore() {
        sqlTest.alterTableSetHdfsStore(" ");
    }

    protected synchronized void alterTableSetHdfsStore(String storeName) {
        Connection gConn = this.getGFEConnection();
        ArrayList<String[]> tables = this.getTableNames(gConn);
        try {
            for (String[] table : tables) {
                String stmt = "ALTER TABLE " + table[0] + "." + table[1] + " SET HDFSSTORE (" + storeName + ")";
                Log.getLogWriter().info("Executing  statement " + stmt);
                gConn.createStatement().executeUpdate(stmt);
            }
        }
        catch (SQLException e) {
            throw new TestException(e.getMessage());
        }
    }

    public static void HydraTask_dropColocatedChildTables() {
        sqlTest.dropColocatedChildTables();
    }

    protected void dropColocatedChildTables() {
        Connection conn = this.getGFEConnection();
        String sql = null;
        ArrayList<String> tables = new ArrayList<String>();
        tables.add("trade.txhistory");
        tables.add("trade.buyorders");
        tables.add("trade.sellorders");
        tables.add("trade.portfolio");
        tables.add("trade.networth");
        boolean testDropTableIfExists = random.nextBoolean();
        sql = testDropTableIfExists ? "drop table if exists " : "drop table ";
        try {
            for (String table : tables) {
                Statement s = conn.createStatement();
                s.execute(sql + table);
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("42Y55") && !testDropTableIfExists) {
                Log.getLogWriter().info("Got expected table not exists exception, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_addPortfolioV1Table() {
        sqlTest.addPortfolioV1Table();
    }

    protected void addPortfolioV1Table() {
        boolean reproduce50116 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50116, true);
        try {
            if (reproduce50116) {
                this.createPortfolioV1Table();
                this.selectIntoPortfolioV1Table();
                this.alterTableAddDataCol();
                this.alterTableAlterConstraint();
                this.dropPortfolioTable();
                this.createPortfolioView();
            } else {
                this.createPortfolioV1Table();
                this.selectIntoPortfolioV1Table();
                this.alterTableAddDataCol();
                this.alterTableAlterConstraint();
            }
            SQLBB.getBB().getSharedMap().put((Object)PORTFOLIOV1READY, (Object)true);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void createPortfolioV1Table() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.createPortfolioV1Table(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void createPortfolioV1Table(Connection dConn, Connection gConn) throws SQLException {
        if (!tableColsSet) {
            SQLTest.setTableCols(gConn);
        }
        boolean reproduce50118 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50118, false);
        String str = null;
        if (!reproduce50118) {
            str = createTablePortfolioStmt.replace("trade.portfolio", "trade.portfoliov1");
            str = str.replace("portf_pk", "portf_pk_v1");
            str = str.replace("cust_fk", "cust_fk_v1");
            str = str.replace("sec_fk", "sec_fk_v1");
            str = str.replace("qty_ck", "qty_ck_v1");
            str = str.replace("avail_ch", "avail_ch_v1");
        }
        String createPortfoliov1Stmt = "create table trade.portfoliov1 (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk_v1 primary key (cid, sid), constraint cust_fk_v1 foreign key (cid) references trade.customers (cid), constraint sec_fk_v1 foreign key (sid) references trade.securities (sec_id), constraint qty_ck_v1 check (qty>=0), constraint avail_ch_v1 check (availQty>=0 and availQty<=qty))";
        String createPortfoliov1 = TestConfig.tab().stringAt(SQLPrms.portfoliov1Statement, createPortfoliov1Stmt);
        String createPortfoliov1UseSelect = reproduce50118 ? "create table trade.portfoliov1 as select * from trade.portfolio with no data" : str;
        String createDerbyIndexTid = "create index indexportfoliov1tid on trade.portfoliov1 (tid)";
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + createPortfoliov1);
            this.executeStatement(dConn, createPortfoliov1);
            Log.getLogWriter().info("executed in derby: " + createPortfoliov1);
            Log.getLogWriter().info("executing in derby: " + createDerbyIndexTid);
            this.executeStatement(dConn, createDerbyIndexTid);
            Log.getLogWriter().info("executed in derby: " + createDerbyIndexTid);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + createPortfoliov1UseSelect);
        this.executeStatement(gConn, createPortfoliov1UseSelect);
        Log.getLogWriter().info("executed in gfxd: " + createPortfoliov1UseSelect);
        if (reproduce50118) {
            String addPrimaryKey = "alter table trade.portfoliov1 add constraint portf_pk_v1 primary key (cid, sid)";
            Log.getLogWriter().info("executing in gfxd: " + addPrimaryKey);
            this.executeStatement(gConn, addPrimaryKey);
            Log.getLogWriter().info("executed in gfxd: " + addPrimaryKey);
            String addCustFKey = "alter table trade.portfoliov1 add constraint cust_fk_v1 foreign key (cid) references trade.customers (cid)";
            Log.getLogWriter().info("executing in gfxd: " + addCustFKey);
            this.executeStatement(gConn, addCustFKey);
            Log.getLogWriter().info("executed in gfxd: " + addCustFKey);
            String addSecFKey = "alter table trade.portfoliov1 add constraint sec_fk_v1 foreign key (sid) references trade.securities (sec_id)";
            Log.getLogWriter().info("executing in gfxd: " + addSecFKey);
            this.executeStatement(gConn, addSecFKey);
            Log.getLogWriter().info("executed in gfxd: " + addSecFKey);
            String addQtyCheck = "alter table trade.portfoliov1 add constraint qty_ck_v1 check (qty>=0)";
            Log.getLogWriter().info("executing in gfxd: " + addQtyCheck);
            this.executeStatement(gConn, addQtyCheck);
            Log.getLogWriter().info("executed in gfxd: " + addQtyCheck);
            String addAvailQtyCheck = "alter table trade.portfoliov1 add constraint avail_ch_v1 check (availQty>=0 and availQty<=qty)";
            Log.getLogWriter().info("executing in gfxd: " + addAvailQtyCheck);
            this.executeStatement(gConn, addAvailQtyCheck);
            Log.getLogWriter().info("executed in gfxd: " + addAvailQtyCheck);
        }
        SQLTest.setTableCols(gConn, "trade.portfoliov1");
        this.commit(gConn);
    }

    protected void selectIntoPortfolioV1Table() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.selectIntoPortfolioV1Table(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void selectIntoPortfolioV1Table(Connection dConn, Connection gConn) throws SQLException {
        String sql = "insert into trade.portfoliov1 (select * from trade.portfolio)";
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + sql);
            this.executeStatement(dConn, sql);
            Log.getLogWriter().info("executed in derby: " + sql);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + sql);
        this.executeStatement(gConn, sql);
        Log.getLogWriter().info("executed in gfxd: " + sql);
        this.commit(gConn);
    }

    protected void alterTableAddDataCol() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.alterTableAddDataCol(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void alterTableAddDataCol(Connection dConn, Connection gConn) throws SQLException {
        String sql = "alter table trade.portfoliov1 add column data blob";
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + sql);
            this.executeStatement(dConn, sql);
            Log.getLogWriter().info("executed in derby: " + sql);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + sql);
        this.executeStatement(gConn, sql);
        Log.getLogWriter().info("executed in gfxd: " + sql);
        this.commit(gConn);
    }

    protected void alterTableAlterConstraint() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.alterTableAlterConstraint(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void alterTableAlterConstraint(Connection dConn, Connection gConn) throws SQLException {
        String sql = "alter table trade.sellorders drop FOREIGN KEY portf_fk";
        String addConstraint = "alter table trade.sellorders add constraint portf_fk foreign key (cid, sid) references trade.portfoliov1 (cid, sid) on delete restrict";
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + sql);
            this.executeStatement(dConn, sql);
            Log.getLogWriter().info("executed in derby: " + sql);
            Log.getLogWriter().info("executing in derby: " + addConstraint);
            this.executeStatement(dConn, addConstraint);
            Log.getLogWriter().info("executed in derby: " + addConstraint);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + sql);
        this.executeStatement(gConn, sql);
        Log.getLogWriter().info("executed in gfxd: " + sql);
        Log.getLogWriter().info("executing in gfxd: " + addConstraint);
        this.executeStatement(gConn, addConstraint);
        Log.getLogWriter().info("executed in gfxd: " + addConstraint);
        this.commit(gConn);
    }

    protected void dropPortfolioTable() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.dropPortfolioTable(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void dropPortfolioTable(Connection dConn, Connection gConn) throws SQLException {
        String derbySql = "drop table trade.portfolio";
        String sql = "drop table " + (random.nextBoolean() ? "if exists " : "") + "trade.portfolio";
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + derbySql);
            this.executeStatement(dConn, derbySql);
            Log.getLogWriter().info("executed in derby: " + derbySql);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + sql);
        this.executeStatement(gConn, sql);
        Log.getLogWriter().info("executed in gfxd: " + sql);
        this.commit(gConn);
    }

    protected void createPortfolioView() throws SQLException {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.createPortfolioView(dConn, gConn);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void createPortfolioView(Connection dConn, Connection gConn) throws SQLException {
        String sql = "create view trade.portfolio as select cid, sid, qty, availQty, subTotal, tid from trade.portfoliov1";
        if (dConn != null) {
            Log.getLogWriter().info("executing in derby: " + sql);
            this.executeStatement(dConn, sql);
            Log.getLogWriter().info("executed in derby: " + sql);
            this.commit(dConn);
        }
        Log.getLogWriter().info("executing in gfxd: " + sql);
        this.executeStatement(gConn, sql);
        Log.getLogWriter().info("executed in gfxd: " + sql);
        this.commit(gConn);
    }

    public static void HydraTask_copyDiskstore() throws IOException {
        String sourcePath = diskCompatibilityDiskStorePath;
        String destPath = TestConfig.getInstance().getClientDescription(RemoteTestModule.getMyClientName()).getVmDescription().getHostDescription().getResourceDir();
        Log.getLogWriter().info("copyDir from " + sourcePath + " to " + destPath);
        SQLTest.copyFiles(sourcePath, destPath);
    }

    protected static void copyFiles(String srcPath, String destPath) throws IOException {
        Log.getLogWriter().info("copyFile Start ");
        File src = new File(srcPath);
        File dest = new File(destPath);
        if (src.isDirectory()) {
            String[] list;
            if (!firstEntry) {
                dest = new File(SQLTest.replaceHostNameFromDestination(dest.getAbsolutePath()));
                dest.mkdirs();
            } else {
                dest.mkdirs();
                firstEntry = false;
            }
            for (String strtemp : list = src.list()) {
                Log.getLogWriter().info(strtemp + " - ");
            }
            for (int i = 0; i < list.length; ++i) {
                String srcFile = src.getAbsolutePath() + FS + list[i];
                String destFile = dest.getAbsolutePath() + FS + list[i];
                SQLTest.copyFiles(srcFile, destFile);
            }
        } else {
            SQLTest.copy(src, dest);
        }
    }

    private static void copy(File source, File dest) throws IOException {
        int c;
        FileInputStream src = new FileInputStream(source);
        FileOutputStream dst = new FileOutputStream(dest);
        while ((c = src.read()) >= 0) {
            dst.write(c);
        }
        src.close();
        dst.close();
    }

    private static String replaceHostNameFromDestination(String dest) {
        String finalDestHostName = null;
        String finalDestString = null;
        String[] destHostName = null;
        String[] destString = dest.split("/");
        if (destString[destString.length - 1].contains("csv")) {
            return dest;
        }
        destHostName = !destString[destString.length - 1].contains("_disk") ? destString[destString.length - 2].split("_") : destString[destString.length - 1].split("_");
        destHostName[destHostName.length - 2] = HostHelper.getIPAddress().getHostName();
        for (int i = 0; i < destHostName.length; ++i) {
            finalDestHostName = i == 0 ? destHostName[i] : finalDestHostName + "_" + destHostName[i];
        }
        if (!destString[destString.length - 1].contains("_disk")) {
            destString[destString.length - 2] = finalDestHostName;
        } else {
            destString[destString.length - 1] = finalDestHostName;
        }
        for (int j = 0; j < destString.length; ++j) {
            finalDestString = j == 0 ? destString[j] : finalDestString + FS + destString[j];
        }
        return finalDestString;
    }

    public static void HydraTask_upgradeDiskStore() throws Exception {
        String sysDirName = FabricServerHelper.getFabricServerDescription().getSysDiskDir();
        Log.getLogWriter().info("GemfireDescription SysDirName: " + sysDirName);
        SQLTest.runUpgradeDiskStore("SQLF-DEFAULT-DISKSTORE", sysDirName);
        SQLTest.runUpgradeDiskStore("SQLF-DD-DISKSTORE", sysDirName + "/datadictionary");
        if (!sysDirName.contains("_locator")) {
            SQLTest.runUpgradeDiskStore("PERSISTCUST", sysDirName + "/persistCust");
            SQLTest.runUpgradeDiskStore("PERSISTPORTF", sysDirName + "/persistPortf");
            SQLTest.runUpgradeDiskStore("PERSISTSELLORDERS", sysDirName + "/persistSellorders");
            SQLTest.runUpgradeDiskStore("PERSISTBUYORDERS", sysDirName + "/persistBuyorders");
            SQLTest.runUpgradeDiskStore("PERSISTNETWORTH", sysDirName + "/persistNetworth");
            SQLTest.runUpgradeDiskStore("PERSISTSECU", sysDirName + "/persistSecu");
            SQLTest.runUpgradeDiskStore("PERSISTTXHISTORY", sysDirName + "/persistTxHistory");
        }
    }

    private static void runUpgradeDiskStore(String storeName, String dir) throws Exception {
        Log.getLogWriter().info("Upgrading diskstore " + storeName + " from " + dir);
        HostDescription hd = TestConfig.getInstance().getClientDescription(RemoteTestModule.getMyClientName()).getVmDescription().getHostDescription();
        String path = "$GEMFIRE" + File.separator + ".." + File.separator + "product-gfxd" + File.separator + "bin" + File.separator + "gfxd";
        String cmd = EnvHelper.expandEnvVars((String)path, (HostDescription)hd) + " upgrade-disk-store " + storeName + " " + dir;
        ProcessMgr.fgexec((String)cmd, (int)0);
        Log.getLogWriter().info("Issued upgrade-disk-store command on " + storeName);
    }

    public static void HydraTask_importTablesToDerby() {
        sqlTest.importTablesToDerby();
    }

    protected void importTablesToDerby() {
        Connection dConn = this.getDiscConnection();
        this.importTablesToDerby(dConn);
        this.closeDiscConnection(dConn);
    }

    protected void importTablesToDerby(Connection conn) {
        String[] tables;
        String schema = "trade";
        for (String table : tables = new String[]{"customers", "securities", "networth", "portfolio", "buyorders", "sellorders", "txhistory"}) {
            this.importTablesToDerby(conn, schema, table);
        }
        this.importTablesToDerby(conn, "EMP", "EMPLOYEES");
    }

    protected void importTablesToDerby(Connection conn, String schema, String table) {
        String importTable = "CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE (?, ?, ?, null, null, null, 0)";
        String importFile = FabricServerHelper.getFabricServerDescription().getSysDiskDir() + File.separator + ".." + File.separator + "csv" + File.separator + table.toUpperCase() + ".file";
        Log.getLogWriter().info("schema " + schema + "  table " + table + " importFile " + importFile);
        try {
            CallableStatement cs = conn.prepareCall(importTable);
            cs.setString(1, schema.toUpperCase());
            cs.setString(2, table.toUpperCase());
            cs.setString(3, importFile);
            cs.execute();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static List<Struct> getResultSetTest(Connection gConn, String sqlQuery) {
        List<Struct> list;
        ResultSet rs = null;
        try {
            System.out.println(sqlQuery);
            rs = gConn.createStatement().executeQuery(sqlQuery);
            list = ResultSetHelper.asList(rs, false);
        }
        catch (SQLException se) {
            try {
                SQLHelper.handleSQLException(se);
            }
            catch (Throwable throwable) {
                SQLHelper.closeResultSet(rs, gConn);
                SQLTest.commitTest(gConn);
                throw throwable;
            }
            SQLHelper.closeResultSet(rs, gConn);
            SQLTest.commitTest(gConn);
            return null;
        }
        SQLHelper.closeResultSet(rs, gConn);
        SQLTest.commitTest(gConn);
        return list;
    }

    protected static void commitTest(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            String name = "gfxd ";
            System.out.println("committing the ops for " + name);
            conn.commit();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se) && se.getSQLState().equalsIgnoreCase("08003")) {
                System.out.println("detected current connection is lost, possibly due to reade time out");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_waitForStartupRecovery() {
        int numOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
        ArrayList vms = new ArrayList();
        vms.addAll(StopStartVMs.getMatchVMs((List)StopStartVMs.getAllVMs(), (String)"server"));
        PRObserver.waitForRebalRecov(vms, (int)1, (int)numOfPRs, null, null, (boolean)false);
    }

    static {
        insertCustomersSQL = "INSERT INTO trade.customers (cid, cust_name, since, addr) VALUES (?,?,?,?)";
        discConn = null;
        hasDerbyServer = false;
        testUniqueKeys = TestConfig.tab().booleanAt(SQLPrms.testUniqueKeys, true);
        randomData = false;
        hasNetworth = false;
        fabricServerStarted = new AtomicBoolean(false);
        isSerial = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        isSingleDMLThread = false;
        usingTrigger = false;
        queryAnyTime = true;
        killInterval = TestConfig.tab().longAt(SQLPrms.killInterval, 120000L);
        dmlFactory = new DMLStmtsFactory();
        ddlFactory = new DDLStmtsFactory();
        joinFactory = new JoinTableStmtsFactory();
        createIndex = TestConfig.tab().booleanAt(SQLPrms.createIndex, false);
        testPartitionBy = TestConfig.tab().booleanAt(SQLPrms.testPartitionBy, false);
        testServerGroups = TestConfig.tab().booleanAt(SQLPrms.testServerGroups, false);
        testServerGroupsInheritence = TestConfig.tab().booleanAt(SQLPrms.testServerGroupsInheritence, false);
        numOfReplay = 0;
        testUniqIndex = TestConfig.tab().booleanAt(SQLPrms.testUniqIndex, false);
        dmlTables = SQLPrms.getTables();
        ddls = SQLPrms.getDDLs();
        populateThruLoader = TestConfig.tab().booleanAt(SQLPrms.populateThruLoader, false);
        testSecurity = TestConfig.tab().booleanAt(Prms.testSecurity, false);
        tables = SQLPrms.getTableNames();
        tableCols = new HashMap();
        tableColsSet = false;
        testInitDDLReplay = TestConfig.tab().booleanAt(SQLPrms.testInitDDLReplay, false);
        multiThreadsCreateTables = TestConfig.tab().booleanAt(SQLPrms.multiThreadsCreateTables, false);
        sgDBSync = "sgDBSync";
        asyncDBSyncId = "asyncDBSync";
        hasAsyncDBSync = TestConfig.tab().booleanAt(SQLPrms.hasAsyncDBSync, false);
        hasAsyncEventListener = TestConfig.tab().booleanAt(SQLPrms.hasAsyncEventListener, false);
        hasHdfs = TestConfig.tab().booleanAt(SQLPrms.hasHDFS, false);
        hasJSON = TestConfig.tab().booleanAt(SQLPrms.hasJSON, false);
        updateWriteOnlyMr = TestConfig.tab().booleanAt(SQLPrms.updateWriteOnlyMr, false);
        hdfsMrJob = TestConfig.tab().booleanAt(SQLPrms.hdfsMrJob, false);
        supportDuplicateTables = TestConfig.tab().booleanAt(SQLPrms.supportDuplicateTables, false);
        rebalanceBuckets = TestConfig.tab().booleanAt(SQLPrms.rebalanceBuckets, false);
        isHATest = TestConfig.tab().longAt(StopStartPrms.numVMsToStop, 0L) > 0L ? true : rebalanceBuckets;
        isEdge = false;
        numOfStores = (int)TestConfig.tab().longAt(SQLPrms.numOfStores, 3L);
        numOfWorkers = (int)TestConfig.tab().longAt(SQLPrms.numOfWorkers, 6L);
        hasPersistentTables = TestConfig.tab().booleanAt(GfxdHelperPrms.persistTables, false);
        isWanTest = TestConfig.tab().booleanAt(SQLWanPrms.isWanTest, false);
        useWriterForWriteThrough = TestConfig.tab().booleanAt(SQLPrms.useWriterForWriteThrough, false);
        testLoaderCreateRandomRow = TestConfig.tab().booleanAt(SQLPrms.testLoaderCreateRandomRow, false);
        hasTx = TestConfig.tab().booleanAt(SQLPrms.hasTx, false);
        isOfflineTest = TestConfig.tab().booleanAt(SQLPrms.isOfflineTest, false);
        tradeSchemaSG = "tradeSchemaSG";
        testEviction = TestConfig.tab().booleanAt(SQLPrms.testEviction, false);
        useHeapPercentage = TestConfig.tab().booleanAt(SQLPrms.useHeapPercentage, false);
        setCriticalHeap = TestConfig.tab().booleanAt(SQLPrms.setCriticalHeap, false);
        getCanceled = new HydraThreadLocal();
        getNodeFailure = new HydraThreadLocal();
        getEvictionConflict = new HydraThreadLocal();
        useMultipleAsyncEventListener = TestConfig.tab().booleanAt(SQLPrms.useMultipleAsyncEventListener, true);
        withReplicatedTables = TestConfig.tab().booleanAt(SQLPrms.withReplicatedTables, false);
        maxResultWaitSec = TestConfig.tab().intAt(Prms.maxResultWaitSec, 300);
        addListenerUsingAlterTable = TestConfig.tab().booleanAt(SQLPrms.addListenerUsingAlterTable, false);
        cycleVms = TestConfig.tab().booleanAt(SQLPrms.cycleVms, true);
        generateIdAlways = TestConfig.tab().booleanAt(SQLPrms.generateIdAlways, false);
        generateDefaultId = TestConfig.tab().booleanAt(SQLPrms.generateDefaultId, false);
        createTableWithGeneratedId = TestConfig.tab().booleanAt(SQLPrms.createTableWithGeneratedId, false);
        dropProc = TestConfig.tab().booleanAt(SQLPrms.dropProc, true);
        dropFunc = TestConfig.tab().booleanAt(SQLPrms.dropFunc, false);
        ddlThread = -1;
        ticket45938fixed = TestConfig.tab().booleanAt(SQLPrms.ticket45938fixed, true);
        disableUpdateStatement48248 = TestConfig.tab().booleanAt(SQLPrms.disableUpdateStatement48248, false);
        testMultipleUniqueIndex = TestConfig.tab().booleanAt(SQLPrms.testMultipleUniqueIndex, false);
        derbyConnection = new HydraThreadLocal();
        resetDerbyConnection = new HydraThreadLocal();
        alterTableDropColumn = TestConfig.tab().booleanAt(SQLPrms.alterTableDropColumn, false);
        hasCompanies = TestConfig.tab().booleanAt(SQLPrms.hasCompanies, false);
        ticket46803fixed = TestConfig.tab().booleanAt(SQLPrms.ticket46803fixed, true);
        reproduceTicket46689 = false;
        alterTableException = new HydraThreadLocal();
        networkPartitionDetectionEnabled = false;
        gemfireCache = null;
        losingSideHost = null;
        populateWithbatch = TestConfig.tab().booleanAt(SQLPrms.populateWithbatch, false);
        isLocator = false;
        companyTable = "create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol, exchange), constraint comp_fk foreign key (symbol, exchange) references trade.securities (symbol, exchange) on delete restrict)";
        hasRedundancy = "hasRedundancy";
        cycleVMTarget = TestConfig.tab().stringAt(SQLPrms.cycleVMTarget, "store");
        waitTimeBeforeNextCycleVM = TestConfig.tab().intAt(SQLPrms.waitTimeBeforeNextCycleVM, 20);
        lastCycledTime = 0L;
        testWanUniqueness = TestConfig.tab().booleanAt(SQLWanPrms.testWanUniqueKeys, false);
        setIdentityColumn = TestConfig.tab().booleanAt(SQLPrms.setIdentityColumn, false);
        useDefaultDiskStoreForOverflow = TestConfig.tab().booleanAt(SQLPrms.useDefaultDiskStoreForOverflow, false);
        percentage = TestConfig.tab().doubleAt(SQLPrms.evictionHeapPercentage, 0.0);
        ticket49794fixed = TestConfig.tab().booleanAt(SQLPrms.ticket49794fixed, true);
        useC3P0 = TestConfig.tab().booleanAt(SQLPrms.useC3P0ConnectionPool, false);
        useDBCP = TestConfig.tab().booleanAt(SQLPrms.useDBCPConnectionPool, false);
        useTomcatConnPool = TestConfig.tab().booleanAt(SQLPrms.useTomcatConnectionPool, false);
        useGfxdConfig = TestConfig.tab().booleanAt(SQLPrms.useGfxdConfig, false);
        portfoliov1IsReady = false;
        hasPortfolioV1 = TestConfig.tab().booleanAt(SQLPrms.hasPortfolioV1, false);
        hasCustomersDup = TestConfig.tab().booleanAt(SQLPrms.hasCustomersDup, false);
        portfoliov1 = "portfoliov1";
        failAtUpdateCount = TestConfig.tab().booleanAt(SQLPrms.failAtUpdateCountDiff, false);
        workAround49565 = TestConfig.tab().booleanAt(SQLPrms.workAround49565, false);
        FS = File.separator;
        firstEntry = true;
        diskCompatibilityDiskStorePath = TestConfig.tab().pathAt(SQLPrms.sqlfireDiskStorePath, null);
        useRandomConfHdfsStore = HDFSTestPrms.useRandomConfig();
        useNewTables = TestConfig.tab().booleanAt(SQLPrms.useNewTables, false);
        waitForLocatorUpgrade = false;
        locatorUpgradeCompleted = false;
        useGenericSQL = TestConfig.tab().booleanAt(SQLPrms.useGenericSQLModel, false);
        sqlGen = null;
        setTx = TestConfig.tab().booleanAt(SQLPrms.setTx, false);
        verifyUsingOrderBy = TestConfig.tab().booleanAt(SQLPrms.verifyUsingOrderBy, false);
        initEvictionHeap = TestConfig.tab().doubleAt(SQLPrms.initEvictionHeapPercent, 60.0);
        workaround51582 = TestConfig.tab().booleanAt(SQLPrms.workaround51582, true);
        accessorUpgradeCompleted = false;
        storeUpgradeCompleted = false;
        verifyByTid = TestConfig.tab().booleanAt(SQLPrms.verifyByTid, false);
        if (testUniqueKeys) {
            testWanUniqueness = false;
        }
        if (testUniqueKeys && testWanUniqueness) {
            throw new TestException("test issue, should not set both testUniqueKeys and testWanUniqueness to true");
        }
        if (useGenericSQL) {
            sqlGen = new SQLOldTest();
        }
        oraclePassword = System.getProperty("user.name");
        DUPLICATE_TABLE_SUFFIX = "_fulldataset";
        MR_TABLE_SUFFIX = "_HDFS";
        isOffheap = TestConfig.tab().booleanAt(SQLPrms.isOffheap, false);
        randomizeOffHeap = TestConfig.tab().booleanAt(SQLPrms.randomizeOffHeap, false);
        allowConcDDLDMLOps = TestConfig.tab().booleanAt(SQLPrms.allowConcDDLDMLOps, false);
        limitConcDDLOps = TestConfig.tab().booleanAt(SQLPrms.limitConcDDLOps, true);
        forceCompaction = TestConfig.tab().booleanAt(SQLPrms.forceCompaction, false);
        syncHAForOfflineTest = TestConfig.tab().booleanAt(SQLPrms.syncHAForOfflineTest, false);
        dumpThreads = TestConfig.tab().booleanAt(SQLPrms.dumpThreads, false);
        dumpThreadsInterval = (int)TestConfig.tab().longAt(SQLPrms.dumpThreadsInterval, 10000L);
        dumpThreadsTotalTime = (int)TestConfig.tab().longAt(SQLPrms.dumpThreadsTotalTime, 600L);
        enableConcurrencyCheck = false;
        ENABLECONCURRENCYCHECKS = " ENABLE CONCURRENCY CHECKS ";
        isTicket51584Fixed = false;
        reproduceTicket51628 = false;
        listeners = new ArrayList<CallBackListener>();
    }
}

