/*
 * Decompiled with CFR 0.152.
 */
package sql;

import hydra.Log;
import hydra.RemoteTestModule;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.NetworkServerHelper;
import java.sql.Connection;
import sql.SQLPrms;
import sql.SQLTest;
import util.PRObserver;

public class SQLThinClientTest
extends SQLTest {
    protected static SQLThinClientTest sqlThinClientTest = new SQLThinClientTest();

    protected SQLThinClientTest() {
    }

    public static synchronized void HydraTask_initializeServer() {
        PRObserver.installObserverHook();
        PRObserver.initialize((int)RemoteTestModule.getMyVmid());
        SQLThinClientTest.initSQLTest();
    }

    public static synchronized void HydraTask_initClient() {
        SQLThinClientTest.initSQLTest();
    }

    public static synchronized void HydraTask_startFabricServer() {
        sqlThinClientTest.startFabricServer();
    }

    public static synchronized void HydraTask_startNetworkServer() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        NetworkServerHelper.startNetworkServers(networkServerConfig);
    }

    public static void HydraTask_createGfxdSchemasByClients() {
        sqlThinClientTest.createGfxdSchemasByClients();
    }

    protected void createGfxdSchemasByClients() {
        Connection conn = this.getGFEConnection();
        Log.getLogWriter().info("creating schema in gfxd.");
        if (!testServerGroupsInheritence) {
            this.createSchemas(conn);
        } else {
            String[] schemas = SQLPrms.getGFESchemas();
            this.createSchemas(conn, schemas);
        }
        Log.getLogWriter().info("done creating schema in gfxd.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_createGfxdTablesByClients() {
        sqlThinClientTest.createGfxdTablesByClients();
    }

    protected void createGfxdTablesByClients() {
        Connection conn = this.getGFEConnection();
        Log.getLogWriter().info("creating tables in gfxd.");
        this.createTables(conn);
        Log.getLogWriter().info("done creating tables in gfxd.");
        this.closeGFEConnection(conn);
    }

    public static void HydraTask_createDiscDB() {
        sqlThinClientTest.createDiscDB();
    }

    public static void HydraTask_createDiscSchemas() {
        sqlThinClientTest.createDiscSchemas();
    }

    public static void HydraTask_createDiscTables() {
        sqlThinClientTest.createDiscTables();
    }

    public static void HydraTask_setTableCols() {
        sqlThinClientTest.setTableCols();
    }

    @Override
    protected void setTableCols() {
        Connection gConn = this.getGFEConnection();
        SQLThinClientTest.setTableCols(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_populateTxTables() {
        sqlThinClientTest.populateTxTables();
    }

    protected void populateTxTables() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.populateTables(dConn, gConn);
        this.commit(gConn);
        this.commit(dConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_verifyResultSets() {
        sqlThinClientTest.verifyResultSets();
    }

    @Override
    protected void verifyResultSets() {
        if (!hasDerbyServer) {
            Log.getLogWriter().info("skipping verification of query results due to manageDerbyServer as false, myTid=" + this.getMyTid());
            this.cleanConnection(this.getGFEConnection());
            return;
        }
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.verifyResultSets(dConn, gConn);
    }

    public static void HydraTask_doDMLOp() {
        sqlThinClientTest.doDMLOp();
    }

    @Override
    protected void doDMLOp() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.doDMLOp(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    public static void HydraTask_queryOnJoinOp() {
        sqlThinClientTest.queryOnJoinOp();
    }

    @Override
    protected void queryOnJoinOp() {
        Log.getLogWriter().info("performing queryOnJoin, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        this.queryOnJoinOp(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    protected static void initSQLTest() {
        sqlTest = new SQLTest();
        sqlTest.initialize();
        isEdge = true;
    }
}

