/*
 * Decompiled with CFR 0.152.
 */
package sql;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.RemoteTestModule;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import sql.sqlutil.ResultSetHelper;
import util.PRObserver;
import util.TestException;

public class SingleTableTest
extends SQLTest {
    protected static SingleTableTest stTest = new SingleTableTest();

    public static synchronized void HydraTask_initialize() {
        if (stTest == null) {
            stTest = new SingleTableTest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            stTest.initialize();
        }
    }

    public static synchronized void HydraTask_createGFXDDB() {
        stTest.createGFXDDB();
    }

    public static synchronized void HydraTask_createGFXDDBForAccessors() {
        stTest.createGFXDDBForAccessors();
    }

    public static synchronized void HydraTask_createGFXDSchemas() {
        stTest.createGFESchemas();
    }

    public static void HydraTask_createGFXDTables() {
        stTest.createGFXDTables();
    }

    protected void createGFXDTables() {
        Connection conn = this.getGFEConnection();
        this.createTables(conn);
        this.closeGFEConnection(conn);
    }

    @Override
    protected void createTables(Connection conn) {
        String sql = "create table trade.networth (cid int not null, cash decimal (30, 15), securities decimal (30, 15), loanlimit int, availloan decimal (30, 15), tid int)";
        if (SQLTest.isOffheap) {
            sql = sql + " OFFHEAP ";
        }
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_populateTables() {
        stTest.populateTables();
    }

    @Override
    protected void populateTables() {
        Connection gConn = this.getGFEConnection();
        this.populateTables(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    protected void populateTables(Connection conn) {
        this.insertTable(conn, 100);
    }

    protected void insertTable(Connection conn, int size) {
        int[] cid = new int[size];
        int key = (int)SQLBB.getBB().getSharedCounters().add(SQLBB.tradeCustomersPrimary, (long)size);
        for (int i = 0; i < size; ++i) {
            int counter;
            cid[i] = counter = key - i;
        }
        int initialAmount = 1000;
        BigDecimal cash = new BigDecimal(initialAmount);
        int loanLimit = 1000;
        BigDecimal availLoan = new BigDecimal(loanLimit);
        BigDecimal securities = new BigDecimal(Integer.toString(0));
        this.insertToTable(conn, cid, cash, securities, loanLimit, availLoan, size);
    }

    protected void insertToTable(Connection conn, int[] cid, BigDecimal cash, BigDecimal securities, int loanLimit, BigDecimal availLoan, int size) {
        String insert = "insert into trade.networth values (?,?,?,?,?,?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(insert);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        int tid = this.getMyTid();
        Log.getLogWriter().info("Insert into gemfirexd, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, cid[i], cash, securities, loanLimit, availLoan, tid);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, int cid, BigDecimal cash, BigDecimal securities, int loanLimit, BigDecimal availLoan, int tid) throws SQLException {
        Log.getLogWriter().info("inserting into table trade.networth cid is " + cid + " cash is " + cash + " securities is " + securities + " loanLimit is " + loanLimit + " availLoan is " + loanLimit + " tid is " + tid);
        stmt.setInt(1, cid);
        stmt.setBigDecimal(2, cash);
        stmt.setBigDecimal(3, securities);
        stmt.setInt(4, loanLimit);
        stmt.setBigDecimal(5, availLoan);
        stmt.setInt(6, tid);
        int rowCount = stmt.executeUpdate();
        return rowCount;
    }

    protected void createProcedure(Connection conn) {
        String procedure = "create procedure trade.addInterest2 () PARAMETER STYLE JAVA LANGUAGE JAVA MODIFIES SQL DATA EXTERNAL NAME 'sql.ProcedureTest.addInterest2'";
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(procedure);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Y68")) {
                Log.getLogWriter().info("expected procedrue already exist exception, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void exeProcedure(Connection conn) {
        String procedure = null;
        procedure = random.nextBoolean() ? "create procedure trade.addInterest2 () PARAMETER STYLE JAVA LANGUAGE JAVA MODIFIES SQL DATA EXTERNAL NAME 'sql.ProcedureTest.addInterest2'" : "drop procedure trade.addInterest2";
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(procedure);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42Y55") || se.getSQLState().equals("42X94")) {
                Log.getLogWriter().info("expected procedrue does not exist exception, continuing test");
            }
            if (se.getSQLState().equals("X0Y68")) {
                Log.getLogWriter().info("expected procedrue already exist exception, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void createFunction(Connection conn) {
        String function = "create function multiply(DP1 Decimal (30, 15) ) RETURNS DECIMAL (30, 15) PARAMETER STYLE JAVA LANGUAGE JAVA NO SQL EXTERNAL NAME 'sql.FunctionTest.multiply2'";
        Log.getLogWriter().info("try to " + function);
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(function);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Y68")) {
                Log.getLogWriter().info("expected function already exist exception, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void exeFunction(Connection conn) {
        String function = random.nextBoolean() ? "create function multiply(DP1 Decimal (30, 15) ) RETURNS DECIMAL (30, 15) PARAMETER STYLE JAVA LANGUAGE JAVA NO SQL EXTERNAL NAME 'sql.FunctionTest.multiply2'" : "drop function multiply";
        Log.getLogWriter().info("try to " + function + " in gfe if exists");
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(function);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42Y55") || se.getSQLState().equals("42X94")) {
                Log.getLogWriter().info("expected function does not exist exception, continuing test");
            }
            if (se.getSQLState().equals("X0Y68")) {
                Log.getLogWriter().info("expected function already exist exception, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_doOps() {
        stTest.doOps();
    }

    public static void HydraTask_createDDL() {
        stTest.createDDL();
    }

    protected void createDDL() {
        Connection conn = this.getGFEConnection();
        this.createFunction(conn);
        this.createProcedure(conn);
        this.closeGFEConnection(conn);
    }

    @Override
    protected void doDDLOp() {
        Connection conn = this.getGFEConnection();
        this.closeGFEConnection(conn);
    }

    @Override
    protected void doDMLOp() {
        Connection conn = this.getGFEConnection();
        this.callProcedure(conn);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    protected void callProcedure(Connection conn) {
        String procedure = "trade.addInterest2";
        SingleTableTest.callProcedure(conn, procedure);
    }

    protected static void callProcedure(Connection conn, String whichProc) {
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        Log.getLogWriter().info("call GFE procedure " + whichProc + ", myTid is " + tid);
        try {
            SingleTableTest.callProcedure(conn, whichProc, tid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42Y03")) {
                Log.getLogWriter().info("got expected exception, continuing test");
            }
            if (se.getSQLState().equals("38000")) {
                Log.getLogWriter().info("got expected exception, continuing test");
            }
            if (se.getSQLState().equals("X0Z01")) {
                Log.getLogWriter().info("got expected exception, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected static void callProcedure(Connection conn, String proc, int tid) throws SQLException {
        CallableStatement cs = null;
        cs = conn.prepareCall("{call " + proc + " ()}");
        Log.getLogWriter().info("call " + proc);
        cs.execute();
        SQLWarning warning = cs.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
    }

    public static void HydraTask_verify() {
        stTest.verify();
    }

    protected void verify() {
        Connection conn = this.getGFEConnection();
        String sql = "select cash from trade.networth";
        List<Struct> results = null;
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            results = ResultSetHelper.asList(rs, false);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        Struct aStruct = (Struct)results.get(0);
        for (Struct result : results) {
            if (aStruct.equals(result)) continue;
            throw new TestException("The cash are not the same for all records : " + ResultSetHelper.listToString(results));
        }
    }
}

