/*
 * Decompiled with CFR 0.152.
 */
package sql.alterTable;

import hydra.HydraVector;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import java.util.Vector;
import sql.SQLHelper;
import sql.SQLTest;
import sql.alterTable.AlterTablePrms;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class AlterTableTest
extends SQLTest {
    protected static AlterTableTest alterTableTest;
    protected static final Random rand;

    public static synchronized void HydraTask_initialize() {
        if (alterTableTest == null) {
            alterTableTest = new AlterTableTest();
            alterTableTest.initialize();
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    public static void HydraTask_runSQLCommands() {
        HydraVector alterCmds;
        if (alterTableTest == null) {
            alterTableTest = new AlterTableTest();
        }
        if ((alterCmds = TestConfig.tab().vecAt(AlterTablePrms.sqlCmds)) != null) {
            for (int i = 0; i < alterCmds.size(); ++i) {
                block20: {
                    String sqlCmd = (String)alterCmds.get(i);
                    if (sqlCmd.contains("alter column") && !sqlCmd.contains("always")) {
                        if (i == 0) {
                            block18: {
                                try {
                                    AlterTableTest.runOneSQLCmd(alterTableTest.getGFEConnection(), sqlCmd, false, true);
                                }
                                catch (SQLException se) {
                                    if (!se.getSQLState().equalsIgnoreCase("0A000")) break block18;
                                    Log.getLogWriter().info("got expected 'Feature not implemented: Column modification not yet supported', continue testing");
                                    return;
                                }
                            }
                            throw new TestException("did not get unsupported exception, need to check and see if product supports alter column now");
                        }
                        Log.getLogWriter().info("does not support alter column yet");
                        return;
                    }
                    if (sqlCmd.contains("alter table") && sqlCmd.contains("eviction by")) {
                        block19: {
                            try {
                                AlterTableTest.runOneSQLCmd(alterTableTest.getGFEConnection(), sqlCmd, false, true);
                            }
                            catch (SQLException se) {
                                if (!se.getSQLState().equalsIgnoreCase("42X01")) break block19;
                                Log.getLogWriter().info("got expected 'syntax error exception' for alter eviction setting, continue testing");
                                return;
                            }
                        }
                        throw new TestException("did not get syntax error exception, need to check and see if product supports alter eviction now");
                    }
                    if (!sqlCmd.contains("alter table") || !sqlCmd.contains("expire")) continue;
                    try {
                        AlterTableTest.runOneSQLCmd(alterTableTest.getGFEConnection(), sqlCmd, false, true);
                    }
                    catch (SQLException se) {
                        if (!se.getSQLState().equalsIgnoreCase("42X01")) break block20;
                        Log.getLogWriter().info("got expected 'syntax error exception' for alter expiration setting, continue testing");
                        return;
                    }
                }
                throw new TestException("did not get syntax error exception, need to check and see if product supports alter expiration now");
            }
        }
        Log.getLogWriter().info("manageDerbyServer is " + Prms.tab().booleanAt(Prms.manageDerbyServer));
        if (Prms.tab().booleanAt(Prms.manageDerbyServer)) {
            AlterTableTest.runSQLCmdsDerby((Vector<String>)alterCmds);
        }
        AlterTableTest.runSQLCmdsGFE((Vector<String>)alterCmds);
        if (TestConfig.tab().get(AlterTablePrms.sqlNegativeCmds) != null) {
            HydraVector negativeCmds = TestConfig.tab().vecAt(AlterTablePrms.sqlNegativeCmds);
            for (String negativeCmd : negativeCmds) {
                Log.getLogWriter().info(negativeCmd);
                try {
                    AlterTableTest.runNegativeSQLCmdGFE(negativeCmd);
                    throw new TestException("Expected exception did not occur on " + negativeCmd);
                }
                catch (SQLException sqle) {
                    if (sqle.getSQLState().equalsIgnoreCase("23503") || sqle.getSQLState().equalsIgnoreCase("23513")) {
                        Log.getLogWriter().info("Got expected SQLException on " + negativeCmd + ", error code is " + sqle.getErrorCode() + ", exception text is " + sqle.getMessage());
                        continue;
                    }
                    SQLHelper.handleSQLException(sqle);
                }
            }
        }
    }

    public static void HydraTask_runSQLCommandsOnPopulatedDB() {
        HydraVector negativeCmds;
        HydraVector alterCmds;
        if (alterTableTest == null) {
            alterTableTest = new AlterTableTest();
        }
        if ((alterCmds = AlterTablePrms.getSqlCmdsForPopulatedDB()) != null) {
            for (int i = 0; i < alterCmds.size(); ++i) {
                String sqlCmd = (String)alterCmds.get(i);
                if (!sqlCmd.contains("alter column") || sqlCmd.contains("always")) continue;
                if (i == 0) {
                    block12: {
                        try {
                            AlterTableTest.runOneSQLCmd(alterTableTest.getGFEConnection(), sqlCmd, false, true);
                        }
                        catch (SQLException se) {
                            if (!se.getSQLState().equalsIgnoreCase("0A000")) break block12;
                            Log.getLogWriter().info("got expected 'Feature not implemented: Column modification not yet supported', continue testing");
                            return;
                        }
                    }
                    throw new TestException("did not get unsupported exception, need to check and see if product supports alter column now");
                }
                Log.getLogWriter().info("does not support alter column yet");
                return;
            }
        }
        if (alterCmds != null) {
            if (Prms.tab().booleanAt(Prms.manageDerbyServer)) {
                AlterTableTest.runSQLCmdsDerby((Vector<String>)alterCmds);
            }
            AlterTableTest.runSQLCmdsGFE((Vector<String>)alterCmds);
        }
        if ((negativeCmds = AlterTablePrms.getSqlNegativeCmdsForPopulatedDB()) != null) {
            for (String negativeCmd : negativeCmds) {
                try {
                    Log.getLogWriter().info(negativeCmd);
                    AlterTableTest.runNegativeSQLCmdGFE(negativeCmd);
                    throw new TestException("Expected exception did not occur on " + negativeCmd);
                }
                catch (SQLException sqle) {
                    Log.getLogWriter().info("Got expected SQLException on " + negativeCmd + ", error code is " + sqle.getErrorCode() + ", exception text is " + sqle.getMessage());
                }
            }
        }
    }

    public static void runOneSQLCmd(Connection conn, String sqlCmd, boolean isDerby, boolean logQueryResults) throws SQLException {
        if (sqlCmd.trim().toLowerCase().startsWith("select")) {
            Log.getLogWriter().info("executing query: " + sqlCmd);
            ResultSet rs = conn.createStatement().executeQuery(sqlCmd);
            if (rs != null && logQueryResults) {
                ResultSetHelper.logResultSet(Log.getLogWriter(), rs);
            }
        } else {
            SQLHelper.executeSQL(conn, sqlCmd, true);
        }
    }

    public static void runSQLCmdsBothConnections(Vector<String> sqlCmds) {
        AlterTableTest.runSQLCmdsDerby(sqlCmds);
        AlterTableTest.runSQLCmdsGFE(sqlCmds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runNegativeSQLCmdGFE(String sqlCmd) throws SQLException {
        Connection conn = alterTableTest.getGFEConnection();
        conn.setAutoCommit(true);
        try {
            conn.createStatement().execute(sqlCmd);
        }
        finally {
            alterTableTest.closeGFEConnection(conn);
        }
    }

    public static void runSQLCmdGFE(String sqlCmd) {
        Vector<String> sqlCmds = new Vector<String>();
        sqlCmds.add(sqlCmd);
        AlterTableTest.runSQLCmdsGFE(sqlCmds);
    }

    public static void runSQLCmdsGFE(Vector<String> sqlCmds) {
        try {
            Connection conn = alterTableTest.getGFEConnection();
            conn.setAutoCommit(true);
            for (String sqlCmd : sqlCmds) {
                Log.getLogWriter().info("Running " + sqlCmd + " on GFE");
                AlterTableTest.runOneSQLCmd(conn, sqlCmd, false, true);
            }
            alterTableTest.closeGFEConnection(conn);
        }
        catch (SQLException sqle) {
            throw new TestException("gfe SQL connection exception", (Throwable)sqle);
        }
    }

    public static void runSQLCmdsDerby(Vector<String> sqlCmds) {
        try {
            Connection conn = alterTableTest.getDiscConnection();
            conn.setAutoCommit(true);
            for (String sqlCmd : sqlCmds) {
                Log.getLogWriter().info("Running " + sqlCmd + " on Derby");
                AlterTableTest.runOneSQLCmd(conn, sqlCmd, true, true);
            }
            alterTableTest.closeDiscConnection(conn);
        }
        catch (SQLException sqle) {
            throw new TestException("derby SQL connection exception", (Throwable)sqle);
        }
    }

    static {
        rand = new Random();
    }
}

