/*
 * Decompiled with CFR 0.152.
 */
package sql.backupAndRestore;

import hydra.Log;
import java.util.List;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import sql.backupAndRestore.BackupAndRestorePrms;

public class BackupAndRestoreUtils {
    public static double CheckDataStoreBytesInUse() {
        double dataStoreBytesInUse = 0.0;
        String archiveName = BackupAndRestorePrms.getArchiveName();
        Log.getLogWriter().info("BackupAndRestoreUtils.CheckDataStoreBytesInUse-archiveName=" + archiveName);
        String spec = "*" + archiveName + "* " + "PartitionedRegionStats " + "* " + "dataStoreBytesInUse " + "filter" + "=" + "none" + " " + "combine" + "=" + "combineAcrossArchives" + " " + "ops" + "=" + "max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("BackupAndRestoreUtils.CheckDataStoreBytesInUse-No Stats Found for spec:" + spec);
        } else {
            Log.getLogWriter().info("BackupAndRestoreUtils.CheckDataStoreBytesInUse-Getting Stats for spec:" + spec);
            for (Object anAList : aList) {
                PerfStatValue stat = (PerfStatValue)anAList;
                double statMax = stat.getMax();
                Log.getLogWriter().info("BackupAndRestoreUtils.CheckDataStoreBytesInUse-statMax=" + statMax);
                dataStoreBytesInUse += statMax;
            }
            Log.getLogWriter().info("BackupAndRestoreUtils.CheckDataStoreBytesInUse-dataStoreBytesInUse=" + dataStoreBytesInUse);
            Log.getLogWriter().info("BackupAndRestoreUtils.CheckDataStoreBytesInUse-dataStoreBytesInUse(MB)=" + dataStoreBytesInUse / 1048576.0);
            Log.getLogWriter().info("BackupAndRestoreUtils.CheckDataStoreBytesInUse-dataStoreBytesInUse(GB)=" + dataStoreBytesInUse / 1.073741824E9);
        }
        return dataStoreBytesInUse;
    }

    public static double GetMBInUse() {
        double mbInUse = BackupAndRestoreUtils.CheckDataStoreBytesInUse() / 1048576.0;
        Log.getLogWriter().info("BackupAndRestoreUtils.GetMBInUse-mbInUse=" + mbInUse);
        return mbInUse;
    }
}

