/*
 * Decompiled with CFR 0.152.
 */
package sql.backupAndRestore;

import com.gemstone.gemfire.LogWriter;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import hydra.gemfirexd.FabricServerHelper;
import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import sql.SQLHelper;
import sql.backupAndRestore.BackupAndRestoreBB;
import sql.backupAndRestore.BackupAndRestorePrms;
import sql.backupAndRestore.OpTracker;
import sql.memscale.TableDefinition;
import sql.view.ViewTest;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class BackupRestoreBigDataTest
extends ViewTest {
    private static BackupRestoreBigDataTest BackupRestoreBigDataTest;
    private static final long MEGABYTE = 0x100000L;
    private static final long GIGABYTE = 0x40000000L;
    private static final Object KEY_TABLES;
    private static final Object KEY_TIMINGS;
    private static final Object KEY_TABLE_ROW_COUNTS;
    private static final String KEY_VALIDATION_ERRORS = "validationErrors";
    private static final String SCHEMA_NAME = "bigDataTest";
    private static final String FILE_SEPARATOR;
    private static final String BACKUP_PREFIX = "backup_";
    private static final String BASELINE_OPT = "-baseline=";
    private static final String DISK_DIR_SUFFIX = "_disk";
    private static final String RESTORE_LINUX = "restore.sh";
    private static final String RESTORE_WINDOWS = "restore.bat";
    private static final String PREFIX_PK = "PK_";
    private static final String PREFIX_INSERT = "insert-";
    private static final String PREFIX_UPDATE = "update-This data was updated";
    private static final String THREADGROUP_CLIENT = "clientThreads";
    private static final String THREADGROUP_DDL = "ddlThread";
    private static final String DATA_TYPE_INTEGER = "INTEGER";
    private static final String DATA_TYPE_VARCHAR = "VARCHAR";
    private static final String DATA_TYPE_CLOB = "CLOB";
    private static final String DATA_TYPE_DATE = "DATE";
    private static LogWriter logWriter;
    private static Set<String> availableTables;
    private static Date insertDate;
    private static Date updateDate;
    private static HydraThreadLocal threadLocal_clientThreadIsPaused;
    private static HydraThreadLocal threadLocal_gfxdConnection;
    private static HydraThreadLocal threadLocal_deletePreparedStatements;
    private static HydraThreadLocal threadLocal_insertPreparedStatements;
    private static HydraThreadLocal threadLocal_updatePreparedStatements;
    private static HydraThreadLocal threadLocal_isClientLeader;
    private static HydraThreadLocal threadLocal_opTracker;

    public static void HydraTask_checkParameters() {
        int deletePercent;
        int updatePercent;
        int insertPercent = BackupAndRestorePrms.getInsertPercent();
        int totalOpPercent = insertPercent + (updatePercent = BackupAndRestorePrms.getUpdatePercent()) + (deletePercent = BackupAndRestorePrms.getDeletePercent());
        if (totalOpPercent != 100) {
            throw new TestException("The total operation percentage needs to equal 100%. The total operation percentage is the sum of the parameters:\n  sql.backupAndRestore.BackupAndRestorePrms-insertPercent (" + insertPercent + "),\n  sql.backupAndRestore.BackupAndRestorePrms-updatePercent (" + updatePercent + "), and\n  sql.backupAndRestore.BackupAndRestorePrms-deletePercent (" + deletePercent + ")\n                                              which total " + totalOpPercent + "%.");
        }
    }

    public static void HydraTask_initializeTest() {
        if (BackupRestoreBigDataTest == null) {
            BackupRestoreBigDataTest = new BackupRestoreBigDataTest();
            Calendar cal = Calendar.getInstance();
            insertDate = new Date(cal.getTime().getTime());
            cal.add(5, 1);
            updateDate = new Date(cal.getTime().getTime());
            logWriter = Log.getLogWriter();
        }
    }

    public static void HydraTask_getGFXDConnection() {
        BackupRestoreBigDataTest.getGFXDConnection();
    }

    private void getGFXDConnection() {
        Connection conn = BackupRestoreBigDataTest.getGFXDClientConnection();
        logWriter.info("BackupRestoreBigDataTest.getGFXDConnection-Connection Set-conn=" + conn);
        threadLocal_gfxdConnection.set((Object)conn);
    }

    public static void HydraTask_generateTableDefinitions() {
        int nbrTables = BackupAndRestorePrms.getNbrTables();
        if (nbrTables <= 0) {
            throw new TestException("Expected " + BackupAndRestorePrms.class.getName() + ".nbrTables to be > 0)");
        }
        ArrayList<TableDefinition> tableList = new ArrayList<TableDefinition>();
        int nbrLobColumns = BackupAndRestorePrms.getNbrLobColumns();
        for (int tableNbr = 1; tableNbr <= nbrTables; ++tableNbr) {
            int startingColNbr;
            String tableName = "Table_" + String.format("%03d", tableNbr);
            int nbrColumnsThisTable = BackupAndRestorePrms.getNbrColumnsPerTable();
            logWriter.info("BackupRestoreBigDataTest.generateTableDefinitions-nbrColumnsThisTable=" + nbrColumnsThisTable);
            if (nbrColumnsThisTable <= 0) {
                throw new TestException("Expected " + BackupAndRestorePrms.class.getName() + ".nbrColumnsPerTable to be > 0");
            }
            TableDefinition tableDef = new TableDefinition(SCHEMA_NAME, tableName);
            int nbrLobColumnsThisTable = 0;
            if (nbrLobColumns > 0) {
                nbrLobColumnsThisTable = nbrLobColumns / nbrTables;
                if (nbrLobColumns % nbrTables > 0) {
                    ++nbrLobColumnsThisTable;
                }
                --nbrLobColumns;
            }
            tableDef.addColumn("pKey", DATA_TYPE_VARCHAR, "20", true);
            for (int columnNbr = startingColNbr = 2; columnNbr <= nbrColumnsThisTable; ++columnNbr) {
                String columnName = "col_" + columnNbr;
                String dataType = BackupAndRestorePrms.getColumnType();
                if (nbrLobColumnsThisTable > 0) {
                    dataType = BackupAndRestorePrms.getLobColumnType();
                    --nbrLobColumnsThisTable;
                }
                if (dataType.equalsIgnoreCase(DATA_TYPE_VARCHAR)) {
                    tableDef.addColumn(columnName, dataType, "" + BackupAndRestorePrms.getVarCharLength(), false);
                    continue;
                }
                if (dataType.equalsIgnoreCase(DATA_TYPE_CLOB)) {
                    tableDef.addColumn(columnName, dataType, BackupAndRestorePrms.getLobLength(), false);
                    continue;
                }
                tableDef.addColumn(columnName, dataType, false);
            }
            tableList.add(tableDef);
        }
        logWriter.info("BackupRestoreBigDataTest.generateTableDefinitions-Table Count=" + tableList.size());
        BackupAndRestoreBB.getBB().getSharedMap().put(KEY_TABLES, tableList);
    }

    public static void HydraTask_createTables() {
        List tableList = (List)BackupAndRestoreBB.getBB().getSharedMap().get(KEY_TABLES);
        for (TableDefinition table : tableList) {
            String createStmt = table.getCreateTableStatement() + " " + BackupAndRestorePrms.getExtraTableClause();
            logWriter.info("BackupRestoreBigDataTest.createTables-About to execute sql statement: " + createStmt);
            sql.backupAndRestore.BackupRestoreBigDataTest.executeSqlStatement(createStmt, true);
        }
        logWriter.info("BackupRestoreBigDataTest.createTables-Created " + tableList.size() + " tables");
        sql.backupAndRestore.BackupRestoreBigDataTest.setEvictionHeapPercentage();
        Connection conn = (Connection)threadLocal_gfxdConnection.get();
        ResultSet rs = sql.backupAndRestore.BackupRestoreBigDataTest.executeSqlQuery(conn, "SELECT tablename FROM sys.systables WHERE tabletype = 'T' AND tableschemaname = '" + SCHEMA_NAME.toUpperCase() + "'");
        try {
            rs.beforeFirst();
            availableTables = new TreeSet<String>();
            while (rs.next()) {
                String tableName = rs.getString(1);
                availableTables.add(tableName);
            }
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
        StringBuilder aStr = new StringBuilder("Tables from bigDataTest schema:\n");
        if (availableTables.size() == 0) {
            aStr.append("   Table is empty");
        } else {
            for (String tableName : availableTables) {
                aStr.append("  ").append(tableName).append("\n");
            }
        }
        logWriter.info("BackupRestoreBigDataTest.HydraTask_createTables:" + aStr.toString());
    }

    private static void setEvictionHeapPercentage() {
        try {
            Connection conn = (Connection)threadLocal_gfxdConnection.get();
            String getEvictionHeapPercentageSql = "values SYS.GET_EVICTION_HEAP_PERCENTAGE()";
            ResultSet resultSet = sql.backupAndRestore.BackupRestoreBigDataTest.executeSqlQuery(conn, getEvictionHeapPercentageSql);
            resultSet.beforeFirst();
            while (resultSet.next()) {
                logWriter.info("BackupRestoreBigDataTest.setEvictionHeapPercentage-percentage before set=" + resultSet.getDouble(1));
            }
            String setEvictionHeapPercentageSql = "CALL SYS.SET_EVICTION_HEAP_PERCENTAGE(?)";
            double evictionHeapPercentage = BackupAndRestorePrms.getEvictionHeapPercentage();
            logWriter.info("BackupRestoreBigDataTest.setEvictionHeapPercentage-sql=" + setEvictionHeapPercentageSql + " with args " + evictionHeapPercentage);
            CallableStatement cs = conn.prepareCall(setEvictionHeapPercentageSql);
            cs.setDouble(1, evictionHeapPercentage);
            cs.executeUpdate();
            resultSet = sql.backupAndRestore.BackupRestoreBigDataTest.executeSqlQuery(conn, getEvictionHeapPercentageSql);
            resultSet.beforeFirst();
            while (resultSet.next()) {
                logWriter.info("BackupRestoreBigDataTest.setEvictionHeapPercentage-percentage after set=" + resultSet.getDouble(1));
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_createIndexes() {
        GsRandom rand = TestConfig.tab().getRandGen();
        List tableList = (List)BackupAndRestoreBB.getBB().getSharedMap().get(KEY_TABLES);
        for (TableDefinition table : tableList) {
            String fullTableName = table.getFullTableName();
            int nbrOfColumns = table.getNumColumns();
            int startingColNbr = 0;
            boolean validColumnType = false;
            while (++startingColNbr != nbrOfColumns && !(validColumnType = !table.getColumnType(startingColNbr).equalsIgnoreCase(DATA_TYPE_CLOB))) {
            }
            if (validColumnType) {
                int randColNbr = rand.nextInt(startingColNbr, nbrOfColumns - 1);
                String randColName = table.getColumnName(randColNbr);
                String indexName = "idx" + fullTableName.substring(fullTableName.length() - 3, fullTableName.length()) + "_" + (randColNbr + 1);
                String order = (randColNbr & 1) == 1 ? "ASC" : "DESC";
                String createStmt = "CREATE INDEX " + indexName + " ON " + fullTableName + " (" + randColName + " " + order + ")";
                logWriter.info("BackupRestoreBigDataTest.HydraTask_createIndexes-About to execute sql statement: " + createStmt);
                sql.backupAndRestore.BackupRestoreBigDataTest.executeSqlStatement(createStmt, true);
                continue;
            }
            logWriter.info("BackupRestoreBigDataTest.HydraTask_createIndexes-An index could not be created for table '" + fullTableName + "' because all columns are CLOBS.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeSqlStatement(String sqlStatement, boolean logStatement) {
        Connection conn = (Connection)threadLocal_gfxdConnection.get();
        try (Statement stmt = conn.createStatement();){
            if (logStatement) {
                logWriter.info("BackupRestoreBigDataTest.executeSqlStatement-Executing sql statement: '" + sqlStatement + "'");
            }
            long startTime = System.currentTimeMillis();
            stmt.execute(sqlStatement);
            long duration = System.currentTimeMillis() - startTime;
            if (logStatement) {
                logWriter.info("BackupRestoreBigDataTest.executeSqlStatement-Done executing sql statement: '" + sqlStatement + "' in " + duration + "ms");
            }
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
    }

    private static ResultSet executeSqlQuery(Connection conn, String sqlQuery) {
        try {
            Statement stmt = conn.createStatement(1004, 1007);
            logWriter.info("BackupRestoreBigDataTest.executeSqlQuery-Executing sql query: " + sqlQuery);
            long startTime = System.currentTimeMillis();
            ResultSet rs = stmt.executeQuery(sqlQuery);
            long duration = System.currentTimeMillis() - startTime;
            logWriter.info("BackupRestoreBigDataTest.executeSqlQuery-Done executing sql query: " + sqlQuery + " in " + duration + "ms");
            return rs;
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
    }

    public static void HydraTask_createPreparedStatements() {
        List tableList = (List)BackupAndRestoreBB.getBB().getSharedMap().get(KEY_TABLES);
        if (tableList == null) {
            throw new TestException("Test problem, no tableList defined, this task should execute after HydraTask_generateTableDefinitions");
        }
        Connection conn = (Connection)threadLocal_gfxdConnection.get();
        threadLocal_insertPreparedStatements.set(sql.backupAndRestore.BackupRestoreBigDataTest.createPreparedInsertStmtMap(conn, tableList));
        threadLocal_updatePreparedStatements.set(sql.backupAndRestore.BackupRestoreBigDataTest.createPreparedUpdateStmtMap(conn, tableList));
        threadLocal_deletePreparedStatements.set(sql.backupAndRestore.BackupRestoreBigDataTest.createPreparedDeleteStmtMap(conn, tableList));
    }

    private static Map<String, List> createPreparedInsertStmtMap(Connection conn, List<TableDefinition> tableList) {
        HashMap<String, List> insertStmtMap = new HashMap<String, List>();
        for (TableDefinition table : tableList) {
            CallableStatement preparedStmt;
            int colNbr;
            StringBuilder insertStmt = new StringBuilder();
            String fullTableName = table.getFullTableName();
            insertStmt.append("INSERT INTO ").append(fullTableName).append(" (");
            int nbrColumns = table.getNumColumns();
            for (colNbr = 1; colNbr <= nbrColumns; ++colNbr) {
                insertStmt.append(table.getColumnName(colNbr - 1));
                if (colNbr == nbrColumns) continue;
                insertStmt.append(", ");
            }
            insertStmt.append(") VALUES (");
            for (colNbr = 1; colNbr <= nbrColumns; ++colNbr) {
                insertStmt.append("?");
                if (colNbr == nbrColumns) continue;
                insertStmt.append(", ");
            }
            insertStmt.append(")");
            try {
                preparedStmt = conn.prepareCall(insertStmt.toString());
            }
            catch (SQLException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
            ArrayList<Object> stmtList = new ArrayList<Object>();
            stmtList.add(insertStmt.toString());
            logWriter.info("insert statement is: " + insertStmt.toString());
            stmtList.add(preparedStmt);
            insertStmtMap.put(fullTableName, stmtList);
        }
        logWriter.fine("BackupRestoreBigDataTest.createPreparedInsertStmtMap-Created prepared statement map: " + insertStmtMap);
        return insertStmtMap;
    }

    private static Map<String, List> createPreparedUpdateStmtMap(Connection conn, List<TableDefinition> tableList) {
        HashMap<String, List> updateStmtMap = new HashMap<String, List>();
        for (TableDefinition table : tableList) {
            CallableStatement preparedStmt;
            StringBuilder updateStmt = new StringBuilder();
            String fullTableName = table.getFullTableName();
            updateStmt.append("UPDATE ").append(fullTableName).append(" SET ");
            int nbrColumns = table.getNumColumns();
            for (int colNbr = 1; colNbr < nbrColumns; ++colNbr) {
                updateStmt.append(table.getColumnName(colNbr)).append("=?");
                if (colNbr == nbrColumns - 1) continue;
                updateStmt.append(", ");
            }
            updateStmt.append(" WHERE pKey=?");
            try {
                preparedStmt = conn.prepareCall(updateStmt.toString());
            }
            catch (SQLException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
            ArrayList<Object> stmtList = new ArrayList<Object>();
            stmtList.add(updateStmt.toString());
            logWriter.info("update statement is: " + updateStmt.toString());
            stmtList.add(preparedStmt);
            updateStmtMap.put(fullTableName, stmtList);
        }
        logWriter.fine("BackupRestoreBigDataTest.createPreparedUpdateStmtMap-Created prepared statement map: " + updateStmtMap);
        return updateStmtMap;
    }

    private static Map<String, List> createPreparedDeleteStmtMap(Connection conn, List<TableDefinition> tableList) {
        HashMap<String, List> deleteStmtMap = new HashMap<String, List>();
        for (TableDefinition table : tableList) {
            CallableStatement preparedStmt;
            StringBuilder deleteStmt = new StringBuilder();
            String fullTableName = table.getFullTableName();
            deleteStmt.append("DELETE FROM ").append(fullTableName).append(" WHERE pKey=?");
            try {
                preparedStmt = conn.prepareCall(deleteStmt.toString());
            }
            catch (SQLException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
            ArrayList<Object> stmtList = new ArrayList<Object>();
            stmtList.add(deleteStmt.toString());
            logWriter.info("delete statement is: " + deleteStmt.toString());
            stmtList.add(preparedStmt);
            deleteStmtMap.put(fullTableName, stmtList);
        }
        logWriter.fine("BackupRestoreBigDataTest.createPreparedDeleteStmtMap-Created prepared statement map: " + deleteStmtMap);
        return deleteStmtMap;
    }

    public static void HydraTask_clickStopWatch() {
        String keySuffix = BackupAndRestorePrms.getTimingKeySuffix();
        BackupAndRestoreBB.getBB().getSharedMap().put((Object)(KEY_TIMINGS + keySuffix), (Object)System.nanoTime());
    }

    public static void HydraTask_doDataInitialization() {
        boolean isClientLeader;
        SharedCounters sharedCounters = BackupAndRestoreBB.getBB().getSharedCounters();
        Object value = threadLocal_isClientLeader.get();
        if (value == null) {
            isClientLeader = sharedCounters.incrementAndRead(BackupAndRestoreBB.theClientLeader) == 1L;
            threadLocal_isClientLeader.set((Object)isClientLeader);
        } else {
            isClientLeader = (Boolean)value;
        }
        logWriter.fine("BackupRestoreBigDataTest.HydraTask_doDataInitialization-isClientLeader=" + isClientLeader);
        Connection conn = (Connection)threadLocal_gfxdConnection.get();
        boolean reusePreparedStatements = BackupAndRestorePrms.getReusePreparedStatements();
        logWriter.fine("BackupRestoreBigDataTest.HydraTask_doDataInitialization-reusePreparedStatements=" + reusePreparedStatements);
        long msToRun = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, 30L) * 1000L;
        long startTime = System.currentTimeMillis();
        do {
            int pkIndex = new Long(sharedCounters.incrementAndRead(BackupAndRestoreBB.largestKey)).intValue();
            logWriter.fine("BackupRestoreBigDataTest.HydraTask_doDataInitialization-pkIndex=" + pkIndex);
            sql.backupAndRestore.BackupRestoreBigDataTest.insertRowIntoAllTables(conn, pkIndex, reusePreparedStatements);
        } while (System.currentTimeMillis() - startTime < msToRun && !sql.backupAndRestore.BackupRestoreBigDataTest.hasInitialDataSizeBeenMet());
        if (sql.backupAndRestore.BackupRestoreBigDataTest.hasInitialDataSizeBeenMet()) {
            if (isClientLeader) {
                double mbInUse = sharedCounters.read(BackupAndRestoreBB.totalDataBytes) / 0x100000L;
                int largestPK = new Long(sharedCounters.read(BackupAndRestoreBB.largestKey)).intValue();
                logWriter.info("BackupRestoreBigDataTest.HydraTask_doDataInitialization-The initial data load is finished. Created " + mbInUse + " MB of data in " + largestPK + " total records.");
            }
            throw new StopSchedulingTaskOnClientOrder("The initial data load is finished. Stopping this client's InitTask.");
        }
    }

    private static boolean hasInitialDataSizeBeenMet() {
        double mbInUse = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.totalDataBytes) / 0x100000L;
        return mbInUse >= (double)BackupAndRestorePrms.getInitialDataMB();
    }

    private static void insertRowIntoAllTables(Connection conn, int pkIndex, boolean reusePreparedStatements) {
        Map insertStmtMap = (Map)threadLocal_insertPreparedStatements.get();
        List tableList = (List)BackupAndRestoreBB.getBB().getSharedMap().get(KEY_TABLES);
        for (TableDefinition table : tableList) {
            CallableStatement preparedStmt;
            List stmtList = (List)insertStmtMap.get(table.getFullTableName());
            String insertStmt = (String)stmtList.get(0);
            boolean closePreparedStatement = false;
            if (reusePreparedStatements) {
                preparedStmt = (CallableStatement)stmtList.get(1);
            } else {
                try {
                    preparedStmt = conn.prepareCall(insertStmt);
                }
                catch (SQLException e) {
                    throw new TestException(TestHelper.getStackTrace((Throwable)e));
                }
                closePreparedStatement = true;
            }
            List<Object> preparedStmtArgs = sql.backupAndRestore.BackupRestoreBigDataTest.buildInsertPreparedStmtArgs(conn, table, pkIndex);
            int result = sql.backupAndRestore.BackupRestoreBigDataTest.executePreparedStatementUpdate(preparedStmt, insertStmt, preparedStmtArgs);
            long totalRowLength = sql.backupAndRestore.BackupRestoreBigDataTest.calculateRowLength(preparedStmtArgs);
            if (result <= 0) {
                throw new TestException("An Error has occurred while Inserting a row into the " + table.getFullTableName() + " table. result=" + result + ", insertStmt=" + insertStmt + ", preparedStmtArgs=" + sql.backupAndRestore.BackupRestoreBigDataTest.reportPreparedStmtArgs(preparedStmtArgs) + ".");
            }
            BackupAndRestoreBB.getBB().getSharedCounters().add(BackupAndRestoreBB.totalDataBytes, totalRowLength);
            if (closePreparedStatement) {
                try {
                    preparedStmt.close();
                }
                catch (SQLException e) {
                    throw new TestException(TestHelper.getStackTrace((Throwable)e));
                }
            }
            for (Object stmtArg : preparedStmtArgs) {
                if (!(stmtArg instanceof Clob)) continue;
                try {
                    ((Clob)stmtArg).free();
                }
                catch (SQLException e) {
                    throw new TestException(TestHelper.getStackTrace((Throwable)e));
                }
            }
            if (!setTx) continue;
            try {
                conn.commit();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public static void HydraTask_setupOpTrackers() {
        int maxStartKey = new Long(BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.largestKey)).intValue();
        int nbrOfClientThreads = TestConfig.getInstance().getThreadGroup(THREADGROUP_CLIENT).getTotalThreads();
        OpTracker opTracker = new OpTracker(maxStartKey, nbrOfClientThreads += TestConfig.getInstance().getThreadGroup(THREADGROUP_DDL).getTotalThreads());
        threadLocal_opTracker.set((Object)opTracker);
    }

    public static void HydraTask_doRandomOps() {
        SharedCounters sharedCounters = BackupAndRestoreBB.getBB().getSharedCounters();
        if (sharedCounters.read(BackupAndRestoreBB.PauseOps) > 0L) {
            logWriter.info("BackupRestoreBigDataTest.HydraTask_doRandomOps-It is time to pause client ops");
            if (((Boolean)threadLocal_clientThreadIsPaused.get()).booleanValue()) {
                logWriter.info("BackupRestoreBigDataTest.HydraTask_doRandomOps-This client thread is already paused");
            } else {
                logWriter.info("BackupRestoreBigDataTest.HydraTask_doRandomOps-This client thread is now paused");
                threadLocal_clientThreadIsPaused.set((Object)true);
                sharedCounters.increment(BackupAndRestoreBB.PauseOps);
            }
            MasterController.sleepForMs((int)5000);
        } else {
            threadLocal_clientThreadIsPaused.set((Object)false);
            sql.backupAndRestore.BackupRestoreBigDataTest.clientRandomOps();
        }
    }

    private static void clientRandomOps() {
        SharedCounters sharedCounters = BackupAndRestoreBB.getBB().getSharedCounters();
        Connection conn = (Connection)threadLocal_gfxdConnection.get();
        OpTracker opTracker = (OpTracker)threadLocal_opTracker.get();
        boolean reusePreparedStatements = BackupAndRestorePrms.getReusePreparedStatements();
        logWriter.fine("BackupRestoreBigDataTest.clientsDoOps-This thread is doing ops, reusePreparedStatements=" + reusePreparedStatements);
        int insertPercent = BackupAndRestorePrms.getInsertPercent() / 2;
        int updatePercent = BackupAndRestorePrms.getUpdatePercent();
        int deletePercent = BackupAndRestorePrms.getDeletePercent();
        GsRandom rand = TestConfig.tab().getRandGen();
        long msToRun = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, 30L) * 1000L;
        long startTime = System.currentTimeMillis();
        do {
            int pkIndex;
            int opType = opTracker.getOpType() == 1 ? (rand.nextInt(1, insertPercent + updatePercent) <= insertPercent ? -1 : 1) : (rand.nextInt(1, insertPercent + deletePercent) <= insertPercent ? -1 : 2);
            if (opType == -1) {
                pkIndex = new Long(sharedCounters.incrementAndRead(BackupAndRestoreBB.largestKey)).intValue();
            } else {
                opTracker.rebaseAt(new Long(sharedCounters.read(BackupAndRestoreBB.largestKey)).intValue());
                pkIndex = opTracker.nextKeyForOp();
                if (pkIndex == -1) {
                    logWriter.error("BackupRestoreBigDataTest.clientsDoOps-pkIndex=" + pkIndex + " is not ready in the OpTracker, skipping this update / delete");
                }
                logWriter.fine("BackupRestoreBigDataTest.clientsDoOps-pkIndex=" + pkIndex + ", opType=" + opType + ", opTracker=" + opTracker.toString());
            }
            sql.backupAndRestore.BackupRestoreBigDataTest.performAnOpOnAllTables(conn, pkIndex, reusePreparedStatements, opType);
        } while (System.currentTimeMillis() - startTime < msToRun && sharedCounters.read(BackupAndRestoreBB.PauseOps) == 0L);
        threadLocal_opTracker.set((Object)opTracker);
    }

    private static void performAnOpOnAllTables(Connection conn, int pkIndex, boolean reusePreparedStatements, int opType) {
        Map preparedStmtMap = opType == -1 ? (Map)threadLocal_insertPreparedStatements.get() : (opType == 1 ? (Map)threadLocal_updatePreparedStatements.get() : (Map)threadLocal_deletePreparedStatements.get());
        List tableList = (List)BackupAndRestoreBB.getBB().getSharedMap().get(KEY_TABLES);
        for (TableDefinition table : tableList) {
            CallableStatement preparedStmt;
            List stmtList = (List)preparedStmtMap.get(table.getFullTableName());
            String sqlStmt = (String)stmtList.get(0);
            boolean closePreparedStatement = false;
            if (reusePreparedStatements) {
                preparedStmt = (CallableStatement)stmtList.get(1);
            } else {
                try {
                    preparedStmt = conn.prepareCall(sqlStmt);
                }
                catch (SQLException e) {
                    throw new TestException(TestHelper.getStackTrace((Throwable)e));
                }
                closePreparedStatement = true;
            }
            List<Object> preparedStmtArgs = opType == -1 ? sql.backupAndRestore.BackupRestoreBigDataTest.buildInsertPreparedStmtArgs(conn, table, pkIndex) : (opType == 1 ? sql.backupAndRestore.BackupRestoreBigDataTest.buildUpdatePreparedStmtArgs(conn, table, pkIndex) : sql.backupAndRestore.BackupRestoreBigDataTest.buildDeletePreparedStmtArgs(table.getColumnType(0), pkIndex));
            int result = sql.backupAndRestore.BackupRestoreBigDataTest.executePreparedStatementUpdate(preparedStmt, sqlStmt, preparedStmtArgs);
            if (result > 0) {
                if (opType == -1) {
                    long totalRowLength = sql.backupAndRestore.BackupRestoreBigDataTest.calculateRowLength(preparedStmtArgs);
                    logWriter.fine("BackupRestoreBigDataTest.performAnOpOnAllTables-totalRowLength=" + totalRowLength);
                    BackupAndRestoreBB.getBB().getSharedCounters().add(BackupAndRestoreBB.totalDataBytes, totalRowLength);
                } else if (opType == 1) {
                    BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.nbrOfUpdates);
                } else if (opType == 2) {
                    BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.nbrOfDeletes);
                }
            } else {
                throw new TestException("An Error has occurred while Inserting a row into the " + table.getFullTableName() + " table. result=" + result + ", opType=" + opType + ", sqlStmt=" + sqlStmt + ", preparedStmtArgs=" + sql.backupAndRestore.BackupRestoreBigDataTest.reportPreparedStmtArgs(preparedStmtArgs) + ".");
            }
            if (closePreparedStatement) {
                try {
                    preparedStmt.close();
                }
                catch (SQLException e) {
                    throw new TestException(TestHelper.getStackTrace((Throwable)e));
                }
            }
            for (Object stmtArg : preparedStmtArgs) {
                if (!(stmtArg instanceof Clob)) continue;
                try {
                    ((Clob)stmtArg).free();
                }
                catch (SQLException e) {
                    throw new TestException(TestHelper.getStackTrace((Throwable)e));
                }
            }
            if (!setTx) continue;
            try {
                conn.commit();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    private static List<Object> buildInsertPreparedStmtArgs(Connection conn, TableDefinition table, int pkIndex) {
        ArrayList<Object> preparedStmtArgs = new ArrayList<Object>();
        int nbrColumns = table.getNumColumns();
        for (int colNbr = 0; colNbr < nbrColumns; ++colNbr) {
            String dataType = table.getColumnType(colNbr);
            if (DATA_TYPE_INTEGER.equalsIgnoreCase(dataType)) {
                preparedStmtArgs.add(pkIndex);
                continue;
            }
            if (DATA_TYPE_VARCHAR.equalsIgnoreCase(dataType)) {
                if (colNbr == 0) {
                    preparedStmtArgs.add(PREFIX_PK + pkIndex);
                    continue;
                }
                preparedStmtArgs.add(sql.backupAndRestore.BackupRestoreBigDataTest.buildRandomString(Integer.valueOf(table.getColumnLength(colNbr)), PREFIX_INSERT));
                continue;
            }
            if (DATA_TYPE_DATE.equalsIgnoreCase(dataType)) {
                preparedStmtArgs.add(insertDate);
                continue;
            }
            if (DATA_TYPE_CLOB.equalsIgnoreCase(dataType)) {
                preparedStmtArgs.add(sql.backupAndRestore.BackupRestoreBigDataTest.buildRandomClobObject(conn, table.getColumnLength(colNbr), PREFIX_INSERT));
                continue;
            }
            throw new TestException("BackupRestoreBigDataTest.buildInsertPreparedStmtArgs-Test does not currently support dataType " + dataType);
        }
        return preparedStmtArgs;
    }

    private static List<Object> buildUpdatePreparedStmtArgs(Connection conn, TableDefinition table, int pkIndex) {
        ArrayList<Object> preparedStmtArgs = new ArrayList<Object>();
        for (int colNbr = 1; colNbr < table.getNumColumns(); ++colNbr) {
            String dataType = table.getColumnType(colNbr);
            if (DATA_TYPE_INTEGER.equalsIgnoreCase(dataType)) {
                preparedStmtArgs.add(pkIndex + 5);
                continue;
            }
            if (DATA_TYPE_VARCHAR.equalsIgnoreCase(dataType)) {
                preparedStmtArgs.add(sql.backupAndRestore.BackupRestoreBigDataTest.buildRandomString(Integer.valueOf(table.getColumnLength(colNbr)), PREFIX_UPDATE));
                continue;
            }
            if (DATA_TYPE_DATE.equalsIgnoreCase(dataType)) {
                preparedStmtArgs.add(updateDate);
                continue;
            }
            if (DATA_TYPE_CLOB.equalsIgnoreCase(dataType)) {
                preparedStmtArgs.add(sql.backupAndRestore.BackupRestoreBigDataTest.buildRandomClobObject(conn, table.getColumnLength(colNbr), PREFIX_UPDATE));
                continue;
            }
            throw new TestException("BackupRestoreBigDataTest.buildUpdatePreparedStmtArgs-Test does not currently support dataType " + dataType);
        }
        if (table.getColumnType(0).equalsIgnoreCase(DATA_TYPE_VARCHAR)) {
            preparedStmtArgs.add(PREFIX_PK + pkIndex);
        } else {
            preparedStmtArgs.add(pkIndex);
        }
        return preparedStmtArgs;
    }

    private static String buildRandomString(int columnLength, String dataPrefix) {
        int maxDataLen;
        String dataValue = dataPrefix;
        GsRandom rand = TestConfig.tab().getRandGen();
        RandomValues rv = new RandomValues();
        RandomValues.setPrintableChars((boolean)true);
        int desiredDataLen = maxDataLen = columnLength - dataValue.length();
        if (rand.nextInt(1, 100) <= 80) {
            desiredDataLen = rand.nextInt(1, maxDataLen);
        }
        dataValue = dataValue + rv.getRandom_String('\'', desiredDataLen);
        return dataValue;
    }

    private static Clob buildRandomClobObject(Connection conn, String columnLength, String dataPrefix) {
        Clob clobObj;
        long colLenBytes = sql.backupAndRestore.BackupRestoreBigDataTest.getNbrBytes(columnLength);
        int firstThird = (int)((double)colLenBytes * 0.33);
        int secondThird = (int)((double)colLenBytes * 0.66);
        GsRandom rand = TestConfig.tab().getRandGen();
        int randInt = rand.nextInt(1, 100);
        long desiredDataLen = randInt <= 25 ? rand.nextLong(1L, (long)firstThird) : (randInt <= 50 ? rand.nextLong((long)(firstThird + 1), (long)secondThird) : (randInt <= 75 ? rand.nextLong((long)(secondThird + 1), colLenBytes) : colLenBytes));
        try {
            RandomValues rv = new RandomValues();
            RandomValues.setPrintableChars((boolean)true);
            clobObj = conn.createClob();
            String clobValue = dataPrefix + rv.getRandom_String('\'', desiredDataLen - (long)dataPrefix.length());
            clobObj.setString(1L, clobValue);
            logWriter.fine("BackupRestoreBigDataTest.buildRandomClobObject-Created CLOB of size " + desiredDataLen + " for a CLOB field of size " + columnLength);
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
        return clobObj;
    }

    private static String reportPreparedStmtArgs(List<Object> preparedStmtArgs) {
        String argsString = "";
        int argCntr = 0;
        for (Object smtArg : preparedStmtArgs) {
            if (argCntr > 0) {
                argsString = argsString + ",\n";
            }
            argsString = argsString + "Argument " + argCntr;
            if (smtArg instanceof String) {
                argsString = argsString + " (String) ='" + smtArg;
            } else if (smtArg instanceof Integer) {
                argsString = argsString + " (Integer) ='" + smtArg;
            } else if (smtArg instanceof Date) {
                argsString = argsString + " (Date) ='" + smtArg;
            } else if (smtArg instanceof Clob) {
                try {
                    int length = PREFIX_UPDATE.length();
                    argsString = argsString + " (Clob(1st " + length + " bytes)) ='" + ((Clob)smtArg).getSubString(0L, length);
                }
                catch (SQLException e) {
                    throw new TestException(TestHelper.getStackTrace((Throwable)e));
                }
            }
            argsString = argsString + "'";
            ++argCntr;
        }
        return argsString;
    }

    private static long getNbrBytes(String byteSpec) {
        char ch;
        int index;
        String intStr = "";
        for (index = 0; index < byteSpec.length() && Character.isDigit(ch = byteSpec.charAt(index)); ++index) {
            intStr = intStr + ch;
        }
        int n = Integer.valueOf(intStr);
        String units = byteSpec.substring(index);
        if (units.equalsIgnoreCase("K")) {
            return n * 1024;
        }
        if (units.equalsIgnoreCase("M")) {
            return (long)n * 0x100000L;
        }
        if (units.equalsIgnoreCase("G")) {
            return (long)n * 0x40000000L;
        }
        throw new TestException("Test problem: unknown byteSpec " + byteSpec);
    }

    private static List<Object> buildDeletePreparedStmtArgs(String columnType, int pkIndex) {
        ArrayList<Object> preparedStmtArgs = new ArrayList<Object>();
        if (columnType.equalsIgnoreCase(DATA_TYPE_VARCHAR)) {
            preparedStmtArgs.add(PREFIX_PK + pkIndex);
        } else {
            preparedStmtArgs.add(pkIndex);
        }
        return preparedStmtArgs;
    }

    private static int executePreparedStatementUpdate(CallableStatement preparedStmt, String sqlStmt, List<Object> args) {
        try {
            StringBuilder argsStr = new StringBuilder();
            for (int argCtr = 0; argCtr < args.size(); ++argCtr) {
                Object anArg = args.get(argCtr);
                if (anArg instanceof Clob) {
                    argsStr.append("' a Clob of size ").append(((Clob)anArg).length()).append("'");
                } else {
                    argsStr.append("'").append(anArg).append("'");
                }
                if (argCtr >= args.size() - 1) continue;
                argsStr.append(", ");
            }
            String pkIndex = sqlStmt.startsWith("INSERT") ? args.get(0).toString() : args.get(args.size() - 1).toString();
            for (int argIndex = 1; argIndex <= args.size(); ++argIndex) {
                Object arg = args.get(argIndex - 1);
                if (arg instanceof String) {
                    preparedStmt.setString(argIndex, (String)arg);
                    continue;
                }
                if (arg instanceof Integer) {
                    preparedStmt.setInt(argIndex, (int)((Integer)arg));
                    continue;
                }
                if (arg instanceof Date) {
                    preparedStmt.setDate(argIndex, (Date)arg);
                    continue;
                }
                if (!(arg instanceof Clob)) continue;
                preparedStmt.setClob(argIndex, (Clob)arg);
            }
            logWriter.fine("BackupRestoreBigDataTest.executePreparedStatementUpdate-sqlStmt=" + sqlStmt + " with arg(s): " + argsStr + "), primaryKey is " + pkIndex);
            logWriter.info("Executing sqlStmt " + sqlStmt + " on primaryKey: " + pkIndex + ".");
            int result = preparedStmt.executeUpdate();
            logWriter.info("BackupRestoreBigDataTest.executePreparedStatementUpdate-result=" + result);
            return result;
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
    }

    private static long calculateRowLength(List<Object> args) {
        long totalRowLength = 0L;
        for (Object arg : args) {
            if (arg instanceof String) {
                totalRowLength += (long)((String)arg).length();
                continue;
            }
            if (arg instanceof Integer) {
                totalRowLength += 4L;
                continue;
            }
            if (arg instanceof Date) {
                totalRowLength += 32L;
                continue;
            }
            if (!(arg instanceof Clob)) continue;
            try {
                totalRowLength += ((Clob)arg).length();
            }
            catch (SQLException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
        }
        return totalRowLength;
    }

    public static void HydraTask_doBackups() {
        logWriter.fine("BackupRestoreBigDataTest.HydraTask_doBackups");
        SharedCounters sharedCounters = BackupAndRestoreBB.getBB().getSharedCounters();
        if (sharedCounters.read(BackupAndRestoreBB.nbrOfThreadsToPause) == 0L) {
            int nbrOfClientThreads = TestConfig.getInstance().getThreadGroup(THREADGROUP_CLIENT).getTotalThreads();
            nbrOfClientThreads += TestConfig.getInstance().getThreadGroup(THREADGROUP_DDL).getTotalThreads();
            sharedCounters.add(BackupAndRestoreBB.nbrOfThreadsToPause, (long)(++nbrOfClientThreads));
        }
        int secondsForThreadToSleep = 30;
        logWriter.info("BackupRestoreBigDataTest.HydraTask_doBackups-Thread is going to sleep for " + secondsForThreadToSleep + " seconds to allow other vms to do random ops");
        MasterController.sleepForMs((int)(secondsForThreadToSleep * 1000));
        if (sql.backupAndRestore.BackupRestoreBigDataTest.isItTimeToBackup()) {
            sql.backupAndRestore.BackupRestoreBigDataTest.triggerBackup();
        }
        if (sql.backupAndRestore.BackupRestoreBigDataTest.hasDataOpsSizeBeenMet()) {
            sharedCounters.increment(BackupAndRestoreBB.PauseOps);
            int totalThreadsToPause = (int)sharedCounters.read(BackupAndRestoreBB.nbrOfThreadsToPause);
            logWriter.info("BackupRestoreBigDataTest.HydraTask_doBackups-DataOps are done, lets pause all threads-totalThreadsToPause=" + totalThreadsToPause);
            TestHelper.waitForCounter((Blackboard)BackupAndRestoreBB.getBB(), (String)"PauseOps", (int)BackupAndRestoreBB.PauseOps, (long)totalThreadsToPause, (boolean)true, (long)-1L, (long)2000L);
            sql.backupAndRestore.BackupRestoreBigDataTest.triggerBackup();
            throw new StopSchedulingOrder("We are done generating data & performing backups.");
        }
    }

    private static boolean hasDataOpsSizeBeenMet() {
        int initialDataMB = BackupAndRestorePrms.getInitialDataMB();
        int desiredDataOpsMB = BackupAndRestorePrms.getDesiredDataOpsMB();
        double mbInUse = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.totalDataBytes) / 0x100000L;
        boolean sizeHasBeenMet = mbInUse >= (double)(initialDataMB + desiredDataOpsMB);
        logWriter.fine("BackupRestoreBigDataTest.hasDataOpsSizeBeenMet-initialDataMB=" + initialDataMB + ", desiredDataOpsMB=" + desiredDataOpsMB + ", mbInUse=" + mbInUse + ", sizeHasBeenMet=" + sizeHasBeenMet);
        return sizeHasBeenMet;
    }

    private static boolean isItTimeToBackup() {
        int backupAfterMBofData = BackupAndRestorePrms.getBackupAfterMBofData();
        int initialDataMB = BackupAndRestorePrms.getInitialDataMB();
        SharedCounters sharedCounters = BackupAndRestoreBB.getBB().getSharedCounters();
        long backupCtr = sharedCounters.read(BackupAndRestoreBB.BackupCtr);
        double mbInUse = sharedCounters.read(BackupAndRestoreBB.totalDataBytes) / 0x100000L;
        boolean timeToBackup = mbInUse - (double)initialDataMB >= (double)((long)backupAfterMBofData * (backupCtr + 1L));
        logWriter.fine("BackupRestoreBigDataTest.isItTimeToBackup-backupAfterMBofData=" + backupAfterMBofData + ", initialDataMB=" + initialDataMB + ", backupCtr=" + backupCtr + ", mbInUse=" + mbInUse + ", timeToBackup=" + timeToBackup);
        return timeToBackup;
    }

    public static void HydraTask_doFullOnlineBackup() {
        sql.backupAndRestore.BackupRestoreBigDataTest.triggerFullOnlineBackup();
    }

    private static void triggerBackup() {
        boolean doBackup = BackupAndRestorePrms.getDoBackup();
        logWriter.info("BackupRestoreBigDataTest.triggerBackup-doBackup=" + doBackup);
        if (doBackup) {
            boolean incrementalBackups = BackupAndRestorePrms.getIncrementalBackups();
            logWriter.info("BackupRestoreBigDataTest.triggerBackup-incrementalBackups=" + incrementalBackups);
            long BackupCtr = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.BackupCtr);
            logWriter.info("BackupRestoreBigDataTest.triggerBackup-BackupCtr=" + BackupCtr);
            if (incrementalBackups && BackupCtr > 0L) {
                sql.backupAndRestore.BackupRestoreBigDataTest.triggerIncrementalOnlineBackup();
            } else {
                sql.backupAndRestore.BackupRestoreBigDataTest.triggerFullOnlineBackup();
            }
        }
    }

    private static void triggerFullOnlineBackup() {
        sql.backupAndRestore.BackupRestoreBigDataTest.performOnlineBackup(false);
    }

    private static void triggerIncrementalOnlineBackup() {
        sql.backupAndRestore.BackupRestoreBigDataTest.performOnlineBackup(true);
    }

    private static void performOnlineBackup(boolean incremental) {
        logWriter.info("BackupRestoreBigDataTest.performOnlineBackup-incremental=" + incremental);
        File rootBackupDir = new File(BackupAndRestorePrms.getBackupPath());
        logWriter.info("BackupRestoreBigDataTest.performOnlineBackup-rootBackupDir=" + rootBackupDir);
        long backupCtr = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.BackupCtr);
        logWriter.info("BackupRestoreBigDataTest.performOnlineBackup-backupCtr=" + backupCtr);
        String incrementalClause = "";
        if (incremental) {
            String baselineDir = rootBackupDir + FILE_SEPARATOR + BACKUP_PREFIX + backupCtr;
            logWriter.info("BackupRestoreBigDataTest.performOnlineBackup-baselineDir1=" + baselineDir);
            File[] baselineDirContents = new File(baselineDir).listFiles();
            if ((baselineDirContents != null ? baselineDirContents.length : 0) != 1) {
                throw new TestException("BackupRestoreBigDataTest.performOnlineBackup-On line backup cannot continue because we were expecting 1 subdirectory in the '" + baselineDir + "' directory, but found " + (baselineDirContents != null ? baselineDirContents.length : 0));
            }
            File backupDateDir = baselineDirContents[0];
            logWriter.info("BackupRestoreBigDataTest.performOnlineBackup-backupDateDir.getName()=" + backupDateDir.getName());
            baselineDir = baselineDir + FILE_SEPARATOR + backupDateDir.getName();
            logWriter.info("BackupRestoreBigDataTest.performOnlineBackup-baselineDir2=" + baselineDir);
            incrementalClause = BASELINE_OPT + baselineDir + " ";
        }
        logWriter.info("BackupRestoreBigDataTest.performOnlineBackup-incrementalClause=" + incrementalClause);
        String gfxdCommand = FabricServerHelper.getGFXDCommand();
        Properties properties = DistributedSystemHelper.getDistributedSystem().getProperties();
        String backupDir = rootBackupDir + FILE_SEPARATOR + BACKUP_PREFIX + (backupCtr + 1L);
        logWriter.info("BackupRestoreBigDataTest.performOnlineBackup-backupDir=" + backupDir);
        String backupCmd = gfxdCommand + " backup " + incrementalClause + backupDir + " -locators=" + properties.get("locators");
        logWriter.info("BackupRestoreBigDataTest.performOnlineBackup-backupCmd=" + backupCmd);
        String backupResult = null;
        try {
            backupResult = ProcessMgr.fgexec((String)backupCmd, (int)300);
        }
        catch (HydraRuntimeException e) {
            e.printStackTrace();
            logWriter.error("BackupRestoreBigDataTest.performOnlineBackup-Backup Failed: e.getCause()=" + e.getCause());
            logWriter.error("BackupRestoreBigDataTest.performOnlineBackup-Backup Failed: e.getMessage()=" + e.getMessage());
        }
        logWriter.info("BackupRestoreBigDataTest.performOnlineBackup-Done calling online backup tool, backupResult is " + backupResult);
        if (backupResult != null && !backupResult.contains("Backup successful")) {
            throw new TestException("BackupRestoreBigDataTest.performOnlineBackup-On line backup was not successful, backupResult from online backup is " + backupResult);
        }
        BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.BackupCtr);
    }

    public static void HydraTask_snapShotRowCounts() {
        Map<String, Number> tableRowCounts = sql.backupAndRestore.BackupRestoreBigDataTest.getTableRowCounts();
        BackupAndRestoreBB.getBB().getSharedMap().put(KEY_TABLE_ROW_COUNTS, tableRowCounts);
    }

    public static void HydraTask_verifyRowCounts() {
        HashMap expRowCnts = (HashMap)BackupAndRestoreBB.getBB().getSharedMap().get(KEY_TABLE_ROW_COUNTS);
        Map<String, Number> actRowCnts = sql.backupAndRestore.BackupRestoreBigDataTest.getTableRowCounts();
        StringBuilder errorSB = new StringBuilder();
        for (Map.Entry expEntry : expRowCnts.entrySet()) {
            Number expRowCnt = (Number)expEntry.getValue();
            Number actRowCnt = actRowCnts.get(expEntry.getKey());
            logWriter.info("BackupRestoreBigDataTest.HydraTask_verifyVerifiableData-For table '" + (String)expEntry.getKey() + "' we expected '" + expRowCnt + "' rows. Actual rows is '" + actRowCnt + "'.\n");
            if (expRowCnt.intValue() == actRowCnt.intValue()) continue;
            errorSB.append("Table ").append((String)expEntry.getKey()).append("'s row counts are incorrect. Expected ").append(expRowCnt).append(" rows, but we have ").append(actRowCnt).append(" rows.");
        }
        if (errorSB.length() != 0) {
            throw new TestException("Error! " + errorSB.toString());
        }
    }

    private static Map<String, Number> getTableRowCounts() {
        Connection conn = (Connection)threadLocal_gfxdConnection.get();
        HashMap<String, Number> tableRowCounts = new HashMap<String, Number>();
        for (String tableName : availableTables) {
            ResultSet rs = sql.backupAndRestore.BackupRestoreBigDataTest.executeSqlQuery(conn, "SELECT count(*) FROM " + SCHEMA_NAME.toUpperCase() + "." + tableName);
            try {
                rs.beforeFirst();
                while (rs.next()) {
                    Double nbrOfRows = rs.getDouble(1);
                    logWriter.info("BackupRestoreBigDataTest.getTableRowCounts-For table '" + tableName + "' we got '" + nbrOfRows + "' rows.");
                    tableRowCounts.put(tableName, nbrOfRows);
                }
            }
            catch (SQLException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
        }
        return tableRowCounts;
    }

    public static void HydraTask_validateData() {
        int pkIndex;
        OpTracker opTracker = (OpTracker)threadLocal_opTracker.get();
        int maxPK = new Long(BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.largestKey)).intValue();
        if (opTracker.getMaxEndKey() != maxPK) {
            opTracker.rebaseAt(maxPK);
            logWriter.info("BackupRestoreBigDataTest.HydraTask_validateData-rebased the OpTracker to maxPK=" + maxPK + " opTracker=" + opTracker.toString());
        }
        List tableList = (List)BackupAndRestoreBB.getBB().getSharedMap().get(KEY_TABLES);
        Connection conn = (Connection)threadLocal_gfxdConnection.get();
        Map<String, List> selectStmtMap = sql.backupAndRestore.BackupRestoreBigDataTest.createPreparedSelectStmtMap(conn, tableList);
        long msToRun = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, 30L) * 1000L;
        long startTime = System.currentTimeMillis();
        do {
            pkIndex = opTracker.nextKeyForValidation();
            threadLocal_opTracker.set((Object)opTracker);
            if (pkIndex < 0) break;
            BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.validateCnt);
            sql.backupAndRestore.BackupRestoreBigDataTest.validateRowInAllTables(tableList, selectStmtMap, pkIndex, opTracker);
            long validationErrorCnt = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.validationErrorCnt);
            int maxValidationErrors = BackupAndRestorePrms.getMaxValidationErrors();
            if (maxValidationErrors <= 0 || validationErrorCnt < (long)maxValidationErrors) continue;
            throw new StopSchedulingTaskOnClientOrder("We have encountered too may errors. We were ask to stop validating at " + maxValidationErrors + "errors. We have found " + validationErrorCnt + ". Stopping any further validation.");
        } while (System.currentTimeMillis() - startTime < msToRun);
        if (pkIndex < 0) {
            throw new StopSchedulingTaskOnClientOrder("All data validation is finished. Stopping this clients CloseTask.");
        }
    }

    private static void validateRowInAllTables(List<TableDefinition> tableList, Map<String, List> selectStmtMap, int pkIndex, OpTracker opTracker) {
        boolean trackingUpdate = false;
        boolean trackingDelete = false;
        if (opTracker.isKeyTracked(pkIndex)) {
            if (opTracker.isUpdateTracker()) {
                trackingUpdate = true;
            } else if (opTracker.isDeleteTracker()) {
                trackingDelete = true;
            }
        }
        StringBuilder errorSB = new StringBuilder();
        for (TableDefinition table : tableList) {
            String tableName = table.getFullTableName();
            List stmtList = selectStmtMap.get(tableName);
            String selectStmt = (String)stmtList.get(0);
            PreparedStatement preparedStmt = (PreparedStatement)stmtList.get(1);
            List<Object> preparedStmtArgs = sql.backupAndRestore.BackupRestoreBigDataTest.buildSelectPreparedStmtArgs(table.getColumnType(0), pkIndex);
            ResultSet resultSet = sql.backupAndRestore.BackupRestoreBigDataTest.executePreparedStatementQuery(preparedStmt, selectStmt, preparedStmtArgs);
            try {
                boolean haveARow = resultSet.first();
                if (haveARow) {
                    if (trackingDelete) {
                        errorSB.append("  Table '").append(tableName).append("' contains a row that should have been deleted. We expected all rows with the key '").append(pkIndex).append("' to be deleted. We used the following query=").append(selectStmt).append("\n");
                        BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.validationErrorCnt);
                        continue;
                    }
                    errorSB.append(sql.backupAndRestore.BackupRestoreBigDataTest.validateColumns(table, pkIndex, resultSet, trackingUpdate));
                    continue;
                }
                if (trackingDelete) continue;
                errorSB.append("  Table '").append(tableName).append("' did not contain a row that it should have. We were expecting a row with the key '").append(pkIndex).append("' to be found using the following query=").append(selectStmt).append("\n");
                BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.validationErrorCnt);
            }
            catch (SQLException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
        }
        if (errorSB.length() != 0) {
            errorSB = new StringBuilder("Errors for primary key '").append(pkIndex).append("':\n").append(errorSB.toString()).append("\n");
            BackupAndRestoreBB.getBB().getSharedMap().put((Object)(KEY_VALIDATION_ERRORS + pkIndex), (Object)errorSB);
        }
    }

    private static String validateColumns(TableDefinition table, int pkIndex, ResultSet resultSet, boolean isUpdate) {
        String expectedDateValue;
        String expectedStringValue;
        String expectedStringPkValue;
        int expectedIntValue;
        StringBuilder errorForPkSB = new StringBuilder();
        if (isUpdate) {
            expectedIntValue = pkIndex + 5;
            expectedStringPkValue = PREFIX_PK + pkIndex;
            expectedStringValue = PREFIX_UPDATE;
            expectedDateValue = updateDate.toString();
        } else {
            expectedIntValue = pkIndex;
            expectedStringPkValue = PREFIX_PK + pkIndex;
            expectedStringValue = PREFIX_INSERT;
            expectedDateValue = insertDate.toString();
        }
        try {
            for (int tblColNbr = 0; tblColNbr < table.getNumColumns(); ++tblColNbr) {
                Object dataValue;
                int rsColNbr = tblColNbr + 1;
                String dataType = table.getColumnType(tblColNbr);
                if (DATA_TYPE_INTEGER.equalsIgnoreCase(dataType)) {
                    dataValue = resultSet.getInt(rsColNbr);
                    if ((Integer)dataValue == expectedIntValue) continue;
                    errorForPkSB.append("  Table '").append(table.getFullTableName()).append("' has the wrong value for column '").append(tblColNbr).append("'. We expected '").append(expectedIntValue).append("' , but we have '").append(dataValue).append("'.\n");
                    BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.validationErrorCnt);
                    continue;
                }
                if (DATA_TYPE_VARCHAR.equalsIgnoreCase(dataType)) {
                    dataValue = resultSet.getString(rsColNbr);
                    if (tblColNbr == 0) {
                        if (((String)dataValue).equals(expectedStringPkValue)) continue;
                        errorForPkSB.append("  Table '").append(table.getFullTableName()).append("' has the wrong value for column '").append(tblColNbr).append("'. We expected '").append(expectedStringPkValue).append("' , but we have '").append((String)dataValue).append("'.\n");
                        BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.validationErrorCnt);
                        continue;
                    }
                    if (((String)dataValue).startsWith(expectedStringValue)) continue;
                    errorForPkSB.append("  Table '").append(table.getFullTableName()).append("' has the wrong value for column '").append(tblColNbr).append("'. We expected it to start with '").append(expectedStringValue).append("' , but we have '").append((String)dataValue).append("'.\n");
                    BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.validationErrorCnt);
                    continue;
                }
                if (DATA_TYPE_DATE.equalsIgnoreCase(dataType)) {
                    dataValue = resultSet.getDate(rsColNbr).toString();
                    if (((String)dataValue).equals(expectedDateValue)) continue;
                    errorForPkSB.append("  Table '").append(table.getFullTableName()).append("' has the wrong value for column '").append(tblColNbr).append("'. We expected '").append(expectedDateValue).append("' , but we have '").append((String)dataValue).append("'.\n");
                    BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.validationErrorCnt);
                    continue;
                }
                if (!DATA_TYPE_CLOB.equalsIgnoreCase(dataType)) continue;
                Clob aClob = resultSet.getClob(rsColNbr);
                String clobValue = aClob.getSubString(1L, expectedStringValue.length());
                if (!clobValue.equals(expectedStringValue)) {
                    errorForPkSB.append("  Table '").append(table.getFullTableName()).append("' has the wrong value for (Clob) column '").append(tblColNbr).append("'. We expected it to start with '").append(expectedStringValue).append("' , but we have '").append(clobValue).append("'.\n");
                    BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.validationErrorCnt);
                }
                aClob.free();
            }
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
        return errorForPkSB.toString();
    }

    private static Map<String, List> createPreparedSelectStmtMap(Connection conn, List<TableDefinition> tableList) {
        HashMap<String, List> selectStmtMap = new HashMap<String, List>();
        for (TableDefinition table : tableList) {
            StringBuilder selectStmt = new StringBuilder();
            String fullTableName = table.getFullTableName();
            selectStmt.append("SELECT ");
            int nbrColumns = table.getNumColumns();
            for (int colNbr = 0; colNbr < nbrColumns; ++colNbr) {
                selectStmt.append(table.getColumnName(colNbr));
                if (colNbr == nbrColumns - 1) continue;
                selectStmt.append(", ");
            }
            selectStmt.append(" FROM ").append(fullTableName).append(" WHERE pKey=?");
            try {
                PreparedStatement preparedStmt = conn.prepareStatement(selectStmt.toString(), 1004, 1007);
                ArrayList<Object> stmtList = new ArrayList<Object>();
                stmtList.add(selectStmt.toString());
                stmtList.add(preparedStmt);
                selectStmtMap.put(fullTableName, stmtList);
            }
            catch (SQLException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
        }
        logWriter.fine("BackupRestoreBigDataTest.createPreparedSelectStmtMap-Created prepared statement map: " + selectStmtMap);
        return selectStmtMap;
    }

    private static List<Object> buildSelectPreparedStmtArgs(String columnType, int pkIndex) {
        ArrayList<Object> preparedStmtArgs = new ArrayList<Object>();
        if (columnType.equalsIgnoreCase(DATA_TYPE_VARCHAR)) {
            preparedStmtArgs.add(PREFIX_PK + pkIndex);
        } else {
            preparedStmtArgs.add(pkIndex);
        }
        return preparedStmtArgs;
    }

    private static ResultSet executePreparedStatementQuery(PreparedStatement preparedStmt, String selectStmt, List<Object> args) {
        ResultSet rs;
        StringBuilder argsStr = new StringBuilder();
        for (int argCtr = 0; argCtr < args.size(); ++argCtr) {
            Object anArg = args.get(argCtr);
            argsStr.append("'").append(anArg).append("'");
            if (argCtr >= args.size() - 1) continue;
            argsStr.append(", ");
        }
        logWriter.fine("BackupRestoreBigDataTest.executePreparedStatementQuery-selectStmt=" + selectStmt + " with arg(s): " + argsStr);
        try {
            for (int i = 0; i < args.size(); ++i) {
                int argIndex = i + 1;
                Object arg = args.get(i);
                if (arg instanceof String) {
                    preparedStmt.setString(argIndex, (String)arg);
                    continue;
                }
                if (!(arg instanceof Integer)) continue;
                preparedStmt.setInt(argIndex, (Integer)arg);
            }
            rs = preparedStmt.executeQuery();
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
        return rs;
    }

    public static void HydraTask_doRestoreBackup() {
        sql.backupAndRestore.BackupRestoreBigDataTest.deleteExistingDiskDirs();
        sql.backupAndRestore.BackupRestoreBigDataTest.performRestoreOfBackup();
    }

    private static void deleteExistingDiskDirs() {
        File[] contents;
        String currDirName = System.getProperty("user.dir");
        logWriter.info("BackupRestoreBigDataTest.deleteExistingDiskDirs-currDirName=" + currDirName);
        ArrayList<String> dirsToDelete = new ArrayList<String>();
        File currDir = new File(currDirName);
        for (File aDir : contents = currDir.listFiles()) {
            String dirName = aDir.getName();
            if (!aDir.isDirectory() || !dirName.endsWith(DISK_DIR_SUFFIX) || dirName.contains("locator")) continue;
            logWriter.fine("BackupRestoreBigDataTest.deleteExistingDiskDirs-aDir.getName()=" + dirName);
            dirsToDelete.add(dirName);
        }
        int deletedCnt = 0;
        for (String dirToDelete : dirsToDelete) {
            deletedCnt += sql.backupAndRestore.BackupRestoreBigDataTest.deleteDir(new File(dirToDelete));
        }
        logWriter.info("BackupRestoreBigDataTest.deleteExistingDiskDirs-deletedCnt=" + deletedCnt);
    }

    private static int deleteDir(File aDir) {
        File[] contents;
        int deletedCnt = 0;
        ArrayList<String> deleteExceptions = new ArrayList<String>();
        for (File aFile : contents = aDir.listFiles()) {
            if (aFile.isDirectory()) {
                deletedCnt += sql.backupAndRestore.BackupRestoreBigDataTest.deleteDir(aFile);
                continue;
            }
            if (aFile.delete()) {
                logWriter.fine("BackupRestoreBigDataTest.deleteDir-Deleted file: " + aFile.getAbsolutePath());
                ++deletedCnt;
                continue;
            }
            deleteExceptions.add("Could not delete file: " + aFile.getAbsolutePath());
        }
        if (aDir.delete()) {
            logWriter.fine("BackupRestoreBigDataTest.deleteDir-Deleted directory: " + aDir.getAbsolutePath());
            ++deletedCnt;
        } else {
            logWriter.fine("BackupRestoreBigDataTest.deleteDir-About to delete aDir.canWrite()=" + aDir.canWrite());
            deleteExceptions.add("Could not delete directory: " + aDir.getAbsolutePath());
        }
        if (deleteExceptions.size() > 0) {
            throw new TestException("BackupRestoreBigDataTest.deleteDir-Could not delete the following directories / files: " + ((Object)deleteExceptions).toString());
        }
        return deletedCnt;
    }

    private static void performRestoreOfBackup() {
        File latestBackupDir;
        String restoreFile = RESTORE_LINUX;
        if (HostHelper.isWindows()) {
            restoreFile = RESTORE_WINDOWS;
        }
        if ((latestBackupDir = sql.backupAndRestore.BackupRestoreBigDataTest.findLatestBackupDir()) == null) {
            throw new TestException("Expecting the test directory to contain at least 1 backup directory, but none were found.");
        }
        block3: for (File hostVMDir : latestBackupDir.listFiles()) {
            logWriter.fine("BackupRestoreBigDataTest.performRestoreOfBackup-hostVMDir.getName()=" + hostVMDir.getName());
            if (hostVMDir.getName().contains("locator")) continue;
            for (File aFile : hostVMDir.listFiles()) {
                logWriter.fine("BackupRestoreBigDataTest.performRestoreOfBackup-aFile.getName()=" + aFile.getName());
                if (!aFile.getName().equals(restoreFile)) continue;
                try {
                    String command = aFile.getCanonicalPath();
                    logWriter.info("BackupRestoreBigDataTest.performRestoreOfBackup-Running restore scripts, command=" + command);
                    String cmdResult = ProcessMgr.fgexec((String)command, (int)5000);
                    logWriter.info("BackupRestoreBigDataTest.performRestoreOfBackup-Restore script executed successfully. cmdResult=" + cmdResult);
                    continue block3;
                }
                catch (HydraRuntimeException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new TestException(TestHelper.getStackTrace((Throwable)e));
                }
            }
        }
    }

    private static File findLatestBackupDir() {
        File backupDir = null;
        long lastBackupNbr = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.BackupCtr);
        logWriter.info("BackupRestoreBigDataTest.findLatestBackupDir-lastBackupNbr=" + lastBackupNbr);
        File rootBackupDir = new File(BackupAndRestorePrms.getBackupPath());
        logWriter.info("BackupRestoreBigDataTest.findLatestBackupDir-rootBackupDir=" + rootBackupDir);
        for (File aDir : rootBackupDir.listFiles()) {
            if (!aDir.getName().equalsIgnoreCase(BACKUP_PREFIX + lastBackupNbr)) continue;
            File[] backupContents = aDir.listFiles();
            if (backupContents == null || backupContents.length != 1) {
                throw new TestException("Expecting backup directory to contain 1 directory, but it " + (backupContents == null ? "is null." : "contains " + backupContents.length));
            }
            backupDir = backupContents[0];
            break;
        }
        logWriter.info("BackupRestoreBigDataTest.findLatestBackupDir-Backup dir is " + backupDir);
        return backupDir;
    }

    public static void HydraTask_testDataReport() {
        SharedCounters sharedCounters = BackupAndRestoreBB.getBB().getSharedCounters();
        long totalBytes = sharedCounters.read(BackupAndRestoreBB.totalDataBytes);
        float totalMB = (float)totalBytes / 1048576.0f;
        float totalGB = (float)totalBytes / 1.0737418E9f;
        long backupCtr = sharedCounters.read(BackupAndRestoreBB.BackupCtr);
        long largestKey = sharedCounters.read(BackupAndRestoreBB.largestKey);
        int nbrTables = BackupAndRestorePrms.getNbrTables();
        long nbrOfUpdates = sharedCounters.read(BackupAndRestoreBB.nbrOfUpdates) / (long)nbrTables;
        long nbrOfDeletes = sharedCounters.read(BackupAndRestoreBB.nbrOfDeletes) / (long)nbrTables;
        String lobInfo = "";
        int nbrLobColumns = BackupAndRestorePrms.getNbrLobColumns();
        if (nbrLobColumns > 0) {
            String lobDataType = BackupAndRestorePrms.getLobColumnType();
            lobInfo = "\n  - Spread among these tables are " + nbrLobColumns + " " + lobDataType + " column(s) of size(s): ";
            String clobSizes = "";
            List tableList = (List)BackupAndRestoreBB.getBB().getSharedMap().get(KEY_TABLES);
            for (TableDefinition table : tableList) {
                int nbrColumns = table.getNumColumns();
                for (int colNbr = 0; colNbr < nbrColumns; ++colNbr) {
                    String dataType = table.getColumnType(colNbr);
                    if (!DATA_TYPE_CLOB.equalsIgnoreCase(dataType)) continue;
                    if (clobSizes.length() > 0) {
                        clobSizes = clobSizes + ", ";
                    }
                    clobSizes = clobSizes + table.getColumnLength(colNbr);
                }
            }
            lobInfo = lobInfo + clobSizes + ".";
        }
        StringBuilder infoSB = new StringBuilder("BackupRestoreBigDataTest.HydraTask_testDataReport-We are done with the test.");
        infoSB.append(" Here are the results:\n  - We generated ").append(totalMB).append(" MB of data (").append(totalGB).append(" GB)\n  - We performed ").append(backupCtr).append(" backups.\n  - We inserted ").append(largestKey).append(" rows into ").append(nbrTables).append(" tables (").append(largestKey * (long)nbrTables).append(" total rows among all tables).").append(lobInfo).append("\n  - On those rows we performed ").append(nbrOfUpdates).append(" updates and ").append(nbrOfDeletes).append(" deletes.");
        long start = (Long)BackupAndRestoreBB.getBB().getSharedMap().get((Object)(KEY_TIMINGS + "-dataInitialization-Start"));
        long stop = (Long)BackupAndRestoreBB.getBB().getSharedMap().get((Object)(KEY_TIMINGS + "-dataInitialization-Stop"));
        long duration = stop - start;
        infoSB.append("\n  - The Data Initialization task took ").append(sql.backupAndRestore.BackupRestoreBigDataTest.reportTimeDuration(duration)).append(" for ~").append(BackupAndRestorePrms.getInitialDataMB()).append(" MB of data.");
        start = (Long)BackupAndRestoreBB.getBB().getSharedMap().get((Object)(KEY_TIMINGS + "-randomOps-Start"));
        stop = (Long)BackupAndRestoreBB.getBB().getSharedMap().get((Object)(KEY_TIMINGS + "-randomOps-Stop"));
        duration = stop - start;
        infoSB.append("\n  -   The Random Operations task took ").append(sql.backupAndRestore.BackupRestoreBigDataTest.reportTimeDuration(duration)).append(" for ~").append(BackupAndRestorePrms.getDesiredDataOpsMB()).append(" MB of data.");
        start = (Long)BackupAndRestoreBB.getBB().getSharedMap().get((Object)(KEY_TIMINGS + "-dataRestoration-Start"));
        stop = (Long)BackupAndRestoreBB.getBB().getSharedMap().get((Object)(KEY_TIMINGS + "-dataRestoration-Stop"));
        duration = stop - start;
        infoSB.append("\n  -    The Data Restoration task took ").append(sql.backupAndRestore.BackupRestoreBigDataTest.reportTimeDuration(duration)).append(".");
        start = (Long)BackupAndRestoreBB.getBB().getSharedMap().get((Object)(KEY_TIMINGS + "-restartGemFireXD-Start"));
        stop = (Long)BackupAndRestoreBB.getBB().getSharedMap().get((Object)(KEY_TIMINGS + "-restartGemFireXD-Stop"));
        duration = stop - start;
        infoSB.append("\n  -   The Restart GemFireXD task took ").append(sql.backupAndRestore.BackupRestoreBigDataTest.reportTimeDuration(duration)).append(".");
        start = (Long)BackupAndRestoreBB.getBB().getSharedMap().get((Object)(KEY_TIMINGS + "-dataValidation-Start"));
        stop = (Long)BackupAndRestoreBB.getBB().getSharedMap().get((Object)(KEY_TIMINGS + "-dataValidation-Stop"));
        duration = stop - start;
        long validateCnt = sharedCounters.read(BackupAndRestoreBB.validateCnt);
        infoSB.append("\n  -     The Data Validation task took ").append(sql.backupAndRestore.BackupRestoreBigDataTest.reportTimeDuration(duration)).append(" on ").append(validateCnt).append(" rows.");
        long validationErrorCnt = sharedCounters.read(BackupAndRestoreBB.validationErrorCnt);
        infoSB.append("\n  - During validation, we found ").append(validationErrorCnt).append(" errors.");
        int maxValidationErrors = BackupAndRestorePrms.getMaxValidationErrors();
        if (maxValidationErrors > 0 && validationErrorCnt > 0L) {
            infoSB.append("\n  - Even though we found errors, we were asked to stop validating at ").append(maxValidationErrors).append(" errors.");
        }
        Log.getLogWriter().info(infoSB.toString());
        StringBuilder errorSB = new StringBuilder();
        for (Map.Entry e : BackupAndRestoreBB.getBB().getSharedMap().getMap().entrySet()) {
            Map.Entry entry = e;
            String key = (String)entry.getKey();
            if (!key.startsWith(KEY_VALIDATION_ERRORS)) continue;
            errorSB.append((CharSequence)((StringBuilder)BackupAndRestoreBB.getBB().getSharedMap().get((Object)key)));
        }
        if (errorSB.length() != 0) {
            throw new TestException("Error(s)!\n" + errorSB.toString());
        }
    }

    private static String reportTimeDuration(long timeDuration) {
        long elapsedSeconds;
        long elapsedMinutes;
        Log.getLogWriter().info("BackupRestoreBigDataTest=reportTimeDuration-timeDuration=" + timeDuration);
        long elapsedHours = TimeUnit.NANOSECONDS.toHours(timeDuration);
        if (elapsedHours > 0L) {
            timeDuration -= TimeUnit.HOURS.toNanos(elapsedHours);
        }
        if ((elapsedMinutes = TimeUnit.NANOSECONDS.toMinutes(timeDuration)) > 0L) {
            timeDuration -= TimeUnit.MINUTES.toNanos(elapsedMinutes);
        }
        if ((elapsedSeconds = TimeUnit.NANOSECONDS.toSeconds(timeDuration)) > 0L) {
            timeDuration -= TimeUnit.SECONDS.toNanos(elapsedSeconds);
        }
        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(timeDuration);
        return String.format("%02d:%02d:%02d.%d", elapsedHours, elapsedMinutes, elapsedSeconds, elapsedMillis);
    }

    static {
        KEY_TABLES = "tables";
        KEY_TIMINGS = "timings";
        KEY_TABLE_ROW_COUNTS = "tableRowCounts";
        FILE_SEPARATOR = System.getProperty("file.separator");
        threadLocal_clientThreadIsPaused = new HydraThreadLocal();
        threadLocal_gfxdConnection = new HydraThreadLocal();
        threadLocal_deletePreparedStatements = new HydraThreadLocal();
        threadLocal_insertPreparedStatements = new HydraThreadLocal();
        threadLocal_updatePreparedStatements = new HydraThreadLocal();
        threadLocal_isClientLeader = new HydraThreadLocal();
        threadLocal_opTracker = new HydraThreadLocal();
    }
}

