/*
 * Decompiled with CFR 0.152.
 */
package sql.backupAndRestore;

import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.ClientDescription;
import hydra.ClientVmInfo;
import hydra.DistributedSystemHelper;
import hydra.FileUtil;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.gemfirexd.FabricServerHelper;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import sql.SQLHelper;
import sql.SQLThinClientTest;
import sql.backupAndRestore.BackupAndRestoreBB;
import sql.backupAndRestore.BackupAndRestorePrms;
import sql.view.ViewTest;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class BackupRestoreTest
extends ViewTest {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String DISK_DIR_SUFFIX = "_disk";
    private static final String RESTORE_LINUX = "restore.sh";
    private static final String RESTORE_WINDOWS = "restore.bat";
    private static final String BACKUP_PREFIX = "backup_";
    private static final String BASELINE_OPT = "-baseline=";
    private static final String INCREMENTAL_TEXT = "Incremental backup.  Restore baseline originals from previous backups.";
    private static BackupRestoreTest backupRestoreTest;
    public static final String DSPROP = "dsProperties";
    private static HydraThreadLocal threadIsPaused;
    private String backupDirPath;

    public void initializeInstance() {
        this.backupDirPath = BackupAndRestorePrms.getBackupPath();
        Log.getLogWriter().info("BackupRestoreTest.initializeInstance-backupDirPath=" + this.backupDirPath);
    }

    private static Properties getdsProp() {
        Properties dsProp = null;
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        if (ds != null) {
            dsProp = ds.getProperties();
        } else {
            dsProp = (Properties)BackupAndRestoreBB.getBB().getSharedMap().get((Object)DSPROP);
            if (dsProp == null) {
                throw new TestException("Test issue, need to set up ds properties in BackupAndRestoreBB for thin client node");
            }
        }
        return dsProp;
    }

    public static void HydraTask_createIndexs() {
        if (backupRestoreTest == null) {
            backupRestoreTest = new BackupRestoreTest();
            backupRestoreTest.initializeInstance();
        }
        backupRestoreTest.createIndexs();
    }

    private void createIndexs() {
        Connection gConn = this.getGFEConnection();
        try {
            Statement s = gConn.createStatement();
            s.execute("CREATE INDEX securitiesIdx ON trade.securities (price ASC)");
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to create indexes\n" + TestHelper.getStackTrace((Throwable)se));
        }
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    public static void HydraTask_doOnlineBackup() {
        boolean contWithBackup = false;
        if (BackupAndRestorePrms.getDoBackup()) {
            boolean bl = contWithBackup = BackupAndRestoreBB.getBB().getSharedCounters().incrementAndRead(BackupAndRestoreBB.BackupInProgress) == 1L;
        }
        if (contWithBackup) {
            if (backupRestoreTest == null) {
                backupRestoreTest = new BackupRestoreTest();
                backupRestoreTest.initializeInstance();
            }
            backupRestoreTest.triggerFullOnlineBackup();
        }
    }

    public static void HydraTask_backupLeader() {
        if (backupRestoreTest == null) {
            backupRestoreTest = new BackupRestoreTest();
            backupRestoreTest.initializeInstance();
        }
        if (BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.NbrOfClientThreads) == 0L) {
            int nbrOfClientThreads = TestConfig.getInstance().getThreadGroup("clientThreads").getTotalThreads();
            Log.getLogWriter().info("BackupRestoreTest.HydraTask_initOpsBackupAndStopVM-nbrOfClientThreads=" + nbrOfClientThreads);
            BackupAndRestoreBB.getBB().getSharedCounters().add(BackupAndRestoreBB.NbrOfClientThreads, (long)nbrOfClientThreads);
        }
        backupRestoreTest.backupLeader();
    }

    private void backupLeader() {
        Log.getLogWriter().info("BackupRestoreTest.backupLeader");
        BackupRestoreTest.logExecutionNumber();
        boolean restartDuringTest = TestConfig.tab().booleanAt(BackupAndRestorePrms.restartDuringTest, false);
        boolean stopVMsDuringTest = TestConfig.tab().booleanAt(BackupAndRestorePrms.stopVmsDuringTest, false);
        Log.getLogWriter().info("BackupRestoreTest.backupLeader-restartDuringTest=" + restartDuringTest + " stopVMsDuringTest=" + stopVMsDuringTest);
        int nbrCurrentTaskThreads = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        if (nbrCurrentTaskThreads > 1) {
            throw new TestException("ERROR! This test was intended to bo 'controlled' with one thread. Please reduce the number of threads in threadgroup named:" + RemoteTestModule.getCurrentThread().getThreadGroupName());
        }
        int nbrOfAccessorThreads = (int)BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.NbrOfClientThreads);
        int totalThreads = nbrCurrentTaskThreads + nbrOfAccessorThreads;
        Log.getLogWriter().info("BackupRestoreTest.backupLeader-totalThreads=" + totalThreads);
        BackupRestoreTest.checkForLastIteration();
        int minTaskGranularitySec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        Log.getLogWriter().info("BackupRestoreTest.backupLeader-Thread is going to sleep for " + minTaskGranularitySec + " seconds to allow other vms to do random ops");
        MasterController.sleepForMs((int)(minTaskGranularitySec * 1000));
        if (!restartDuringTest && !stopVMsDuringTest) {
            BackupRestoreTest.triggerBackup();
        }
        BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.PauseOps);
        TestHelper.waitForCounter((Blackboard)BackupAndRestoreBB.getBB(), (String)"PauseOps", (int)BackupAndRestoreBB.PauseOps, (long)totalThreads, (boolean)true, (long)-1L, (long)2000L);
        backupRestoreTest.verifyResultSets();
        if (restartDuringTest) {
            BackupRestoreTest.triggerBackup();
            backupRestoreTest.stopFabricServer();
            backupRestoreTest.deleteExistingDiskDirs();
            backupRestoreTest.performRestoreOfBackup();
            backupRestoreTest.startFabricServer();
            SQLThinClientTest.HydraTask_startNetworkServer();
            backupRestoreTest.verifyResultSets();
        }
        long nbrOfVMsStoped = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.NbrOfVMsStopped);
        Log.getLogWriter().info("BackupRestoreTest.backupLeader-nbrOfVMsStoped=" + nbrOfVMsStoped);
        if (stopVMsDuringTest && nbrOfVMsStoped == 0L) {
            BackupRestoreTest.triggerBackup();
            Object[] targetVM = StopStartVMs.getOtherVMs((int)1);
            ClientVmInfo vmToStop = (ClientVmInfo)((List)targetVM[0]).get(0);
            String stopMode = (String)((List)targetVM[1]).get(0);
            Log.getLogWriter().info("BackupRestoreTest.backupLeader-about to stop vm:" + vmToStop + " via " + stopMode);
            StopStartVMs.stopVM((ClientVmInfo)vmToStop, (String)stopMode);
            BackupAndRestoreBB.getBB().getSharedMap().put((Object)"stoppedVMs", (Object)vmToStop);
            ClientDescription clientDescription = TestConfig.getInstance().getClientDescription(vmToStop.getClientName());
            int stoppedVmThreadCnt = clientDescription.getVmThreads();
            Log.getLogWriter().info("BackupRestoreTest.backupLeader-stoppedVmThreadCnt=" + stoppedVmThreadCnt);
            BackupAndRestoreBB.getBB().getSharedCounters().subtract(BackupAndRestoreBB.NbrOfClientThreads, (long)stoppedVmThreadCnt);
            BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.NbrOfVMsStopped);
        } else if (stopVMsDuringTest && nbrOfVMsStoped == 1L) {
            ClientVmInfo stoppedVM = (ClientVmInfo)BackupAndRestoreBB.getBB().getSharedMap().get((Object)"stoppedVMs");
            StopStartVMs.startVM((ClientVmInfo)stoppedVM);
            ClientDescription clientDescription = TestConfig.getInstance().getClientDescription(stoppedVM.getClientName());
            int stoppedVmThreadCnt = clientDescription.getVmThreads();
            Log.getLogWriter().info("BackupRestoreTest.backupLeader-stoppedVmThreadCnt=" + stoppedVmThreadCnt);
            BackupAndRestoreBB.getBB().getSharedCounters().add(BackupAndRestoreBB.NbrOfClientThreads, (long)stoppedVmThreadCnt);
            BackupAndRestoreBB.getBB().getSharedCounters().add(BackupAndRestoreBB.NbrOfVMsStopped, 99L);
        } else if (stopVMsDuringTest && nbrOfVMsStoped == 99L) {
            BackupRestoreTest.triggerBackup();
        }
        boolean isItTimeToStop = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.TimeToStop) >= 1L;
        Log.getLogWriter().info("BackupRestoreTest.backupLeader-isItTimeToStop=" + isItTimeToStop);
        if (isItTimeToStop) {
            throw new StopSchedulingOrder("Number of executions is " + BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.ExecutionNumber));
        }
        BackupAndRestoreBB.getBB().getSharedCounters().zero(BackupAndRestoreBB.PauseOps);
    }

    public static void HydraTask_doOpsAndWait() {
        if (backupRestoreTest == null) {
            backupRestoreTest = new BackupRestoreTest();
            backupRestoreTest.initializeInstance();
        }
        backupRestoreTest.doOpsAndWait();
    }

    private static void doOpsAndWait() {
        boolean timeToPauseOps = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.PauseOps) > 0L;
        Log.getLogWriter().info("BackupRestoreTest.doOpsAndWait-timeToPauseOps=" + timeToPauseOps);
        if (timeToPauseOps) {
            if (((Boolean)threadIsPaused.get()).booleanValue()) {
                Log.getLogWriter().info("BackupRestoreTest.doOpsAndWait-This thread is already paused");
            } else {
                Log.getLogWriter().info("BackupRestoreTest.doOpsAndWait-This thread is now paused");
                threadIsPaused.set((Object)new Boolean(true));
                BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.PauseOps);
            }
            MasterController.sleepForMs((int)5000);
        } else {
            threadIsPaused.set((Object)new Boolean(false));
            do {
                Log.getLogWriter().info("BackupRestoreTest.doOpsAndWait-Doing Ops");
                backupRestoreTest.doDMLOp();
                timeToPauseOps = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.PauseOps) > 0L;
                Log.getLogWriter().info("BackupRestoreTest.doOpsAndWait-timeToPauseOps=" + timeToPauseOps);
            } while (!timeToPauseOps);
        }
    }

    public static void HydraTask_performFinalBackup() {
        if (backupRestoreTest == null) {
            backupRestoreTest = new BackupRestoreTest();
            backupRestoreTest.initializeInstance();
        }
        backupRestoreTest.performFinalBackup();
    }

    private static void performFinalBackup() {
        boolean leaderToBackup;
        Log.getLogWriter().info("BackupRestoreTest.performFinalBackup");
        boolean bl = leaderToBackup = BackupAndRestoreBB.getBB().getSharedCounters().incrementAndRead(BackupAndRestoreBB.LeaderForFinalBackup) == 1L;
        if (leaderToBackup) {
            Log.getLogWriter().info("BackupRestoreTest.performFinalBackup-It's time to stop, but we must first perform one more backup. I'll do it!");
            BackupRestoreTest.triggerBackup();
        }
    }

    private static void logExecutionNumber() {
        long execNbr = BackupAndRestoreBB.getBB().getSharedCounters().incrementAndRead(BackupAndRestoreBB.ExecutionNumber);
        Log.getLogWriter().info("BackupRestoreTest.logExecutionNumber-Beginning task with execution number: " + execNbr);
    }

    protected static void checkForLastIteration() {
        long execNbr = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.ExecutionNumber);
        Log.getLogWriter().info("BackupRestoreTest.checkForLastIteration-execNbr=" + execNbr + ", BackupAndRestorePrms.getNbrOfExecutions()=" + BackupAndRestorePrms.getNbrOfExecutions());
        if (execNbr >= (long)BackupAndRestorePrms.getNbrOfExecutions()) {
            Log.getLogWriter().info("BackupRestoreTest.checkForLastIteration-This is the last iteration of this task, execNbr=" + execNbr);
            BackupAndRestoreBB.getBB().getSharedCounters().increment(BackupAndRestoreBB.TimeToStop);
        }
    }

    public static void doBackup() {
        if (backupRestoreTest == null) {
            backupRestoreTest = new BackupRestoreTest();
            backupRestoreTest.initializeInstance();
        }
        BackupRestoreTest.triggerBackup();
    }

    private static void triggerBackup() {
        boolean doBackup = BackupAndRestorePrms.getDoBackup();
        Log.getLogWriter().info("BackupRestoreTest.triggerBackup-doBackup=" + doBackup);
        if (doBackup) {
            boolean incrementalBackups = BackupAndRestorePrms.getIncrementalBackups();
            Log.getLogWriter().info("BackupRestoreTest.triggerBackup-incrementalBackups=" + incrementalBackups);
            long BackupCntr = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.BackupCtr);
            Log.getLogWriter().info("BackupRestoreTest.triggerBackup-BackupCntr=" + BackupCntr);
            if (incrementalBackups && BackupCntr > 0L) {
                backupRestoreTest.triggerIncrementalOnlineBackup();
            } else {
                backupRestoreTest.triggerFullOnlineBackup();
            }
        }
    }

    private static void triggerFullOnlineBackup() {
        BackupRestoreTest.performOnlineBackup(false);
    }

    private static void triggerIncrementalOnlineBackup() {
        BackupRestoreTest.performOnlineBackup(true);
    }

    private static void performOnlineBackup(boolean incremental) {
        Log.getLogWriter().info("BackupRestoreTest.doOnlineBackup-incremental=" + incremental);
        File rootBackupDir = new File(BackupRestoreTest.backupRestoreTest.backupDirPath);
        Log.getLogWriter().info("BackupRestoreTest.doOnlineBackup-rootBackupDir=" + rootBackupDir);
        long backupCntr = BackupAndRestoreBB.getBB().getSharedCounters().incrementAndRead(BackupAndRestoreBB.BackupCtr);
        Log.getLogWriter().info("BackupRestoreTest.doOnlineBackup-backupCntr=" + backupCntr);
        String incrementalClause = "";
        if (incremental) {
            String baselineDir = rootBackupDir + FILE_SEPARATOR + BACKUP_PREFIX + (backupCntr - 1L);
            Log.getLogWriter().info("BackupRestoreTest.doOnlineBackup-baselineDir1=" + baselineDir);
            File[] baselineDirContents = new File(baselineDir).listFiles();
            if (baselineDirContents.length != 1) {
                throw new TestException("BackupRestoreTest.doOnlineBackup-On line backup cannot continue because we were expecting 1 subdirectory in the '" + baselineDir + "' directory, but found " + baselineDirContents.length);
            }
            File backupDateDir = baselineDirContents[0];
            Log.getLogWriter().info("BackupRestoreTest.doOnlineBackup-backupDateDir.getName()=" + backupDateDir.getName());
            baselineDir = baselineDir + FILE_SEPARATOR + backupDateDir.getName();
            Log.getLogWriter().info("BackupRestoreTest.doOnlineBackup-baselineDir2=" + baselineDir);
            incrementalClause = BASELINE_OPT + baselineDir + " ";
        }
        Log.getLogWriter().info("BackupRestoreTest.doOnlineBackup-incrementalClause=" + incrementalClause);
        String gfxdCommand = FabricServerHelper.getGFXDCommand();
        Properties properties = BackupRestoreTest.getdsProp();
        String backupDir = rootBackupDir + FILE_SEPARATOR + BACKUP_PREFIX + backupCntr;
        Log.getLogWriter().info("BackupRestoreTest.doOnlineBackup-backupDir=" + backupDir);
        String backupCmd = gfxdCommand + " backup " + incrementalClause + backupDir + " -locators=" + properties.get("locators");
        Log.getLogWriter().info("BackupRestoreTest.doOnlineBackup-backupCmd=" + backupCmd);
        String backupResult = null;
        try {
            backupResult = ProcessMgr.fgexec((String)backupCmd, (int)0);
        }
        catch (HydraRuntimeException e) {
            e.printStackTrace();
            Log.getLogWriter().info("BackupRestoreTest.doOnlineBackup-Backup Failed: e.getCause()=" + e.getCause());
            Log.getLogWriter().info("BackupRestoreTest.doOnlineBackup-Backup Failed: e.getMessage()=" + e.getMessage());
        }
        Log.getLogWriter().info("BackupRestoreTest.doOnlineBackup-Done calling online backup tool, backupResult is " + backupResult);
        if (backupResult == null || backupResult.indexOf("Backup successful") < 0) {
            throw new TestException("BackupRestoreTest.doOnlineBackup-On line backup was not successful, backupResult from online backup is " + backupResult);
        }
    }

    public static void HydraTask_snapShotDiskDirContents() {
        if (backupRestoreTest == null) {
            backupRestoreTest = new BackupRestoreTest();
            backupRestoreTest.initializeInstance();
        }
        backupRestoreTest.snapShotDiskDirContents();
    }

    private static void snapShotDiskDirContents() {
        String lastFileName = "_" + (BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.BackupCtr) + 1L);
        Log.getLogWriter().info("BackupRestoreTest.snapShotDiskDirContents-lastFileName=" + lastFileName);
        List diskDirSnapShot = BackupRestoreTest.diskDirContents(System.getProperty("user.dir"), lastFileName);
        Log.getLogWriter().info("BackupRestoreTest.snapShotDiskDirContents-diskDirSnapShot.size()=" + diskDirSnapShot.size());
        BackupAndRestoreBB.getBB().getSharedMap().put((Object)"diskDirSnapShot", (Object)diskDirSnapShot);
    }

    public static void HydraTask_verifyDiskDirContents() {
        if (backupRestoreTest == null) {
            backupRestoreTest = new BackupRestoreTest();
            backupRestoreTest.initializeInstance();
        }
        backupRestoreTest.verifyDiskDirContents();
    }

    private static void verifyDiskDirContents() {
        String lastFileName = "_" + BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.BackupCtr);
        Log.getLogWriter().info("BackupRestoreTest.verifyDiskDirContents-lastFileName=" + lastFileName);
        List diskDirNow = BackupRestoreTest.diskDirContents(System.getProperty("user.dir"), lastFileName);
        Log.getLogWriter().info("BackupRestoreTest.verifyDiskDirContents-diskDirNow.size()=" + diskDirNow.size());
        List diskDirSnapShot = (List)BackupAndRestoreBB.getBB().getSharedMap().get((Object)"diskDirSnapShot");
        Log.getLogWriter().info("BackupRestoreTest.verifyDiskDirContents-diskDirSnapShot.size()=" + diskDirSnapShot.size());
        boolean error = false;
        String errorString = "";
        ArrayList missingFiles = new ArrayList();
        missingFiles.addAll(diskDirSnapShot);
        missingFiles.removeAll(diskDirNow);
        if (missingFiles.size() > 0) {
            error = true;
            errorString = "The following files were missing after the restore:\n" + missingFiles + "\n";
        }
        ArrayList extraFiles = new ArrayList();
        extraFiles.addAll(diskDirNow);
        extraFiles.removeAll(diskDirSnapShot);
        if (extraFiles.size() > 0) {
            error = true;
            errorString = errorString + "The following unexpected files were found after the restore:\n" + extraFiles + "\n";
        }
        if (error) {
            throw new TestException(errorString);
        }
        Log.getLogWriter().info("erifyDiskDirContents-No missing or extra files found.");
    }

    private static List diskDirContents(String testDirName, String lastFileName) {
        Log.getLogWriter().info("BackupRestoreTest.diskDirContents-testDirName=" + testDirName + ", lastFileName=" + lastFileName);
        ArrayList<String> allDiskDirContents = new ArrayList<String>();
        for (File aTestFile : new File(testDirName).listFiles()) {
            String diskDirName;
            if (!aTestFile.isDirectory() || !aTestFile.getName().endsWith(DISK_DIR_SUFFIX) || !(diskDirName = aTestFile.getName()).contains("datastore")) continue;
            for (File aDiskDirFile : aTestFile.listFiles()) {
                if (aDiskDirFile.isDirectory() && aDiskDirFile.getName().equals("datadictionary")) {
                    String dataDictDirName = aDiskDirFile.getName();
                    for (File aDataDictFile : aDiskDirFile.listFiles()) {
                        String dataDictFileName = aDataDictFile.getName();
                        if (dataDictFileName.endsWith(".lk") || dataDictFileName.endsWith(".d") || lastFileName != null && dataDictFileName.contains(lastFileName)) continue;
                        allDiskDirContents.add(diskDirName + FILE_SEPARATOR + dataDictDirName + FILE_SEPARATOR + dataDictFileName + "-" + aDataDictFile.length());
                    }
                    continue;
                }
                String diskFileName = aDiskDirFile.getName();
                if (diskFileName.endsWith(".lk") || diskFileName.endsWith(".d") || lastFileName != null && diskFileName.contains(lastFileName)) continue;
                allDiskDirContents.add(diskDirName + FILE_SEPARATOR + diskFileName + "-" + aDiskDirFile.length());
            }
        }
        return allDiskDirContents;
    }

    public static void HydraTask_doRestoreBackup() {
        boolean contWithRestore = false;
        if (BackupAndRestorePrms.getDoBackup()) {
            long counter = BackupAndRestoreBB.getBB().getSharedCounters().incrementAndRead(BackupAndRestoreBB.RestoreThreadCnt);
            boolean bl = contWithRestore = counter == 1L;
        }
        if (contWithRestore) {
            if (backupRestoreTest == null) {
                backupRestoreTest = new BackupRestoreTest();
                backupRestoreTest.initializeInstance();
            }
            backupRestoreTest.deleteExistingDiskDirs();
            backupRestoreTest.performRestoreOfBackup();
            BackupAndRestoreBB.getBB().getSharedCounters().zero(BackupAndRestoreBB.RestoreThreadCnt);
        }
    }

    private void performRestoreOfBackup() {
        File latestBackupDir;
        String restoreFile = RESTORE_LINUX;
        if (HostHelper.isWindows()) {
            restoreFile = RESTORE_WINDOWS;
        }
        if ((latestBackupDir = this.findLatestBackupDir()) == null) {
            throw new TestException("Expecting the test directory to contain at least 1 backup directory, but none were found.");
        }
        block3: for (File hostVMDir : latestBackupDir.listFiles()) {
            Log.getLogWriter().info("BackupRestoreTest.performRestoreOfBackup-hostVMDir.getName()=" + hostVMDir.getName());
            if (hostVMDir.getName().contains("locator")) continue;
            for (File aFile : hostVMDir.listFiles()) {
                Log.getLogWriter().info("BackupRestoreTest.performRestoreOfBackup-aFile.getName()=" + aFile.getName());
                if (!aFile.getName().equals(restoreFile)) continue;
                try {
                    String command = aFile.getCanonicalPath();
                    Log.getLogWriter().info("BackupRestoreTest.performRestoreOfBackup-Running restore scripts, command=" + command);
                    String cmdResult = ProcessMgr.fgexec((String)command, (int)5000);
                    Log.getLogWriter().info("BackupRestoreTest.performRestoreOfBackup-Restore script executed successfully. cmdResult=" + cmdResult);
                    continue block3;
                }
                catch (HydraRuntimeException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new TestException(TestHelper.getStackTrace((Throwable)e));
                }
            }
        }
    }

    private void deleteExistingDiskDirs() {
        File[] contents;
        String currDirName = System.getProperty("user.dir");
        Log.getLogWriter().info("BackupRestoreTest.deleteExistingDiskDirs-currDirName=" + currDirName);
        ArrayList<String> dirsToDelete = new ArrayList<String>();
        File currDir = new File(currDirName);
        for (File aDir : contents = currDir.listFiles()) {
            String dirName = aDir.getName();
            if (!aDir.isDirectory() || !dirName.endsWith(DISK_DIR_SUFFIX) || dirName.contains("locator")) continue;
            Log.getLogWriter().info("BackupRestoreTest.deleteExistingDiskDirs-aDir.getName()=" + dirName);
            dirsToDelete.add(dirName);
        }
        for (String dirToDelete : dirsToDelete) {
            int deletedCnt = this.deleteDir(new File(dirToDelete));
            Log.getLogWriter().info("BackupRestoreTest.deleteExistingDiskDirs-dirToDelete=" + dirToDelete + " deletedCnt=" + deletedCnt);
        }
    }

    private int deleteDir(File aDir) {
        File[] contents;
        int deletedCnt = 0;
        ArrayList<String> deleteExceptions = new ArrayList<String>();
        for (File aFile : contents = aDir.listFiles()) {
            if (aFile.isDirectory()) {
                deletedCnt += this.deleteDir(aFile);
                continue;
            }
            if (aFile.delete()) {
                Log.getLogWriter().info("BackupRestoreTest.deleteDir-Deleted file: " + aFile.getAbsolutePath());
                ++deletedCnt;
                continue;
            }
            deleteExceptions.add("Could not delete file: " + aFile.getAbsolutePath());
        }
        if (aDir.delete()) {
            Log.getLogWriter().info("BackupRestoreTest.deleteDir-Deleted directory: " + aDir.getAbsolutePath());
            ++deletedCnt;
        } else {
            Log.getLogWriter().info("BackupRestoreTest.deleteDir-About to delete aDir.canWrite()=" + aDir.canWrite());
            deleteExceptions.add("Could not delete directory: " + aDir.getAbsolutePath());
        }
        if (deleteExceptions.size() > 0) {
            throw new TestException("BackupRestoreTest.deleteDir-Could not delete the following direcories / files: " + ((Object)deleteExceptions).toString());
        }
        return deletedCnt;
    }

    public static void HydraTask_verifyIncrementalBackupPerformed() {
        if (backupRestoreTest == null) {
            backupRestoreTest = new BackupRestoreTest();
            backupRestoreTest.initializeInstance();
        }
        backupRestoreTest.verifyIncrementalBackupPerformed();
    }

    private void verifyIncrementalBackupPerformed() {
        Log.getLogWriter().info("BackupRestoreTest.verifyIncrementalBackupPerformed");
        String restoreFile = RESTORE_LINUX;
        if (HostHelper.isWindows()) {
            restoreFile = RESTORE_WINDOWS;
        }
        boolean doBackup = BackupAndRestorePrms.getDoBackup();
        Log.getLogWriter().info("BackupRestoreTest.verifyIncrementalBackupPerformed-doBackup=" + doBackup);
        if (doBackup) {
            boolean incrementalBackups = BackupAndRestorePrms.getIncrementalBackups();
            Log.getLogWriter().info("BackupRestoreTest.verifyIncrementalBackupPerformed-incrementalBackups=" + incrementalBackups);
            long BackupCntr = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.BackupCtr);
            Log.getLogWriter().info("BackupRestoreTest.verifyIncrementalBackupPerformed-BackupCntr=" + BackupCntr);
            if (incrementalBackups && BackupCntr > 1L) {
                File latestBackupDir = this.findLatestBackupDir();
                if (latestBackupDir == null) {
                    throw new TestException("Expecting the test directory to contain at least 1 backup directory, but none were found.");
                }
                block2: for (File hostVMDir : latestBackupDir.listFiles()) {
                    for (File aFile : hostVMDir.listFiles()) {
                        if (!aFile.getName().equals(restoreFile)) continue;
                        try {
                            String restoreScriptFullFilename = aFile.getCanonicalPath();
                            boolean isBackupIncremental = FileUtil.hasLinesContaining((String)restoreScriptFullFilename, (String)INCREMENTAL_TEXT);
                            Log.getLogWriter().info("BackupRestoreTest.verifyIncrementalBackupPerformed-isBackupIncremental=" + isBackupIncremental);
                            if (!isBackupIncremental) {
                                throw new TestException("Expecting the restore script to be of type incremental, but it wasn't.");
                            }
                            continue block2;
                        }
                        catch (IOException e) {
                            throw new TestException(TestHelper.getStackTrace((Throwable)e));
                        }
                    }
                }
            }
        }
    }

    private File findLatestBackupDir() {
        File backupDir = null;
        long lastBackupNbr = BackupAndRestoreBB.getBB().getSharedCounters().read(BackupAndRestoreBB.BackupCtr);
        Log.getLogWriter().info("BackupRestoreTest.findLatestBackupDir-lastBackupNbr=" + lastBackupNbr);
        File rootBackupDir = new File(this.backupDirPath);
        Log.getLogWriter().info("BackupRestoreTest.findBackupDir-rootBackupDir=" + rootBackupDir);
        for (File aDir : rootBackupDir.listFiles()) {
            if (!aDir.getName().equalsIgnoreCase(BACKUP_PREFIX + lastBackupNbr)) continue;
            File[] backupContents = aDir.listFiles();
            if (backupContents.length != 1) {
                throw new TestException("Expecting backup directory to contain 1 directory, but it contains " + backupContents.length);
            }
            backupDir = backupContents[0];
            break;
        }
        Log.getLogWriter().info("BackupRestoreTest.findLatestBackupDir-Backup dir is " + backupDir);
        return backupDir;
    }

    public static void HydraTask_checkDataStoreBytesInUse() {
        backupRestoreTest.checkDataStoreBytesInUse();
    }

    private static void checkDataStoreBytesInUse() {
        String archiveName = BackupAndRestorePrms.getArchiveName();
        Log.getLogWriter().info("BackupRestoreTest.checkDataStoreBytesInUse-archiveName=" + archiveName);
        String spec = "*" + archiveName + "* " + "PartitionedRegionStats " + "* " + "dataStoreBytesInUse " + "filter" + "=" + "none" + " " + "combine" + "=" + "combineAcrossArchives" + " " + "ops" + "=" + "max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("BackupRestoreTest.checkDataStoreBytesInUse-No Stats Found for spec:" + spec);
        } else {
            Log.getLogWriter().info("BackupRestoreTest.checkDataStoreBytesInUse-Getting Stats for spec:" + spec);
            double dataStoreBytesInUse = 0.0;
            for (int i = 0; i < aList.size(); ++i) {
                PerfStatValue stat = (PerfStatValue)aList.get(i);
                double statMax = stat.getMax();
                Log.getLogWriter().info("BackupRestoreTest.checkDataStoreBytesInUse-statMax=" + statMax);
                dataStoreBytesInUse += statMax;
            }
            Log.getLogWriter().info("BackupRestoreTest.checkDataStoreBytesInUse-dataStoreBytesInUse=" + dataStoreBytesInUse);
            Log.getLogWriter().info("BackupRestoreTest.checkDataStoreBytesInUse-dataStoreBytesInUse(MB)=" + dataStoreBytesInUse / 1048576.0);
        }
    }

    static {
        threadIsPaused = new HydraThreadLocal();
    }
}

