/*
 * Decompiled with CFR 0.152.
 */
package sql.backupAndRestore;

import hydra.GsRandom;
import hydra.Log;
import hydra.TestConfig;
import java.io.Serializable;
import sql.backupAndRestore.BackupAndRestoreBB;

public class OpTracker
implements Serializable {
    public static final int OP_TYPE_INSERT = -1;
    public static final int OP_TYPE_UPDATE = 1;
    public static final int OP_TYPE_DELETE = 2;
    private int opTrackerKey = new Long(BackupAndRestoreBB.getBB().getSharedCounters().incrementAndRead(BackupAndRestoreBB.opTrackerCnt)).intValue();
    private int opType = (this.opTrackerKey & 1) == 1 ? 1 : 2;
    private int startKey = -1;
    private int endKey = -1;
    private int endValKey = -1;
    private int nbrOfThreads = 0;
    private int maxEndKey = 0;
    private int nbrAvailKeys = 0;
    private int myMaxKey = 0;
    private int returnedCount = 0;
    private int returnedValCount = 0;

    public OpTracker(int maxEndKeyArg, int nbrOfThreadsArg) {
        this.maxEndKey = maxEndKeyArg;
        this.nbrOfThreads = nbrOfThreadsArg;
        this.returnedCount = 0;
        this.calcNbrAvailKeys();
        this.calcMyMaxKey();
        GsRandom rand = TestConfig.tab().getRandGen();
        int reducedNbrAvailKeys = this.nbrAvailKeys / 2;
        this.startKey = rand.nextInt(0, reducedNbrAvailKeys - 1) * this.nbrOfThreads + this.opTrackerKey;
        Log.getLogWriter().info("OpTracker-Created a new OpTracker:" + this.toString());
    }

    public void rebaseAt(int maxEndKeyArg) {
        Log.getLogWriter().fine("OpTracker.rebaseAt-opTrackerKey=" + this.opTrackerKey + ", maxEndKey=" + this.maxEndKey + ", maxEndKeyArg=" + maxEndKeyArg);
        this.maxEndKey = maxEndKeyArg;
        this.calcNbrAvailKeys();
        this.calcMyMaxKey();
    }

    private void calcNbrAvailKeys() {
        Log.getLogWriter().fine("OpTracker.calcNbrAvailKeys-opTrackerKey=" + this.opTrackerKey + ", nbrAvailKeys(Before)=" + this.nbrAvailKeys);
        int quotient = this.maxEndKey / this.nbrOfThreads;
        int remainder = this.maxEndKey % this.nbrOfThreads;
        this.nbrAvailKeys = quotient;
        if (this.opTrackerKey <= remainder) {
            ++this.nbrAvailKeys;
        }
        Log.getLogWriter().fine("OpTracker.calcNbrAvailKeys-opTrackerKey=" + this.opTrackerKey + ", nbrAvailKeys(After)=" + this.nbrAvailKeys);
    }

    private void calcMyMaxKey() {
        this.myMaxKey = (this.nbrAvailKeys - 1) * this.nbrOfThreads + this.opTrackerKey;
        if (this.myMaxKey > this.maxEndKey) {
            this.myMaxKey -= this.nbrOfThreads;
            Log.getLogWriter().info("OpTracker.calcMyMaxKey-myMaxKey '" + this.myMaxKey + "' is > maxEndKey '" + this.maxEndKey + "', reducing it by the number of threads (" + this.nbrOfThreads + ")");
        }
    }

    public int nextKeyForOp() {
        if (this.endKey == -1) {
            this.endKey = this.startKey;
        } else {
            if (this.returnedCount == this.nbrAvailKeys) {
                return -1;
            }
            int nextKey = this.endKey + this.nbrOfThreads;
            if (nextKey > this.myMaxKey) {
                return -1;
            }
            this.endKey = nextKey;
        }
        ++this.returnedCount;
        Log.getLogWriter().fine("OpTracker.nextKeyForOp-endKey=" + this.endKey + ", returnedCount=" + this.returnedCount);
        return this.endKey;
    }

    public int nextKeyForValidation() {
        if (this.endValKey == -1) {
            this.endValKey = this.opTrackerKey;
        } else {
            if (this.returnedValCount == this.nbrAvailKeys) {
                return -1;
            }
            int nextKey = this.endValKey + this.nbrOfThreads;
            if (nextKey > this.myMaxKey) {
                return -1;
            }
            this.endValKey = nextKey;
        }
        ++this.returnedValCount;
        Log.getLogWriter().info("OpTracker.nextKeyForValidation-endValKey=" + this.endValKey + ", returnedValCount=" + this.returnedValCount);
        return this.endValKey;
    }

    public boolean isKeyTracked(int key) {
        boolean found = false;
        if (this.endKey == -1) {
            found = false;
        } else if (key == this.startKey || key == this.endKey) {
            found = true;
        } else if (key > this.startKey && key < this.endKey) {
            found = (key - this.startKey) % this.nbrOfThreads == 0;
        }
        return found;
    }

    public int getMaxEndKey() {
        return this.maxEndKey;
    }

    public int getOpType() {
        return this.opType;
    }

    public boolean isDeleteTracker() {
        return this.opType == 2;
    }

    public boolean isUpdateTracker() {
        return this.opType == 1;
    }

    public String toString() {
        return "OpTracker (opTrackerKey=" + this.opTrackerKey + ", opType=" + this.opType + ", nbrAvailKeys=" + this.nbrAvailKeys + ", startKey=" + this.startKey + ", endKey=" + this.endKey + ", endValKey=" + this.endValKey + ", myMaxKey=" + this.myMaxKey + ", maxEndKey=" + this.maxEndKey + ", returnedCount=" + this.returnedCount + ", returnedValCount=" + this.returnedValCount + ", nbrOfThreads=" + this.nbrOfThreads + ")";
    }
}

