/*
 * Decompiled with CFR 0.152.
 */
package sql.ciIndex;

import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import hydra.HydraVector;
import hydra.Log;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import sql.SQLHelper;
import sql.SQLThinClientTest;
import sql.ciIndex.CaseInsensitiveIndexPrms;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class CaseInsensitiveIndexTest
extends SQLThinClientTest {
    public static String importTableSqlTemplate = "call syscs_util.import_table_ex('T', 'TABLE_DATA', '%DataFilePath%', ',',NULL,NULL,0,0,6,0,NULL,NULL)";
    public static CaseInsensitiveIndexTest ciIndexTest = new CaseInsensitiveIndexTest();

    public static void HydraTask_createGfxdObjectsByClients() {
        ciIndexTest.createGfxdObejcts(true);
    }

    public static void HydraTask_createGfxdObjectsByPeers() {
        ciIndexTest.createGfxdObejcts(false);
    }

    public static void HydraTask_populateDataByClients() {
        ciIndexTest.populateData(true);
    }

    public static void HydraTask_populateDataByPeers() {
        ciIndexTest.populateData(false);
    }

    public static void HydraTask_queryCaseInsentiveIndexByClients() {
        ciIndexTest.queryCaseInsentiveIndex(true);
    }

    public static void HydraTask_queryCaseInsentiveIndexByPeers() {
        ciIndexTest.queryCaseInsentiveIndex(false);
    }

    protected void queryCaseInsentiveIndex(boolean gfxdclient) {
        String hintStr;
        HydraVector queryVec = CaseInsensitiveIndexPrms.getQueryStatements();
        HydraVector ciQueryVec = CaseInsensitiveIndexPrms.getCiQueryStatements();
        HydraVector comparators = CaseInsensitiveIndexPrms.getResultComparators();
        HydraVector hints = CaseInsensitiveIndexPrms.getQueryHints();
        int index = random.nextInt(queryVec.size());
        String queryStr = (String)queryVec.get(index);
        String ciQueryStr = (String)ciQueryVec.get(index);
        String string = hintStr = index < hints.size() ? (String)hints.get(index) : null;
        if (hintStr != null && !hintStr.trim().isEmpty()) {
            queryStr = this.addHint(queryStr, hintStr);
            ciQueryStr = this.addHint(ciQueryStr, hintStr);
        }
        Connection gConn = this.getGFEConnection();
        this.queryResultSets(gConn, queryStr, ciQueryStr, (String)comparators.get(index));
        this.closeGFEConnection(gConn);
    }

    protected void queryResultSets(Connection gConn, String queryStr, String ciQueryStr, String comparator) {
        try {
            Log.getLogWriter().info("Query: " + queryStr);
            Log.getLogWriter().info("CI Query: " + ciQueryStr);
            ResultSet rs = gConn.createStatement().executeQuery(queryStr);
            ResultSet ciRs = gConn.createStatement().executeQuery(ciQueryStr);
            this.compareResultSets(rs, ciRs, comparator);
            this.commit(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected String addHint(String queryStr, String hintStr) {
        String hintPrefix = " -- GEMFIREXD-PROPERTIES ";
        String hintPostfix = " \n ";
        int whereIdx = queryStr.toLowerCase().indexOf("where");
        if (whereIdx != -1) {
            String selectPart = queryStr.substring(0, whereIdx);
            String wherePart = queryStr.substring(whereIdx);
            return selectPart + " -- GEMFIREXD-PROPERTIES " + hintStr + " \n " + wherePart;
        }
        return queryStr + " -- GEMFIREXD-PROPERTIES " + hintStr + " \n ";
    }

    protected boolean compareResultSets(ResultSet rs, ResultSet ciRs, String comparator) {
        StructTypeImpl sti = ResultSetHelper.getStructType(rs);
        List<Struct> csList = ResultSetHelper.asList(rs, sti, false);
        if (csList == null) {
            return false;
        }
        Log.getLogWriter().info("ResultSet contain " + csList.size() + " rows");
        StructTypeImpl gfxdsti = ResultSetHelper.getStructType(ciRs);
        List<Struct> ciList = ResultSetHelper.asList(ciRs, gfxdsti, false);
        if (ciList == null) {
            return false;
        }
        Log.getLogWriter().info("Case insensitive query resultset contain " + ciList.size() + " rows");
        if (comparator.trim().equalsIgnoreCase("equal")) {
            ResultSetHelper.compareResultSets(csList, ciList, "query", "ciQuery");
            return true;
        }
        if (comparator.trim().equalsIgnoreCase("greater")) {
            return csList.size() > ciList.size();
        }
        if (comparator.trim().equalsIgnoreCase("less")) {
            return csList.size() < ciList.size();
        }
        if (comparator.trim().equalsIgnoreCase("zero_ciquery")) {
            if (csList.size() > 0 && ciList.size() == 0) {
                return true;
            }
            if (ciList.size() != 0) {
                throw new TestException("CI Query should return zero resultSet");
            }
            if (csList.size() <= 0) {
                throw new TestException("Query failed to return resultSet");
            }
            throw new TestException("Query failed to return resultSet and CI Query should return zero resultSet");
        }
        return false;
    }

    protected void populateData(boolean gfxdclient) {
        HydraVector dataFilePathVec = CaseInsensitiveIndexPrms.getCiIndexDataFiles();
        String fixedDatafilePath = System.getProperty("JTESTS") + "/sql/ciIndex/TABLE_DATA_fixed.dat";
        fixedDatafilePath = fixedDatafilePath.replaceAll("\\\\", "\\\\\\\\");
        dataFilePathVec.add(fixedDatafilePath);
        Connection conn = this.getGFEConnection();
        for (int i = 0; i < dataFilePathVec.size(); ++i) {
            String dataFile = (String)dataFilePathVec.get(i);
            Log.getLogWriter().info("Populating gfxd tables using data in: " + dataFile);
            String importTableSql = importTableSqlTemplate.replaceAll("%DataFilePath%", dataFile);
            try {
                SQLHelper.executeSQL(conn, importTableSql, true);
                continue;
            }
            catch (SQLException sqle) {
                Log.getLogWriter().error("Failed in populating gfxd tables using " + dataFile);
            }
        }
        Log.getLogWriter().info("done populating gfxd tables.");
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    protected void createGfxdObejcts(boolean gfxdclient) {
        Connection conn = this.getGFEConnection();
        String ciIndexDDLPath = CaseInsensitiveIndexPrms.getCiIndexDDLFilePath();
        Log.getLogWriter().info("creating gfxd objects in gfxd using sql script: " + ciIndexDDLPath);
        SQLHelper.runSQLScript(conn, ciIndexDDLPath, true);
        Log.getLogWriter().info("done creating database objects in gfxd.");
        this.commit(conn);
        this.closeGFEConnection(conn);
    }
}

