/*
 * Decompiled with CFR 0.152.
 */
package sql.dataextractor;

import com.gemstone.gemfire.internal.offheap.OffHeapMemoryStats;
import com.pivotal.gemfirexd.tools.dataextractor.GemFireXDDataExtractor;
import com.pivotal.gemfirexd.tools.dataextractor.GemFireXDDataExtractorLoader;
import hydra.ClientVmInfo;
import hydra.FileUtil;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.VmDescription;
import hydra.blackboard.SharedMap;
import hydra.gemfirexd.HDFSStorePrms;
import hydra.gemfirexd.NetworkServerBlackboard;
import hydra.gemfirexd.NetworkServerHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import memscale.OffHeapHelper;
import sql.SQLHelper;
import sql.SQLTest;
import sql.dataextractor.DataExtractorBB;
import sql.dataextractor.DataExtractorPrms;
import sql.ddlStatements.DDLStmtIF;
import util.StopStartVMs;
import util.TestException;

public class DataExtractorTest
extends SQLTest {
    static HydraVector threadGroupNames = null;
    static HydraVector clientVMsToRestart = null;
    static String[] ddlCreateTableStatements = null;
    static String[] ddlCreateTableExtensions = null;
    static int threadCount = 0;
    protected static DataExtractorTest extractorTest = null;
    static Random rand = new Random();
    List<ClientVmInfo> restartVMs = new ArrayList<ClientVmInfo>();
    String propFileAbsolutePath = null;
    static boolean performUpdatesWhileShuttingDown = true;
    static boolean simultaneousShutdownVMs = false;
    static final String RANDOM_CORRUPTION_STRING = "THIS IS RANDOM STRING TO CAUSE CORRUPTION";
    static ClientVmInfo lastStandingVmInfo = null;
    static ClientVmInfo secondLastStandingVmInfo = null;
    private static int monitorObjectsMax = 0;
    private static boolean terminateMonitorThread = false;

    public static synchronized void HydraTask_initialize() {
        if (extractorTest == null) {
            extractorTest = new DataExtractorTest();
        }
        if (threadGroupNames == null) {
            threadGroupNames = TestConfig.tab().vecAt(DataExtractorPrms.threadGroupNames);
            if (threadGroupNames == null) {
                throw new TestException("No thread groups specified for operations threads");
            }
            for (int i = 0; i < threadGroupNames.size(); ++i) {
                String threadGroupName = threadGroupNames.get(i).toString();
                Log.getLogWriter().info("Thread group name: " + threadGroupName);
                Log.getLogWriter().info("ThreadGroup:" + TestConfig.getInstance().getThreadGroup(threadGroupName));
                threadCount += TestConfig.getInstance().getThreadGroup(threadGroupName).getTotalThreads();
            }
        }
        performUpdatesWhileShuttingDown = TestConfig.tab().booleanAt(DataExtractorPrms.performUpdatesWhileShuttingDown, true);
        String clientName = RemoteTestModule.getMyClientName();
        Log.getLogWriter().info("My client name: " + clientName);
        HydraVector statements = TestConfig.tab().vecAt(DataExtractorPrms.ddlCreateTableStatements, new HydraVector());
        HydraVector extensions = TestConfig.tab().vecAt(DataExtractorPrms.ddlCreateTableExtensions, new HydraVector());
        ddlCreateTableStatements = new String[statements.size()];
        ddlCreateTableExtensions = new String[extensions.size()];
        for (int i = 0; i < statements.size(); ++i) {
            DataExtractorTest.ddlCreateTableStatements[i] = (String)statements.elementAt(i);
            DataExtractorTest.ddlCreateTableExtensions[i] = (String)extensions.elementAt(i);
        }
        DataExtractorTest.HydraTask_initializeFabricServer();
    }

    public static void HydraTask_doOperations() {
        extractorTest.doOperations();
    }

    private void doOperations() {
        if (DataExtractorBB.getBB().getSharedCounters().read(DataExtractorBB.recyclingStarted) != 0L) {
            long recycledAll = DataExtractorBB.getBB().getSharedCounters().read(DataExtractorBB.recycledAllVMs);
            if (recycledAll != 0L) {
                throw new StopSchedulingTaskOnClientOrder("Already Recycled VM, so no DML/DDL operations to be done");
            }
            if (!performUpdatesWhileShuttingDown) {
                throw new StopSchedulingTaskOnClientOrder("Recycling started");
            }
        }
        long opsTaskGranularitySec = TestConfig.tab().longAt(DataExtractorPrms.opsTaskGranularitySec);
        long minTaskGranularityMS = opsTaskGranularitySec * 1000L;
        this.performOps(minTaskGranularityMS);
        if (DataExtractorBB.getBB().getSharedCounters().read(DataExtractorBB.recycledAllVMs) != 0L) {
            throw new StopSchedulingTaskOnClientOrder("All vms have paused");
        }
    }

    private void performOps(long taskTimeMS) {
        long startTime = System.currentTimeMillis();
        boolean performDDLOps = TestConfig.tab().booleanAt(DataExtractorPrms.performDDLOps, false);
        do {
            if (performDDLOps && rand.nextInt(10) > 8) {
                this.doDDLOp();
                continue;
            }
            Connection dConn = null;
            if (hasDerbyServer) {
                dConn = this.getDiscConnection();
            }
            Connection gConn = this.getGFEConnection();
            this.doDMLOp(dConn, gConn);
            if (dConn != null) {
                this.closeDiscConnection(dConn);
            }
            this.closeGFEConnection(gConn);
        } while (System.currentTimeMillis() - startTime < taskTimeMS);
        Log.getLogWriter().info("Done performing one batch of operations");
    }

    @Override
    protected void doDDLOp(Connection dConn, Connection gConn) {
        if (random.nextInt(2) == 0) {
            int ddl = ddls[random.nextInt(ddls.length)];
            DDLStmtIF ddlStmt = ddlFactory.createDDLStmt(ddl);
            ddlStmt.doDDLOp(dConn, gConn);
            this.commit(dConn);
            this.commit(gConn);
        } else {
            Log.getLogWriter().info("RemoteTestModule.getCurrentThread().getThreadId(): " + RemoteTestModule.getCurrentThread().getThreadId());
            Log.getLogWriter().info("RemoteTestModule.getMyVmid(): " + RemoteTestModule.getMyVmid());
            Log.getLogWriter().info("RemoteTestModule.getMyBaseThreadId(): " + RemoteTestModule.getMyBaseThreadId());
            int DDLOpsBatchSize = TestConfig.tab().intAt(DataExtractorPrms.DDLOpsBatchSize, 1);
            for (int i = 0; i < DDLOpsBatchSize; ++i) {
                String UniqueId = "_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getCurrentThread().getThreadId() + "_op_" + i;
                this.dropCreateAlterTables(dConn, gConn, UniqueId);
            }
        }
    }

    protected void dropCreateAlterTables(Connection dConn, Connection gConn, String UniqueId) {
        try {
            int i = random.nextInt(ddlCreateTableStatements.length);
            Statement gStmt = gConn.createStatement();
            Statement dStmt = dConn.createStatement();
            Log.getLogWriter().info("Dropping the sql table trade.temp " + UniqueId + " (if exists)");
            gStmt.execute("drop table if exists trade.temp" + UniqueId);
            try {
                dStmt.execute("drop table trade.temp" + UniqueId);
            }
            catch (SQLException e) {
                Log.getLogWriter().warning("Derby drop table threw an exception + " + e);
            }
            if (random.nextInt(3) > 0) {
                Log.getLogWriter().info("Creating the sql table trade.temp" + UniqueId);
                String sqlCommandGFE = "create table trade.temp" + UniqueId + " " + ddlCreateTableStatements[i] + " " + ddlCreateTableExtensions[i];
                String sqlCommandDerby = "create table trade.temp" + UniqueId + " " + ddlCreateTableStatements[i];
                Log.getLogWriter().info("Commiting the sql create table");
                Log.getLogWriter().info("sqlCommandGFE: " + sqlCommandGFE);
                Log.getLogWriter().info("sqlCommandDerby: " + sqlCommandDerby);
                gStmt.execute(sqlCommandGFE);
                dStmt.execute(sqlCommandDerby);
                if (random.nextInt() == 0) {
                    Log.getLogWriter().info("Altering the sql table trade.temp" + UniqueId);
                    String sqlAlterCommand = "alter table trade.temp" + UniqueId + " " + " drop column salary";
                    Log.getLogWriter().info("Commiting the sql alter table");
                    Log.getLogWriter().info("sqlAlterCommand: " + sqlAlterCommand);
                    gStmt.execute(sqlAlterCommand);
                    dStmt.execute(sqlAlterCommand);
                }
            }
            this.commit(dConn);
            this.commit(gConn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static synchronized void HydraTask_initController() {
        if (extractorTest == null) {
            extractorTest = new DataExtractorTest();
        }
        if ((clientVMsToRestart = TestConfig.tab().vecAt(DataExtractorPrms.clientVMNamesForRestart)) == null) {
            throw new TestException("No client vm names specified for restart sequence");
        }
        simultaneousShutdownVMs = TestConfig.tab().booleanAt(DataExtractorPrms.simultaneousShutdownVMs, false);
        if (simultaneousShutdownVMs) {
            performUpdatesWhileShuttingDown = true;
        }
        for (int i = 0; i < clientVMsToRestart.size(); ++i) {
            DataExtractorTest.extractorTest.restartVMs.addAll(StopStartVMs.getMatchVMs((List)StopStartVMs.getAllVMs(), (String)clientVMsToRestart.get(i).toString()));
        }
    }

    public static void HydraTask_Controller_OnlyStopStartVMs() throws Exception {
        Log.getLogWriter().info("Stopping Vms now");
        extractorTest.shutDownVMs();
        Log.getLogWriter().info("Starting Vms now");
        StopStartVMs.startVMs(DataExtractorTest.extractorTest.restartVMs);
    }

    public static void HydraTask_Controller() throws Exception {
        Log.getLogWriter().info("Stopping Vms now");
        extractorTest.shutDownVMs();
        extractorTest.generateProperyFile();
        extractorTest.runExtractorTool();
        extractorTest.clearPersistentDirs();
        Log.getLogWriter().info("Starting Vms now");
        StopStartVMs.startVMs(DataExtractorTest.extractorTest.restartVMs);
        DataExtractorTest.loadUsingRecommendedFile();
    }

    public static void HydraTask_Controller_Data_Corrupt() throws Exception {
        Log.getLogWriter().info("Stopping Vms now");
        extractorTest.shutDownVMs();
        extractorTest.generateProperyFile();
        DataExtractorTest.corruptOrDeleteDataFiles();
        extractorTest.runExtractorTool();
        DataExtractorTest.verifySecondLastStandingVM();
    }

    public static void HydraTask_Controller_Data_Corrupt_verifyDerby() throws Exception {
        Log.getLogWriter().info("Stopping Vms now");
        extractorTest.shutDownVMs();
        extractorTest.generateProperyFile();
        DataExtractorTest.corruptOrDeleteDataFiles();
        extractorTest.runExtractorTool();
        DataExtractorTest.verifyCorruptedVMNotUsed();
        extractorTest.clearPersistentDirs();
        Log.getLogWriter().info("Starting Vms now");
        StopStartVMs.startVMs(DataExtractorTest.extractorTest.restartVMs);
        DataExtractorTest.loadUsingRecommendedFile();
    }

    public static void verifySecondLastStandingVM() throws Exception {
        String userDir = System.getProperty("user.dir");
        String recommendedFile = userDir + File.separator + DataExtractorTest.getExtractedFilesDirName() + File.separator + "Recommended.txt";
        File recFile = new File(recommendedFile);
        int lineCount = 1;
        BufferedReader reader = new BufferedReader(new FileReader(recommendedFile));
        String line = reader.readLine();
        line = reader.readLine();
        String name = "vm_" + secondLastStandingVmInfo.getVmid() + "_" + secondLastStandingVmInfo.getClientName();
        while (line != null) {
            if (!line.contains(name)) {
                throw new TestException("An entry at line#" + lineCount + " in recommended.txt does not contain " + name + " i.e. second-last standing VM. Possibly a wrong csv was recommended. Line content: " + line);
            }
            line = reader.readLine();
            ++lineCount;
        }
    }

    public static void verifyCorruptedVMNotUsed() throws Exception {
        String userDir = System.getProperty("user.dir");
        String recommendedFile = userDir + File.separator + DataExtractorTest.getExtractedFilesDirName() + File.separator + "Recommended.txt";
        File recFile = new File(recommendedFile);
        int lineCount = 1;
        BufferedReader reader = new BufferedReader(new FileReader(recommendedFile));
        String line = reader.readLine();
        line = reader.readLine();
        String name = "vm_" + lastStandingVmInfo.getVmid() + "_" + lastStandingVmInfo.getClientName();
        while (line != null) {
            if (line.contains(name)) {
                throw new TestException("An entry at line#" + lineCount + " in recommended.txt does contains " + name + " i.e. Corrupted VM. Possibly a wrong csv was recommended. Line content: " + line);
            }
            line = reader.readLine();
            ++lineCount;
        }
    }

    public static void HydraTask_RunExtractor() throws Exception {
        extractorTest.shutDownVMs();
        extractorTest.generateProperyFile();
        extractorTest.runExtractorTool();
    }

    public static void HydraTask_StopStartVMs() throws Exception {
        extractorTest.shutDownVMs();
        StopStartVMs.startVMs(DataExtractorTest.extractorTest.restartVMs);
    }

    private void shutDownVMs() throws Exception {
        DataExtractorBB.getBB().getSharedCounters().increment(DataExtractorBB.recyclingStarted);
        if (simultaneousShutdownVMs) {
            long opsTaskGranularitySec = TestConfig.tab().longAt(DataExtractorPrms.opsTaskGranularitySec);
            long minTaskGranularityMS = opsTaskGranularitySec * 1000L;
            Log.getLogWriter().info("Sleeping for " + minTaskGranularityMS * 3L / 2L + " millisecs to allow the current operations task to terminate");
            MasterController.sleepForMs((int)((int)minTaskGranularityMS * 3 / 2));
            ArrayList<String> stopModeList = new ArrayList<String>();
            for (ClientVmInfo vmInfo : this.restartVMs) {
                stopModeList.add("nice_exit");
            }
            StopStartVMs.stopVMs(this.restartVMs, stopModeList);
        } else {
            for (ClientVmInfo vmInfo : this.restartVMs) {
                MasterController.sleepForMs((int)15000);
                StopStartVMs.stopVM((ClientVmInfo)vmInfo, (String)"nice_exit");
                Log.getLogWriter().info("Sleeping for 20 seconds to allow ops to run...");
                MasterController.sleepForMs((int)20000);
            }
        }
        DataExtractorBB.getBB().getSharedCounters().increment(DataExtractorBB.recycledAllVMs);
    }

    private void generateProperyFile() throws IOException {
        String userDir = System.getProperty("user.dir");
        File file = new File(userDir, "propertyFile.txt");
        file.createNewFile();
        String hdfsDiskStore = TestConfig.tab().stringAt(HDFSStorePrms.diskStoreName, null);
        Log.getLogWriter().info("hdfsDiskStore= " + hdfsDiskStore);
        PrintWriter pw = new PrintWriter(file);
        for (ClientVmInfo vmInfo : this.restartVMs) {
            String name = "vm_" + vmInfo.getVmid() + "_" + vmInfo.getClientName();
            String clientName = vmInfo.getClientName();
            Log.getLogWriter().info("vmInfo.getClientName()" + clientName);
            Log.getLogWriter().info("Client description name= " + TestConfig.getInstance().getClientDescription(clientName).getName());
            VmDescription vmDesc = TestConfig.getInstance().getClientDescription(clientName).getVmDescription();
            Log.getLogWriter().info("VM description name= " + vmDesc.getName());
            Log.getLogWriter().info("Host description name= " + vmDesc.getHostDescription().getName());
            Log.getLogWriter().info("Host description host-name= " + vmDesc.getHostDescription().getHostName());
            String dirName = name + "_" + vmDesc.getHostDescription().getHostName() + "_disk";
            String diskDirName = userDir + File.separator + dirName;
            String hdfsDiskDirName = userDir + File.separator + dirName + File.separator + hdfsDiskStore;
            if (hdfsDiskStore != null) {
                pw.write(name + "=" + diskDirName + "," + hdfsDiskDirName + "\n");
                continue;
            }
            pw.write(name + "=" + diskDirName + "\n");
        }
        pw.close();
        this.propFileAbsolutePath = file.getAbsolutePath();
    }

    private void runExtractorTool() throws Exception {
        RemoteTestModule.getMyVmid();
        Thread monitorThread = DataExtractorTest.getOffHeapMonitorThread();
        monitorThread.start();
        Log.getLogWriter().info("***************Extracting data*****************");
        GemFireXDDataExtractor.main((String[])new String[]{"property-file=" + this.propFileAbsolutePath});
        Log.getLogWriter().info("***************Done Extracting data***************");
        terminateMonitorThread = true;
        monitorThread.join();
        if (monitorObjectsMax > 0) {
            throw new TestException("Bug 50408 detected; Off-heap memory was used while extractor tool was running, objects stat max: " + monitorObjectsMax);
        }
    }

    private static Thread getOffHeapMonitorThread() {
        Thread monitorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (SQLTest.isOffheap) {
                    Log.getLogWriter().info("Starting monitor thread to look for off-heap memory usage");
                    while (true) {
                        OffHeapMemoryStats stats;
                        int objects;
                        if (terminateMonitorThread) {
                            Log.getLogWriter().info("monitor thread is terminating");
                            break;
                        }
                        if (OffHeapHelper.isOffHeapMemoryConfigured() && (objects = (stats = OffHeapHelper.getOffHeapMemoryStats()).getObjects()) > 0) {
                            Log.getLogWriter().info("Detected off-heap memory usage, number of objects in off-heap memory is " + objects);
                            monitorObjectsMax = Math.max(monitorObjectsMax, objects);
                        }
                        MasterController.sleepForMs((int)1500);
                    }
                }
            }
        });
        return monitorThread;
    }

    private void clearPersistentDirs() {
        String userDir = System.getProperty("user.dir");
        Log.getLogWriter().info("Deleting persistence files from all dirs ");
        for (ClientVmInfo vmInfo : this.restartVMs) {
            String name = "vm_" + vmInfo.getVmid() + "_" + vmInfo.getClientName();
            String clientName = vmInfo.getClientName();
            Log.getLogWriter().info("vmInfo.getClientName()" + clientName);
            Log.getLogWriter().info("Client description name= " + TestConfig.getInstance().getClientDescription(clientName).getName());
            VmDescription vmDesc = TestConfig.getInstance().getClientDescription(clientName).getVmDescription();
            Log.getLogWriter().info("VM description name= " + vmDesc.getName());
            Log.getLogWriter().info("Host description name= " + vmDesc.getHostDescription().getName());
            Log.getLogWriter().info("Host description host-name= " + vmDesc.getHostDescription().getHostName());
            String dirName = name + "_" + vmDesc.getHostDescription().getHostName() + "_disk";
            String fullDirPath = userDir + File.separator + dirName;
            List files = FileUtil.getFiles((File)new File(fullDirPath), null, (boolean)false);
            Log.getLogWriter().info(dirName + " has total of " + files.size() + " files/dirs");
            Log.getLogWriter().info("Deleting files from: " + fullDirPath);
            FileUtil.deleteFilesFromDirRecursive((String)fullDirPath);
            Log.getLogWriter().info("Deleted files from: " + fullDirPath);
            files = FileUtil.getFiles((File)new File(fullDirPath), null, (boolean)false);
            Log.getLogWriter().info("After deleting " + dirName + " has total of " + files.size() + " files/dirs");
        }
    }

    public static void loadUsingRecommendedFile() throws Exception {
        SharedMap map = NetworkServerBlackboard.getInstance().getSharedMap();
        Log.getLogWriter().info("Printing entire map");
        NetworkServerHelper.Endpoint selectedEndpoint = null;
        for (Object key : map.getMap().keySet()) {
            Log.getLogWriter().info("For key: " + key);
            Map endpoints = (Map)map.get(key);
            for (NetworkServerHelper.Endpoint endpoint : endpoints.values()) {
                if (key.toString().contains("server")) {
                    selectedEndpoint = endpoint;
                }
                int port = endpoint.getPort();
                Log.getLogWriter().info("Endpoint: " + endpoint.toString());
                Log.getLogWriter().info("Endpoint name: " + endpoint.getName());
                Log.getLogWriter().info("Endpoint host: " + endpoint.getHost());
                Log.getLogWriter().info("Endpoint Id: " + endpoint.getId());
            }
        }
        int port = selectedEndpoint.getPort();
        Log.getLogWriter().info("Selected Endpoint: " + selectedEndpoint.toString());
        Log.getLogWriter().info("Selected Endpoint name: " + selectedEndpoint.getName());
        String userDir = System.getProperty("user.dir");
        String extractDirName = DataExtractorTest.getExtractedFilesDirName();
        String name1 = "recommended=" + userDir + File.separator + extractDirName + File.separator + "Recommended.txt";
        String name2 = "port=" + port;
        String name3 = "property-file=" + DataExtractorTest.extractorTest.propFileAbsolutePath;
        String name4 = "host=" + selectedEndpoint.getAddress();
        DataExtractorTest.sortRecommendedFile(userDir + File.separator + extractDirName + File.separator + "Recommended.txt");
        Thread monitorThread = DataExtractorTest.getOffHeapMonitorThread();
        monitorThread.start();
        Log.getLogWriter().info("***************Loader: Loading data*****************");
        GemFireXDDataExtractorLoader.main((String[])new String[]{name1, name2, name3, name4});
        Log.getLogWriter().info("***************Loader: Loading data complete*****************");
        terminateMonitorThread = true;
        monitorThread.join();
        if (monitorObjectsMax > 0) {
            throw new TestException("Bug 50408 detected; Off-heap memory was used while extractor tool was running, objects stat max: " + monitorObjectsMax);
        }
    }

    static String getExtractedFilesDirName() {
        String userDir = System.getProperty("user.dir");
        class ExtractedFilesFolderFilter
        implements FileFilter {
            ExtractedFilesFolderFilter() {
            }

            @Override
            public boolean accept(File fn) {
                return fn.getName().startsWith("EXTRACTED_FILES") && fn.getName().contains("EXTRACTED_FILES") && fn.isDirectory();
            }
        }
        List extractDirs = FileUtil.getFiles((File)new File(userDir), (FileFilter)new ExtractedFilesFolderFilter(), (boolean)false);
        File extractDir = (File)extractDirs.get(0);
        return extractDir.getName();
    }

    public static void corruptOrDeleteDataFiles() throws IOException {
        String userDir = System.getProperty("user.dir");
        ClientVmInfo vmInfo1 = null;
        ClientVmInfo vmInfo2 = null;
        Iterator<ClientVmInfo> iter = DataExtractorTest.extractorTest.restartVMs.iterator();
        do {
            vmInfo2 = vmInfo1;
            vmInfo1 = iter.next();
        } while (iter.hasNext());
        lastStandingVmInfo = vmInfo1;
        secondLastStandingVmInfo = vmInfo2;
        int vmId = lastStandingVmInfo.getVmid();
        String name = "vm_" + lastStandingVmInfo.getVmid() + "_" + lastStandingVmInfo.getClientName();
        String clientName = lastStandingVmInfo.getClientName();
        VmDescription vmDesc = TestConfig.getInstance().getClientDescription(clientName).getVmDescription();
        String dirName = name + "_" + vmDesc.getHostDescription().getHostName() + "_disk";
        String fullDirPath = userDir + File.separator + dirName;
        String fileExt = TestConfig.tab().stringAt(DataExtractorPrms.fileExtensionForCorruptOrDelete, null);
        String operation = TestConfig.tab().stringAt(DataExtractorPrms.corruptOrDeleteOP, null);
        List files = FileUtil.getFiles((File)new File(fullDirPath), null, (boolean)false);
        if (operation != null && fileExt != null) {
            DataExtractorTest.specificFileCorruptionOrDeletion(files, fileExt, operation);
        } else {
            boolean corruptedOrDeletedOneFile = false;
            for (int i = 0; i < files.size(); ++i) {
                File file = (File)files.get(i);
                if (!file.getName().contains(".drf") && !file.getName().contains(".krf") && !file.getName().contains(".crf") && !file.getName().contains(".if")) continue;
                String absoluteFilePath = file.getAbsolutePath();
                if (corruptedOrDeletedOneFile) continue;
                if (rand.nextInt(2) == 0) {
                    if (file.getName().contains(".drf")) continue;
                    DataExtractorTest.corruptOpLogFile(absoluteFilePath);
                    Log.getLogWriter().info("Corrupted " + file.getName() + " files from: " + fullDirPath);
                } else {
                    if (file.getName().contains(".krf")) continue;
                    if (!file.delete()) {
                        throw new TestException("Could not delete file: " + absoluteFilePath);
                    }
                    Log.getLogWriter().info("Deleted file: " + absoluteFilePath);
                }
                corruptedOrDeletedOneFile = true;
            }
        }
    }

    public static void specificFileCorruptionOrDeletion(List files, String fileExtension, String operation) throws IOException {
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            if (!file.getName().contains(fileExtension)) continue;
            String absoluteFilePath = file.getAbsolutePath();
            if (operation.equalsIgnoreCase("corrupt")) {
                DataExtractorTest.corruptOpLogFile(absoluteFilePath);
                Log.getLogWriter().info("Corrupted " + file.getName() + " file");
                continue;
            }
            if (!file.delete()) {
                throw new TestException("Could not delete file: " + absoluteFilePath);
            }
            Log.getLogWriter().info("Deleted file: " + absoluteFilePath);
        }
    }

    static int countLinesInFile(String fileName) throws IOException {
        int count = 0;
        File file = new File(fileName);
        if (file.isDirectory()) {
            throw new RuntimeException("Cannot count lines in a directory");
        }
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        String line = reader.readLine();
        while (line != null) {
            ++count;
            line = reader.readLine();
        }
        reader.close();
        return count;
    }

    public static void corruptOpLogFile(String dataFile) throws IOException {
        String userDir = System.getProperty("user.dir");
        String tempfile = userDir + File.separator + "temp.txt";
        int numLines = DataExtractorTest.countLinesInFile(dataFile);
        File file = new File(dataFile);
        PrintWriter pw = new PrintWriter(tempfile);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int corruptLine = 3 * numLines / 4;
        String line = reader.readLine();
        int count = 0;
        while (line != null) {
            line = reader.readLine();
            if (++count == corruptLine) {
                pw.write(line.substring(0, line.length() / 2));
                pw.write(RANDOM_CORRUPTION_STRING);
                pw.write(line.substring(line.length() / 2, line.length()));
                continue;
            }
            pw.write(line + "\n");
        }
        reader.close();
        pw.close();
        file.delete();
        File tempFile = new File(tempfile);
        if (!tempFile.renameTo(file)) {
            throw new RuntimeException("Could not rename: " + tempfile + " to " + dataFile);
        }
    }

    public static void sortRecommendedFile(String recommendedFile) throws IOException {
        File recFile = new File(recommendedFile);
        BufferedReader reader = new BufferedReader(new FileReader(recFile));
        String line = reader.readLine();
        String ddl = null;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> customers = new ArrayList<String>();
        ArrayList<String> securities = new ArrayList<String>();
        ArrayList<String> portfolio = new ArrayList<String>();
        ArrayList<String> employees = new ArrayList<String>();
        if (line != null) {
            ddl = line;
        }
        line = reader.readLine();
        while (line != null) {
            if (line.contains("CUSTOMERS")) {
                customers.add(line);
            } else if (line.contains("SECURITIES")) {
                securities.add(line);
            } else if (line.contains("PORTFOLIO")) {
                portfolio.add(line);
            } else if (line.contains("EMPLOYEES")) {
                employees.add(line);
            } else {
                list.add(line);
            }
            line = reader.readLine();
        }
        recFile.delete();
        recFile = new File(recommendedFile);
        PrintWriter pw = new PrintWriter(recFile);
        pw.write(ddl + "\n");
        for (String csvFile : customers) {
            pw.write(csvFile + "\n");
        }
        for (String csvFile : securities) {
            pw.write(csvFile + "\n");
        }
        for (String csvFile : portfolio) {
            pw.write(csvFile + "\n");
        }
        for (String csvFile : employees) {
            pw.write(csvFile + "\n");
        }
        for (String csvFile : list) {
            pw.write(csvFile + "\n");
        }
        pw.close();
    }
}

