/*
 * Decompiled with CFR 0.152.
 */
package sql.datagen;

import hydra.Log;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import sql.SQLPrms;
import sql.datagen.MappedColumnInfo;

public class ColumnMetaData {
    private Random rand = new Random(SQLPrms.getRandSeed());
    private String columnName;
    private String fullTableName;
    private int dataType;
    private int columnSize;
    private int decimalDigits;
    private boolean isPrimary;
    private boolean isUnique;
    private MappedColumnInfo mappedColumn;
    private Map<Integer, Long> lastNumMap = new HashMap<Integer, Long>();
    private Map<Integer, LinkedList<Object>> fkValuesMap = new HashMap<Integer, LinkedList<Object>>();
    private Map<Integer, LinkedList<Object>> fkValuesMap_bk = new HashMap<Integer, LinkedList<Object>>();

    public String getColumnName() {
        return this.columnName;
    }

    public String getFullTableName() {
        return this.fullTableName;
    }

    public String getFullColumnName() {
        return this.fullTableName + "." + this.columnName;
    }

    public void setFullTableName(String fullTableName) {
        this.fullTableName = fullTableName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getColumnSize() {
        int len = this.columnSize;
        if (this.mappedColumn != null) {
            int minlen = this.mappedColumn.getMinLen();
            int maxlen = this.mappedColumn.getMaxLen();
            len = minlen;
            if (maxlen != -1) {
                len = this.rand.nextInt(maxlen - minlen) + minlen;
            }
        }
        return len;
    }

    public boolean isAbsoluteLenth() {
        int minlen;
        boolean absolute = false;
        if (this.mappedColumn != null && (minlen = this.mappedColumn.getMinLen()) != -1) {
            absolute = true;
        }
        return absolute;
    }

    public void setColumnSize(int columnSize) {
        this.columnSize = columnSize;
    }

    public int getDecimalDigits() {
        if (this.mappedColumn != null) {
            return this.mappedColumn.getPrec();
        }
        return this.decimalDigits;
    }

    public void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public MappedColumnInfo getMappedColumn() {
        return this.mappedColumn;
    }

    public void setMappedColumn(MappedColumnInfo mappedColumn) {
        this.mappedColumn = mappedColumn;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public void setUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public Long getLastNum(int tid) {
        return this.lastNumMap.get(tid);
    }

    public void setLastNum(int tid, Long value) {
        this.lastNumMap.put(tid, value);
    }

    public boolean isFKParent() {
        boolean flag = false;
        if (this.mappedColumn != null) {
            flag = this.mappedColumn.isFKParent();
        }
        return flag;
    }

    public void addToFKValueMap(int tid, Object val) {
        if (this.isFKParent()) {
            LinkedList<Object> l = this.fkValuesMap.get(tid);
            if (l == null) {
                l = new LinkedList();
                this.fkValuesMap.put(tid, l);
            }
            if (!l.contains(val)) {
                l.add(val);
            }
        }
    }

    public Object getRandomValueFromFKList(int tid, boolean unique) {
        Object value = null;
        LinkedList<Object> l = this.fkValuesMap.get(tid);
        LinkedList<Object> l_bk = this.fkValuesMap_bk.get(tid);
        if (l != null && !l.isEmpty()) {
            if (unique) {
                value = l.remove();
                if (l_bk == null) {
                    l_bk = new LinkedList();
                    this.fkValuesMap_bk.put(tid, l_bk);
                }
                l_bk.add(value);
            } else {
                int size = l.size();
                int n = size > 1 ? this.rand.nextInt(size - 1) : 0;
                value = l.get(n);
            }
        }
        return value;
    }

    public void resetFKValueMap() {
        Log.getLogWriter().info("Reset FKValueMap for " + this.getFullColumnName());
        for (Integer t : this.fkValuesMap_bk.keySet()) {
            LinkedList<Object> l = this.fkValuesMap.get(t);
            LinkedList<Object> l_bk = this.fkValuesMap_bk.get(t);
            l.addAll(l_bk);
            l_bk.clear();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName() + "[").append("columnName=" + this.getFullColumnName()).append(",isFKParent=" + this.isFKParent()).append(",dataType=" + this.dataType).append(",isPrimary=" + this.isPrimary()).append(",isUnique=" + this.isUnique()).append(",columnSize=" + this.columnSize).append(",decimalDigits=" + this.decimalDigits).append(",mappedColumn=" + this.mappedColumn).append("]");
        return sb.toString();
    }
}

