/*
 * Decompiled with CFR 0.152.
 */
package sql.datagen;

import com.gemstone.gemfire.LogWriter;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.TestConfig;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import sql.SQLPrms;
import sql.datagen.ColumnMetaData;
import sql.datagen.FKContraint;
import sql.datagen.FKMappedColumn;
import sql.datagen.FixedTokenMappedColumn;
import sql.datagen.MappedColumnInfo;
import sql.datagen.Mapper;
import sql.datagen.RandomValueGenerator;
import sql.datagen.TableMetaData;
import sql.datagen.TableMetaDataGenerator;
import sql.datagen.ValueListMappedColumn;
import util.TestException;

public class DataGenerator {
    public LogWriter log;
    protected static String url = "jdbc:gemfirexd://localhost:1530/";
    protected static String driver = "com.pivotal.gemfirexd.jdbc.ClientDriver";
    public static final Random rand = new Random(SQLPrms.getRandSeed());
    private static DataGenerator datagen = null;
    private final Mapper mapper;
    private Map<String, TableMetaData> tableMetaMap = new HashMap<String, TableMetaData>();
    private int totalThreads = -1;

    private DataGenerator() {
        this.log = Log.getLogWriter();
        this.log.info("DataGenerator initialize in this vm");
        this.mapper = Mapper.getMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataGenerator getDataGenerator() {
        if (datagen != null) return datagen;
        Class<DataGenerator> clazz = DataGenerator.class;
        synchronized (DataGenerator.class) {
            if (datagen != null) return datagen;
            datagen = new DataGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return datagen;
        }
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public int getTotalThreads() {
        return this.totalThreads;
    }

    public synchronized void parseMapperFile(String mapperFile, Connection conn) {
        if (mapperFile != null && new File(mapperFile).exists()) {
            try {
                this.mapper.parseMapperFile(mapperFile, conn);
            }
            catch (Exception e) {
                throw new RuntimeException("Error in parsing mapper file ", e);
            }
        } else {
            throw new RuntimeException("mapper file does not exists : " + mapperFile);
        }
    }

    public Map<String, TableMetaData> getTableMetaMap() {
        return this.tableMetaMap;
    }

    public void generateCSVs(String[] fullTableName, int[] rows, String[] csvFile, Connection conn) {
        for (int i = 0; i < fullTableName.length; ++i) {
            String tablename;
            fullTableName[i] = tablename = fullTableName[i].trim().toUpperCase();
            TableMetaData tableMeta = new TableMetaDataGenerator().generate(tablename, rows[i], csvFile[i], conn);
            this.tableMetaMap.put(tableMeta.getTableName(), tableMeta);
        }
        for (String tablename : fullTableName) {
            this.generateCSVPerTable(this.tableMetaMap.get(tablename), conn);
        }
    }

    public void generateCSVPerTable(TableMetaData table, Connection conn) {
        this.log.info("Start Generating CSV for " + table.toString());
        long startTime = System.currentTimeMillis();
        char sep = this.getFieldSeparator();
        boolean printHeader = false;
        int rows = table.getTotalRows();
        int batchNum = 1000;
        if (rows > 10000) {
            batchNum = 10000;
        }
        if (rows > 100000) {
            batchNum = 100000;
        }
        if (rows > 1000000) {
            batchNum = 1000000;
        }
        batchNum = rows;
        List<ColumnMetaData> columnList = table.getColumns();
        try {
            FileWriter fstream = new FileWriter(table.getCsvFileName());
            BufferedWriter out = new BufferedWriter(fstream);
            if (printHeader) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < columnList.size(); ++i) {
                    String column = columnList.get(i).getColumnName();
                    if (i < columnList.size() - 1) {
                        sb.append(column).append(sep);
                        continue;
                    }
                    sb.append(column).append('\n');
                }
                out.write(sb.toString());
            }
            do {
                int rowBatch = rows - batchNum > 0 ? batchNum : rows;
                rows -= rowBatch;
                StringBuilder sb = new StringBuilder();
                List<Map<String, Object>> rowsList = this.getNewRows(table, rowBatch, conn);
                for (Map<String, Object> row : rowsList) {
                    for (int i = 0; i < columnList.size(); ++i) {
                        String column = columnList.get(i).getColumnName();
                        Object v = row.get(column);
                        if (v == null) {
                            v = "";
                        }
                        if (v instanceof Timestamp) {
                            v = this.timestampToString((Timestamp)v);
                        }
                        if (v instanceof Date) {
                            v = this.dateToString((Date)v);
                        }
                        sb.append(v);
                        if (i < columnList.size() - 1) {
                            sb.append(sep);
                            continue;
                        }
                        sb.append('\n');
                    }
                }
                out.write(sb.toString());
            } while (rows > 0);
            out.close();
        }
        catch (IOException e) {
            throw new TestException("Error in writing to CSV for table " + table.getTableName(), (Throwable)e);
        }
        this.log.info("Generated CSV for " + table.getTableName() + " time elapsed: " + (System.currentTimeMillis() - startTime) + " ms");
    }

    public List<Map<String, Object>> getNewRows(TableMetaData table, int expectedRows, Connection conn) {
        this.log.info("Generated " + expectedRows + " new rows for table " + table.getTableName());
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        List<String> pkList = table.getPKList();
        List<String> uniqueList = table.getUniqueList();
        List<FKContraint> fkConstraintList = table.getFKList();
        int pkCnt = pkList.size();
        int uniqueCnt = uniqueList.size();
        int fkCnt = fkConstraintList.size();
        List<Integer> tids = this.getTidsList();
        if (this.totalThreads == -1) {
            this.totalThreads = tids.size();
        }
        int errors = 0;
        int threshold = expectedRows * 2;
        int newRows = 0;
        boolean done = false;
        while (newRows < expectedRows && !done) {
            Map<String, Object> rowData;
            int i;
            int repeatVal;
            int maxRepeatVal;
            int minRepeatVal;
            int tid = tids.get(rand.nextInt(this.totalThreads));
            ArrayList<String> excludeCols = new ArrayList<String>();
            HashMap<String, Object> colMap = new HashMap<String, Object>();
            if (fkCnt == 0) {
                if (pkCnt == 0) {
                    Map<String, Object> rowData2 = this.getRow(table, colMap, tid);
                    if (rowData2 != null) {
                        data.add(rowData2);
                        ++newRows;
                    } else {
                        ++errors;
                    }
                } else {
                    int idx = 0;
                    do {
                        String pkcol = pkList.get(idx);
                        ColumnMetaData pkCol = table.getColumnMeta(pkcol);
                        Object pkVal = this.getValueForColumn(table, pkCol, colMap, tid);
                        for (int j = 0; j < 10 && pkVal == null; ++j) {
                            ++errors;
                            tid = tids.get(rand.nextInt(this.totalThreads));
                            pkVal = this.getValueForColumn(table, pkCol, colMap, tid);
                        }
                        if (pkVal == null) continue;
                        MappedColumnInfo mappedCol = pkCol.getMappedColumn();
                        minRepeatVal = 1;
                        maxRepeatVal = -1;
                        if (mappedCol != null && mappedCol instanceof FKMappedColumn) {
                            minRepeatVal = ((FKMappedColumn)mappedCol).getMinRepeatValue();
                            maxRepeatVal = ((FKMappedColumn)mappedCol).getMaxRepeatValue();
                        }
                        repeatVal = minRepeatVal;
                        if (maxRepeatVal != -1 && Math.abs(maxRepeatVal - minRepeatVal) > 0) {
                            repeatVal += rand.nextInt(Math.abs(maxRepeatVal - minRepeatVal));
                        }
                        colMap.put("TID", new Integer(tid));
                        colMap.put(pkCol.getColumnName(), pkVal);
                        for (i = 0; i < repeatVal; ++i) {
                            rowData = this.getRow(table, colMap, tid);
                            if (rowData != null) {
                                data.add(rowData);
                                ++newRows;
                                continue;
                            }
                            ++errors;
                        }
                        excludeCols.add(pkCol.getColumnName());
                        this.resetParentFKValueMap(table, excludeCols);
                    } while (++idx < pkCnt - 1);
                }
            } else {
                int idx = 0;
                do {
                    FKContraint fk = fkConstraintList.get(idx);
                    ColumnMetaData fkCol = table.getColumnMetaForFKConstraint(fk);
                    Object fkValue = this.getValueForColumn(table, fkCol, colMap, tid);
                    for (int j = 0; j < 10 && fkValue == null; ++j) {
                        ++errors;
                        tid = tids.get(rand.nextInt(this.totalThreads));
                        fkValue = this.getValueForColumn(table, fkCol, colMap, tid);
                    }
                    if (fkValue == null) continue;
                    MappedColumnInfo mappedCol = fkCol.getMappedColumn();
                    minRepeatVal = 1;
                    maxRepeatVal = -1;
                    if (mappedCol != null && mappedCol instanceof FKMappedColumn) {
                        minRepeatVal = ((FKMappedColumn)mappedCol).getMinRepeatValue();
                        maxRepeatVal = ((FKMappedColumn)mappedCol).getMaxRepeatValue();
                    }
                    repeatVal = minRepeatVal;
                    if (maxRepeatVal != -1 && Math.abs(maxRepeatVal - minRepeatVal) > 0) {
                        repeatVal += rand.nextInt(Math.abs(maxRepeatVal - minRepeatVal));
                    }
                    colMap.put("TID", new Integer(tid));
                    colMap.put(fkCol.getColumnName(), fkValue);
                    for (i = 0; i < repeatVal; ++i) {
                        rowData = this.getRow(table, colMap, tid);
                        if (rowData != null) {
                            data.add(rowData);
                            ++newRows;
                            continue;
                        }
                        ++errors;
                    }
                    excludeCols.add(fkCol.getColumnName());
                    this.resetParentFKValueMap(table, excludeCols);
                } while (++idx < fkCnt - 1);
            }
            if (errors <= threshold) continue;
            this.log.warning("Error in generating rows for " + table.getTableName() + ". Insuffcient rows in FK parent. Generated only " + newRows + " rows out of " + expectedRows);
            done = true;
        }
        this.resetParentFKValueMap(table, new ArrayList<String>());
        return data;
    }

    public Map<String, Object> getRow(TableMetaData table, Map<String, Object> columnValueMap, int tid) {
        table.increamentCurrentRowID();
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        Set<String> keyset = columnValueMap.keySet();
        for (ColumnMetaData columnMeta : table.getColumns()) {
            String colName = columnMeta.getColumnName();
            Object value = null;
            value = keyset.contains(colName) ? columnValueMap.get(colName) : this.getValueForColumn(table, columnMeta, columnValueMap, tid);
            if (value == null) {
                this.log.warning("Could not generate value for " + columnMeta.getFullColumnName() + " columnValueMap=" + columnValueMap);
                return null;
            }
            if (value.equals("[null]")) {
                rowData.put(colName, null);
                continue;
            }
            if (value == "[skip]") continue;
            rowData.put(colName, value);
        }
        table.addToFKCompositeMap(rowData, tid);
        return rowData;
    }

    private Object getValueForColumn(TableMetaData table, ColumnMetaData columnMeta, Map<String, Object> columnValueMap, int tid) {
        MappedColumnInfo mapped = columnMeta.getMappedColumn();
        Object value = null;
        value = mapped == null ? new RandomValueGenerator().generateValues(table, columnMeta, tid) : (mapped instanceof FixedTokenMappedColumn ? this.getValueFromFixedToken((FixedTokenMappedColumn)mapped) : (mapped instanceof ValueListMappedColumn ? this.getValueFromValueList(table, (ValueListMappedColumn)mapped) : (mapped instanceof FKMappedColumn ? this.getValueFromFKParent(table, columnMeta, columnValueMap, tid) : new RandomValueGenerator().generateValues(table, columnMeta, tid))));
        if (value != null && columnMeta.isFKParent()) {
            columnMeta.addToFKValueMap(tid, value);
        }
        return value;
    }

    private Object getValueFromFixedToken(FixedTokenMappedColumn column) {
        return column.getFixedToken().getNext();
    }

    private Object getValueFromFKParent(TableMetaData table, ColumnMetaData colMeta, Map<String, Object> columnValueMap, int tid) {
        FKMappedColumn column = (FKMappedColumn)colMeta.getMappedColumn();
        String parent = column.getFkParentTable();
        TableMetaData parentMeta = this.tableMetaMap.get(parent);
        ColumnMetaData parentColMeta = parentMeta.getColumnMeta(column.getFkParentColumn());
        boolean unique = false;
        if (colMeta.isPrimary() || colMeta.isUnique()) {
            unique = true;
        }
        if (columnValueMap.size() > 0 && table.isCompositeFKColumn(colMeta)) {
            return parentMeta.getValueFromCokmpositeFK(parentColMeta, columnValueMap, tid);
        }
        return parentColMeta.getRandomValueFromFKList(tid, unique);
    }

    private void resetParentFKValueMap(TableMetaData table, List<String> excludeCols) {
        for (ColumnMetaData colMeta : table.getColumns()) {
            if (excludeCols.contains(colMeta.getColumnName()) || colMeta.getMappedColumn() == null || !(colMeta.getMappedColumn() instanceof FKMappedColumn)) continue;
            FKMappedColumn column = (FKMappedColumn)colMeta.getMappedColumn();
            String parent = column.getFkParentTable();
            TableMetaData parentMeta = this.tableMetaMap.get(parent);
            ColumnMetaData parentColMeta = parentMeta.getColumnMeta(column.getFkParentColumn());
            parentColMeta.resetFKValueMap();
        }
    }

    private Object getValueFromValueList(TableMetaData table, ValueListMappedColumn column) {
        Object[] values = column.getValueList();
        boolean random = column.isRandomize();
        if (random) {
            return values[rand.nextInt(values.length - 1) + 1];
        }
        return values[table.getCurrentRowID() % values.length];
    }

    protected char getFieldSeparator() {
        return ',';
    }

    protected String dateToString(Date dt) {
        SimpleDateFormat formatterTimestamp = new SimpleDateFormat(this.getFormatterTimestamp());
        return formatterTimestamp.format(dt);
    }

    protected String timestampToString(Timestamp ts) {
        SimpleDateFormat formatterTimestamp = new SimpleDateFormat(this.getFormatterTimestamp());
        return formatterTimestamp.format(ts);
    }

    protected String getFormatterTimestamp() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    protected String getFormatterDate() {
        return "yyyy-MM-dd";
    }

    public List<Integer> getTidsList() {
        ArrayList<Integer> tids = new ArrayList<Integer>();
        TestConfig tc = TestConfig.getInstance();
        int num = tc.getTotalThreads();
        for (int i = 0; i < num; ++i) {
            tids.add(new Integer(i));
        }
        return tids;
    }

    public static Connection getConnection() {
        Connection con = null;
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            System.out.println("ClassNotFoundException: " + e.getMessage());
            System.exit(3);
        }
        try {
            Properties p = new Properties();
            con = DriverManager.getConnection(url, p);
        }
        catch (SQLException ex) {
            System.out.println("SQLException: " + ex.getMessage());
            System.exit(3);
        }
        return con;
    }

    public static void main(String[] args) {
        int i;
        if (args.length == 0) {
            String usage = "Usage: DataGenerator <table-names> [<host:port> <row-counts> <mapper-file>]\n table-names  => comma separated table names\n row-counts   => comma separated row-counts\n mapper-file  => column mapper files";
            System.out.println(usage);
            System.exit(1);
        }
        String[] tableNames = null;
        int[] rowCounts = null;
        String mapperFile = null;
        tableNames = args[0].split(",");
        if (args.length > 1) {
            url = "jdbc:gemfirexd://" + args[1];
            System.out.println("url=" + url);
        }
        if (args.length > 2) {
            String[] multipleRowCount = args[2].split(",");
            rowCounts = new int[multipleRowCount.length];
            for (i = 0; i < multipleRowCount.length; ++i) {
                rowCounts[i] = Integer.parseInt(multipleRowCount[i]);
            }
        }
        if (args.length > 3) {
            mapperFile = args[3];
        }
        String[] outputFiles = new String[tableNames.length];
        for (i = 0; i < tableNames.length; ++i) {
            outputFiles[i] = tableNames[i] + ".csv";
        }
        Connection conn = DataGenerator.getConnection();
        DataGenerator dg = null;
        try {
            dg = new DataGenerator();
            dg.log = Log.createLogWriter((String)"datagenerator", (String)("datagenerator_" + ProcessMgr.getProcessId()), (boolean)true, (String)"INFO", (int)0);
            dg.parseMapperFile(mapperFile, conn);
            dg.generateCSVs(tableNames, rowCounts, outputFiles, conn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

