/*
 * Decompiled with CFR 0.152.
 */
package sql.datagen;

import hydra.blackboard.Blackboard;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class DataGeneratorBB
extends Blackboard {
    static String SQL_BB_NAME = "DataGenerator_BB";
    static String SQL_BB_TYPE = "RMI";
    static final String TABLE_ROW_QUEUE_PREFIX = "TableRowQueue_";
    static final String TABLE_ROWS_LOW_PREFIX = "TableRowdLow_";
    static final String TABLE_CSV_PREFIX = "TableCSV_";
    public static int PARSE_MAPPER = 0;
    public static DataGeneratorBB bbInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataGeneratorBB getBB() {
        if (bbInstance != null) return bbInstance;
        Class<DataGeneratorBB> clazz = DataGeneratorBB.class;
        synchronized (DataGeneratorBB.class) {
            if (bbInstance != null) return bbInstance;
            bbInstance = new DataGeneratorBB(SQL_BB_NAME, SQL_BB_TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bbInstance;
        }
    }

    public DataGeneratorBB() {
    }

    public DataGeneratorBB(String name, String type) {
        super(name, type, DataGeneratorBB.class);
    }

    public static String getCSVFileName(String fullTableName) {
        String key = TABLE_CSV_PREFIX + fullTableName.toUpperCase();
        return (String)bbInstance.getSharedMap().get((Object)key);
    }

    public static void setCSVFileName(String fullTableName, String csv) {
        String key = TABLE_CSV_PREFIX + fullTableName.toUpperCase();
        bbInstance.getSharedMap().put((Object)key, (Object)csv);
    }

    public static Queue<Map<String, Object>> getRowsFromBB(String fullTableName) {
        LinkedBlockingQueue<Map<String, Object>> tableRowsQueue = new LinkedBlockingQueue<Map<String, Object>>();
        String key = TABLE_ROW_QUEUE_PREFIX + fullTableName.toUpperCase();
        bbInstance.getSharedLock().lock();
        Queue allRowsQueue = (Queue)bbInstance.getSharedMap().get((Object)key);
        int queueSize = allRowsQueue.size();
        if (queueSize < 500) {
            DataGeneratorBB.setRowsLowThresholdReached(fullTableName, true);
        }
        int rowsToReturn = queueSize > 100 ? 100 : queueSize;
        for (int i = 0; i < rowsToReturn; ++i) {
            tableRowsQueue.add((Map<String, Object>)allRowsQueue.poll());
        }
        bbInstance.getSharedMap().put((Object)key, (Object)allRowsQueue);
        bbInstance.getSharedLock().unlock();
        return tableRowsQueue;
    }

    public static boolean isRowsLowThresholdReached(String fullTableName) {
        String flagKey = TABLE_ROWS_LOW_PREFIX + fullTableName.toUpperCase();
        Boolean f = (Boolean)bbInstance.getSharedMap().get((Object)flagKey);
        return f == null ? true : f;
    }

    public static void setRowsLowThresholdReached(String fullTableName, boolean bool) {
        String flagKey = TABLE_ROWS_LOW_PREFIX + fullTableName.toUpperCase();
        bbInstance.getSharedMap().put((Object)flagKey, (Object)new Boolean(bool));
    }

    public static void addTableRowsToBB(String fullTableName, List<Map<String, Object>> rowList) {
        String key = TABLE_ROW_QUEUE_PREFIX + fullTableName.toUpperCase();
        bbInstance.getSharedLock().lock();
        LinkedBlockingQueue<Map<String, Object>> allRowsQueue = (LinkedBlockingQueue<Map<String, Object>>)bbInstance.getSharedMap().get((Object)key);
        if (allRowsQueue == null) {
            allRowsQueue = new LinkedBlockingQueue<Map<String, Object>>();
        }
        allRowsQueue.addAll(rowList);
        bbInstance.getSharedMap().put((Object)key, allRowsQueue);
        bbInstance.getSharedLock().unlock();
    }
}

