/*
 * Decompiled with CFR 0.152.
 */
package sql.datagen;

import hydra.FileUtil;
import hydra.Log;
import hydra.RemoteTestModule;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import sql.datagen.DataGeneratorBB;
import sql.datagen.DataGeneratorMgr;
import util.TestException;

public class DataGeneratorClient {
    public void parseMapper(String mapper, Connection conn) {
        if (DataGeneratorBB.getBB().getSharedCounters().incrementAndRead(DataGeneratorBB.PARSE_MAPPER) == 1L) {
            File mfile = new File(mapper);
            String destMapper = null;
            if (mfile.exists()) {
                destMapper = "mapper.prop";
                FileUtil.copyFile((String)mapper, (String)destMapper);
            } else {
                Log.getLogWriter().warning("Mapper file does not Exists: " + mapper);
            }
            String classname = DataGeneratorMgr.class.getName();
            String methodname = "parseMapperFile";
            Class[] types = new Class[]{String.class};
            Object[] args = new Object[]{destMapper};
            try {
                RemoteTestModule.Master.invoke(classname, methodname, types, args);
            }
            catch (RemoteException e) {
                throw new TestException("In parsing mapper :" + mapper, (Throwable)e);
            }
        } else {
            Log.getLogWriter().warning("Mapper is already parsed " + mapper);
        }
    }

    public void generateTableCSVs(String[] tables, int[] rowCounts) {
    }
}

