/*
 * Decompiled with CFR 0.152.
 */
package sql.datagen;

import com.gemstone.gemfire.LogWriter;
import com.google.common.primitives.Ints;
import hydra.FileUtil;
import hydra.Log;
import hydra.MasterController;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import sql.SQLPrms;
import sql.datagen.DataGenerator;
import sql.datagen.DataGeneratorBB;
import sql.datagen.TableMetaData;
import util.TestException;

public class DataGeneratorHelper {
    public static LogWriter log = Log.getLogWriter();
    static DataGenerator datagen = null;
    static final Map<String, Queue<Map<String, Object>>> tableRowsQueueMap = new HashMap<String, Queue<Map<String, Object>>>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void initDataGenerator(String mapper, String[] tableNames, int[] rowCounts, Connection conn) {
        if (DataGeneratorBB.getBB().getSharedCounters().incrementAndRead(DataGeneratorBB.PARSE_MAPPER) == 1L) {
            if (datagen != null) throw new TestException("Datagenerator is already initialized");
            File mfile = new File(mapper);
            String destMapper = null;
            if (mfile.exists()) {
                destMapper = "datagenmapper.prop";
                FileUtil.copyFile((String)mapper, (String)destMapper);
            } else {
                log.warning("Mapper file does not Exists: " + mapper);
            }
            log.info("Init DataGenerator in this vm with mapper : " + destMapper);
            try {
                datagen = DataGenerator.getDataGenerator();
                datagen.parseMapperFile(destMapper, conn);
            }
            catch (Exception e) {
                throw new TestException("", (Throwable)e);
            }
            DataGeneratorHelper.generateCSVsForPopulate(datagen, tableNames, rowCounts, conn);
            if (!SQLPrms.isInsertInBB()) return;
            DataGeneratorHelper.generateRowsInBBForInserts(datagen, tableNames, conn);
            return;
        }
        log.info("DataGenerator is already initialized by other vm");
    }

    private static void generateCSVsForPopulate(DataGenerator datagen, String[] tableNames, int[] rowCounts, Connection conn) {
        String[] outputFiles = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            outputFiles[i] = tableNames[i].trim().toUpperCase() + "_populate.csv";
            DataGeneratorBB.setCSVFileName(tableNames[i], outputFiles[i]);
        }
        log.info("Generating CSVs for tables=" + Arrays.asList(tableNames) + ", rows=" + Ints.asList((int[])rowCounts) + ", outputFiles=" + Arrays.asList(outputFiles));
        datagen.generateCSVs(tableNames, rowCounts, outputFiles, conn);
    }

    private static void generateRowsInBBForInserts(final DataGenerator datagen, String[] fullTableNames, final Connection conn) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    for (String key : datagen.getTableMetaMap().keySet()) {
                        TableMetaData table = datagen.getTableMetaMap().get(key);
                        String tableName = table.getTableName();
                        if (!DataGeneratorBB.isRowsLowThresholdReached(tableName)) continue;
                        log.info("Adding 1000 new rows in BB for insert for table " + tableName);
                        try {
                            List<Map<String, Object>> rowList = datagen.getNewRows(table, 1000, conn);
                            DataGeneratorBB.addTableRowsToBB(tableName, rowList);
                            DataGeneratorBB.setRowsLowThresholdReached(tableName, false);
                        }
                        catch (Exception e) {
                            throw new TestException("Error in creating rows in BB for insert ", (Throwable)e);
                        }
                    }
                    log.info("DataGenerator - datapopulator for insert, Sleeping for 2 sec");
                    MasterController.sleepForMs((int)2000);
                }
            }
        }, "DataGenerator_insertRows").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getNewRow(String fullTableName) {
        String key = fullTableName.toUpperCase();
        Queue<Map<String, Object>> tableRowsQueue = null;
        Map<String, Object> rowMap = null;
        Map<String, Queue<Map<String, Object>>> map = tableRowsQueueMap;
        synchronized (map) {
            tableRowsQueue = tableRowsQueueMap.get(key);
            if (tableRowsQueue == null) {
                DataGeneratorBB.getBB();
                tableRowsQueue = DataGeneratorBB.getRowsFromBB(key);
                tableRowsQueueMap.put(key, tableRowsQueue);
                log.info("Initialize local rows cache for table " + fullTableName + " with cached is " + tableRowsQueue.size() + " rows");
            } else if (tableRowsQueue.size() < 10) {
                tableRowsQueue.addAll(DataGeneratorBB.getRowsFromBB(key));
                log.info("Added 100 rows into local cache for table " + fullTableName + " total cached is " + tableRowsQueue.size());
            }
            rowMap = tableRowsQueue.poll();
        }
        if (rowMap == null) {
            log.info("DataGenerator - No row in local queue, waiting for 2 sec");
            MasterController.sleepForMs((int)2000);
            rowMap = DataGeneratorHelper.getNewRow(fullTableName);
        }
        return rowMap;
    }

    public static Object getTidsList() {
        ArrayList<Integer> tids = new ArrayList<Integer>();
        int num = 100;
        for (int i = 0; i <= num; ++i) {
            tids.add(new Integer(i));
        }
        return tids;
    }
}

