/*
 * Decompiled with CFR 0.152.
 */
package sql.datagen;

import sql.datagen.MappedColumnInfo;

public class FKMappedColumn
extends MappedColumnInfo {
    private String fkParentTable;
    private String fkParentColumn;
    private int minRepeatValue = -1;
    private int maxRepeatValue = -1;

    public FKMappedColumn(String columnName) {
        super(columnName);
    }

    public void setFKRelationship(String fkParentStr, int minRepeat, int maxRepeat) {
        String parent = fkParentStr.trim().toUpperCase();
        this.fkParentTable = parent.substring(0, parent.lastIndexOf("."));
        this.fkParentColumn = parent.substring(parent.lastIndexOf(".") + 1);
        this.minRepeatValue = minRepeat;
        this.maxRepeatValue = maxRepeat;
    }

    public String getFullFkParentColumn() {
        return this.fkParentTable + "." + this.fkParentColumn;
    }

    public String getFkParentColumn() {
        return this.fkParentColumn;
    }

    public String getFkParentTable() {
        return this.fkParentTable;
    }

    public int getMinRepeatValue() {
        return this.minRepeatValue;
    }

    public int getMaxRepeatValue() {
        return this.maxRepeatValue;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName() + "[").append("columnName=" + this.getColumnName()).append(",fkParentTable=" + this.fkParentTable).append(",fkParentColumn=" + this.fkParentColumn).append(",minRepeatValue=" + this.minRepeatValue).append(",maxRepeatValue=" + this.maxRepeatValue).append("]");
        return sb.toString();
    }
}

