/*
 * Decompiled with CFR 0.152.
 */
package sql.datagen;

import com.gemstone.gemfire.LogWriter;
import hydra.Log;
import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import sql.datagen.MappedColumnInfo;
import sql.datagen.SpecialTokens;

public class Mapper {
    public static LogWriter log = Log.getLogWriter();
    private static Mapper mapper;
    private AtomicBoolean parsed = new AtomicBoolean(false);
    public static final String nullToken = "[null]";
    public static final String skipToken = "[skip]";
    private HashMap<String, MappedColumnInfo> columnNameMapping = new HashMap();

    private Mapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Mapper getMapper() {
        if (mapper != null) return mapper;
        Class<Mapper> clazz = Mapper.class;
        synchronized (Mapper.class) {
            if (mapper != null) return mapper;
            mapper = new Mapper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mapper;
        }
    }

    public void resetMapper() {
        this.columnNameMapping = new HashMap();
    }

    public synchronized void parseMapperFile(String mapper, Connection conn) throws Exception {
        if (this.parsed.get()) {
            return;
        }
        this.parsed.set(true);
        if (mapper == null) {
            log.error(" mapper file is null, returning.");
            return;
        }
        log.info("Start parsing mapper: " + mapper);
        try (BufferedReader in = null;){
            String line;
            FileReader freader = new FileReader(mapper);
            in = new BufferedReader(freader);
            boolean skipMode = false;
            while ((line = in.readLine()) != null) {
                String mappedColumnS;
                if (line.startsWith("*/")) {
                    skipMode = false;
                    continue;
                }
                if (line.startsWith("##") || skipMode || line.startsWith("#")) continue;
                if (line.startsWith("/*")) {
                    skipMode = true;
                    continue;
                }
                if ((line = line.trim()).length() <= 0) continue;
                String[] mapping = line.split("=");
                String col = mapping[0].trim().toUpperCase();
                MappedColumnInfo mappedColumn = this.parseLine(col, mappedColumnS = mapping[1].trim(), conn);
                if (mappedColumn == null) {
                    mappedColumnS = mappedColumnS.toUpperCase();
                    mappedColumn = this.columnNameMapping.get(mappedColumnS);
                    log.info("Registering mapping for column " + col + " to " + mappedColumn);
                    if (mappedColumn == null) {
                        throw new Exception("No parent mapping found for " + col + " for parent " + mappedColumnS);
                    }
                }
                if (this.columnNameMapping.put(col, mappedColumn) == null) continue;
                throw new IllegalStateException("Multiple mappings for column " + col);
            }
            in.close();
        }
        log.info("Stop parsing mapper:" + mapper + "\n");
    }

    public HashMap<String, MappedColumnInfo> getColumnNameMapping() {
        return this.columnNameMapping;
    }

    private MappedColumnInfo parseLine(String col, String line, Connection conn) throws Exception {
        if (line.startsWith("::")) {
            if (SpecialTokens.valuelist.lineStartsWith(line = line.substring("::".length()))) {
                return SpecialTokens.valuelist.parseToken(col, line, conn);
            }
            if (SpecialTokens.foreignkey.lineStartsWith(line)) {
                return SpecialTokens.foreignkey.parseToken(col, line, conn);
            }
            if (SpecialTokens.random.lineStartsWith(line)) {
                return SpecialTokens.random.parseToken(col, line, conn);
            }
            if (SpecialTokens.format.lineStartsWith(line)) {
                return SpecialTokens.format.parseToken(col, line, conn);
            }
            if (SpecialTokens.UUID.lineStartsWith(line)) {
                return SpecialTokens.UUID.parseToken(col, line, conn);
            }
            if (SpecialTokens.LCTS.lineStartsWith(line)) {
                return SpecialTokens.LCTS.parseToken(col, line, conn);
            }
            if (SpecialTokens.LMTS.lineStartsWith(line)) {
                return SpecialTokens.LMTS.parseToken(col, line, conn);
            }
            if (SpecialTokens.UUID.lineStartsWith(line)) {
                return SpecialTokens.UUID.parseToken(col, line, conn);
            }
            if (SpecialTokens.UDT.lineStartsWith(line)) {
                return SpecialTokens.UDT.parseToken(col, line, conn);
            }
            throw new IllegalArgumentException("Invalid col " + col + " for line: " + line);
        }
        if (SpecialTokens.nullvalue.lineStartsWith(line)) {
            return SpecialTokens.nullvalue.parseToken(col, line, conn);
        }
        if (SpecialTokens.skipvalue.lineStartsWith(line)) {
            return SpecialTokens.skipvalue.parseToken(col, line, conn);
        }
        return null;
    }
}

