/*
 * Decompiled with CFR 0.152.
 */
package sql.datagen;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import sql.datagen.ColumnMetaData;
import sql.datagen.DataGenerator;
import sql.datagen.TableMetaData;

public class RandomValueGenerator {
    private Random rand;
    private int totalThreads;
    final char[] chooseChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    static final char[] chooseBytes = "0123456789abcdef".toCharArray();
    final char[] chooseInts = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public RandomValueGenerator() {
        DataGenerator datagen = DataGenerator.getDataGenerator();
        this.totalThreads = datagen.getTotalThreads();
        this.rand = DataGenerator.rand;
    }

    public Object generateValues(TableMetaData table, ColumnMetaData column, int tid) {
        Long lastNum;
        int type = column.getDataType();
        int cLen = column.getColumnSize();
        int prec = column.getDecimalDigits();
        boolean absoluteLength = column.isAbsoluteLenth();
        boolean isPrimary = column.isPrimary();
        boolean isUnique = column.isUnique();
        Long newNum = lastNum = column.getLastNum(tid);
        newNum = lastNum == null ? new Long(tid) : (isPrimary || isUnique ? Long.valueOf(this.getNextNumber(lastNum, this.totalThreads)) : (this.rand.nextInt(100) < 20 ? lastNum : Long.valueOf(this.getNextNumber(lastNum, this.totalThreads))));
        String newNumStr = newNum.toString();
        Object value = null;
        switch (type) {
            case 1: 
            case 12: 
            case 2005: {
                String baseValue = column.getColumnName();
                if (isPrimary) {
                    value = baseValue + "_" + newNum;
                    break;
                }
                int diff = cLen - baseValue.length() - newNumStr.length() - 2;
                if (diff > 3) {
                    String v = this.generateString(diff, absoluteLength);
                    value = baseValue + "_" + newNumStr + "_" + v;
                    break;
                }
                int len = cLen - newNumStr.length() - 1;
                value = newNumStr + "_" + this.generateString(len, absoluteLength);
                break;
            }
            case -5: {
                if (isPrimary || isUnique) {
                    value = (long)newNum;
                    break;
                }
                int l = newNumStr.length();
                String s = this.generateNumericStr(cLen - l, prec, absoluteLength);
                value = new Long(newNumStr + s);
                break;
            }
            case 4: {
                if (isPrimary || isUnique) {
                    value = newNum.intValue();
                    break;
                }
                int l = newNumStr.length();
                String s = this.generateNumericStr(cLen - l, prec, absoluteLength);
                value = new Integer(newNumStr + s);
                break;
            }
            case 5: {
                if (isPrimary || isUnique) {
                    value = newNum.shortValue();
                    break;
                }
                int l = newNumStr.length();
                String s = this.generateNumericStr(cLen - l, prec, absoluteLength);
                value = new Short(newNumStr + s);
                break;
            }
            case 8: {
                if (isPrimary || isUnique) {
                    value = new BigDecimal(newNum);
                    break;
                }
                int l = newNumStr.length();
                String s = this.generateNumericStr(cLen - l, prec, absoluteLength);
                value = new BigDecimal(newNumStr + s);
                break;
            }
            case 6: 
            case 7: {
                if (isPrimary || isUnique) {
                    value = new Float(newNum + "");
                    break;
                }
                int l = newNumStr.length();
                String s = this.generateNumericStr(cLen - l, prec, absoluteLength);
                value = new Float(newNumStr + s);
                break;
            }
            case 91: {
                value = this.generateDate(newNum * 183000L);
                break;
            }
            case 93: {
                value = this.generateTimestamp(newNum * 183000L);
                break;
            }
            case 2: 
            case 3: {
                if (isPrimary || isUnique) {
                    value = new BigDecimal(newNum);
                    break;
                }
                int l = newNumStr.length();
                String s = this.generateNumericStr(cLen - l, prec, absoluteLength);
                value = new BigDecimal(newNumStr + s);
                break;
            }
            case 2004: {
                value = this.generateBytes(cLen, absoluteLength);
                break;
            }
            default: {
                throw new RuntimeException("cannot handle column of type " + type);
            }
        }
        column.setLastNum(tid, newNum);
        return value;
    }

    protected String getFormatterTimestamp() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    protected String getFormatterDate() {
        return "yyyy-MM-dd";
    }

    protected String getBaseTime() {
        return "2012-01-01 01:01:00";
    }

    protected String generateString(int len, boolean absoluteLength) {
        if (len < 1) {
            return new String();
        }
        if (len > 32000) {
            len = 32000;
        }
        if (!absoluteLength) {
            len = this.rand.nextInt(len) + 1;
        }
        String chars = new String();
        for (int i = 0; i < len; ++i) {
            chars = chars + this.chooseChars[this.rand.nextInt(this.chooseChars.length)];
        }
        return new String(chars);
    }

    protected char[] generateBytes(int len, boolean absoluteLength) {
        if (len < 1) {
            return new char[0];
        }
        if (len > 32000) {
            len = 32000;
        }
        if (!absoluteLength) {
            len = this.rand.nextInt(len) + 1;
        }
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = chooseBytes[this.rand.nextInt(chooseBytes.length)];
        }
        return chars;
    }

    protected java.sql.Date generateDate(long offset) {
        SimpleDateFormat formatterTimestamp = new SimpleDateFormat(this.getFormatterTimestamp());
        Date baseDate = null;
        try {
            baseDate = formatterTimestamp.parse(this.getBaseTime());
        }
        catch (ParseException e) {
            throw new RuntimeException("Error is formating Date ", e);
        }
        long newTime = baseDate.getTime() + offset;
        java.sql.Date newDate = new java.sql.Date(newTime);
        return newDate;
    }

    protected Timestamp generateTimestamp(long offset) {
        SimpleDateFormat formatterTimestamp = new SimpleDateFormat(this.getFormatterTimestamp());
        Date baseDate = null;
        try {
            baseDate = formatterTimestamp.parse(this.getBaseTime());
        }
        catch (ParseException e) {
            throw new RuntimeException("Error is formating TimeStamp ", e);
        }
        long newTime = baseDate.getTime() + offset;
        Timestamp newDate = new Timestamp(newTime);
        return newDate;
    }

    protected String generateNumericStr(int len, int prec, boolean absoluteLength) {
        int major = len - prec - 1;
        if (major > 1) {
            if (major > 15) {
                major = 15;
            }
            if (!absoluteLength) {
                major = this.rand.nextInt(major) + 1;
            }
        }
        String majorChars = new String();
        if (major > 0) {
            for (int i = 0; i < major; ++i) {
                majorChars = majorChars + this.chooseInts[this.rand.nextInt(this.chooseInts.length)];
            }
        } else {
            majorChars = majorChars + "";
        }
        String num = majorChars;
        if (prec > 0) {
            if (!absoluteLength) {
                prec = this.rand.nextInt(prec) + 1;
            }
            char[] precChars = new char[prec];
            for (int i = 0; i < prec; ++i) {
                precChars[i] = this.chooseInts[this.rand.nextInt(this.chooseInts.length)];
            }
            num = num + "." + new String(precChars);
        }
        return num;
    }

    protected long getNextNumber(long lastNum, int totalThreads) {
        return lastNum + (long)totalThreads;
    }

    protected String getNewNumStr(long newNum, int digits) {
        String numStr = "";
        int l = (newNum + "").length();
        int diff = digits - l;
        for (int i = 0; i < diff; ++i) {
            numStr = numStr + "0";
        }
        return numStr + newNum;
    }
}

