/*
 * Decompiled with CFR 0.152.
 */
package sql.datagen;

import com.gemstone.gemfire.LogWriter;
import hydra.Log;
import hydra.MethExecutor;
import hydra.MethExecutorResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import sql.datagen.FKMappedColumn;
import sql.datagen.FixedTokenMappedColumn;
import sql.datagen.MappedColumnInfo;
import sql.datagen.ValueListMappedColumn;

public enum SpecialTokens {
    foreignkey{

        @Override
        public MappedColumnInfo parseToken(String col, String line, Connection conn) throws Exception {
            int minNumber = -1;
            int maxNumber = -1;
            String foreignKeyColumn = null;
            String[] elems = line.split(" ");
            if (elems.length != 4) {
                throw new IllegalArgumentException("incorrect defination for '::foreignkey' token for " + col + ", value=" + line);
            }
            foreignKeyColumn = elems[1].toUpperCase().trim();
            String number = elems[3];
            int rangeIndex = number.indexOf(45);
            if (rangeIndex > 0) {
                minNumber = Integer.parseInt(number.substring(0, rangeIndex).trim());
                maxNumber = Integer.parseInt(number.substring(rangeIndex + 1).trim());
            } else {
                minNumber = maxNumber = Integer.parseInt(number.trim());
            }
            if (foreignKeyColumn == null || minNumber == -1 || maxNumber == -1) {
                throw new IllegalArgumentException("either foreignKey or cardinality (number) not mentioned for " + col);
            }
            FKMappedColumn m = new FKMappedColumn(col);
            m.setFKRelationship(foreignKeyColumn, minNumber, maxNumber);
            this.log.info("Registering foreign key maping for column " + col + ": " + m);
            return m;
        }
    }
    ,
    valuelist{

        @Override
        public MappedColumnInfo parseToken(String col, String line, Connection conn) throws Exception {
            if (line.indexOf("bashexecute") > 0) {
                String valueListCmd = line.substring(line.indexOf(91) + 1, line.indexOf(93));
                ArrayList<String> cmd = new ArrayList<String>(4);
                cmd.add("bash");
                cmd.add("--norc");
                cmd.add("-c");
                cmd.add(valueListCmd);
                this.log.info("executing:" + cmd);
                ProcessBuilder procBuilder = new ProcessBuilder(cmd);
                Process pr = procBuilder.start();
                BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                ArrayList<String> outputLines = new ArrayList<String>();
                String outline = null;
                while ((outline = buf.readLine()) != null) {
                    outputLines.add(outline);
                }
                buf = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
                while ((outline = buf.readLine()) != null) {
                    this.log.error(outline);
                }
                pr.waitFor();
                Object[] values = ((String)outputLines.get(0)).split(",");
                if (outputLines.size() > 1) {
                    this.log.error("More than one line output is getting IGNORED for now ....");
                }
                boolean randomize = false;
                if (line.endsWith("randomize")) {
                    randomize = true;
                }
                ValueListMappedColumn m = new ValueListMappedColumn(col, values, randomize);
                this.log.info("Registering values for column " + col + ": " + m);
                return m;
            }
            if (line.indexOf("javaexecute") > 0) {
                String methodName;
                String valueListStr = line.substring(line.indexOf(91) + 1, line.indexOf(93));
                String[] elems = valueListStr.split(" ");
                if (elems.length != 2) {
                    throw new IllegalArgumentException("incorrect defination for " + col + " value=" + line);
                }
                String e = elems[1].trim();
                String className = e.substring(0, e.lastIndexOf("."));
                MethExecutorResult result = MethExecutor.executeInstance((String)className, (String)(methodName = e.substring(e.lastIndexOf(".") + 1, e.indexOf("("))));
                if (result.exceptionOccurred()) {
                    throw new Exception("occured invoking " + className + "." + methodName, result.getException());
                }
                List vList = (List)result.getResult();
                Object[] values = vList.toArray(new Object[0]);
                boolean randomize = false;
                if (line.endsWith("randomize")) {
                    randomize = true;
                }
                ValueListMappedColumn m = new ValueListMappedColumn(col, values, randomize);
                this.log.info("Registering values for column " + col + ": " + m);
                return m;
            }
            if (line.indexOf("{") > 0) {
                String valueList = line.substring(line.indexOf(123) + 1, line.indexOf(125));
                Object[] values = valueList.split(",");
                for (int i = 0; i < values.length; ++i) {
                    values[i] = values[i].trim();
                }
                boolean randomize = false;
                if (line.endsWith("randomize")) {
                    randomize = true;
                }
                ValueListMappedColumn m = new ValueListMappedColumn(col, values, randomize);
                this.log.info("Registering values for column " + col + ": " + m);
                return m;
            }
            String valueListQuery = line.substring(line.indexOf(91) + 1, line.indexOf(93));
            ResultSet r = conn.createStatement().executeQuery(valueListQuery);
            ArrayList<String> values = new ArrayList<String>();
            while (r.next()) {
                values.add(r.getString(1));
            }
            boolean randomize = false;
            if (line.endsWith("randomize")) {
                randomize = true;
            }
            ValueListMappedColumn m = new ValueListMappedColumn(col, values.toArray(new String[0]), randomize);
            this.log.info("Registering values for column " + col + ": " + m);
            return m;
        }
    }
    ,
    random{

        @Override
        public MappedColumnInfo parseToken(String col, String line, Connection conn) {
            int beginIndex = line.indexOf("[");
            if (beginIndex == -1) {
                throw new IllegalArgumentException("Incomplete randome specifier: " + line);
            }
            int endIndex = line.indexOf("]");
            if (endIndex == -1) {
                throw new IllegalArgumentException("Incomplete randome specifier: " + line);
            }
            String valueSpec = line.substring(beginIndex + 1, endIndex);
            if (valueSpec.indexOf("-") <= 0) {
                MappedColumnInfo m = new MappedColumnInfo(col);
                m.setRange(Integer.parseInt(valueSpec), -1, -1);
                this.log.info("Registering random values for column " + col + ": " + m);
                return m;
            }
            String[] valueLengths = valueSpec.split("-");
            int begin = Integer.parseInt(valueLengths[0]);
            int end = Integer.parseInt(valueLengths[1]);
            MappedColumnInfo m = new MappedColumnInfo(col);
            m.setRange(begin, end, -1);
            this.log.info("Registering random values for column " + col + ": " + m);
            return m;
        }
    }
    ,
    format{

        @Override
        public MappedColumnInfo parseToken(String col, String line, Connection conn) throws Exception {
            int beginLength = -1;
            int endLength = -1;
            int prec = -1;
            String fSpec = line.substring(this.name().length()).trim();
            int dot = fSpec.indexOf(".");
            if (dot == -1) {
                beginLength = fSpec.length();
            } else {
                beginLength = fSpec.length();
                prec = fSpec.length() - dot - 1;
            }
            MappedColumnInfo m = new MappedColumnInfo(col);
            m.setRange(beginLength, endLength, prec);
            this.log.info("Registering fixed format values for column " + col + ": " + m);
            return m;
        }
    }
    ,
    UUID{

        @Override
        public MappedColumnInfo parseToken(String col, String line, Connection conn) {
            FixedTokenMappedColumn m = new FixedTokenMappedColumn(col, this);
            this.log.info("Registering UUID value for column " + col + ": " + m);
            return m;
        }

        @Override
        public String getNext() {
            return java.util.UUID.randomUUID().toString();
        }
    }
    ,
    LMTS{

        @Override
        public MappedColumnInfo parseToken(String col, String line, Connection conn) {
            this.log.info("Registering LMTS value for column " + col + ": " + line);
            return new MappedColumnInfo(col);
        }
    }
    ,
    LCTS{

        @Override
        public MappedColumnInfo parseToken(String col, String line, Connection conn) {
            this.log.info("Registering LCTS value for column " + col + ": " + line);
            return new MappedColumnInfo(col);
        }
    }
    ,
    UDT{
        String classname = null;
        String methodname = null;

        @Override
        public MappedColumnInfo parseToken(String col, String line, Connection conn) {
            String[] elem;
            for (String e : elem = line.split(" ")) {
                if ((e = e.trim()).equalsIgnoreCase("UDT") || e.equalsIgnoreCase("")) continue;
                this.classname = e.substring(0, e.lastIndexOf("."));
                this.methodname = e.substring(e.lastIndexOf(".") + 1, e.indexOf("("));
            }
            FixedTokenMappedColumn m = new FixedTokenMappedColumn(col, this);
            this.log.info("Registering UDIT value for column " + col + ": " + m);
            return m;
        }

        @Override
        public String getNext() {
            MethExecutorResult result = MethExecutor.executeInstance((String)this.classname, (String)this.methodname);
            if (result.getStackTrace() != null) {
                throw new RuntimeException(result.toString());
            }
            return result.getResult().toString();
        }

        public String toString() {
            return "UDT " + this.classname + "." + this.methodname + "()";
        }
    }
    ,
    nullvalue{

        @Override
        public boolean lineStartsWith(String line) {
            return line.startsWith("[null]");
        }

        @Override
        public MappedColumnInfo parseToken(String col, String line, Connection conn) throws Exception {
            this.log.info("Registering NULL value for column " + col + ": " + line);
            return new FixedTokenMappedColumn(col, this);
        }

        @Override
        public String getNext() {
            return "[null]";
        }
    }
    ,
    skipvalue{

        @Override
        public boolean lineStartsWith(String line) {
            return line.startsWith("[skip]");
        }

        @Override
        public MappedColumnInfo parseToken(String col, String line, Connection conn) throws Exception {
            System.out.println("NOT Registering, rather skipping value for column " + col + ": " + line);
            return new FixedTokenMappedColumn(col, this);
        }

        @Override
        public String getNext() {
            return "[skip]";
        }
    };

    LogWriter log = Log.getLogWriter();

    public boolean lineStartsWith(String line) {
        return line.startsWith(this.name());
    }

    public String getNext() {
        return null;
    }

    public abstract MappedColumnInfo parseToken(String var1, String var2, Connection var3) throws Exception;
}

