/*
 * Decompiled with CFR 0.152.
 */
package sql.datagen;

import hydra.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sql.datagen.ColumnMetaData;
import sql.datagen.FKContraint;
import sql.datagen.FKMappedColumn;

public class TableMetaData {
    private String tableName;
    private String csvFileName;
    private int totalRows;
    private int currentRowID;
    private List<String> PKList;
    private List<FKContraint> FKList;
    private List<String> uniqueList;
    private List<ColumnMetaData> columns;
    private Map<Integer, List<Map<String, Object>>> fkCompositeMapping;

    public TableMetaData(String tableName) {
        this.tableName = tableName;
        this.PKList = new ArrayList<String>();
        this.FKList = new ArrayList<FKContraint>();
        this.uniqueList = new ArrayList<String>();
        this.columns = new ArrayList<ColumnMetaData>();
        this.currentRowID = 0;
        this.fkCompositeMapping = new HashMap<Integer, List<Map<String, Object>>>();
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public void setCsvFileName(String csvFileName) {
        this.csvFileName = csvFileName;
    }

    public String getCsvFileName() {
        return this.csvFileName;
    }

    public List<String> getPKList() {
        return this.PKList;
    }

    public void addtoPKList(String pKColumn) {
        this.PKList.add(pKColumn);
    }

    public List<FKContraint> getFKList() {
        return this.FKList;
    }

    public void addToFKList(FKContraint fKcolumn) {
        this.FKList.add(fKcolumn);
    }

    public ColumnMetaData getColumnMetaForFKConstraint(FKContraint fk) {
        for (ColumnMetaData col : this.columns) {
            if (!fk.getColumnName().equals(col.getColumnName())) continue;
            return col;
        }
        return null;
    }

    public ColumnMetaData getColumnMeta(String columnName) {
        for (ColumnMetaData col : this.columns) {
            if (!columnName.equals(col.getColumnName())) continue;
            return col;
        }
        return null;
    }

    public boolean isCompositeFKColumn(ColumnMetaData column) {
        boolean flag = false;
        String parentTable = ((FKMappedColumn)column.getMappedColumn()).getFkParentTable();
        for (FKContraint fk : this.FKList) {
            if (column.getColumnName().equals(fk.getColumnName()) || !parentTable.contains(fk.getParentTable())) continue;
            flag = true;
        }
        return flag;
    }

    public List<String> getUniqueList() {
        return this.uniqueList;
    }

    public void addToUniqueList(String uniqueCol) {
        this.uniqueList.add(uniqueCol);
    }

    public List<ColumnMetaData> getColumns() {
        return this.columns;
    }

    public void addColumns(ColumnMetaData column) {
        this.columns.add(column);
    }

    public int getCurrentRowID() {
        return this.currentRowID;
    }

    public void increamentCurrentRowID() {
        ++this.currentRowID;
    }

    public void addToFKCompositeMap(Map<String, Object> rowData, int tid) {
        if (this.PKList.size() > 1) {
            List<Map<String, Object>> fkValuesTidMapList = this.fkCompositeMapping.get(tid);
            if (fkValuesTidMapList == null) {
                fkValuesTidMapList = new LinkedList<Map<String, Object>>();
                this.fkCompositeMapping.put(tid, fkValuesTidMapList);
            }
            boolean isfkParent = true;
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            for (String pkCol : this.PKList) {
                if (!this.getColumnMeta(pkCol).isFKParent()) {
                    isfkParent = false;
                }
                rowMap.put(pkCol, rowData.get(pkCol));
            }
            if (isfkParent) {
                fkValuesTidMapList.add(rowMap);
            }
        }
    }

    public Object getValueFromCokmpositeFK(ColumnMetaData column, Map<String, Object> valueMap, int tid) {
        Object value = null;
        if (this.PKList.size() > 1) {
            List<Map<String, Object>> fkValuesTidMapList = this.fkCompositeMapping.get(tid);
            String pkcol = null;
            for (String pk : this.PKList) {
                if (valueMap.get(pk) == null) continue;
                pkcol = pk;
            }
            if (pkcol != null) {
                Object pkval = valueMap.get(pkcol);
                for (Map<String, Object> rowMap : fkValuesTidMapList) {
                    if (rowMap.get(pkcol) == null || !rowMap.get(pkcol).equals(pkval)) continue;
                    value = rowMap.get(column.getColumnName());
                }
            } else {
                Log.getLogWriter().warning("No pk column in value list for. column=" + column.getColumnName() + " valueMap=" + valueMap);
            }
        } else {
            throw new RuntimeException("Not Expected to be here." + this.getTableName() + " do not have composite PK");
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("[").append("name=" + this.tableName).append(",csvFileName=" + this.csvFileName).append(",totalRows=" + this.totalRows).append(",PKList=" + this.PKList).append(",FKList=" + this.FKList).append(",uniqueList=" + this.uniqueList).append(",columns=" + this.columns).append("]");
        return sb.toString();
    }
}

