/*
 * Decompiled with CFR 0.152.
 */
package sql.datagen;

import hydra.Log;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import sql.datagen.ColumnMetaData;
import sql.datagen.DataGenerator;
import sql.datagen.FKContraint;
import sql.datagen.FKMappedColumn;
import sql.datagen.MappedColumnInfo;
import sql.datagen.Mapper;
import sql.datagen.TableMetaData;
import util.TestException;

public class TableMetaDataGenerator {
    DataGenerator dagen = DataGenerator.getDataGenerator();
    Mapper mapper = this.dagen.getMapper();

    public TableMetaData generate(String fullTableName, int rows, String csvFile, Connection conn) {
        TableMetaData tableMeta = new TableMetaData(fullTableName);
        tableMeta.setCsvFileName(csvFile);
        tableMeta.setTotalRows(rows);
        String schemaName = null;
        String tableName = fullTableName;
        int schemaIndex = fullTableName.indexOf(46);
        if (schemaIndex >= 0) {
            schemaName = fullTableName.substring(0, schemaIndex);
            tableName = fullTableName.substring(schemaIndex + 1);
        }
        try {
            DatabaseMetaData meta = conn.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet rs = meta.getTables(null, schemaName, tableName, types);
            while (rs.next()) {
                if (tableName.equals(rs.getString("TABLE_NAME"))) continue;
                throw new RuntimeException("unexpected table name " + rs.getString("TABLE_NAME") + ", expected: " + tableName);
            }
            HashSet<String> primaryKeys = new HashSet<String>();
            ResultSet keyList = meta.getPrimaryKeys(null, schemaName, tableName);
            while (keyList.next()) {
                String pk = keyList.getString("COLUMN_NAME");
                primaryKeys.add(pk);
                tableMeta.addtoPKList(pk);
            }
            HashSet<String> uniqueKeys = new HashSet<String>();
            ResultSet uniqueList = meta.getIndexInfo(null, schemaName, tableName, true, false);
            while (uniqueList.next()) {
                String u = uniqueList.getString("COLUMN_NAME");
                if (primaryKeys.contains(u)) continue;
                uniqueKeys.add(u);
                tableMeta.addToUniqueList(u);
            }
            HashSet<String> importedKeys = new HashSet<String>();
            ResultSet importList = meta.getImportedKeys(null, schemaName, tableName);
            while (importList.next()) {
                String fktable = importList.getString("FKTABLE_NAME");
                String fkColumn = importList.getString("FKCOLUMN_NAME");
                String parentTable = importList.getString("PKTABLE_NAME");
                String parentCol = importList.getString("PKCOLUMN_NAME");
                FKContraint fk = new FKContraint(fktable, fkColumn, parentTable, parentCol);
                importedKeys.add(fk.toString());
                tableMeta.addToFKList(fk);
            }
            String s = (importedKeys.size() > 0 ? " Foreign Keys:" + importedKeys : "") + (uniqueKeys.size() > 0 ? " Unique Keys:" + uniqueKeys : "");
            Log.getLogWriter().info("Parsing Table:" + fullTableName + " with " + rows + " rows, primary key: " + primaryKeys + s);
            ResultSet rsColumns = meta.getColumns(null, schemaName, tableName, null);
            while (rsColumns.next()) {
                ColumnMetaData column = new ColumnMetaData();
                column.setFullTableName(fullTableName.trim().toUpperCase());
                column.setColumnName(rsColumns.getString("COLUMN_NAME").trim().toUpperCase());
                column.setDataType(rsColumns.getInt("DATA_TYPE"));
                column.setColumnSize(rsColumns.getInt("COLUMN_SIZE"));
                column.setDecimalDigits(rsColumns.getInt("DECIMAL_DIGITS"));
                MappedColumnInfo mappedCol = this.mapper.getColumnNameMapping().get(column.getFullColumnName());
                column.setMappedColumn(mappedCol);
                if (mappedCol instanceof FKMappedColumn) {
                    MappedColumnInfo parent = this.mapper.getColumnNameMapping().get(((FKMappedColumn)mappedCol).getFullFkParentColumn());
                    parent.setFKParent(true);
                }
                if (primaryKeys.contains(column.getColumnName())) {
                    column.setPrimary(true);
                }
                if (uniqueKeys.contains(column.getColumnName())) {
                    column.setUnique(true);
                }
                tableMeta.addColumns(column);
            }
        }
        catch (SQLException se) {
            throw new TestException(se.getMessage());
        }
        return tableMeta;
    }
}

