/*
 * Decompiled with CFR 0.152.
 */
package sql.dbCache;

import hydra.Log;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import sql.dbCache.DBCachePrms;
import util.TestException;

public class DBCacheTest
extends SQLTest {
    protected static DBCacheTest dbCacheTest;
    int lruCount = TestConfig.tab().intAt(DBCachePrms.lruCount, 100);

    public static synchronized void HydraTask_initialize() {
        if (dbCacheTest == null) {
            dbCacheTest = new DBCacheTest();
            dbCacheTest.initialize();
        }
    }

    public static synchronized void HydraTask_verifyLRUCount() {
        if (dbCacheTest == null) {
            dbCacheTest = new DBCacheTest();
        }
        dbCacheTest.verifyLRUCount();
    }

    protected void verifyLRUCount() {
        Connection gConn = this.getGFEConnection();
        String query = "SELECT COUNT(*) FROM trade.sellorders";
        try {
            PreparedStatement stmt = gConn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            rs.next();
            int num_row = rs.getInt(1);
            Log.getLogWriter().info("Number of rows in sellorders : " + num_row);
            if (num_row != this.lruCount && SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSellOrdersPrimary) > (long)(2 * this.lruCount)) {
                throw new TestException("Number of rows: " + num_row + " in sellorders table is not equal to LRUCount: " + this.lruCount);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.closeGFEConnection(gConn);
    }
}

