/*
 * Decompiled with CFR 0.152.
 */
package sql.ddlStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.ddlStatements.DDLStmtIF;
import sql.ddlStatements.FunctionDDLStmt;
import sql.ddlStatements.ProcedureDDLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class AuthorizationDDLStmt
implements DDLStmtIF {
    private static String[] tableNames = SQLPrms.getTableNames();
    private static HashMap<String, List<String>> tableCols = new HashMap();
    protected static ArrayList<String> procedureNames = null;
    protected static ArrayList<String> functionNames = null;
    protected static boolean usePublic = TestConfig.tab().booleanAt(SQLPrms.usePublicAsGrantees, false);
    private static String[] tablePriv;
    String[] action = new String[]{"grant ", "revoke "};
    String withGrantOption = " WITH GRANT OPTION ";
    private static boolean hasRoutine;

    @Override
    public void doDDLOp(Connection dConn, Connection gConn) {
        boolean success = false;
        int maxNumOfTries = 1;
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        String tableName = tableNames[SQLTest.random.nextInt(tableNames.length)];
        String routineName = hasRoutine ? this.getRoutineNames(dConn, gConn) : null;
        StringBuffer aStr = new StringBuffer();
        String act = this.action[SQLTest.random.nextInt(this.action.length)];
        aStr.append(act);
        if (routineName == null) {
            aStr.append(this.getAuthForTables(tableName, act));
        } else {
            aStr.append(SQLTest.random.nextBoolean() ? this.getAuthForTables(tableName, act) : this.getAuthForRoutines(routineName, act));
        }
        if (dConn != null) {
            try {
                success = this.applySecurityToDerby(dConn, aStr.toString(), exList);
                int count = 0;
                while (!success) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finish grant/revoke stmt, abort this operation");
                        return;
                    }
                    exList.clear();
                    success = this.applySecurityToDerby(dConn, aStr.toString(), exList);
                    ++count;
                }
                this.applySecurityToGFE(gConn, aStr.toString(), exList);
                SQLHelper.handleMissedSQLException(exList);
                gConn.commit();
                dConn.commit();
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                throw new TestException("execute security statement fails " + TestHelper.getStackTrace((Throwable)se));
            }
        }
        try {
            this.applySecurityToGFE(gConn, aStr.toString());
            gConn.commit();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("execute security statement fails " + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public void assignSelectToMe(Connection dConn, Connection gConn, int tid) {
        boolean success = false;
        int maxNumOfTries = 1;
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        String sql = "grant select on trade.buyorders to thr_" + tid;
        if (dConn != null) {
            try {
                success = this.applySecurityToDerby(dConn, sql, exList);
                int count = 0;
                while (!success) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finish grant/revoke stmt, abort this operation");
                        return;
                    }
                    exList.clear();
                    success = this.applySecurityToDerby(dConn, sql, exList);
                    ++count;
                }
                this.applySecurityToGFE(gConn, sql, exList);
                SQLHelper.handleMissedSQLException(exList);
                gConn.commit();
                dConn.commit();
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                throw new TestException("execute security statement fails " + TestHelper.getStackTrace((Throwable)se));
            }
        }
        try {
            this.applySecurityToGFE(gConn, sql);
            gConn.commit();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("execute security statement fails " + TestHelper.getStackTrace((Throwable)se));
        }
    }

    @Override
    public void createDDLs(Connection dConn, Connection gConn) {
    }

    protected String getRoutineNames(Connection dConn, Connection gConn) {
        int n = 10;
        if (SQLTest.random.nextInt(n) == 0) {
            return "function " + this.getFunctionName(dConn, gConn);
        }
        return "procedure " + this.getProcedureName(dConn, gConn);
    }

    protected synchronized String getProcedureName(Connection dConn, Connection gConn) {
        ResultSet rs = null;
        try {
            rs = gConn.getMetaData().getProcedures(null, null, null);
            List<Struct> procNames = ResultSetHelper.asList(rs, false);
            Log.getLogWriter().info("procedure names are " + ResultSetHelper.listToString(procNames));
            rs.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        try {
            rs = gConn.getMetaData().getFunctions(null, null, null);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        List<Struct> funcNames = ResultSetHelper.asList(rs, false);
        Log.getLogWriter().info("function names are " + ResultSetHelper.listToString(funcNames));
        if (procedureNames == null) {
            ArrayList<String> procs = new ArrayList<String>();
            procs.addAll(ProcedureDDLStmt.modifyProcNameList);
            procs.addAll(ProcedureDDLStmt.nonModifyProcNameList);
            procedureNames = new ArrayList(procs);
        }
        return procedureNames.get(SQLTest.random.nextInt(procedureNames.size()));
    }

    protected String getFunctionName(Connection dConn, Connection gConn) {
        if (functionNames == null) {
            functionNames = new ArrayList<String>(FunctionDDLStmt.functionNameList);
        }
        return functionNames.get(SQLTest.random.nextInt(functionNames.size()));
    }

    private String getAuthForTables(String tableName, String act) {
        StringBuffer aStr = new StringBuffer();
        if (SQLTest.random.nextBoolean()) {
            aStr.append("ALL PRIVILEGES ");
        } else {
            String privList = this.getPrivilegeLists(tableName);
            if (privList.equals(" ")) {
                Log.getLogWriter().info("did not get the privilege list");
                aStr.append("ALL PRIVILEGES ");
            } else {
                aStr.append(privList);
            }
        }
        if (act.contains("grant ")) {
            aStr.append(" on " + tableName + " to ");
        } else {
            aStr.append(" on " + tableName + " from ");
        }
        int num = SQLTest.random.nextInt(SQLTest.numOfWorkers) + 1;
        String grantees = null;
        grantees = usePublic ? (SQLTest.random.nextInt(100) == 0 ? AuthorizationDDLStmt.getGrantees(num) : " public ") : AuthorizationDDLStmt.getGrantees(num);
        aStr.append(grantees.equals(" ") ? "thr_0" : grantees);
        return aStr.toString();
    }

    private String getPrivilegeLists(String tableName) {
        StringBuffer aStr = new StringBuffer("  ");
        for (int i = 0; i < tablePriv.length; ++i) {
            if (!SQLTest.random.nextBoolean()) continue;
            aStr.append(tablePriv[i]);
            if (i > 2) {
                aStr.append(this.getColumnLists(tableName));
            }
            aStr.append(", ");
        }
        if (aStr.charAt(aStr.length() - 2) == ',') {
            aStr.deleteCharAt(aStr.length() - 2);
        }
        aStr.deleteCharAt(0);
        return aStr.toString();
    }

    private String getColumnLists(String tableName) {
        List<String> colNames = tableCols.get(tableName);
        StringBuffer aStr = new StringBuffer("  ");
        for (int i = 0; i < colNames.size(); ++i) {
            if (!SQLTest.random.nextBoolean()) continue;
            aStr.append(colNames.get(i) + ", ");
        }
        if (aStr.charAt(aStr.length() - 2) == ',') {
            aStr.deleteCharAt(aStr.length() - 2);
        }
        aStr.deleteCharAt(0);
        if (aStr.length() != 1) {
            aStr.insert(1, '(');
            aStr.append(')');
        }
        return aStr.toString();
    }

    private String getAuthForRoutines(String routineName, String act) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("EXECUTE ON ");
        if (act.contains("grant ")) {
            aStr.append(routineName + " to ");
        } else {
            aStr.append(routineName + " from ");
        }
        int num = SQLTest.random.nextInt(SQLTest.numOfWorkers) + 1;
        String grantees = null;
        grantees = usePublic ? (SQLTest.random.nextInt() == 0 ? AuthorizationDDLStmt.getGrantees(num) : " public ") : AuthorizationDDLStmt.getGrantees(num);
        aStr.append(grantees.equals(" ") ? "thr_0" : grantees);
        if (act.contains("revoke ")) {
            aStr.append(" restrict ");
        }
        return aStr.toString();
    }

    protected boolean applySecurityToDerby(Connection dConn, String sql, ArrayList<SQLException> exList) {
        Log.getLogWriter().info("execute authorization statement in derby");
        Log.getLogWriter().info("security statement is: " + sql);
        try {
            Statement stmt = dConn.createStatement();
            stmt.execute(sql);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                Log.getLogWriter().info("detected the deadlock, will try it again");
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void applySecurityToGFE(Connection gConn, String sql, ArrayList<SQLException> exList) {
        Log.getLogWriter().info("execute authorization statement in GFE");
        Log.getLogWriter().info("security statement is: " + sql);
        try {
            Statement stmt = gConn.createStatement();
            stmt.execute(sql);
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void applySecurityToGFE(Connection gConn, String sql) {
        Log.getLogWriter().info("execute authorization statement in GFE");
        Log.getLogWriter().info("security statement is: " + sql);
        try {
            Statement stmt = gConn.createStatement();
            stmt.execute(sql);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42506") && SQLTest.testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            if (se.getSQLState().equals("42509") && SQLTest.testSecurity) {
                Log.getLogWriter().info("Got the expected grant or revoke operation is not allowed exception for authorization, continuing tests");
            }
            if (se.getSQLState().equals("42Y03") && hasRoutine) {
                Log.getLogWriter().info("Got the expected not recognized as a function or procedure exception for authorization, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    public static void turnOnAuthorization(Connection dConn, Connection gConn) {
        String sql = "CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.database.sqlAuthorization', 'true')";
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (dConn != null) {
            AuthorizationDDLStmt.turnOnDerbyAuthorization(dConn, sql, exList);
            AuthorizationDDLStmt.turnOnGFEAuthorization(gConn, sql, exList);
            SQLHelper.handleMissedSQLException(exList);
        } else {
            AuthorizationDDLStmt.turnOnGFEAuthorization(gConn, sql);
        }
    }

    public static void turnOnDerbyAuthorization(Connection conn, String sql, ArrayList<SQLException> exList) {
        Log.getLogWriter().info("turn on authorization statement in derby");
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            conn.commit();
            ResultSet rs = stmt.executeQuery("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.sqlAuthorization')");
            rs.next();
            Log.getLogWriter().info("Value of sqlAuthorization is " + rs.getString(1));
            rs = stmt.executeQuery("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.defaultConnectionMode')");
            rs.next();
            Log.getLogWriter().info("Value of defaultConnectionMode is " + rs.getString(1));
            rs.close();
        }
        catch (SQLException se) {
            SQLHelper.handleDerbySQLException(se, exList);
        }
    }

    public static void turnOnGFEAuthorization(Connection conn, String sql, ArrayList<SQLException> exList) {
        Log.getLogWriter().info("turn on authorization statement in GFE");
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    public static void turnOnGFEAuthorization(Connection conn, String sql) {
        Log.getLogWriter().info("turn on authorization statement in GFE");
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public void provideAllPrivToAll(Connection dConn, Connection gConn) {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        for (int i = 0; i < tableNames.length; ++i) {
            Statement stmt;
            StringBuffer sql = new StringBuffer();
            sql.append("grant all privileges on " + tableNames[i] + " to " + AuthorizationDDLStmt.getAllGrantees());
            Log.getLogWriter().info("security statement is " + sql.toString());
            if (dConn != null) {
                try {
                    stmt = dConn.createStatement();
                    stmt.execute(sql.toString());
                    dConn.commit();
                    stmt.close();
                }
                catch (SQLException se) {
                    SQLHelper.handleDerbySQLException(se, exList);
                }
                try {
                    stmt = gConn.createStatement();
                    stmt.execute(sql.toString());
                    gConn.commit();
                    stmt.close();
                }
                catch (SQLException se) {
                    SQLHelper.handleGFGFXDException(se, exList);
                }
                continue;
            }
            try {
                stmt = gConn.createStatement();
                stmt.execute(sql.toString());
                gConn.commit();
                stmt.close();
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public void delegateGrantOption(Connection dConn, Connection gConn) {
        if (dConn != null) {
            for (int i = 0; i < tableNames.length; ++i) {
                this.delegateGrantOption(dConn, gConn, tableNames[i]);
            }
        } else {
            for (int i = 0; i < tableNames.length; ++i) {
                this.delegateGrantOption(gConn, tableNames[i]);
            }
        }
    }

    private void delegateGrantOption(Connection dConn, Connection gConn, String tableName) {
        Statement stmt;
        int num = SQLTest.random.nextInt(SQLTest.numOfWorkers) + 1;
        String grantees = AuthorizationDDLStmt.getGrantees(num);
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        StringBuffer sql = new StringBuffer();
        int whichPriv = SQLTest.random.nextInt(tablePriv.length);
        sql.append("grant " + tablePriv[whichPriv] + " on " + tableName + " to " + grantees + this.withGrantOption);
        Log.getLogWriter().info("security statement is " + sql.toString());
        try {
            stmt = dConn.createStatement();
            stmt.execute(sql.toString());
            dConn.commit();
            stmt.close();
        }
        catch (SQLException se) {
            SQLHelper.handleDerbySQLException(se, exceptionList);
        }
        try {
            stmt = gConn.createStatement();
            stmt.execute(sql.toString());
            gConn.commit();
            stmt.close();
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exceptionList);
        }
        SQLHelper.handleMissedSQLException(exceptionList);
    }

    private void delegateGrantOption(Connection gConn, String tableName) {
        int num = SQLTest.random.nextInt(SQLTest.numOfWorkers) + 1;
        String grantees = AuthorizationDDLStmt.getGrantees(num);
        StringBuffer sql = new StringBuffer();
        int whichPriv = SQLTest.random.nextInt(tablePriv.length);
        sql.append("grant " + tablePriv[whichPriv] + " on " + tableName + " to " + grantees + this.withGrantOption);
        Log.getLogWriter().info("security statement is " + sql.toString());
        try {
            Statement stmt = gConn.createStatement();
            stmt.execute(sql.toString());
            gConn.commit();
            stmt.close();
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42X01")) {
                Log.getLogWriter().info("Got expected exception as WITH GRANT OPTION is not supported yet, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    public void useDelegatedPrivilege(Connection dConn, Connection gConn) {
        if (dConn != null) {
            for (int i = 0; i < tableNames.length; ++i) {
                this.useDelegatedPrivilege(dConn, gConn, tableNames[i]);
            }
        } else {
            for (int i = 0; i < tableNames.length; ++i) {
                this.useDelegatedPrivilege(gConn, tableNames[i]);
            }
        }
    }

    private void useDelegatedPrivilege(Connection dConn, Connection gConn, String tableName) {
        Statement stmt;
        int num = SQLTest.random.nextInt(SQLTest.numOfWorkers) + 1;
        String grantees = AuthorizationDDLStmt.getGrantees(num);
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        StringBuffer sql = new StringBuffer();
        int whichPriv = SQLTest.random.nextInt(tablePriv.length);
        sql.append("grant " + tablePriv[whichPriv] + " on " + tableName + " to " + grantees);
        Log.getLogWriter().info("security statement is " + sql.toString());
        try {
            stmt = dConn.createStatement();
            stmt.execute(sql.toString());
            dConn.commit();
            stmt.close();
        }
        catch (SQLException se) {
            SQLHelper.handleDerbySQLException(se, exceptionList);
        }
        try {
            stmt = gConn.createStatement();
            stmt.execute(sql.toString());
            gConn.commit();
            stmt.close();
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exceptionList);
        }
        SQLHelper.handleMissedSQLException(exceptionList);
    }

    private void useDelegatedPrivilege(Connection gConn, String tableName) {
        int num = SQLTest.random.nextInt(SQLTest.numOfWorkers) + 1;
        String grantees = AuthorizationDDLStmt.getGrantees(num);
        StringBuffer sql = new StringBuffer();
        int whichPriv = SQLTest.random.nextInt(tablePriv.length);
        sql.append("grant " + tablePriv[whichPriv] + " on " + tableName + " to " + grantees);
        Log.getLogWriter().info("security statement is " + sql.toString());
        try {
            Statement stmt = gConn.createStatement();
            stmt.execute(sql.toString());
            gConn.commit();
            stmt.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public void revokeDelegatedPrivilege(Connection dConn, Connection gConn) {
        if (dConn != null) {
            for (int i = 0; i < tableNames.length; ++i) {
                this.revokeDelegatedPrivilege(dConn, gConn, tableNames[i]);
            }
        } else {
            for (int i = 0; i < tableNames.length; ++i) {
                this.revokeDelegatedPrivilege(gConn, tableNames[i]);
            }
        }
    }

    private void revokeDelegatedPrivilege(Connection dConn, Connection gConn, String tableName) {
        Statement stmt;
        int num = SQLTest.random.nextInt(SQLTest.numOfWorkers) + 1;
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        String grantees = AuthorizationDDLStmt.getGrantees(num);
        StringBuffer sql = new StringBuffer();
        int whichPriv = SQLTest.random.nextInt(tablePriv.length);
        sql.append("revoke " + tablePriv[whichPriv] + " on " + tableName + " from " + grantees);
        Log.getLogWriter().info("security statement is " + sql.toString());
        try {
            stmt = dConn.createStatement();
            stmt.execute(sql.toString());
            dConn.commit();
            stmt.close();
        }
        catch (SQLException se) {
            SQLHelper.handleDerbySQLException(se, exceptionList);
        }
        try {
            stmt = gConn.createStatement();
            stmt.execute(sql.toString());
            gConn.commit();
            stmt.close();
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exceptionList);
        }
    }

    private void revokeDelegatedPrivilege(Connection gConn, String tableName) {
        int num = SQLTest.random.nextInt(SQLTest.numOfWorkers) + 1;
        String grantees = AuthorizationDDLStmt.getGrantees(num);
        int whichPriv = SQLTest.random.nextInt(tablePriv.length);
        StringBuffer sql = new StringBuffer();
        sql.append("revoke " + tablePriv[whichPriv] + " on " + tableName + " from " + grantees);
        Log.getLogWriter().info("security statement is " + sql.toString());
        try {
            Statement stmt = gConn.createStatement();
            stmt.execute(sql.toString());
            gConn.commit();
            stmt.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private static String getAllGrantees() {
        StringBuffer aStr = new StringBuffer("  ");
        Map userPasswd = (Map)SQLBB.getBB().getSharedMap().get((Object)SQLSecurityTest.userPasswdMap);
        for (Map.Entry e : userPasswd.entrySet()) {
            if (((String)e.getKey()).equalsIgnoreCase("thr_" + RemoteTestModule.getCurrentThread().getThreadId())) continue;
            aStr.append((String)e.getKey() + ", ");
        }
        if (aStr.charAt(aStr.length() - 2) == ',') {
            aStr.deleteCharAt(aStr.length() - 2);
        }
        aStr.deleteCharAt(0);
        return aStr.toString();
    }

    private static String getGrantees(int num) {
        StringBuffer aStr = new StringBuffer("  ");
        Map userPasswd = (Map)SQLBB.getBB().getSharedMap().get((Object)SQLSecurityTest.userPasswdMap);
        userPasswd.remove("thr_" + RemoteTestModule.getCurrentThread().getThreadId());
        String[] users = new String[userPasswd.size()];
        userPasswd.keySet().toArray(users);
        for (int i = 0; i < num; ++i) {
            int x = SQLTest.random.nextInt(users.length);
            aStr.append(users[x] + ", ");
        }
        if (aStr.charAt(aStr.length() - 2) == ',') {
            aStr.deleteCharAt(aStr.length() - 2);
        }
        aStr.deleteCharAt(0);
        return aStr.toString();
    }

    private static String getGrantee() {
        return AuthorizationDDLStmt.getGrantees(1);
    }

    static {
        tableCols.putAll((Map)SQLBB.getBB().getSharedMap().get((Object)"tableCols"));
        tablePriv = new String[]{"delete", "insert", "trigger", "References ", "select", "update"};
        hasRoutine = TestConfig.tab().booleanAt(SQLPrms.hasRoutineInSecurityTest, false);
    }
}

