/*
 * Decompiled with CFR 0.152.
 */
package sql.ddlStatements;

import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.ddlStatements.DDLStmtIF;
import sql.sqlDAP.DAProcedures;
import sql.sqlDAP.SQLDAPPrms;
import sql.sqlDAP.SQLDAPTest;

public class DAPDDLStmt
implements DDLStmtIF {
    public static HashMap<String, String> derbyNonModifyProcMap = new HashMap();
    public static HashMap<String, String> gfxdNonModifyProcMap = new HashMap();
    public static ArrayList<String> derbyNonModifyProcNameList = new ArrayList();
    public static ArrayList<String> gfxdNonModifyProcNameList = new ArrayList();
    public static HashMap<String, String> derbyModifyProcMap = new HashMap();
    public static ArrayList<String> derbyModifyProcNameList = new ArrayList();
    public static HashMap<String, String> gfxdModifyProcMap = new HashMap();
    public static ArrayList<String> gfxdModifyProcNameList = new ArrayList();
    protected static boolean hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
    protected static boolean cidByRange = TestConfig.tab().booleanAt(SQLDAPPrms.cidByRange, true);
    protected static boolean testServerGroupsInheritence = TestConfig.tab().booleanAt(SQLPrms.testServerGroupsInheritence, false);
    public static boolean updateWrongSG = TestConfig.tab().booleanAt(SQLDAPPrms.updateWrongSG, false);
    public static boolean testCustomProcessor = TestConfig.tab().booleanAt(SQLDAPPrms.testCustomProcessor, false);
    static boolean concurrentDropDAPOp = SQLDAPTest.concurrentDropDAPOp;
    static String showDerbyBuyorders = "create procedure trade.showDerbyBuyorders(IN DP1 Integer, IN DP2 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'sql.sqlDAP.DerbyDAPTest.selectDerbyBuyordersByTidList'";
    static String showGfxdBuyorders = "create procedure trade.showGfxdBuyorders(IN DP1 Integer, IN DP2 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'sql.sqlDAP.DAPTest.selectGfxdBuyordersByTidList'";
    static String getListOfDerbyBuyorders = "create procedure trade.getListOfDerbybuyorders(IN DP1 Integer, IN DP2 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'sql.sqlDAP.DerbyDAPTest.selectDerbyBuyordersByTidList'";
    static String getListOfGfxdBuyorders = "create procedure trade.getListOfGfxdbuyorders(IN DP1 Integer, IN DP2 Integer, OUT DP3 Object) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA EXTERNAL NAME 'sql.sqlDAP.DAPTest.getListOfGfxdBuyordersByTidList'";
    static String showDerbyPortfolio = "create procedure trade.showDerbyPortfolio(IN DP1 Integer, IN DP2 Integer, IN DP3 Integer, IN DP4 Integer, OUT DP5 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 4 EXTERNAL NAME 'sql.sqlDAP.DerbyDAPTest.selectDerbyPortfolioByCidRange'";
    static String showGfxdPortfolio = "create procedure trade.showGfxdPortfolio(IN DP1 Integer, IN DP2 Integer, IN DP3 Integer, IN DP4 Integer, OUT DP5 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 4 EXTERNAL NAME 'sql.sqlDAP.DAPTest.selectGfxdPortfolioByCidRange'";
    static String updateGfxdPortfolioWrongSG = "create procedure trade.updateGfxdPortfolioWrongSG(IN DP1 DECIMAL, IN DP2 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA MODIFIES SQL DATA EXTERNAL NAME 'sql.sqlDAP.DAPTest.updateGfxdPortfolioWrongSG'";
    static String updateDerbyPortfolioWrongSG = "create procedure trade.updateDerbyPortfolioWrongSG(IN DP1 DECIMAL, IN DP2 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA MODIFIES SQL DATA EXTERNAL NAME 'sql.sqlDAP.DAPTest.updateDerbyPortfolioWrongSG'";
    static String updateDerbyPortfolioByCidRange = "create procedure trade.updateDerbyPortfolioByCidRange(IN DP1 Integer, IN DP2 Integer, IN DP3 DECIMAL(30, 20), IN DP4 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA Modifies SQL DATA EXTERNAL NAME 'sql.sqlDAP.DerbyDAPTest.updateDerbyPortfolioByCidRange'";
    static String updateGfxdPortfolioByCidRange = "create procedure trade.updateGfxdPortfolioByCidRange(IN DP1 Integer, IN DP2 Integer, IN DP3 DECIMAL(30, 20), IN DP4 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA Modifies SQL DATA EXTERNAL NAME 'sql.sqlDAP.DAPTest.updateGfxdPortfolioByCidRange'";
    static String updateDerbySellordersSG = "create procedure trade.updateDerbySellordersSG(IN DP1 TIMESTAMP, IN DP2 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA Modifies SQL DATA EXTERNAL NAME 'sql.sqlDAP.DerbyDAPTest.updateDerbySellordersSG'";
    static String updateGfxdSellordersSG = "create procedure trade.updateGfxdSellordersSG(IN DP1 TIMESTAMP, IN DP2 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA Modifies SQL DATA EXTERNAL NAME 'sql.sqlDAP.DAPTest.updateGfxdSellordersSG'";
    static String customDerbyProc = "create procedure trade.customDerbyProc(IN DP1 Integer, IN DP2 Integer, IN DP3 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 2 EXTERNAL NAME 'sql.sqlDAP.DerbyDAPTest.customDerbyProc'";
    static String customGfxdProc = "create procedure trade.customGfxdProc(IN DP1 Integer, IN DP2 Integer, IN DP3 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 3 EXTERNAL NAME 'sql.sqlDAP.DAPTest.customGfxdProc'";
    public static final String SHOWDERBYBUYORDERS = "trade.showDerbyBuyorders";
    public static final String SHOWGFXDBUYORDERS = "trade.showGfxdBuyorders";
    public static final String GETLISTOFGFXDBUYORDERS = "trade.getListOfGfxdbuyorders";
    public static final String GETLISTOFDERBYBUYORDERS = "trade.getListOfDerbybuyorders";
    public static final String SHOWDERBYPORTFOLIO = "trade.showDerbyPortfolio";
    public static final String SHOWGFXDPORTFOLIO = "trade.showGfxdPortfolio";
    public static final String UPDATGFXDFPORTFOLIOWRONGSG = "trade.updateGfxdPortfolioWrongSG";
    public static final String UPDATEDERBYPORTFOLIOWRONGSG = "trade.updateDerbyPortfolioWrongSG";
    public static final String UPDATEDERBYPORTFOLIO = "trade.updateDerbyPortfolioByCidRange";
    public static final String UPDATGFXDFPORTFOLIO = "trade.updateGfxdPortfolioByCidRange";
    public static final String UPDATEDERBYSELLORDERSSG = "trade.updateDerbySellordersSG";
    public static final String UPDATGFXDFSELLORDERSSG = "trade.updateGfxdSellordersSG";
    public static final String CUSTOMGFXDPROC = "trade.customGfxdProc";
    public static final String CUSTOMDERBYPROC = "trade.customDerbyProc";

    @Override
    public void createDDLs(Connection dConn, Connection gConn) {
        String gfxdProc;
        String derbyProc;
        int i;
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        for (i = 0; i < gfxdModifyProcNameList.size(); ++i) {
            derbyProc = derbyModifyProcMap.get(derbyModifyProcNameList.get(i));
            gfxdProc = gfxdModifyProcMap.get(gfxdModifyProcNameList.get(i));
            if (dConn != null) {
                if (derbyProc != null) {
                    this.exeDerbyProcedure(dConn, derbyProc, exList);
                }
                this.exeGfxdProcedure(gConn, gfxdProc, exList);
                SQLHelper.handleMissedSQLException(exList);
                continue;
            }
            this.exeGfxdProcedure(gConn, gfxdProc);
        }
        for (i = 0; i < derbyNonModifyProcNameList.size(); ++i) {
            derbyProc = derbyNonModifyProcMap.get(derbyNonModifyProcNameList.get(i));
            gfxdProc = gfxdNonModifyProcMap.get(gfxdNonModifyProcNameList.get(i));
            if (dConn != null) {
                this.exeDerbyProcedure(dConn, derbyProc, exList);
                this.exeGfxdProcedure(gConn, gfxdProc, exList);
                SQLHelper.handleMissedSQLException(exList);
                continue;
            }
            this.exeGfxdProcedure(gConn, gfxdProc);
        }
    }

    protected boolean exeDerbyProcedure(Connection dConn, String procedure, ArrayList<SQLException> exList) {
        Log.getLogWriter().info("try to " + procedure + " in derby");
        try {
            this.exeProcedure(dConn, procedure);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void exeGfxdProcedure(Connection gConn, String procedure, ArrayList<SQLException> exList) {
        Log.getLogWriter().info("try to " + procedure + " in gfxd");
        try {
            this.exeProcedure(gConn, procedure);
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void exeGfxdProcedure(Connection gConn, String procedure) {
        Log.getLogWriter().info("try to " + procedure + " in gfxd if exists");
        try {
            this.exeProcedure(gConn, procedure);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42Y55") || se.getSQLState().equals("42X94")) {
                Log.getLogWriter().info("expected procedrue does not exist exception, continuing test");
            }
            if (se.getSQLState().equals("X0Y68")) {
                Log.getLogWriter().info("expected procedrue already exist exception, continuing test");
            }
            if (se.getSQLState().equals("42507") && SQLTest.testSecurity) {
                Log.getLogWriter().info("expected authorization exception, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void exeProcedure(Connection conn, String procedure) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate(procedure);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
    }

    @Override
    public void doDDLOp(Connection dConn, Connection gConn) {
        int whichProc = 0;
        String derbyProc = null;
        String derbyProcName = null;
        String gfxdProc = null;
        String gfxdProcName = null;
        whichProc = SQLTest.random.nextInt(derbyNonModifyProcNameList.size());
        derbyProc = derbyNonModifyProcMap.get(derbyNonModifyProcNameList.get(whichProc));
        derbyProcName = derbyNonModifyProcNameList.get(whichProc);
        gfxdProc = gfxdNonModifyProcMap.get(gfxdNonModifyProcNameList.get(whichProc));
        gfxdProcName = gfxdNonModifyProcNameList.get(whichProc);
        if (hasDerbyServer && concurrentDropDAPOp) {
            if (!DAProcedures.doOp(gfxdProcName)) {
                Log.getLogWriter().info("Other threads are performing op on the procedure " + gfxdProcName + ", abort this operation");
                return;
            }
            this.doConcurrentDAPOp(dConn, gConn, derbyProc, derbyProcName, gfxdProc, gfxdProcName);
            DAProcedures.zeroCounter(gfxdProcName);
        } else {
            this.doConcurrentDAPOp(dConn, gConn, derbyProc, derbyProcName, gfxdProc, gfxdProcName);
        }
    }

    protected void doConcurrentDAPOp(Connection dConn, Connection gConn, String derbyProc, String derbyProcName, String gfxdProc, String gfxdProcName) {
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        int choice = 3;
        int op = SQLTest.random.nextInt(choice);
        if (op == 0 || op == 1) {
            String dropDerbyStatement = "drop procedure " + derbyProcName;
            String dropGfxdStatement = "drop procedure " + gfxdProcName;
            if (dConn != null) {
                if (!this.exeDerbyProcedure(dConn, dropDerbyStatement, exceptionList) && concurrentDropDAPOp) {
                    DAProcedures.zeroCounter(gfxdProcName);
                    return;
                }
                this.exeGfxdProcedure(gConn, dropGfxdStatement, exceptionList);
                SQLHelper.handleMissedSQLException(exceptionList);
            } else {
                this.exeGfxdProcedure(gConn, dropGfxdStatement);
            }
        }
        if (op == 1 || op == 2) {
            if (dConn != null) {
                if (!this.exeDerbyProcedure(dConn, derbyProc, exceptionList) && concurrentDropDAPOp) {
                    DAProcedures.zeroCounter(gfxdProcName);
                    return;
                }
                this.exeGfxdProcedure(gConn, gfxdProc, exceptionList);
                SQLHelper.handleMissedSQLException(exceptionList);
            } else {
                this.exeGfxdProcedure(gConn, gfxdProc);
            }
        }
    }

    static {
        derbyNonModifyProcNameList.add(SHOWDERBYBUYORDERS);
        derbyNonModifyProcMap.put(SHOWDERBYBUYORDERS, showDerbyBuyorders);
        gfxdNonModifyProcNameList.add(SHOWGFXDBUYORDERS);
        gfxdNonModifyProcMap.put(SHOWGFXDBUYORDERS, showGfxdBuyorders);
        derbyNonModifyProcMap.put(GETLISTOFGFXDBUYORDERS, getListOfDerbyBuyorders);
        gfxdNonModifyProcMap.put(GETLISTOFGFXDBUYORDERS, getListOfGfxdBuyorders);
        if (cidByRange) {
            derbyNonModifyProcNameList.add(SHOWDERBYPORTFOLIO);
            derbyNonModifyProcMap.put(SHOWDERBYPORTFOLIO, showDerbyPortfolio);
            gfxdNonModifyProcNameList.add(SHOWGFXDPORTFOLIO);
            gfxdNonModifyProcMap.put(SHOWGFXDPORTFOLIO, showGfxdPortfolio);
        }
        if (testCustomProcessor) {
            gfxdNonModifyProcNameList.add(CUSTOMGFXDPROC);
            gfxdNonModifyProcMap.put(CUSTOMGFXDPROC, customGfxdProc);
            derbyNonModifyProcNameList.add(CUSTOMDERBYPROC);
            derbyNonModifyProcMap.put(CUSTOMDERBYPROC, customDerbyProc);
        }
        if (testServerGroupsInheritence) {
            if (updateWrongSG) {
                gfxdModifyProcNameList.add(UPDATGFXDFPORTFOLIOWRONGSG);
                gfxdModifyProcMap.put(UPDATGFXDFPORTFOLIOWRONGSG, updateGfxdPortfolioWrongSG);
                derbyModifyProcNameList.add(UPDATEDERBYPORTFOLIOWRONGSG);
                derbyModifyProcMap.put(UPDATEDERBYPORTFOLIOWRONGSG, updateDerbyPortfolioWrongSG);
            }
            gfxdModifyProcNameList.add(UPDATGFXDFSELLORDERSSG);
            gfxdModifyProcMap.put(UPDATGFXDFSELLORDERSSG, updateGfxdSellordersSG);
            derbyModifyProcNameList.add(UPDATEDERBYSELLORDERSSG);
            derbyModifyProcMap.put(UPDATEDERBYSELLORDERSSG, updateDerbySellordersSG);
        }
        derbyModifyProcNameList.add(UPDATEDERBYPORTFOLIO);
        derbyModifyProcMap.put(UPDATEDERBYPORTFOLIO, updateDerbyPortfolioByCidRange);
        gfxdModifyProcNameList.add(UPDATGFXDFPORTFOLIO);
        gfxdModifyProcMap.put(UPDATGFXDFPORTFOLIO, updateGfxdPortfolioByCidRange);
    }
}

