/*
 * Decompiled with CFR 0.152.
 */
package sql.ddlStatements;

import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import sql.SQLHelper;
import sql.SQLTest;
import sql.ddlStatements.DDLStmtIF;
import sql.ddlStatements.Procedures;
import util.TestException;

public class FunctionDDLStmt
implements DDLStmtIF {
    static String portfolio = "create function trade.funcPortf(DP1 Integer) RETURNS TABLE (   cid int, sid int, qty int, availQty int, subTotal decimal(30,20), tid int ) PARAMETER STYLE DERBY_JDBC_RESULT_SET LANGUAGE JAVA READS SQL DATA EXTERNAL NAME 'sql.FunctionTest.readPortfolioDerby'";
    static String multiply = "create function trade.multiply(DP1 Decimal (30, 20) ) RETURNS DECIMAL (30, 20) PARAMETER STYLE JAVA LANGUAGE JAVA NO SQL EXTERNAL NAME 'sql.FunctionTest.multiply'";
    static String maxCid = "create function trade.maxCid(DP1 Integer) RETURNS INTEGER PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA EXTERNAL NAME 'sql.FunctionTest.getMaxCid'";
    public static HashMap<String, String> functionMap = new HashMap();
    public static ArrayList<String> functionNameList = new ArrayList();
    protected static boolean hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
    protected boolean dropFunc = SQLTest.dropFunc;

    private String findProcedureName(String funcName) {
        if (funcName.equals("trade.multiply")) {
            return "trade.addInterest";
        }
        throw new TestException("incorrect funcName is used");
    }

    @Override
    public void doDDLOp(Connection dConn, Connection gConn) {
        int chance = 1000;
        if (!this.dropFunc || SQLTest.random.nextInt(chance) != 1) {
            Log.getLogWriter().info("will not perform drop function");
            return;
        }
        int whichFunction = 0;
        String function = null;
        String functionName = null;
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        whichFunction = SQLTest.random.nextInt(functionNameList.size());
        function = functionMap.get(functionNameList.get(whichFunction));
        functionName = functionNameList.get(whichFunction);
        if (hasDerbyServer && !Procedures.doOp(this.findProcedureName(functionName))) {
            Log.getLogWriter().info("Other threads are performing op using the function " + functionName + ", abort this operation");
            return;
        }
        int choice = 3;
        int op = SQLTest.random.nextInt(choice);
        if (op == 0 || op == 1) {
            String dropStatement = "drop function " + functionName;
            if (dConn != null) {
                if (!this.exeDerbyFunction(dConn, dropStatement, exceptionList)) {
                    Procedures.zeroCounter(this.findProcedureName(functionName));
                    return;
                }
                if (!this.exeDerbyFunction(dConn, function, exceptionList)) {
                    Procedures.zeroCounter(this.findProcedureName(functionName));
                    try {
                        dConn.rollback();
                        Log.getLogWriter().info("roll back the ops");
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    return;
                }
                this.exeGFEFunction(gConn, dropStatement, exceptionList);
                this.exeGFEFunction(gConn, function, exceptionList);
                SQLHelper.handleMissedSQLException(exceptionList);
            } else {
                this.exeGFEFunction(gConn, dropStatement);
            }
        }
        if (op == 2) {
            if (dConn != null) {
                if (!this.exeDerbyFunction(dConn, function, exceptionList)) {
                    Procedures.zeroCounter(this.findProcedureName(functionName));
                    return;
                }
                this.exeGFEFunction(gConn, function, exceptionList);
                SQLHelper.handleMissedSQLException(exceptionList);
            } else {
                this.exeGFEFunction(gConn, function);
            }
        }
        if (hasDerbyServer) {
            Procedures.zeroCounter(this.findProcedureName(functionName));
        }
    }

    protected boolean exeDerbyFunction(Connection dConn, String function, ArrayList<SQLException> exList) {
        Log.getLogWriter().info("try to " + function + " in derby");
        try {
            this.exeFunction(dConn, function);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void exeGFEFunction(Connection gConn, String function, ArrayList<SQLException> exList) {
        Log.getLogWriter().info("try to " + function + " in gfe");
        try {
            this.exeFunction(gConn, function);
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void exeGFEFunction(Connection gConn, String function) {
        Log.getLogWriter().info("try to " + function + " in gfe if exists");
        try {
            this.exeFunction(gConn, function);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42Y55") || se.getSQLState().equals("42X94")) {
                Log.getLogWriter().info("expected function does not exist exception, continuing test");
            }
            if (se.getSQLState().equals("X0Y68")) {
                Log.getLogWriter().info("expected function already exist exception, continuing test");
            }
            if (se.getSQLState().equals("42507") && SQLTest.testSecurity) {
                Log.getLogWriter().info("expected authorization exception, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void exeFunction(Connection conn, String function) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate(function);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
    }

    @Override
    public void createDDLs(Connection dConn, Connection gConn) {
    }

    public static void createFuncMultiply(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        Statement stmt = conn.createStatement();
        stmt.executeUpdate(multiply);
        Log.getLogWriter().info("executed " + multiply);
    }

    public static void createFuncMaxCid(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        Statement stmt = conn.createStatement();
        stmt.executeUpdate(maxCid);
        Log.getLogWriter().info("executed " + maxCid);
    }

    public static void createFuncPortf(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate(portfolio);
        Log.getLogWriter().info("executed " + portfolio);
    }

    public static void dropFuncPortf(Connection conn) throws SQLException {
        String dropFuncPortf = "drop function trade.funcPortf";
        Statement stmt = conn.createStatement();
        stmt.executeUpdate(dropFuncPortf);
        Log.getLogWriter().info("executed " + dropFuncPortf);
    }

    static {
        functionNameList.add("trade.multiply");
        functionMap.put("trade.multiply", multiply);
    }
}

