/*
 * Decompiled with CFR 0.152.
 */
package sql.ddlStatements;

import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.ddlStatements.DDLStmtIF;
import sql.mbeans.listener.CallBackListener;

public class IndexDDLStmt
implements DDLStmtIF {
    protected static final Random rand = SQLTest.random;
    protected static String[] sort = new String[]{"asc ", "desc ", " "};
    protected static String[] types = new String[]{"global hash "};
    protected static HashMap<String, List<String>> tableCols = new HashMap();
    protected static boolean[] setTableCols = new boolean[]{false};
    protected static String[] tables = SQLPrms.getTableNames();
    protected static ArrayList<String> indexList = new ArrayList();
    protected static boolean dropIndex = TestConfig.tab().booleanAt(SQLPrms.dropIndex, false);
    protected static int minNumIndex = 8;
    protected static int maxNumIndex = 12;
    protected static IndexDDLStmt instance = new IndexDDLStmt();
    protected static boolean renameIndex = TestConfig.tab().booleanAt(SQLPrms.renameIndex, false);
    protected static boolean isOfflineTest = TestConfig.tab().booleanAt(SQLPrms.isOfflineTest, false);
    protected static boolean testUniqIndex = SQLTest.testUniqIndex;
    private static long lastDDLOpTime = 0L;
    private static int waitPeriod = 3;
    private static String lastIndexOpTime = "lastIndexOpTime";
    private static boolean portfoliov1IsReady = false;
    private static String portfoliov1 = "portfoliov1";
    private static boolean hasPortfolioV1 = SQLTest.hasPortfolioV1;
    private List<CallBackListener> listeners = new ArrayList<CallBackListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDDLOp(Connection dConn, Connection gConn) {
        long now;
        Object lastUpdateTime;
        if (!RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString().equalsIgnoreCase("INITTASK")) {
            if (!SQLTest.allowConcDDLDMLOps) {
                Log.getLogWriter().info("This test does not run with concurrent ddl with dml ops, abort the op");
                return;
            }
            if (SQLTest.limitConcDDLOps) {
                if (!this.perfDDLOp()) {
                    Log.getLogWriter().info("Does not meet criteria to perform concurrent ddl right now, abort the op");
                    return;
                }
                lastUpdateTime = (Long)SQLBB.getBB().getSharedMap().get((Object)lastIndexOpTime);
                if (lastUpdateTime != null) {
                    now = System.currentTimeMillis();
                    lastDDLOpTime = (Long)lastUpdateTime;
                    Log.getLogWriter().info(lastIndexOpTime + " currently is set to " + lastDDLOpTime / 60000L);
                    if (now - lastDDLOpTime < (long)(waitPeriod * 60 * 1000)) {
                        SQLBB.getBB().getSharedCounters().zero(SQLBB.perfLimitedIndexDDL);
                        return;
                    }
                }
            }
            Log.getLogWriter().info("performing conuccrent index op in main task");
        }
        lastUpdateTime = setTableCols;
        synchronized (setTableCols) {
            if (!setTableCols[0]) {
                IndexDDLStmt.getTableColsFromBB();
            }
            // ** MonitorExit[lastUpdateTime] (shouldn't be in output)
            int numIndex = 1;
            if (dropIndex && indexList.size() >= minNumIndex) {
                this.dropIndex(gConn);
            } else if (renameIndex && SQLTest.random.nextBoolean()) {
                this.renameIndex(gConn);
            } else {
                this.createIndex(gConn, numIndex);
            }
            if (!RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString().equalsIgnoreCase("INITTASK") && SQLTest.limitConcDDLOps) {
                now = System.currentTimeMillis();
                SQLBB.getBB().getSharedMap().put((Object)lastIndexOpTime, (Object)now);
                lastDDLOpTime = now;
                SQLBB.getBB().getSharedCounters().zero(SQLBB.perfLimitedIndexDDL);
            }
            return;
        }
    }

    private boolean perfDDLOp() {
        long now;
        if (lastDDLOpTime == 0L) {
            Long lastUpdateTime = (Long)SQLBB.getBB().getSharedMap().get((Object)lastIndexOpTime);
            if (lastUpdateTime == null) {
                return this.checkBBForDDLOp();
            }
            lastDDLOpTime = lastUpdateTime;
        }
        if ((now = System.currentTimeMillis()) - lastDDLOpTime < (long)(waitPeriod * 60 * 1000)) {
            return false;
        }
        lastDDLOpTime = (Long)SQLBB.getBB().getSharedMap().get((Object)lastIndexOpTime);
        if (now - lastDDLOpTime < (long)(waitPeriod * 60 * 1000)) {
            return false;
        }
        return this.checkBBForDDLOp();
    }

    private boolean checkBBForDDLOp() {
        int perfLimitedConcDDL = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.perfLimitedIndexDDL);
        return perfLimitedConcDDL == 1;
    }

    public static void doDerbyIndexOp(Connection dConn) {
        Statement stmt;
        SQLWarning warning;
        Statement stmt2;
        String createIndexStmt1 = "create index indexName1 on trade.customers (cust_name) ";
        String createIndexStmt2 = "create index indexName2 on trade.customers (cust_name) ";
        try {
            stmt2 = dConn.createStatement();
            Log.getLogWriter().info("creating index statement is " + createIndexStmt1);
            stmt2.executeUpdate(createIndexStmt1);
            warning = stmt2.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        try {
            stmt2 = dConn.createStatement();
            Log.getLogWriter().info("creating index statement is " + createIndexStmt2);
            stmt2.executeUpdate(createIndexStmt2);
            warning = stmt2.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        String dropIndexStmt = "drop index indexName2";
        try {
            stmt = dConn.createStatement();
            Log.getLogWriter().info("removing index statement is " + dropIndexStmt);
            stmt.executeUpdate(dropIndexStmt);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42X65")) {
                Log.getLogWriter().info("got index name does not exist exception");
            }
            SQLHelper.handleSQLException(se);
        }
        dropIndexStmt = "drop index indexName1";
        try {
            stmt = dConn.createStatement();
            Log.getLogWriter().info("removing index statement is " + dropIndexStmt);
            stmt.executeUpdate(dropIndexStmt);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42X65")) {
                Log.getLogWriter().info("got index name does not exist exception");
            }
            SQLHelper.handleSQLException(se);
        }
        dropIndexStmt = "drop index trade.indexName2";
        try {
            stmt = dConn.createStatement();
            Log.getLogWriter().info("removing index statement is " + dropIndexStmt);
            stmt.executeUpdate(dropIndexStmt);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42X65")) {
                Log.getLogWriter().info("got index name does not exist exception");
            }
            SQLHelper.handleSQLException(se);
        }
        dropIndexStmt = "drop index trade.indexName1";
        try {
            stmt = dConn.createStatement();
            Log.getLogWriter().info("removing index statement is " + dropIndexStmt);
            stmt.executeUpdate(dropIndexStmt);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected static synchronized void getTableColsFromBB() {
        tableCols.putAll((Map)SQLBB.getBB().getSharedMap().get((Object)"tableCols"));
        IndexDDLStmt.setTableCols[0] = true;
    }

    public static void createUniqIndex(Connection conn) {
        if (!testUniqIndex || SQLTest.hasCompanies) {
            Log.getLogWriter().info("unique index will not be created");
            return;
        }
        String createIndexStmt = "create unique index uniqIndex_" + RemoteTestModule.getCurrentThread().getThreadId() + " on trade.securities (symbol asc, exchange desc)";
        try {
            Statement stmt = conn.createStatement();
            Log.getLogWriter().info("creating index statement is " + createIndexStmt);
            stmt.executeUpdate(createIndexStmt);
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void createIndex(Connection conn, int num) {
        for (int i = 0; i < num; ++i) {
            this.createIndex(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createIndex(Connection conn) {
        Boolean value;
        if (hasPortfolioV1 && !portfoliov1IsReady && (value = (Boolean)SQLBB.getBB().getSharedMap().get((Object)"portfoliov1IsReady")) != null) {
            portfoliov1IsReady = value;
            IndexDDLStmt.getTableColsFromBB();
        }
        int maxCol = 2;
        Set<String> tableNames = tableCols.keySet();
        String tableName = (String)tableNames.toArray()[rand.nextInt(tableNames.size())];
        if (hasPortfolioV1 && tableName.toLowerCase().contains(portfoliov1) && !portfoliov1IsReady) {
            tableName = "portfolio";
        }
        Log.getLogWriter().info("portfoliov1IsReady is " + portfoliov1IsReady);
        Log.getLogWriter().info("table name  is " + tableName);
        List<String> colNames = tableCols.get(tableName);
        int whichCol = rand.nextInt(colNames.size());
        int whichCol2 = (whichCol + 1) % colNames.size();
        int numOfCols = 1;
        int createIndexOnMultiCol = 10;
        if (rand.nextInt(createIndexOnMultiCol) == 0) {
            numOfCols = maxCol;
        }
        ArrayList<String> arrayList = indexList;
        synchronized (arrayList) {
            if (indexList.size() > maxNumIndex) {
                Log.getLogWriter().info("index created in this vm is " + indexList.size() + " which is more than " + maxNumIndex + " now, will not create index this time.");
                return;
            }
        }
        String type = " ";
        long count = SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.indexCount);
        String indexName = "index_" + count;
        int createTypeIndex = 10;
        if (rand.nextInt(createTypeIndex) == 0) {
            type = types[rand.nextInt(types.length)];
            numOfCols = rand.nextInt(maxCol);
        }
        String cols = colNames.get(whichCol) + " " + sort[rand.nextInt(sort.length)];
        if (numOfCols == 2) {
            cols = cols + " ," + colNames.get(whichCol2) + " " + sort[rand.nextInt(sort.length)];
        }
        String createIndexStmt = "create  index " + indexName + " on " + tableName + " ( " + cols + " ) ";
        try {
            Statement stmt = conn.createStatement();
            Log.getLogWriter().info("creating index statement is " + createIndexStmt);
            stmt.executeUpdate(createIndexStmt);
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            } else {
                ArrayList<String> arrayList2 = indexList;
                synchronized (arrayList2) {
                    indexList.add(indexName);
                    this.executeListeners("CREATE_INDEX", indexName, tableName);
                }
                Log.getLogWriter().info("index created for the statement: " + createIndexStmt);
            }
            conn.commit();
            this.executeListeners("CONN_COMMIT", new Object[0]);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("23505") && type.equalsIgnoreCase("unique ")) {
                Log.getLogWriter().info("Got the expected exception creating unique index, continuing test");
            }
            if (se.getSQLState().equalsIgnoreCase("XSAS3") && type.equalsIgnoreCase("global hash ") && !sort.equals(" ")) {
                Log.getLogWriter().info("Got the expected exception creating global hash index with sort, continuing test");
            }
            if ((se.getSQLState().equalsIgnoreCase("X0Z08") || se.getSQLState().equalsIgnoreCase("X0Z01")) && isOfflineTest) {
                Log.getLogWriter().info("Got the expected exception during creating index when no nodes are available, continuing test");
            }
            if (se.getSQLState().equalsIgnoreCase("X0X67")) {
                Log.getLogWriter().info("Got the expected exception during creating index on BLOB field, continuing test");
            }
            if (se.getSQLState().equalsIgnoreCase("42Y62") && hasPortfolioV1 && portfoliov1IsReady) {
                Log.getLogWriter().info("Got the expected exception not able to create index on a view, continuing test");
            }
            if (SQLTest.setTx && SQLHelper.gotTXNodeFailureException(se)) {
                Log.getLogWriter().info("Got the expected node failure exception with txn, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    private void executeListeners(String listenerName, Object ... params) {
        for (CallBackListener listener : this.listeners) {
            if (!listenerName.equals(listener.getName())) continue;
            listener.execute(params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropIndex(Connection conn) {
        String indexName;
        ArrayList<String> arrayList = indexList;
        synchronized (arrayList) {
            if (indexList.size() == 0) {
                return;
            }
            indexName = "trade." + indexList.remove(rand.nextInt(indexList.size()));
        }
        String dropIndexStmt = "drop index " + indexName;
        try {
            Statement stmt = conn.createStatement();
            Log.getLogWriter().info("removing index statement is " + dropIndexStmt);
            stmt.executeUpdate(dropIndexStmt);
            Log.getLogWriter().info("index removed for the statement: " + dropIndexStmt);
            this.executeListeners("DROP_INDEX", indexName);
        }
        catch (SQLException se) {
            if ((se.getSQLState().equalsIgnoreCase("X0Z08") || se.getSQLState().equalsIgnoreCase("X0Z01")) && isOfflineTest) {
                Log.getLogWriter().info("Got the expected exception during dropping index when no nodes are available, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renameIndex(Connection conn) {
        String newIndexName;
        String indexName;
        ArrayList<String> arrayList = indexList;
        synchronized (arrayList) {
            if (indexList.size() == 0) {
                return;
            }
            indexName = indexList.remove(rand.nextInt(indexList.size()));
            newIndexName = indexName + "a";
        }
        String renameIndexStmt = "rename index trade." + indexName + " to " + newIndexName;
        try {
            Statement stmt = conn.createStatement();
            Log.getLogWriter().info("rename index statement is " + renameIndexStmt);
            stmt.executeUpdate(renameIndexStmt);
            Log.getLogWriter().info("index renamed for the statement: " + renameIndexStmt);
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        ArrayList<String> arrayList2 = indexList;
        synchronized (arrayList2) {
            indexList.add(newIndexName);
            this.executeListeners("RENAME_INDEX", indexName);
        }
    }

    @Override
    public void createDDLs(Connection dConn, Connection gConn) {
        this.doDDLOp(dConn, gConn);
    }

    public ArrayList<String> getIndexList() {
        return indexList;
    }

    public void addListener(CallBackListener callBackListener) {
        this.listeners.add(callBackListener);
    }
}

