/*
 * Decompiled with CFR 0.152.
 */
package sql.ddlStatements;

import hydra.Log;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import sql.ddlStatements.DDLStmtIF;
import sql.ddlStatements.Procedures;
import sql.wan.SQLWanPrms;
import sql.wan.WanTest;

public class ProcedureDDLStmt
implements DDLStmtIF {
    protected boolean dropProc = SQLTest.dropProc;
    static String showCustomers = "create procedure trade.show_customers(DP1 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'sql.ProcedureTest.selectCustomers'";
    static String addInterest = "create procedure trade.addInterest(DP1 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA MODIFIES SQL DATA EXTERNAL NAME 'sql.ProcedureTest.addInterest'";
    static String testInOutParam = "create procedure trade.testInOutParam(DP1 Integer, OUT DP2 DECIMAL (30, 20), INOUT DP3 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 2 EXTERNAL NAME 'sql.ProcedureTest.testInOutParam'";
    static String queryCustomers = "create procedure trade.query_customers(DP1 Integer , DP2 varchar(500) , OUT DP3 varchar(500)) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA EXTERNAL NAME 'sql.ProcedureTest.queryCustomers'";
    static String[] showCustomersByWanSite = null;
    static String[] addInterestByWanSite = null;
    static String[] testInOutParamByWanSite = null;
    public static HashMap<String, String> nonModifyProcMap = new HashMap();
    public static HashMap<String, String> modifyProcMap = new HashMap();
    public static ArrayList<String> modifyProcNameList = new ArrayList();
    public static ArrayList<String> nonModifyProcNameList = new ArrayList();
    protected static boolean hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
    static boolean isSingleSitePublisher = TestConfig.tab().booleanAt(SQLWanPrms.isSingleSitePublisher, false);
    static boolean isWanTest = TestConfig.tab().booleanAt(SQLWanPrms.isWanTest, false);
    static int numOfWanSites = TestConfig.tab().intAt(SQLWanPrms.numOfWanSites, 1);
    private static long lastDDLOpTime;
    private static int waitPeriod;
    private static String lastProcOpTime;

    @Override
    public void doDDLOp(Connection dConn, Connection gConn) {
        if (!RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString().equalsIgnoreCase("INITTASK")) {
            if (!SQLTest.allowConcDDLDMLOps) {
                Log.getLogWriter().info("This test does not run with concurrent ddl with dml ops, abort the op");
                return;
            }
            if (SQLTest.limitConcDDLOps) {
                long now;
                if (!this.perfDDLOp()) {
                    Log.getLogWriter().info("Does not meet criteria to perform concurrent ddl right now, abort the op");
                    return;
                }
                Long lastUpdateTime = (Long)SQLBB.getBB().getSharedMap().get((Object)lastProcOpTime);
                if (lastUpdateTime != null && (now = System.currentTimeMillis()) - (lastDDLOpTime = lastUpdateTime.longValue()) < (long)(waitPeriod * 60 * 1000)) {
                    SQLBB.getBB().getSharedCounters().zero(SQLBB.perfLimitedProcDDL);
                    Log.getLogWriter().info("Does not meet criteria to perform concurrent ddl abort");
                    return;
                }
            }
            Log.getLogWriter().info("performing conuccrent procedure op in main task");
        }
        int whichProc = 0;
        String proc = null;
        String procName = null;
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (SQLTest.random.nextBoolean()) {
            whichProc = SQLTest.random.nextInt(nonModifyProcNameList.size());
            proc = nonModifyProcMap.get(nonModifyProcNameList.get(whichProc));
            procName = nonModifyProcNameList.get(whichProc);
        } else {
            whichProc = SQLTest.random.nextInt(modifyProcNameList.size());
            proc = modifyProcMap.get(modifyProcNameList.get(whichProc));
            procName = modifyProcNameList.get(whichProc);
        }
        if (hasDerbyServer && !Procedures.doOp(procName)) {
            Log.getLogWriter().info("Other threads are performing op on the procedure " + procName + ", abort this operation");
            return;
        }
        int choice = 3;
        int op = SQLTest.random.nextInt(choice);
        if ((op == 0 || op == 1) && this.dropProc) {
            String dropStatement = "drop procedure " + procName;
            if (dConn != null) {
                if (!this.exeDerbyProcedure(dConn, dropStatement, exceptionList)) {
                    Procedures.zeroCounter(procName);
                    return;
                }
                this.exeGFEProcedure(gConn, dropStatement, exceptionList);
                SQLHelper.handleMissedSQLException(exceptionList);
            } else {
                this.exeGFEProcedure(gConn, dropStatement);
            }
        }
        if (op == 1 || op == 2) {
            if (dConn != null) {
                if (!this.exeDerbyProcedure(dConn, proc, exceptionList)) {
                    Procedures.zeroCounter(procName);
                    return;
                }
                this.exeGFEProcedure(gConn, proc, exceptionList);
                SQLHelper.handleMissedSQLException(exceptionList);
            } else {
                this.exeGFEProcedure(gConn, proc);
            }
        }
        if (hasDerbyServer) {
            Procedures.zeroCounter(procName);
        }
        if (!RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString().equalsIgnoreCase("INITTASK") && SQLTest.limitConcDDLOps) {
            long now = System.currentTimeMillis();
            SQLBB.getBB().getSharedMap().put((Object)lastProcOpTime, (Object)now);
            lastDDLOpTime = now;
            SQLBB.getBB().getSharedCounters().zero(SQLBB.perfLimitedProcDDL);
        }
    }

    private boolean perfDDLOp() {
        long now;
        if (lastDDLOpTime == 0L) {
            Long lastUpdateTime = (Long)SQLBB.getBB().getSharedMap().get((Object)lastProcOpTime);
            if (lastUpdateTime == null) {
                return this.checkBBForDDLOp();
            }
            lastDDLOpTime = lastUpdateTime;
        }
        if ((now = System.currentTimeMillis()) - lastDDLOpTime < (long)(waitPeriod * 60 * 1000)) {
            return false;
        }
        lastDDLOpTime = (Long)SQLBB.getBB().getSharedMap().get((Object)lastProcOpTime);
        if (now - lastDDLOpTime < (long)(waitPeriod * 60 * 1000)) {
            return false;
        }
        return this.checkBBForDDLOp();
    }

    private boolean checkBBForDDLOp() {
        int perfLimitedConcDDL = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.perfLimitedProcDDL);
        return perfLimitedConcDDL == 1;
    }

    protected boolean exeDerbyProcedure(Connection dConn, String procedure, ArrayList<SQLException> exList) {
        Log.getLogWriter().info("try to " + procedure + " in derby");
        try {
            this.exeProcedure(dConn, procedure);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void exeGFEProcedure(Connection gConn, String procedure, ArrayList<SQLException> exList) {
        Log.getLogWriter().info("try to " + procedure + " in gfe");
        try {
            this.exeProcedure(gConn, procedure);
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void exeGFEProcedure(Connection gConn, String procedure) {
        Log.getLogWriter().info("try to " + procedure + " in gfe if exists");
        try {
            this.exeProcedure(gConn, procedure);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42Y55") || se.getSQLState().equals("42X94")) {
                Log.getLogWriter().info("expected procedrue does not exist exception, continuing test");
            }
            if (se.getSQLState().equals("X0Y68")) {
                Log.getLogWriter().info("expected procedrue already exist exception, continuing test");
            }
            if (se.getSQLState().equals("42507") && SQLTest.testSecurity) {
                Log.getLogWriter().info("expected authorization exception, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void exeProcedure(Connection conn, String procedure) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate(procedure);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
    }

    @Override
    public void createDDLs(Connection dConn, Connection gConn) {
        String proc;
        int i;
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        for (i = 0; i < modifyProcNameList.size(); ++i) {
            proc = modifyProcMap.get(modifyProcNameList.get(i));
            if (dConn != null) {
                this.exeDerbyProcedure(dConn, proc, exList);
                this.exeGFEProcedure(gConn, proc, exList);
                SQLHelper.handleMissedSQLException(exList);
                continue;
            }
            this.exeGFEProcedure(gConn, proc);
        }
        for (i = 0; i < nonModifyProcNameList.size(); ++i) {
            proc = nonModifyProcMap.get(nonModifyProcNameList.get(i));
            if (dConn != null) {
                this.exeDerbyProcedure(dConn, proc, exList);
                this.exeGFEProcedure(gConn, proc, exList);
                SQLHelper.handleMissedSQLException(exList);
                continue;
            }
            this.exeGFEProcedure(gConn, proc);
        }
    }

    public void createJSONDDL(Connection gConn) {
        this.exeGFEProcedure(gConn, queryCustomers);
    }

    static {
        if (isWanTest && !isSingleSitePublisher) {
            showCustomersByWanSite = new String[numOfWanSites];
            addInterestByWanSite = new String[numOfWanSites];
            testInOutParamByWanSite = new String[numOfWanSites];
            for (int i = 0; i < numOfWanSites; ++i) {
                ProcedureDDLStmt.showCustomersByWanSite[i] = "create procedure trade.show_customers" + (i + 1) + "(DP1 Integer) " + "PARAMETER STYLE JAVA " + "LANGUAGE JAVA " + "READS SQL DATA " + "DYNAMIC RESULT SETS 1 " + "EXTERNAL NAME 'sql.ProcedureTest.selectCustomers'";
                ProcedureDDLStmt.addInterestByWanSite[i] = "create procedure trade.addInterest" + (i + 1) + "(DP1 Integer) " + "PARAMETER STYLE JAVA " + "LANGUAGE JAVA " + "MODIFIES SQL DATA " + "EXTERNAL NAME 'sql.ProcedureTest.addInterest'";
                ProcedureDDLStmt.testInOutParamByWanSite[i] = "create procedure trade.testInOutParam" + (i + 1) + "(DP1 Integer, " + "OUT DP2 DECIMAL (30, 20), INOUT DP3 Integer) " + "PARAMETER STYLE JAVA " + "LANGUAGE JAVA " + "READS SQL DATA " + "DYNAMIC RESULT SETS 2 " + "EXTERNAL NAME 'sql.ProcedureTest.testInOutParam'";
            }
        }
        if (isWanTest && !isSingleSitePublisher) {
            int myWanSite = WanTest.myWanSite;
            Log.getLogWriter().info("in Procedure, my wan site is " + myWanSite);
            nonModifyProcNameList.add("trade.show_customers" + myWanSite);
            nonModifyProcMap.put("trade.show_customers" + myWanSite, showCustomersByWanSite[myWanSite - 1]);
            nonModifyProcNameList.add("trade.testInOutParam" + myWanSite);
            nonModifyProcMap.put("trade.testInOutParam" + myWanSite, testInOutParamByWanSite[myWanSite - 1]);
            modifyProcNameList.add("trade.addInterest" + myWanSite);
            modifyProcMap.put("trade.addInterest" + myWanSite, addInterestByWanSite[myWanSite - 1]);
        } else {
            nonModifyProcNameList.add("trade.show_customers");
            nonModifyProcMap.put("trade.show_customers", showCustomers);
            nonModifyProcNameList.add("trade.testInOutParam");
            nonModifyProcMap.put("trade.testInOutParam", testInOutParam);
            modifyProcNameList.add("trade.addInterest");
            modifyProcMap.put("trade.addInterest", addInterest);
        }
        lastDDLOpTime = 0L;
        waitPeriod = 3;
        lastProcOpTime = "lastProcOpTime";
    }
}

