/*
 * Decompiled with CFR 0.152.
 */
package sql.ddlStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.MasterController;
import hydra.Prms;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.ddlStatements.ProcedureDDLStmt;
import sql.dmlStatements.AbstractDMLStmt;
import sql.sqlutil.ResultSetHelper;
import sql.wan.SQLWanBB;
import sql.wan.SQLWanPrms;
import sql.wan.WanTest;
import util.TestException;

public class Procedures {
    protected static int maxNumOfTries = 1;
    protected static boolean hasDerbyServer = TestConfig.tab().booleanAt(Prms.manageDerbyServer, false);
    static boolean isWanTest = TestConfig.tab().booleanAt(SQLWanPrms.isWanTest, false);
    static boolean isSingleSitePublisher = TestConfig.tab().booleanAt(SQLWanPrms.isSingleSitePublisher, false);
    static boolean testPartitionBy = TestConfig.tab().booleanAt(SQLPrms.testPartitionBy, false);
    static boolean modifyPartitionKey = Procedures.modifyPartitionedKey();
    static boolean isHATest = SQLTest.isHATest;
    protected static boolean dropProc = SQLTest.dropProc;

    public static void callProcedures(Connection dConn, Connection gConn) {
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        String whichProc = null;
        boolean[] success = new boolean[1];
        Object[] inOut = new Object[2];
        if (dConn != null) {
            if (SQLTest.random.nextBoolean()) {
                if (modifyPartitionKey) {
                    return;
                }
                if (isHATest) {
                    return;
                }
                whichProc = Procedures.getModifyProcedure();
                Procedures.callModifyProcedures(dConn, gConn, whichProc, inOut, exList);
            } else {
                whichProc = Procedures.getNonModifyProcedure();
                Procedures.callNonModifyProcedures(dConn, gConn, whichProc, inOut, exList);
            }
        } else if (SQLTest.random.nextBoolean()) {
            if (modifyPartitionKey) {
                return;
            }
            if (isHATest) {
                return;
            }
            whichProc = Procedures.getModifyProcedure();
            Procedures.callGFEProcedure(gConn, whichProc, inOut, success);
        } else {
            whichProc = Procedures.getNonModifyProcedure();
            ResultSet[] rs = Procedures.callGFEProcedure(gConn, whichProc, inOut, success);
            if (success[0]) {
                Procedures.processRS(rs);
            }
        }
    }

    protected static void callModifyProcedures(Connection dConn, Connection gConn, String whichProc, Object[] inOut, List<SQLException> exList) {
        if (hasDerbyServer && !Procedures.doOp(whichProc)) {
            Log.getLogWriter().info("Other threads are performing op on the procedure " + whichProc + ", abort this operation");
            return;
        }
        int count = 0;
        boolean success = Procedures.callDerbyModifyProcedure(dConn, whichProc, inOut, exList);
        while (!success) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("could not call the derby procedure due to issues, abort this operation");
                Procedures.zeroCounter(whichProc);
                return;
            }
            exList.clear();
            ++count;
            success = Procedures.callDerbyModifyProcedure(dConn, whichProc, inOut, exList);
        }
        boolean[] successForHA = new boolean[1];
        Procedures.callGFEProcedure(gConn, whichProc, inOut, exList, successForHA);
        while (!successForHA[0]) {
            Procedures.callGFEProcedure(gConn, whichProc, inOut, exList, successForHA);
        }
        SQLHelper.handleMissedSQLException(exList);
        if (hasDerbyServer) {
            Procedures.zeroCounter(whichProc);
        }
    }

    protected static boolean callDerbyModifyProcedure(Connection conn, String whichProc, Object[] inOut, List<SQLException> exList) {
        int tid = AbstractDMLStmt.getMyTid();
        Log.getLogWriter().info("call Derby procedure " + whichProc + ", myTid is " + tid);
        int numOfRS = Procedures.getNumOfRS(whichProc);
        try {
            Procedures.callProcedure(conn, whichProc, numOfRS, tid, inOut);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected static void callNonModifyProcedures(Connection dConn, Connection gConn, String whichProc, Object[] inOut, List<SQLException> exList) {
        if (hasDerbyServer && !Procedures.doOp(whichProc)) {
            Log.getLogWriter().info("Other threads are performing op on the procedure " + whichProc + ", abort this operation");
            return;
        }
        Object[] gfxdInOut = new Object[2];
        ResultSet[] derbyRS = Procedures.callDerbyProcedure(dConn, whichProc, inOut, exList);
        if (derbyRS == null && exList.size() == 0) {
            Procedures.zeroCounter(whichProc);
            return;
        }
        boolean[] success = new boolean[1];
        ResultSet[] gfeRS = Procedures.callGFEProcedure(gConn, whichProc, gfxdInOut, exList, success);
        while (!success[0]) {
            gfeRS = Procedures.callGFEProcedure(gConn, whichProc, gfxdInOut, exList, success);
        }
        SQLHelper.handleMissedSQLException(exList);
        if (derbyRS == null) {
            Procedures.zeroCounter(whichProc);
            return;
        }
        Procedures.compareResultSets(derbyRS, gfeRS);
        if (whichProc.startsWith("trade.testInOutParam")) {
            if (gfxdInOut[0] == null && inOut[0] == null) {
                Log.getLogWriter().info("No max cash found, possible no data inserted by this thread or data deleted");
            } else if (gfxdInOut[0] != null && inOut[0] != null) {
                if (!gfxdInOut[0].getClass().equals(BigDecimal.class)) {
                    throw new TestException("supposed to get BigDecimal but got " + gfxdInOut[0].getClass());
                }
                if (((BigDecimal)inOut[0]).subtract((BigDecimal)gfxdInOut[0]).longValue() != 0L) {
                    throw new TestException("Got different out parameter value, derby is " + ((BigDecimal)inOut[0]).longValue() + " gfxd is " + ((BigDecimal)gfxdInOut[0]).longValue());
                }
                Log.getLogWriter().info("maxCash is " + ((BigDecimal)inOut[0]).longValue());
            } else {
                throw new TestException("Only one outparam has data, derby maxCash is " + inOut[0] + "gemfirexd maxCash is " + gfxdInOut[0]);
            }
            if (!gfxdInOut[1].getClass().equals(Integer.class)) {
                throw new TestException("supposed to get Integer but got " + gfxdInOut[1].getClass());
            }
            if (((Integer)inOut[1]).intValue() != ((Integer)gfxdInOut[1]).intValue()) {
                throw new TestException("Got different out parameter value, derby is " + (Integer)inOut[1] + " gfxd is " + (Integer)gfxdInOut[1]);
            }
            Log.getLogWriter().info("out paramet int is " + (Integer)inOut[1]);
        }
        if (hasDerbyServer) {
            Procedures.zeroCounter(whichProc);
        }
    }

    protected static ResultSet[] callDerbyProcedure(Connection conn, String whichProc, Object[] inOut, List<SQLException> exList) {
        ResultSet[] rs = null;
        int tid = AbstractDMLStmt.getMyTid();
        Log.getLogWriter().info("call Derby procedure " + whichProc + ", myTid is " + tid);
        int numOfRS = Procedures.getNumOfRS(whichProc);
        try {
            rs = Procedures.callProcedure(conn, whichProc, numOfRS, tid, inOut);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return null;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return rs;
    }

    protected static ResultSet[] callGFEProcedure(Connection conn, String whichProc, Object[] inOut, List<SQLException> exList, boolean[] success) {
        ResultSet[] rs = null;
        int tid = AbstractDMLStmt.getMyTid();
        Log.getLogWriter().info("call GFE procedure " + whichProc + ", myTid is " + tid);
        int numOfRS = Procedures.getNumOfRS(whichProc);
        success[0] = true;
        try {
            rs = Procedures.callProcedure(conn, whichProc, numOfRS, tid, inOut);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01")) {
                Log.getLogWriter().info("got expected exception, continuing test");
                success[0] = false;
            }
            SQLHelper.handleGFGFXDException(se, exList);
        }
        return rs;
    }

    protected static ResultSet[] callGFEProcedure(Connection conn, String whichProc, Object[] inOut, boolean[] success) {
        int tid = AbstractDMLStmt.getMyTid();
        Log.getLogWriter().info("call GFE procedure " + whichProc + ", myTid is " + tid);
        int numOfRS = Procedures.getNumOfRS(whichProc);
        success[0] = true;
        try {
            return Procedures.callProcedure(conn, whichProc, numOfRS, tid, inOut);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42Y03")) {
                Log.getLogWriter().info("got expected exception, continuing test");
                success[0] = false;
            } else if (se.getSQLState().equals("38000")) {
                Log.getLogWriter().info("got expected exception, continuing test");
                success[0] = false;
            } else if (se.getSQLState().equals("X0Z01") && SQLTest.isHATest) {
                Log.getLogWriter().info("got expected exception, continuing test");
                success[0] = false;
            } else if (se.getSQLState().equals("42504") && SQLTest.testSecurity) {
                Log.getLogWriter().info("expected authorization exception, continuing test");
                success[0] = false;
            } else if (se.getSQLState().equals("X0Z02") && SQLTest.hasTx) {
                Log.getLogWriter().info("expected conflict exception, continuing test");
                success[0] = false;
            } else {
                SQLHelper.handleSQLException(se);
            }
            return null;
        }
    }

    protected static ResultSet[] callProcedure(Connection conn, String proc, int numOfRS, int tid, Object[] inOut) throws SQLException {
        SQLWarning warning;
        ResultSet[] rs = new ResultSet[numOfRS];
        int num = Procedures.getNumOfParams(proc);
        PreparedStatement cs = null;
        if (num == 1) {
            cs = conn.prepareCall("{call " + proc + "(?)}");
            cs.setInt(1, tid);
        } else if (num == 0) {
            cs = conn.prepareCall("{call " + proc + " }");
        } else if (num == 3 && proc.startsWith("trade.testInOutParam")) {
            cs = conn.prepareCall("{call " + proc + " (?, ?, ?)}");
            cs.registerOutParameter(2, 3);
            cs.registerOutParameter(3, 4);
            cs.setInt(1, tid);
            cs.setInt(3, tid);
        }
        cs.execute();
        Log.getLogWriter().info("executed " + proc);
        if (numOfRS > 0) {
            rs[0] = cs.getResultSet();
            int i = 1;
            while (cs.getMoreResults(2)) {
                Log.getLogWriter().info("has more results");
                rs[i] = cs.getResultSet();
                ++i;
            }
            Log.getLogWriter().info("finished setting outgoing result set");
        }
        if (proc.startsWith("trade.testInOutParam")) {
            inOut[0] = cs.getBigDecimal(2);
            inOut[1] = new Integer(cs.getInt(3));
            Log.getLogWriter().info("finished setting output value");
        }
        if ((warning = cs.getWarnings()) != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rs;
    }

    protected static String getModifyProcedure() {
        int whichOne = SQLTest.random.nextInt(ProcedureDDLStmt.modifyProcNameList.size());
        return ProcedureDDLStmt.modifyProcNameList.get(whichOne);
    }

    protected static String getNonModifyProcedure() {
        int whichOne = SQLTest.random.nextInt(ProcedureDDLStmt.nonModifyProcNameList.size());
        return ProcedureDDLStmt.nonModifyProcNameList.get(whichOne);
    }

    protected static int getNumOfParams(String proc) {
        if (proc.startsWith("trade.show_customers") || proc.startsWith("trade.addInterest")) {
            return 1;
        }
        if (proc.startsWith("trade.testInOutParam")) {
            Log.getLogWriter().info("param is 3");
            return 3;
        }
        return 0;
    }

    protected static int getNumOfRS(String proc) {
        if (proc.startsWith("trade.show_customers")) {
            return 1;
        }
        if (proc.startsWith("trade.testInOutParam")) {
            return 2;
        }
        return 0;
    }

    protected static boolean compareResultSets(ResultSet[] derbyRS, ResultSet[] gfeRS) {
        boolean success = true;
        if (derbyRS.length != gfeRS.length) {
            throw new TestException("got different number of resultSets: there are" + derbyRS.length + "result sets from derby and " + gfeRS.length + "result sets from gfe");
        }
        for (int i = 0; i < derbyRS.length; ++i) {
            success = Procedures.compareResultSets(derbyRS[i], gfeRS[i]);
            if (success) continue;
            return success;
        }
        return success;
    }

    protected static boolean compareResultSets(ResultSet derbyRS, ResultSet gfeRS) {
        return ResultSetHelper.compareResultSets(derbyRS, gfeRS);
    }

    protected static void processRS(ResultSet[] rs) {
        for (int i = 0; i < rs.length; ++i) {
            List<Struct> list = ResultSetHelper.asList(rs[i], false);
            if (!(list == null & isHATest)) continue;
            return;
        }
    }

    public static boolean doOp(String procName) {
        int doOp = Procedures.getCounter(procName);
        int count = 0;
        while (doOp != 1) {
            if (count > maxNumOfTries) {
                return false;
            }
            ++count;
            MasterController.sleepForMs((int)(100 * SQLTest.random.nextInt(30)));
            doOp = Procedures.getCounter(procName);
        }
        return true;
    }

    public static int getCounter(String procName) {
        if (!dropProc) {
            return 1;
        }
        if (procName.startsWith("trade.show_customers")) {
            int counter = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.show_customers);
            Log.getLogWriter().info(procName + " counter is " + counter + " ");
            return counter;
        }
        if (procName.startsWith("trade.addInterest")) {
            int counter = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.addInterest);
            Log.getLogWriter().info(procName + " counter is " + counter + " ");
            return counter;
        }
        if (procName.startsWith("trade.testInOutParam")) {
            int counter = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.testInOutParam);
            Log.getLogWriter().info(procName + " counter is " + counter + " ");
            return counter;
        }
        return -1;
    }

    public static void zeroCounter(String procName) {
        if (procName.startsWith("trade.show_customers")) {
            Log.getLogWriter().info("zeros counter SQLBB.show_customers");
            SQLBB.getBB().getSharedCounters().zero(SQLBB.show_customers);
        } else if (procName.startsWith("trade.addInterest")) {
            Log.getLogWriter().info("zeros counter SQLBB.addInterest");
            SQLBB.getBB().getSharedCounters().zero(SQLBB.addInterest);
        } else if (procName.startsWith("trade.testInOutParam")) {
            Log.getLogWriter().info("zeros counter SQLBB.testInOutParam");
            SQLBB.getBB().getSharedCounters().zero(SQLBB.testInOutParam);
        }
    }

    protected static boolean modifyPartitionedKey() {
        if (testPartitionBy && isWanTest && !isSingleSitePublisher) {
            int myWanSite = WanTest.myWanSite;
            List partitionKey = (List)SQLWanBB.getBB().getSharedMap().get((Object)(myWanSite + "_networthPartition"));
            return partitionKey.contains("cash");
        }
        if (testPartitionBy) {
            List partitionKey = (List)SQLBB.getBB().getSharedMap().get((Object)"networthPartition");
            return partitionKey.contains("cash");
        }
        return false;
    }

    public static void callJsonProcedure(Connection conn, int tid) throws SQLException {
        CallableStatement cs = null;
        String networth_json = null;
        ResultSet rs = conn.createStatement().executeQuery("select  json_details from trade.networth where tid = " + tid + " and json_details is not null");
        if (rs.next()) {
            networth_json = rs.getString(1);
        }
        cs = conn.prepareCall("{call  trade.query_Customers(?,?,?)}");
        cs.setInt(1, tid);
        cs.setString(2, networth_json);
        cs.registerOutParameter(3, 12);
        cs.execute();
        String networthOut = cs.getString(3);
        if (!networth_json.equalsIgnoreCase(networthOut)) {
            throw new TestException("Inout Parameter Mismatch. Input param is: " + networth_json + " outputParam is " + networthOut);
        }
        Log.getLogWriter().info("executed trade.query_Customers ");
    }
}

