/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlDistTxRRStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.blackboard.SharedMap;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.dmlDistTxStatements.TradeCustomersDMLDistTxStmt;
import sql.sqlTx.ReadLockedKey;
import sql.sqlTx.SQLDistRRTxTest;
import sql.sqlTx.SQLTxRRReadBB;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class TradeCustomersDMLDistTxRRStmt
extends TradeCustomersDMLDistTxStmt {
    @Override
    protected boolean verifyConflict(HashMap<String, Integer> modifiedKeysByOp, HashMap<String, Integer> modifiedKeysByThisTx, SQLException gfxdse, boolean getConflict) {
        return this.verifyConflictForRR(modifiedKeysByOp, modifiedKeysByThisTx, gfxdse, getConflict);
    }

    @Override
    public boolean queryGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.queryGfxdOnly(gConn);
        }
        int whichQuery = rand.nextInt(select.length);
        int cid = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary));
        Date since = TradeCustomersDMLDistTxRRStmt.getSince();
        ResultSet gfxdRS = null;
        SQLException gfxdse = null;
        try {
            gfxdRS = TradeCustomersDMLDistTxRRStmt.query(gConn, whichQuery, cid, since, TradeCustomersDMLDistTxRRStmt.getMyTid());
            if (gfxdRS == null) {
                if (isHATest) {
                    Log.getLogWriter().info("Testing HA and did not get GFXD result set");
                    return true;
                }
                throw new TestException("Not able to get gfxd result set");
            }
        }
        catch (SQLException se) {
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            SQLHelper.printSQLException(se);
            gfxdse = se;
        }
        List<Struct> gfxdList = ResultSetHelper.asList(gfxdRS, false);
        if (gfxdList == null && isHATest) {
            Log.getLogWriter().info("Testing HA and did not get GFXD result set");
            return true;
        }
        this.addReadLockedKeys(gfxdList);
        this.addQueryToDerbyTx(whichQuery, cid, since, gfxdList, gfxdse);
        return true;
    }

    protected void addReadLockedKeys(List<Struct> gfxdList) {
        int txId = (Integer)SQLDistRRTxTest.curTxId.get();
        SharedMap readLockedKeysByRRTx = SQLTxRRReadBB.getBB().getSharedMap();
        Log.getLogWriter().info("adding the RR read keys to the Map for this txId: " + txId);
        for (int i = 0; i < gfxdList.size(); ++i) {
            int cid = (Integer)gfxdList.get(i).get("CID");
            String key = TradeCustomersDMLDistTxRRStmt.getTableName() + "_" + cid;
            Log.getLogWriter().info("RR read key to be added is " + key);
            ((HashMap)SQLDistRRTxTest.curTxRRReadKeys.get()).put(key, txId);
            ReadLockedKey readKey = (ReadLockedKey)readLockedKeysByRRTx.get((Object)key);
            if (readKey == null) {
                readKey = new ReadLockedKey(key);
            }
            readKey.addKeyByCurTx(txId);
            readLockedKeysByRRTx.put((Object)key, (Object)readKey);
        }
    }

    @Override
    protected boolean queryGfxdOnly(Connection gConn) {
        try {
            return super.queryGfxdOnly(gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02") && !reproduce49935) {
                Log.getLogWriter().info("hit #49935, continuing test");
                return false;
            }
            throw te;
        }
    }
}

