/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlDistTxRRStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.dmlDistTxStatements.TradeSecuritiesDMLDistTxStmt;
import sql.sqlTx.ReadLockedKey;
import sql.sqlTx.SQLDistRRTxTest;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlTx.SQLTxRRReadBB;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class TradeSecuritiesDMLDistTxRRStmt
extends TradeSecuritiesDMLDistTxStmt {
    protected static boolean reproduce39455 = TestConfig.tab().booleanAt(SQLPrms.toReproduce39455, false);

    @Override
    protected boolean verifyConflict(HashMap<String, Integer> modifiedKeysByOp, HashMap<String, Integer> modifiedKeysByThisTx, SQLException gfxdse, boolean getConflict) {
        return this.verifyConflictForRR(modifiedKeysByOp, modifiedKeysByThisTx, gfxdse, getConflict);
    }

    @Override
    public boolean queryGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.queryGfxdOnly(gConn);
        }
        int whichQuery = rand.nextInt(select.length);
        if (whichQuery > 3) {
            whichQuery -= 4;
        }
        int sec_id = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary));
        String symbol = this.getSymbol();
        BigDecimal price = this.getPrice();
        BigDecimal price1 = price.add(new BigDecimal(rangePrice));
        String exchange = this.getExchange();
        int tid = testUniqueKeys ? TradeSecuritiesDMLDistTxRRStmt.getMyTid() : this.getRandomTid();
        String sql = null;
        ResultSet gfxdRS = null;
        SQLException gfxdse = null;
        List<Struct> noneTxGfxdList = null;
        if (!reproduce39455 && whichQuery == 1) {
            --whichQuery;
        }
        try {
            gfxdRS = TradeSecuritiesDMLDistTxRRStmt.query(gConn, whichQuery, sec_id, symbol, price, exchange, tid);
            if (gfxdRS == null) {
                if (isHATest) {
                    Log.getLogWriter().info("Testing HA and did not get GFXD result set");
                    return true;
                }
                throw new TestException("Not able to get gfxd result set");
            }
        }
        catch (SQLException se) {
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            SQLHelper.printSQLException(se);
            gfxdse = se;
        }
        List<Struct> gfxdList = ResultSetHelper.asList(gfxdRS, false);
        if (gfxdList == null && isHATest) {
            Log.getLogWriter().info("Testing HA and did not get GFXD result set");
            return true;
        }
        boolean[] success = new boolean[]{false};
        if (whichQuery == 1) {
            sql = "select sec_id from trade.securities where tid=" + tid + " and symbol > '" + symbol + "'";
            while (!success[0]) {
                noneTxGfxdList = this.getKeysForQuery(sql, success);
            }
        } else if (whichQuery == 2) {
            sql = "select sec_id from trade.securities where (price<" + price + " or price >= " + price1 + ") and tid =" + tid;
            while (!success[0]) {
                noneTxGfxdList = this.getKeysForQuery(sql, success);
            }
        }
        if (whichQuery == 1 || whichQuery == 2) {
            Log.getLogWriter().info("noneTxGfxdList size is " + noneTxGfxdList.size());
            this.addReadLockedKeys(noneTxGfxdList);
        } else {
            this.addReadLockedKeys(gfxdList);
        }
        this.addQueryToDerbyTx(whichQuery, sec_id, symbol, price, exchange, tid, gfxdList, gfxdse);
        return true;
    }

    protected List<Struct> getKeysForQuery(String sql, boolean[] success) {
        Connection noneTxConn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        try {
            Log.getLogWriter().info("executing the following query: " + sql);
            ResultSet noneTxGfxdRS = noneTxConn.createStatement().executeQuery(sql);
            List<Struct> noneTxGfxdList = ResultSetHelper.asList(noneTxGfxdRS, false);
            if (noneTxGfxdList == null && isHATest) {
                Log.getLogWriter().info("Testing HA and did not get GFXD result set");
                success[0] = false;
            } else {
                success[0] = true;
            }
            return noneTxGfxdList;
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            return null;
        }
    }

    protected void addReadLockedKeys(List<Struct> gfxdList) {
        int txId = (Integer)SQLDistRRTxTest.curTxId.get();
        SharedMap readLockedKeysByRRTx = SQLTxRRReadBB.getBB().getSharedMap();
        Log.getLogWriter().info("adding the RR read keys to the Map for this txId: " + txId);
        for (int i = 0; i < gfxdList.size(); ++i) {
            int sid = (Integer)gfxdList.get(i).get("SEC_ID");
            String key = TradeSecuritiesDMLDistTxRRStmt.getTableName() + "_" + sid;
            Log.getLogWriter().info("RR read key to be added is " + key);
            ((HashMap)SQLDistRRTxTest.curTxRRReadKeys.get()).put(key, txId);
            ReadLockedKey readKey = (ReadLockedKey)readLockedKeysByRRTx.get((Object)key);
            if (readKey == null) {
                readKey = new ReadLockedKey(key);
            }
            readKey.addKeyByCurTx(txId);
            readLockedKeysByRRTx.put((Object)key, (Object)readKey);
        }
    }

    @Override
    protected boolean queryGfxdOnly(Connection gConn) {
        try {
            return super.queryGfxdOnly(gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02") && !reproduce49935) {
                Log.getLogWriter().info("hit #49935, continuing test");
                return false;
            }
            throw te;
        }
    }
}

