/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlDistTxStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlDistTxStatements.DMLDistTxStmtIF;
import sql.dmlStatements.TradeCustomersDMLStmt;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlTx.SQLTxPartitionInfoBB;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class TradeCustomersDMLDistTxStmt
extends TradeCustomersDMLStmt
implements DMLDistTxStmtIF {
    public static boolean isReplicate;
    protected static boolean reproduce50010;
    protected static boolean reproduce50001;
    protected static boolean reproduce50283;
    protected boolean hasSecondary = isReplicate || batchingWithSecondaryData && (Boolean)SQLBB.getBB().getSharedMap().get((Object)SQLTest.hasRedundancy) != false;
    protected static String[] update;
    protected static String[] select;
    protected static String[] delete;

    protected void updateGfxdTable(Connection conn, int[] newCid, int[] cid, String[] cust_name, Date[] since, String[] addr, int[] whichUpdate, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        Statement s = this.getStmt(conn);
        int tid = TradeCustomersDMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            if (whichUpdate[i] == 0) {
                Log.getLogWriter().info("Updating gemfirexd on primary key, expect exception thrown here with TID:" + tid + "QUERY:" + update[whichUpdate[i]]);
                stmt = this.getUnsupportedStmt(conn, update[whichUpdate[i]]);
                continue;
            }
            stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(conn, whichUpdate[i]) : TradeCustomersDMLDistTxStmt.getStmt(conn, update[whichUpdate[i]]);
            if (stmt == null) continue;
            updateCount[i] = !SQLTest.testPartitionBy && rand.nextBoolean() ? this.updateTable(s, newCid[i], cid[i], cust_name[i], since[i], addr[i], tid, whichUpdate[i]) : this.updateTable(stmt, newCid[i], cid[i], cust_name[i], since[i], addr[i], tid, whichUpdate[i]);
        }
    }

    @Override
    protected int updateTable(PreparedStatement stmt, int newCid, int cid, String cust_name, Date since, String addr, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + update[whichUpdate];
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(database + "updating trade.customers with CID:" + newCid + " where CID:" + cid + query);
                stmt.setInt(1, newCid);
                stmt.setInt(2, cid);
                stmt.setInt(3, RemoteTestModule.getCurrentThread().getThreadId());
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "updating trade.customers with CUSTNAME:" + cust_name + ",ADDR:" + addr + " where CID," + cid + ",TID:" + tid + query);
                stmt.setString(1, cust_name);
                stmt.setString(2, addr);
                stmt.setInt(3, cid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in  trade.customers CUSTNAME:" + cust_name + ",ADDR:" + addr + " where CID," + cid + ",TID:" + tid + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "updating trade.customers with CUSTNAME:" + cust_name + ",ADDR:" + addr + " where CID:" + cid + ",TID:" + tid + query);
                stmt.setString(1, cust_name);
                stmt.setString(2, addr);
                stmt.setInt(3, cid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in  trade.customers with CUSTNAME:" + cust_name + ",ADDR:" + addr + " where CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "updating trade.customers with CUSTNAME:" + cust_name + ",SINCE:" + since + " where CID:" + cid + ",TID:" + tid + query);
                stmt.setString(1, cust_name);
                stmt.setDate(2, since);
                stmt.setInt(3, cid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in  trade.customers CUSTNAME:" + cust_name + ",SINCE:" + since + " where CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "updating trade.customers with SINCE:" + since + " where CID:" + cid + query);
                stmt.setDate(1, since);
                if (!reproduce50283) {
                    stmt.setInt(2, cid);
                }
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in  trade.customers with SINCE:" + since + " where CID:" + cid + query);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    @Override
    protected int updateTable(Statement stmt, int newCid, int cid, String cust_name, Date since, String addr, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        String query = " QUERY: " + update[whichUpdate];
        switch (whichUpdate) {
            case 0: {
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "updating trade.customers  with CUSTNAME:" + cust_name + ",ADDR:" + ",CID:" + cid + ",TID" + tid + query);
                rowCount = stmt.executeUpdate("update trade.customers set cust_name ='" + cust_name + "' , addr ='" + addr + "' where cid=" + cid + " and tid <>" + tid);
                Log.getLogWriter().info(database + "updated " + rowCount + " rows trade.customers CUSTNAME:" + cust_name + ",ADDR:" + ",CID:" + cid + ",TID" + tid + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "updating trade.customers with CUSTNAME:" + cust_name + ",ADDR:" + addr + ",CID:" + cid + ",TID:" + tid + query);
                rowCount = stmt.executeUpdate("update trade.customers set cust_name ='" + cust_name + "' , addr ='" + addr + "' where cid=" + cid + " and tid <=" + tid);
                Log.getLogWriter().info(database + "updated " + rowCount + "rows in trade.customers with CUSTNAME:" + cust_name + ",ADDR:" + addr + ",CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "updating trade.customers with CUSTNAME:" + cust_name + ",SINCE:" + since + ",CID:" + cid + ",TID:" + tid + query);
                rowCount = stmt.executeUpdate("update trade.customers set cust_name ='" + cust_name + "' , since ='" + since + "' where cid=" + cid + " and tid >" + tid);
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.customers CUSTNAME:" + cust_name + ",SINCE:" + since + ",CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "updating trade.customers with SINCE:" + since + ",CID:" + cid + query);
                rowCount = stmt.executeUpdate("update trade.customers set since ='" + since + "' where cid=" + cid);
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.customers SINCE:" + since + ",CID:" + cid + query);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void updateDerbyTable(Connection conn, int[] newCid, int[] cid, String[] cust_name, Date[] since, String[] addr, int[] whichUpdate, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        int tid = TradeCustomersDMLDistTxStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            if (whichUpdate[i] == 0) {
                Log.getLogWriter().info("this update primary key/partiton key case in gfe, do not update");
                return;
            }
            stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(conn, whichUpdate[i]) : TradeCustomersDMLDistTxStmt.getStmt(conn, update[whichUpdate[i]]);
            if (stmt == null) continue;
            count = this.updateTable(stmt, newCid[i], cid[i], cust_name[i], since[i], addr[i], tid, whichUpdate[i]);
            if (count != updateCount[i]) {
                Log.getLogWriter().info("Derby update has different row count from that of gfxd gfxd updated " + updateCount[i] + " rows, but derby updated " + count + "rows");
                continue;
            }
            Log.getLogWriter().info("Derby updates " + count + " rows");
        }
    }

    protected void updateGfxdOnlyTable(Connection conn, int[] newCid, int[] cid, String[] cust_name, Date[] since, String[] addr, int[] whichUpdate, int size) {
        PreparedStatement stmt = null;
        Statement s = this.getStmt(conn);
        int tid = TradeCustomersDMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            if (whichUpdate[i] == 0) {
                Log.getLogWriter().info("update partition key statement is " + update[whichUpdate[i]]);
                stmt = this.getUnsupportedStmt(conn, update[whichUpdate[i]]);
                continue;
            }
            stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(conn, whichUpdate[i]) : TradeCustomersDMLDistTxStmt.getStmt(conn, update[whichUpdate[i]]);
            try {
                if (stmt == null) continue;
                if (rand.nextBoolean()) {
                    this.updateTable(s, newCid[i], cid[i], cust_name[i], since[i], addr[i], tid, whichUpdate[i]);
                    continue;
                }
                this.updateTable(stmt, newCid[i], cid[i], cust_name[i], since[i], addr[i], tid, whichUpdate[i]);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    @Override
    public boolean insertGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.insertGfxdOnly(gConn);
        }
        int chance = 10;
        boolean useBatchInsert = rand.nextInt(chance) == 1;
        int size = useBatchInsert ? 5 : 1;
        int[] cid = new int[size];
        String[] cust_name = new String[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        SQLException gfxdse = null;
        int[] updateCount = new int[size];
        this.getDataForInsert(cid, cust_name, since, addr, size);
        if (rand.nextInt(100) == 1 && SQLDistTxTest.ticket43170fixed) {
            cid[0] = cid[0] - 1;
        }
        boolean usePut = rand.nextBoolean();
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        for (int i = 0; i < size; ++i) {
            modifiedKeysByOp.put(TradeCustomersDMLDistTxStmt.getTableName() + "_" + cid[i], (Integer)SQLDistTxTest.curTxId.get());
        }
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            this.insertToGfxdTable(gConn, cid, cust_name, since, addr, updateCount, size, usePut);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, se, true);
                } else {
                    this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, se, this.hasSecondary, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
            SQLDistTxTest.batchInsertToCustomersSucceeded.set((Object)false);
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, null, false);
        } else {
            this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, null, this.hasSecondary, false);
        }
        SQLDistTxTest.cidInserted.set((Object)cid[0]);
        this.addInsertToDerbyTx(cid, cust_name, since, addr, updateCount, gfxdse);
        modifiedKeysByTx.putAll(modifiedKeysByOp);
        SQLDistTxTest.curTxModifiedKeys.set((Object)modifiedKeysByTx);
        return true;
    }

    protected void addInsertToDerbyTx(int[] cid, String[] cust_name, Date[] since, String[] addr, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{1, "insert", cid, cust_name, since, addr, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    public static String getTableName() {
        return "customers";
    }

    @Override
    public void insertDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[7];
        try {
            this.insertToDerbyTable(dConn, (int[])data[2], (String[])data[3], (Date[])data[4], (String[])data[5], (int[])data[6], ((int[])data[2]).length);
        }
        catch (SQLException derbyse) {
            if (derbyse.getSQLState().equals("38000") || derbyse.getSQLState().equals("XJ208")) {
                if (!SQLTest.isEdge) {
                    derbyse = derbyse.getNextException();
                    if (derbyse == null) {
                        throw new TestException("derby batch update exception does not have nested exception");
                    }
                } else if (gfxdse.getSQLState().equals("XJ208")) {
                    gfxdse = gfxdse.getNextException();
                    derbyse = derbyse.getNextException();
                } else {
                    if (reproduce50010) {
                        Log.getLogWriter().info("derby excetpion:");
                        SQLHelper.printSQLException(derbyse);
                        Log.getLogWriter().info("gfxd excetpion:");
                        SQLHelper.printSQLException(gfxdse);
                        throw new TestException("gfxd does not get correct batch update exception");
                    }
                    Log.getLogWriter().info("ignore ticket 50010 for now");
                    derbyse = derbyse.getNextException();
                }
            }
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    @Override
    public boolean updateGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.updateGfxdOnly(gConn);
        }
        int size = 1;
        int[] cid = new int[size];
        int[] newCid = new int[size];
        String[] cust_name = new String[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        int[] whichUpdate = new int[size];
        int[] updateCount = new int[size];
        SQLException gfxdse = null;
        boolean[] expectConflict = new boolean[1];
        if (!ticket42672fixed && this.isCustomersPartitionedOnPKOrReplicate()) {
            Log.getLogWriter().info("not implemented due to #42672, abort this op for now");
            return true;
        }
        this.getDataForUpdate((Connection)SQLDistTxTest.gfxdNoneTxConn.get(), newCid, cid, cust_name, since, addr, whichUpdate, size);
        this.getExistingCidFromCustomers((Connection)SQLDistTxTest.gfxdNoneTxConn.get(), cid);
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        for (int i = 0; i < size; ++i) {
            whichUpdate[i] = this.getWhichUpdate(whichUpdate[i]);
        }
        try {
            this.getKeysForUpdate(modifiedKeysByOp, whichUpdate[0], cid[0], newCid[0], since[0]);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            Log.getLogWriter().warning("not able to get the keys, abort this insert op");
            return true;
        }
        try {
            this.updateGfxdTable(gConn, newCid, cid, cust_name, since, addr, whichUpdate, updateCount, size);
            if (isHATest && ((Boolean)SQLDistTxTest.failedToGetStmtNodeFailure.get()).booleanValue()) {
                SQLDistTxTest.failedToGetStmtNodeFailure.set((Object)false);
                return false;
            }
            if (((Boolean)SQLDistTxTest.updateOnPartitionCol.get()).booleanValue()) {
                SQLDistTxTest.updateOnPartitionCol.set((Object)false);
                return true;
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, se, true);
                } else {
                    this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, se, this.hasSecondary, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, null, false);
        } else {
            this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, null, this.hasSecondary, false);
        }
        this.addUpdateToDerbyTx(newCid, cid, cust_name, since, addr, whichUpdate, updateCount, gfxdse);
        modifiedKeysByTx.putAll(modifiedKeysByOp);
        SQLDistTxTest.curTxModifiedKeys.set((Object)modifiedKeysByTx);
        return true;
    }

    private int getWhichUpdate(int index) {
        if (((Boolean)SQLDistTxTest.commitEarly.get()).booleanValue()) {
            index = 4;
        }
        return index;
    }

    protected void getKeysForUpdate(HashMap<String, Integer> keys, int whichUpdate, int cid, int newCid, Date since) throws SQLException {
        int tid = TradeCustomersDMLDistTxStmt.getMyTid();
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = "gemfirexd - TXID:" + txId + " ";
        Connection conn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: {
                break;
            }
            case 1: {
                sql = "select cid from trade.customers where cid=" + cid + " and tid<>" + tid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info(database + "CID:" + cid + " exists for update");
                    keys.put(TradeCustomersDMLDistTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 2: {
                sql = "select cid from trade.customers where cid =" + cid + " and tid<=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info(database + "CID:" + availCid + " exists for update");
                    keys.put(TradeCustomersDMLDistTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            case 3: {
                sql = "select cid from trade.customers where cid=" + cid + " and tid>" + tid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info(database + "CID:" + availCid + " exists for update");
                    keys.put(TradeCustomersDMLDistTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            case 4: {
                sql = "select cid from trade.customers where cid=" + cid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info(database + "CID:" + availCid + " exists for update");
                    keys.put(TradeCustomersDMLDistTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    @Override
    public boolean deleteGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.deleteGfxdOnly(gConn);
        }
        int whichDelete = rand.nextInt(delete.length);
        whichDelete = this.getWhichDelete(whichDelete);
        return true;
    }

    private int getWhichDelete(int index) {
        if (index == 1 && !((Boolean)SQLDistTxTest.commitEarly.get()).booleanValue()) {
            index = 0;
        }
        return index;
    }

    @Override
    public boolean queryGfxd(Connection gConn, boolean withDerby) {
        List<Struct> gfxdList;
        if (!withDerby) {
            return this.queryGfxdOnly(gConn);
        }
        int whichQuery = rand.nextInt(select.length);
        int cid = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary));
        Date since = TradeCustomersDMLDistTxStmt.getSince();
        ResultSet gfxdRS = null;
        SQLException gfxdse = null;
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            gfxdRS = TradeCustomersDMLDistTxStmt.query(gConn, whichQuery, cid, since, TradeCustomersDMLDistTxStmt.getMyTid());
            if (gfxdRS == null) {
                throw new TestException("Not able to get gfxd result set");
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (batchingWithSecondaryData) {
                    this.verifyConflictWithBatching(new HashMap<String, Integer>(), modifiedKeysByTx, se, this.hasSecondary, true);
                    return false;
                }
            } else {
                if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                    SQLHelper.printSQLException(se);
                    Log.getLogWriter().info("got node failure exception during Tx without HA support, continue testing");
                    return false;
                }
                SQLHelper.handleSQLException(se);
            }
            gfxdse = se;
        }
        if ((gfxdList = ResultSetHelper.asList(gfxdRS, false)) == null && isHATest) {
            Log.getLogWriter().info("Testing HA and did not get GFXD result set due to node failure");
            return false;
        }
        this.addQueryToDerbyTx(whichQuery, cid, since, gfxdList, gfxdse);
        return true;
    }

    protected static ResultSet query(Connection conn, int whichQuery, int cid, Date since, int tid) throws SQLException {
        boolean[] success = new boolean[1];
        ResultSet rs = TradeCustomersDMLDistTxStmt.getQuery(conn, whichQuery, cid, since, tid, success);
        Log.getLogWriter().info("success is " + success[0]);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                if (SQLHelper.isDerbyConn(conn)) {
                    Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                }
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = TradeCustomersDMLDistTxStmt.getQuery(conn, whichQuery, cid, since, tid, success);
        }
        return rs;
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, int cid, Date since, int tid, boolean[] success) throws SQLException {
        ResultSet rs = null;
        success[0] = true;
        String transactionId = (Integer)SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - " + transactionId + " ";
        String query = " QUERY: " + select[whichQuery];
        try {
            PreparedStatement stmt = conn.prepareStatement(select[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.customers with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.customers with CID:" + cid + ",TID:" + tid + query);
                    stmt.setInt(1, tid);
                    stmt.setInt(2, cid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.customers with CID:" + cid + ",SINCE: " + since + ",TID:" + tid + query);
                    stmt.setInt(1, tid);
                    stmt.setInt(2, cid);
                    stmt.setDate(3, since);
                    stmt.setInt(4, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying trade.customers with CID:" + cid + "SINCE:" + since + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setDate(2, since);
                    stmt.setInt(3, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.customers with ADDR like:" + '%' + cid + '%' + query);
                    stmt.setString(1, "%" + cid + "%");
                    break;
                }
                case 5: {
                    String custName = TradeCustomersDMLDistTxStmt.getUnionCustNameWildcard(cid);
                    String custName2 = TradeCustomersDMLDistTxStmt.getUnionCustNameWildcard(cid + 2);
                    stmt.setInt(1, tid);
                    stmt.setString(2, custName);
                    stmt.setInt(3, tid);
                    stmt.setString(4, custName2);
                    Log.getLogWriter().info(database + "querying trade.customers with TID:" + tid + ",1_CUSTNAME:" + custName + ",2_CUSTNAME:" + custName2 + query);
                    break;
                }
                case 6: {
                    Log.getLogWriter().info(database + "querying trade.customers with CID:" + cid + query);
                    stmt.setInt(1, cid);
                    break;
                }
                case 7: {
                    Log.getLogWriter().info(database + "querying trade.customers with substr(cust_name, 5, length(cust_name)-4) = " + cid + " or substr(addr, 16, length(addr)-15) = " + (cid - 10) + query);
                    stmt.setString(1, "" + cid);
                    stmt.setString(2, "" + (cid - 10));
                    break;
                }
                case 8: {
                    Log.getLogWriter().info(database + "querying trade.customers with CUSTNAME:" + "name" + cid + " or SINCE:" + since + query);
                    stmt.setString(1, "name" + cid);
                    stmt.setDate(2, since);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            throw se;
        }
        return rs;
    }

    public static int getCid() {
        int newCids;
        int maxCid = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary);
        int n = newCids = 10 * numOfThreads > 100 ? 10 * numOfThreads : 100;
        if (maxCid > newCids) {
            return rand.nextInt(maxCid - newCids) + 1;
        }
        throw new TestException("test issue, not enough cid in the tests yet");
    }

    protected void addQueryToDerbyTx(int whichQuery, int cid, Date since, List<Struct> gfxdList, SQLException gfxdse) {
        Object[] data = new Object[]{1, "query", whichQuery, cid, since, gfxdList, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void queryDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[6];
        List gfxdList = (List)data[5];
        ResultSet derbyRS = null;
        try {
            derbyRS = TradeCustomersDMLDistTxStmt.query(dConn, (Integer)data[2], (Integer)data[3], (Date)data[4], TradeCustomersDMLDistTxStmt.getMyTid());
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
        }
        ResultSetHelper.compareResultSets(ResultSetHelper.asList(derbyRS, true), gfxdList);
    }

    protected void addUpdateToDerbyTx(int[] newCid, int[] cid, String[] cust_name, Date[] since, String[] addr, int[] whichUpdate, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{1, "update", newCid, cid, cust_name, since, addr, whichUpdate, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void updateDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[9];
        try {
            this.updateDerbyTable(dConn, (int[])data[2], (int[])data[3], (String[])data[4], (Date[])data[5], (String[])data[6], (int[])data[7], (int[])data[8], 1);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    protected void insertToGfxdTable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int[] count, int size) throws SQLException {
        this.insertToGfxdTable(conn, cid, cust_name, since, addr, count, size, false);
    }

    protected void insertToGfxdTable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int[] count, int size, boolean usePut) throws SQLException {
        PreparedStatement stmt = null;
        stmt = SQLTest.isEdge && !isTicket48176Fixed && isHATest ? TradeCustomersDMLDistTxStmt.getStmtThrowException(conn, usePut ? put : insert) : conn.prepareStatement(usePut ? put : insert);
        int tid = TradeCustomersDMLDistTxStmt.getMyTid();
        if (size > 1) {
            int[] temp = this.insertBatchToGFETable(conn, cid, cust_name, since, addr, size, usePut);
            if (temp != null) {
                for (int i = 0; i < temp.length; ++i) {
                    count[i] = temp[i];
                }
            } else {
                Log.getLogWriter().warning("batch insert failed, needs to be checked");
            }
        } else {
            for (int i = 0; i < size; ++i) {
                count[i] = this.insertToTable(stmt, cid[i], cust_name[i], since[i], addr[i], tid, usePut);
                Log.getLogWriter().info("gemfirexd -  inserts " + count[i] + " rows");
            }
        }
    }

    protected int[] insertBatchToGFETable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size) throws SQLException {
        return this.insertBatchToGFETable(conn, cid, cust_name, since, addr, size, false);
    }

    protected int[] insertBatchToGFETable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, boolean isPut) throws SQLException {
        Statement stmt = conn.createStatement();
        int tid = TradeCustomersDMLDistTxStmt.getMyTid();
        int[] counts = null;
        for (int i = 0; i < size; ++i) {
            String sql = (isPut ? "put" : "insert") + " into trade.customers values (" + cid[i] + ", '" + cust_name[i] + "' , '" + since[i] + "' , '" + addr[i] + "'," + tid + ")";
            stmt.addBatch(sql);
            Log.getLogWriter().info(sql);
            Log.getLogWriter().info("gemfirexd - TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " " + (isPut ? "batch putting" : "batch inserting") + " into trade.customers CID:" + cid[i] + ",CUSTNAME:" + cust_name[i] + ",SINCE:" + since[i] + ",ADDR:" + addr[i] + ".TID:" + tid);
            continue;
        }
        try {
            counts = stmt.executeBatch();
            Log.getLogWriter().info("executed batch insert in gfxd");
            if (counts == null) {
                throw new TestException("gemfirexd statement executebatch succeeded but not return an array of update counts");
            }
            if (counts.length < 1) {
                throw new TestException("gemfirexd statement executebatch succeeded but returned zero length array of update counts");
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw se;
        }
        return counts;
    }

    protected void insertToDerbyTable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(insert);
        int tid = TradeCustomersDMLDistTxStmt.getMyTid();
        if (size > 1) {
            int[] counts = this.insertBatchToDerbyTable(conn, cid, cust_name, since, addr, size);
            boolean hasWrongUpdateCount = false;
            for (int i = 0; i < size; ++i) {
                if (counts[i] == updateCount[i]) continue;
                Log.getLogWriter().info("derby insert has different row count from that of gfxd gfxd inserted " + updateCount[i] + " row, but derby inserted " + counts[i] + " row for " + (i + 1) + "th element");
                hasWrongUpdateCount = true;
            }
            if (reproduce50001 && !isHATest && hasWrongUpdateCount) {
                throw new TestException("Derby batch update has different row count from that of gfxd");
            }
        } else {
            int count = 0;
            for (int i = 0; i < size; ++i) {
                count = this.insertToTable(stmt, cid[i], cust_name[i], since[i], addr[i], tid);
                if (count == updateCount[i]) continue;
                Log.getLogWriter().info("derby insert has different row count from that of gfxd gfxd inserted " + updateCount[i] + " row, but derby inserted " + count + " row");
            }
        }
    }

    protected int[] insertBatchToDerbyTable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size) throws SQLException {
        int i;
        Statement stmt = conn.createStatement();
        int tid = TradeCustomersDMLDistTxStmt.getMyTid();
        int[] counts = null;
        for (i = 0; i < size; ++i) {
            stmt.addBatch("insert into trade.customers values (" + cid[i] + ", '" + cust_name[i] + "','" + since[i] + "','" + addr[i] + "'," + tid + ")");
            Log.getLogWriter().info("Derby - batch inserting into trade.customers CID:" + cid[i] + ",CUSTNAME:" + cust_name[i] + ",SINCE:" + since[i] + ",ADDR:" + addr[i] + ",TID:" + tid);
        }
        counts = stmt.executeBatch();
        for (i = 0; i < counts.length; ++i) {
            if (counts[i] != -3) {
                Log.getLogWriter().info("Derby - inserted into table trade.customers CID:" + cid[i] + ",CUSTNAME:" + cust_name[i] + ",SINCE:" + since[i] + ",ADDR:" + addr[i] + ",TID:" + tid);
            }
            verifyRowCount.put(tid + "_insert" + i, 0);
            verifyRowCount.put(tid + "_insert" + i, new Integer(counts[i]));
        }
        return counts;
    }

    @Override
    public void deleteDerby(Connection dConn, int index) {
    }

    protected boolean insertGfxdOnly(Connection gConn) {
        try {
            this.insert(null, gConn, 1, false);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                if (nobatching || RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString().equalsIgnoreCase("INITTASK")) {
                    throw new TestException("Without batching, we should not get conflict exception " + TestHelper.getStackTrace((Throwable)te));
                }
                Log.getLogWriter().info("got expected conflict exception");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected boolean updateGfxdOnly(Connection gConn) {
        try {
            this.update(null, gConn, 1);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected boolean deleteGfxdOnly(Connection gConn) {
        try {
            this.delete(null, gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected boolean queryGfxdOnly(Connection gConn) {
        try {
            this.query(null, gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02") && batchingWithSecondaryData) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected PreparedStatement getCorrectTxStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys) {
        PreparedStatement stmt = null;
        switch (whichUpdate) {
            case 0: {
                break;
            }
            case 1: {
                if (partitionKeys.contains("cust_name")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomersDMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("cust_name") || partitionKeys.contains("addr")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomersDMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("cust_name") || partitionKeys.contains("since")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomersDMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 4: {
                if (partitionKeys.contains("since")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomersDMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected PreparedStatement getCorrectTxStmt(Connection conn, int whichUpdate) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectTxStmt(conn, whichUpdate, partitionKeys);
    }

    static {
        reproduce50010 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50010, false);
        reproduce50001 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50001, true);
        reproduce50283 = false;
        try {
            String partition = (String)SQLTxPartitionInfoBB.getBB().getSharedMap().get((Object)("trade." + TradeCustomersDMLDistTxStmt.getTableName()));
            isReplicate = partition.equalsIgnoreCase("replicate");
        }
        catch (NullPointerException npe) {
            isReplicate = false;
        }
        Log.getLogWriter().info("isReplicate is " + isReplicate);
        update = new String[]{"update trade.customers set cid = ? where cid=? and tid = ? ", "update trade.customers set cust_name = ? , addr = ? where cid=? and tid <>? ", "update trade.customers set cust_name = ? , addr = ? where cid=? and tid <=? ", "update trade.customers set cust_name = ?, since =? where cid=? and tid >? ", "update trade.customers set since =? where cid=? "};
        select = new String[]{"select * from trade.customers where tid = ?", "select cid, since, cust_name from trade.customers where tid=? and cid >?", "select cid, since, addr, cust_name from trade.customers where (tid<? or cid <=?) and since >? and tid = ?", "select cid, addr, since, cust_name from trade.customers where (cid >? or since <?) and tid = ?", "select cid, max(substr(rtrim(addr), 1, length(addr))) from trade.customers where addr like ? group by cid ", "select cid, since, cust_name from trade.customers where tid =? and cust_name like ? union select cid, since, cust_name from trade.customers where tid =? and cust_name like ? ", "select * from trade.customers where cid = ?", "select cid, since, cust_name from trade.customers where substr(cust_name, 5, length(cust_name)-4) = ? or substr(addr, 16, length(addr)-15) = ?", "select cid, since, cust_name from trade.customers where cust_name = ? or since = ?"};
        delete = new String[]{"delete from trade.customers where cid in (?, ?)", "delete from trade.customers where (substr(cust_name, 5, length(cust_name)-4) = ? or substr(addr, 16, length(addr)-15) = ?) and cid < ? "};
    }
}

