/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlDistTxStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlDistTxStatements.DMLDistTxStmtIF;
import sql.dmlStatements.TradeCustomersDMLStmt;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class TradeCustomersV1DMLDistTxStmt
extends TradeCustomersDMLStmt
implements DMLDistTxStmtIF {
    public static boolean reproduce50676 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50676, false);
    protected static boolean addGenIdCol = SQLDistTxTest.addGenIdColInCustomersv1;
    protected static String insertGenId = rand.nextBoolean() ? "insert into trade.customersv1 (cid, cust_name, since, addr, tid, genId, round) values (?,?,?,?,?, default, ?)" : "insert into trade.customersv1 (cid, cust_name, since, addr, tid, round) values (?,?,?,?,?,?)";
    protected static String insertDerbyGenid = "insert into trade.customersv1 (cid, cust_name, since, addr, tid, genId, round) values (?,?,?,?,?,?,?)";
    protected static String insert = rand.nextBoolean() ? "insert into trade.customersv1 (cid, cust_name, since, addr, tid, round) values (default,?,?,?,?,?)" : "insert into trade.customersv1 (cust_name, since, addr, tid, round) values (?,?,?,?,?)";
    protected static String insertDerby = "insert into trade.customersv1 (cid, cust_name, since, addr, tid, round) values (?,?,?,?,?,?)";
    protected static String[] update = new String[]{"update trade.customersv1 set tid = ? , round = ? where cid=? ", "update trade.customersv1 set addr = ?, round = ? where (cust_name=? or since = ? ) and round < ?  ", "update trade.customersv1 set cust_name = ? , addr = ? , round = ? where cid<=? and cid>? and tid <=? and round <?", "update trade.customersv1 set tid = ? , round = ? where since>? and round < ? and cid in (select cid from trade.customersv1 where cust_name in (?, ?) or addr = ?)", "update trade.customersv1 set since =? , round = ? where cid in (?, ?, ?) "};
    protected static String[] delete = new String[]{"delete from trade.customersv1 where cid=?", "delete from trade.customersv1 where cid in (? , ?) "};
    protected static String[] select = new String[]{"select * from trade.customersv1 where tid = ? and round <? and since> ? and cid>?", "select " + (!reproduce50676 ? "* " : "cid, since, cust_name, round ") + "from trade.customersv1 where cid =?", "select " + (!reproduce50676 ? "* " : "cid, since, addr, cust_name, round ") + "from trade.customersv1 where (cid =? or cid = ?)", "select " + (!reproduce50676 ? "* " : "cid, addr, since, cust_name, round ") + "from trade.customersv1 where (cid in (?, ?) or cid = ?)", "select cust_name, count(cid) as num from trade.customersv1 where cid> ? and round <? group by cust_name order by num, cust_name ", "select " + (!reproduce50676 ? "* " : "cid, since, cust_name, round, tid ") + "from trade.customersv1 where cust_name like ? and round < ?" + " union " + "select " + (!reproduce50676 ? "* " : "cid, since, cust_name, round, tid ") + "from trade.customersv1 where tid =? and cid<? and round <?", "select " + (!reproduce50676 ? "* " : "cid, since, cust_name, round ") + "from trade.customersv1 where (substr(cust_name, 5, length(cust_name)-4) = ? or " + "substr(addr, 16, length(addr)-15) = ?) and round <?"};
    protected static final int RANGE = 10;
    protected static boolean hasSecondary = SQLDistTxTest.hasSecondaryTables;
    protected static boolean reproduce50010 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50010, false);
    protected static boolean holdParentKeysByUpdate = false;
    protected static boolean reproduce50546 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50546, false);

    @Override
    public boolean deleteGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.deleteGfxdOnly(gConn);
        }
        int chance = 5 * SQLDistTxTest.numOfWorkers;
        if (rand.nextInt(chance) != 1) {
            return true;
        }
        int whichDelete = rand.nextInt(delete.length);
        long[] cid = new long[1];
        int[] updateCount = new int[1];
        int tid = TradeCustomersV1DMLDistTxStmt.getMyTid();
        Connection nonTxConn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        SQLException gfxdse = null;
        cid[0] = TradeCustomersV1DMLDistTxStmt.getNewTypeCidFromQuery(nonTxConn, TradeCustomersV1DMLDistTxStmt.getTableName(), rand.nextBoolean() ? TradeCustomersV1DMLDistTxStmt.getMyTid() : rand.nextInt(SQLDistTxTest.numOfWorkers));
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashMap<String, Integer> holdDeleteKeysBlockingChildByOp = new HashMap<String, Integer>();
        try {
            this.getKeysForDelete(nonTxConn, modifiedKeysByOp, holdDeleteKeysBlockingChildByOp, whichDelete, cid[0], tid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().warning("Not able to process the keys for this op due to HA, this insert op does not proceed");
                return true;
            }
            SQLHelper.handleSQLException(se);
        }
        try {
            this.deleteFromGfxdTable(gConn, cid, tid, whichDelete, updateCount);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflictNewTables(modifiedKeysByOp, null, holdDeleteKeysBlockingChildByOp, null, null, se, true);
                } else {
                    this.verifyConflictNewTablesWithBatching(modifiedKeysByOp, null, holdDeleteKeysBlockingChildByOp, null, null, se, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflictNewTables(modifiedKeysByOp, null, holdDeleteKeysBlockingChildByOp, null, null, gfxdse, false);
        } else {
            this.verifyConflictNewTablesWithBatching(modifiedKeysByOp, null, holdDeleteKeysBlockingChildByOp, null, null, gfxdse, false);
        }
        this.addDeleteToDerbyTx(cid[0], tid, whichDelete, updateCount[0], gfxdse);
        return true;
    }

    protected void getKeysForDelete(Connection conn, HashMap<String, Integer> keys, HashMap<String, Integer> holdDeleteKeysBlockingChild, int whichDelete, long cid, int tid) throws SQLException {
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = "gemfirexd - TXID:" + txId + " ";
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select cid from trade.customersv1 where cid =" + cid;
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    Log.getLogWriter().info(database + TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    holdDeleteKeysBlockingChild.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            case 1: {
                sql = "select cid from trade.customersv1 where cid in (" + cid + ", " + (cid - (long)tid) + ")";
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    Log.getLogWriter().info(database + TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    holdDeleteKeysBlockingChild.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                }
                rs.close();
                break;
            }
            default: {
                throw new TestException("Wrong delete statement here");
            }
        }
    }

    protected void deleteFromGfxdTable(Connection gConn, long[] cid, int tid, int whichDelete, int[] updateCount) throws SQLException {
        PreparedStatement stmt = null;
        stmt = SQLTest.isEdge && !isTicket48176Fixed && isHATest ? TradeCustomersV1DMLDistTxStmt.getStmtThrowException(gConn, delete[whichDelete]) : gConn.prepareStatement(delete[whichDelete]);
        updateCount[0] = this.deleteFromTable(stmt, cid[0], tid, whichDelete);
    }

    protected int deleteFromTable(PreparedStatement stmt, long cid, int tid, int whichDelete) throws SQLException {
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        String query = " QUERY: " + delete[whichDelete];
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting from trade.customersv1 " + "with CID:" + cid + query);
                stmt.setLong(1, cid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows from " + "trade.customersv1 with CID:" + cid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting from trade.customersv1 with" + " CID:" + cid + ",CID:" + (cid - (long)tid) + query);
                stmt.setLong(1, cid);
                stmt.setLong(2, cid - (long)tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows from " + "trade.customersv1 with CID:" + cid + ",CID:" + (cid - (long)tid) + query);
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void addDeleteToDerbyTx(long cid, int tid, int whichDelete, int updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{1, "delete", cid, tid, whichDelete, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public boolean updateGfxd(Connection gConn, boolean withDerby) {
        PreparedStatement stmt;
        if (!withDerby) {
            return this.updateGfxdOnly(gConn);
        }
        int size = 1;
        long[] cid = new long[size];
        long[] cid2 = new long[size];
        String[] cust_name = new String[size];
        String[] cust_name2 = new String[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        int[] whichUpdate = new int[size];
        int[] updateCount = new int[size];
        SQLException gfxdse = null;
        if (holdParentKeysByUpdate || !ticket42672fixed && this.isCustomersPartitionedOnPKOrReplicate()) {
            holdParentKeysByUpdate = true;
        }
        this.getDataForUpdate((Connection)SQLDistTxTest.gfxdNoneTxConn.get(), cid, cid2, cust_name, cust_name2, since, addr, whichUpdate, size);
        if (!reproduce50546 && whichUpdate[0] == 3) {
            whichUpdate[0] = 4;
        }
        if (SQLTest.testPartitionBy && (stmt = this.getCorrectTxStmt(gConn, whichUpdate[0])) == null && ((Boolean)SQLDistTxTest.updateOnPartitionCol.get()).booleanValue()) {
            SQLDistTxTest.updateOnPartitionCol.set((Object)false);
            return true;
        }
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashMap<String, Integer> holdNonDeleteKeysBlockingChildByOp = new HashMap<String, Integer>();
        HashMap<String, Integer> holdParentKeysByOp = new HashMap<String, Integer>();
        try {
            this.getKeysForUpdate(modifiedKeysByOp, holdNonDeleteKeysBlockingChildByOp, holdParentKeysByOp, whichUpdate[0], cid[0], cid2[0], since[0], cust_name[0], cust_name2[0], addr[0]);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            Log.getLogWriter().warning("not able to get the keys, abort this update op");
            return true;
        }
        try {
            this.updateGfxdTable(gConn, cid, cid2, cust_name, cust_name2, since, addr, whichUpdate, updateCount, size);
            if (isHATest && ((Boolean)SQLDistTxTest.failedToGetStmtNodeFailure.get()).booleanValue()) {
                SQLDistTxTest.failedToGetStmtNodeFailure.set((Object)false);
                return false;
            }
            if (((Boolean)SQLDistTxTest.updateOnPartitionCol.get()).booleanValue()) {
                SQLDistTxTest.updateOnPartitionCol.set((Object)false);
                return true;
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflictNewTables(modifiedKeysByOp, holdNonDeleteKeysBlockingChildByOp, null, holdParentKeysByOp, null, se, true);
                } else {
                    this.verifyConflictNewTablesWithBatching(modifiedKeysByOp, holdNonDeleteKeysBlockingChildByOp, null, holdParentKeysByOp, null, se, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflictNewTables(modifiedKeysByOp, holdNonDeleteKeysBlockingChildByOp, null, holdParentKeysByOp, null, gfxdse, false);
        } else {
            this.verifyConflictNewTablesWithBatching(modifiedKeysByOp, holdNonDeleteKeysBlockingChildByOp, null, holdParentKeysByOp, null, gfxdse, false);
        }
        this.addUpdateToDerbyTx(cid, cid2, cust_name, cust_name2, since, addr, whichUpdate, updateCount, gfxdse);
        return true;
    }

    protected void getDataForUpdate(Connection conn, long[] cid, long[] cid2, String[] cust_name, String[] cust_name2, Date[] since, String[] addr, int[] whichUpdate, int size) {
        this.getExistingCidFromCustomers((Connection)SQLDistTxTest.gfxdNoneTxConn.get(), cid);
        this.getExistingCidFromCustomers((Connection)SQLDistTxTest.gfxdNoneTxConn.get(), cid2);
        int maxCid = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary);
        for (int i = 0; i < size; ++i) {
            cust_name[i] = "name" + rand.nextInt(maxCid);
            cust_name2[i] = "name" + rand.nextInt(maxCid);
            addr[i] = "address is " + cust_name[i];
            since[i] = TradeCustomersV1DMLDistTxStmt.getSince();
            whichUpdate[i] = rand.nextInt(update.length);
        }
    }

    protected void getExistingCidFromCustomers(Connection conn, long[] cid) {
        List<Struct> list = null;
        String sql = "select cid from trade.customersv1";
        try {
            ResultSet rs = conn.createStatement().executeQuery(sql);
            list = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (list == null || list.size() == 0) {
            cid[0] = 0L;
            Log.getLogWriter().info("could not get valid cid, using 0 instead");
        } else {
            cid[0] = (Long)list.get(rand.nextInt(list.size())).get("CID");
        }
    }

    protected void getKeysForUpdate(HashMap<String, Integer> keys, HashMap<String, Integer> holdKeysBlockingChild, HashMap<String, Integer> holdParentKeys, int whichUpdate, long cid, long cid2, Date since, String custName, String custName2, String addr) throws SQLException {
        int tid = TradeCustomersV1DMLDistTxStmt.getMyTid();
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        int round = (Integer)SQLDistTxTest.iteration.get();
        String database = "gemfirexd - TXID:" + txId + " ";
        Connection conn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: {
                sql = "select cid from trade.customersv1 where cid =" + cid;
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    Log.getLogWriter().info(database + TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    if (!holdParentKeysByUpdate) continue;
                    holdKeysBlockingChild.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            case 1: {
                sql = "select cid from trade.customersv1 where (cust_name='" + custName + "' or since='" + since + "') and round < " + round;
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    Log.getLogWriter().info(database + TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    if (!holdParentKeysByUpdate) continue;
                    holdKeysBlockingChild.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                }
                rs.close();
                break;
            }
            case 2: {
                sql = "select cid from trade.customersv1 where cid <=" + cid + " and cid >" + (cid - 10L) + " and tid<=" + tid + " and round < " + round;
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    Log.getLogWriter().info(database + TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    if (!holdParentKeysByUpdate) continue;
                    holdKeysBlockingChild.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            case 3: {
                sql = "select cid from trade.customersv1 where since>'" + since + "' and round < " + round + " and cid in (select cid from trade.customersv1 where cust_name in('" + custName + "', '" + custName2 + "') or addr = '" + addr + "')";
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    Log.getLogWriter().info(database + TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    if (!holdParentKeysByUpdate) continue;
                    holdKeysBlockingChild.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            case 4: {
                sql = "select cid from trade.customersv1 where cid in (" + cid + ", " + (cid - 10L) + ", " + cid2 + ")";
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    Log.getLogWriter().info(database + TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    if (!holdParentKeysByUpdate) continue;
                    holdKeysBlockingChild.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void updateGfxdTable(Connection conn, long[] cid, long[] cid2, String[] cust_name, String[] cust_name2, Date[] since, String[] addr, int[] whichUpdate, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        int tid = TradeCustomersV1DMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(conn, whichUpdate[i]) : TradeCustomersV1DMLDistTxStmt.getStmt(conn, update[whichUpdate[i]]);
            if (stmt == null) continue;
            updateCount[i] = this.updateTable(stmt, cid[i], cid2[i], cust_name[i], cust_name2[i], since[i], addr[i], tid, whichUpdate[i]);
        }
    }

    protected PreparedStatement getCorrectTxStmt(Connection conn, int whichUpdate) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectTxStmt(conn, whichUpdate, partitionKeys);
    }

    protected PreparedStatement getCorrectTxStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys) {
        PreparedStatement stmt = null;
        Log.getLogWriter().info("getting stmt for :" + update[whichUpdate]);
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("tid")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomersV1DMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("addr")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomersV1DMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("cust_name") || partitionKeys.contains("addr")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomersV1DMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("tid")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomersV1DMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 4: {
                if (partitionKeys.contains("since")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomersV1DMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected int updateTable(PreparedStatement stmt, long cid, long cid2, String cust_name, String cust_name2, Date since, String addr, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        int round = (Integer)SQLDistTxTest.iteration.get();
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + update[whichUpdate];
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(database + "updating trade.customersv1 with TID:" + tid + ",ROUND:" + round + " where CID:" + cid + query);
                stmt.setInt(1, tid);
                stmt.setInt(2, round);
                stmt.setLong(3, cid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in trade.customersv1 with TID:" + tid + ",ROUND:" + round + " where CID:" + cid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "updating trade.customersv1 with ADDR:" + addr + ",ROUND:" + round + " where CUST_NAME" + cust_name + ",SINCE:" + since + ",ROUND:" + round + query);
                stmt.setString(1, addr);
                stmt.setInt(2, round);
                stmt.setString(3, cust_name);
                stmt.setDate(4, since);
                stmt.setInt(5, round);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in trade.customersv1 with ADDR:" + addr + " where CUST_NAME" + cust_name + ",SINCE:" + since + ",ROUND:" + round + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "updating trade.customersv1 with CUSTNAME:" + cust_name + ",ADDR:" + addr + ",ROUND:" + round + " where CID:" + cid + ",CID:" + (cid - 10L) + ",TID:" + tid + ",ROUND:" + round + query);
                stmt.setString(1, cust_name);
                stmt.setString(2, addr);
                stmt.setInt(3, round);
                stmt.setLong(4, cid);
                stmt.setLong(5, cid - 10L);
                stmt.setInt(6, tid);
                stmt.setInt(7, round);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in  trade.customersv1 with CUSTNAME:" + cust_name + ",ADDR:" + addr + ",ROUND:" + round + " where CID:" + cid + ",CID:" + (cid - 10L) + ",TID:" + tid + ",ROUND:" + round + query);
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "updating trade.customersv1 with TID:" + tid + ", round:" + round + " where SINCE:" + since + ",ROUND:" + round + ",CUST_NAME in (" + cust_name + "," + cust_name2 + ") " + " OR ADDR:" + addr + query);
                stmt.setInt(1, tid);
                stmt.setInt(2, round);
                stmt.setDate(3, since);
                stmt.setInt(4, round);
                stmt.setString(5, cust_name);
                stmt.setString(6, cust_name2);
                stmt.setString(7, addr);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in trade.customersv1 with TID:" + tid + ", round:" + round + " where SINCE:" + since + ",ROUND:" + round + ",CUST_NAME in (" + cust_name + "," + cust_name2 + ") " + " OR ADDR:" + addr + query);
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "updating trade.customersv1 with SINCE:" + since + ",ROUND:" + round + " where CID in (" + cid + "," + (cid - 10L) + "," + cid2 + ") " + query);
                stmt.setDate(1, since);
                stmt.setInt(2, round);
                stmt.setLong(3, cid);
                stmt.setLong(4, cid - 10L);
                stmt.setLong(5, cid2);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in  trade.customersv1 with SINCE:" + since + ",ROUND:" + round + " where CID in (" + cid + "," + (cid - 10L) + "," + cid2 + ") " + query);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void addUpdateToDerbyTx(long[] cid, long[] cid2, String[] cust_name, String[] cust_name2, Date[] since, String[] addr, int[] whichUpdate, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{1, "update", cid, cid2, cust_name, cust_name2, since, addr, whichUpdate, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void updateDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[10];
        try {
            this.updateDerbyTable(dConn, (long[])data[2], (long[])data[3], (String[])data[4], (String[])data[5], (Date[])data[6], (String[])data[7], (int[])data[8], (int[])data[9], 1);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    protected void updateDerbyTable(Connection conn, long[] cid, long[] cid2, String[] cust_name, String[] cust_name2, Date[] since, String[] addr, int[] whichUpdate, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        int tid = TradeCustomersV1DMLDistTxStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(conn, whichUpdate[i]) : TradeCustomersV1DMLDistTxStmt.getStmt(conn, update[whichUpdate[i]]);
            if (stmt == null) continue;
            count = this.updateTable(stmt, cid[i], cid2[i], cust_name[i], cust_name2[i], since[i], addr[i], tid, whichUpdate[i]);
            if (count != updateCount[i]) {
                String str = "Derby update has different row count from that of gfxd gfxd updated " + updateCount[i] + " rows, but derby updated " + count + "rows";
                if (failAtUpdateCount) {
                    throw new TestException(str);
                }
                Log.getLogWriter().info(str);
                continue;
            }
            Log.getLogWriter().info("Derby updates " + count + " rows");
        }
    }

    @Override
    public boolean insertGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.insertGfxdOnly(gConn);
        }
        int size = 1;
        long[] generatedCid = new long[size];
        int[] cid = new int[size];
        String[] cust_name = new String[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        SQLException gfxdse = null;
        int[] updateCount = new int[size];
        this.getDataForInsert(cid, cust_name, since, addr, size);
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashMap<String, Integer> holdNonDeleteKeysBlockingChildByOp = new HashMap<String, Integer>();
        HashMap<String, Integer> holdParentKeysByOp = new HashMap<String, Integer>();
        try {
            this.insertToGfxdTable(gConn, cid, cust_name, since, addr, generatedCid, updateCount, size);
            if (!addGenIdCol) {
                for (int i = 0; i < size; ++i) {
                    modifiedKeysByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + generatedCid[i], (Integer)SQLDistTxTest.curTxId.get());
                    holdNonDeleteKeysBlockingChildByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + generatedCid[i], (Integer)SQLDistTxTest.curTxId.get());
                }
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflictNewTables(modifiedKeysByOp, holdNonDeleteKeysBlockingChildByOp, null, holdParentKeysByOp, null, se, true);
                    throw new TestException("Does not expect any conflict exception here for inserting into table with generated alway as identity and no batching" + TestHelper.getStackTrace((Throwable)se));
                }
                this.verifyConflictNewTablesWithBatching(modifiedKeysByOp, holdNonDeleteKeysBlockingChildByOp, null, holdParentKeysByOp, null, se, true);
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflictNewTables(modifiedKeysByOp, holdNonDeleteKeysBlockingChildByOp, null, holdParentKeysByOp, null, gfxdse, false);
        } else {
            this.verifyConflictNewTablesWithBatching(modifiedKeysByOp, holdNonDeleteKeysBlockingChildByOp, null, holdParentKeysByOp, null, gfxdse, false);
        }
        SQLDistTxTest.cidInserted.set((Object)generatedCid[0]);
        this.addInsertToDerbyTx(cid, cust_name, since, addr, generatedCid, updateCount, gfxdse);
        return true;
    }

    @Override
    protected void getDataForInsert(int[] cid, String[] cust_name, Date[] since, String[] addr, int size) {
        int key = (int)SQLBB.getBB().getSharedCounters().add(SQLBB.tradeCustomersPrimary, (long)size);
        for (int i = 0; i < size; ++i) {
            int counter;
            cid[i] = counter = key - i;
            cust_name[i] = "name" + counter;
            addr[i] = "address is " + cust_name[i];
            since[i] = TradeCustomersV1DMLDistTxStmt.getSince();
        }
    }

    protected void addInsertToDerbyTx(int[] cid, String[] cust_name, Date[] since, String[] addr, long[] generatedCid, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{1, "insert", cid, cust_name, since, addr, generatedCid, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    protected void insertToGfxdTable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, long[] generatedCid, int[] count, int size) throws SQLException {
        PreparedStatement stmt = null;
        stmt = addGenIdCol ? conn.prepareStatement(insertGenId, 1) : conn.prepareStatement(insert, 1);
        int tid = TradeCustomersV1DMLDistTxStmt.getMyTid();
        if (size != 1) {
            throw new TestException("Should only insert 1 row in the test");
        }
        for (int i = 0; i < size; ++i) {
            count[i] = this.insertToTable(stmt, cid[i], cust_name[i], since[i], addr[i], generatedCid, tid);
            Log.getLogWriter().info("gemfirexd -  inserts " + count[i] + " rows");
        }
    }

    protected int insertToTable(PreparedStatement stmt, int cid, String cust_name, Date since, String addr, long[] generatedCid, int tid) throws SQLException {
        return this.insertToTable(stmt, cid, cust_name, since, addr, generatedCid, tid, false);
    }

    protected int insertToTable(PreparedStatement stmt, int cid, String cust_name, Date since, String addr, long[] generatedCid, int tid, boolean isPut) throws SQLException {
        String transactionId = SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        boolean isDerbyConn = SQLHelper.isDerbyConn(stmt.getConnection());
        String database = isDerbyConn ? "Derby - " : "gemfirexd - " + transactionId + " ";
        int round = (Integer)SQLDistTxTest.iteration.get();
        int rowCount = -1;
        if (!isDerbyConn) {
            long gCid;
            if (addGenIdCol) {
                Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade." + TradeCustomersV1DMLDistTxStmt.getTableName() + " with " + "CID:" + cid + ",CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + ",GENERATEDCID:to be generated" + ",ROUND:" + round);
                stmt.setInt(1, cid);
                stmt.setString(2, cust_name);
                stmt.setDate(3, since);
                stmt.setString(4, addr);
                stmt.setInt(5, tid);
                stmt.setInt(6, round);
                rowCount = stmt.executeUpdate();
                gCid = 0L;
                ResultSet rs = stmt.getGeneratedKeys();
                if (rs.next()) {
                    gCid = rs.getLong(1);
                }
                Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows into trade." + TradeCustomersV1DMLDistTxStmt.getTableName() + " with " + "CID:" + cid + ",CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + "GENERATED CID:" + gCid + ",ROUND:" + round);
                generatedCid[0] = gCid;
            } else {
                Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade." + TradeCustomersV1DMLDistTxStmt.getTableName() + " with " + "CID:to be generated" + ",CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + ",ROUND:" + round);
                stmt.setString(1, cust_name);
                stmt.setDate(2, since);
                stmt.setString(3, addr);
                stmt.setInt(4, tid);
                stmt.setInt(5, round);
                rowCount = stmt.executeUpdate();
                gCid = 0L;
                ResultSet rs = stmt.getGeneratedKeys();
                if (rs.next()) {
                    gCid = rs.getLong(1);
                }
                Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows into trade." + TradeCustomersV1DMLDistTxStmt.getTableName() + " with " + "CID:" + gCid + ",CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + ",ROUND:" + round);
                generatedCid[0] = gCid;
            }
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        } else if (addGenIdCol) {
            Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade." + TradeCustomersV1DMLDistTxStmt.getTableName() + " with " + "CID:" + cid + ",CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + ",GENID:" + generatedCid[0] + ",ROUND:" + round);
            stmt.setInt(1, cid);
            stmt.setString(2, cust_name);
            stmt.setDate(3, since);
            stmt.setString(4, addr);
            stmt.setInt(5, tid);
            stmt.setLong(6, generatedCid[0]);
            stmt.setInt(7, round);
            rowCount = stmt.executeUpdate();
            Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows into trade." + TradeCustomersV1DMLDistTxStmt.getTableName() + " with " + "CID:" + cid + ",CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + ",GENID:" + generatedCid[0] + ",ROUND:" + round);
        } else {
            Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade." + TradeCustomersV1DMLDistTxStmt.getTableName() + " with " + "CID:" + generatedCid[0] + ",CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + ",ROUND:" + round);
            stmt.setLong(1, generatedCid[0]);
            stmt.setString(2, cust_name);
            stmt.setDate(3, since);
            stmt.setString(4, addr);
            stmt.setInt(5, tid);
            stmt.setInt(6, round);
            rowCount = stmt.executeUpdate();
            Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows into trade." + TradeCustomersV1DMLDistTxStmt.getTableName() + " with " + "CID:" + generatedCid[0] + ",CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + ",ROUND:" + round);
        }
        return rowCount;
    }

    protected boolean insertGfxdOnly(Connection gConn) {
        Log.getLogWriter().info("needs implementation");
        return true;
    }

    @Override
    public void insertDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[8];
        try {
            this.insertToDerbyTable(dConn, (int[])data[2], (String[])data[3], (Date[])data[4], (String[])data[5], (long[])data[6], (int[])data[7], ((int[])data[2]).length);
        }
        catch (SQLException derbyse) {
            if (derbyse.getSQLState().equals("38000") || derbyse.getSQLState().equals("XJ208")) {
                if (!SQLTest.isEdge) {
                    derbyse = derbyse.getNextException();
                    if (derbyse == null) {
                        throw new TestException("derby batch update exception does not have nested exception");
                    }
                } else if (gfxdse.getSQLState().equals("XJ208")) {
                    gfxdse = gfxdse.getNextException();
                    derbyse = derbyse.getNextException();
                } else {
                    if (reproduce50010) {
                        Log.getLogWriter().info("derby excetpion:");
                        SQLHelper.printSQLException(derbyse);
                        Log.getLogWriter().info("gfxd excetpion:");
                        SQLHelper.printSQLException(gfxdse);
                        throw new TestException("gfxd does not get correct batch update exception");
                    }
                    Log.getLogWriter().info("ignore ticket 50010 for now");
                    derbyse = derbyse.getNextException();
                }
            }
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    protected void insertToDerbyTable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, long[] genId, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        stmt = addGenIdCol ? conn.prepareStatement(insertDerbyGenid) : conn.prepareStatement(insertDerby);
        int tid = TradeCustomersV1DMLDistTxStmt.getMyTid();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            count = this.insertToTable(stmt, cid[i], cust_name[i], since[i], addr[i], genId, tid);
            if (count == updateCount[i]) continue;
            String str = "derby insert has different row count from that of gfxd gfxd inserted " + updateCount[i] + " row, but derby inserted " + count + " row";
            if (failAtUpdateCount) {
                throw new TestException(str);
            }
            Log.getLogWriter().info(str);
        }
    }

    public static String getTableName() {
        return "customersv1";
    }

    protected boolean updateGfxdOnly(Connection gConn) {
        Log.getLogWriter().info("needs implementation");
        return true;
    }

    protected boolean deleteGfxdOnly(Connection gConn) {
        return true;
    }

    @Override
    public void deleteDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[6];
        try {
            this.deleteFromDerbyTable(dConn, (Long)data[2], (Integer)data[3], (int)((Integer)data[4]), (Integer)data[5]);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    protected void deleteFromDerbyTable(Connection dConn, long cid, int tid, int whichDelete, int updateCount) throws SQLException {
        PreparedStatement stmt = TradeCustomersV1DMLDistTxStmt.getStmt(dConn, delete[whichDelete]);
        Log.getLogWriter().info("Delete in derby, myTid is " + tid);
        int count = this.deleteFromTable(stmt, cid, tid, whichDelete);
        if (count != updateCount) {
            String str = "derby delete has different row count from that of gfxd gfxd deleted " + updateCount + " rows, but derby deleted " + count + " rows in " + TradeCustomersV1DMLDistTxStmt.getTableName();
            if (failAtUpdateCount) {
                throw new TestException(str);
            }
            Log.getLogWriter().info(str);
        }
    }

    protected boolean queryGfxdOnly(Connection gConn) {
        return true;
    }

    @Override
    public boolean queryGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.queryGfxdOnly(gConn);
        }
        int whichQuery = rand.nextInt(select.length);
        int tid = TradeCustomersV1DMLDistTxStmt.getMyTid();
        Connection nonTxConn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        long cid = TradeCustomersV1DMLDistTxStmt.getNewTypeCidFromQuery(nonTxConn, TradeCustomersV1DMLDistTxStmt.getTableName(), rand.nextBoolean() ? TradeCustomersV1DMLDistTxStmt.getMyTid() : rand.nextInt(SQLDistTxTest.numOfWorkers));
        Date since = TradeCustomersV1DMLDistTxStmt.getSince();
        ResultSet gfxdRS = null;
        SQLException gfxdse = null;
        String additionalWhereClause = TradeCustomersV1DMLDistTxStmt.getUpdatedPksByTx();
        try {
            gfxdRS = TradeCustomersV1DMLDistTxStmt.query(gConn, whichQuery, cid, since, tid, additionalWhereClause);
            if (gfxdRS == null) {
                throw new TestException("Not able to get gfxd result set");
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (batchingWithSecondaryData) {
                    this.verifyConflictNewTablesWithBatching(null, null, null, null, null, se, true);
                    return false;
                }
                throw new TestException("Select query in Read Committed isolation gets conflict exception without batching");
            }
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx without HA support, continue testing");
                return false;
            }
            SQLHelper.handleSQLException(se);
            gfxdse = se;
        }
        List<Struct> gfxdList = ResultSetHelper.asList(gfxdRS, false);
        if (gfxdList == null && isHATest) {
            Log.getLogWriter().info("Testing HA and did not get GFXD result set due to node failure");
            return true;
        }
        this.addQueryToDerbyTx(whichQuery, cid, since, additionalWhereClause, gfxdList, gfxdse);
        return true;
    }

    protected void addQueryToDerbyTx(int whichQuery, long cid, Date since, String additionalWhereClause, List<Struct> gfxdList, SQLException gfxdse) {
        Object[] data = new Object[]{1, "query", whichQuery, cid, since, additionalWhereClause, gfxdList, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    protected static ResultSet query(Connection conn, int whichQuery, long cid, Date since, int tid, String additionalWhereClause) throws SQLException {
        ResultSet rs = TradeCustomersV1DMLDistTxStmt.getQuery(conn, whichQuery, cid, since, tid, additionalWhereClause);
        return rs;
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, long cid, Date since, int tid, String additionalWhereClause) throws SQLException {
        ResultSet rs = null;
        String transactionId = (Integer)SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - " + transactionId + " ";
        int round = (Integer)SQLDistTxTest.iteration.get();
        String selectsql = select[whichQuery];
        if (queryOpTimeNewTables) {
            selectsql = selectsql.contains("group by") ? selectsql.substring(0, selectsql.indexOf("group")) + additionalWhereClause + selectsql.substring(selectsql.indexOf("group"), selectsql.length()) : (selectsql.contains("union") ? selectsql.substring(0, selectsql.indexOf("union")) + additionalWhereClause + selectsql.substring(selectsql.indexOf("union"), selectsql.length()) + additionalWhereClause : selectsql + additionalWhereClause);
        }
        String query = " QUERY: " + selectsql;
        Log.getLogWriter().info(query);
        try {
            PreparedStatement stmt = conn.prepareStatement(selectsql);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.customersv1 with TID:" + tid + ",ROUND:" + round + ",SINCE:" + since + ",CID:" + cid + query);
                    stmt.setInt(1, tid);
                    stmt.setInt(2, round);
                    stmt.setDate(3, since);
                    stmt.setLong(4, cid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.customersv1 with CID:" + cid + query);
                    stmt.setLong(1, cid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.customersv1 with CID:" + cid + ",CID: " + (cid - 10L) + query);
                    stmt.setLong(1, cid);
                    stmt.setLong(2, cid - 10L);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying trade.customersv1 with CID:" + cid + ",CID" + (cid - 10L) + ",CID:" + (cid - 20L) + query);
                    stmt.setLong(1, cid);
                    stmt.setLong(2, cid - 10L);
                    stmt.setLong(3, cid - 20L);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.customersv1 with CID:" + cid + ",ROUND:" + round + query);
                    stmt.setLong(1, cid);
                    stmt.setInt(2, round);
                    break;
                }
                case 5: {
                    String custName = TradeCustomersV1DMLDistTxStmt.getUnionCustNameWildcard(cid);
                    Log.getLogWriter().info(database + "querying trade.customersv1 with " + "CUSTNAME:" + custName + ",ROUND:" + round + ",TID:" + tid + ",CID:" + cid + ",ROUND:" + round + query);
                    stmt.setInt(2, round);
                    stmt.setString(1, custName);
                    stmt.setInt(3, tid);
                    stmt.setLong(4, cid);
                    stmt.setInt(5, round);
                    break;
                }
                case 6: {
                    Log.getLogWriter().info(database + "querying trade.customersv1 with substr(cust_name, 5, length(cust_name)-4) = '" + cid + "' or substr(addr, 16, length(addr)-15) = '" + (cid - 10L) + "',ROUND" + round + query);
                    stmt.setString(1, "" + cid);
                    stmt.setString(2, "" + (cid - 10L));
                    stmt.setInt(3, round);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return null;
            }
            throw se;
        }
        return rs;
    }

    protected static String getUpdatedPksByTx() {
        StringBuffer str = new StringBuffer();
        StringBuffer keyStr = new StringBuffer();
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        for (String key : modifiedKeysByTx.keySet()) {
            Log.getLogWriter().info(key);
            if (!key.startsWith(TradeCustomersV1DMLDistTxStmt.getTableName())) continue;
            String aKey = key.substring(TradeCustomersV1DMLDistTxStmt.getTableName().length() + 1, key.length());
            keyStr.append(" " + aKey + ",");
        }
        if (keyStr.length() > 0) {
            str.append(" and cid not in(");
            str.append(keyStr);
            str.replace(str.lastIndexOf(","), str.length(), ")");
        }
        Log.getLogWriter().info(str.toString());
        return str.toString();
    }

    protected static String getUnionCustNameWildcard(long i) {
        String str = i >= 10L ? Long.toString(i).substring(0, 2) : Long.toString(i);
        return "%me%" + str + "%";
    }

    @Override
    public void queryDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[7];
        List gfxdList = (List)data[6];
        ResultSet derbyRS = null;
        try {
            derbyRS = TradeCustomersV1DMLDistTxStmt.query(dConn, (Integer)data[2], (Long)data[3], (Date)data[4], TradeCustomersV1DMLDistTxStmt.getMyTid(), (String)data[5]);
            if (derbyRS == null) {
                throw new TestException("Test issue, does not expect there is no result from derby");
            }
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
        }
        ResultSetHelper.compareResultSets(ResultSetHelper.asList(derbyRS, true), gfxdList);
    }
}

