/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlDistTxStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlDistTxStatements.DMLDistTxStmtIF;
import sql.dmlStatements.TradeNetworthDMLStmt;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlTx.SQLTxPartitionInfoBB;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class TradeNetworthDMLDistTxStmt
extends TradeNetworthDMLStmt
implements DMLDistTxStmtIF {
    protected static String[] delete = new String[]{"delete from trade.networth where cid = ?", "delete from trade.networth where cid in (?,?)"};
    static final boolean isConcUpdateTx = TestConfig.tab().booleanAt(SQLPrms.isConcUpdateTx, false);
    public static boolean isReplicate;
    protected boolean hasSecondary = isReplicate || batchingWithSecondaryData && (Boolean)SQLBB.getBB().getSharedMap().get((Object)SQLTest.hasRedundancy) != false;
    protected static boolean ticket42669fixed;

    protected void insertToDerbyTable(Connection conn, int cid, BigDecimal[] cash, BigDecimal securities, int[] loanLimit, BigDecimal[] availLoan, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = TradeNetworthDMLDistTxStmt.getStmt(conn, insert);
        int tid = TradeNetworthDMLDistTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into derby, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            count = this.insertToTable(stmt, cid, cash[i], securities, loanLimit[i], availLoan[i], tid);
            if (count == updateCount[i]) continue;
            Log.getLogWriter().info("derby insert has different row count from that of gfxd gfxd inserted " + updateCount[i] + " row, but derby inserted " + count + " row");
        }
    }

    protected void insertToGfxdTable(Connection conn, int cid, BigDecimal[] cash, BigDecimal securities, int[] loanLimit, BigDecimal[] availLoan, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        stmt = SQLTest.isEdge && !isTicket48176Fixed && isHATest ? TradeNetworthDMLDistTxStmt.getStmtThrowException(conn, insert) : conn.prepareStatement(insert);
        int tid = TradeNetworthDMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            updateCount[i] = this.insertToTable(stmt, cid, cash[i], securities, loanLimit[i], availLoan[i], tid);
        }
    }

    protected void insertToGfxdOnlyTable(Connection conn, int cid, BigDecimal[] cash, BigDecimal securities, int[] loanLimit, BigDecimal[] availLoan, int size) {
        PreparedStatement stmt = TradeNetworthDMLDistTxStmt.getStmt(conn, insert);
        int tid = TradeNetworthDMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, cid, cash[i], securities, loanLimit[i], availLoan[i], tid);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23503")) {
                    Log.getLogWriter().info("detected foreign key constraint violation during insert, continuing test");
                }
                if (se.getSQLState().equals("23505")) {
                    Log.getLogWriter().info("detected duplicate primary key constraint violation during insert, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected void updateGfxdTable(Connection conn, int[] cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, int[] whichUpdate, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        int tid = TradeNetworthDMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(conn, whichUpdate[i], null) : TradeNetworthDMLDistTxStmt.getStmt(conn, update[whichUpdate[i]]);
            if (stmt == null) continue;
            updateCount[i] = this.updateTable(stmt, cid[i], availLoanDelta[i], sec[i], cashDelta[i], newLoanLimit[i], tid, whichUpdate[i]);
        }
    }

    protected void updateDerbyTable(Connection conn, int[] cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, int[] whichUpdate, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        int tid = TradeNetworthDMLDistTxStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            boolean[] unsupported = new boolean[1];
            stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(conn, whichUpdate[i], unsupported) : TradeNetworthDMLDistTxStmt.getStmt(conn, update[whichUpdate[i]]);
            if (stmt == null || (count = this.updateTable(stmt, cid[i], availLoanDelta[i], sec[i], cashDelta[i], newLoanLimit[i], tid, whichUpdate[i])) == updateCount[i]) continue;
            Log.getLogWriter().info("Derby update has different row count from that of gfxd, gfxd updated " + updateCount[i] + " rows, but derby updated " + count + " rows");
        }
    }

    protected void updateGfxdOnlyTable(Connection conn, int[] cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, int[] whichUpdate, int size) {
        PreparedStatement stmt = null;
        int tid = TradeNetworthDMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(conn, whichUpdate[i], null) : TradeNetworthDMLDistTxStmt.getStmt(conn, update[whichUpdate[i]]);
            try {
                if (stmt == null) continue;
                this.updateTable(stmt, cid[i], availLoanDelta[i], sec[i], cashDelta[i], newLoanLimit[i], tid, whichUpdate[i]);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23513")) {
                    Log.getLogWriter().info("detected the constraint check violation, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    @Override
    public boolean insertGfxd(Connection gConn, boolean withDerby) {
        return true;
    }

    public boolean insertGfxd(Connection gConn, boolean withDerby, int cid) {
        if (!withDerby) {
            return this.insertGfxdOnly(gConn, cid);
        }
        int size = 1;
        BigDecimal[] cash = new BigDecimal[size];
        int[] loanLimit = new int[size];
        BigDecimal[] availLoan = new BigDecimal[size];
        int[] updateCount = new int[size];
        this.getDataForInsert(cash, loanLimit, availLoan, size);
        BigDecimal securities = new BigDecimal(Integer.toString(0));
        SQLException gfxdse = null;
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        modifiedKeysByOp.put(TradeNetworthDMLDistTxStmt.getTableName() + "_" + cid, (Integer)SQLDistTxTest.curTxId.get());
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            this.insertToGfxdTable(gConn, cid, cash, securities, loanLimit, availLoan, updateCount, size);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, se, true);
                } else {
                    this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, se, this.hasSecondary, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, gfxdse, false);
        } else {
            this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, gfxdse, this.hasSecondary, false);
        }
        this.addInsertToDerbyTx(cid, cash, loanLimit, availLoan, securities, updateCount, gfxdse);
        modifiedKeysByTx.putAll(modifiedKeysByOp);
        SQLDistTxTest.curTxModifiedKeys.set((Object)modifiedKeysByTx);
        return true;
    }

    protected void addInsertToDerbyTx(int cid, BigDecimal[] cash, int[] loanLimit, BigDecimal[] availLoan, BigDecimal securities, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{4, "insert", cid, cash, loanLimit, availLoan, securities, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void insertDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[8];
        try {
            this.insertToDerbyTable(dConn, (Integer)data[2], (BigDecimal[])data[3], (BigDecimal)data[6], (int[])data[4], (BigDecimal[])data[5], (int[])data[7], 1);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    public static String getTableName() {
        return "networth";
    }

    @Override
    public boolean updateGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.updateGfxdOnly(gConn);
        }
        int size = 1;
        int[] whichUpdate = new int[size];
        int[] cid = new int[size];
        BigDecimal[] availLoanDelta = new BigDecimal[size];
        BigDecimal[] sec = new BigDecimal[size];
        BigDecimal[] cashDelta = new BigDecimal[size];
        int[] newLoanLimit = new int[size];
        int[] updateCount = new int[size];
        SQLException gfxdse = null;
        Connection nonTxConn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        this.getDataForUpdate(nonTxConn, cid, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate, size);
        int tid = rand.nextInt(SQLDistTxTest.numOfWorkers);
        cid[0] = TradeNetworthDMLDistTxStmt.getCidFromQuery((Connection)SQLDistTxTest.gfxdNoneTxConn.get(), rand.nextBoolean() ? TradeNetworthDMLDistTxStmt.getMyTid() : tid);
        whichUpdate[0] = this.getWhichUpdate(whichUpdate[0]);
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            this.getKeysForUpdate(nonTxConn, modifiedKeysByOp, whichUpdate[0], cid[0], sec[0]);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().warning("Not able to process the keys for this op due to HA, this insert op does not proceed");
                return true;
            }
            SQLHelper.handleSQLException(se);
        }
        try {
            this.updateGfxdTable(gConn, cid, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate, updateCount, size);
            if (isHATest && ((Boolean)SQLDistTxTest.failedToGetStmtNodeFailure.get()).booleanValue()) {
                SQLDistTxTest.failedToGetStmtNodeFailure.set((Object)false);
                return false;
            }
            if (((Boolean)SQLDistTxTest.updateOnPartitionCol.get()).booleanValue()) {
                SQLDistTxTest.updateOnPartitionCol.set((Object)false);
                return true;
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, se, true);
                } else {
                    this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, se, this.hasSecondary, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, gfxdse, false);
        } else {
            this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, gfxdse, this.hasSecondary, false);
        }
        this.addUpdateToDerbyTx(cid, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate, updateCount, gfxdse);
        if (gfxdse == null) {
            modifiedKeysByTx.putAll(modifiedKeysByOp);
            SQLDistTxTest.curTxModifiedKeys.set((Object)modifiedKeysByTx);
        }
        return true;
    }

    protected void addUpdateToDerbyTx(int[] cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, int[] whichUpdate, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{4, "update", cid, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void updateDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[9];
        try {
            this.updateDerbyTable(dConn, (int[])data[2], (BigDecimal[])data[3], (BigDecimal[])data[4], (BigDecimal[])data[5], (int[])data[6], (int[])data[7], (int[])data[8], 1);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    private int getWhichUpdate(int index) {
        if (index < update.length / 2) {
            index += update.length / 2;
        }
        if (index == 5 && ((Boolean)SQLDistTxTest.commitEarly.get()).booleanValue()) {
            index = 7;
        } else if (index == 7 && !((Boolean)SQLDistTxTest.commitEarly.get()).booleanValue()) {
            index = 5;
        }
        if (index == 7) {
            index = 5;
        }
        return index;
    }

    protected void getKeysForUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int cid, BigDecimal securities) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        switch (whichUpdate) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                throw new TestException("should use only non unique key case");
            }
            case 4: 
            case 5: 
            case 6: {
                sql = "select cid from trade.networth where cid=" + cid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info(database + "CID:" + cid + " exists for update");
                    keys.put(TradeNetworthDMLDistTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 7: {
                sql = "select cid from trade.networth where securities >" + securities;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info(database + "CID:" + availCid + " exists for update");
                    keys.put(TradeNetworthDMLDistTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    @Override
    public boolean deleteGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.deleteGfxdOnly(gConn);
        }
        int whichDelete = rand.nextInt(delete.length);
        int cid = TradeNetworthDMLDistTxStmt.getExistingCid();
        int cid1 = TradeNetworthDMLDistTxStmt.getExistingCid();
        int[] updateCount = new int[1];
        SQLException gfxdse = null;
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        Connection nonTxConn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        try {
            this.getKeysForDelete(nonTxConn, modifiedKeysByOp, whichDelete, cid, cid1);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().warning("Not able to process the keys for this op due to HA, this insert op does not proceed");
                return true;
            }
            SQLHelper.handleSQLException(se);
        }
        try {
            this.deleteFromGfxdTable(gConn, cid, cid1, whichDelete, updateCount);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, se, true);
                } else {
                    this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, se, this.hasSecondary, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, gfxdse, false);
        } else {
            this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, gfxdse, this.hasSecondary, false);
        }
        this.addDeleteToDerbyTx(cid, cid1, whichDelete, updateCount[0], gfxdse);
        modifiedKeysByTx.putAll(modifiedKeysByOp);
        SQLDistTxTest.curTxModifiedKeys.set((Object)modifiedKeysByTx);
        return true;
    }

    protected void addDeleteToDerbyTx(int cid, int cid1, int whichDelete, int updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{4, "delete", cid, cid1, whichDelete, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    protected void deleteFromGfxdTable(Connection gConn, int cid, int cid1, int whichDelete, int[] updateCount) throws SQLException {
        PreparedStatement stmt = null;
        stmt = SQLTest.isEdge && !isTicket48176Fixed && isHATest ? TradeNetworthDMLDistTxStmt.getStmtThrowException(gConn, delete[whichDelete]) : gConn.prepareStatement(delete[whichDelete]);
        updateCount[0] = this.deleteFromTableTx(stmt, cid, cid1, whichDelete);
    }

    protected void deleteFromDerbyTable(Connection dConn, int cid, int cid1, int whichDelete, int updateCount) throws SQLException {
        PreparedStatement stmt = TradeNetworthDMLDistTxStmt.getStmt(dConn, delete[whichDelete]);
        int count = this.deleteFromTableTx(stmt, cid, cid1, whichDelete);
        if (count != updateCount) {
            Log.getLogWriter().info("derby delete has different row count from that of gfxd gfxd deleted " + updateCount + " rows, but derby deleted " + count + " rows in " + TradeNetworthDMLDistTxStmt.getTableName());
        }
    }

    protected int deleteFromTableTx(PreparedStatement stmt, int cid, int cid1, int whichDelete) throws SQLException {
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        String query = " QUERY: " + delete[whichDelete];
        String completionMessage = "";
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting from trade.networth with CID: " + cid + query);
                stmt.setInt(1, cid);
                completionMessage = " rows from trade.networth with CID: " + cid + query;
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting from trade.networth with 1_CID: " + cid + ",2_CID:" + cid1 + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, cid1);
                completionMessage = " rows from trade.networth with 1_CID: " + cid + ",2_CID:" + cid1 + query;
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + " deleted " + rowCount + completionMessage);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    private void getKeysForDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int cid, int cid1) throws SQLException {
        String sql = null;
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        ResultSet rs = null;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        switch (whichDelete) {
            case 0: {
                sql = "select cid from trade.networth where cid = " + cid;
                Log.getLogWriter().info(database + sql);
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    int cidKey = rs.getInt("CID");
                    ids.add(cidKey);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select cid from trade.networth where cid in (?, ? )";
                Log.getLogWriter().info(database + sql);
                PreparedStatement stmt = conn.prepareStatement(sql);
                stmt.setInt(1, cid);
                stmt.setInt(2, cid1);
                rs = stmt.executeQuery();
                List<Struct> resultsList = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
                if (resultsList == null) break;
                for (Struct row : resultsList) {
                    Integer cidKey = (Integer)row.get("CID");
                    ids.add(cidKey);
                }
                break;
            }
            default: {
                throw new TestException("wrong index here");
            }
        }
        for (Integer key : ids) {
            keys.put(TradeNetworthDMLDistTxStmt.getTableName() + "_" + key, txId);
        }
    }

    @Override
    public void deleteDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[6];
        try {
            this.deleteFromDerbyTable(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (Integer)data[5]);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
        }
    }

    @Override
    public boolean queryGfxd(Connection gConn, boolean withDerby) {
        List<Struct> gfxdList;
        if (!withDerby) {
            return this.queryGfxdOnly(gConn);
        }
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        int cash = 100000;
        int sec = 100000;
        int tid = TradeNetworthDMLDistTxStmt.getMyTid();
        int loanLimit = loanLimits[rand.nextInt(loanLimits.length)];
        BigDecimal loanAmount = new BigDecimal(Integer.toString(rand.nextInt(loanLimit)));
        BigDecimal queryCash = new BigDecimal(Integer.toString(rand.nextInt(cash)));
        BigDecimal querySec = new BigDecimal(Integer.toString(rand.nextInt(sec)));
        ResultSet gfxdRS = null;
        SQLException gfxdse = null;
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            gfxdRS = TradeNetworthDMLDistTxStmt.query(gConn, whichQuery, queryCash, querySec, loanLimit, loanAmount, tid);
            if (gfxdRS == null) {
                throw new TestException("Not able to get gfxd result set");
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (batchingWithSecondaryData) {
                    this.verifyConflictWithBatching(new HashMap<String, Integer>(), modifiedKeysByTx, se, this.hasSecondary, true);
                    return false;
                }
            } else {
                if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                    SQLHelper.printSQLException(se);
                    Log.getLogWriter().info("got node failure exception during Tx without HA support, continue testing");
                    return false;
                }
                SQLHelper.handleSQLException(se);
            }
            gfxdse = se;
        }
        if ((gfxdList = ResultSetHelper.asList(gfxdRS, false)) == null && isHATest) {
            Log.getLogWriter().info("Testing HA and did not get GFXD result set due to node failure");
            return false;
        }
        this.addQueryToDerbyTx(whichQuery, queryCash, querySec, loanLimit, loanAmount, tid, gfxdList, gfxdse);
        return true;
    }

    protected void addQueryToDerbyTx(int whichQuery, BigDecimal queryCash, BigDecimal querySec, int loanLimit, BigDecimal loanAmount, int tid, List<Struct> gfxdList, SQLException gfxdse) {
        Object[] data = new Object[]{4, "query", whichQuery, queryCash, querySec, loanLimit, loanAmount, tid, gfxdList, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void queryDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[9];
        List gfxdList = (List)data[8];
        ResultSet derbyRS = null;
        try {
            derbyRS = TradeNetworthDMLDistTxStmt.query(dConn, (Integer)data[2], (BigDecimal)data[3], (BigDecimal)data[4], (Integer)data[5], (BigDecimal)data[6], (Integer)data[7]);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
        }
        ResultSetHelper.compareResultSets(ResultSetHelper.asList(derbyRS, true), gfxdList);
    }

    @Override
    protected void getDataForUpdate(Connection conn, int[] cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, int[] whichUpdate, int size) {
        int maxAvailLimitDelta = 10000;
        int maxCashDelta = 10000;
        int maxSec = 1000000;
        for (int i = 0; i < size; ++i) {
            cid[i] = testUniqueKeys ? TradeNetworthDMLDistTxStmt.getCid(conn) : TradeNetworthDMLDistTxStmt.getExistingCid();
            availLoanDelta[i] = this.getBigDecimal(Double.toString((double)rand.nextInt(maxAvailLimitDelta * 100 + 1) * 0.01));
            sec[i] = this.getBigDecimal(Double.toString((double)rand.nextInt(maxSec * 100 + 1) * 0.01));
            cashDelta[i] = this.getBigDecimal(Double.toString((double)rand.nextInt(maxCashDelta * 100 + 1) * 0.01));
            newLoanLimit[i] = loanLimits[rand.nextInt(loanLimits.length)];
            whichUpdate[i] = isConcUpdateTx ? this.getWhichConcUpdate(numOfNonUniqUpdate, update.length) : this.getWhichOne(numOfNonUniqUpdate, update.length);
        }
    }

    protected BigDecimal getBigDecimal(String s) {
        String p = s.substring(0, s.indexOf(".") + 2);
        if (!ticket42669fixed) {
            return new BigDecimal(p);
        }
        return new BigDecimal(s);
    }

    protected boolean insertGfxdOnly(Connection gConn, int cid) {
        try {
            this.insert(null, gConn, 1, new int[]{cid});
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (te.getMessage().contains("23505")) {
                Log.getLogWriter().info("detected duplicate primary key constraint violation during insert, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected boolean updateGfxdOnly(Connection gConn) {
        try {
            this.update(null, gConn, 1);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected int getWhichConcUpdate(int numOfNonUniq, int total) {
        int whichOne = super.getWhichOne(numOfNonUniq, total);
        if (isConcUpdateTx && (whichOne == 1 || whichOne == 5)) {
            ++whichOne;
        }
        return whichOne;
    }

    protected boolean deleteGfxdOnly(Connection gConn) {
        try {
            this.delete(null, gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected boolean queryGfxdOnly(Connection gConn) {
        try {
            this.query(null, gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02") && batchingWithSecondaryData) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        try {
            super.insert(dConn, gConn, size);
        }
        catch (TestException te) {
            if (dConn == null & te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("concurrent insert could cause expected conflict exception");
            }
            throw te;
        }
    }

    protected PreparedStatement getCorrectTxStmt(Connection conn, int whichUpdate, boolean[] unsupported) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectStmt(conn, whichUpdate, partitionKeys, unsupported);
    }

    static {
        try {
            String partition = (String)SQLTxPartitionInfoBB.getBB().getSharedMap().get((Object)("trade." + TradeNetworthDMLDistTxStmt.getTableName()));
            isReplicate = partition.equalsIgnoreCase("replicate");
        }
        catch (NullPointerException npe) {
            isReplicate = false;
        }
        Log.getLogWriter().info("isReplicate is " + isReplicate);
        ticket42669fixed = TestConfig.tab().booleanAt(SQLPrms.isTicket42669fixed, false);
    }
}

