/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlDistTxStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlDistTxStatements.DMLDistTxStmtIF;
import sql.dmlDistTxStatements.TradeCustomersV1DMLDistTxStmt;
import sql.dmlStatements.TradeNetworthDMLStmt;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class TradeNetworthV1DMLDistTxStmt
extends TradeNetworthDMLStmt
implements DMLDistTxStmtIF {
    protected static String insert = "insert into trade.networthv1 values (?,?,?,?,?,?,?,?)";
    protected static String[] update = new String[]{"update trade.networthv1 set c_cid=?,  round = ? where cid = ? ", "update trade.networthv1 set availloan=availloan-?, round = ?  where cid in (?, ?)", "update trade.networthv1 set cash=cash-?, round = ?  where cid in (select min(cid) from trade.networthv1 where (securities>? and cash > ? and cid >=?)and round < ?) ", "update trade.networthv1 set loanLimit=?, round = ?  where  tid= ?  and round < ? and securities > ? and securities < ?", "update trade.networthv1 set availloan=availloan+? ,  round = ? where c_cid = ? and round < ?", "update trade.networthv1 set c_cid = (select max(c.cid) from trade.customersv1 c where (c.since >= ? or c.cid < ? ) and c.round <?), round = ? where cid = ?  "};
    protected static String[] delete = new String[]{"delete from trade.networthv1 where cid = ?", "delete from trade.networthv1 where cid <=? and cid> ? and (cash>? or availloan <?) and round <?"};
    protected static String[] select = new String[]{"select * from trade.networthv1 where cid <? and cid >= ? ", "select a.cid, (a.cash + a.securities - (a.loanLimit - a.availloan)) as networthv1 from (select cid, cash, securities, loanLimit, availloan from trade.networthv1 where securities <? and cash >?) as a where a.cid<? ", "select cid, loanlimit, availloan from trade.networthv1 where loanlimit >? and loanlimit-availloan <= ?", "select cid, cash, securities, round from trade.networthv1 where (cash<? or securities >=?) ", "select * from trade.networthv1 where cash > loanLimit - availloan and c_cid < ?", "select cash, securities, loanlimit, cid, availloan, c_cid from trade.networthv1 where (c_cid<? or cash > loanLimit - availloan)", "select securities, cash, availloan, loanlimit, cid, availloan, round from trade.networthv1 where (availloan >=securities or cash > loanLimit - availloan)"};
    protected static final String RANGE = "500";
    protected static final int CIDRANGE = 10;
    protected static boolean reproduce50649 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50649, true);
    protected static boolean reproduce50607 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50607, false);
    protected static boolean reproduce50608 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50608, true);
    protected static boolean reproduce50609 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50609, true);
    protected static boolean reproduce50610 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50610, true);
    protected static boolean reproduce50658 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50658, true);
    protected static boolean reproduce50710 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50710, true);

    @Override
    public boolean insertGfxd(Connection gConn, boolean withDerby) {
        return true;
    }

    public boolean insertGfxd(Connection gConn, boolean withDerby, long cid) {
        if (!withDerby) {
            return this.insertGfxdOnly(gConn, cid);
        }
        int size = 1;
        BigDecimal[] cash = new BigDecimal[size];
        int[] loanLimit = new int[size];
        BigDecimal[] availLoan = new BigDecimal[size];
        int[] updateCount = new int[size];
        this.getDataForInsert(cash, loanLimit, availLoan, size);
        BigDecimal securities = new BigDecimal(Integer.toString(0));
        SQLException gfxdse = null;
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashMap<String, Integer> holdKeysBlockingChildByOp = new HashMap<String, Integer>();
        HashMap<String, Integer> holdNewParentKeysByOp = new HashMap<String, Integer>();
        modifiedKeysByOp.put(TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + cid, txId);
        holdNewParentKeysByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + cid, txId);
        try {
            this.insertToGfxdTable(gConn, cid, cash, securities, loanLimit, availLoan, updateCount, size);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflictNewTables(modifiedKeysByOp, holdKeysBlockingChildByOp, null, null, holdNewParentKeysByOp, se, true);
                } else {
                    this.verifyConflictNewTablesWithBatching(modifiedKeysByOp, holdKeysBlockingChildByOp, null, null, holdNewParentKeysByOp, se, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflictNewTables(modifiedKeysByOp, holdKeysBlockingChildByOp, null, null, holdNewParentKeysByOp, gfxdse, false);
        } else {
            this.verifyConflictNewTablesWithBatching(modifiedKeysByOp, holdKeysBlockingChildByOp, null, null, holdNewParentKeysByOp, gfxdse, false);
        }
        this.addInsertToDerbyTx(cid, cash, loanLimit, availLoan, securities, updateCount, gfxdse);
        return true;
    }

    protected void insertToGfxdTable(Connection conn, long cid, BigDecimal[] cash, BigDecimal securities, int[] loanLimit, BigDecimal[] availLoan, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        stmt = conn.prepareStatement(insert);
        int tid = TradeNetworthV1DMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            updateCount[i] = this.insertToTable(stmt, cid, cash[i], securities, loanLimit[i], availLoan[i], tid);
        }
    }

    protected void addInsertToDerbyTx(long cid, BigDecimal[] cash, int[] loanLimit, BigDecimal[] availLoan, BigDecimal securities, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{4, "insert", cid, cash, loanLimit, availLoan, securities, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    protected boolean insertGfxdOnly(Connection gConn, long cid) {
        Log.getLogWriter().info("needs implementation");
        return true;
    }

    public void insert(Connection dConn, Connection gConn, int size, long[] cid) {
        BigDecimal[] cash = new BigDecimal[size];
        int[] loanLimit = new int[size];
        BigDecimal[] availLoan = new BigDecimal[size];
        this.getDataForInsert(cash, loanLimit, availLoan, size);
        BigDecimal securities = new BigDecimal(Integer.toString(0));
        if (dConn != null) {
            throw new TestException("should not be executed here");
        }
        this.insertToGFETable(gConn, cid, cash, securities, loanLimit, availLoan, size);
    }

    protected void insertToGFETable(Connection conn, long[] cid, BigDecimal[] cash, BigDecimal securities, int[] loanLimit, BigDecimal[] availLoan, int size) {
        PreparedStatement stmt = TradeNetworthV1DMLDistTxStmt.getStmt(conn, insert);
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeNetworthV1DMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, cid[i], cash[i], securities, loanLimit[i], availLoan[i], tid);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23503")) {
                    Log.getLogWriter().info("detected foreign key constraint violation during insert, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42802")) {
                    Log.getLogWriter().info("Got expected column not found exception in insert, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("23505") && isHATest && SQLTest.isEdge) {
                    Log.getLogWriter().info("detected pk constraint violation during insert -- relaxing due to #43571, continuing test");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, long cid, BigDecimal cash, BigDecimal securities, int loanLimit, BigDecimal availLoan, int tid) throws SQLException {
        return this.insertToTable(stmt, cid, cash, securities, loanLimit, availLoan, tid, false);
    }

    protected int insertToTable(PreparedStatement stmt, long cid, BigDecimal cash, BigDecimal securities, int loanLimit, BigDecimal availLoan, int tid, boolean isPut) throws SQLException {
        String txid = SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        int round = (Integer)SQLDistTxTest.iteration.get();
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - " + txid + " ";
        Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.networthv1 with CID:" + cid + ",CASH:" + cash + ":SECURITIES," + securities + ",LOANLIMIT:" + loanLimit + ",AVAILLOAN:" + availLoan + ",TID:" + tid + ",ROUND:" + round + ",C_CID:" + cid);
        stmt.setLong(1, cid);
        stmt.setBigDecimal(2, cash);
        stmt.setBigDecimal(3, securities);
        stmt.setInt(4, loanLimit);
        stmt.setBigDecimal(5, availLoan);
        stmt.setInt(6, tid);
        stmt.setInt(7, round);
        stmt.setLong(8, cid);
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + (isPut ? "put" : "inserted ") + rowCount + " rows in trade.networthv1 with CID:" + cid + ",CASH:" + cash + ":SECURITIES," + securities + ",LOANLIMIT:" + loanLimit + ",AVAILLOAN:" + availLoan + ",TID:" + tid + ",ROUND:" + round + ",C_CID:" + cid);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    @Override
    public void insertDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[8];
        try {
            this.insertToDerbyTable(dConn, (Long)data[2], (BigDecimal[])data[3], (BigDecimal)data[6], (int[])data[4], (BigDecimal[])data[5], (int[])data[7], 1);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    protected void insertToDerbyTable(Connection conn, long cid, BigDecimal[] cash, BigDecimal securities, int[] loanLimit, BigDecimal[] availLoan, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = TradeNetworthV1DMLDistTxStmt.getStmt(conn, insert);
        int tid = TradeNetworthV1DMLDistTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into derby, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            count = this.insertToTable(stmt, cid, cash[i], securities, loanLimit[i], availLoan[i], tid);
            if (count == updateCount[i]) continue;
            String str = "derby insert has different row count from that of gfxd gfxd inserted " + updateCount[i] + " row, but derby inserted " + count + " row";
            if (failAtUpdateCount) {
                throw new TestException(str);
            }
            Log.getLogWriter().info(str);
        }
    }

    @Override
    public boolean updateGfxd(Connection gConn, boolean withDerby) {
        PreparedStatement stmt;
        if (!withDerby) {
            return this.updateGfxdOnly(gConn);
        }
        int size = 1;
        int[] whichUpdate = new int[size];
        long[] cid = new long[size];
        long[] c_cid = new long[size];
        BigDecimal[] availLoanDelta = new BigDecimal[size];
        BigDecimal[] sec = new BigDecimal[size];
        BigDecimal[] cashDelta = new BigDecimal[size];
        BigDecimal[] cash = new BigDecimal[size];
        Date[] since = new Date[size];
        int[] newLoanLimit = new int[size];
        int[] updateCount = new int[size];
        SQLException gfxdse = null;
        Connection nonTxConn = rand.nextBoolean() ? (Connection)SQLDistTxTest.gfxdNoneTxConn.get() : (Connection)SQLTest.derbyConnection.get();
        this.getDataForUpdate(nonTxConn, cid, c_cid, availLoanDelta, sec, cashDelta, newLoanLimit, since, cash, whichUpdate, size);
        if (!reproduce50607 && whichUpdate[0] == 5) {
            whichUpdate[0] = 2;
        }
        if (!(reproduce50608 && reproduce50609 || whichUpdate[0] != 1 && whichUpdate[0] != 0 && whichUpdate[0] != 4)) {
            whichUpdate[0] = 2;
        }
        if (!reproduce50610 && whichUpdate[0] == 3) {
            whichUpdate[0] = 2;
        }
        if (SQLTest.testPartitionBy && (stmt = this.getCorrectTxStmt(gConn, whichUpdate[0])) == null && ((Boolean)SQLDistTxTest.updateOnPartitionCol.get()).booleanValue()) {
            SQLDistTxTest.updateOnPartitionCol.set((Object)false);
            return true;
        }
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashMap<String, Integer> holdForeignKeysByOp = new HashMap<String, Integer>();
        HashMap<String, Integer> holdNewForeignKeysByOp = new HashMap<String, Integer>();
        boolean success = false;
        try {
            success = this.getKeysForUpdate(nonTxConn, modifiedKeysByOp, holdForeignKeysByOp, holdNewForeignKeysByOp, whichUpdate[0], cid[0], sec[0], cash[0], c_cid[0], since[0]);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().warning("Not able to process the keys for this op due to HA, this update op does not proceed");
                return true;
            }
            SQLHelper.handleSQLException(se);
        }
        if (!success) {
            Log.getLogWriter().info("not able to get the locking keys, treat as a no op");
            return true;
        }
        try {
            this.updateGfxdTable(gConn, cid, c_cid, availLoanDelta, sec, cashDelta, newLoanLimit, since, cash, whichUpdate, updateCount, size);
            if (isHATest && ((Boolean)SQLDistTxTest.failedToGetStmtNodeFailure.get()).booleanValue()) {
                SQLDistTxTest.failedToGetStmtNodeFailure.set((Object)false);
                return false;
            }
            if (((Boolean)SQLDistTxTest.updateOnPartitionCol.get()).booleanValue()) {
                SQLDistTxTest.updateOnPartitionCol.set((Object)false);
                return true;
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflictNewTables(modifiedKeysByOp, null, null, holdForeignKeysByOp, holdNewForeignKeysByOp, se, true);
                } else {
                    this.verifyConflictNewTablesWithBatching(modifiedKeysByOp, null, null, holdForeignKeysByOp, holdNewForeignKeysByOp, se, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflictNewTables(modifiedKeysByOp, null, null, holdForeignKeysByOp, holdNewForeignKeysByOp, gfxdse, false);
        } else {
            this.verifyConflictNewTablesWithBatching(modifiedKeysByOp, null, null, holdForeignKeysByOp, holdNewForeignKeysByOp, gfxdse, false);
        }
        this.addUpdateToDerbyTx(cid, c_cid, availLoanDelta, sec, cashDelta, newLoanLimit, since, cash, whichUpdate, updateCount, gfxdse);
        return true;
    }

    protected void getDataForUpdate(Connection conn, long[] cid, long[] c_cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, Date[] since, BigDecimal[] cash, int[] whichUpdate, int size) {
        int maxAvailLimitDelta = 10000;
        int maxCashDelta = 10000;
        int maxSec = 1000000;
        for (int i = 0; i < size; ++i) {
            cid[i] = TradeNetworthV1DMLDistTxStmt.getNewTypeCidFromQuery(conn, TradeNetworthV1DMLDistTxStmt.getTableName(), rand.nextBoolean() ? TradeNetworthV1DMLDistTxStmt.getMyTid() : rand.nextInt(SQLDistTxTest.numOfWorkers));
            c_cid[i] = TradeNetworthV1DMLDistTxStmt.getNewTypeCidFromQuery(conn, TradeCustomersV1DMLDistTxStmt.getTableName(), rand.nextBoolean() ? TradeNetworthV1DMLDistTxStmt.getMyTid() : rand.nextInt(SQLDistTxTest.numOfWorkers));
            availLoanDelta[i] = this.getBigDecimal(Double.toString((double)rand.nextInt(maxAvailLimitDelta * 100 + 1) * 0.01));
            sec[i] = this.getBigDecimal(Double.toString((double)rand.nextInt(maxSec * 100 + 1) * 0.01));
            cashDelta[i] = this.getBigDecimal(Double.toString((double)(rand.nextInt(maxCashDelta) + 1) * 0.1));
            newLoanLimit[i] = loanLimits[rand.nextInt(loanLimits.length)];
            since[i] = TradeNetworthV1DMLDistTxStmt.getSince();
            cash[i] = this.getCash();
            whichUpdate[i] = rand.nextInt(update.length);
        }
    }

    protected BigDecimal getCash() {
        int maxCash = 10000;
        int minCash = 1000;
        return this.getBigDecimal(Integer.toString(rand.nextInt(maxCash - minCash) + minCash));
    }

    protected BigDecimal getBigDecimal(String s) {
        String p = s.substring(0, s.indexOf(".") + 2);
        return new BigDecimal(p);
    }

    protected boolean getKeysForUpdate(Connection conn, HashMap<String, Integer> keys, HashMap<String, Integer> holdForeignKeysByOp, HashMap<String, Integer> holdNewForeignKeysByOp, int whichUpdate, long cid, BigDecimal sec, BigDecimal cash, long c_cid, Date since) throws SQLException {
        int tid = TradeNetworthV1DMLDistTxStmt.getMyTid();
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        int round = (Integer)SQLDistTxTest.iteration.get();
        String database = "gemfirexd - TXID:" + txId + " ";
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: {
                sql = "select cid, c_cid from trade.networthv1 where cid =" + cid;
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    long existingC_Cid = rs.getLong(2);
                    Log.getLogWriter().info(database + TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    Log.getLogWriter().info(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid + " fk to be held to block parent delete");
                    holdForeignKeysByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid, txId);
                    Log.getLogWriter().info(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + c_cid + " fk to be held  to block parent dml op");
                    holdNewForeignKeysByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + c_cid, txId);
                }
                break;
            }
            case 1: {
                sql = "select cid, c_cid from trade.networthv1 where cid in (" + cid + ", " + (cid - (long)tid) + ")";
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    long existingC_Cid = rs.getLong(2);
                    Log.getLogWriter().info(database + TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    Log.getLogWriter().info(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid + " fk to be held to block parent delete");
                    holdForeignKeysByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid, txId);
                }
                break;
            }
            case 2: {
                sql = "select cid, c_cid from trade.networthv1 where cid in (select min(cid) from trade.networthv1 where (securities>" + sec + " and cash > " + cash + " and cid >= " + cid + ") and round < " + round + ")";
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    long existingC_Cid = rs.getLong(2);
                    Log.getLogWriter().info(database + TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    Log.getLogWriter().info(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid + " fk to be held to block parent delete");
                    holdForeignKeysByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid, txId);
                }
                break;
            }
            case 3: {
                sql = "select cid, c_cid from trade.networthv1 where tid =" + tid + " and round < " + round + " and securities > " + sec + " and securities < " + sec.add(new BigDecimal(RANGE));
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    long existingC_Cid = rs.getLong(2);
                    Log.getLogWriter().info(database + TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    Log.getLogWriter().info(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid + " fk to be held to block parent delete");
                    holdForeignKeysByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid, txId);
                }
                break;
            }
            case 4: {
                sql = "select cid, c_cid from trade.networthv1 where c_cid = " + c_cid + " and round <" + round;
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    long existingC_Cid = rs.getLong(2);
                    Log.getLogWriter().info(database + TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    Log.getLogWriter().info(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid + " fk to be held to block parent delete");
                    holdForeignKeysByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid, txId);
                }
                break;
            }
            case 5: {
                sql = "select max(cid) from trade.customersv1 where (since >= '" + since + "' or cid < " + cid + ") and round <" + round;
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                long newc_cid = 0L;
                while (rs.next()) {
                    newc_cid = rs.getLong(1);
                    Log.getLogWriter().info(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + newc_cid + " fk to be held to block parent dml op");
                    holdNewForeignKeysByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + newc_cid, txId);
                }
                if (newc_cid == 0L) {
                    Log.getLogWriter().info(sql + " does not gets valid result");
                    return false;
                }
                sql = "select cid, c_cid from trade.networthv1 where cid = " + cid;
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                long availCid = 0L;
                while (rs.next()) {
                    availCid = rs.getLong(1);
                    long existingC_Cid = rs.getLong(2);
                    Log.getLogWriter().info(database + TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    Log.getLogWriter().info(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid + " fk to be held to block parent delete");
                    holdForeignKeysByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
        if (rs != null) {
            rs.close();
        }
        return true;
    }

    protected void updateGfxdTable(Connection conn, long[] cid, long[] c_cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, Date[] since, BigDecimal[] cash, int[] whichUpdate, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        int tid = TradeNetworthV1DMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(conn, whichUpdate[i]) : TradeNetworthV1DMLDistTxStmt.getStmt(conn, update[whichUpdate[i]]);
            if (stmt == null) continue;
            updateCount[i] = this.updateTable(stmt, cid[i], c_cid[i], availLoanDelta[i], sec[i], cashDelta[i], newLoanLimit[i], since[i], cash[i], tid, whichUpdate[i]);
        }
    }

    protected PreparedStatement getCorrectTxStmt(Connection conn, int whichUpdate) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectTxStmt(conn, whichUpdate, partitionKeys);
    }

    protected PreparedStatement getCorrectTxStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys) {
        PreparedStatement stmt = null;
        Log.getLogWriter().info("getting stmt for :" + update[whichUpdate]);
        switch (whichUpdate) {
            case 0: {
                stmt = TradeNetworthV1DMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("availloan")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeNetworthV1DMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("cash")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeNetworthV1DMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("loanLimit")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeNetworthV1DMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 4: {
                if (partitionKeys.contains("availloan")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeNetworthV1DMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 5: {
                stmt = TradeNetworthV1DMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected int updateTable(PreparedStatement stmt, long cid, long c_cid, BigDecimal availLoanDelta, BigDecimal sec, BigDecimal cashDelta, int newLoanLimit, Date since, BigDecimal cash, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        int round = (Integer)SQLDistTxTest.iteration.get();
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + update[whichUpdate];
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(database + "updating trade.networthv1 with C_CID:" + c_cid + ",ROUND:" + round + " where CID:" + cid + query);
                stmt.setLong(1, c_cid);
                stmt.setInt(2, round);
                stmt.setLong(3, cid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in trade.networthv1 with C_CID:" + c_cid + ",ROUND:" + round + " where CID:" + cid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "updating trade.networthv1 with AVAILLOANDELTA:" + availLoanDelta + ",ROUND:" + round + " where CID IN(" + cid + "," + (cid - (long)tid) + ")" + query);
                stmt.setBigDecimal(1, availLoanDelta);
                stmt.setInt(2, round);
                stmt.setLong(3, cid);
                stmt.setLong(4, cid - (long)tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in trade.networthv1 with AVAILLOANDELTA:" + availLoanDelta + ",ROUND:" + round + " where CID IN(" + cid + "," + (cid - (long)tid) + ")" + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "updating trade.networthv1 with CASHDELTA:" + cashDelta + ",ROUND:" + round + " where SECURITIES:" + sec + ",CASH:" + cash + ",CID:" + cid + ",ROUND:" + round + query);
                stmt.setBigDecimal(1, cashDelta);
                stmt.setInt(2, round);
                stmt.setBigDecimal(3, sec);
                stmt.setBigDecimal(4, cash);
                stmt.setLong(5, cid);
                stmt.setInt(6, round);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in " + "trade.networthv1 with CASHDELTA:" + cashDelta + ",ROUND:" + round + " where SECURITIES:" + sec + ",CASH:" + cash + ",CID:" + cid + ",ROUND:" + round + query);
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "updating trade.networthv1 with LOANLIMIT:" + newLoanLimit + ",ROUND:" + round + " where TID:" + tid + ",ROUND:" + round + ",SECURITIES:" + sec + " AND SECURITIES:" + sec.add(new BigDecimal(RANGE)) + query);
                stmt.setInt(1, newLoanLimit);
                stmt.setInt(2, round);
                stmt.setInt(3, tid);
                stmt.setInt(4, round);
                stmt.setBigDecimal(5, sec);
                stmt.setBigDecimal(6, sec.add(new BigDecimal(RANGE)));
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in trade.networthv1 with LOANLIMIT:" + newLoanLimit + ",ROUND:" + round + " where TID:" + tid + ",ROUND:" + round + ",SECURITIES:" + sec + " AND SECURITIES:" + sec.add(new BigDecimal(RANGE)) + query);
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "updating trade.networthv1 with AVAILLOANDELTA:" + availLoanDelta + ",ROUND:" + round + " where C_CID:" + c_cid + ",ROUND:" + round + query);
                stmt.setBigDecimal(1, availLoanDelta);
                stmt.setInt(2, round);
                stmt.setLong(3, c_cid);
                stmt.setInt(4, round);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in trade.networthv1 with AVAILLOANDELTA:" + availLoanDelta + ",ROUND:" + round + " where C_CID:" + c_cid + ",ROUND:" + round + query);
                break;
            }
            case 5: {
                Log.getLogWriter().info(database + "updating trade.networthv1 with C.SINCE:" + since + ",C.CID:" + cid + ",C.ROUND:" + round + ",ROUND:" + round + " where CID:" + cid + query);
                stmt.setDate(1, since);
                stmt.setLong(2, cid);
                stmt.setInt(3, round);
                stmt.setInt(4, round);
                stmt.setLong(5, cid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in trade.networthv1 with C.SINCE:" + since + ",C.CID:" + cid + ",C.ROUND:" + round + ",ROUND:" + round + " where CID:" + cid + query);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void addUpdateToDerbyTx(long[] cid, long[] c_cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, Date[] since, BigDecimal[] cash, int[] whichUpdate, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{4, "update", cid, c_cid, availLoanDelta, sec, cashDelta, newLoanLimit, since, cash, whichUpdate, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void updateDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[12];
        try {
            this.updateDerbyTable(dConn, (long[])data[2], (long[])data[3], (BigDecimal[])data[4], (BigDecimal[])data[5], (BigDecimal[])data[6], (int[])data[7], (Date[])data[8], (BigDecimal[])data[9], (int[])data[10], (int[])data[11], 1);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    protected void updateDerbyTable(Connection conn, long[] cid, long[] c_cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, Date[] since, BigDecimal[] cash, int[] whichUpdate, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        int tid = TradeNetworthV1DMLDistTxStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(conn, whichUpdate[i]) : TradeNetworthV1DMLDistTxStmt.getStmt(conn, update[whichUpdate[i]]);
            if (stmt == null || (count = this.updateTable(stmt, cid[i], c_cid[i], availLoanDelta[i], sec[i], cashDelta[i], newLoanLimit[i], since[i], cash[i], tid, whichUpdate[i])) == updateCount[i]) continue;
            String str = "Derby update has different row count from that of gfxd, gfxd updated " + updateCount[i] + " rows, but derby updated " + count + " rows";
            if (failAtUpdateCount) {
                throw new TestException(str);
            }
            Log.getLogWriter().info(str);
        }
    }

    protected boolean updateGfxdOnly(Connection gConn) {
        Log.getLogWriter().info("needs implementation");
        return true;
    }

    @Override
    public boolean deleteGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.deleteGfxdOnly(gConn);
        }
        int whichDelete = rand.nextInt(delete.length);
        if (!reproduce50649 && whichDelete == 0) {
            ++whichDelete;
        }
        if (!reproduce50658 && whichDelete == 1) {
            --whichDelete;
        }
        if (!reproduce50658 && !reproduce50649) {
            Log.getLogWriter().info("could not execute delete stmt due to bugs");
            return true;
        }
        long[] cid = new long[1];
        int[] updateCount = new int[1];
        int tid = TradeNetworthV1DMLDistTxStmt.getMyTid();
        BigDecimal[] cash = new BigDecimal[1];
        BigDecimal[] availloan = new BigDecimal[1];
        SQLException gfxdse = null;
        cash[0] = this.getCash();
        availloan[0] = this.getCash();
        Connection nonTxConn = rand.nextBoolean() ? (Connection)SQLDistTxTest.gfxdNoneTxConn.get() : (Connection)SQLTest.derbyConnection.get();
        cid[0] = TradeNetworthV1DMLDistTxStmt.getNewTypeCidFromQuery(nonTxConn, TradeNetworthV1DMLDistTxStmt.getTableName(), rand.nextBoolean() ? TradeNetworthV1DMLDistTxStmt.getMyTid() : rand.nextInt(SQLDistTxTest.numOfWorkers));
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashMap<String, Integer> holdForeignKeysByOp = new HashMap<String, Integer>();
        HashMap<String, Integer> holdNewForeignKeysByOp = new HashMap<String, Integer>();
        try {
            this.getKeysForDelete(nonTxConn, modifiedKeysByOp, holdForeignKeysByOp, whichDelete, cid[0], cash[0], availloan[0], tid);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().warning("Not able to process the keys for this op due to HA, this update op does not proceed");
                return true;
            }
            SQLHelper.handleSQLException(se);
        }
        try {
            this.deleteFromGfxdTable(gConn, cid, cash, availloan, whichDelete, updateCount);
            if (isHATest && ((Boolean)SQLDistTxTest.failedToGetStmtNodeFailure.get()).booleanValue()) {
                SQLDistTxTest.failedToGetStmtNodeFailure.set((Object)false);
                return false;
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflictNewTables(modifiedKeysByOp, null, null, holdForeignKeysByOp, holdNewForeignKeysByOp, se, true);
                } else {
                    this.verifyConflictNewTablesWithBatching(modifiedKeysByOp, null, null, holdForeignKeysByOp, holdNewForeignKeysByOp, se, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflictNewTables(modifiedKeysByOp, null, null, holdForeignKeysByOp, holdNewForeignKeysByOp, gfxdse, false);
        } else {
            this.verifyConflictNewTablesWithBatching(modifiedKeysByOp, null, null, holdForeignKeysByOp, holdNewForeignKeysByOp, gfxdse, false);
        }
        this.addDeleteToDerbyTx(cid[0], cash[0], availloan[0], whichDelete, updateCount[0], gfxdse);
        return true;
    }

    protected void addDeleteToDerbyTx(long cid, BigDecimal cash, BigDecimal availloan, int whichDelete, int updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{4, "delete", cid, cash, availloan, whichDelete, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    protected void getKeysForDelete(Connection conn, HashMap<String, Integer> keys, HashMap<String, Integer> holdForeignKeysByOp, int whichDelete, long cid, BigDecimal cash, BigDecimal availloan, int tid) throws SQLException {
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        int round = (Integer)SQLDistTxTest.iteration.get();
        String database = "gemfirexd - TXID:" + txId + " ";
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select cid, c_cid from trade.networthv1 where cid =" + cid;
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    long existingC_Cid = rs.getLong(2);
                    Log.getLogWriter().info(database + TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    Log.getLogWriter().info(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid + " fk to be held to block parent delete");
                    holdForeignKeysByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid, txId);
                }
                break;
            }
            case 1: {
                sql = "select cid, c_cid from trade.networthv1 where cid <=" + cid + " and cid > " + (cid - 10L) + " and (cash >" + cash + " or availloan<" + availloan + ") and round<" + round;
                Log.getLogWriter().info("executing stmt:" + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    long availCid = rs.getLong(1);
                    long existingC_Cid = rs.getLong(2);
                    Log.getLogWriter().info(database + TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid + " exists for update");
                    keys.put(TradeNetworthV1DMLDistTxStmt.getTableName() + "_" + availCid, txId);
                    Log.getLogWriter().info(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid + " fk to be held to block parent delete");
                    holdForeignKeysByOp.put(TradeCustomersV1DMLDistTxStmt.getTableName() + "_" + existingC_Cid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong delete statement here");
            }
        }
    }

    protected void deleteFromGfxdTable(Connection gConn, long[] cid, BigDecimal[] cash, BigDecimal[] availloan, int whichDelete, int[] updateCount) throws SQLException {
        PreparedStatement stmt = null;
        stmt = SQLTest.isEdge && !isTicket48176Fixed && isHATest ? TradeNetworthV1DMLDistTxStmt.getStmtThrowException(gConn, delete[whichDelete]) : gConn.prepareStatement(delete[whichDelete]);
        updateCount[0] = this.deleteFromTable(stmt, cid[0], cash[0], availloan[0], whichDelete);
    }

    protected int deleteFromTable(PreparedStatement stmt, long cid, BigDecimal cash, BigDecimal availloan, int whichDelete) throws SQLException {
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        int round = (Integer)SQLDistTxTest.iteration.get();
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        String query = " QUERY: " + delete[whichDelete];
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleteing from trade.networthv1 " + "with CID:" + cid + query);
                stmt.setLong(1, cid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows from " + "trade.networthv1 with CID:" + cid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleteing from trade.networthv1 with" + " CID:" + cid + ",CID:" + (cid - 10L) + ",CASH:" + cash + ",AVAILLOAN:" + availloan + ",ROUND:" + round + query);
                stmt.setLong(1, cid);
                stmt.setLong(2, cid - 10L);
                stmt.setBigDecimal(3, cash);
                stmt.setBigDecimal(4, availloan);
                stmt.setInt(5, round);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows from " + "trade.networthv1 with" + " CID:" + cid + ",CID:" + (cid - 10L) + ",CASH:" + cash + ",AVAILLOAN:" + availloan + ",ROUND:" + round + query);
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected boolean deleteGfxdOnly(Connection gConn) {
        Log.getLogWriter().info("needs implementation");
        return true;
    }

    public static String getTableName() {
        return "networthv1";
    }

    @Override
    public void deleteDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[7];
        try {
            this.deleteFromDerbyTable(dConn, (Long)data[2], (BigDecimal)data[3], (BigDecimal)data[4], (Integer)data[5], (Integer)data[6]);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    protected void deleteFromDerbyTable(Connection dConn, long cid, BigDecimal cash, BigDecimal availloan, int whichDelete, int updateCount) throws SQLException {
        PreparedStatement stmt = TradeNetworthV1DMLDistTxStmt.getStmt(dConn, delete[whichDelete]);
        int tid = TradeNetworthV1DMLDistTxStmt.getMyTid();
        Log.getLogWriter().info("Delete in derby, myTid is " + tid);
        int count = this.deleteFromTable(stmt, cid, cash, availloan, whichDelete);
        if (count != updateCount) {
            String str = "derby delete has different row count from that of gfxd gfxd deleted " + updateCount + " rows, but derby deleted " + count + " rows in " + TradeNetworthV1DMLDistTxStmt.getTableName();
            if (failAtUpdateCount) {
                throw new TestException(str);
            }
            Log.getLogWriter().info(str);
        }
    }

    @Override
    public void queryDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[data.length - 1];
        List gfxdList = (List)data[data.length - 2];
        ResultSet derbyRS = null;
        try {
            derbyRS = TradeNetworthV1DMLDistTxStmt.query(dConn, (Integer)data[2], (BigDecimal)data[3], (BigDecimal)data[4], (Integer)data[5], (BigDecimal)data[6], (Integer)data[7], (Long)data[8], (String)data[9]);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
        }
        ResultSetHelper.compareResultSets(ResultSetHelper.asList(derbyRS, true), gfxdList);
    }

    @Override
    public boolean queryGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.queryGfxdOnly(gConn);
        }
        int whichQuery = rand.nextInt(select.length);
        int cash = 100000;
        int sec = 100000;
        int tid = TradeNetworthV1DMLDistTxStmt.getMyTid();
        int loanLimit = loanLimits[rand.nextInt(loanLimits.length)];
        BigDecimal loanAmount = new BigDecimal(Integer.toString(rand.nextInt(loanLimit)));
        BigDecimal queryCash = new BigDecimal(Integer.toString(rand.nextInt(cash)));
        BigDecimal querySec = new BigDecimal(Integer.toString(rand.nextInt(sec)));
        Connection nonTxConn = rand.nextBoolean() ? (Connection)SQLDistTxTest.gfxdNoneTxConn.get() : (Connection)SQLTest.derbyConnection.get();
        long cid = TradeNetworthV1DMLDistTxStmt.getNewTypeCidFromQuery(nonTxConn, TradeNetworthV1DMLDistTxStmt.getTableName(), rand.nextBoolean() ? TradeNetworthV1DMLDistTxStmt.getMyTid() : rand.nextInt(SQLDistTxTest.numOfWorkers));
        ResultSet gfxdRS = null;
        SQLException gfxdse = null;
        if (!reproduce50710) {
            return true;
        }
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        String additionalWhereClause = TradeNetworthV1DMLDistTxStmt.getUpdatedPksByTx(modifiedKeysByTx);
        try {
            gfxdRS = TradeNetworthV1DMLDistTxStmt.query(gConn, whichQuery, queryCash, querySec, loanLimit, loanAmount, tid, cid, additionalWhereClause);
            if (gfxdRS == null) {
                throw new TestException("Not able to get gfxd result set");
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (batchingWithSecondaryData) {
                    this.verifyConflictNewTablesWithBatching(null, null, null, null, null, se, true);
                    return false;
                }
                throw new TestException("Select query in Read Committed isolation gets conflict exception without batching");
            }
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx without HA support, continue testing");
                return false;
            }
            SQLHelper.handleSQLException(se);
            gfxdse = se;
        }
        List<Struct> gfxdList = ResultSetHelper.asList(gfxdRS, false);
        if (gfxdList == null && isHATest) {
            Log.getLogWriter().info("Testing HA and did not get GFXD result set due to node failure");
            return true;
        }
        this.addQueryToDerbyTx(whichQuery, queryCash, querySec, loanLimit, loanAmount, tid, cid, additionalWhereClause, gfxdList, gfxdse);
        return true;
    }

    protected static String getUpdatedPksByTx(HashMap<String, Integer> modifiedKeysByTx) {
        StringBuffer str = new StringBuffer();
        StringBuffer keyStr = new StringBuffer();
        for (String key : modifiedKeysByTx.keySet()) {
            if (!key.startsWith(TradeNetworthV1DMLDistTxStmt.getTableName())) continue;
            String aKey = key.substring(TradeNetworthV1DMLDistTxStmt.getTableName().length() + 1, key.length());
            keyStr.append(" " + aKey + ",");
        }
        if (keyStr.length() > 0) {
            str.append(" and cid not in(");
            str.append(keyStr);
            str.replace(str.lastIndexOf(","), str.length(), ")");
        }
        return str.toString();
    }

    protected static ResultSet query(Connection conn, int whichQuery, BigDecimal cash, BigDecimal sec, int loanLimit, BigDecimal loanAmount, int tid, long cid, String additionalWhereClause) throws SQLException {
        ResultSet rs = TradeNetworthV1DMLDistTxStmt.getQuery(conn, whichQuery, cash, sec, loanLimit, loanAmount, tid, cid, additionalWhereClause);
        return rs;
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, BigDecimal cash, BigDecimal sec, int loanLimit, BigDecimal loanAmount, int tid, long cid, String additionalWhereClause) throws SQLException {
        ResultSet rs = null;
        String transactionId = (Integer)SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - " + transactionId + " ";
        String selectsql = select[whichQuery];
        if (queryOpTimeNewTables) {
            if (selectsql.startsWith("select a.cid")) {
                String whereClause = additionalWhereClause.replace("cid", "a.cid");
                selectsql = selectsql + whereClause;
                String fetchClause = " order by a.cid desc OFFSET 12 ROWS FETCH NEXT 5 ROWS ONLY";
                selectsql = selectsql + fetchClause;
            } else {
                selectsql = selectsql + additionalWhereClause;
            }
        }
        String query = " QUERY: " + selectsql;
        Log.getLogWriter().info(query);
        try {
            PreparedStatement stmt = conn.prepareStatement(selectsql);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.networthv1 with CID:" + cid + ",CID:" + (cid - 10L) + query);
                    stmt.setLong(1, cid);
                    stmt.setLong(2, cid - 10L);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.networthv1 with SECURITIES:" + sec + ",CASH:" + cash + ",CID:" + cid + query);
                    stmt.setBigDecimal(1, sec);
                    stmt.setBigDecimal(2, cash);
                    stmt.setLong(3, cid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.networthv1 with LOANLIMIT:" + loanLimit + ",LOANAMOUNT:" + loanAmount + query);
                    stmt.setInt(1, loanLimit);
                    stmt.setBigDecimal(2, loanAmount);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying trade.networthv1 with CASH:" + cash + ",SECURITIES:" + sec + ",TID:" + tid + query);
                    stmt.setBigDecimal(1, cash);
                    stmt.setBigDecimal(2, sec);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.networthv1 with C_CID:" + cid + query);
                    stmt.setLong(1, cid);
                    break;
                }
                case 5: {
                    Log.getLogWriter().info(database + "querying trade.networthv1 C_CID:" + cid + query);
                    stmt.setLong(1, cid);
                    break;
                }
                case 6: {
                    Log.getLogWriter().info(database + "querying trade.networthv1 no predicate" + query);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return null;
            }
            throw se;
        }
        return rs;
    }

    protected void addQueryToDerbyTx(int whichQuery, BigDecimal queryCash, BigDecimal querySec, int loanLimit, BigDecimal loanAmount, int tid, long cid, String additionalWhereClause, List<Struct> gfxdList, SQLException gfxdse) {
        Object[] data = new Object[]{4, "query", whichQuery, queryCash, querySec, loanLimit, loanAmount, tid, cid, additionalWhereClause, gfxdList, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    protected boolean queryGfxdOnly(Connection gConn) {
        return true;
    }
}

