/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlDistTxStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlDistTxStatements.DMLDistTxStmtIF;
import sql.dmlDistTxStatements.TradeCustomersDMLDistTxStmt;
import sql.dmlDistTxStatements.TradeSecuritiesDMLDistTxStmt;
import sql.dmlStatements.TradePortfolioDMLStmt;
import sql.sqlTx.RangeForeignKey;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlTx.SQLTxBatchingFKBB;
import sql.sqlTx.SQLTxPartitionInfoBB;
import sql.sqlTx.SQLTxSecondBB;
import sql.sqlutil.GFXDStructImpl;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class TradePortfolioDMLDistTxStmt
extends TradePortfolioDMLStmt
implements DMLDistTxStmtIF {
    public static String cidPrefix = "_cid_";
    public static String sidPrefix = "_sid_";
    static final boolean isConcUpdateTx = TestConfig.tab().booleanAt(SQLPrms.isConcUpdateTx, false);
    public static boolean isReplicate;
    protected boolean hasSecondary = isReplicate || batchingWithSecondaryData && (Boolean)SQLBB.getBB().getSharedMap().get((Object)SQLTest.hasRedundancy) != false;

    @Override
    public void deleteDerby(Connection dConn, int index) {
    }

    @Override
    public boolean deleteGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.deleteGfxdOnly(gConn);
        }
        return true;
    }

    protected void addInsertToDerbyTx(int[] cid, int[] sid, int[] qty, BigDecimal[] sub, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{3, "insert", cid, sid, qty, sub, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void insertDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[7];
        try {
            this.insertToDerbyTable(dConn, (int[])data[2], (int[])data[3], (int[])data[4], (BigDecimal[])data[5], (int[])data[6], 1);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    @Override
    public boolean insertGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.insertGfxdOnly(gConn);
        }
        int size = 1;
        int[] cid = new int[size];
        int[] sid = new int[size];
        int[] qty = new int[size];
        BigDecimal[] sub = new BigDecimal[size];
        BigDecimal[] price = new BigDecimal[size];
        int[] updateCount = new int[size];
        boolean[] expectConflict = new boolean[1];
        Connection nonTxConn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        SQLException gfxdse = null;
        this.getExistingCidFromCustomers(nonTxConn, cid);
        this.getDataFromResultSet(nonTxConn, sid, qty, sub, price, size);
        int chance = 200;
        if (rand.nextInt(chance) == 0) {
            cid[0] = 0;
        } else if (rand.nextInt(chance) == 0) {
            sid[0] = 0;
        }
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashSet<String> parentKeysHold = new HashSet<String>();
        try {
            this.getKeysForInsert(nonTxConn, modifiedKeysByOp, cid[0], sid[0], expectConflict, parentKeysHold);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().warning("Not able to process the keys for this op due to HA, this insert op does not proceed");
                return true;
            }
            SQLHelper.handleSQLException(se);
        }
        if (batchingWithSecondaryData) {
            HashSet holdFKsByThisTx = (HashSet)SQLDistTxTest.foreignKeyHeldWithBatching.get();
            holdFKsByThisTx.addAll(parentKeysHold);
            SQLDistTxTest.foreignKeyHeldWithBatching.set((Object)holdFKsByThisTx);
            SharedMap holdingFKTxIds = SQLTxBatchingFKBB.getBB().getSharedMap();
            Integer myTxId = (Integer)SQLDistTxTest.curTxId.get();
            for (String key : parentKeysHold) {
                HashSet<Integer> txIds = (HashSet<Integer>)holdingFKTxIds.get((Object)key);
                if (txIds == null) {
                    txIds = new HashSet<Integer>();
                }
                txIds.add(myTxId);
                holdingFKTxIds.put((Object)key, txIds);
            }
        }
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            this.insertToGfxdTable(gConn, cid, sid, qty, sub, updateCount, size);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!expectConflict[0]) {
                    if (!batchingWithSecondaryData) {
                        this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, se, true);
                    } else {
                        this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, se, this.hasSecondary, true);
                    }
                }
                if (batchingWithSecondaryData) {
                    this.cleanUpFKHolds();
                }
                this.removePartialRangeForeignKeys(cid, sid);
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                if (batchingWithSecondaryData) {
                    this.cleanUpFKHolds();
                }
                this.removePartialRangeForeignKeys(cid, sid);
                return false;
            }
            if (expectConflict[0] && !se.getSQLState().equals("23505") && !se.getSQLState().equals("23503") && !batchingWithSecondaryData) {
                throw new TestException("expect conflict exceptions, but did not get it" + TestHelper.getStackTrace((Throwable)se));
            }
            gfxdse = se;
            if (batchingWithSecondaryData) {
                this.cleanUpFKHolds();
            }
            this.removePartialRangeForeignKeys(cid, sid);
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, gfxdse, false);
        } else {
            this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, gfxdse, this.hasSecondary, false);
        }
        if (expectConflict[0] && gfxdse == null && !batchingWithSecondaryData) {
            throw new TestException("Did not get conflict exception for foreign key check. Please check for logs");
        }
        if (withDerby) {
            this.addInsertToDerbyTx(cid, sid, qty, sub, updateCount, gfxdse);
        }
        modifiedKeysByTx.putAll(modifiedKeysByOp);
        SQLDistTxTest.curTxModifiedKeys.set((Object)modifiedKeysByTx);
        return true;
    }

    @Override
    protected int getDataFromResultSet(Connection regConn, int[] sid, int[] qty, BigDecimal[] sub, BigDecimal[] price, int size) {
        if (testUniqueKeys) {
            return super.getDataFromResultSet(regConn, sid, qty, sub, price, size);
        }
        Connection conn = TradePortfolioDMLDistTxStmt.getAuthConn(regConn);
        ArrayList list = null;
        int[] offset = new int[1];
        String sql = "select sec_id, price from trade.securities";
        try {
            ResultSet rs = conn.createStatement().executeQuery(sql);
            list = (ArrayList)ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
        }
        catch (SQLException se) {
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                Log.getLogWriter().info("got node failure exception during Tx without HA support, continue testing");
            }
            SQLHelper.handleSQLException(se);
        }
        if (list == null || list.size() == 0) {
            return 0;
        }
        int availSize = this.getAvailSize(list, size, offset);
        for (int i = 0; i < availSize; ++i) {
            sid[i] = (Integer)((GFXDStructImpl)list.get(i + offset[0])).get("SEC_ID");
            price[i] = (BigDecimal)((GFXDStructImpl)list.get(i + offset[0])).get("PRICE");
            qty[i] = rand.nextInt(1901) + 100;
            sub[i] = price[i].multiply(new BigDecimal(String.valueOf(qty[i])));
        }
        if (rand.nextInt(100) == 1 && useTimeout) {
            sid[0] = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary);
            Log.getLogWriter().info("possibly test insert/insert parent/child cases");
        }
        return availSize;
    }

    private void getKeysForInsert(Connection conn, HashMap<String, Integer> keys, int cid, int sid, boolean[] expectConflict, HashSet<String> parentKeys) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        sql = "select sec_id from trade.securities where sec_id =" + sid;
        Log.getLogWriter().info(database + sql);
        rs = conn.createStatement().executeQuery(sql);
        if (!rs.next()) {
            Log.getLogWriter().info(database + "foreign key SECID:" + sid + " does not exist " + "in the securities table, should get foreign key constraint exception");
        }
        rs.close();
        sql = "select cid from trade.customers where cid =" + cid;
        Log.getLogWriter().info(database + sql);
        rs = conn.createStatement().executeQuery(sql);
        if (!rs.next()) {
            Log.getLogWriter().info(database + "foreign key CID:" + cid + " does not exist " + "in the customer table, should get foreign key constraint exception");
        }
        rs.close();
        boolean hasForeignKeyConflict = false;
        if (!ticket42672fixed) {
            hasForeignKeyConflict = this.isCustomersPartitionedOnPKOrReplicate() && this.hasForeignKeyConflict(TradeCustomersDMLDistTxStmt.getTableName() + "_" + cid, txId) || this.isSecuritiesPartitionedOnPKOrReplicate() && this.hasForeignKeyConflict(TradeSecuritiesDMLDistTxStmt.getTableName() + "_" + sid, txId);
        }
        parentKeys.add(TradeCustomersDMLDistTxStmt.getTableName() + "_" + cid);
        parentKeys.add(TradeSecuritiesDMLDistTxStmt.getTableName() + "_" + sid);
        Log.getLogWriter().info("parent keys added: " + TradeCustomersDMLDistTxStmt.getTableName() + "_" + cid);
        Log.getLogWriter().info("parent keys added: " + TradeSecuritiesDMLDistTxStmt.getTableName() + "_" + sid);
        SharedMap rangeForeignKeys = SQLTxSecondBB.getBB().getSharedMap();
        String keyCid = TradePortfolioDMLDistTxStmt.getTableName() + cidPrefix + cid;
        String keySid = TradePortfolioDMLDistTxStmt.getTableName() + sidPrefix + sid;
        RangeForeignKey cidRangeKey = (RangeForeignKey)rangeForeignKeys.get((Object)keyCid);
        RangeForeignKey sidRangeKey = (RangeForeignKey)rangeForeignKeys.get((Object)keySid);
        if (cidRangeKey == null) {
            cidRangeKey = new RangeForeignKey(keyCid);
        }
        if (sidRangeKey == null) {
            sidRangeKey = new RangeForeignKey(keySid);
        }
        boolean hasRangeForeignKeyConflict = cidRangeKey.hasConflictAddPartialRangeKey(txId) || sidRangeKey.hasConflictAddPartialRangeKey(txId);
        rangeForeignKeys.put((Object)(TradePortfolioDMLDistTxStmt.getTableName() + cidPrefix + cid), (Object)cidRangeKey);
        rangeForeignKeys.put((Object)(TradePortfolioDMLDistTxStmt.getTableName() + sidPrefix + sid), (Object)sidRangeKey);
        ArrayList curTxRangeFK = (ArrayList)SQLDistTxTest.curTxFKHeld.get();
        curTxRangeFK.add(keyCid);
        curTxRangeFK.add(keySid);
        SQLDistTxTest.curTxFKHeld.set((Object)curTxRangeFK);
        boolean bl = expectConflict[0] = hasForeignKeyConflict || hasRangeForeignKeyConflict;
        if (hasForeignKeyConflict) {
            Log.getLogWriter().info("should expect lock not held/conflict exception here");
        }
        keys.put(TradePortfolioDMLDistTxStmt.getTableName() + "_cid_" + cid + "_sid_" + sid, txId);
    }

    protected void insertToGfxdTable(Connection conn, int[] cid, int[] sid, int[] qty, BigDecimal[] sub, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        stmt = SQLTest.isEdge && !isTicket48176Fixed && isHATest ? TradePortfolioDMLDistTxStmt.getStmtThrowException(conn, insert) : conn.prepareStatement(insert);
        int tid = TradePortfolioDMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            updateCount[i] = this.insertToTable(stmt, cid[i], sid[i], qty[i], sub[i], tid);
        }
    }

    protected void removePartialRangeForeignKeys(int[] cid, int[] sid) {
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        SharedMap rangeForeignKeys = SQLTxSecondBB.getBB().getSharedMap();
        RangeForeignKey cidRangeKey = (RangeForeignKey)rangeForeignKeys.get((Object)(TradePortfolioDMLDistTxStmt.getTableName() + cidPrefix + cid[0]));
        RangeForeignKey sidRangeKey = (RangeForeignKey)rangeForeignKeys.get((Object)(TradePortfolioDMLDistTxStmt.getTableName() + sidPrefix + sid[0]));
        if (cidRangeKey != null) {
            cidRangeKey.removePartialRangeKey(txId);
        }
        if (sidRangeKey != null) {
            sidRangeKey.removePartialRangeKey(txId);
        }
        Log.getLogWriter().info("removing the partial range foreign key for this txId");
    }

    protected boolean insertToDerbyTable(Connection conn, int[] cid, int[] sid, int[] qty, BigDecimal[] sub, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = TradePortfolioDMLDistTxStmt.getStmt(conn, insert);
        int tid = TradePortfolioDMLDistTxStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            count = this.insertToTable(stmt, cid[i], sid[i], qty[i], sub[i], tid);
            if (count == updateCount[i]) continue;
            Log.getLogWriter().info("derby insert has different row count from that of gfxd gfxd inserted " + updateCount[i] + " row, but derby inserted " + count + " row in " + TradePortfolioDMLDistTxStmt.getTableName());
        }
        return true;
    }

    protected void addQueryToDerbyTx(int whichQuery, BigDecimal subTotal1, BigDecimal subTotal2, int queryQty, int queryAvail, int sid, int cid, int tid, List<Struct> gfxdList, SQLException gfxdse) {
        Object[] data = new Object[]{3, "query", whichQuery, subTotal1, subTotal2, queryQty, queryAvail, sid, cid, tid, gfxdList, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void queryDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[11];
        List gfxdList = (List)data[10];
        ResultSet derbyRS = null;
        try {
            derbyRS = TradePortfolioDMLDistTxStmt.query(dConn, (Integer)data[2], (BigDecimal)data[3], (BigDecimal)data[4], (Integer)data[5], (Integer)data[6], (Integer)data[7], (Integer)data[8], (Integer)data[9]);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
        }
        ResultSetHelper.compareResultSets(ResultSetHelper.asList(derbyRS, true), gfxdList);
    }

    @Override
    public boolean queryGfxd(Connection gConn, boolean withDerby) {
        List<Struct> gfxdList;
        if (!withDerby) {
            return this.queryGfxdOnly(gConn);
        }
        int numOfNonUniq = 6;
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        if (whichQuery < 6) {
            whichQuery += 6;
        }
        if (whichQuery == 6) {
            ++whichQuery;
        }
        int qty = 1000;
        int avail = 500;
        int startPoint = 10000;
        int range = 100000;
        BigDecimal subTotal1 = new BigDecimal(Integer.toString(rand.nextInt(startPoint)));
        BigDecimal subTotal2 = subTotal1.add(new BigDecimal(Integer.toString(rand.nextInt(range))));
        int queryQty = rand.nextInt(qty);
        int queryAvail = rand.nextInt(avail);
        int sid = 0;
        int cid = 0;
        Connection nonTxConn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        int[] key = TradePortfolioDMLDistTxStmt.getKey(nonTxConn);
        if (key != null) {
            sid = key[0];
            cid = key[1];
        }
        int tid = TradePortfolioDMLDistTxStmt.getMyTid();
        ResultSet gfxdRS = null;
        SQLException gfxdse = null;
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            gfxdRS = TradePortfolioDMLDistTxStmt.query(gConn, whichQuery, subTotal1, subTotal2, queryQty, queryAvail, sid, cid, tid);
            if (gfxdRS == null) {
                throw new TestException("Not able to get gfxd result set");
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02") && batchingWithSecondaryData) {
                this.verifyConflictWithBatching(new HashMap<String, Integer>(), modifiedKeysByTx, se, this.hasSecondary, true);
                return false;
            }
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx without HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if ((gfxdList = ResultSetHelper.asList(gfxdRS, false)) == null && isHATest) {
            Log.getLogWriter().info("Testing HA and did not get GFXD result set due to node failure");
            return false;
        }
        this.addQueryToDerbyTx(whichQuery, subTotal1, subTotal2, queryQty, queryAvail, sid, cid, tid, gfxdList, gfxdse);
        return true;
    }

    @Override
    public void updateDerby(Connection dConn, int index) {
    }

    @Override
    public boolean updateGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.updateGfxdOnly(gConn);
        }
        return true;
    }

    public static String getTableName() {
        return "portfolio";
    }

    protected boolean insertGfxdOnly(Connection gConn) {
        try {
            this.insert(null, gConn, 1);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected boolean updateGfxdOnly(Connection gConn) {
        try {
            this.update(null, gConn, 1);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected boolean deleteGfxdOnly(Connection gConn) {
        try {
            this.delete(null, gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected boolean queryGfxdOnly(Connection gConn) {
        try {
            this.query(null, gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02") && batchingWithSecondaryData) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        try {
            super.insert(dConn, gConn, size);
        }
        catch (TestException te) {
            if (dConn == null & te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("concurrent insert could cause expected conflict exception");
            }
            throw te;
        }
    }

    @Override
    public void populate(Connection dConn, Connection gConn) {
        try {
            super.populate(dConn, gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02") && dConn == null) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
            }
            throw te;
        }
    }

    @Override
    protected int getWhichUpdate(int numOfNonUniq, int total) {
        int whichOne = super.getWhichOne(numOfNonUniq, total);
        if (isConcUpdateTx && (whichOne == 1 || whichOne == 6)) {
            ++whichOne;
        }
        return whichOne;
    }

    static {
        try {
            String partition = (String)SQLTxPartitionInfoBB.getBB().getSharedMap().get((Object)("trade." + TradePortfolioDMLDistTxStmt.getTableName()));
            isReplicate = partition.equalsIgnoreCase("replicate");
        }
        catch (NullPointerException npe) {
            isReplicate = false;
        }
        Log.getLogWriter().info("isReplicate is " + isReplicate);
    }
}

