/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlDistTxStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.blackboard.SharedMap;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import sql.dmlDistTxStatements.DMLDistTxStmtIF;
import sql.dmlDistTxStatements.TradePortfolioDMLDistTxStmt;
import sql.dmlStatements.TradeSecuritiesDMLStmt;
import sql.sqlTx.RangeForeignKey;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlTx.SQLTxPartitionInfoBB;
import sql.sqlTx.SQLTxSecondBB;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class TradeSecuritiesDMLDistTxStmt
extends TradeSecuritiesDMLStmt
implements DMLDistTxStmtIF {
    protected static String[] update = new String[]{"update trade.securities set price = ? where sec_id = ? ", "update trade.securities set tid =? where sec_id = ? ", "update trade.securities set symbol = ?, exchange =? where sec_id = ?", "update trade.securities set price = ? where symbol Between ? AND ? and sec_id < ?"};
    protected static String[] delete = new String[]{"delete from trade.securities where sec_id=?", "delete from trade.securities where (symbol like ? and exchange = ? ) and tid=?"};
    public static boolean isReplicate;
    protected boolean hasSecondary = isReplicate || batchingWithSecondaryData && (Boolean)SQLBB.getBB().getSharedMap().get((Object)SQLTest.hasRedundancy) != false;

    protected void addDeleteToDerbyTx(int sec_id, String symbol, String exchange, int tid, int whichDelete, int updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{2, "delete", sec_id, symbol, exchange, tid, whichDelete, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void deleteDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[8];
        try {
            this.deleteFromDerbyTable(dConn, (int)((Integer)data[2]), (String)data[3], (String)data[4], (Integer)data[5], (int)((Integer)data[6]), (Integer)data[7]);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
        }
    }

    @Override
    public boolean deleteGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.deleteGfxdOnly(gConn);
        }
        int whichDelete = rand.nextInt(delete.length);
        whichDelete = this.getWhichDelete(whichDelete);
        int minLen = 2;
        int maxLen = 3;
        String symbol = this.getSymbol(minLen, maxLen) + '%';
        String exchange = this.getExchange();
        int[] sec_id = new int[1];
        int[] updateCount = new int[1];
        boolean[] expectConflict = new boolean[1];
        int tid = TradeSecuritiesDMLDistTxStmt.getMyTid();
        Connection nonTxConn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        SQLException gfxdse = null;
        this.getExistingSidFromSecurities(nonTxConn, sec_id);
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        try {
            this.getKeysForDelete(nonTxConn, modifiedKeysByOp, whichDelete, sec_id[0], symbol, exchange, tid, expectConflict);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().warning("Not able to process the keys for this op due to HA, this insert op does not proceed");
                return true;
            }
            SQLHelper.handleSQLException(se);
        }
        if (batchingWithSecondaryData) {
            HashSet holdParentKeyByThisTx = (HashSet)SQLDistTxTest.parentKeyHeldWithBatching.get();
            holdParentKeyByThisTx.addAll(modifiedKeysByOp.keySet());
            SQLDistTxTest.parentKeyHeldWithBatching.set((Object)holdParentKeyByThisTx);
            int txId = (Integer)SQLDistTxTest.curTxId.get();
            SQLBB.getBB().getSharedMap().put((Object)(parentKeyHeldTxid + txId), (Object)holdParentKeyByThisTx);
        }
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            this.deleteFromGfxdTable(gConn, sec_id[0], symbol, exchange, tid, whichDelete, updateCount);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (expectConflict[0]) {
                    Log.getLogWriter().info("got expected conflict exception due to foreign key constraint, continuing testing");
                } else if (!batchingWithSecondaryData) {
                    this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, se, true);
                } else {
                    this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, se, this.hasSecondary, true);
                }
                for (String key : modifiedKeysByOp.keySet()) {
                    Log.getLogWriter().info("key is " + key);
                    if (key.contains("unique")) continue;
                    int sid = Integer.parseInt(key.substring(key.indexOf("_") + 1));
                    this.removeWholeRangeForeignKeys(sid);
                    if (!batchingWithSecondaryData) continue;
                    this.cleanUpFKHolds();
                }
                return false;
            }
            if (SQLHelper.gotTXNodeFailureException(se)) {
                if (gfxdtxHANotReady && isHATest) {
                    SQLHelper.printSQLException(se);
                    Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                    for (String key : modifiedKeysByOp.keySet()) {
                        Log.getLogWriter().info("key is " + key);
                        if (key.contains("unique")) continue;
                        int sid = Integer.parseInt(key.substring(key.indexOf("_") + 1));
                        this.removeWholeRangeForeignKeys(sid);
                        if (!batchingWithSecondaryData) continue;
                        this.cleanUpFKHolds();
                    }
                    return false;
                }
                throw new TestException("got node failure exception in a non HA test" + TestHelper.getStackTrace((Throwable)se));
            }
            if (expectConflict[0] && !se.getSQLState().equals("23503") && !batchingWithSecondaryData) {
                throw new TestException("expect conflict exceptions, but did not get it" + TestHelper.getStackTrace((Throwable)se));
            }
            gfxdse = se;
            for (String key : modifiedKeysByOp.keySet()) {
                if (key == null || key.contains("_unique_")) continue;
                String s = key.substring(key.indexOf("_") + 1);
                int sid = Integer.parseInt(s);
                this.removeWholeRangeForeignKeys(sid);
                if (!batchingWithSecondaryData) continue;
                this.cleanUpFKHolds();
            }
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, gfxdse, false);
        } else {
            this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, gfxdse, this.hasSecondary, false);
        }
        if (expectConflict[0] && gfxdse == null && !batchingWithSecondaryData) {
            throw new TestException("Did not get conflict exception for foreign key check. Please check for logs");
        }
        this.addDeleteToDerbyTx(sec_id[0], symbol, exchange, tid, whichDelete, updateCount[0], gfxdse);
        modifiedKeysByTx.putAll(modifiedKeysByOp);
        SQLDistTxTest.curTxModifiedKeys.set((Object)modifiedKeysByTx);
        return true;
    }

    protected void addInsertToDerbyTx(int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{2, "insert", sec_id, symbol, exchange, price, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void insertDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[7];
        try {
            this.insertToDerbyTable(dConn, (int[])data[2], (String[])data[3], (String[])data[4], (BigDecimal[])data[5], (int[])data[6], 1);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    @Override
    public boolean insertGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.insertGfxdOnly(gConn);
        }
        int size = 1;
        int[] sec_id = new int[size];
        String[] symbol = new String[size];
        String[] exchange = new String[size];
        BigDecimal[] price = new BigDecimal[size];
        int[] updateCount = new int[size];
        SQLException gfxdse = null;
        this.getDataForInsert(sec_id, symbol, exchange, price, size);
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        modifiedKeysByOp.put(TradeSecuritiesDMLDistTxStmt.getTableName() + "_" + sec_id[0], (Integer)SQLDistTxTest.curTxId.get());
        modifiedKeysByOp.put(TradeSecuritiesDMLDistTxStmt.getTableName() + "_unique_" + symbol[0] + "_" + exchange[0], (Integer)SQLDistTxTest.curTxId.get());
        Log.getLogWriter().info("gemfirexd - TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " need to hold the unique key " + TradeSecuritiesDMLDistTxStmt.getTableName() + "_unique_" + symbol[0] + "_" + exchange[0]);
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            this.insertToGfxdTable(gConn, sec_id, symbol, exchange, price, updateCount, size);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, se, true);
                } else {
                    this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, se, this.hasSecondary, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("gemfirexd - TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, gfxdse, false);
        } else {
            this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, gfxdse, this.hasSecondary, false);
        }
        this.addInsertToDerbyTx(sec_id, symbol, exchange, price, updateCount, gfxdse);
        modifiedKeysByTx.putAll(modifiedKeysByOp);
        SQLDistTxTest.curTxModifiedKeys.set((Object)modifiedKeysByTx);
        return true;
    }

    public static String getTableName() {
        return "securities";
    }

    protected void insertToGfxdTable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        stmt = SQLTest.isEdge && !isTicket48176Fixed && isHATest ? TradeSecuritiesDMLDistTxStmt.getStmtThrowException(conn, insert) : conn.prepareStatement(insert);
        int tid = TradeSecuritiesDMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            updateCount[i] = this.insertToTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid);
        }
    }

    protected void insertToDerbyTable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = TradeSecuritiesDMLDistTxStmt.getStmt(conn, insert);
        int tid = TradeSecuritiesDMLDistTxStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            count = this.insertToTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid);
            if (count == updateCount[i]) continue;
            Log.getLogWriter().info("derby insert has different row count from that of gfxd gfxd inserted " + updateCount[i] + " row, but derby inserted " + count + " row in " + TradeSecuritiesDMLDistTxStmt.getTableName());
        }
    }

    protected void addQueryToDerbyTx(int whichQuery, int sec_id, String symbol, BigDecimal price, String exchange, int tid, List<Struct> gfxdList, SQLException gfxdse) {
        Object[] data = new Object[]{2, "query", whichQuery, sec_id, symbol, price, exchange, tid, gfxdList, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void queryDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[9];
        List gfxdList = (List)data[8];
        ResultSet derbyRS = null;
        try {
            derbyRS = TradeSecuritiesDMLDistTxStmt.query(dConn, (Integer)data[2], (Integer)data[3], (String)data[4], (BigDecimal)data[5], (String)data[6], (Integer)data[7]);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
        }
        ResultSetHelper.compareResultSets(ResultSetHelper.asList(derbyRS, true), gfxdList);
    }

    @Override
    public boolean queryGfxd(Connection gConn, boolean withDerby) {
        List<Struct> gfxdList;
        if (!withDerby) {
            return this.queryGfxdOnly(gConn);
        }
        int numOfNonUniq = 4;
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        if (whichQuery < 4) {
            whichQuery += 4;
        }
        int sec_id = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary));
        String symbol = this.getSymbol();
        BigDecimal price = this.getPrice();
        String exchange = this.getExchange();
        int tid = TradeSecuritiesDMLDistTxStmt.getMyTid();
        ResultSet gfxdRS = null;
        SQLException gfxdse = null;
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            gfxdRS = TradeSecuritiesDMLDistTxStmt.query(gConn, whichQuery, sec_id, symbol, price, exchange, tid);
            if (gfxdRS == null) {
                throw new TestException("Not able to get gfxd result set");
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02") && batchingWithSecondaryData) {
                this.verifyConflictWithBatching(new HashMap<String, Integer>(), modifiedKeysByTx, se, this.hasSecondary, true);
                return false;
            }
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx without HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if ((gfxdList = ResultSetHelper.asList(gfxdRS, false)) == null && isHATest) {
            Log.getLogWriter().info("Testing HA and did not get GFXD result set due to node failure");
            return false;
        }
        this.addQueryToDerbyTx(whichQuery, sec_id, symbol, price, exchange, tid, gfxdList, gfxdse);
        return true;
    }

    protected void addUpdateToDerbyTx(int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, String[] lowEnd, String[] highEnd, int whichUpdate, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{2, "update", sec_id, symbol, exchange, price, lowEnd, highEnd, whichUpdate, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void updateDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[10];
        try {
            this.updateDerbyTable(dConn, (int[])data[2], (String[])data[3], (String[])data[4], (BigDecimal[])data[5], (String[])data[6], (String[])data[7], (Integer)data[8], (int[])data[9], 1);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    private int getWhichUpdate(int index) {
        if (index == 2 && ((Boolean)SQLDistTxTest.commitEarly.get()).booleanValue()) {
            index = 3;
        } else if (index == 3 && !((Boolean)SQLDistTxTest.commitEarly.get()).booleanValue()) {
            index = 2;
        }
        boolean ticket42651fixed = true;
        if (index == 2 && !ticket42651fixed) {
            index = 1;
        }
        return index;
    }

    @Override
    public boolean updateGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.updateGfxdOnly(gConn);
        }
        int whichUpdate = this.getWhichUpdate(rand.nextInt(update.length));
        int size = 1;
        int[] sec_id = new int[size];
        String[] symbol = new String[size];
        String[] exchange = new String[size];
        BigDecimal[] price = new BigDecimal[size];
        String[] lowEnd = new String[size];
        String[] highEnd = new String[size];
        Connection nonTxConn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        boolean[] expectConflict = new boolean[1];
        this.getDataForUpdate(gConn, sec_id, symbol, exchange, price, size);
        for (int i = 0; i < size; ++i) {
            sec_id[i] = TradeSecuritiesDMLDistTxStmt.getExistingSid();
        }
        this.getSidForTx(nonTxConn, sec_id);
        this.getAdditionalUpdateData(lowEnd, highEnd);
        this.getExistingSidFromSecurities(nonTxConn, sec_id);
        if (isHATest && sec_id[0] == 0) {
            Log.getLogWriter().info("gemfirexd - TXID:" + (Integer)SQLDistTxTest.curTxId.get() + "could not get valid sec_id, abort this op");
            return true;
        }
        int[] updateCount = new int[size];
        SQLException gfxdse = null;
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            this.getKeysForUpdate(nonTxConn, modifiedKeysByOp, whichUpdate, sec_id[0], lowEnd[0], highEnd[0], expectConflict);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().warning("Not able to process the keys for this op due to HA, this insert op does not proceed");
                return true;
            }
            SQLHelper.handleSQLException(se);
        }
        if (whichUpdate == 2) {
            modifiedKeysByOp.put(TradeSecuritiesDMLDistTxStmt.getTableName() + "_unique_" + symbol[0] + "_" + exchange[0], txId);
            Log.getLogWriter().info("need to hold the unique key " + TradeSecuritiesDMLDistTxStmt.getTableName() + "_unique_" + symbol[0] + "_" + exchange[0]);
            try {
                String sql = "select symbol, exchange from trade.securities where sec_id = " + sec_id[0];
                ResultSet rs = nonTxConn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    String symbolKey = rs.getString("SYMBOL");
                    String exchangeKey = rs.getString("EXCHANGE");
                    Log.getLogWriter().info("gemfirexd - TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " should hold the unique key " + TradeSecuritiesDMLDistTxStmt.getTableName() + "_unique_" + symbolKey + "_" + exchangeKey);
                    modifiedKeysByOp.put(TradeSecuritiesDMLDistTxStmt.getTableName() + "_unique_" + symbolKey + "_" + exchangeKey, txId);
                }
                rs.close();
            }
            catch (SQLException se) {
                if (!SQLHelper.checkGFXDException(gConn, se)) {
                    Log.getLogWriter().info("gemfirexd - TXID:" + (Integer)SQLDistTxTest.curTxId.get() + "node failure in HA test, abort this operation");
                    return false;
                }
                SQLHelper.handleSQLException(se);
            }
        }
        if (batchingWithSecondaryData && !ticket42672fixed && this.isSecuritiesPartitionedOnPKOrReplicate()) {
            HashSet holdParentKeyByThisTx = (HashSet)SQLDistTxTest.parentKeyHeldWithBatching.get();
            holdParentKeyByThisTx.addAll(modifiedKeysByOp.keySet());
            SQLDistTxTest.parentKeyHeldWithBatching.set((Object)holdParentKeyByThisTx);
            SQLBB.getBB().getSharedMap().put((Object)(parentKeyHeldTxid + txId), (Object)holdParentKeyByThisTx);
        }
        try {
            this.updateGfxdTable(gConn, sec_id, symbol, exchange, price, lowEnd, highEnd, whichUpdate, updateCount, size);
            if (isHATest && ((Boolean)SQLDistTxTest.failedToGetStmtNodeFailure.get()).booleanValue()) {
                SQLDistTxTest.failedToGetStmtNodeFailure.set((Object)false);
                return false;
            }
            if (((Boolean)SQLDistTxTest.updateOnPartitionCol.get()).booleanValue()) {
                SQLDistTxTest.updateOnPartitionCol.set((Object)false);
                return true;
            }
            if (expectConflict[0] && !batchingWithSecondaryData) {
                throw new TestException("expected to get conflict exception due to foreign key constraint, but does not. Please check the logs for more information");
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (expectConflict[0]) {
                    Log.getLogWriter().info("got conflict exception due to #42672, continuing testing");
                } else if (!batchingWithSecondaryData) {
                    this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, se, true);
                } else {
                    this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, se, this.hasSecondary, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("gemfirexd - TXID:" + (Integer)SQLDistTxTest.curTxId.get() + "got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, gfxdse, false);
        } else {
            this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, gfxdse, this.hasSecondary, false);
        }
        this.addUpdateToDerbyTx(sec_id, symbol, exchange, price, lowEnd, highEnd, whichUpdate, updateCount, gfxdse);
        if (gfxdse == null) {
            modifiedKeysByTx.putAll(modifiedKeysByOp);
            SQLDistTxTest.curTxModifiedKeys.set((Object)modifiedKeysByTx);
        }
        return true;
    }

    private void getAdditionalUpdateData(String[] lowEnd, String[] highEnd) {
        String firstChar = this.getSymbol(1, 1);
        String secondChar = this.getSymbol(1, 1);
        char c = secondChar.charAt(0);
        if (c == 'z' || c == 'y') {
            lowEnd[0] = firstChar + (char)(c - 2);
            highEnd[0] = firstChar + secondChar;
        } else {
            lowEnd[0] = firstChar + secondChar;
            highEnd[0] = firstChar + (char)(c + 2);
        }
    }

    private void getKeysForUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int sec_id, String lowEnd, String highEnd, boolean[] expectConflict) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        ArrayList<Integer> ids = new ArrayList<Integer>();
        switch (whichUpdate) {
            case 0: 
            case 1: 
            case 2: {
                int availSid;
                sql = "select sec_id from trade.securities where sec_id =" + sec_id;
                Log.getLogWriter().info(database + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    availSid = rs.getInt(1);
                    Log.getLogWriter().info(database + "sec_id: " + availSid + " exists for update");
                    keys.put(TradeSecuritiesDMLDistTxStmt.getTableName() + "_" + sec_id, txId);
                    ids.add(availSid);
                }
                break;
            }
            case 3: {
                int availSid;
                sql = "select sec_id from trade.securities where symbol between '" + lowEnd + "' AND '" + highEnd + "' and sec_id< " + sec_id;
                Log.getLogWriter().info(database + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    availSid = rs.getInt(1);
                    Log.getLogWriter().info(database + "sec_id: " + availSid + " exists for update");
                    keys.put(TradeSecuritiesDMLDistTxStmt.getTableName() + "_" + availSid, txId);
                    ids.add(availSid);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
        if (!ticket42672fixed && this.isSecuritiesPartitionedOnPKOrReplicate()) {
            SharedMap rangeForeignKeys = SQLTxSecondBB.getBB().getSharedMap();
            for (Integer key : ids) {
                String portfolioKey = TradePortfolioDMLDistTxStmt.getTableName() + TradePortfolioDMLDistTxStmt.sidPrefix + key;
                RangeForeignKey portfolioRangeKey = (RangeForeignKey)rangeForeignKeys.get((Object)portfolioKey);
                if (portfolioRangeKey == null) {
                    portfolioRangeKey = new RangeForeignKey(portfolioKey);
                }
                rangeForeignKeys.put((Object)portfolioKey, (Object)portfolioRangeKey);
                String buyordersKey = "buyorders_sid_" + key;
                RangeForeignKey buyordersRangeKey = (RangeForeignKey)rangeForeignKeys.get((Object)buyordersKey);
                if (buyordersRangeKey == null) {
                    buyordersRangeKey = new RangeForeignKey(buyordersKey);
                }
                rangeForeignKeys.put((Object)buyordersKey, (Object)buyordersRangeKey);
                boolean hasRangeForeignKeyConflict = portfolioRangeKey.hasConflictAddWholeRangeKey(txId) || buyordersRangeKey.hasConflictAddWholeRangeKey(txId);
                rangeForeignKeys.put((Object)portfolioKey, (Object)portfolioRangeKey);
                rangeForeignKeys.put((Object)buyordersKey, (Object)buyordersRangeKey);
                keys.put(TradeSecuritiesDMLDistTxStmt.getTableName() + "_" + key, txId);
                ArrayList curTxRangeFK = (ArrayList)SQLDistTxTest.curTxFKHeld.get();
                curTxRangeFK.add(buyordersKey);
                curTxRangeFK.add(portfolioKey);
                SQLDistTxTest.curTxFKHeld.set((Object)curTxRangeFK);
                if (!hasRangeForeignKeyConflict) continue;
                expectConflict[0] = true;
                Log.getLogWriter().info("expect to gets the conflict due to foregin key constraint");
                break;
            }
        }
    }

    private void updateGfxdTable(Connection gConn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, String[] lowEnd, String[] highEnd, int whichUpdate, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        int tid = TradeSecuritiesDMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(gConn, whichUpdate) : TradeSecuritiesDMLDistTxStmt.getStmt(gConn, update[whichUpdate]);
            if (stmt == null) continue;
            updateCount[i] = this.updateTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid, lowEnd[i], highEnd[i], whichUpdate);
        }
    }

    private void updateDerbyTable(Connection dConn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, String[] lowEnd, String[] highEnd, int whichUpdate, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        int tid = TradeSecuritiesDMLDistTxStmt.getMyTid();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(dConn, whichUpdate) : TradeSecuritiesDMLDistTxStmt.getStmt(dConn, update[whichUpdate]);
            if (stmt == null || (count = this.updateTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid, lowEnd[i], highEnd[i], whichUpdate)) == updateCount[i]) continue;
            Log.getLogWriter().info("Derby update has different row count from that of gfxd, gfxd updated " + updateCount[i] + " rows, but derby updated " + count + " rows");
        }
    }

    protected int updateTable(PreparedStatement stmt, int sec_id, String symbol, String exchange, BigDecimal price, int tid, String lowEnd, String highEnd, int whichUpdate) throws SQLException {
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        String query = " QUERY: " + update[whichUpdate];
        String successString = "";
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(database + "updating trade.securities  with SECID:" + sec_id + " where PRICE:" + price.doubleValue() + query);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, sec_id);
                successString = "trade.securities table with SECID:" + sec_id + " where PRICE:" + price.doubleValue() + query;
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "updating trade.securities with SECID:" + sec_id + " where TID:" + tid + query);
                stmt.setInt(1, tid);
                stmt.setInt(2, sec_id);
                successString = "trade.securities with SECID:" + sec_id + " where TID:" + tid + query;
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "updating trade.securities where  SEC_ID:" + sec_id + ",SYMBOL:" + symbol + ",EXCHANGE:" + exchange + query);
                stmt.setString(1, symbol);
                stmt.setString(2, exchange);
                stmt.setInt(3, sec_id);
                successString = "trade.securities where  SEC_ID:" + sec_id + ",SYMBOL:" + symbol + ",EXCHANGE:" + exchange + query;
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "updating trade.securities with PRICE:" + price.doubleValue() + " where 1_SYMBOL:" + lowEnd + ",2_SYMBOL:" + highEnd + ",SEC_ID:" + sec_id + query);
                stmt.setBigDecimal(1, price);
                stmt.setString(2, lowEnd);
                stmt.setString(3, highEnd);
                stmt.setInt(4, sec_id);
                successString = "trade.securities with PRICE:" + price.doubleValue() + " where 1_SYMBOL:" + lowEnd + ",2_SYMBOL:" + highEnd + ",SEC_ID:" + sec_id + query;
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + "updated " + rowCount + " rows in" + successString);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected PreparedStatement getCorrectTxStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys) {
        PreparedStatement stmt = null;
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("price")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeSecuritiesDMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("tid")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeSecuritiesDMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("symbol") || partitionKeys.contains("exchange")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeSecuritiesDMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("price")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeSecuritiesDMLDistTxStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    private int getWhichDelete(int index) {
        if (index == 1 && !((Boolean)SQLDistTxTest.commitEarly.get()).booleanValue()) {
            index = 0;
        }
        return index;
    }

    private void getKeysForDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int sec_id, String symbol, String exchange, int tid, boolean[] expectConflict) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        ArrayList<Integer> ids = new ArrayList<Integer>();
        switch (whichDelete) {
            case 0: {
                sql = "select symbol, exchange from trade.securities where sec_id = " + sec_id;
                Log.getLogWriter().info(database + sql);
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    String symbolKey = rs.getString("SYMBOL");
                    String exchangeKey = rs.getString("exchange");
                    Log.getLogWriter().info(database + "should hold the unique key " + TradeSecuritiesDMLDistTxStmt.getTableName() + "_unique_" + symbolKey + "_" + exchangeKey);
                    keys.put(TradeSecuritiesDMLDistTxStmt.getTableName() + "_unique_" + symbolKey + "_" + exchangeKey, txId);
                    ids.add(sec_id);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select sec_id, symbol, exchange from trade.securities where (symbol like ? and exchange = ? ) and tid=?";
                Log.getLogWriter().info(database + sql);
                PreparedStatement stmt = conn.prepareStatement(sql);
                stmt.setString(1, symbol);
                stmt.setString(2, exchange);
                stmt.setInt(3, tid);
                rs = stmt.executeQuery();
                List<Struct> resultsList = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
                if (resultsList == null) break;
                for (Struct row : resultsList) {
                    Integer sid = (Integer)row.get("SEC_ID");
                    String symbolKey = (String)row.get("SYMBOL");
                    String exchangeKey = (String)row.get("EXCHANGE");
                    Log.getLogWriter().info(database + "sec_id: " + sid + " exists for delete");
                    keys.put(TradeSecuritiesDMLDistTxStmt.getTableName() + "_unique_" + symbolKey + "_" + exchangeKey, txId);
                    Log.getLogWriter().info(database + "should hold the unique key " + TradeSecuritiesDMLDistTxStmt.getTableName() + "_unique_" + symbolKey + "_" + exchangeKey);
                    ids.add(sid);
                }
                break;
            }
            default: {
                throw new TestException("wrong index here");
            }
        }
        SharedMap rangeForeignKeys = SQLTxSecondBB.getBB().getSharedMap();
        for (Integer key : ids) {
            String buyordersKey;
            RangeForeignKey buyordersRangeKey;
            String portfolioKey = TradePortfolioDMLDistTxStmt.getTableName() + TradePortfolioDMLDistTxStmt.sidPrefix + key;
            RangeForeignKey portfolioRangeKey = (RangeForeignKey)rangeForeignKeys.get((Object)portfolioKey);
            if (portfolioRangeKey == null) {
                portfolioRangeKey = new RangeForeignKey(portfolioKey);
            }
            if ((buyordersRangeKey = (RangeForeignKey)rangeForeignKeys.get((Object)(buyordersKey = "buyorders_sid_" + key))) == null) {
                buyordersRangeKey = new RangeForeignKey(buyordersKey);
            }
            boolean hasRangeForeignKeyConflict = portfolioRangeKey.hasConflictAddWholeRangeKey(txId) || buyordersRangeKey.hasConflictAddWholeRangeKey(txId);
            rangeForeignKeys.put((Object)portfolioKey, (Object)portfolioRangeKey);
            rangeForeignKeys.put((Object)buyordersKey, (Object)buyordersRangeKey);
            keys.put(TradeSecuritiesDMLDistTxStmt.getTableName() + "_" + key, txId);
            ArrayList curTxRangeFK = (ArrayList)SQLDistTxTest.curTxFKHeld.get();
            curTxRangeFK.add(buyordersKey);
            curTxRangeFK.add(portfolioKey);
            SQLDistTxTest.curTxFKHeld.set((Object)curTxRangeFK);
            if (!hasRangeForeignKeyConflict) continue;
            expectConflict[0] = true;
            break;
        }
    }

    protected void removeWholeRangeForeignKeys(int sid) {
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        SharedMap rangeForeignKeys = SQLTxSecondBB.getBB().getSharedMap();
        String portfolioFK = TradePortfolioDMLDistTxStmt.getTableName() + TradePortfolioDMLDistTxStmt.sidPrefix + sid;
        RangeForeignKey portfolioKey = (RangeForeignKey)rangeForeignKeys.get((Object)portfolioFK);
        String buyordersFK = "buyorders_sid_" + sid;
        RangeForeignKey buyordersKey = (RangeForeignKey)rangeForeignKeys.get((Object)buyordersFK);
        ArrayList fkHeld = (ArrayList)SQLDistTxTest.curTxFKHeld.get();
        if (portfolioKey != null) {
            portfolioKey.removeWholeRangeKey(txId);
            fkHeld.remove(portfolioFK);
        }
        if (buyordersKey != null) {
            buyordersKey.removeWholeRangeKey(txId);
            fkHeld.remove(buyordersFK);
        }
        rangeForeignKeys.put((Object)portfolioFK, (Object)portfolioKey);
        rangeForeignKeys.put((Object)buyordersFK, (Object)buyordersKey);
        SQLDistTxTest.curTxFKHeld.set((Object)fkHeld);
    }

    protected void deleteFromGfxdTable(Connection gConn, int sec_id, String symbol, String exchange, int tid, int whichDelete, int[] updateCount) throws SQLException {
        PreparedStatement stmt = null;
        stmt = SQLTest.isEdge && !isTicket48176Fixed && isHATest ? TradeSecuritiesDMLDistTxStmt.getStmtThrowException(gConn, delete[whichDelete]) : gConn.prepareStatement(delete[whichDelete]);
        updateCount[0] = this.deleteFromTable(stmt, sec_id, symbol, exchange, tid, whichDelete);
    }

    protected void deleteFromDerbyTable(Connection dConn, int sec_id, String symbol, String exchange, int tid, int whichDelete, int updateCount) throws SQLException {
        PreparedStatement stmt = TradeSecuritiesDMLDistTxStmt.getStmt(dConn, delete[whichDelete]);
        Log.getLogWriter().info("Delete in derby, myTid is " + tid);
        int count = this.deleteFromTable(stmt, sec_id, symbol, exchange, tid, whichDelete);
        if (count != updateCount) {
            Log.getLogWriter().info("derby delete has different row count from that of gfxd gfxd deleted " + updateCount + " rows, but derby deleted " + count + " rows in " + TradeSecuritiesDMLDistTxStmt.getTableName());
        }
    }

    protected int deleteFromTable(PreparedStatement stmt, int sec_id, String symbol, String exchange, int tid, int whichDelete) throws SQLException {
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        String query = " QUERY: " + delete[whichDelete];
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleteing from trade.securities with SECID:" + sec_id + query);
                stmt.setInt(1, sec_id);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows from trade.securities with SECID:" + sec_id + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleteing from trade.securities with  SYMBOL:" + symbol + ",EXCHANGE:" + exchange + ",TID:" + tid + query);
                stmt.setString(1, symbol);
                stmt.setString(2, exchange);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows from trade.securities with  SYMBOL:" + symbol + ",EXCHANGE:" + exchange + ",TID:" + tid + query);
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    @Override
    protected BigDecimal getPrice() {
        double d = (double)(rand.nextInt(10000) + 1) * 0.01;
        String sd = Double.toString(d);
        String p = sd.substring(0, sd.indexOf(".") + 2);
        BigDecimal price = new BigDecimal(p);
        return price;
    }

    protected boolean insertGfxdOnly(Connection gConn) {
        try {
            this.insert(null, gConn, 1);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected boolean updateGfxdOnly(Connection gConn) {
        try {
            this.update(null, gConn, 1);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected boolean deleteGfxdOnly(Connection gConn) {
        try {
            this.delete(null, gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected boolean queryGfxdOnly(Connection gConn) {
        try {
            this.query(null, gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02") && batchingWithSecondaryData) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    @Override
    public void populate(Connection dConn, Connection gConn) {
        try {
            super.populate(dConn, gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02") && dConn == null) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
            }
            throw te;
        }
    }

    protected PreparedStatement getCorrectTxStmt(Connection conn, int whichUpdate) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectTxStmt(conn, whichUpdate, partitionKeys);
    }

    protected void getSidForTx(Connection regConn, int[] sids) {
        if (sids.length != 1) {
            throw new TestException("this method only handles for size of 1 case");
        }
        Connection conn = TradeSecuritiesDMLDistTxStmt.getAuthConn(regConn);
        int n = 0;
        n = useGfxdConfig ? rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary) / numOfThreads) : rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary) / TestHelper.getNumThreads());
        try {
            String s = "select sec_id from trade.securities where tid = " + TradeSecuritiesDMLDistTxStmt.getMyTid();
            ResultSet rs = conn.createStatement().executeQuery(s);
            int temp = 0;
            while (rs.next()) {
                if (n == temp) {
                    sids[0] = rs.getInt("SEC_ID");
                    break;
                }
                ++temp;
            }
            rs.close();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("use sid as 0");
            }
            if (se.getSQLState().equals("XN008")) {
                Log.getLogWriter().info("Query processing has been terminated due to an error on the server");
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                Log.getLogWriter().info("use sid as 0");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    static {
        try {
            String partition = (String)SQLTxPartitionInfoBB.getBB().getSharedMap().get((Object)("trade." + TradeSecuritiesDMLDistTxStmt.getTableName()));
            isReplicate = partition.equalsIgnoreCase("replicate");
        }
        catch (NullPointerException npe) {
            isReplicate = false;
        }
        Log.getLogWriter().info("isReplicate is " + isReplicate);
    }
}

