/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlDistTxStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlDistTxStatements.DMLDistTxStmtIF;
import sql.dmlDistTxStatements.TradePortfolioDMLDistTxStmt;
import sql.dmlStatements.TradeSellOrdersDMLStmt;
import sql.sqlTx.RangeForeignKey;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlTx.SQLTxBatchingFKBB;
import sql.sqlTx.SQLTxPartitionInfoBB;
import sql.sqlTx.SQLTxSecondBB;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class TradeSellOrdersDMLDistTxStmt
extends TradeSellOrdersDMLStmt
implements DMLDistTxStmtIF {
    public static String cidPrefix = "_cid_";
    public static String sidPrefix = "_sid_";
    static final boolean isConcUpdateTx = TestConfig.tab().booleanAt(SQLPrms.isConcUpdateTx, false);
    protected static String[] selectForUpdate = new String[]{"select oid, status from trade.sellorders where sid = ? and ask>? for update of status ", "select * from trade.sellorders where cid >= ? and cid <? for update of qty, status ", "select * from  trade.sellorders where cid = ? and sid= ? for update "};
    protected static String[] updateByPK = new String[]{"update trade.sellorders set status = ?  where oid = ? ", "update trade.sellorders set qty = ?,  status = ? where oid = ?  ", "update trade.sellorders set order_time = ? where oid = ? "};
    protected static String[] delete = new String[]{"delete from trade.sellorders where cid=? and sid=? and oid <?", "delete from trade.sellorders where oid=? ", "delete from trade.sellorders where cid>? and cid <? and oid <?", "delete from trade.sellorders where cid<? and sid = ? and oid < ?"};
    public static boolean isReplicate;
    protected boolean hasSecondary = isReplicate || batchingWithSecondaryData && (Boolean)SQLBB.getBB().getSharedMap().get((Object)SQLTest.hasRedundancy) != false;

    @Override
    public void deleteDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[8];
        try {
            this.deleteFromDerbyTable(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (Integer)data[5], (Integer)data[6], (Integer)data[7]);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
        }
    }

    protected void addDeleteToDerbyTx(int cid, int cid1, int sid, int oid, int whichDelete, int updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{5, "delete", cid, cid1, sid, oid, whichDelete, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public boolean deleteGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.deleteGfxdOnly(gConn);
        }
        int whichDelete = rand.nextInt(delete.length);
        int cid = TradeSellOrdersDMLDistTxStmt.getExistingCid();
        int cid1 = cid + 3;
        int sid = TradeSellOrdersDMLDistTxStmt.getExistingSid();
        int oid = TradeSellOrdersDMLDistTxStmt.getExistingOid();
        int[] updateCount = new int[1];
        SQLException gfxdse = null;
        Connection nonTxConn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            this.getKeysForDelete(nonTxConn, modifiedKeysByOp, whichDelete, cid, cid1, sid, oid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().warning("Not able to process the keys for this op due to HA, this insert op does not proceed");
                return true;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        try {
            this.deleteFromGfxdTable(gConn, cid, cid1, sid, oid, whichDelete, updateCount);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, se, true);
                } else {
                    this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, se, this.hasSecondary, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, gfxdse, false);
        } else {
            this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, gfxdse, this.hasSecondary, false);
        }
        this.addDeleteToDerbyTx(cid, cid1, sid, oid, whichDelete, updateCount[0], gfxdse);
        modifiedKeysByTx.putAll(modifiedKeysByOp);
        SQLDistTxTest.curTxModifiedKeys.set((Object)modifiedKeysByTx);
        return true;
    }

    public static int getExistingOid() {
        int newSids;
        int maxSid = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSellOrdersPrimary);
        int n = newSids = 10 * numOfThreads > 100 ? 10 * numOfThreads : 100;
        if (maxSid > newSids) {
            return rand.nextInt(maxSid - newSids) + 1;
        }
        throw new TestException("test issue, not enough sid in the tests yet");
    }

    private void getKeysForDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int cid, int cid1, int sid, int oid) throws SQLException {
        String sql = null;
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        ResultSet rs = null;
        PreparedStatement stmt = null;
        List<Struct> resultsList = null;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        switch (whichDelete) {
            case 0: {
                Integer oidKey;
                sql = "select oid from trade.sellorders where cid= " + cid + " and sid =" + sid + " and oid <" + oid;
                Log.getLogWriter().info(database + sql);
                rs = conn.createStatement().executeQuery(sql);
                resultsList = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
                if (resultsList == null) break;
                for (Struct row : resultsList) {
                    oidKey = (Integer)row.get("OID");
                    ids.add(oidKey);
                    Log.getLogWriter().info(database + "To be deleted key is: " + oidKey);
                }
                break;
            }
            case 1: {
                Integer oidKey;
                sql = "select oid from trade.sellorders where oid= ?";
                Log.getLogWriter().info(database + sql);
                stmt = conn.prepareStatement(sql);
                stmt.setInt(1, oid);
                rs = stmt.executeQuery();
                resultsList = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
                if (resultsList == null) break;
                for (Struct row : resultsList) {
                    oidKey = (Integer)row.get("OID");
                    ids.add(oidKey);
                    Log.getLogWriter().info(database + "To be deleted key is: " + oidKey);
                }
                break;
            }
            case 2: {
                Integer oidKey;
                sql = "select oid from trade.sellorders where cid>? and cid <? and oid <?";
                Log.getLogWriter().info(database + sql);
                stmt = conn.prepareStatement(sql);
                stmt.setInt(1, cid);
                stmt.setInt(2, cid1);
                stmt.setInt(3, oid);
                rs = stmt.executeQuery();
                resultsList = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
                if (resultsList == null) break;
                for (Struct row : resultsList) {
                    oidKey = (Integer)row.get("OID");
                    ids.add(oidKey);
                    Log.getLogWriter().info(database + "To be deleted key is: " + oidKey);
                }
                break;
            }
            case 3: {
                Integer oidKey;
                sql = "select oid from trade.sellorders where cid<? and sid = ? and oid <?";
                Log.getLogWriter().info(database + sql);
                stmt = conn.prepareStatement(sql);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                stmt.setInt(3, oid);
                rs = stmt.executeQuery();
                resultsList = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
                if (resultsList == null) break;
                for (Struct row : resultsList) {
                    oidKey = (Integer)row.get("OID");
                    ids.add(oidKey);
                    Log.getLogWriter().info(database + "To be deleted key is: " + oidKey);
                }
                break;
            }
            default: {
                throw new TestException("wrong index here");
            }
        }
        for (Integer key : ids) {
            keys.put(TradeSellOrdersDMLDistTxStmt.getTableName() + "_" + key, txId);
        }
    }

    protected void deleteFromGfxdTable(Connection gConn, int cid, int cid1, int sid, int oid, int whichDelete, int[] updateCount) throws SQLException {
        PreparedStatement stmt = null;
        stmt = SQLTest.isEdge && !isTicket48176Fixed && isHATest ? TradeSellOrdersDMLDistTxStmt.getStmtThrowException(gConn, delete[whichDelete]) : gConn.prepareStatement(delete[whichDelete]);
        updateCount[0] = this.deleteFromTableTx(stmt, cid, cid1, sid, oid, whichDelete);
    }

    protected void deleteFromDerbyTable(Connection dConn, int cid, int cid1, int sid, int oid, int whichDelete, int updateCount) throws SQLException {
        PreparedStatement stmt = TradeSellOrdersDMLDistTxStmt.getStmt(dConn, delete[whichDelete]);
        int count = this.deleteFromTableTx(stmt, cid, cid1, sid, oid, whichDelete);
        if (count != updateCount) {
            Log.getLogWriter().info("derby delete has different row count from that of gfxd gfxd deleted " + updateCount + " rows, but derby deleted " + count + " rows in " + TradeSellOrdersDMLDistTxStmt.getTableName());
        }
    }

    protected int deleteFromTableTx(PreparedStatement stmt, int cid, int cid1, int sid, int oid, int whichDelete) throws SQLException {
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        String query = " QUERY: " + delete[whichDelete];
        String successString = "";
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting trade.sellorders with CID:" + cid + ",SID:" + sid + ",OID:" + oid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                stmt.setInt(3, oid);
                successString = "from trade.sellorders with CID:" + cid + ",SID:" + sid + ",OID:" + oid + query;
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting trade.sellorders with OID:" + oid + query);
                stmt.setInt(1, oid);
                successString = "trade.sellorders with OID:" + oid + query;
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "deleting trade.sellorders with 1_CID:" + cid + ",2_CID:" + cid1 + ",OID:" + oid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, cid1);
                stmt.setInt(3, oid);
                successString = "trade.sellorders with 1_CID:" + cid + ",2_CID:" + cid1 + ",OID:" + oid + query;
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "deleting trade.sellorders with CID:" + cid + ",SID:" + sid + ",OID:" + oid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                stmt.setInt(3, oid);
                successString = "trade.sellorders with CID:" + cid + ",SID:" + sid + ",OID:" + oid + query;
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + "deleted " + rowCount + " rows from" + successString);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected boolean deleteGfxdOnly(Connection gConn) {
        try {
            this.delete(null, gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    protected void addInsertToDerbyTx(int[] oid, int[] cid, int[] sid, int[] qty, String[] status, Timestamp[] time, BigDecimal[] ask, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{5, "insert", oid, cid, sid, qty, status, time, ask, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    @Override
    public void insertDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[10];
        try {
            this.insertToDerbyTable(dConn, (int[])data[2], (int[])data[3], (int[])data[4], (int[])data[5], (String[])data[6], (Timestamp[])data[7], (BigDecimal[])data[8], (int[])data[9], 1);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    protected boolean insertToDerbyTable(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String[] status, Timestamp[] time, BigDecimal[] ask, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = TradeSellOrdersDMLDistTxStmt.getStmt(conn, insert);
        int tid = TradeSellOrdersDMLDistTxStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            count = this.insertToTable(stmt, oid[i], cid[i], sid[i], qty[i], status[i], time[i], ask[i], tid);
            if (count == updateCount[i]) continue;
            Log.getLogWriter().info("derby insert has different row count from that of gfxd gfxd inserted " + updateCount[i] + " row, but derby inserted " + count + " row in " + TradeSellOrdersDMLDistTxStmt.getTableName());
        }
        return true;
    }

    @Override
    public boolean insertGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.insertGfxdOnly(gConn);
        }
        int size = 1;
        int[] cid = new int[size];
        int[] sid = new int[size];
        int[] oid = new int[size];
        int[] qty = new int[size];
        String[] status = new String[size];
        Timestamp[] time = new Timestamp[size];
        BigDecimal[] ask = new BigDecimal[size];
        int[] updateCount = new int[size];
        boolean[] expectConflict = new boolean[1];
        Connection nonTxConn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        SQLException gfxdse = null;
        this.getKeysFromPortfolio(nonTxConn, cid, sid);
        this.getDataForInsert(nonTxConn, oid, cid, sid, qty, time, ask, size);
        for (int i = 0; i < status.length; ++i) {
            status[i] = "open";
        }
        int chance = 200;
        if (rand.nextInt(chance) == 0) {
            cid[0] = 0;
        } else if (rand.nextInt(chance) == 0) {
            sid[0] = 0;
        }
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        modifiedKeysByOp.put(TradeSellOrdersDMLDistTxStmt.getTableName() + "_" + oid[0], (Integer)SQLDistTxTest.curTxId.get());
        HashSet<String> parentKeysHold = new HashSet<String>();
        try {
            this.getKeysForInsert(nonTxConn, cid[0], sid[0], expectConflict, parentKeysHold);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().warning("Not able to process the keys for this op due to HA, this insert op does not proceed");
                return true;
            }
            SQLHelper.handleSQLException(se);
        }
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        if (batchingWithSecondaryData) {
            HashSet holdFKsByThisTx = (HashSet)SQLDistTxTest.foreignKeyHeldWithBatching.get();
            holdFKsByThisTx.addAll(parentKeysHold);
            SQLDistTxTest.foreignKeyHeldWithBatching.set((Object)holdFKsByThisTx);
            SharedMap holdingFKTxIds = SQLTxBatchingFKBB.getBB().getSharedMap();
            Integer myTxId = (Integer)SQLDistTxTest.curTxId.get();
            for (String key : parentKeysHold) {
                HashSet<Integer> txIds = (HashSet<Integer>)holdingFKTxIds.get((Object)key);
                if (txIds == null) {
                    txIds = new HashSet<Integer>();
                }
                txIds.add(myTxId);
                holdingFKTxIds.put((Object)key, txIds);
            }
        }
        try {
            this.insertToGfxdTable(gConn, oid, cid, sid, qty, status, time, ask, updateCount, size);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!expectConflict[0]) {
                    if (!batchingWithSecondaryData) {
                        this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, se, true);
                    } else {
                        this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, se, this.hasSecondary, true);
                    }
                }
                if (batchingWithSecondaryData) {
                    this.cleanUpFKHolds();
                }
                this.removePartialRangeForeignKeys(cid, sid);
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                if (batchingWithSecondaryData) {
                    this.cleanUpFKHolds();
                }
                this.removePartialRangeForeignKeys(cid, sid);
                return false;
            }
            if (expectConflict[0] && !se.getSQLState().equals("23503") && !batchingWithSecondaryData) {
                throw new TestException("expect conflict exceptions, but did not get it" + TestHelper.getStackTrace((Throwable)se));
            }
            gfxdse = se;
            if (batchingWithSecondaryData) {
                this.cleanUpFKHolds();
            }
            this.removePartialRangeForeignKeys(cid, sid);
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, gfxdse, false);
        } else {
            this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, gfxdse, this.hasSecondary, false);
        }
        if (expectConflict[0] && gfxdse == null && !batchingWithSecondaryData) {
            throw new TestException("Did not get conflict exception for foreign key check. Please check for logs");
        }
        if (withDerby) {
            this.addInsertToDerbyTx(oid, cid, sid, qty, status, time, ask, updateCount, gfxdse);
        }
        modifiedKeysByTx.putAll(modifiedKeysByOp);
        SQLDistTxTest.curTxModifiedKeys.set((Object)modifiedKeysByTx);
        return true;
    }

    protected boolean insertGfxdOnly(Connection gConn) {
        try {
            this.insert(null, gConn, 1);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    private void getKeysForInsert(Connection conn, int cid, int sid, boolean[] expectConflict, HashSet<String> parentKeys) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        sql = "select * from trade.portfolio where cid = " + cid + " and sid =" + sid;
        Log.getLogWriter().info(database + sql);
        rs = conn.createStatement().executeQuery(sql);
        if (!rs.next()) {
            Log.getLogWriter().info(database + "foreign key cid " + cid + ", sid " + sid + " does not exist " + "in the parent table, should get foreign key constraint exception");
        }
        rs.close();
        boolean hasForeignKeyConflict = this.hasForeignKeyConflict(TradePortfolioDMLDistTxStmt.getTableName() + cidPrefix + cid + sidPrefix + sid, txId);
        parentKeys.add(TradePortfolioDMLDistTxStmt.getTableName() + cidPrefix + cid + sidPrefix + sid);
        SharedMap rangeForeignKeys = SQLTxSecondBB.getBB().getSharedMap();
        String key = TradeSellOrdersDMLDistTxStmt.getTableName() + cidPrefix + cid + sidPrefix + sid;
        RangeForeignKey cid_sidRangeKey = (RangeForeignKey)rangeForeignKeys.get((Object)key);
        if (cid_sidRangeKey == null) {
            cid_sidRangeKey = new RangeForeignKey(key);
        }
        boolean hasRangeForeignKeyConflict = cid_sidRangeKey.hasConflictAddPartialRangeKey(txId);
        rangeForeignKeys.put((Object)(TradeSellOrdersDMLDistTxStmt.getTableName() + cidPrefix + cid + sidPrefix + sid), (Object)cid_sidRangeKey);
        ArrayList curTxRangeFK = (ArrayList)SQLDistTxTest.curTxFKHeld.get();
        curTxRangeFK.add(key);
        SQLDistTxTest.curTxFKHeld.set((Object)curTxRangeFK);
        boolean bl = expectConflict[0] = hasForeignKeyConflict || hasRangeForeignKeyConflict;
        if (hasForeignKeyConflict) {
            Log.getLogWriter().info(database + "should expect lock not held/conflict exception here");
        }
    }

    protected void removePartialRangeForeignKeys(int[] cid, int[] sid) {
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        SharedMap rangeForeignKeys = SQLTxSecondBB.getBB().getSharedMap();
        RangeForeignKey cid_sidRangeKey = (RangeForeignKey)rangeForeignKeys.get((Object)(TradeSellOrdersDMLDistTxStmt.getTableName() + cidPrefix + cid[0] + sidPrefix + sid[0]));
        if (cid_sidRangeKey != null) {
            cid_sidRangeKey.removePartialRangeKey(txId);
        }
        Log.getLogWriter().info("removing the partial range foreign key for this TXID:" + txId);
    }

    protected void insertToGfxdTable(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String[] status, Timestamp[] time, BigDecimal[] ask, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        stmt = SQLTest.isEdge && !isTicket48176Fixed && isHATest ? (useDefaultValue ? TradeSellOrdersDMLDistTxStmt.getStmtThrowException(conn, insertWithDefaultValue) : TradeSellOrdersDMLDistTxStmt.getStmtThrowException(conn, insert)) : (useDefaultValue ? conn.prepareStatement(insertWithDefaultValue) : conn.prepareStatement(insert));
        int tid = TradeSellOrdersDMLDistTxStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            updateCount[i] = this.insertToTable(stmt, oid[i], cid[i], sid[i], qty[i], status[i], time[i], ask[i], tid);
        }
    }

    public static String getTableName() {
        return "sellorders";
    }

    @Override
    public void queryDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[10];
        List gfxdList = (List)data[9];
        ResultSet derbyRS = null;
        try {
            derbyRS = TradeSellOrdersDMLDistTxStmt.query(dConn, (Integer)data[2], (String[])data[3], (BigDecimal[])data[4], (int[])data[5], (int[])data[6], (Timestamp)data[7], (Integer)data[8]);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
        }
        ResultSetHelper.compareResultSets(ResultSetHelper.asList(derbyRS, true), gfxdList);
    }

    @Override
    public boolean queryGfxd(Connection gConn, boolean withDerby) {
        List<Struct> gfxdList;
        if (!withDerby) {
            return this.queryGfxdOnly(gConn);
        }
        int numOfNonUniq = select.length / 2;
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        Connection nonTxConn = (Connection)SQLDistTxTest.gfxdNoneTxConn.get();
        String[] status = new String[2];
        BigDecimal[] ask = new BigDecimal[2];
        int[] cid = new int[5];
        int[] oid = new int[5];
        int tid = TradeSellOrdersDMLDistTxStmt.getMyTid();
        Timestamp orderTime = this.getRandTime();
        this.getStatus(status);
        this.getAsk(ask);
        this.getCids(nonTxConn, cid);
        this.getOids(oid);
        ResultSet gfxdRS = null;
        SQLException gfxdse = null;
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            gfxdRS = TradeSellOrdersDMLDistTxStmt.query(gConn, whichQuery, status, ask, cid, oid, orderTime, tid);
            if (gfxdRS == null) {
                throw new TestException("Not able to get gfxd result set");
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02") && batchingWithSecondaryData) {
                this.verifyConflictWithBatching(new HashMap<String, Integer>(), modifiedKeysByTx, se, this.hasSecondary, true);
                return false;
            }
            if (isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            gfxdse = se;
        }
        if ((gfxdList = ResultSetHelper.asList(gfxdRS, false)) == null && isHATest) {
            Log.getLogWriter().info("Testing HA and did not get GFXD result set due to node failure");
            return false;
        }
        this.addQueryToDerbyTx(whichQuery, status, ask, cid, oid, orderTime, tid, gfxdList, gfxdse);
        return true;
    }

    protected void addQueryToDerbyTx(int whichQuery, String[] status, BigDecimal[] ask, int[] cid, int[] oid, Timestamp orderTime, int tid, List<Struct> gfxdList, SQLException gfxdse) {
        Object[] data = new Object[]{5, "query", whichQuery, status, ask, cid, oid, orderTime, tid, gfxdList, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    protected boolean queryGfxdOnly(Connection gConn) {
        try {
            this.query(null, gConn);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02") && batchingWithSecondaryData) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    @Override
    public void updateDerby(Connection dConn, int index) {
        ArrayList derbyOps = (ArrayList)SQLDistTxTest.derbyOps.get();
        Object[] data = (Object[])derbyOps.get(index);
        SQLException gfxdse = (SQLException)data[12];
        try {
            this.updateDerbyTable(dConn, (int[])data[2], (int[])data[3], (int[])data[4], (BigDecimal[])data[5], (int[])data[6], (Timestamp[])data[7], (String)data[8], (ArrayList)data[9], (int[])data[10], (int[])data[11], 1);
        }
        catch (SQLException derbyse) {
            SQLHelper.compareExceptions(derbyse, gfxdse);
            return;
        }
        if (gfxdse != null) {
            SQLHelper.handleMissedSQLException(gfxdse);
        }
    }

    protected void updateDerbyTable(Connection conn, int[] cid, int[] cid2, int[] sid, BigDecimal[] ask, int[] qty, Timestamp[] orderTime, String status, ArrayList<Integer> oids, int[] whichUpdate, int[] gfxdupdateCount, int size) throws SQLException {
        PreparedStatement pstmt = null;
        PreparedStatement ursstmt = null;
        int tid = TradeSellOrdersDMLDistTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("select for update in derby, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            String sql = selectForUpdate[whichUpdate[i]];
            Log.getLogWriter().info("select for update statement is " + sql);
            pstmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(conn, whichUpdate[i]) : TradeSellOrdersDMLDistTxStmt.getStmt(conn, updateByPK[whichUpdate[i]]);
            if (pstmt == null) continue;
            try {
                ursstmt = conn.prepareStatement(sql, 1003, 1008);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            ResultSet rs = this.getSelectForUpdateRS(ursstmt, cid[i], cid2[i], sid[i], ask[i], orderTime[i], status, whichUpdate[i], size);
            Log.getLogWriter().info("oids size is " + oids.size());
            int[] derbyUpdateCount = new int[oids.size()];
            this.updateTable(null, rs, qty[i], status, orderTime[i], oids, whichUpdate[i], derbyUpdateCount, size, false);
            for (int j = 0; j < oids.size(); ++j) {
                if (derbyUpdateCount[j] == gfxdupdateCount[j]) continue;
                Log.getLogWriter().info("Derby update has different row count from that of gfxd, gfxd updated " + gfxdupdateCount[j] + " rows, but derby updated " + count + " rows");
            }
        }
    }

    @Override
    public boolean updateGfxd(Connection gConn, boolean withDerby) {
        if (!withDerby) {
            return this.updateGfxdOnly(gConn);
        }
        if (!SQLDistTxTest.isTicket43188fiFixed && SQLDistTxTest.useThinClientDriverInTx) {
            return true;
        }
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        int size = 1;
        int[] sid = new int[size];
        BigDecimal[] ask = new BigDecimal[size];
        Timestamp[] orderTime = new Timestamp[size];
        int[] cid = new int[size];
        int[] cid2 = new int[size];
        int[] qty = new int[size];
        ArrayList<Integer> oids = new ArrayList<Integer>();
        String status = statuses[rand.nextInt(statuses.length)];
        int[] whichUpdate = new int[size];
        SQLException gfxdse = null;
        boolean success = this.getDataForUpdate((Connection)SQLDistTxTest.gfxdNoneTxConn.get(), cid, cid2, sid, qty, orderTime, ask, whichUpdate, size);
        if (!success) {
            return true;
        }
        HashMap<String, Integer> modifiedKeysByOp = new HashMap<String, Integer>();
        HashMap modifiedKeysByTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        try {
            this.getKeysForUpdate((Connection)SQLDistTxTest.gfxdNoneTxConn.get(), modifiedKeysByOp, whichUpdate[0], cid[0], cid2[0], sid[0], ask[0], orderTime[0], oids);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().warning("Not able to process the keys for this op due to HA, this update op does not proceed");
                return true;
            }
            SQLHelper.handleSQLException(se);
        }
        int[] updateCount = new int[oids.size()];
        try {
            success = this.updateGfxdTable(gConn, cid, cid2, sid, ask, qty, orderTime, status, oids, whichUpdate, updateCount, size);
            if (!success) {
                if (isHATest && ((Boolean)SQLDistTxTest.failedToGetStmtNodeFailure.get()).booleanValue()) {
                    SQLDistTxTest.failedToGetStmtNodeFailure.set((Object)false);
                    return false;
                }
                if (((Boolean)SQLDistTxTest.updateOnPartitionCol.get()).booleanValue()) {
                    SQLDistTxTest.updateOnPartitionCol.set((Object)false);
                    return true;
                }
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                if (!batchingWithSecondaryData) {
                    this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, se, true);
                } else {
                    this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, se, this.hasSecondary, true);
                }
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx with HA support, continue testing");
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        if (!batchingWithSecondaryData) {
            this.verifyConflict(modifiedKeysByOp, modifiedKeysByTx, gfxdse, false);
        } else {
            this.verifyConflictWithBatching(modifiedKeysByOp, modifiedKeysByTx, gfxdse, this.hasSecondary, false);
        }
        this.addUpdateToDerbyTx(cid, cid2, sid, ask, qty, orderTime, status, oids, whichUpdate, updateCount, gfxdse);
        modifiedKeysByTx.putAll(modifiedKeysByOp);
        SQLDistTxTest.curTxModifiedKeys.set((Object)modifiedKeysByTx);
        return true;
    }

    protected void addUpdateToDerbyTx(int[] cid, int[] cid2, int[] sid, BigDecimal[] ask, int[] qty, Timestamp[] orderTime, String status, ArrayList<Integer> oids, int[] whichUpdate, int[] updateCount, SQLException gfxdse) {
        Object[] data = new Object[]{5, "update", cid, cid2, sid, ask, qty, orderTime, status, oids, whichUpdate, updateCount, gfxdse};
        ArrayList<Object[]> derbyOps = (ArrayList<Object[]>)SQLDistTxTest.derbyOps.get();
        if (derbyOps == null) {
            derbyOps = new ArrayList<Object[]>();
        }
        derbyOps.add(data);
        SQLDistTxTest.derbyOps.set(derbyOps);
    }

    protected boolean getDataForUpdate(Connection regConn, int[] cid, int[] cid2, int[] sid, int[] qty, Timestamp[] orderTime, BigDecimal[] ask, int[] whichUpdate, int size) {
        Connection conn = TradeSellOrdersDMLDistTxStmt.getAuthConn(regConn);
        int cidRange = 3;
        if (!((Boolean)SQLDistTxTest.commitEarly.get()).booleanValue()) {
            return false;
        }
        int[] cids = new int[size * 2];
        int[] sids = new int[size * 2];
        if (!this.getDataFromResult(conn, cid, sid)) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            qty[i] = this.getQty();
            orderTime[i] = this.getRandTime();
            ask[i] = this.getPrice();
            whichUpdate[i] = rand.nextInt(selectForUpdate.length);
            cid[i] = cids[i];
            cid2[i] = cid[i] + cidRange;
            sid[i] = sids[i];
        }
        return true;
    }

    protected boolean updateGfxdOnly(Connection gConn) {
        try {
            this.update(null, gConn, 1);
        }
        catch (TestException te) {
            if (te.getMessage().contains("X0Z02")) {
                Log.getLogWriter().info("got expected conflict exception, continuing test");
                return false;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                Log.getLogWriter().info("got expected node failure exception, continuing test");
                return false;
            }
            throw te;
        }
        return true;
    }

    @Override
    protected int getWhichUpdate(int numOfNonUniq, int total) {
        int whichOne = super.getWhichOne(numOfNonUniq, total);
        if (isConcUpdateTx) {
            if (whichOne == 2 || whichOne == 6) {
                --whichOne;
            } else if (whichOne == 3 || whichOne == 7) {
                whichOne -= 2;
            }
        }
        return whichOne;
    }

    protected void getKeysForUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int cid, int cid2, int sid, BigDecimal ask, Timestamp orderTime, ArrayList<Integer> oids) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        switch (whichUpdate) {
            case 0: {
                sql = "select oid from trade.sellorders where sid=" + sid + " and ask > " + ask;
                Log.getLogWriter().info(database + "executing " + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int oid = rs.getInt(1);
                    Log.getLogWriter().info(database + "OID: " + oid + " exists to be locked by select for update");
                    if (oids.size() == 0) {
                        oids.add(oid);
                    } else if (rand.nextBoolean()) {
                        oids.add(oid);
                    } else {
                        Log.getLogWriter().info(database + "OID: " + oid + " will not be modified by update");
                    }
                    keys.put(TradeSellOrdersDMLDistTxStmt.getTableName() + "_" + oid, txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select oid from trade.sellorders where cid>=" + cid + " and cid <" + cid2;
                Log.getLogWriter().info(database + "executing " + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int oid = rs.getInt(1);
                    Log.getLogWriter().info(database + "OID: " + oid + " exists to be locked by select for update");
                    if (oids.size() == 0) {
                        oids.add(oid);
                    } else if (rand.nextBoolean()) {
                        oids.add(oid);
                    } else {
                        Log.getLogWriter().info(database + "OID: " + oid + " will not be modified by update");
                    }
                    keys.put(TradeSellOrdersDMLDistTxStmt.getTableName() + "_" + oid, txId);
                }
                rs.close();
                break;
            }
            case 2: {
                sql = "select oid from trade.sellorders where cid=" + cid + " and sid =" + sid;
                Log.getLogWriter().info(database + "executing " + sql);
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int oid = rs.getInt(1);
                    Log.getLogWriter().info(database + "OID: " + oid + " exists to be locked by select for update");
                    if (oids.size() == 0) {
                        oids.add(oid);
                    } else if (rand.nextBoolean()) {
                        oids.add(oid);
                    } else {
                        Log.getLogWriter().info(database + "OID: " + oid + " will not be modified by update");
                    }
                    keys.put(TradeSellOrdersDMLDistTxStmt.getTableName() + "_" + oid, txId);
                }
                rs.close();
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected boolean updateGfxdTable(Connection conn, int[] cid, int[] cid2, int[] sid, BigDecimal[] ask, int[] qty, Timestamp[] orderTime, String status, ArrayList<Integer> oids, int[] whichUpdate, int[] updateCount, int size) throws SQLException {
        PreparedStatement stmt = null;
        int tid = TradeSellOrdersDMLDistTxStmt.getMyTid();
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        Log.getLogWriter().info(database + "select for update in gemfirexd, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            boolean success;
            boolean usePK = false;
            String sql = selectForUpdate[whichUpdate[i]];
            Log.getLogWriter().info(database + "select for update statement is " + sql);
            try {
                stmt = conn.prepareStatement(sql, 1003, 1008);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (se.getSQLState().equals("0A000")) {
                    if (whichUpdate[i] == 0 && partitionKeys.contains("status")) {
                        SQLDistTxTest.updateOnPartitionCol.set((Object)true);
                        return false;
                    }
                    if (whichUpdate[i] == 1 && (partitionKeys.contains("qty") || partitionKeys.contains("status"))) {
                        SQLDistTxTest.updateOnPartitionCol.set((Object)true);
                        return false;
                    }
                    SQLHelper.handleSQLException(se);
                }
                throw se;
            }
            ResultSet rs = this.getSelectForUpdateRS(stmt, cid[i], cid2[i], sid[i], ask[i], orderTime[i], status, whichUpdate[i], size);
            ArrayList selectForUpdateRSList = (ArrayList)SQLDistTxTest.selectForUpdateRS.get();
            selectForUpdateRSList.add(rs);
            SQLDistTxTest.selectForUpdateRS.set((Object)selectForUpdateRSList);
            if (usePK) {
                stmt = SQLTest.testPartitionBy ? this.getCorrectTxStmt(conn, whichUpdate[i]) : TradeSellOrdersDMLDistTxStmt.getStmt(conn, updateByPK[whichUpdate[i]]);
                if (stmt == null) {
                    return false;
                }
                success = this.updateTable(stmt, rs, qty[i], status, orderTime[i], oids, whichUpdate[i], updateCount, size, usePK);
                if (success) continue;
                return success;
            }
            success = this.updateTable(stmt, rs, qty[i], status, orderTime[i], oids, whichUpdate[i], updateCount, size, usePK);
            if (success) continue;
            return success;
        }
        return true;
    }

    protected ResultSet getSelectForUpdateRS(PreparedStatement stmt, int cid, int cid2, int sid, BigDecimal ask, Timestamp orderTime, String status, int whichUpdate, int size) throws SQLException {
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        switch (whichUpdate) {
            case 0: {
                stmt.setInt(1, sid);
                stmt.setBigDecimal(2, ask);
                Log.getLogWriter().info(database + " selecting for update from trade.sellorders with SID:" + sid + ",ASK:" + ask + " QUERY: " + selectForUpdate[whichUpdate]);
                break;
            }
            case 1: {
                stmt.setInt(1, cid);
                stmt.setInt(2, cid2);
                Log.getLogWriter().info(database + "selecting for update from trade.sellorders with 1_CID:" + cid + ",2_CID:" + cid2 + " QUERY: " + selectForUpdate[whichUpdate]);
                break;
            }
            case 2: {
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                Log.getLogWriter().info(database + "selecting for update from trade.sellorders with CID:" + cid + ",SID:" + sid + " QUERY: " + selectForUpdate[whichUpdate]);
                break;
            }
            default: {
                throw new TestException(database + "Wrong select for update sql string here");
            }
        }
        return stmt.executeQuery();
    }

    protected boolean updateTable(PreparedStatement stmt, ResultSet rs, int qty, String status, Timestamp orderTime, ArrayList<Integer> oids, int whichUpdate, int[] updateCount, int size, boolean usePK) throws SQLException {
        boolean[] success = new boolean[1];
        String txid = SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = "Derby - ";
        if (stmt != null) {
            int txId = (Integer)SQLDistTxTest.curTxId.get();
            String string = database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        }
        if (usePK) {
            for (int i = 0; i < oids.size(); ++i) {
                updateCount[i] = this.updateTableUsngPKStmt(stmt, qty, status, orderTime, oids.get(i), whichUpdate);
            }
        } else {
            Log.getLogWriter().info(database + "update using resultset updateRow");
            while (rs.next()) {
                int oid = rs.getInt("OID");
                for (int i = 0; i < oids.size(); ++i) {
                    if (oid != oids.get(i)) continue;
                    updateCount[i] = this.updateTableUsingURS(rs, qty, status, orderTime, oids.get(i), whichUpdate, success);
                    if (success[0]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected int updateTableUsngPKStmt(PreparedStatement stmt, int qty, String status, Timestamp orderTime, int oid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        int txId = (Integer)SQLDistTxTest.curTxId.get();
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - TXID:" + txId + " ";
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(database + "updating trade.sellorders with STATUS:" + status + "where OID:" + oid + " QUERY: " + updateByPK[whichUpdate]);
                stmt.setString(1, status);
                stmt.setInt(2, oid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.sellorders with STATUS:" + status + "where OID:" + oid + " QUERY: " + updateByPK[whichUpdate]);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "updating trade.sellorders with QTY:" + qty + ",STATUS:" + status + "where OID:" + oid + " QUERY: " + updateByPK[whichUpdate]);
                stmt.setInt(1, qty);
                stmt.setString(2, status);
                stmt.setInt(3, oid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.sellorders with QTY:" + qty + ",STATUS:" + status + "where OID:" + oid + " QUERY: " + updateByPK[whichUpdate]);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "updating trade.sellorders with ORDERTIME:" + orderTime + " where OID:" + oid + " QUERY: " + updateByPK[whichUpdate]);
                stmt.setTimestamp(1, orderTime);
                stmt.setInt(2, oid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.sellorders with ORDERTIME:" + orderTime + " where OID:" + oid + " QUERY: " + updateByPK[whichUpdate]);
                break;
            }
            default: {
                throw new TestException(database + "Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int updateTableUsingURS(ResultSet rs, int qty, String status, Timestamp orderTime, int oid, int whichUpdate, boolean[] success) throws SQLException {
        int rowCount = 1;
        String txid = "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(txid + "updating tarde.sellorders table using URS with STATUS: " + status + "where OID:" + oid + " QUERY: " + "update  status = ? where oid = ?");
                rs.updateString("STATUS", status);
                rs.updateRow();
                break;
            }
            case 1: {
                Log.getLogWriter().info(txid + "updating trade.sellorders table using URS with QTY:" + qty + ", " + "STATUS:" + status + " where OID:" + oid + " QUERY: " + "update trade.sellorders set qty = ?,  status = ? where where oid = ?  ");
                rs.updateInt("QTY", qty);
                rs.updateString("STATUS", status);
                rs.updateRow();
                break;
            }
            case 2: {
                Log.getLogWriter().info(txid + "updating trade.sellorders table using URS with ORDERTIME:" + orderTime + " where OID:" + oid + " QUERY: " + "update trade.sellorders set order_time = ? where where oid = ? ");
                try {
                    rs.updateTimestamp("ORDER_TIME", orderTime);
                    rs.updateRow();
                    break;
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    if (se.getSQLState().equals("0A000") && partitionKeys.contains("order_time")) {
                        rowCount = 0;
                        success[0] = false;
                        return rowCount;
                    }
                    throw se;
                }
            }
            default: {
                throw new TestException("Wrong updatable resultset used here");
            }
        }
        success[0] = true;
        return rowCount;
    }

    private PreparedStatement getCorrectTxStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys) {
        PreparedStatement stmt = null;
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("status")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, updateByPK[whichUpdate]);
                    break;
                }
                stmt = TradeSellOrdersDMLDistTxStmt.getStmt(conn, updateByPK[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("qty") || partitionKeys.contains("status")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, updateByPK[whichUpdate]);
                    break;
                }
                stmt = TradeSellOrdersDMLDistTxStmt.getStmt(conn, updateByPK[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("order_time")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, updateByPK[whichUpdate]);
                    break;
                }
                stmt = TradeSellOrdersDMLDistTxStmt.getStmt(conn, updateByPK[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    private PreparedStatement getCorrectTxStmt(Connection conn, int whichUpdate) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectTxStmt(conn, whichUpdate, partitionKeys);
    }

    static {
        try {
            String partition = (String)SQLTxPartitionInfoBB.getBB().getSharedMap().get((Object)("trade." + TradeSellOrdersDMLDistTxStmt.getTableName()));
            isReplicate = partition.equalsIgnoreCase("replicate");
        }
        catch (NullPointerException npe) {
            isReplicate = false;
        }
        Log.getLogWriter().info("isReplicate is " + isReplicate);
    }
}

