/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements;

import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedLock;
import hydra.blackboard.SharedMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import javax.sql.rowset.serial.SerialClob;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.DMLStmtIF;
import sql.dmlStatements.TradeCustomersDMLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlTx.ForeignKeyLocked;
import sql.sqlTx.SQLDistRRTxTest;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlTx.SQLTxBB;
import sql.sqlTx.SQLTxBatchingBB;
import sql.sqlTx.SQLTxBatchingDeleteHoldKeysBB;
import sql.sqlTx.SQLTxBatchingFKBB;
import sql.sqlTx.SQLTxBatchingNonDeleteHoldKeysBB;
import sql.sqlTx.SQLTxDeleteHoldKeysBlockingChildBB;
import sql.sqlTx.SQLTxHoldForeignKeysBB;
import sql.sqlTx.SQLTxHoldKeysBlockingChildBB;
import sql.sqlTx.SQLTxHoldNewForeignKeysBB;
import sql.sqlTx.SQLTxPrms;
import sql.sqlTx.SQLTxRRReadBB;
import sql.sqlTx.SQLTxRRWriteBB;
import sql.sqlutil.GFXDStructImpl;
import sql.sqlutil.ResultSetHelper;
import sql.wan.SQLWanBB;
import sql.wan.SQLWanPrms;
import sql.wan.WanTest;
import util.StopStartPrms;
import util.TestException;
import util.TestHelper;

public abstract class AbstractDMLStmt
implements DMLStmtIF {
    protected static final Random rand = SQLTest.random;
    protected static boolean testUniqueKeys = SQLTest.testUniqueKeys;
    protected static boolean isSerial = SQLTest.isSerial;
    protected static boolean randomData = SQLTest.randomData;
    protected static boolean queryAnyTime = SQLTest.queryAnyTime;
    protected static boolean hasNetworth = SQLTest.hasNetworth;
    protected static HashMap<Integer, ArrayList<Integer>> cidsByThread = new HashMap();
    protected static SharedMap partitionMap = SQLBB.getBB().getSharedMap();
    protected static SharedMap wanPartitionMap = SQLWanBB.getBB().getSharedMap();
    protected static boolean isHATest = TestConfig.tab().longAt(StopStartPrms.numVMsToStop, 0L) > 0L ? true : TestConfig.tab().booleanAt(SQLPrms.rebalanceBuckets, false);
    protected static boolean usingTrigger = TestConfig.tab().booleanAt(SQLPrms.usingTrigger, false);
    public static final String TXLOCK = "lockToPerformTx";
    public static final String LOCK_SERVICE_NAME = "MyLockService";
    protected static DistributedLockService dls;
    protected static SharedLock lock;
    public static boolean byCidRange;
    public static boolean byTidList;
    public static boolean singleRowTx;
    protected static String thisTxId;
    public static String cid_txId;
    public static int cidRangeForTxOp;
    public static boolean isWanTest;
    public static boolean testLoaderCreateRandomRow;
    protected static boolean useWriterForWriteThrough;
    protected static int retrySleepMs;
    protected static int numOfThreads;
    protected static int numGettingDataFromDerby;
    protected static boolean useGfxdConfig;
    protected static boolean testSecurity;
    public static boolean isOfflineTest;
    protected static boolean useTimeout;
    protected static boolean mixRR_RC;
    protected static boolean setCriticalHeap;
    protected static boolean nobatching;
    protected static boolean batchingWithSecondaryData;
    protected static boolean testWanUniqueness;
    protected boolean generateIdAlways = SQLTest.generateIdAlways;
    protected boolean generateDefaultId = SQLTest.generateDefaultId;
    protected static boolean hasCompanies;
    protected static boolean failAtUpdateCount;
    protected boolean ticket46799fixed = TestConfig.tab().booleanAt(SQLPrms.ticket46799fixed, false);
    protected boolean noNullClob = TestConfig.tab().booleanAt(SQLPrms.noNullClob, false);
    protected static boolean alterTableDropColumn;
    protected static short[] digits;
    public static boolean gfxdtxHANotReady;
    public boolean testPartionBy = SQLTest.testPartitionBy;
    protected static boolean isTicket48176Fixed;
    protected static boolean isTicket49338Fixed;
    protected static boolean allowUpdateOnPartitionColumn;
    public static HydraThreadLocal dumpNoAggregateRs;
    public static HydraThreadLocal dumpQueryPlanRs;
    protected static boolean hasHdfs;
    protected static boolean ticket42672fixed;
    public static boolean reproduce49935;
    protected static boolean useMD5Checksum;
    public static boolean queryOpTimeNewTables;
    public static String parentKeyHeldTxid;
    public static boolean isSingleHop;
    public static boolean hasTx;
    public static ThreadLocal<Calendar> myCal;
    public static boolean testworkaroundFor51519;
    protected int initMaxQty = 2000;
    private Connection dConn;
    private Connection gConn;

    protected static void getLock() {
        if (!SQLTest.isEdge) {
            dls.lock((Object)TXLOCK, -1L, -1L);
        } else {
            lock.lock();
        }
    }

    protected void releaseLock() {
        if (!SQLTest.isEdge) {
            dls.unlock((Object)TXLOCK);
        } else {
            lock.unlock();
        }
    }

    @Override
    public abstract void insert(Connection var1, Connection var2, int var3);

    @Override
    public abstract void update(Connection var1, Connection var2, int var3);

    @Override
    public abstract void delete(Connection var1, Connection var2);

    @Override
    public abstract void query(Connection var1, Connection var2);

    @Override
    public void populate(Connection dConn, Connection gConn) {
        int initSize = 10;
        this.populate(dConn, gConn, initSize);
    }

    public void populate(Connection dConn, Connection gConn, int initSize) {
        for (int i = 0; i < initSize; ++i) {
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            this.insert(dConn, gConn, 1);
            this.commit(gConn);
            Log.getLogWriter().info("gfxd committed");
            if (dConn == null) continue;
            this.commit(dConn);
            Log.getLogWriter().info("derby committed");
        }
    }

    private static DistributedLockService getLockService() {
        DistributedLockService dls = DistributedLockService.getServiceNamed((String)LOCK_SERVICE_NAME);
        if (dls == null) {
            InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
            if (ds == null) {
                throw new TestException("DistributedSystem is " + ds);
            }
            dls = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)ds);
        }
        return dls;
    }

    protected int getMyWanSite() {
        if (isWanTest) {
            return WanTest.myWanSite;
        }
        return -1;
    }

    public static int getMyTid() {
        if (testWanUniqueness) {
            return WanTest.myWanSite;
        }
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        return myTid;
    }

    public static Calendar getCal() {
        return Calendar.getInstance(TimeZone.getTimeZone(ResultSetHelper.defaultTimeZone));
    }

    protected int getRandomTid() {
        if (testWanUniqueness) {
            return WanTest.myWanSite;
        }
        int myTid = AbstractDMLStmt.getMyTid();
        int offset = rand.nextInt(5);
        return myTid < 5 ? myTid + offset : myTid - offset;
    }

    protected static PreparedStatement getStmt(Connection conn, String sql) {
        PreparedStatement stmt = null;
        try {
            stmt = AbstractDMLStmt.getStmtThrowException(conn, sql);
        }
        catch (SQLException se) {
            if (gfxdtxHANotReady && isHATest && !SQLTest.hasTx && SQLTest.setTx && SQLHelper.gotTXNodeFailureException(se) && SQLTest.hasDerbyServer) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("prepare statement got node failure exception during Tx without HA support, continue testing");
                boolean[] getNodeFailure = (boolean[])SQLTest.getNodeFailure.get();
                if (getNodeFailure == null) {
                    getNodeFailure = new boolean[]{true};
                }
                SQLTest.getNodeFailure.set((Object)getNodeFailure);
            }
            if (gfxdtxHANotReady && isHATest && SQLTest.hasTx && SQLHelper.gotTXNodeFailureException(se) && SQLTest.hasDerbyServer) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("prepare statement got node failure exception during Tx without HA support, continue testing");
                SQLDistTxTest.failedToGetStmtNodeFailure.set((Object)true);
            }
            SQLHelper.handleSQLException(se);
        }
        return stmt;
    }

    protected static PreparedStatement getStmtThrowException(Connection conn, String sql) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            if (SQLTest.testSecurity && (se.getSQLState().equals("42500") || se.getSQLState().equals("42502") || se.getSQLState().equals("25502"))) {
                Log.getLogWriter().info("sql is " + sql);
                SQLHelper.printSQLException(se);
                SQLSecurityTest.prepareStmtException.set((Object)se);
            }
            if (!SQLHelper.checkDerbyException(conn, se)) {
                if (hasTx) {
                    SQLDistTxTest.rollbackGfxdTx.set((Object)true);
                    Log.getLogWriter().info("force gfxd to rollback operations as well");
                } else {
                    Log.getLogWriter().info("get stmt failed due to lock issue or read time out");
                }
            }
            if ((se.getSQLState().equals("42X14") || se.getSQLState().equals("42802") || se.getSQLState().equals("42X04")) && alterTableDropColumn) {
                SQLHelper.printSQLException(se);
                if (SQLHelper.isDerbyConn(conn)) {
                    Log.getLogWriter().info("alterTableException is set to true");
                    SQLTest.alterTableException.set((Object)true);
                } else if (SQLTest.hasDerbyServer) {
                    if (SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                        SQLTest.alterTableException.set((Object)false);
                        Log.getLogWriter().info("alterTableException is set to false");
                    } else {
                        throw new TestException("Derby does not get alter table exception but gfxd does" + TestHelper.getStackTrace((Throwable)se));
                    }
                }
                Log.getLogWriter().info("got expected missing column due to alter table drop column");
            }
            throw se;
        }
        return stmt;
    }

    protected Statement getStmt(Connection conn) {
        Statement stmt;
        try {
            stmt = conn.createStatement();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("could not get Statement\n" + TestHelper.getStackTrace((Throwable)se));
        }
        return stmt;
    }

    protected PreparedStatement getUnsupportedStmt(Connection conn, String sql) {
        if (!allowUpdateOnPartitionColumn) {
            if (hasTx) {
                SQLDistTxTest.updateOnPartitionCol.set((Object)true);
            }
            return null;
        }
        try {
            conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            if (SQLTest.testSecurity && (se.getSQLState().equals("42500") || se.getSQLState().equals("42502"))) {
                SQLHelper.printSQLException(se);
                SQLSecurityTest.prepareStmtException.set((Object)se);
            }
            if (se.getSQLState().equals("0A000")) {
                if (SQLTest.hasTx) {
                    SQLDistTxTest.updateOnPartitionCol.set((Object)true);
                }
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("Got the expected Exception, continuing test");
                return null;
            }
            if (se.getSQLState().equals("42Z23") && (this.generateIdAlways || this.generateDefaultId)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("Got the expected Exception, continuing test");
                return null;
            }
            if (setCriticalHeap && se.getSQLState().equals("XCL54")) {
                Log.getLogWriter().warning("memory runs low and get query cancellation exception");
                return null;
            }
            if ((se.getSQLState().equals("42X14") || se.getSQLState().equals("42802") || se.getSQLState().equals("42X04")) && alterTableDropColumn) {
                SQLHelper.printSQLException(se);
                if (SQLHelper.isDerbyConn(conn)) {
                    throw new TestException("test issue, derby connection should not execute this" + TestHelper.getStackTrace((Throwable)se));
                }
                if (SQLTest.hasDerbyServer) {
                    // empty if block
                }
                Log.getLogWriter().info("got expected missing column due to alter table drop column");
                return null;
            }
            if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se) && SQLTest.hasDerbyServer) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got node failure exception during Tx without HA support, continue testing");
                SQLDistTxTest.failedToGetStmtNodeFailure.set((Object)true);
                return null;
            }
            throw new TestException("Not the expected  Feature not implemented \n" + TestHelper.getStackTrace((Throwable)se));
        }
        throw new TestException("Did not get the expected  'Feature not implemented' exception\n");
    }

    protected int getWhichOne(int numOfNonUniq, int total) {
        int whichOne = testUniqueKeys ? rand.nextInt(total - numOfNonUniq) : (testWanUniqueness ? rand.nextInt(total - numOfNonUniq) : rand.nextInt(total));
        return whichOne;
    }

    protected int getAvailSize(ArrayList<Struct> result, int size, int[] offset) {
        int availSize = size;
        if (result == null) {
            return 0;
        }
        if (size >= result.size()) {
            availSize = result.size();
        } else {
            offset[0] = rand.nextInt(result.size() - size);
        }
        return availSize;
    }

    protected static boolean checkDerbyException(Connection conn, SQLException se) {
        if (se.getSQLState().equals("40001")) {
            Log.getLogWriter().info("detected the deadlock, will try it again");
            return false;
        }
        if (se.getSQLState().equals("40XL1")) {
            Log.getLogWriter().info("detected could not obtain lock, will try it again");
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                SQLHelper.handleSQLException(e);
            }
            return false;
        }
        return true;
    }

    public static int getCid(Connection conn) {
        int cid = 0;
        cid = testUniqueKeys ? AbstractDMLStmt.getCidFromQuery(conn) : (testWanUniqueness ? AbstractDMLStmt.getCidFromQuery(conn) : AbstractDMLStmt.getRandomCid(conn));
        return cid;
    }

    private static int getRandomCid(Connection conn) {
        if (rand.nextBoolean()) {
            return AbstractDMLStmt.getCid();
        }
        int tid = AbstractDMLStmt.getMyTid();
        return AbstractDMLStmt.getCidFromQuery(conn, tid == 0 ? ++tid : --tid);
    }

    public static int getCidFromQuery(Connection regConn) {
        return AbstractDMLStmt.getCidFromQuery(regConn, AbstractDMLStmt.getMyTid());
    }

    public static int getCidFromQuery(Connection regConn, int tid) {
        int maxNumOfTries;
        Connection conn = AbstractDMLStmt.getAuthConn(regConn);
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
        Log.getLogWriter().info(database + "get cid from query");
        int cid = 0;
        boolean[] success = new boolean[1];
        int whichQuery = 0;
        ResultSet rs = TradeCustomersDMLStmt.getQuery(conn, whichQuery, 0, null, tid);
        if (rs == null) {
            success[0] = false;
        } else {
            cid = AbstractDMLStmt.getCid(rs, success, conn);
        }
        int count = 0;
        int n = setCriticalHeap ? 0 : (maxNumOfTries = SQLHelper.isDerbyConn(conn) ? 1 : 3);
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info(database + "Could not get the cid, use cid as 0 instead");
                return cid;
            }
            rs = TradeCustomersDMLStmt.getQuery(conn, whichQuery, 0, null, tid);
            if (rs == null) {
                success[0] = false;
            } else {
                cid = AbstractDMLStmt.getCid(rs, success, conn);
            }
            if (cid == -1) {
                cid = 0;
                return cid;
            }
            ++count;
        }
        return cid;
    }

    public static long getNewTypeCidFromQuery(Connection regConn, String tableName, int tid) {
        int maxNumOfTries;
        Connection conn = AbstractDMLStmt.getAuthConn(regConn);
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
        Log.getLogWriter().info(database + "get cid from query");
        long cid = 0L;
        boolean[] success = new boolean[1];
        ResultSet rs = AbstractDMLStmt.getQueryResults(conn, tableName, tid);
        if (rs == null) {
            success[0] = false;
        } else {
            cid = AbstractDMLStmt.getNewTypeCid(rs, success, conn);
        }
        int count = 0;
        int n = setCriticalHeap ? 1 : (maxNumOfTries = SQLHelper.isDerbyConn(conn) ? 1 : 3);
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info(database + "Could not get the cid, use cid as 0 instead");
                return cid;
            }
            rs = AbstractDMLStmt.getQueryResults(conn, tableName, tid);
            if (rs == null) {
                success[0] = false;
            } else {
                cid = AbstractDMLStmt.getNewTypeCid(rs, success, conn);
            }
            if (cid == -1L) {
                cid = 0L;
                return cid;
            }
            ++count;
        }
        return cid;
    }

    private static ResultSet getQueryResults(Connection conn, String tableName, int tid) {
        String sql = "select * from trade." + tableName;
        Log.getLogWriter().info(sql);
        ResultSet rs = null;
        try {
            rs = conn.createStatement().executeQuery(sql);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se) || !SQLHelper.checkGFXDException(conn, se)) {
                return rs;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected static Connection getAuthConn(Connection regConn) {
        if (testSecurity) {
            Connection conn = SQLHelper.isDerbyConn(regConn) ? (Connection)SQLSecurityTest.derbySuperUserConn.get() : (SQLSecurityTest.bootedAsSuperUser ? (Connection)SQLSecurityTest.gfxdSuperUserConn.get() : (Connection)SQLSecurityTest.gfxdSystemUserConn.get());
            return conn;
        }
        return regConn;
    }

    protected boolean trackCids(Connection conn) {
        int whichQuery = 0;
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
        ResultSet rs = TradeCustomersDMLStmt.getQuery(conn, whichQuery, 0, null, AbstractDMLStmt.getMyTid());
        if (rs == null) {
            Log.getLogWriter().info(database + "Not able to get results set from derby for thread " + AbstractDMLStmt.getMyTid());
            return false;
        }
        ArrayList rl = (ArrayList)ResultSetHelper.getCidsAsList(conn, rs);
        if (rl == null) {
            Log.getLogWriter().info(database + "Not able to put cids by this thread " + AbstractDMLStmt.getMyTid() + "need to analyze the log.");
            return false;
        }
        cidsByThread.put(new Integer(AbstractDMLStmt.getMyTid()), rl);
        return true;
    }

    private static int getCid(ResultSet rs, boolean[] success, Connection conn) {
        int cid = 0;
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
        Log.getLogWriter().info(database + "processing resultset");
        List<Struct> customers = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
        if (customers != null) {
            Log.getLogWriter().info(database + "customer size is " + customers.size());
            success[0] = true;
            cid = customers.size() > 0 ? (Integer)customers.get(rand.nextInt(customers.size())).get("CID") : 0;
        } else {
            success[0] = false;
        }
        return cid;
    }

    protected static long getNewTypeCid(ResultSet rs, boolean[] success, Connection conn) {
        long cid = 0L;
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
        Log.getLogWriter().info(database + "processing resultset");
        List<Struct> customers = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
        if (customers != null) {
            Log.getLogWriter().info(database + "customer size is " + customers.size());
            success[0] = true;
            cid = customers.size() > 0 ? (Long)customers.get(rand.nextInt(customers.size())).get("CID") : 0L;
        } else {
            success[0] = false;
        }
        return cid;
    }

    public static int getCid() {
        return rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary)) + 1;
    }

    public static int getExistingCid() {
        int newCids;
        int maxCid = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary);
        int n = newCids = 10 * numOfThreads > 100 ? 10 * numOfThreads : 100;
        if (maxCid > newCids) {
            return rand.nextInt(maxCid - newCids) + 1;
        }
        throw new TestException("test issue, not enough cid in the tests yet");
    }

    public static int getExistingSid() {
        int newSids;
        int maxSid = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary);
        int n = newSids = 10 * numOfThreads > 100 ? 10 * numOfThreads : 100;
        if (maxSid > newSids) {
            return rand.nextInt(maxSid - newSids) + 1;
        }
        throw new TestException("test issue, not enough sid in the tests yet");
    }

    protected void getCids(Connection regConn, int[] cids) {
        Connection conn = AbstractDMLStmt.getAuthConn(regConn);
        int cid = 0;
        int size = cids.length;
        if (testUniqueKeys || testWanUniqueness) {
            ResultSet rs = null;
            int whichQuery = 0;
            try {
                rs = TradeCustomersDMLStmt.getQuery(conn, whichQuery, 0, null, AbstractDMLStmt.getMyTid());
                int count = 0;
                while (rs == null) {
                    if (count >= 2) {
                        Log.getLogWriter().info("could not get the cids, cids will be 0");
                        for (int i = 0; i < size; ++i) {
                            cids[i] = cid;
                        }
                        return;
                    }
                    ++count;
                    rs = TradeCustomersDMLStmt.getQuery(conn, whichQuery, 0, null, AbstractDMLStmt.getMyTid());
                }
            }
            catch (TestException te) {
                if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureTestException(te)) {
                    Log.getLogWriter().info("got expected node failure exception, cids will be 0");
                }
                throw te;
            }
            if (rs == null) {
                return;
            }
            ArrayList rsList = (ArrayList)ResultSetHelper.asList(rs, ResultSetHelper.getStructType(rs), SQLHelper.isDerbyConn(conn));
            SQLHelper.closeResultSet(rs, conn);
            if (rsList == null) {
                return;
            }
            int rsSize = rsList.size();
            if (rsSize >= size) {
                int offset = rand.nextInt(rsSize - size + 1);
                for (int i = 0; i < size; ++i) {
                    cids[i] = (Integer)((GFXDStructImpl)rsList.get(i + offset)).get("CID");
                }
            } else {
                int i;
                for (i = 0; i < rsSize; ++i) {
                    cids[i] = (Integer)((GFXDStructImpl)rsList.get(i)).get("CID");
                }
                for (i = rsSize; i < size; ++i) {
                    cids[i] = cid;
                }
            }
        } else {
            for (int i = 0; i < size; ++i) {
                cids[i] = AbstractDMLStmt.getCid();
            }
        }
    }

    protected int getSid(Connection regConn) {
        int sid;
        block11: {
            Connection conn = AbstractDMLStmt.getAuthConn(regConn);
            sid = 0;
            int n = 0;
            if (testUniqueKeys || isSerial) {
                n = useGfxdConfig ? rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary) / numOfThreads) : rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary) / TestHelper.getNumThreads());
                String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
                try {
                    String s = "select sec_id from trade.securities where tid = " + (isSerial ? this.getRandomTid() : AbstractDMLStmt.getMyTid());
                    ResultSet rs = conn.createStatement().executeQuery(s);
                    Log.getLogWriter().info("executed " + s + " from " + database);
                    int temp = 0;
                    while (rs.next()) {
                        if (temp == 0 && rand.nextInt(1000) != 1) {
                            sid = rs.getInt("SEC_ID");
                        }
                        if (n == temp) {
                            sid = rs.getInt("SEC_ID");
                            Log.getLogWriter().info("sec_id to be returned is " + sid);
                            break;
                        }
                        ++temp;
                    }
                    rs.close();
                }
                catch (SQLException se) {
                    if (!SQLHelper.checkDerbyException(conn, se)) {
                        Log.getLogWriter().info("use sid as 0");
                        break block11;
                    }
                    if (se.getSQLState().equals("XN008")) {
                        Log.getLogWriter().info("Query processing has been terminated due to an error on the server");
                        break block11;
                    }
                    if (!SQLHelper.checkGFXDException(conn, se)) {
                        Log.getLogWriter().info("use sid as 0");
                        break block11;
                    }
                    if (gfxdtxHANotReady && isHATest && SQLHelper.gotTXNodeFailureException(se)) {
                        Log.getLogWriter().info("got node failure exception during Tx with HA support, will use sid as 0");
                        break block11;
                    }
                    SQLHelper.handleSQLException(se);
                }
            } else {
                sid = this.getSid();
            }
        }
        return sid;
    }

    protected int getSid() {
        return rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary)) + 1;
    }

    protected int getQty() {
        return rand.nextInt(this.initMaxQty);
    }

    protected int getQty(int initQty) {
        return rand.nextInt(initQty);
    }

    protected BigDecimal getPrice() {
        return new BigDecimal(Double.toString((double)(rand.nextInt(10000) + 1) * 0.01));
    }

    protected String getRandVarChar(int length) {
        int aVal = 97;
        int sp = 32;
        int chance = 10;
        int symbolLength = rand.nextInt(length) + 1;
        char[] charArray = new char[symbolLength];
        for (int j = 0; j < symbolLength; ++j) {
            charArray[j] = rand.nextInt(chance) == 1 ? (char)sp : (char)(rand.nextInt(26) + aVal);
        }
        String randChars = new String(charArray);
        return randChars;
    }

    public static Date getSince() {
        int month = rand.nextInt(12) + 1;
        int day = month != 2 ? rand.nextInt(30) + 1 : rand.nextInt(28) + 1;
        String monthStr = Integer.toString(month);
        String dayStr = Integer.toString(day);
        if (month < 10) {
            monthStr = '0' + monthStr;
        }
        if (day < 10) {
            dayStr = '0' + dayStr;
        }
        return Date.valueOf(Integer.toString(1998 + rand.nextInt(10)) + '-' + monthStr + '-' + dayStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEid(Connection conn) {
        int eid = 0;
        int maxNumOfTries = 1;
        boolean success = false;
        List<Struct> eids = null;
        if (testUniqueKeys || testWanUniqueness) {
            int count = 0;
            while (!success) {
                try {
                    ResultSet rs = conn.createStatement().executeQuery("select eid from emp.employees where tid = " + AbstractDMLStmt.getMyTid());
                    eids = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
                    success = true;
                }
                catch (SQLException se) {
                    if (!SQLHelper.checkDerbyException(conn, se)) {
                        success = false;
                        continue;
                    }
                    if (!SQLHelper.checkGFXDException(conn, se)) {
                        success = false;
                        continue;
                    }
                    SQLHelper.handleSQLException(se);
                }
                finally {
                    if (count++ < maxNumOfTries) continue;
                    success = true;
                }
            }
            eid = AbstractDMLStmt.process(eids);
        } else {
            eid = AbstractDMLStmt.getEid();
        }
        return eid;
    }

    public static int getEid() {
        return rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.empEmployeesPrimary)) + 1;
    }

    protected static int process(List<Struct> eids) {
        if (eids == null || eids.size() == 0) {
            return 0;
        }
        int n = rand.nextInt(eids.size());
        Struct aStruct = eids.get(n);
        return (Integer)aStruct.get("EID");
    }

    protected void rollback(Connection conn) {
        try {
            conn.rollback();
            String db = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            Log.getLogWriter().info(db + "rollback this operation ");
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void commit(Connection conn) {
        try {
            boolean[] getNodeFailure;
            boolean[] getCanceled;
            if (setCriticalHeap && (getCanceled = (boolean[])SQLTest.getCanceled.get())[0] && SQLHelper.isDerbyConn(conn)) {
                Log.getLogWriter().info("memory runs low in gfxd, rollback the corresponding derby ops");
                conn.rollback();
                return;
            }
            if (SQLTest.setTx && isHATest && (getNodeFailure = (boolean[])SQLTest.getNodeFailure.get()) != null && getNodeFailure[0] && SQLHelper.isDerbyConn(conn)) {
                Log.getLogWriter().info("got node failure exception in gfxd, rollback the corresponding derby ops");
                conn.rollback();
                return;
            }
            String name = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            Log.getLogWriter().info(name + "committing the ops");
            conn.commit();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se) && se.getSQLState().equalsIgnoreCase("08003")) {
                Log.getLogWriter().info("detected current connection is lost, possibly due to reade time out");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected boolean verifyConflict(HashMap<String, Integer> modifiedKeysByOp, HashMap<String, Integer> modifiedKeysByThisTx, SQLException gfxdse, boolean getsConflict) {
        SharedMap modifiedKeysByOtherTx = SQLTxBB.getBB().getSharedMap();
        SharedMap writeLockedKeysByRRTx = null;
        Map writeLockedKeysByOtherRR = null;
        SharedMap readLockedKeysByRRTx = null;
        Map readLockedKeysByOtherRR = null;
        int beforeSize = modifiedKeysByOtherTx.size();
        Log.getLogWriter().info("before the op, the tx bb map size is " + beforeSize);
        for (String key : modifiedKeysByThisTx.keySet()) {
            modifiedKeysByOp.remove(key);
        }
        if (modifiedKeysByOp.size() == 0) {
            if (!getsConflict) {
                Log.getLogWriter().info("this op does not have newly modified keys");
                return true;
            }
            throw new TestException("this op does not have newly modified keys, but got conflict exception\n" + (gfxdse == null ? "" : TestHelper.getStackTrace((Throwable)gfxdse)));
        }
        int mapSize = modifiedKeysByOp.size();
        Log.getLogWriter().info("new modified key map size is " + mapSize);
        HashMap<String, Integer> verifyMap = new HashMap<String, Integer>();
        verifyMap.putAll(modifiedKeysByOp);
        Map modifiedKeysByOthers = modifiedKeysByOtherTx.getMap();
        verifyMap.putAll(modifiedKeysByOthers);
        if (mixRR_RC) {
            writeLockedKeysByRRTx = SQLTxRRWriteBB.getBB().getSharedMap();
            beforeSize += writeLockedKeysByRRTx.size();
            writeLockedKeysByOtherRR = writeLockedKeysByRRTx.getMap();
            verifyMap.putAll(writeLockedKeysByOtherRR);
            readLockedKeysByRRTx = SQLTxRRReadBB.getBB().getSharedMap();
            beforeSize += readLockedKeysByRRTx.size();
            readLockedKeysByOtherRR = readLockedKeysByRRTx.getMap();
            verifyMap.putAll(readLockedKeysByOtherRR);
        }
        int afterSize = verifyMap.size();
        Log.getLogWriter().info("tx bb map size is " + afterSize);
        if (beforeSize + mapSize == afterSize) {
            Log.getLogWriter().info("there is no conflict");
            if (getsConflict) {
                throw new TestException("no conflict detected, but got conflict exception\n" + (gfxdse == null ? "" : TestHelper.getStackTrace((Throwable)gfxdse)));
            }
            if (gfxdse == null) {
                modifiedKeysByOtherTx.putAll(modifiedKeysByOp);
            }
            return true;
        }
        if (!getsConflict) {
            if (gfxdse != null && gfxdse.getSQLState().equals("23513")) {
                Log.getLogWriter().info("if we get check constraint here, but did not get conflict exception. this is OK -- continuing test");
                return true;
            }
            Log.getLogWriter().info("did not get expected conflict exception", (Throwable)gfxdse);
            this.logConflict(modifiedKeysByOp, modifiedKeysByOthers, writeLockedKeysByOtherRR, readLockedKeysByOtherRR);
        } else {
            Log.getLogWriter().info("got expected conflict by this op");
        }
        return false;
    }

    protected void logConflict(HashMap<String, Integer> modifiedKeys, Map modifiedKeysByOtherTx, Map writeLockedKeysByOtherRR, Map readLockedKeysByOtherRR) {
        StringBuffer str = new StringBuffer();
        str.append("This tx " + SQLDistTxTest.curTxId.get() + " has modified the following keys " + "which are modified by other tx:\n");
        for (String key : modifiedKeys.keySet()) {
            if (modifiedKeysByOtherTx.containsKey(key)) {
                str.append(key + " is already locked by txId: " + modifiedKeysByOtherTx.get(key) + "\n");
            }
            if (writeLockedKeysByOtherRR != null && writeLockedKeysByOtherRR.containsKey(key)) {
                str.append(key + " is already RR write locked by txId: " + modifiedKeysByOtherTx.get(key) + "\n");
            }
            if (readLockedKeysByOtherRR == null || !readLockedKeysByOtherRR.containsKey(key)) continue;
            str.append(key + " is already RR read locked by txId: " + modifiedKeysByOtherTx.get(key) + "\n");
        }
        throw new TestException("Did not get expected conflict exception: " + str.toString());
    }

    protected String logMissingConflict(HashMap<String, Integer> modifiedKeys, Map modifiedKeysByOtherTx) {
        StringBuffer str = new StringBuffer();
        str.append("This tx " + SQLDistTxTest.curTxId.get() + " has modified the following keys " + "which are modified by other tx:\n");
        for (String key : modifiedKeys.keySet()) {
            if (!modifiedKeysByOtherTx.containsKey(key)) continue;
            str.append(key + " is already locked by txId: " + modifiedKeysByOtherTx.get(key) + "\n");
        }
        Log.getLogWriter().info(str.toString());
        return str.toString();
    }

    protected void logMissingConflictThrowException(HashMap<String, Integer> modifiedKeys, Map modifiedKeysByOtherTx) {
        String str = this.logMissingConflict(modifiedKeys, modifiedKeysByOtherTx);
        throw new TestException("Did not get expected conflict exception: " + str);
    }

    protected boolean hasForeignKeyConflict(String key, int txId) {
        if (!batchingWithSecondaryData) {
            SharedMap modifiedKeysByRCTx = SQLTxBB.getBB().getSharedMap();
            SharedMap modifiedKeysByRRTx = SQLTxRRWriteBB.getBB().getSharedMap();
            Map modifiedKeysByAllTx = modifiedKeysByRCTx.getMap();
            modifiedKeysByAllTx.putAll(modifiedKeysByRRTx.getMap());
            Integer holdingTxId = (Integer)modifiedKeysByAllTx.get(key);
            if (holdingTxId == null || holdingTxId == txId) {
                return false;
            }
            Log.getLogWriter().info("the key " + key + " is being held by the txId: " + holdingTxId);
            return true;
        }
        SharedMap modifiedKeysByRCTx = SQLTxBatchingBB.getBB().getSharedMap();
        Map modifiedKeysByAllTx = modifiedKeysByRCTx.getMap();
        ArrayList holdingTxIds = (ArrayList)modifiedKeysByAllTx.get(key);
        if (holdingTxIds == null || holdingTxIds.size() == 1 && holdingTxIds.contains(txId)) {
            return false;
        }
        Log.getLogWriter().info("the key " + key + " is being held by the txId: " + holdingTxIds.toString());
        return true;
    }

    protected void getExistingSidFromSecurities(Connection conn, int[] sec_id) {
        if (testUniqueKeys) {
            for (int i = 0; i < sec_id.length; ++i) {
                sec_id[i] = this.getSid(conn);
            }
            return;
        }
        List<Struct> list = null;
        String sql = "select sec_id from trade.securities";
        try {
            ResultSet rs = conn.createStatement().executeQuery(sql);
            list = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (list == null || list.size() == 0) {
            sec_id[0] = 0;
            Log.getLogWriter().info("could not get valid sec_id, using 0 instead");
        } else {
            sec_id[0] = (Integer)list.get(rand.nextInt(list.size())).get("SEC_ID");
        }
    }

    protected void getExistingCidFromCustomers(Connection conn, int[] cid) {
        if (testUniqueKeys) {
            this.getCids(conn, cid);
            return;
        }
        List<Struct> list = null;
        String sql = "select cid from trade.customers";
        try {
            ResultSet rs = conn.createStatement().executeQuery(sql);
            list = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (list == null || list.size() == 0) {
            cid[0] = 0;
            Log.getLogWriter().info("could not get valid cid, using 0 instead");
        } else {
            cid[0] = (Integer)list.get(rand.nextInt(list.size())).get("CID");
        }
    }

    protected boolean verifyConflictForRR(HashMap<String, Integer> modifiedKeysByOp, HashMap<String, Integer> modifiedKeysByThisTx, SQLException gfxdse, boolean getsConflict) {
        SharedMap writeLockedKeysByRRTx = SQLTxRRWriteBB.getBB().getSharedMap();
        Map writeLockedKeysByOtherRR = null;
        SharedMap modifiedKeysByOtherRCTx = null;
        Map modifiedKeysByOtherRC = null;
        int beforeSize = writeLockedKeysByRRTx.size();
        Log.getLogWriter().info("before the op, the tx bb map size for RR write is " + beforeSize);
        for (String key : modifiedKeysByThisTx.keySet()) {
            modifiedKeysByOp.remove(key);
        }
        if (modifiedKeysByOp.size() == 0) {
            Log.getLogWriter().info("this op does not have newly modified keys");
            return true;
        }
        int mapSize = modifiedKeysByOp.size();
        Log.getLogWriter().info("newly modified key map size is " + mapSize);
        HashMap<String, Integer> verifyMap = new HashMap<String, Integer>();
        verifyMap.putAll(modifiedKeysByOp);
        writeLockedKeysByOtherRR = writeLockedKeysByRRTx.getMap();
        verifyMap.putAll(writeLockedKeysByOtherRR);
        if (mixRR_RC) {
            modifiedKeysByOtherRCTx = SQLTxBB.getBB().getSharedMap();
            beforeSize += modifiedKeysByOtherRCTx.size();
            modifiedKeysByOtherRC = modifiedKeysByOtherRCTx.getMap();
            verifyMap.putAll(modifiedKeysByOtherRC);
        }
        int afterSize = verifyMap.size();
        Log.getLogWriter().info("tx bb map size is " + afterSize);
        if (beforeSize + mapSize == afterSize) {
            Log.getLogWriter().info("there is no conflict");
            if (getsConflict) {
                throw new TestException("no conflict detected, but got conflict exception\n" + (gfxdse == null ? "" : TestHelper.getStackTrace((Throwable)gfxdse)));
            }
            if (gfxdse == null) {
                writeLockedKeysByRRTx.putAll(modifiedKeysByOp);
            }
            return true;
        }
        if (!getsConflict) {
            if (gfxdse != null && gfxdse.getSQLState().equals("23513")) {
                Log.getLogWriter().info("if we get check constraint here, but did not get conflict exception. this is OK -- continuing test");
                return true;
            }
            Log.getLogWriter().info("did not get expected conflict exception", (Throwable)gfxdse);
            this.logConflictForRR(modifiedKeysByOp, writeLockedKeysByOtherRR, modifiedKeysByOtherRC);
        } else {
            Log.getLogWriter().info("got expected conflict by this op");
        }
        return false;
    }

    protected void logConflictForRR(HashMap<String, Integer> modifiedKeys, Map writeLockedKeysByOtherRR, Map modifiedKeysByOtherRC) {
        StringBuffer str = new StringBuffer();
        str.append("This tx " + SQLDistTxTest.curTxId.get() + " has modified the following keys " + "which are modified by other tx:\n");
        for (String key : modifiedKeys.keySet()) {
            if (writeLockedKeysByOtherRR.containsKey(key)) {
                str.append(key + " is already locked by txId: " + writeLockedKeysByOtherRR.get(key) + "\n");
            }
            if (modifiedKeysByOtherRC == null || !modifiedKeysByOtherRC.containsKey(key)) continue;
            str.append(key + " is already RR write locked by txId: " + modifiedKeysByOtherRC.get(key) + "\n");
        }
        throw new TestException("Did not get expected conflict exception: " + str.toString());
    }

    protected void verifyConflictWithBatching(HashMap<String, Integer> modifiedKeysByOp, HashMap<String, Integer> modifiedKeysByThisTx, SQLException gfxdse, boolean hasSecondary, boolean getsConflict) {
        long startTime = System.currentTimeMillis();
        Log.getLogWriter().info("start time" + startTime);
        SharedMap modifiedKeysByOtherTx = SQLTxBatchingBB.getBB().getSharedMap();
        SharedMap writeLockedKeysByRRTx = null;
        Map writeLockedKeysByOtherRR = null;
        SharedMap readLockedKeysByRRTx = null;
        Map readLockedKeysByOtherRR = null;
        int beforeSize = modifiedKeysByOtherTx.size();
        Log.getLogWriter().info("before the op, the tx bb map size is " + beforeSize);
        for (String key : modifiedKeysByThisTx.keySet()) {
            modifiedKeysByOp.remove(key);
        }
        Log.getLogWriter().info("key loop takes " + (System.currentTimeMillis() - startTime));
        if (modifiedKeysByOp.size() == 0) {
            if (!getsConflict) {
                Log.getLogWriter().info("this op does not have newly modified keys");
                this.logTime(startTime);
                return;
            }
            if (this.expectBatchingConflict(modifiedKeysByOtherTx, modifiedKeysByThisTx)) {
                Log.getLogWriter().info("get expected conflict due to batching");
                this.logTime(startTime);
                return;
            }
            if (this.verifyBatchingFKConflict(modifiedKeysByOtherTx.getMap())) {
                Log.getLogWriter().info("get expected the conflict due to foreign key hold conflcit");
                this.logTime(startTime);
                return;
            }
            throw new TestException("this op does not have newly modified keys, but got conflict exception\n" + (gfxdse == null ? "" : TestHelper.getStackTrace((Throwable)gfxdse)));
        }
        int mapSize = modifiedKeysByOp.size();
        Log.getLogWriter().info("new modified key map size is " + mapSize);
        HashMap<String, Integer> verifyMap = new HashMap<String, Integer>();
        verifyMap.putAll(modifiedKeysByOp);
        Map modifiedKeysByOthers = modifiedKeysByOtherTx.getMap();
        verifyMap.putAll(modifiedKeysByOthers);
        if (mixRR_RC) {
            writeLockedKeysByRRTx = SQLTxRRWriteBB.getBB().getSharedMap();
            beforeSize += writeLockedKeysByRRTx.size();
            writeLockedKeysByOtherRR = writeLockedKeysByRRTx.getMap();
            verifyMap.putAll(writeLockedKeysByOtherRR);
            readLockedKeysByRRTx = SQLTxRRReadBB.getBB().getSharedMap();
            beforeSize += readLockedKeysByRRTx.size();
            readLockedKeysByOtherRR = readLockedKeysByRRTx.getMap();
            verifyMap.putAll(readLockedKeysByOtherRR);
        }
        int afterSize = verifyMap.size();
        Log.getLogWriter().info("tx bb map size is " + afterSize);
        if (beforeSize + mapSize == afterSize) {
            Log.getLogWriter().info("there is no conflict");
            if (getsConflict) {
                if (this.verifyBatchingFKConflict(modifiedKeysByOthers)) {
                    Log.getLogWriter().info("get expected the conflict due to foreign key hold conflcit");
                    return;
                }
                if (this.expectBatchingConflict(modifiedKeysByOtherTx, modifiedKeysByThisTx)) {
                    Log.getLogWriter().info("get expected conflict due to batching");
                    return;
                }
                throw new TestException("no conflict detected, but got conflict exception\n" + (gfxdse == null ? "" : TestHelper.getStackTrace((Throwable)gfxdse)));
            }
            if (gfxdse == null) {
                for (String key : modifiedKeysByOp.keySet()) {
                    ArrayList list = null;
                    if (modifiedKeysByOtherTx.containsKey((Object)key)) {
                        list = (ArrayList)modifiedKeysByOtherTx.get((Object)key);
                        if (list.size() != 0) {
                            Log.getLogWriter().info("for key: " + key + ", there are following other txId hold the" + " lock locally: " + list.toString());
                        }
                    } else {
                        list = new ArrayList();
                    }
                    Log.getLogWriter().info("this tx holds the following key " + key);
                    list.add(modifiedKeysByOp.get(key));
                    modifiedKeysByOtherTx.put((Object)key, (Object)list);
                }
            }
        } else if (!getsConflict) {
            if (gfxdse != null) {
                if (gfxdse.getSQLState().equals("23513") || gfxdse.getSQLState().equals("23505") || gfxdse.getSQLState().equals("23503")) {
                    Log.getLogWriter().info("if we get constraint violation here, but did not get conflict exception. this is OK -- as conflict exception may not be thrown due to batching");
                } else {
                    SQLHelper.handleSQLException(gfxdse);
                }
            } else {
                Log.getLogWriter().info("did not get expected conflict exception", (Throwable)gfxdse);
                for (String key : modifiedKeysByOp.keySet()) {
                    ArrayList list = null;
                    if (modifiedKeysByOtherTx.containsKey((Object)key)) {
                        list = (ArrayList)modifiedKeysByOtherTx.get((Object)key);
                        Log.getLogWriter().info("for key: " + key + ", there are following other txId hold the" + " lock locally: " + list.toString());
                        if (!hasSecondary && list.size() > 0) {
                            throw new TestException("does not detect conflict exception for a table without secondary data, the lock for the key:" + key + " was hold by following txIds " + list.toString());
                        }
                    } else {
                        list = new ArrayList();
                    }
                    list.add(modifiedKeysByOp.get(key));
                    modifiedKeysByOtherTx.put((Object)key, (Object)list);
                }
            }
        } else {
            Log.getLogWriter().info("got expected conflict by this op");
        }
        this.logTime(startTime);
    }

    protected void logTime(long startTime) {
        Log.getLogWriter().info("verification takes " + (System.currentTimeMillis() - startTime));
    }

    protected boolean expectBatchingConflict(SharedMap modifiedKeysByAllTx, HashMap<String, Integer> modifiedKeysByThisTx) {
        Integer myTxId = (Integer)SQLDistTxTest.curTxId.get();
        for (String key : modifiedKeysByThisTx.keySet()) {
            ArrayList txIdsForTheKey = (ArrayList)modifiedKeysByAllTx.get((Object)key);
            if (!txIdsForTheKey.contains(myTxId) || txIdsForTheKey.size() <= 1) continue;
            return true;
        }
        return false;
    }

    protected boolean verifyBatchingFKConflict(Map modifiedKeysByAllTx) {
        Integer myTxId = (Integer)SQLDistTxTest.curTxId.get();
        HashSet holdFKsByThisTx = (HashSet)SQLDistTxTest.foreignKeyHeldWithBatching.get();
        for (String key : holdFKsByThisTx) {
            ArrayList txIdsForTheKey = (ArrayList)modifiedKeysByAllTx.get(key);
            if (txIdsForTheKey == null || (txIdsForTheKey.contains(myTxId) || txIdsForTheKey.size() != 1) && txIdsForTheKey.size() <= 1) continue;
            Log.getLogWriter().info("could get conflict for foreign key " + key + " with txIds: " + txIdsForTheKey);
            return true;
        }
        SharedMap holdingFKTxIds = SQLTxBatchingFKBB.getBB().getSharedMap();
        HashSet holdParentKeyByThisTx = (HashSet)SQLDistTxTest.parentKeyHeldWithBatching.get();
        for (String key : holdParentKeyByThisTx) {
            HashSet txIds = (HashSet)holdingFKTxIds.get((Object)key);
            if (txIds == null || txIds.size() <= 1 && (txIds.size() != 1 || txIds.contains(myTxId))) continue;
            Log.getLogWriter().info("could get conflict for foreign key " + key + " with txIds: " + txIds);
            return true;
        }
        return false;
    }

    public Clob[] getClob(int size) {
        boolean isTicket47987Fixed = false;
        Clob[] profile = new Clob[size];
        int maxClobSize = 10000;
        int specialClobSize = 2000000;
        try {
            for (int i = 0; i < size; ++i) {
                char[] chars;
                if (rand.nextBoolean() || this.noNullClob) {
                    if (this.ticket46799fixed) {
                        char[] cArray = chars = rand.nextInt(10) != 0 ? this.getAsciiCharArray(rand.nextInt(maxClobSize) + 1) : this.getCharArray(rand.nextInt(maxClobSize) + 1);
                        if (rand.nextInt(100) == 1) {
                            Log.getLogWriter().info("clob length is " + specialClobSize);
                            chars = this.getCharArray(specialClobSize);
                        }
                        profile[i] = new SerialClob(chars);
                        continue;
                    }
                    if (rand.nextInt(200) == 1 && isTicket49338Fixed) {
                        Log.getLogWriter().info("clob length is " + specialClobSize);
                        profile[i] = new SerialClob(this.getRandVarChar(specialClobSize).toCharArray());
                        continue;
                    }
                    profile[i] = new SerialClob(this.getRandVarChar(rand.nextInt(maxClobSize) + 1).toCharArray());
                    continue;
                }
                if (rand.nextInt(10) != 0 || !isTicket47987Fixed) continue;
                chars = new char[]{};
                profile[i] = new SerialClob(chars);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return profile;
    }

    protected char[] getCharArray(int length) {
        int arrayLength = rand.nextInt(length) + 1;
        char[] charArray = new char[arrayLength];
        for (int j = 0; j < arrayLength; ++j) {
            charArray[j] = this.getValidChar();
        }
        return charArray;
    }

    protected char[] getAsciiCharArray(int length) {
        int arrayLength = rand.nextInt(length) + 1;
        char[] charArray = new char[arrayLength];
        for (int j = 0; j < arrayLength; ++j) {
            charArray[j] = (char)rand.nextInt(128);
        }
        return charArray;
    }

    protected byte[] getByteArray(int maxLength) {
        int arrayLength = rand.nextInt(maxLength) + 1;
        byte[] byteArray = new byte[arrayLength];
        for (int j = 0; j < arrayLength; ++j) {
            byteArray[j] = (byte)rand.nextInt(256);
        }
        return byteArray;
    }

    protected byte[] getMaxByteArray(int maxLength) {
        Log.getLogWriter().info("max length byte array has length: " + maxLength);
        int arrayLength = maxLength;
        byte[] byteArray = new byte[arrayLength];
        for (int j = 0; j < arrayLength; ++j) {
            byteArray[j] = (byte)rand.nextInt(256);
        }
        return byteArray;
    }

    protected String getStringFromClob(Clob profile) throws SQLException {
        String clob = null;
        if (profile != null) {
            if (profile.length() == 0L) {
                clob = "empty";
            } else {
                BufferedReader reader = new BufferedReader(profile.getCharacterStream());
                clob = ResultSetHelper.convertCharArrayToString(reader, (int)profile.length());
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new TestException("could not close the BufferedReader" + TestHelper.getStackTrace((Throwable)e));
                }
            }
        }
        return clob;
    }

    protected char getValidChar() {
        return (char)rand.nextInt(1319);
    }

    protected void checkTicket49605(Connection dConn, Connection gConn, String tableName) {
        try {
            String select = "select * from trade." + tableName + " where tid = " + AbstractDMLStmt.getMyTid();
            Log.getLogWriter().info("Checking ticket #49605 by table scan, derby executing query: " + select);
            ResultSet derbyrs = dConn.createStatement().executeQuery(select);
            Log.getLogWriter().info("Checking ticket #49605 by table scan, gfxd executing query: " + select);
            ResultSet gfxdrs = gConn.createStatement().executeQuery(select);
            ResultSetHelper.compareResultSets(derbyrs, gfxdrs);
            Log.getLogWriter().info("does not get result set mismatch -- comparison could be aborted, continue testing");
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void checkTicket49605(Connection dConn, Connection gConn, String tableName, int pk, int pk2, String symbol, String exchange) {
        try {
            String sql = null;
            if (tableName.contains("orders")) {
                sql = "select * from trade." + tableName + " where oid = " + pk;
            } else if (tableName.contains("customers") || tableName.contains("networth")) {
                sql = "select * from trade." + tableName + " where cid = " + pk;
            } else if (tableName.contains("portfolio")) {
                sql = "select * from trade." + tableName + " where cid = " + pk + " and sid = " + pk2;
            } else if (tableName.contains("companies")) {
                sql = "select * from trade." + tableName + " where symbol = '" + symbol + "' and exchange = '" + exchange + "'";
            } else if (tableName.contains("securities")) {
                sql = "select * from trade." + tableName + " where sec_id = " + pk;
            }
            ResultSet rs = gConn.createStatement().executeQuery(sql);
            Log.getLogWriter().info(sql);
            Log.getLogWriter().info("got results from get convertable: " + ResultSetHelper.listToString(ResultSetHelper.asList(rs, false)));
            String select = "select * from trade." + tableName + " where tid = " + AbstractDMLStmt.getMyTid();
            Log.getLogWriter().info("Checking ticket #49605 by table scan, derby executing query: " + select);
            ResultSet derbyrs = dConn.createStatement().executeQuery(select);
            Log.getLogWriter().info("Checking ticket #49605 by table scan, gfxd executing query: " + select);
            ResultSet gfxdrs = gConn.createStatement().executeQuery(select);
            ResultSetHelper.compareResultSets(derbyrs, gfxdrs);
            Log.getLogWriter().info("does not get result set mismatch -- comparison could be aborted, continue testing");
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void deleteRow(Connection dConn, Connection gConn, String tableName, int pk, int pk2, String symbol, String exchange) {
        try {
            String sql = null;
            if (tableName.contains("orders")) {
                sql = "delete from trade." + tableName + " where oid = " + pk;
            } else if (tableName.contains("customers") || tableName.contains("networth")) {
                sql = "delete from trade." + tableName + " where cid = " + pk;
            } else if (tableName.contains("portfolio")) {
                sql = "delete from trade." + tableName + " where cid = " + pk + " and sid = " + pk2;
            } else if (tableName.contains("companies")) {
                sql = "delete from trade." + tableName + "where symbol = '" + symbol + "' and exchange = '" + exchange + "'";
            } else if (tableName.contains("securities")) {
                sql = "delete from trade." + tableName + " where sec_id = " + pk;
            }
            int dcount = dConn.createStatement().executeUpdate(sql);
            Log.getLogWriter().info("derby executed " + sql);
            int gcount = gConn.createStatement().executeUpdate(sql);
            Log.getLogWriter().info("gfxd executed " + sql);
            if (dcount != gcount) {
                Log.getLogWriter().info("derby deleted row but gfxd does not");
                this.checkTicket49605(dConn, gConn, tableName, pk, pk2, symbol, exchange);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected boolean isCustomersPartitionedOnPKOrReplicate() {
        if (!this.testPartionBy) {
            return true;
        }
        ArrayList partitionKey = (ArrayList)partitionMap.get((Object)"customersPartition");
        return partitionKey.size() == 1 && partitionKey.contains("cid") || partitionKey.size() == 0;
    }

    protected boolean isSecuritiesPartitionedOnPKOrReplicate() {
        if (!this.testPartionBy) {
            return true;
        }
        ArrayList partitionKey = (ArrayList)partitionMap.get((Object)"securitiesPartition");
        return partitionKey.size() == 1 && partitionKey.contains("sec_id") || partitionKey.size() == 0;
    }

    protected void removeTxIdFromBatchingFKs(HashSet<String> fks) {
        Integer myTxId = (Integer)SQLDistTxTest.curTxId.get();
        SharedMap holdingFKTxIds = SQLTxBatchingFKBB.getBB().getSharedMap();
        for (String fk : fks) {
            HashSet txIds = (HashSet)holdingFKTxIds.get((Object)fk);
            Log.getLogWriter().info("holdingFKTxIds removed myTxId: " + myTxId + " for the this foreing key: " + fk);
            txIds.remove(myTxId);
            holdingFKTxIds.put((Object)fk, (Object)txIds);
        }
    }

    protected void cleanUpFKHolds() {
        HashSet fks = (HashSet)SQLDistTxTest.foreignKeyHeldWithBatching.get();
        this.removeTxIdFromBatchingFKs(fks);
        fks.clear();
        SQLDistTxTest.foreignKeyHeldWithBatching.set((Object)fks);
        HashSet parentKeys = (HashSet)SQLDistTxTest.parentKeyHeldWithBatching.get();
        parentKeys.clear();
        SQLDistTxTest.parentKeyHeldWithBatching.set((Object)parentKeys);
    }

    protected boolean verifyConflictNewTables(HashMap<String, Integer> modifiedKeysByOp, HashMap<String, Integer> modifiedKeysByThisTx, HashMap<String, Integer> holdNonDeleteBlockingKeysByOp, HashMap<String, Integer> holdNonDeleteBlockingKeysByThisTx, HashMap<String, Integer> holdDeleteBlockingKeysByOp, HashMap<String, Integer> holdDeleteBlockingKeysByThisTx, HashMap<String, Integer> holdForeignKeysByOp, HashMap<String, ForeignKeyLocked> holdForeignKeysByThisTx, HashMap<String, Integer> holdNewForeignKeysByOp, HashMap<String, ForeignKeyLocked> holdNewForeignKeysByThisTx, SQLException gfxdse, boolean getsConflict) {
        SharedMap modifiedKeysByOtherTx = SQLTxBB.getBB().getSharedMap();
        SharedMap holdBlockingKeysByOtherTx = SQLTxHoldKeysBlockingChildBB.getBB().getSharedMap();
        SharedMap holdDeleteBlockingKeysByOtherTx = SQLTxDeleteHoldKeysBlockingChildBB.getBB().getSharedMap();
        SharedMap holdForeignKeysByOtherTx = SQLTxHoldForeignKeysBB.getBB().getSharedMap();
        SharedMap holdNewForeignKeysByOtherTx = SQLTxHoldNewForeignKeysBB.getBB().getSharedMap();
        if (getsConflict) {
            if (this.verifyModifiedKeysConflict(modifiedKeysByOp, modifiedKeysByThisTx, modifiedKeysByOtherTx, gfxdse, getsConflict)) {
                return true;
            }
            if (this.expectForeignKeysConflict(holdNonDeleteBlockingKeysByOp, holdNonDeleteBlockingKeysByThisTx, holdBlockingKeysByOtherTx, holdDeleteBlockingKeysByOp, holdDeleteBlockingKeysByThisTx, holdDeleteBlockingKeysByOtherTx, holdForeignKeysByOp, holdForeignKeysByThisTx, holdForeignKeysByOtherTx, holdNewForeignKeysByOp, holdNewForeignKeysByThisTx, holdNewForeignKeysByOtherTx, gfxdse, getsConflict)) {
                return true;
            }
            throw new TestException("Does not expect conflict exception but gets it." + TestHelper.getStackTrace((Throwable)gfxdse));
        }
        if (gfxdse != null && gfxdse.getSQLState().equals("23513")) {
            Log.getLogWriter().info("if we get check constraint here, but did not get conflict exception. this is OK -- continuing test");
            return true;
        }
        if (this.verifyModifiedKeysConflict(modifiedKeysByOp, modifiedKeysByThisTx, modifiedKeysByOtherTx, gfxdse, getsConflict)) {
            if (!this.expectForeignKeysConflict(holdNonDeleteBlockingKeysByOp, holdNonDeleteBlockingKeysByThisTx, holdBlockingKeysByOtherTx, holdDeleteBlockingKeysByOp, holdDeleteBlockingKeysByThisTx, holdDeleteBlockingKeysByOtherTx, holdForeignKeysByOp, holdForeignKeysByThisTx, holdForeignKeysByOtherTx, holdNewForeignKeysByOp, holdNewForeignKeysByThisTx, holdNewForeignKeysByOtherTx, gfxdse, getsConflict)) {
                this.addLockingKeysToBB(modifiedKeysByOp, modifiedKeysByThisTx, modifiedKeysByOtherTx, holdNonDeleteBlockingKeysByOp, holdNonDeleteBlockingKeysByThisTx, holdBlockingKeysByOtherTx, holdDeleteBlockingKeysByOp, holdDeleteBlockingKeysByThisTx, holdDeleteBlockingKeysByOtherTx, holdForeignKeysByOp, holdForeignKeysByThisTx, holdForeignKeysByOtherTx, holdNewForeignKeysByOp, holdNewForeignKeysByThisTx, holdNewForeignKeysByOtherTx);
                return true;
            }
            if (gfxdse == null) {
                throw new TestException("Expected conflict, but does not get it");
            }
            if (gfxdse.getSQLState().equalsIgnoreCase("23503")) {
                Log.getLogWriter().info("Got foreign key constraint violation 23503 instead of conflict exception, this is possible if delete deletes more than one rows and deleting some of rows could get 23503");
                return false;
            }
            Log.getLogWriter().warning("need to check if the exception is allowed here instead of conflict exception");
            throw new TestException("Expected conflict, but get other exception: " + TestHelper.getStackTrace((Throwable)gfxdse));
        }
        if (gfxdse == null) {
            throw new TestException("Expected conflict, but does not get it");
        }
        if (gfxdse.getSQLState().equalsIgnoreCase("23503")) {
            Log.getLogWriter().info("Got foreign key constraint violation 23503 instead of conflict exception, this is possible if delete deletes more than one rows and deleting some of rows could get 23503");
            return false;
        }
        throw new TestException("Expected conflict, but does not get it");
    }

    protected boolean verifyConflictNewTables(HashMap<String, Integer> modifiedKeysByOp, HashMap<String, Integer> holdNonDeleteBlockingKeysByOp, HashMap<String, Integer> holdDeleteBlockingKeysByOp, HashMap<String, Integer> holdForeignKeysByOp, HashMap<String, Integer> holdNewForeignKeysByOp, SQLException gfxdse, boolean getsConflict) {
        HashMap modifiedKeysByThisTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        HashMap holdNonDeleteKeysByThisTx = (HashMap)SQLDistTxTest.curTxNonDeleteHoldKeys.get();
        HashMap holdDeleteKeysByThisTx = (HashMap)SQLDistTxTest.curTxDeleteHoldKeys.get();
        HashMap holdForeignKeysByThisTx = (HashMap)SQLDistTxTest.curTxHoldParentKeys.get();
        HashMap holdNewForeignKeysByThisTx = (HashMap)SQLDistTxTest.curTxNewHoldParentKeys.get();
        SharedMap modifiedKeysByOtherTx = SQLTxBB.getBB().getSharedMap();
        SharedMap holdBlockingKeysByOtherTx = SQLTxHoldKeysBlockingChildBB.getBB().getSharedMap();
        SharedMap holdDeleteBlockingKeysByOtherTx = SQLTxDeleteHoldKeysBlockingChildBB.getBB().getSharedMap();
        SharedMap holdForeignKeysByOtherTx = SQLTxHoldForeignKeysBB.getBB().getSharedMap();
        SharedMap holdNewForeignKeysByOtherTx = SQLTxHoldNewForeignKeysBB.getBB().getSharedMap();
        if (getsConflict) {
            if (this.verifyModifiedKeysConflict(modifiedKeysByOp, modifiedKeysByThisTx, modifiedKeysByOtherTx, gfxdse, getsConflict)) {
                return true;
            }
            if (this.expectForeignKeysConflict(holdNonDeleteBlockingKeysByOp, holdNonDeleteKeysByThisTx, holdBlockingKeysByOtherTx, holdDeleteBlockingKeysByOp, holdDeleteKeysByThisTx, holdDeleteBlockingKeysByOtherTx, holdForeignKeysByOp, holdForeignKeysByThisTx, holdForeignKeysByOtherTx, holdNewForeignKeysByOp, holdNewForeignKeysByThisTx, holdNewForeignKeysByOtherTx, gfxdse, getsConflict)) {
                return true;
            }
            throw new TestException("Does not expect conflict exception but gets it." + TestHelper.getStackTrace((Throwable)gfxdse));
        }
        if (gfxdse != null && gfxdse.getSQLState().equals("23513")) {
            Log.getLogWriter().info("if we get check constraint here, but did not get conflict exception. this is OK -- continuing test");
            return true;
        }
        if (this.verifyModifiedKeysConflict(modifiedKeysByOp, modifiedKeysByThisTx, modifiedKeysByOtherTx, gfxdse, getsConflict)) {
            if (!this.expectForeignKeysConflict(holdNonDeleteBlockingKeysByOp, holdNonDeleteKeysByThisTx, holdBlockingKeysByOtherTx, holdDeleteBlockingKeysByOp, holdDeleteKeysByThisTx, holdDeleteBlockingKeysByOtherTx, holdForeignKeysByOp, holdForeignKeysByThisTx, holdForeignKeysByOtherTx, holdNewForeignKeysByOp, holdNewForeignKeysByThisTx, holdNewForeignKeysByOtherTx, gfxdse, getsConflict)) {
                this.addLockingKeysToBB(modifiedKeysByOp, modifiedKeysByThisTx, modifiedKeysByOtherTx, holdNonDeleteBlockingKeysByOp, holdNonDeleteKeysByThisTx, holdBlockingKeysByOtherTx, holdDeleteBlockingKeysByOp, holdDeleteKeysByThisTx, holdDeleteBlockingKeysByOtherTx, holdForeignKeysByOp, holdForeignKeysByThisTx, holdForeignKeysByOtherTx, holdNewForeignKeysByOp, holdNewForeignKeysByThisTx, holdNewForeignKeysByOtherTx);
                return true;
            }
            if (gfxdse == null) {
                throw new TestException("Expected conflict, but does not get it");
            }
            if (gfxdse.getSQLState().equalsIgnoreCase("23503")) {
                Log.getLogWriter().info("Got foreign key constraint violation 23503 instead of conflict exception, this is possible if delete deletes more than one rows and deleting some of rows could get 23503");
                return false;
            }
            Log.getLogWriter().warning("need to check if the exception is allowed here instead of conflict exception");
            throw new TestException("Expected conflict, but get other exception: " + TestHelper.getStackTrace((Throwable)gfxdse));
        }
        if (gfxdse == null) {
            throw new TestException("Expected conflict, but does not get it");
        }
        if (gfxdse.getSQLState().equalsIgnoreCase("23503")) {
            Log.getLogWriter().info("Got foreign key constraint violation 23503 instead of conflict exception, this is possible if delete deletes more than one rows and deleting some of rows could get 23503");
            return false;
        }
        throw new TestException("Expected conflict, but does not get it");
    }

    protected boolean verifyConflictNewTablesWithBatching(HashMap<String, Integer> modifiedKeysByOp, HashMap<String, Integer> holdNonDeleteBlockingKeysByOp, HashMap<String, Integer> holdDeleteBlockingKeysByOp, HashMap<String, Integer> holdForeignKeysByOp, HashMap<String, Integer> holdNewForeignKeysByOp, SQLException gfxdse, boolean getsConflict) {
        HashMap modifiedKeysByThisTx = (HashMap)SQLDistTxTest.curTxModifiedKeys.get();
        HashMap holdNonDeleteKeysByThisTx = (HashMap)SQLDistTxTest.curTxNonDeleteHoldKeys.get();
        HashMap holdDeleteKeysByThisTx = (HashMap)SQLDistTxTest.curTxDeleteHoldKeys.get();
        HashMap holdForeignKeysByThisTx = (HashMap)SQLDistTxTest.curTxHoldParentKeys.get();
        HashMap holdNewForeignKeysByThisTx = (HashMap)SQLDistTxTest.curTxNewHoldParentKeys.get();
        SharedMap modifiedKeysByOtherTx = SQLTxBatchingBB.getBB().getSharedMap();
        SharedMap holdBlockingKeysByOtherTx = SQLTxBatchingNonDeleteHoldKeysBB.getBB().getSharedMap();
        SharedMap holdDeleteBlockingKeysByOtherTx = SQLTxBatchingDeleteHoldKeysBB.getBB().getSharedMap();
        SharedMap holdForeignKeysByOtherTx = SQLTxHoldForeignKeysBB.getBB().getSharedMap();
        SharedMap holdNewForeignKeysByOtherTx = SQLTxHoldNewForeignKeysBB.getBB().getSharedMap();
        this.addLockingKeysToBatchingBB(modifiedKeysByOp, modifiedKeysByThisTx, modifiedKeysByOtherTx, holdNonDeleteBlockingKeysByOp, holdNonDeleteKeysByThisTx, holdBlockingKeysByOtherTx, holdDeleteBlockingKeysByOp, holdDeleteKeysByThisTx, holdDeleteBlockingKeysByOtherTx, holdForeignKeysByOp, holdForeignKeysByThisTx, holdForeignKeysByOtherTx, holdNewForeignKeysByOp, holdNewForeignKeysByThisTx, holdNewForeignKeysByOtherTx);
        if (getsConflict) {
            if (this.expectModifiedKeysConflictWithBatching(modifiedKeysByOp, modifiedKeysByThisTx, modifiedKeysByOtherTx, gfxdse, getsConflict)) {
                return true;
            }
            if (this.expectForeignKeysConflictWithBatching(holdNonDeleteBlockingKeysByOp, holdNonDeleteKeysByThisTx, holdBlockingKeysByOtherTx, holdDeleteBlockingKeysByOp, holdDeleteKeysByThisTx, holdDeleteBlockingKeysByOtherTx, holdForeignKeysByOp, holdForeignKeysByThisTx, holdForeignKeysByOtherTx, holdNewForeignKeysByOp, holdNewForeignKeysByThisTx, holdNewForeignKeysByOtherTx, gfxdse, getsConflict)) {
                return true;
            }
            throw new TestException("Does not expect conflict exception but gets it." + TestHelper.getStackTrace((Throwable)gfxdse));
        }
        return true;
    }

    protected void addLockingKeysToBB(HashMap<String, Integer> modifiedKeysByOp, HashMap<String, Integer> modifiedKeysByThisTx, SharedMap modifiedKeysByOtherTx, HashMap<String, Integer> holdNonDeleteKeysByOp, HashMap<String, Integer> holdNonDeleteKeysByThisTx, SharedMap holdNonDeleteKeysByOtherTx, HashMap<String, Integer> holdDeleteKeysByOp, HashMap<String, Integer> holdDeleteKeysByThisTx, SharedMap holdDeleteKeysByOtherTx, HashMap<String, Integer> holdForeignKeysByOp, HashMap<String, ForeignKeyLocked> holdForeignKeysByThisTx, SharedMap holdForeignKeysByOtherTx, HashMap<String, Integer> holdNewForeignKeysByOp, HashMap<String, ForeignKeyLocked> holdNewForeignKeysByThisTx, SharedMap holdNewForeignKeysByOtherTx) {
        ForeignKeyLocked fkLockedByOtherTx;
        ForeignKeyLocked fkLockedByTx;
        if (modifiedKeysByOp != null) {
            modifiedKeysByThisTx.putAll(modifiedKeysByOp);
            modifiedKeysByOtherTx.putAll(modifiedKeysByOp);
        }
        if (holdNonDeleteKeysByOp != null) {
            holdNonDeleteKeysByThisTx.putAll(holdNonDeleteKeysByOp);
            holdNonDeleteKeysByOtherTx.putAll(holdNonDeleteKeysByOp);
        }
        if (holdDeleteKeysByOp != null) {
            holdDeleteKeysByThisTx.putAll(holdDeleteKeysByOp);
            holdDeleteKeysByOtherTx.putAll(holdDeleteKeysByOp);
        }
        if (holdForeignKeysByOp != null) {
            for (String key : holdForeignKeysByOp.keySet()) {
                fkLockedByTx = holdForeignKeysByThisTx.get(key);
                if (fkLockedByTx == null) {
                    fkLockedByTx = new ForeignKeyLocked(key);
                }
                Log.getLogWriter().info("Adding exsiting fk locked in current txn");
                fkLockedByTx.addKeyByCurTx(holdForeignKeysByOp.get(key));
                holdForeignKeysByThisTx.put(key, fkLockedByTx);
                fkLockedByOtherTx = (ForeignKeyLocked)holdForeignKeysByOtherTx.get((Object)key);
                if (fkLockedByOtherTx == null) {
                    fkLockedByOtherTx = new ForeignKeyLocked(key);
                }
                Log.getLogWriter().info("Adding exsiting fk locked in current txn");
                fkLockedByOtherTx.addKeyByCurTx(holdForeignKeysByOp.get(key));
                holdForeignKeysByOtherTx.put((Object)key, (Object)fkLockedByOtherTx);
            }
        }
        if (holdNewForeignKeysByOp != null) {
            for (String key : holdNewForeignKeysByOp.keySet()) {
                fkLockedByTx = holdNewForeignKeysByThisTx.get(key);
                if (fkLockedByTx == null) {
                    fkLockedByTx = new ForeignKeyLocked(key);
                }
                Log.getLogWriter().info("Adding new fk locked in current txn");
                fkLockedByTx.addKeyByCurTx(holdNewForeignKeysByOp.get(key));
                holdNewForeignKeysByThisTx.put(key, fkLockedByTx);
                fkLockedByOtherTx = (ForeignKeyLocked)holdNewForeignKeysByOtherTx.get((Object)key);
                if (fkLockedByOtherTx == null) {
                    fkLockedByOtherTx = new ForeignKeyLocked(key);
                }
                Log.getLogWriter().info("Adding new fk locked in all txns");
                fkLockedByOtherTx.addKeyByCurTx(holdNewForeignKeysByOp.get(key));
                holdNewForeignKeysByOtherTx.put((Object)key, (Object)fkLockedByOtherTx);
            }
        }
        SQLDistTxTest.curTxModifiedKeys.set(modifiedKeysByThisTx);
        SQLDistTxTest.curTxNonDeleteHoldKeys.set(holdNonDeleteKeysByThisTx);
        SQLDistTxTest.curTxDeleteHoldKeys.set(holdDeleteKeysByThisTx);
        SQLDistTxTest.curTxHoldParentKeys.set(holdForeignKeysByThisTx);
        SQLDistTxTest.curTxNewHoldParentKeys.set(holdNewForeignKeysByThisTx);
    }

    protected void addLockingKeysToBatchingBB(HashMap<String, Integer> modifiedKeysByOp, HashMap<String, Integer> modifiedKeysByThisTx, SharedMap modifiedKeysByAllTx, HashMap<String, Integer> holdNonDeleteKeysByOp, HashMap<String, Integer> holdNonDeleteKeysByThisTx, SharedMap holdNonDeleteKeysByAllTx, HashMap<String, Integer> holdDeleteKeysByOp, HashMap<String, Integer> holdDeleteKeysByThisTx, SharedMap holdDeleteKeysByAllTx, HashMap<String, Integer> holdForeignKeysByOp, HashMap<String, ForeignKeyLocked> holdForeignKeysByThisTx, SharedMap holdForeignKeysByAllTx, HashMap<String, Integer> holdNewForeignKeysByOp, HashMap<String, ForeignKeyLocked> holdNewForeignKeysByThisTx, SharedMap holdNewForeignKeysByAllTx) {
        ForeignKeyLocked fkLockedByAllTx;
        ForeignKeyLocked fkLockedByTx;
        Integer myTxId;
        ArrayList list;
        if (modifiedKeysByOp != null) {
            modifiedKeysByThisTx.putAll(modifiedKeysByOp);
            for (String key : modifiedKeysByOp.keySet()) {
                list = null;
                if (modifiedKeysByAllTx.containsKey((Object)key)) {
                    list = (ArrayList)modifiedKeysByAllTx.get((Object)key);
                    if (list.size() != 0) {
                        Log.getLogWriter().info("for key: " + key + ", there are following other txId hold the" + " lock locally: " + list.toString());
                    }
                } else {
                    list = new ArrayList();
                }
                Log.getLogWriter().info("this tx holds the following key " + key);
                myTxId = modifiedKeysByOp.get(key);
                if (!list.contains(myTxId)) {
                    list.add(myTxId);
                }
                modifiedKeysByAllTx.put((Object)key, (Object)list);
            }
        }
        if (holdNonDeleteKeysByOp != null) {
            holdNonDeleteKeysByThisTx.putAll(holdNonDeleteKeysByOp);
            for (String key : holdNonDeleteKeysByOp.keySet()) {
                list = null;
                if (holdNonDeleteKeysByAllTx.containsKey((Object)key)) {
                    list = (ArrayList)holdNonDeleteKeysByAllTx.get((Object)key);
                    if (list.size() != 0) {
                        Log.getLogWriter().info("for key: " + key + ", there are following txId hold the" + " non delete key lock locally: " + list.toString());
                    }
                } else {
                    list = new ArrayList();
                }
                Log.getLogWriter().info("this tx holds the following non delete key " + key);
                myTxId = holdNonDeleteKeysByOp.get(key);
                if (!list.contains(myTxId)) {
                    list.add(myTxId);
                }
                holdNonDeleteKeysByAllTx.put((Object)key, (Object)list);
            }
        }
        if (holdDeleteKeysByOp != null) {
            holdDeleteKeysByThisTx.putAll(holdDeleteKeysByOp);
            for (String key : holdDeleteKeysByOp.keySet()) {
                list = null;
                if (holdDeleteKeysByAllTx.containsKey((Object)key)) {
                    list = (ArrayList)holdDeleteKeysByAllTx.get((Object)key);
                    if (list.size() != 0) {
                        Log.getLogWriter().info("for key: " + key + ", there are following txId hold the" + " delete key lock locally: " + list.toString());
                    }
                } else {
                    list = new ArrayList();
                }
                Log.getLogWriter().info("this tx holds the following delete key " + key);
                myTxId = holdDeleteKeysByOp.get(key);
                if (!list.contains(myTxId)) {
                    list.add(myTxId);
                }
                holdDeleteKeysByAllTx.put((Object)key, (Object)list);
            }
        }
        if (holdForeignKeysByOp != null) {
            for (String key : holdForeignKeysByOp.keySet()) {
                fkLockedByTx = holdForeignKeysByThisTx.get(key);
                if (fkLockedByTx == null) {
                    fkLockedByTx = new ForeignKeyLocked(key);
                }
                Log.getLogWriter().info("Adding exsiting fk locked in current txn");
                fkLockedByTx.addKeyByCurTx(holdForeignKeysByOp.get(key));
                holdForeignKeysByThisTx.put(key, fkLockedByTx);
                fkLockedByAllTx = (ForeignKeyLocked)holdForeignKeysByAllTx.get((Object)key);
                if (fkLockedByAllTx == null) {
                    fkLockedByAllTx = new ForeignKeyLocked(key);
                }
                Log.getLogWriter().info("Adding exsiting fk locked in current txn");
                fkLockedByAllTx.addKeyByCurTx(holdForeignKeysByOp.get(key));
                holdForeignKeysByAllTx.put((Object)key, (Object)fkLockedByAllTx);
            }
        }
        if (holdNewForeignKeysByOp != null) {
            for (String key : holdNewForeignKeysByOp.keySet()) {
                fkLockedByTx = holdNewForeignKeysByThisTx.get(key);
                if (fkLockedByTx == null) {
                    fkLockedByTx = new ForeignKeyLocked(key);
                }
                Log.getLogWriter().info("Adding new fk locked in current txn");
                fkLockedByTx.addKeyByCurTx(holdNewForeignKeysByOp.get(key));
                holdNewForeignKeysByThisTx.put(key, fkLockedByTx);
                fkLockedByAllTx = (ForeignKeyLocked)holdNewForeignKeysByAllTx.get((Object)key);
                if (fkLockedByAllTx == null) {
                    fkLockedByAllTx = new ForeignKeyLocked(key);
                }
                Log.getLogWriter().info("Adding new fk locked in all txns");
                fkLockedByAllTx.addKeyByCurTx(holdNewForeignKeysByOp.get(key));
                holdNewForeignKeysByAllTx.put((Object)key, (Object)fkLockedByAllTx);
            }
        }
        SQLDistTxTest.curTxModifiedKeys.set(modifiedKeysByThisTx);
        SQLDistTxTest.curTxNonDeleteHoldKeys.set(holdNonDeleteKeysByThisTx);
        SQLDistTxTest.curTxDeleteHoldKeys.set(holdDeleteKeysByThisTx);
        SQLDistTxTest.curTxHoldParentKeys.set(holdForeignKeysByThisTx);
        SQLDistTxTest.curTxNewHoldParentKeys.set(holdNewForeignKeysByThisTx);
    }

    protected boolean verifyModifiedKeysConflict(HashMap<String, Integer> modifiedKeysByOp, HashMap<String, Integer> modifiedKeysByThisTx, SharedMap modifiedKeysByOtherTx, SQLException gfxdse, boolean getsConflict) {
        int beforeSize = modifiedKeysByOtherTx.size();
        Log.getLogWriter().info("before the op, the tx bb map size is " + beforeSize);
        for (String key : modifiedKeysByThisTx.keySet()) {
            modifiedKeysByOp.remove(key);
        }
        if (modifiedKeysByOp.size() == 0) {
            if (!getsConflict) {
                Log.getLogWriter().info("this op does not have newly modified keys");
                return true;
            }
            Log.getLogWriter().info("there is no conflict detected based on modified keys");
            return false;
        }
        int mapSize = modifiedKeysByOp.size();
        Log.getLogWriter().info("newly modified key map size is " + mapSize);
        HashMap<String, Integer> verifyMap = new HashMap<String, Integer>();
        verifyMap.putAll(modifiedKeysByOp);
        Map modifiedKeysByOthers = modifiedKeysByOtherTx.getMap();
        verifyMap.putAll(modifiedKeysByOthers);
        int afterSize = verifyMap.size();
        Log.getLogWriter().info("tx bb map size is " + afterSize);
        if (beforeSize + mapSize == afterSize) {
            if (getsConflict) {
                Log.getLogWriter().info("No conflict detected due to row locks, need to check foreign key conflict");
                return false;
            }
            Log.getLogWriter().info("there is no conflict detected based on modified keys");
            return true;
        }
        if (getsConflict) {
            Log.getLogWriter().info("Gets expected conflict due to row locks.");
            return true;
        }
        if (gfxdse == null) {
            this.logMissingConflictThrowException(modifiedKeysByOp, modifiedKeysByOthers);
        } else {
            this.logMissingConflict(modifiedKeysByOp, modifiedKeysByOthers);
        }
        return false;
    }

    protected boolean expectModifiedKeysConflictWithBatching(HashMap<String, Integer> modifiedKeysByOp, HashMap<String, Integer> modifiedKeysByThisTx, SharedMap modifiedKeysByAllTx, SQLException gfxdse, boolean getsConflict) {
        if (modifiedKeysByThisTx != null) {
            for (String key : modifiedKeysByThisTx.keySet()) {
                ArrayList list = (ArrayList)modifiedKeysByAllTx.get((Object)key);
                if (list.size() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean expectForeignKeysConflictWithBatching(HashMap<String, Integer> holdBlockingKeysByOp, HashMap<String, Integer> holdBlockingKeysByThisTx, SharedMap holdBlockingKeysByAllTx, HashMap<String, Integer> holdDeleteBlockingKeysByOp, HashMap<String, Integer> holdDeleteBlockingKeysByThisTx, SharedMap holdDeleteBlockingKeysByAllTx, HashMap<String, Integer> holdForeignKeysByOp, HashMap<String, ForeignKeyLocked> holdForeignKeysByThisTx, SharedMap holdForeignKeysByAllTx, HashMap<String, Integer> holdNewForeignKeysByOp, HashMap<String, ForeignKeyLocked> holdNewForeignKeysByThisTx, SharedMap holdNewForeignKeysByAllTx, SQLException gfxdse, boolean getsConflict) {
        boolean getBlockingKeyConflict = false;
        boolean getDeleteBlockingKeyConflict = false;
        boolean getForeignKeyConflict = false;
        boolean getNewFkConflict = false;
        boolean getNewFkDeleteConflict = false;
        boolean getFkDeleteConflict = false;
        if (holdBlockingKeysByThisTx != null) {
            getBlockingKeyConflict = this.checkBlockingKeysWithBatching(holdBlockingKeysByThisTx, holdNewForeignKeysByAllTx);
        }
        if (holdDeleteBlockingKeysByThisTx != null) {
            getDeleteBlockingKeyConflict = this.checkDeleteBlockingKeysWithBatching(holdDeleteBlockingKeysByThisTx, holdForeignKeysByAllTx, holdNewForeignKeysByAllTx);
        }
        if (holdForeignKeysByThisTx != null) {
            getFkDeleteConflict = this.checkForeignKeysWithBatching(holdForeignKeysByThisTx, holdDeleteBlockingKeysByAllTx);
        }
        if (holdNewForeignKeysByThisTx != null) {
            getNewFkConflict = this.checkForeignKeysWithBatching(holdNewForeignKeysByThisTx, holdBlockingKeysByAllTx);
            getNewFkDeleteConflict = this.checkForeignKeysWithBatching(holdNewForeignKeysByThisTx, holdDeleteBlockingKeysByAllTx);
        }
        boolean bl = getForeignKeyConflict = getNewFkConflict || getNewFkDeleteConflict || getFkDeleteConflict;
        return getBlockingKeyConflict || getDeleteBlockingKeyConflict || getForeignKeyConflict;
    }

    protected boolean expectForeignKeysConflict(HashMap<String, Integer> holdBlockingKeysByOp, HashMap<String, Integer> holdBlockingKeysByThisTx, SharedMap holdBlockingKeysByOtherTx, HashMap<String, Integer> holdDeleteBlockingKeysByOp, HashMap<String, Integer> holdDeleteBlockingKeysByThisTx, SharedMap holdDeleteBlockingKeysByOtherTx, HashMap<String, Integer> holdForeignKeysByOp, HashMap<String, ForeignKeyLocked> holdParentKeysByThisTx, SharedMap holdForeignKeysByOtherTx, HashMap<String, Integer> holdNewForeignKeysByOp, HashMap<String, ForeignKeyLocked> holdNewParentKeysByThisTx, SharedMap holdNewForeignKeysByOtherTx, SQLException gfxdse, boolean getsConflict) {
        boolean getBlockingKeyConflict = false;
        boolean getForeignKeyConflict = false;
        boolean getNewFkConflict = false;
        boolean getNewFkDeleteConflict = false;
        boolean getFkDeleteConflict = false;
        if (holdBlockingKeysByOp == null || holdBlockingKeysByOp != null && holdBlockingKeysByOp.size() == 0) {
            if (holdDeleteBlockingKeysByOp == null || holdDeleteBlockingKeysByOp != null && holdDeleteBlockingKeysByOp.size() == 0) {
                Log.getLogWriter().info("this op does not have newly modified keys");
                getBlockingKeyConflict = false;
            } else {
                getBlockingKeyConflict = this.checkDeleteBlockingKeys(holdDeleteBlockingKeysByOp, holdForeignKeysByOtherTx, holdNewForeignKeysByOtherTx);
            }
        } else {
            getBlockingKeyConflict = this.checkBlockingKeys(holdBlockingKeysByOp, holdNewForeignKeysByOtherTx);
        }
        if (holdForeignKeysByOp == null && holdForeignKeysByOp != null && holdForeignKeysByOp.size() == 0) {
            Log.getLogWriter().info("this op does not hold exiting foreign keys in child tables");
            getForeignKeyConflict = false;
        } else {
            getFkDeleteConflict = this.checkForeignKeys(holdForeignKeysByOp, holdDeleteBlockingKeysByOtherTx);
            if (getFkDeleteConflict) {
                throw new TestException("delete op on parent should fail with 23503 or conflict exception, we should not see conflict during op on child");
            }
        }
        if (holdNewForeignKeysByOp == null && holdNewForeignKeysByOp != null && holdNewForeignKeysByOp.size() == 0) {
            Log.getLogWriter().info("this op does not hold new foreign keys in child tables");
            getForeignKeyConflict = false;
        } else {
            getNewFkConflict = this.checkForeignKeys(holdNewForeignKeysByOp, holdBlockingKeysByOtherTx);
            getNewFkDeleteConflict = this.checkForeignKeys(holdNewForeignKeysByOp, holdDeleteBlockingKeysByOtherTx);
        }
        boolean bl = getForeignKeyConflict = getNewFkConflict || getNewFkDeleteConflict || getFkDeleteConflict;
        return getBlockingKeyConflict || getForeignKeyConflict;
    }

    protected boolean checkBlockingKeys(HashMap<String, Integer> holdBlockingKeysByOp, SharedMap holdNewForeignKeysByOtherTx) {
        Set<String> keys = holdBlockingKeysByOp.keySet();
        for (String key : keys) {
            int txId = holdBlockingKeysByOp.get(key);
            ForeignKeyLocked fkLocked = (ForeignKeyLocked)holdNewForeignKeysByOtherTx.get((Object)key);
            if (fkLocked == null || !fkLocked.detectOtherTxIdConflict(txId)) continue;
            return true;
        }
        Log.getLogWriter().info("This op does not hold foreign keys causing conflict for existing child table ops");
        return false;
    }

    protected boolean checkBlockingKeysWithBatching(HashMap<String, Integer> holdBlockingKeysByThisTx, SharedMap holdNewForeignKeysByAllTx) {
        Set<String> keys = holdBlockingKeysByThisTx.keySet();
        for (String key : keys) {
            int txId = holdBlockingKeysByThisTx.get(key);
            ForeignKeyLocked fkLocked = (ForeignKeyLocked)holdNewForeignKeysByAllTx.get((Object)key);
            if (fkLocked == null || !fkLocked.detectOtherTxIdConflict(txId)) continue;
            return true;
        }
        Log.getLogWriter().info("This txn does not hold foreign keys causing conflict for existing child table ops");
        return false;
    }

    protected boolean checkDeleteBlockingKeys(HashMap<String, Integer> holdDeleteBlockingKeysByOp, SharedMap holdForeignKeysByAllTx, SharedMap holdNewForeignKeysByAllTx) {
        Set<String> keys = holdDeleteBlockingKeysByOp.keySet();
        for (String key : keys) {
            int txId = holdDeleteBlockingKeysByOp.get(key);
            ForeignKeyLocked fkLocked = (ForeignKeyLocked)holdForeignKeysByAllTx.get((Object)key);
            if (fkLocked != null && fkLocked.detectOtherTxIdConflict(txId)) {
                return true;
            }
            fkLocked = (ForeignKeyLocked)holdNewForeignKeysByAllTx.get((Object)key);
            if (fkLocked == null || !fkLocked.detectOtherTxIdConflict(txId)) continue;
            return true;
        }
        Log.getLogWriter().info("This op does not hold foreign keys causing conflict for existing child table ops");
        return false;
    }

    protected boolean checkDeleteBlockingKeysWithBatching(HashMap<String, Integer> holdDeleteBlockingKeysByThisTx, SharedMap holdForeignKeysByAllTx, SharedMap holdNewForeignKeysByAllTx) {
        Set<String> keys = holdDeleteBlockingKeysByThisTx.keySet();
        for (String key : keys) {
            int txId = holdDeleteBlockingKeysByThisTx.get(key);
            ForeignKeyLocked fkLocked = (ForeignKeyLocked)holdForeignKeysByAllTx.get((Object)key);
            if (fkLocked != null && fkLocked.detectOtherTxIdConflict(txId)) {
                return true;
            }
            fkLocked = (ForeignKeyLocked)holdNewForeignKeysByAllTx.get((Object)key);
            if (fkLocked == null || !fkLocked.detectOtherTxIdConflict(txId)) continue;
            return true;
        }
        Log.getLogWriter().info("This txn does not have delete op holding foreign keys causing conflict for existing child table ops");
        return false;
    }

    protected boolean checkForeignKeys(HashMap<String, Integer> holdForeignKeysByOp, SharedMap holdBlockingKeysByOtherTx) {
        if (holdForeignKeysByOp == null) {
            return false;
        }
        Set<String> keys = holdForeignKeysByOp.keySet();
        for (String key : keys) {
            int txId = holdForeignKeysByOp.get(key);
            Integer blockingTxId = (Integer)holdBlockingKeysByOtherTx.get((Object)key);
            if (blockingTxId == null || txId == blockingTxId) continue;
            Log.getLogWriter().info("Another txId: " + blockingTxId + " holds " + "the foreign key needs for op in this txn: " + txId);
            return true;
        }
        Log.getLogWriter().info("This op does not hold foreign keys causing conflict for existing parent table ops");
        return false;
    }

    protected boolean checkForeignKeysWithBatching(HashMap<String, ForeignKeyLocked> holdForeignKeysByThisTx, SharedMap holdBlockingKeysByAllTx) {
        if (holdForeignKeysByThisTx == null) {
            return false;
        }
        Set<String> keys = holdForeignKeysByThisTx.keySet();
        for (String key : keys) {
            ArrayList blockingTxIds;
            ForeignKeyLocked fks = holdForeignKeysByThisTx.get(key);
            Set<Integer> txIds = fks.getKeysHeldByTxIds().keySet();
            if (txIds.size() > 1) {
                throw new TestException("Test issue, current txn should only hold one txId. But it has follwing txIds " + txIds.toArray());
            }
            int myTxId = txIds.iterator().next();
            int holdTimes = fks.getKeysHeldByTxIds().get(myTxId);
            if (holdTimes <= 0 || (blockingTxIds = (ArrayList)holdBlockingKeysByAllTx.get((Object)key)) == null) continue;
            Iterator i$ = blockingTxIds.iterator();
            while (i$.hasNext()) {
                int txId = (Integer)i$.next();
                if (txId == myTxId) continue;
                Log.getLogWriter().info("Another txId: " + txId + " holds " + "the foreign key needs for op in this txn: " + myTxId);
                return true;
            }
        }
        Log.getLogWriter().info("This op does not hold foreign keys causing conflict for existing parent table ops");
        return false;
    }

    protected void resetCanceledFlag() {
        boolean[] getCanceled = (boolean[])SQLTest.getCanceled.get();
        if (getCanceled != null && getCanceled[0]) {
            getCanceled[0] = false;
            SQLTest.getCanceled.set((Object)getCanceled);
            Log.getLogWriter().info("getCanceled is reset for new ops");
        }
    }

    protected boolean getNodeFailureFlag() {
        boolean[] getNodeFailure = (boolean[])SQLTest.getNodeFailure.get();
        return getNodeFailure != null && getNodeFailure[0];
    }

    static {
        byCidRange = TestConfig.tab().booleanAt(SQLPrms.byCidRange, false);
        byTidList = TestConfig.tab().booleanAt(SQLPrms.byTidList, false);
        singleRowTx = TestConfig.tab().booleanAt(SQLPrms.singleRowTx, true);
        thisTxId = "thisTxId";
        cid_txId = "cid_txId_";
        cidRangeForTxOp = 5;
        isWanTest = TestConfig.tab().booleanAt(SQLWanPrms.isWanTest, false);
        testLoaderCreateRandomRow = TestConfig.tab().booleanAt(SQLPrms.testLoaderCreateRandomRow, false);
        useWriterForWriteThrough = TestConfig.tab().booleanAt(SQLPrms.useWriterForWriteThrough, false);
        retrySleepMs = 100;
        numOfThreads = TestConfig.tab().intAt(SQLPrms.numOfWorkers, 6);
        numGettingDataFromDerby = numOfThreads > 6 ? 20 : numOfThreads;
        useGfxdConfig = TestConfig.tab().booleanAt(SQLPrms.useGfxdConfig, false);
        testSecurity = SQLTest.testSecurity;
        isOfflineTest = TestConfig.tab().booleanAt(SQLPrms.isOfflineTest, false);
        useTimeout = SQLDistTxTest.useTimeout;
        mixRR_RC = SQLDistRRTxTest.mixRR_RC;
        setCriticalHeap = SQLTest.setCriticalHeap;
        nobatching = TestConfig.tab().booleanAt(SQLTxPrms.nobatching, true);
        batchingWithSecondaryData = !nobatching;
        testWanUniqueness = SQLTest.testWanUniqueness;
        hasCompanies = SQLTest.hasCompanies;
        failAtUpdateCount = SQLTest.failAtUpdateCount;
        alterTableDropColumn = SQLTest.alterTableDropColumn;
        digits = new short[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        gfxdtxHANotReady = true;
        isTicket48176Fixed = true;
        isTicket49338Fixed = false;
        allowUpdateOnPartitionColumn = TestConfig.tab().booleanAt(SQLPrms.allowUpdateOnPartitionColumn, false);
        dumpNoAggregateRs = new HydraThreadLocal();
        dumpQueryPlanRs = new HydraThreadLocal();
        hasHdfs = SQLTest.hasHdfs;
        ticket42672fixed = false;
        reproduce49935 = SQLDistRRTxTest.reproduce49935;
        useMD5Checksum = ResultSetHelper.useMD5Checksum;
        queryOpTimeNewTables = SQLDistTxTest.queryOpTimeNewTables;
        parentKeyHeldTxid = "parentKeyHeldTxid";
        isSingleHop = TestConfig.tab().booleanAt(SQLPrms.isSingleHop, false);
        hasTx = TestConfig.tab().booleanAt(SQLPrms.hasTx, false);
        boolean bl = testworkaroundFor51519 = TestConfig.tab().booleanAt(SQLPrms.testworkaroundFor51519, true) && !SQLTest.hasDerbyServer;
        if (SQLTest.isEdge) {
            lock = SQLBB.getBB().getSharedLock();
        } else {
            dls = AbstractDMLStmt.getLockService();
        }
    }
}

