/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements;

import hydra.Log;
import hydra.MasterController;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sql.SQLHelper;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class EmpDepartmentDMLStmt
extends AbstractDMLStmt {
    protected static String insert = "insert into emp.department values (?,?,?)";
    protected static String put = "put into emp.department values (?,?,?)";
    protected static String[] update = new String[0];
    protected static String[] select = new String[]{"select * from emp.department", "select * from emp.department where deptname = ? "};
    protected static String[] delete = new String[0];
    protected static String[] names = new String[]{"accounting", "finance", "admin", "HR", "sales", "marketing", "executive", "purchasing", "legal", "IT"};
    protected static int maxNumOfTries = 1;
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();
    protected static ArrayList<String> partitionKeys = null;

    @Override
    public void delete(Connection dConn, Connection gConn) {
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
    }

    @Override
    public void query(Connection dConn, Connection gConn) {
        int whichQuery = rand.nextInt(select.length);
        String name = names[rand.nextInt(names.length)];
        ResultSet discRS = null;
        ResultSet gfeRS = null;
        if (dConn != null) {
            discRS = EmpDepartmentDMLStmt.getQuery(dConn, whichQuery, name);
            if (discRS == null) {
                Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                return;
            }
            gfeRS = EmpDepartmentDMLStmt.getQuery(gConn, whichQuery, name);
            if (gfeRS == null) {
                if (isHATest) {
                    Log.getLogWriter().info("Testing HA and did not get GFXD result set after retry");
                    return;
                }
                throw new TestException("Not able to get GFXD result set and not a HA test");
            }
            boolean success = ResultSetHelper.compareResultSets(discRS, gfeRS);
            if (!success) {
                Log.getLogWriter().info("Not able to compare results in emp.department table");
            }
        } else {
            gfeRS = EmpDepartmentDMLStmt.getQuery(gConn, whichQuery, name);
            if (gfeRS != null) {
                ResultSetHelper.asList(gfeRS, false);
            } else if (isHATest) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
            } else {
                throw new TestException("gfxd query returns null and not a HA test");
            }
        }
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
    }

    @Override
    public void populate(Connection dConn, Connection gConn) {
        int size = names.length;
        this.populate(dConn, gConn, size);
    }

    @Override
    public void populate(Connection dConn, Connection gConn, int size) {
        this.insertDepartment(dConn, gConn, size);
    }

    private void insertDepartment(Connection dConn, Connection gConn, int size) {
        int[] did = new int[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        this.getDataForInsert(did);
        if (dConn != null) {
            if (SQLTest.setTx) {
                if (SQLTest.ddlThread != -1 && EmpDepartmentDMLStmt.getMyTid() == SQLTest.ddlThread) {
                    for (int i = 0; i < did.length; ++i) {
                        this.insertToDerbyTable(dConn, did[i], names[i], exceptionList);
                    }
                    this.insertToGFETable(gConn, did);
                    this.commit(gConn);
                    this.commit(dConn);
                    if (exceptionList.size() != 0) {
                        throw new TestException("insert into department table in derby failed");
                    }
                }
                return;
            }
            for (int i = 0; i < did.length; ++i) {
                boolean success = this.insertToDerbyTable(dConn, did[i], names[i], exceptionList);
                if (!success) continue;
                this.insertToGFETable(gConn, did[i], names[i], exceptionList);
                SQLHelper.handleMissedSQLException(exceptionList);
            }
            this.commit(gConn);
            this.commit(dConn);
        } else if (SQLTest.ddlThread != -1 && EmpDepartmentDMLStmt.getMyTid() == SQLTest.ddlThread) {
            this.insertToGFETable(gConn, did);
        }
    }

    protected boolean insertToDerbyTable(Connection conn, int did, String name, List<SQLException> exceptions) {
        PreparedStatement stmt = EmpDepartmentDMLStmt.getStmt(conn, insert);
        int tid = EmpDepartmentDMLStmt.getMyTid();
        int count = -1;
        try {
            verifyRowCount.put(tid + "_insert", 0);
            count = this.insertToTable(stmt, did, name, tid);
            verifyRowCount.put(tid + "_insert", new Integer(count));
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exceptions);
        }
        return true;
    }

    protected void insertToGFETable(Connection conn, int did, String name, List<SQLException> exceptions) {
        PreparedStatement stmt = EmpDepartmentDMLStmt.getStmt(conn, insert);
        int tid = EmpDepartmentDMLStmt.getMyTid();
        int count = -1;
        try {
            count = this.insertToTable(stmt, did, name, tid);
            if (count != verifyRowCount.get(tid + "_insert")) {
                Log.getLogWriter().info("Gfxd insert has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert") + " but gfxd inserted " + count);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exceptions);
        }
    }

    protected void insertToGFETable(Connection conn, int[] did) {
        PreparedStatement stmt = EmpDepartmentDMLStmt.getStmt(conn, insert);
        int tid = EmpDepartmentDMLStmt.getMyTid();
        for (int i = 0; i < did.length; ++i) {
            try {
                this.insertToTable(stmt, did[i], names[i], tid);
                continue;
            }
            catch (SQLException se) {
                if ("23505".equals(se.getSQLState())) {
                    Log.getLogWriter().info("Got the expected exception due to primary key constraint check");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, int did, String name, int tid, boolean isPut) throws SQLException {
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        Log.getLogWriter().info(database + (isPut ? "putting " : "inserting") + " into emp.department with DEPTID:" + did + ",DEPTNAME:" + name + ",TID:" + tid);
        stmt.setInt(1, did);
        stmt.setString(2, name);
        stmt.setInt(3, tid);
        int rowCount = stmt.executeUpdate();
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        Log.getLogWriter().info(database + (isPut ? "put " : "inserted") + rowCount + " rows in emp.department DEPTID:" + did + ",DEPTNAME:" + name + ",TID:" + tid);
        return rowCount;
    }

    protected int insertToTable(PreparedStatement stmt, int did, String name, int tid) throws SQLException {
        return this.insertToTable(stmt, did, name, tid, false);
    }

    private void getDataForInsert(int[] did) {
        int size = names.length;
        int i = 0;
        while (i < size) {
            did[i++] = i;
        }
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, String name) {
        boolean[] success = new boolean[1];
        ResultSet rs = EmpDepartmentDMLStmt.getQuery(conn, whichQuery, name, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = EmpDepartmentDMLStmt.getQuery(conn, whichQuery, name, success);
        }
        return rs;
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, String name, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        Log.getLogWriter().info("which query is -- " + select[whichQuery]);
        try {
            PreparedStatement stmt = conn.prepareStatement(select[whichQuery]);
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            String query = " QUERY: " + select[whichQuery];
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying emp.department with no data " + query);
                    break;
                }
                case 1: 
                case 2: {
                    Log.getLogWriter().info(database + "querying emp.department with DEPTNAME:" + name + query);
                    stmt.setString(1, name);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    @Override
    public void put(Connection dConn, Connection gConn, int size) {
    }
}

