/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements;

import hydra.Log;
import hydra.MasterController;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.rowset.serial.SerialBlob;
import sql.SQLBB;
import sql.SQLHelper;
import sql.dmlStatements.AbstractDMLStmt;
import sql.dmlStatements.EmpDepartmentDMLStmt;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class EmpEmployeesDMLStmt
extends AbstractDMLStmt {
    protected static String insert = "insert into emp.employees values (?,?,?,?,?,?,?,?)";
    protected static String put = "put into emp.employees values (?,?,?,?,?,?,?,?)";
    protected static String[] update = new String[]{"update emp.employees set deptno = ? where eid=? and tid = ? ", "update emp.employees set emp_name = ? , addr = ? where eid=? and tid =?", "update emp.employees set picture = ? , addr = ? where eid=? and tid =? ", "update emp.employees set picture = ?, since =? where eid=? and tid =? ", "update emp.employees set deptno = ? where eid=? ", "update emp.employees set emp_name = ? , addr = ? where eid=? ", "update emp.employees set picture = ? , addr = ? where eid=? ", "update emp.employees set picture = ?, since =? where eid=? "};
    protected static String[] select = new String[]{"select picture from emp.employees where tid = ?", "select eid, since, picture, emp_name from emp.employees where tid=? and eid >?", "select since, picture, addr, eid from emp.employees where (eid <=? or addr =?) and picture IS NOT NULL and tid = ?", "select max(eid) from emp.employees where (emp_name =? or since <?) and tid = ?", "select * from emp.employees where tid IN (?, ?) ", "select eid, since, picture, emp_name from emp.employees where eid >?", "select since, picture, addr, eid from emp.employees where (eid <=? or addr >?) and picture IS NOT NULL", "select max(eid) from emp.employees where (emp_name >? or since <?)"};
    protected static String[] delete = new String[]{"delete from emp.employees where (emp_name = ? or eid = ? ) and tid = ?", "delete from emp.employees where eid=? and tid=?", "delete from emp.employees where (emp_name = ? or eid = ? ) ", "delete from emp.employees where eid=? "};
    protected static int maxNumOfTries = 2;
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();
    protected static ArrayList<String> partitionKeys = null;
    private static final char[] numbers = new char[10];

    @Override
    public void delete(Connection dConn, Connection gConn) {
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        int[] eid = new int[size];
        String[] emp_name = new String[size];
        int[] deptid = new int[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        Blob[] picture = new Blob[size];
        String[] ssn = new String[size];
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        boolean success = false;
        this.getDataForInsert(eid, emp_name, since, addr, deptid, picture, ssn, size);
        if (dConn != null && !useWriterForWriteThrough) {
            try {
                success = this.insertToDerbyTable(dConn, eid, emp_name, deptid, since, addr, picture, ssn, size, exList);
                int count = 0;
                while (!success) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                        return;
                    }
                    MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                    exList.clear();
                    success = this.insertToDerbyTable(dConn, eid, emp_name, deptid, since, addr, picture, ssn, size, exList);
                    ++count;
                }
                this.insertToGFXDTable(gConn, eid, emp_name, deptid, since, addr, picture, ssn, size, exList);
                this.commit(dConn);
                this.commit(gConn);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                throw new TestException("insert to emp.employees fails\n" + TestHelper.getStackTrace((Throwable)se));
            }
        }
        try {
            this.insertToGFXDTable(gConn, eid, emp_name, deptid, since, addr, picture, ssn, size, false);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("insert to gfxd emp.emploees fails\n" + TestHelper.getStackTrace((Throwable)se));
        }
    }

    @Override
    public void query(Connection dConn, Connection gConn) {
        int numOfNonUniq = select.length / 2;
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        int eid = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.empEmployeesPrimary));
        Date since = EmpEmployeesDMLStmt.getSince();
        String addr = this.getAddress();
        String empName = this.getName();
        if (dConn != null) {
            ResultSet discRS = this.getQuery(dConn, whichQuery, eid, since, addr, empName);
            if (discRS == null) {
                Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                return;
            }
            ResultSet gfxdRS = this.getQuery(gConn, whichQuery, eid, since, addr, empName);
            if (gfxdRS == null) {
                if (isHATest) {
                    Log.getLogWriter().info("Testing HA and did not get GFXD result set");
                    return;
                }
                throw new TestException("Not able to get gfxd result set after retry");
            }
            boolean success = ResultSetHelper.compareResultSets(discRS, gfxdRS);
            if (!success) {
                Log.getLogWriter().info("Not able to compare results due to derby server error");
            }
        } else {
            ResultSet gfxdRS = this.getQuery(gConn, whichQuery, eid, since, addr, empName);
            if (gfxdRS != null) {
                ResultSetHelper.asList(gfxdRS, false);
            } else if (isHATest) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
            } else {
                throw new TestException("gfxd query returns null and not a HA test");
            }
        }
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
    }

    protected void getDataForInsert(int[] eid, String[] emp_name, Date[] since, String[] addr, int[] deptid, Blob[] picture, String[] ssn, int size) {
        int key = (int)SQLBB.getBB().getSharedCounters().add(SQLBB.empEmployeesPrimary, (long)size);
        int regBlobSize = 10000;
        int maxBlobSize = 2000000;
        try {
            for (int i = 0; i < size; ++i) {
                int counter;
                eid[i] = counter = key - i;
                emp_name[i] = this.getName();
                addr[i] = this.getAddress();
                since[i] = EmpEmployeesDMLStmt.getSince();
                deptid[i] = rand.nextInt(EmpDepartmentDMLStmt.names.length) + 1;
                if (rand.nextBoolean()) {
                    byte[] bytes = rand.nextInt(10) != 0 ? this.getByteArray(regBlobSize) : (rand.nextInt(100) == 0 ? this.getByteArray(maxBlobSize) : new byte[]{});
                    picture[i] = new SerialBlob(bytes);
                }
                ssn[i] = this.getSSN(9);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    private String getName() {
        int maxNameLength = 25;
        return this.getRandVarChar(rand.nextInt(maxNameLength) + 1);
    }

    private String getAddress() {
        int maxAddrLength = 55;
        return this.getRandVarChar(rand.nextInt(maxAddrLength) + 1);
    }

    private String getSSN(int length) {
        char[] ssn = new char[length];
        for (int i = 0; i < length; ++i) {
            ssn[i] = numbers[rand.nextInt(numbers.length)];
        }
        return new String(ssn);
    }

    protected boolean insertToDerbyTable(Connection conn, int[] eid, String[] emp_name, int[] deptid, Date[] since, String[] addr, Blob[] picture, String[] ssn, int size, List<SQLException> exceptions) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(insert);
        int tid = EmpEmployeesDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, eid[i], emp_name[i], deptid[i], since[i], addr[i], picture[i], ssn[i], tid, false);
                verifyRowCount.put(tid + "_insert" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected void insertToGFXDTable(Connection conn, int[] eid, String[] emp_name, int[] deptid, Date[] since, String[] addr, Blob[] picture, String[] ssn, int size, List<SQLException> exceptions) throws SQLException {
        this.insertToGFXDTable(conn, eid, emp_name, deptid, since, addr, picture, ssn, size, exceptions, false);
    }

    protected void insertToGFXDTable(Connection conn, int[] eid, String[] emp_name, int[] deptid, Date[] since, String[] addr, Blob[] picture, String[] ssn, int size, List<SQLException> exceptions, boolean isPut) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(isPut ? put : insert);
        int tid = EmpEmployeesDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, eid[i], emp_name[i], deptid[i], since[i], addr[i], picture[i], ssn[i], tid, isPut);
                if (count == verifyRowCount.get(tid + "_insert" + i)) continue;
                Log.getLogWriter().info("Gfxd insert has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + count);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void insertToGFXDTable(Connection conn, int[] eid, String[] emp_name, int[] deptid, Date[] since, String[] addr, Blob[] picture, String[] ssn, int size, boolean isPut) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(isPut ? put : insert);
        int tid = EmpEmployeesDMLStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, eid[i], emp_name[i], deptid[i], since[i], addr[i], picture[i], ssn[i], tid, isPut);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, int eid, String emp_name, int deptid, Date since, String addr, Blob picture, String ssn, int tid, boolean isPut) throws SQLException {
        String blob = null;
        if (picture != null) {
            blob = picture.length() == 0L ? "empty picture" : ResultSetHelper.convertByteArrayToString(picture.getBytes(1L, (int)picture.length()));
        }
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into emp.employees with EID:" + eid + ",EMPNAME:" + emp_name + ",DEPTID:" + deptid + ",SINCE:" + since + ",ADDR:" + addr + ",PICTURE:" + blob + ",SSN:" + ssn + ",TID:" + tid);
        stmt.setInt(1, eid);
        stmt.setString(2, emp_name);
        stmt.setInt(3, deptid);
        stmt.setDate(4, since);
        stmt.setString(5, addr);
        if (picture == null) {
            stmt.setNull(6, 2004);
        } else {
            stmt.setBlob(6, picture);
        }
        stmt.setString(7, ssn);
        stmt.setInt(8, tid);
        int rowCount = stmt.executeUpdate();
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows into emp.employees EID:" + eid + ",EMPNAME:" + emp_name + ",DEPTID:" + deptid + ",SINCE:" + since + ",ADDR:" + addr + ",PICTURE:" + blob + ",SSN:" + ssn + ",TID:" + tid);
        return rowCount;
    }

    public ResultSet getQuery(Connection conn, int whichQuery, int eid, Date since, String addr, String empName) {
        int tid = EmpEmployeesDMLStmt.getMyTid();
        int tid2 = tid == 0 ? tid + 1 : tid - 1;
        return EmpEmployeesDMLStmt.getQuery(conn, whichQuery, eid, since, addr, empName, tid, tid2);
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, int eid, Date since, String addr, String empName, int tid, int tid2) {
        boolean[] success = new boolean[1];
        ResultSet rs = EmpEmployeesDMLStmt.getQuery(conn, whichQuery, eid, since, addr, empName, tid, tid2, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                if (SQLHelper.isDerbyConn(conn)) {
                    Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                }
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = EmpEmployeesDMLStmt.getQuery(conn, whichQuery, eid, since, addr, empName, tid, tid2, success);
        }
        return rs;
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, int eid, Date since, String addr, String empName, int tid, int tid2, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            String query = " QUERY: " + select[whichQuery];
            PreparedStatement stmt = conn.prepareStatement(select[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying emp.employees with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying emp.employees with EID:" + eid + ",TID:" + tid + query);
                    stmt.setInt(1, tid);
                    stmt.setInt(2, eid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying emp.employees with EID:" + eid + ",ADDR:" + addr + ",TID:" + tid + query);
                    stmt.setInt(1, eid);
                    stmt.setString(2, addr);
                    stmt.setInt(3, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying emp.employees with EMPNAME:" + empName + ",SINCE:" + since + ",TID:" + tid + query);
                    stmt.setString(1, empName);
                    stmt.setDate(2, since);
                    stmt.setInt(3, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying emp.employees with TID:" + tid + ",2_TID:" + tid2 + query);
                    stmt.setInt(1, tid);
                    stmt.setInt(2, tid2);
                    break;
                }
                case 5: {
                    Log.getLogWriter().info(database + "querying emp.employees with EID:" + eid + query);
                    stmt.setInt(1, eid);
                    break;
                }
                case 6: {
                    Log.getLogWriter().info(database + "querying emp.employees with EID: " + eid + ",ADDR:" + addr + query);
                    stmt.setInt(1, eid);
                    stmt.setString(2, addr);
                    break;
                }
                case 7: {
                    Log.getLogWriter().info(database + "querying emp.employees with EMPNAME:" + empName + ",SINCE:" + since + query);
                    stmt.setString(1, empName);
                    stmt.setDate(2, since);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    @Override
    public void put(Connection dConn, Connection gConn, int size) {
        int[] eid = new int[size];
        String[] emp_name = new String[size];
        int[] deptid = new int[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        Blob[] picture = new Blob[size];
        String[] ssn = new String[size];
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        boolean success = false;
        this.getDataForInsert(eid, emp_name, since, addr, deptid, picture, ssn, size);
        if (dConn != null && !useWriterForWriteThrough) {
            try {
                success = this.insertToDerbyTable(dConn, eid, emp_name, deptid, since, addr, picture, ssn, size, exList);
                int count = 0;
                while (!success) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                        return;
                    }
                    MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                    exList.clear();
                    success = this.insertToDerbyTable(dConn, eid, emp_name, deptid, since, addr, picture, ssn, size, exList);
                    ++count;
                }
                this.insertToGFXDTable(gConn, eid, emp_name, deptid, since, addr, picture, ssn, size, exList, true);
                this.commit(dConn);
                this.commit(gConn);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                throw new TestException("insert to emp.employees fails\n" + TestHelper.getStackTrace((Throwable)se));
            }
        }
        try {
            this.insertToGFXDTable(gConn, eid, emp_name, deptid, since, addr, picture, ssn, size, true);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("put to gfxd emp.emploees fails\n" + TestHelper.getStackTrace((Throwable)se));
        }
    }

    static {
        for (int i = 0; i < 10; ++i) {
            EmpEmployeesDMLStmt.numbers[i] = (char)(48 + i);
        }
    }
}

