/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements;

import hydra.Log;
import hydra.MasterController;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlutil.GFXDStructImpl;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class TradeBuyOrdersDMLStmt
extends AbstractDMLStmt {
    protected static String insert = "insert into trade.buyorders values (?,?,?,?,?,?,?,?)";
    protected static String put = "put into trade.buyorders values (?,?,?,?,?,?,?,?)";
    protected static String[] update = new String[]{"update trade.buyorders set status = 'filled'  where sid = ? and bid>? and status = 'open' and tid = ? ", "update trade.buyorders set status = 'cancelled' where (ordertime >? or sid=?) and status = 'open' and tid =? ", "update trade.buyorders set bid = ? where cid = ? and sid= ? and status = 'open' and qty >? and tid =? ", "update trade.buyorders set bid = ? , qty=? where cid = ? and sid= ? and bid <? and status = 'open' and tid =? ", "update trade.buyorders set sid = ? where cid = ? and sid= ? and status = 'open' and tid =? ", "update trade.buyorders set status = 'filled'  where sid = ? and bid>? and status = 'open' ", "update trade.buyorders set status = 'cancelled' where (ordertime <? or sid=?) and status = 'open'  ", "update trade.buyorders set bid = ? where cid = ? and sid= ? and status = 'open' and qty >? ", "update trade.buyorders set bid = ? , qty=? where cid = ? and sid= ? and bid <? and status = 'open'  ", "update trade.buyorders set sid = ? where cid = ? and sid= ? and status = 'open'  "};
    protected static String[] select = new String[]{"select * from trade.buyorders where status = 'open' and tid = ?", "select cid, bid, cid, sid from trade.buyorders where cid >? and sid <? and qty >? and orderTime<? and tid = ?", "select sid, count(*) from trade.buyorders  where status =? and tid =? GROUP BY sid HAVING count(*) >=1", "select cid, min(qty*bid) as smallest_order from trade.buyorders  where status =? and tid =? GROUP BY cid", "select cid, cast (avg(qty*bid) as decimal (30, 20)) as amount from trade.buyorders  where status =? and tid =? GROUP BY cid ORDER BY amount", "select cid, max(qty*bid) as largest_order from trade.buyorders  where status =? and tid =?  GROUP BY cid HAVING max(qty*bid) > 2000 ORDER BY largest_order DESC, cid DESC ", "select b1.oid, b1.cid, b1.sid, b1.qty, b1.tid, b2.oid, b2.cid, b2.sid, b2.qty, b2.tid from trade.buyorders b1, trade.buyorders b2 where b1.cid = b2.cid and b1.tid = ? and b1.sid = b2.sid and b1.qty < b2.qty and b1.oid < b2.oid", "select * from trade.buyorders", "select cid, bid, cid, sid from trade.buyorders where cid >?  and sid <? and qty >? and orderTime<?  ", "select sid, count(*) from trade.buyorders  where status =? GROUP BY sid HAVING count(*) >=1", "select cid, count(distinct sid) from trade.buyorders  where status =? GROUP BY cid", "select cid, cast (avg(qty*bid) as decimal (30, 20)) as amount from trade.buyorders  where status =? GROUP BY cid ORDER BY amount", "select cid, max(qty*bid) as largest_order from trade.buyorders  where status =? GROUP BY cid HAVING max(qty*bid) > 20000 ORDER BY max(qty*bid), cid DESC ", "select b1.oid, b1.cid, b1.sid, b1.qty, b1.tid, b2.oid, b2.cid, b2.sid, b2.qty, b2.tid from trade.buyorders b1, trade.buyorders b2 where b1.cid = b2.cid and b1.sid = b2.sid and b1.qty < b2.qty and b1.oid < b2.oid"};
    protected static String[] selectwoaggreate = new String[]{"select * from trade.buyorders where status = 'open' and tid = ?", "select cid, bid, cid, sid from trade.buyorders where cid >? and sid <? and qty >? and orderTime<? and tid = ?", "select * from trade.buyorders  where status =? and tid =? order by sid", "select * from trade.buyorders  where status =? and tid =? order by cid", "select cid , (qty*bid) as totalAmt, count(*) as numRows from trade.buyorders  where status =? and tid =? order by cid, oid, sid", "select * from trade.buyorders  where status =? and tid =? order by cid", "select b1.oid, b1.cid, b1.sid, b1.qty, b1.tid, b2.oid, b2.cid, b2.sid, b2.qty, b2.tid from trade.buyorders b1, trade.buyorders b2 where b1.cid = b2.cid and b1.tid = ? and b1.sid = b2.sid and b1.qty < b2.qty and b1.oid < b2.oid", "select * from trade.buyorders", "select cid, bid, cid, sid from trade.buyorders where cid >?  and sid <? and qty >? and orderTime<?  ", "select sid, count(*) from trade.buyorders  where status =? GROUP BY sid HAVING count(*) >=1", "select cid,count(sid) from trade.buyorders  where status =? GROUP BY cid", "select cid, cast (avg(qty*bid) as decimal (30, 20)) as amount from trade.buyorders  where status =? GROUP BY cid ORDER BY amount", "select cid, max(qty*bid) as largest_order from trade.buyorders  where status =? GROUP BY cid HAVING max(qty*bid) > 20000 ORDER BY max(qty*bid), cid DESC ", "select b1.oid, b1.cid, b1.sid, b1.qty, b1.tid, b2.oid, b2.cid, b2.sid, b2.qty, b2.tid from trade.buyorders b1, trade.buyorders b2 where b1.cid = b2.cid and b1.sid = b2.sid and b1.qty < b2.qty and b1.oid < b2.oid"};
    protected static String[] delete = new String[]{"delete from trade.buyorders where cid=? and sid=? and tid=?", "delete from trade.buyorders where oid=? and (bid <? or qty>?) and tid=?", "delete from trade.buyorders where (status ='cancelled' or status = 'filled' or qty<?) and bid>? and tid=?", "delete from trade.buyorders where cid=? and sid=?", "delete from trade.buyorders where oid=? and (bid <? or qty>?) ", "delete from trade.buyorders where (status ='cancelled' or status = 'filled' or qty<?) and bid>?"};
    protected static String[] statuses = new String[]{"cancelled", "open", "filled"};
    protected static int maxNumOfTries = 1;
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();
    protected static ArrayList<String> partitionKeys = null;
    protected static boolean reproduce47943 = true;
    protected static boolean isTicket49116Fixed = true;

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        if (testLoaderCreateRandomRow) {
            this.insertThruLoader(gConn, size);
            return;
        }
        int[] cid = new int[size];
        if (gConn == null) {
            this.getCids(dConn, cid);
        } else if (dConn != null && rand.nextBoolean()) {
            this.getCids(dConn, cid);
        } else {
            this.getCids(gConn, cid);
        }
        if (hasHdfs) {
            for (int id : cid) {
                if (id != 0) continue;
                Log.getLogWriter().info("do not insert 0 for hdfs tests when fk was taken out due to #49452");
                return;
            }
        }
        this.insert(dConn, gConn, size, cid);
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
        int[] sid = new int[size];
        int[] newSid = new int[size];
        BigDecimal[] bid = new BigDecimal[size];
        Timestamp[] orderTime = new Timestamp[size];
        int[] cid = new int[size];
        int[] qty = new int[size];
        BigDecimal[] bid2 = new BigDecimal[size];
        int[] whichUpdate = new int[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            if (rand.nextInt(numGettingDataFromDerby) == 1) {
                if (!this.getDataForUpdate(dConn, cid, sid, newSid, qty, orderTime, bid, bid2, whichUpdate, size)) {
                    Log.getLogWriter().info("could not get the data for update, abort this operation");
                    return;
                }
            } else {
                this.getDataForUpdate(gConn, cid, sid, newSid, qty, orderTime, bid, bid2, whichUpdate, size);
            }
            if (hasHdfs) {
                for (int id : sid) {
                    if (id != 0) continue;
                    Log.getLogWriter().info("do not update 0 for hdfs tests when fk was taken out due to #49452");
                    return;
                }
            }
            if (setCriticalHeap) {
                this.resetCanceledFlag();
                if (!hasTx) {
                    return;
                }
            }
            boolean success = this.updateDerbyTable(dConn, cid, sid, newSid, qty, orderTime, bid, bid2, whichUpdate, size, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the update op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.updateDerbyTable(dConn, cid, sid, newSid, qty, orderTime, bid, bid2, whichUpdate, size, exceptionList);
            }
            this.updateGFETable(gConn, cid, sid, newSid, qty, orderTime, bid, bid2, whichUpdate, size, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.getDataForUpdate(gConn, cid, sid, newSid, qty, orderTime, bid, bid2, whichUpdate, size);
            this.updateGFETable(gConn, cid, sid, newSid, qty, orderTime, bid, bid2, whichUpdate, size);
        }
    }

    @Override
    public void delete(Connection dConn, Connection gConn) {
        int numOfNonUniqDelete = delete.length / 2;
        int whichDelete = this.getWhichOne(numOfNonUniqDelete, delete.length);
        if (SQLTest.syncHAForOfflineTest && whichDelete != 1) {
            whichDelete = 1;
        }
        int size = 1;
        int[] cid = new int[size];
        int[] sid = new int[size];
        int[] oid = new int[size];
        int[] qty = new int[size];
        BigDecimal[] bid = new BigDecimal[size];
        for (int i = 0; i < size; ++i) {
            oid[i] = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeBuyOrdersPrimary));
            qty[i] = this.getQty();
        }
        this.getBid(bid);
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        int availSize = dConn != null && rand.nextBoolean() ? this.getDataForDelete(dConn, cid, sid) : this.getDataForDelete(gConn, cid, sid);
        if (availSize == 0 || availSize == -1) {
            return;
        }
        if (setCriticalHeap) {
            this.resetCanceledFlag();
            if (!hasTx) {
                whichDelete = 1;
            }
        }
        if (dConn != null) {
            boolean success = this.deleteFromDerbyTable(dConn, whichDelete, cid, sid, oid, bid, qty, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the delete op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.deleteFromDerbyTable(dConn, whichDelete, cid, sid, oid, bid, qty, exceptionList);
            }
            this.deleteFromGFETable(gConn, whichDelete, cid, sid, oid, bid, qty, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.deleteFromGFETable(gConn, whichDelete, cid, sid, oid, bid, qty);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void query(Connection dConn, Connection gConn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void populate(Connection dConn, Connection gConn) {
        if (testLoaderCreateRandomRow) {
            this.insertThruLoader(gConn);
            return;
        }
        int initSize = rand.nextInt(10) + 1;
        for (int i = 0; i < initSize; ++i) {
            int j;
            int numCid = rand.nextInt(30);
            if (dConn != null && SQLTest.testPartitionBy && SQLTest.populateThruLoader) {
                for (j = 0; j < numCid; ++j) {
                    this.insert(dConn, null, 1);
                    this.commit(dConn);
                }
                continue;
            }
            for (j = 0; j < numCid; ++j) {
                if (setCriticalHeap) {
                    this.resetCanceledFlag();
                }
                this.insert(dConn, gConn, 1);
                if (dConn != null) {
                    this.commit(dConn);
                }
                this.commit(gConn);
            }
        }
    }

    protected void insertThruLoader(Connection gConn) {
        int size = rand.nextInt(300) + 1;
        this.insertThruLoader(gConn, size);
    }

    protected void insertThruLoader(Connection gConn, int size) {
        int startPoint;
        int key = (int)SQLBB.getBB().getSharedCounters().add(SQLBB.tradeBuyOrdersPrimary, (long)size);
        int n = startPoint = key == size ? 1 : key - size + 1;
        if (rand.nextBoolean()) {
            this.loadEachRow(gConn, key, startPoint);
        } else {
            this.loadMultiRows(gConn, key, startPoint);
        }
    }

    protected void loadEachRow(Connection gConn, int key, int startPoint) {
        try {
            String sql = "select * from trade.buyorders where oid = ?";
            PreparedStatement pStmt = gConn.prepareStatement(sql);
            for (int i = startPoint; i <= key; ++i) {
                Log.getLogWriter().info("gemfirexd - querying trade.buyorders with OID:" + i + " QUERY: " + sql);
                pStmt.setInt(1, i);
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) continue;
                throw new TestException("loader does not load the data for oid: " + i);
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23503")) {
                Log.getLogWriter().info("loader could not load the data due to #42171");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected void loadMultiRows(Connection gConn, int key, int startPoint) {
        block3: {
            String sql = "select * from trade.buyorders where oid IN (";
            for (int i = startPoint; i < key; ++i) {
                sql = sql + i + ", ";
            }
            sql = sql + key + ")";
            Log.getLogWriter().info("gemfirexd - querying trade.buyorders QUERY: " + sql);
            try {
                Statement stmt = gConn.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                ResultSetHelper.asList(rs, false);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23503")) break block3;
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public void insert(Connection dConn, Connection gConn, int size, int[] cids) {
        this.insert(dConn, gConn, size, cids, false);
    }

    public void insert(Connection dConn, Connection gConn, int size, int[] cids, boolean isPut) {
        int chance = 10;
        int maxSize = 10;
        boolean usebatch = false;
        if (!(cids[0] == 0 || rand.nextInt(chance) != 1 || dConn == null || alterTableDropColumn || testSecurity || setCriticalHeap)) {
            usebatch = true;
            size = rand.nextInt(maxSize) + 1;
        }
        if (SQLTest.syncHAForOfflineTest) {
            usebatch = false;
            size = 1;
        }
        int[] cid = new int[size];
        for (int i = 0; i < size; ++i) {
            cid[i] = cids[0];
        }
        int[] oid = new int[size];
        int[] sid = new int[size];
        int[] qty = new int[size];
        String status = "open";
        Timestamp[] time = new Timestamp[size];
        BigDecimal[] bid = new BigDecimal[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            boolean success;
            if (gConn == null || rand.nextInt(numGettingDataFromDerby) == 1) {
                this.getDataForInsert(dConn, oid, cid, sid, qty, time, bid, size);
            } else {
                this.getDataForInsert(gConn, oid, cid, sid, qty, time, bid, size);
            }
            if (hasHdfs) {
                for (int id : sid) {
                    if (id != 0) continue;
                    Log.getLogWriter().info("do not insert 0 for hdfs tests when fk was taken out due to #49452");
                    return;
                }
            }
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            if (usebatch) {
                for (int id : sid) {
                    if (id != 0) continue;
                    Log.getLogWriter().info("could not get enough valid sid for batching insert");
                    return;
                }
                success = this.insertToDerbyTableUsingBatch(dConn, oid, cid, sid, qty, status, time, bid, size, exceptionList);
            } else {
                success = this.insertToDerbyTable(dConn, oid, cid, sid, qty, status, time, bid, size, exceptionList);
            }
            if (!success) {
                Log.getLogWriter().info("Could not finish the op in derby, will abort this operation in derby");
                this.rollback(dConn);
                if (!alterTableDropColumn || SQLTest.alterTableException.get() == null || !((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                    return;
                }
            }
            if (gConn == null) {
                Log.getLogWriter().info("connection is null, must be a load test");
                return;
            }
            try {
                if (usebatch) {
                    this.insertToGfxdTableUsingBatch(gConn, oid, cid, sid, qty, status, time, bid, size, exceptionList, isPut);
                } else {
                    this.insertToGFETable(gConn, oid, cid, sid, qty, status, time, bid, size, exceptionList, isPut);
                }
            }
            catch (TestException te) {
                if (te.getMessage().contains("Execute SQL statement failed with: 23505") && isHATest && SQLTest.isEdge) {
                    try {
                        this.checkTicket49605(dConn, gConn, "buyorders");
                    }
                    catch (TestException e) {
                        Log.getLogWriter().info("insert failed due to #49605", (Throwable)e);
                        Log.getLogWriter().info("retry this using put to work around #49605");
                        if (usebatch) {
                            this.insertToGfxdTableUsingBatch(gConn, oid, cid, sid, qty, status, time, bid, size, exceptionList, true);
                        } else {
                            this.insertToGFETable(gConn, oid, cid, sid, qty, status, time, bid, size, exceptionList, true);
                        }
                        this.checkTicket49605(dConn, gConn, "buyorders");
                    }
                }
                throw te;
            }
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.getDataForInsert(gConn, oid, cid, sid, qty, time, bid, size);
            if (hasHdfs) {
                for (int id : sid) {
                    if (id != 0) continue;
                    Log.getLogWriter().info("do not insert 0 for hdfs tests when fk was taken out due to #49452");
                    return;
                }
            }
            this.insertToGFETable(gConn, oid, cid, sid, qty, status, time, bid, size, isPut);
        }
    }

    protected void getDataForInsert(Connection regConn, int[] oid, int[] cid, int[] sid, int[] qty, Timestamp[] time, BigDecimal[] bid, int size) {
        Connection conn = TradeBuyOrdersDMLStmt.getAuthConn(regConn);
        this.getOids(oid, size);
        for (int i = 0; i < size; ++i) {
            sid[i] = this.getSid(conn);
            qty[i] = this.getQty(this.initMaxQty / 2);
            time[i] = new Timestamp(System.currentTimeMillis());
            bid[i] = new BigDecimal(Double.toString((double)(rand.nextInt(10000) + 1) * 0.01));
        }
    }

    protected void getOids(int[] oid, int size) {
        int key = (int)SQLBB.getBB().getSharedCounters().add(SQLBB.tradeBuyOrdersPrimary, (long)size);
        for (int i = 0; i < size; ++i) {
            oid[i] = key - size + 1 + i;
        }
    }

    protected void insertToGFETable(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String status, Timestamp[] time, BigDecimal[] bid, int size, List<SQLException> exceptions, boolean isPut) {
        PreparedStatement stmt = TradeBuyOrdersDMLStmt.getStmt(conn, isPut ? put : insert);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, oid[i], cid[i], sid[i], qty[i], status, time[i], bid[i], tid, isPut);
                if (count == verifyRowCount.get(tid + "_insert" + i)) continue;
                String str = "Gfxd insert to buyorders has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void insertToGFETable(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String status, Timestamp[] time, BigDecimal[] bid, int size, boolean isPut) {
        PreparedStatement stmt = TradeBuyOrdersDMLStmt.getStmt(conn, isPut ? put : insert);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, oid[i], cid[i], sid[i], qty[i], status, time[i], bid[i], tid, isPut);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23503")) {
                    Log.getLogWriter().info("detected the foreign key constraint violation, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42802")) {
                    Log.getLogWriter().info("Got expected column not found exception in insert, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("23505") && isHATest && SQLTest.isEdge) {
                    Log.getLogWriter().info("detected pk constraint violation during insert -- relaxing due to #43571, continuing test");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, int oid, int cid, int sid, int qty, String status, Timestamp time, BigDecimal bid, int tid) throws SQLException {
        return this.insertToTable(stmt, oid, cid, sid, qty, status, time, bid, tid, false);
    }

    protected int insertToTable(PreparedStatement stmt, int oid, int cid, int sid, int qty, String status, Timestamp time, BigDecimal bid, int tid, boolean isPut) throws SQLException {
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd -  ";
        Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.buyorders with OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",STATUS:" + status + ",TIME:" + time + ",BID:" + bid + ",TID:" + tid);
        stmt.setInt(1, oid);
        stmt.setInt(2, cid);
        stmt.setInt(3, sid);
        stmt.setInt(4, qty);
        stmt.setBigDecimal(5, bid);
        if (testworkaroundFor51519) {
            stmt.setTimestamp(6, time, TradeBuyOrdersDMLStmt.getCal());
        } else {
            stmt.setTimestamp(6, time);
        }
        stmt.setString(7, status);
        stmt.setInt(8, tid);
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows in trade.buyorders with OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",STATUS:" + status + ",TIME:" + time + ",BID:" + bid + ",TID:" + tid);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        if (database.contains("gemfirexd") && isPut) {
            if (!SQLTest.ticket49794fixed) {
                this.insertToBuyordersFulldataset(stmt.getConnection(), oid, cid, sid, qty, bid, time, status, tid);
            }
            Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.buyorders with OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",STATUS:" + status + ",TIME:" + time + ",BID:" + bid + ",TID:" + tid);
            rowCount = stmt.executeUpdate();
            Log.getLogWriter().info(database + (isPut ? "put" : "inserted") + rowCount + " rows in trade.buyorders with OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",STATUS:" + status + ",TIME:" + time + ",BID:" + bid + ",TID:" + tid);
            warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        return rowCount;
    }

    protected void insertToBuyordersFulldataset(Connection conn, int oid, int cid, int sid, int qty, BigDecimal bid, Timestamp time, String status, int tid) {
        try {
            Log.getLogWriter().info(" Trigger behaviour is not defined for putDML hence deleting  the  row  from TRADE.BUYORDERS_FULLDATASET with data OID:" + oid);
            conn.createStatement().execute("DELETE FROM TRADE.BUYORDERS_FULLDATASET  WHERE OID:" + oid);
            PreparedStatement preparedInsertStmt = conn.prepareStatement("insert into trade.buyorders_fulldataset values (?,?,?,?,?,?,?,?)");
            preparedInsertStmt.setInt(1, oid);
            preparedInsertStmt.setInt(2, cid);
            preparedInsertStmt.setInt(3, sid);
            preparedInsertStmt.setInt(4, qty);
            preparedInsertStmt.setBigDecimal(5, bid);
            if (testworkaroundFor51519) {
                preparedInsertStmt.setTimestamp(6, time, TradeBuyOrdersDMLStmt.getCal());
            } else {
                preparedInsertStmt.setTimestamp(6, time);
            }
            preparedInsertStmt.setString(7, status);
            preparedInsertStmt.setInt(8, tid);
            Log.getLogWriter().info(" Trigger behaviour is not defined for putDML hence inserting  the  row  into TRADE.BUYORDERS_FULLDATASET OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",BID:" + bid + ",TID:" + tid);
            preparedInsertStmt.executeUpdate();
        }
        catch (SQLException se) {
            Log.getLogWriter().info("Error while updating TRADE.BUYORDES_FULLDATASET table. It may cause Data inconsistency " + se.getMessage());
        }
    }

    protected void addBatchInsert(PreparedStatement stmt, int oid, int cid, int sid, int qty, String status, Timestamp time, BigDecimal bid, int tid) throws SQLException {
        this.addBatchInsert(stmt, oid, cid, sid, qty, status, time, bid, tid, false);
    }

    protected void addBatchInsert(PreparedStatement stmt, int oid, int cid, int sid, int qty, String status, Timestamp time, BigDecimal bid, int tid, boolean isPut) throws SQLException {
        Log.getLogWriter().info((SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ") + (isPut ? "putting " : "inserting ") + " into trade.buyorders with data OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",STATUS:" + status + ",TIME:" + time + ",BID:" + bid + ",TID:" + tid);
        stmt.setInt(1, oid);
        stmt.setInt(2, cid);
        stmt.setInt(3, sid);
        stmt.setInt(4, qty);
        stmt.setBigDecimal(5, bid);
        if (testworkaroundFor51519) {
            stmt.setTimestamp(6, time, TradeBuyOrdersDMLStmt.getCal());
        } else {
            stmt.setTimestamp(6, time);
        }
        stmt.setString(7, status);
        stmt.setInt(8, tid);
        stmt.addBatch();
    }

    protected void insertToGfxdTableUsingBatch(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String status, Timestamp[] time, BigDecimal[] bid, int size, List<SQLException> exceptions, boolean isPut) {
        PreparedStatement stmt = TradeBuyOrdersDMLStmt.getStmt(conn, isPut ? put : insert);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        if (stmt == null) {
            throw new TestException("Does not expect stmt to be null, need to check logs to confirm this issue.");
        }
        int[] counts = null;
        for (int i = 0; i < size; ++i) {
            try {
                this.addBatchInsert(stmt, oid[i], cid[i], sid[i], qty[i], status, time[i], bid[i], tid, isPut);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
        try {
            counts = stmt.executeBatch();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            SQLHelper.handleGFGFXDException(se, exceptions);
        }
        if (counts == null) {
            if (setCriticalHeap) {
                boolean[] getCanceled = (boolean[])SQLTest.getCanceled.get();
                if (getCanceled != null && getCanceled[0]) {
                    Log.getLogWriter().info("insert batching into gfxd failed due to low memory exception");
                    return;
                }
                throw new TestException("Does not expect execute batch to fail, need to check logs.");
            }
            if (SQLTest.setTx && isHATest) {
                boolean[] getNodeFailure = (boolean[])SQLTest.getNodeFailure.get();
                if (getNodeFailure != null && getNodeFailure[0]) {
                    Log.getLogWriter().info("insert batching into gfxd failed due to node failure exception");
                    return;
                }
                throw new TestException("Does not expect execute batch to fail, need to check logs.");
            }
            throw new TestException("Does not expect execute batch to fail, need to check logs to confirm this issue.");
        }
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] != -3) {
                Log.getLogWriter().info("gemfirexd - inserted" + counts[i] + " rows in trade.buyorders OID:" + oid[i] + ",CID:" + cid[i] + ",SID:" + sid[i] + ",QTY:" + qty[i] + ",STATUS:" + status + ",TIME:" + time[i] + ",BID:" + bid[i] + ",TID:" + tid);
                if (counts[i] == verifyRowCount.get(tid + "_insert" + i)) continue;
                String str = "gemfirexd insert to buyorders has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + counts[i];
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            Log.getLogWriter().warning("gfxd failed to update in batch update");
        }
    }

    protected boolean insertToDerbyTable(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String status, Timestamp[] time, BigDecimal[] bid, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = TradeBuyOrdersDMLStmt.getStmt(conn, insert);
        if (stmt == null) {
            return false;
        }
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                verifyRowCount.put(tid + "_insert" + i, 0);
                count = this.insertToTable(stmt, oid[i], cid[i], sid[i], qty[i], status, time[i], bid[i], tid);
                verifyRowCount.put(tid + "_insert" + i, new Integer(count));
                Log.getLogWriter().info("Derby inserts " + verifyRowCount.get(tid + "_insert" + i) + " rows");
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected boolean insertToDerbyTableUsingBatch(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String status, Timestamp[] time, BigDecimal[] bid, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = TradeBuyOrdersDMLStmt.getStmt(conn, insert);
        if (stmt == null) {
            return false;
        }
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        int[] counts = null;
        for (int i = 0; i < size; ++i) {
            try {
                this.addBatchInsert(stmt, oid[i], cid[i], sid[i], qty[i], status, time[i], bid[i], tid);
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        try {
            counts = stmt.executeBatch();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exceptions);
        }
        if (counts == null && isOfflineTest && !SQLTest.syncHAForOfflineTest) {
            Log.getLogWriter().info("Hit bug #43754, and will be ignored");
            return false;
        }
        if (counts == null) {
            throw new TestException("Does not expect failure while inserting into derby using batch, need to check logs to find out cause for this");
        }
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] == -3) {
                throw new TestException("derby failed to insert rows in batch insert");
            }
            verifyRowCount.put(tid + "_insert" + i, 0);
            verifyRowCount.put(tid + "_insert" + i, new Integer(counts[i]));
            Log.getLogWriter().info("Derby - inserted " + counts[i] + " rowS in trade.buyorders OID:" + oid[i] + ",CID:" + cid[i] + ",SID:" + sid[i] + ",QTY:" + qty[i] + ",STATUS:" + status + ",TIME:" + time[i] + ",BID:" + bid[i] + ",TID:" + tid);
        }
        return true;
    }

    protected void getStatus(String[] status) {
        for (int i = 0; i < status.length; ++i) {
            status[i] = statuses[rand.nextInt(statuses.length)];
        }
    }

    protected Timestamp getRandTime() {
        return new Timestamp(System.currentTimeMillis() - (long)rand.nextInt(600000));
    }

    protected void getBid(BigDecimal[] bid) {
        for (int i = 0; i < bid.length; ++i) {
            bid[i] = this.getPrice();
        }
    }

    protected boolean getDataForUpdate(Connection regConn, int[] cid, int[] sid, int[] newSid, int[] qty, Timestamp[] orderTime, BigDecimal[] ask, BigDecimal[] ask2, int[] whichUpdate, int size) {
        Connection conn = TradeBuyOrdersDMLStmt.getAuthConn(regConn);
        int numOfNonUniq = update.length / 2;
        boolean success = this.getDataFromResult(conn, cid, sid);
        if (!success) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            newSid[i] = this.getSid(conn);
            qty[i] = this.getQty();
            orderTime[i] = this.getRandTime();
            ask[i] = this.getPrice();
            ask2[i] = this.getPrice();
            whichUpdate[i] = this.getWhichOne(numOfNonUniq, update.length);
        }
        return true;
    }

    protected boolean getDataFromResult(Connection regConn, int[] cid, int[] sid) {
        Connection conn = TradeBuyOrdersDMLStmt.getAuthConn(regConn);
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        if (!testUniqueKeys && !testWanUniqueness && tid != 0) {
            tid = rand.nextInt(tid);
        }
        return this.getDataFromResult(conn, cid, sid, tid);
    }

    protected boolean getDataFromResult(Connection conn, int[] cid, int[] sid, int tid) {
        int defaultCid = 0;
        int defaultSid = 0;
        int size = cid.length;
        boolean[] success = new boolean[1];
        int num = 20;
        int n = rand.nextInt(num);
        ResultSet rs = null;
        try {
            int whichQuery = 0;
            rs = TradeBuyOrdersDMLStmt.getQuery(conn, whichQuery, null, null, 0, 0, 0, null, tid, success);
            if (!success[0] || rs == null) {
                return false;
            }
            int i = 0;
            int temp = 0;
            while (rs.next() && i < size) {
                if (temp == 0) {
                    cid[i] = rs.getInt("CID");
                    sid[i] = rs.getInt("SID");
                } else if (n >= temp) {
                    cid[i] = rs.getInt("CID");
                    sid[i] = rs.getInt("SID");
                    ++i;
                }
                ++temp;
            }
            rs.close();
            while (i < size) {
                cid[i] = defaultCid;
                sid[i] = defaultSid;
                ++i;
            }
        }
        catch (SQLException se) {
            if (!SQLHelper.checkGFXDException(conn, se)) {
                return false;
            }
            if (SQLHelper.isAlterTableException(conn, se)) {
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean updateDerbyTable(Connection conn, int[] cid, int[] sid, int[] newSid, int[] qty, Timestamp[] orderTime, BigDecimal[] bid, BigDecimal[] bid2, int[] whichUpdate, int size, List<SQLException> exList) {
        PreparedStatement stmt = null;
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        int count = -1;
        boolean[] unsupported = new boolean[1];
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i], unsupported) : TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate[i]]);
            if (stmt == null) {
                if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                    return true;
                }
                return unsupported[0];
            }
            try {
                if (stmt == null) continue;
                verifyRowCount.put(tid + "_update" + i, 0);
                count = this.updateTable(stmt, cid[i], sid[i], newSid[i], qty[i], orderTime[i], bid[i], bid2[i], tid, whichUpdate[i]);
                verifyRowCount.put(tid + "_update" + i, new Integer(count));
                Log.getLogWriter().info("Derby updates " + count + " rows");
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exList);
            }
        }
        return true;
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, boolean[] unsupported) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectStmt(conn, whichUpdate, partitionKeys, unsupported);
    }

    protected void setPartitionKeys() {
        if (!isWanTest) {
            partitionKeys = (ArrayList)partitionMap.get((Object)"buyordersPartition");
        } else {
            int myWanSite = this.getMyWanSite();
            partitionKeys = (ArrayList)wanPartitionMap.get((Object)(myWanSite + "_buyordersPartition"));
        }
        Log.getLogWriter().info("partition keys are " + partitionKeys);
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys, boolean[] unsupported) {
        PreparedStatement stmt = null;
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("status")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("status")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("bid")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("bid") || partitionKeys.contains("qty")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 4: {
                if (partitionKeys.contains("sid")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 5: {
                if (partitionKeys.contains("status")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 6: {
                if (partitionKeys.contains("status")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 7: {
                if (partitionKeys.contains("bid")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 8: {
                if (partitionKeys.contains("bid") || partitionKeys.contains("qty")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 9: {
                if (partitionKeys.contains("sid")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected void updateGFETable(Connection conn, int[] cid, int[] sid, int[] newSid, int[] qty, Timestamp[] orderTime, BigDecimal[] bid, BigDecimal[] bid2, int[] whichUpdate, int size, List<SQLException> exList) {
        PreparedStatement stmt = null;
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i], null) : TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate[i]]);
            if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
                SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
                SQLSecurityTest.prepareStmtException.set(null);
                return;
            }
            if (setCriticalHeap && stmt == null) {
                return;
            }
            try {
                if (stmt == null || (count = this.updateTable(stmt, cid[i], sid[i], newSid[i], qty[i], orderTime[i], bid[i], bid2[i], tid, whichUpdate[i])) == verifyRowCount.get(tid + "_update" + i)) continue;
                String str = "Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exList);
            }
        }
    }

    protected void updateGFETable(Connection conn, int[] cid, int[] sid, int[] newSid, int[] qty, Timestamp[] orderTime, BigDecimal[] bid, BigDecimal[] bid2, int[] whichUpdate, int size) {
        PreparedStatement stmt = null;
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i], null) : TradeBuyOrdersDMLStmt.getStmt(conn, update[whichUpdate[i]]);
            try {
                if (stmt == null) continue;
                this.updateTable(stmt, cid[i], sid[i], newSid[i], qty[i], orderTime[i], bid[i], bid2[i], tid, whichUpdate[i]);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23503") && (whichUpdate[i] == 4 || whichUpdate[i] == 9)) {
                    Log.getLogWriter().info("detected foreign key constraint violation during update, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && (se.getSQLState().equals("42X14") || se.getSQLState().equals("42X04"))) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int updateTable(PreparedStatement stmt, int cid, int sid, int newSid, int qty, Timestamp orderTime, BigDecimal bid, BigDecimal bid2, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + update[whichUpdate];
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(database + "updating trade.buyorders with STATUS:filled where SID:" + sid + ",BID:" + bid + ",STATUS:open,TID:" + tid + query);
                stmt.setInt(1, sid);
                stmt.setBigDecimal(2, bid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with STATUS:filled where SID:" + sid + ",BID:" + bid + ",STATUS:open,TID:" + tid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "updating trade.buyorders with STATUS:cancelled where ORDERTIME:" + orderTime + ",SID:" + sid + ",TID:" + tid + query);
                if (testworkaroundFor51519) {
                    stmt.setTimestamp(1, orderTime, TradeBuyOrdersDMLStmt.getCal());
                } else {
                    stmt.setTimestamp(1, orderTime);
                }
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders STATUS:cancelled where ORDERTIME:" + orderTime + ",SID:" + sid + ",TID:" + tid + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "updating trade.buyorders with BID:" + bid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open,QTY:" + qty + ",TID:" + tid + query);
                stmt.setBigDecimal(1, bid);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                stmt.setInt(4, qty);
                stmt.setInt(5, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with BID:" + bid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open,QTY:" + qty + ",TID:" + tid + query);
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "updating trade.buyorders with BID:" + bid + ",QTY:" + qty + " where CID:" + cid + ",SID:" + sid + ",BID:" + bid2 + ",STATUS:open,TID:" + tid + query);
                stmt.setBigDecimal(1, bid);
                stmt.setInt(2, qty);
                stmt.setInt(3, cid);
                stmt.setInt(4, sid);
                stmt.setBigDecimal(5, bid2);
                stmt.setInt(6, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with BID:" + bid + ",QTY:" + qty + " where CID:" + cid + ",SID:" + sid + ",BID:" + bid2 + ",STATUS:open,TID:" + tid + query);
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "updating trade.buyorders with SID:" + newSid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open,TID: " + tid + query);
                stmt.setInt(1, newSid);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with SID:" + newSid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open,TID: " + tid + query);
                break;
            }
            case 5: {
                Log.getLogWriter().info(database + "updating trade.buyorders with STATUS:filled where SID:" + sid + ",BID:" + bid + ",STATUS:open" + query);
                stmt.setInt(1, sid);
                stmt.setBigDecimal(2, bid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with STATUS:filled where SID:" + sid + ",BID:" + bid + ",STATUS:open" + query);
                break;
            }
            case 6: {
                Log.getLogWriter().info(database + "updating trade.buyorders with STATUS:cancelled where ORDERTIME:" + orderTime + ",SID:" + sid + ",STATUS:open" + query);
                if (testworkaroundFor51519) {
                    stmt.setTimestamp(1, orderTime, TradeBuyOrdersDMLStmt.getCal());
                } else {
                    stmt.setTimestamp(1, orderTime);
                }
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders  with STATUS:cancelled where ORDERTIME:" + orderTime + ",SID:" + sid + ",STATUS:open" + query);
                break;
            }
            case 7: {
                Log.getLogWriter().info(database + "updating on trade.buyorders with BID:" + bid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open,QTY:" + qty + query);
                stmt.setBigDecimal(1, bid);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                stmt.setInt(4, qty);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with BID:" + bid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open,QTY:" + qty + query);
                break;
            }
            case 8: {
                Log.getLogWriter().info(database + "updating trade.buyorders with BID:" + bid + ",QTY:" + qty + " where CID:" + cid + ",SID:" + sid + ",BID:" + bid2 + ",STATUS:open" + query);
                stmt.setBigDecimal(1, bid);
                stmt.setInt(2, qty);
                stmt.setInt(3, cid);
                stmt.setInt(4, sid);
                stmt.setBigDecimal(5, bid2);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with BID:" + bid + ",QTY:" + qty + " where CID:" + cid + ",SID:" + sid + ",BID:" + bid2 + ",STATUS:open" + query);
                break;
            }
            case 9: {
                Log.getLogWriter().info(database + "updating trade.buyorders with SID:" + newSid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open" + query);
                stmt.setInt(1, newSid);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders  with SID:" + newSid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open" + query);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, String status, BigDecimal bid, int qty, int cid, int sid, Timestamp orderTime, int tid) {
        ResultSet rs;
        block4: {
            boolean[] success = new boolean[1];
            rs = null;
            try {
                rs = TradeBuyOrdersDMLStmt.getQuery(conn, whichQuery, status, bid, qty, cid, sid, orderTime, tid, success);
                int count = 0;
                while (!success[0]) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                        return null;
                    }
                    ++count;
                    MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                    rs = TradeBuyOrdersDMLStmt.getQuery(conn, whichQuery, status, bid, qty, cid, sid, orderTime, tid, success);
                }
            }
            catch (SQLException se) {
                if (SQLHelper.isAlterTableException(conn, se)) break block4;
                SQLHelper.handleSQLException(se);
            }
        }
        return rs;
    }

    protected static ResultSet query(Connection conn, int whichQuery, String status, BigDecimal bid, int qty, int cid, int sid, Timestamp orderTime, int tid) throws SQLException {
        boolean[] success = new boolean[1];
        ResultSet rs = TradeBuyOrdersDMLStmt.getQuery(conn, whichQuery, status, bid, qty, cid, sid, orderTime, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = TradeBuyOrdersDMLStmt.getQuery(conn, whichQuery, status, bid, qty, cid, sid, orderTime, tid, success);
        }
        return rs;
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, String status, BigDecimal bid, int qty, int cid, int sid, Timestamp orderTime, int tid, boolean[] success) throws SQLException {
        Boolean dumpResult = (Boolean)dumpNoAggregateRs.get();
        Boolean dumpQueryPlan = (Boolean)dumpQueryPlanRs.get();
        String sql = dumpResult != null && dumpResult != false ? selectwoaggreate[whichQuery] : (dumpQueryPlan != null && dumpQueryPlan != false ? "explain " + select[whichQuery] : select[whichQuery]);
        return TradeBuyOrdersDMLStmt.getQuery(conn, whichQuery, status, bid, qty, cid, sid, orderTime, tid, success, sql);
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, String status, BigDecimal bid, int qty, int cid, int sid, Timestamp orderTime, int tid, boolean[] success, String sql) throws SQLException {
        ResultSet rs = null;
        success[0] = true;
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + select[whichQuery];
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with  CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",ORDERTIME:" + orderTime + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, sid);
                    stmt.setInt(3, qty);
                    if (testworkaroundFor51519) {
                        stmt.setTimestamp(4, orderTime, TradeBuyOrdersDMLStmt.getCal());
                    } else {
                        stmt.setTimestamp(4, orderTime);
                    }
                    stmt.setInt(5, tid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + ",TID:" + tid + query);
                    stmt.setString(1, status);
                    stmt.setInt(2, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + ",TID:" + tid + query);
                    stmt.setString(1, status);
                    stmt.setInt(2, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + ",TID:" + tid + query);
                    stmt.setString(1, status);
                    stmt.setInt(2, tid);
                    break;
                }
                case 5: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + ",TID:" + tid + query);
                    stmt.setString(1, status);
                    stmt.setInt(2, tid);
                    break;
                }
                case 6: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 7: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with no data" + query);
                    break;
                }
                case 8: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",ORDERTIME:" + orderTime + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, sid);
                    stmt.setInt(3, qty);
                    if (testworkaroundFor51519) {
                        stmt.setTimestamp(4, orderTime, TradeBuyOrdersDMLStmt.getCal());
                        break;
                    }
                    stmt.setTimestamp(4, orderTime);
                    break;
                }
                case 9: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + query);
                    stmt.setString(1, status);
                    break;
                }
                case 10: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + query);
                    stmt.setString(1, status);
                    break;
                }
                case 11: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + query);
                    stmt.setString(1, status);
                    break;
                }
                case 12: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + query);
                    stmt.setString(1, status);
                    break;
                }
                case 13: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with no data" + query);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            throw se;
        }
        return rs;
    }

    protected int getDataForDelete(Connection regConn, int[] cid, int[] sid) {
        Connection conn = TradeBuyOrdersDMLStmt.getAuthConn(regConn);
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        if (!testUniqueKeys && !testWanUniqueness && tid != 0) {
            tid = rand.nextInt(tid);
        }
        return this.getDataForDelete(conn, cid, sid, tid);
    }

    protected int getDataForDelete(Connection conn, int[] cid, int[] sid, int tid) {
        int availSize = cid.length;
        int firstQuery = 0;
        ResultSet rs = null;
        int[] offset = new int[1];
        rs = TradeBuyOrdersDMLStmt.getQuery(conn, firstQuery, null, null, 0, 0, 0, null, tid);
        int count = 0;
        while (rs == null && !setCriticalHeap) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get result. abort this operations");
                return -1;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = TradeBuyOrdersDMLStmt.getQuery(conn, firstQuery, null, null, 0, 0, 0, null, TradeBuyOrdersDMLStmt.getMyTid());
        }
        ArrayList result = (ArrayList)ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
        SQLHelper.closeResultSet(rs, conn);
        if (result == null) {
            Log.getLogWriter().info("Could not get result. abort this operations");
            return -1;
        }
        availSize = this.getAvailSize(result, cid.length, offset);
        for (int i = 0; i < availSize; ++i) {
            cid[i] = (Integer)((GFXDStructImpl)result.get(i + offset[0])).get("CID");
            sid[i] = (Integer)((GFXDStructImpl)result.get(i + offset[0])).get("SID");
        }
        return availSize;
    }

    protected boolean deleteFromDerbyTable(Connection dConn, int whichDelete, int[] cid, int[] sid, int[] oid, BigDecimal[] bid, int[] qty, List<SQLException> exList) {
        PreparedStatement stmt = TradeBuyOrdersDMLStmt.getStmt(dConn, delete[whichDelete]);
        if (stmt == null) {
            return false;
        }
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        int count = -1;
        try {
            for (int i = 0; i < cid.length; ++i) {
                verifyRowCount.put(tid + "_delete_" + i, 0);
                count = this.deleteFromTable(stmt, cid[i], sid[i], oid[i], bid[i], qty[i], tid, whichDelete);
                verifyRowCount.put(tid + "_delete_" + i, new Integer(count));
            }
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void deleteFromGFETable(Connection gConn, int whichDelete, int[] cid, int[] sid, int[] oid, BigDecimal[] bid, int[] qty, List<SQLException> exList) {
        PreparedStatement stmt = TradeBuyOrdersDMLStmt.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        int count = -1;
        try {
            for (int i = 0; i < cid.length; ++i) {
                count = this.deleteFromTable(stmt, cid[i], sid[i], oid[i], bid[i], qty[i], tid, whichDelete);
                if (count == verifyRowCount.get(tid + "_delete_" + i)) continue;
                String str = "Gfxd delete (buyorders) has different row count from that of derby derby deleted " + verifyRowCount.get(tid + "_delete_" + i) + " but gfxd deleted " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void deleteFromGFETable(Connection gConn, int whichDelete, int[] cid, int[] sid, int[] oid, BigDecimal[] bid, int[] qty) {
        PreparedStatement stmt = TradeBuyOrdersDMLStmt.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeBuyOrdersDMLStmt.getMyTid();
        try {
            for (int i = 0; i < cid.length; ++i) {
                this.deleteFromTable(stmt, cid[i], sid[i], oid[i], bid[i], qty[i], tid, whichDelete);
            }
        }
        catch (SQLException se) {
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            if (alterTableDropColumn && (se.getSQLState().equals("42X14") || se.getSQLState().equals("42X04"))) {
                Log.getLogWriter().info("Got expected column not found exception in delete, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected int deleteFromTable(PreparedStatement stmt, int cid, int sid, int oid, BigDecimal bid, int qty, int tid, int whichDelete) throws SQLException {
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + delete[whichDelete];
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting trade.buyorders with CID:" + cid + ",SID:" + sid + ",TID:" + tid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.buyorders CID:" + cid + ",SID:" + sid + ",TID:" + tid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting trade.buyorders with OID:" + oid + ",BID:" + bid + ",QTY:" + qty + ",TID:" + tid + query);
                stmt.setInt(1, oid);
                stmt.setBigDecimal(2, bid);
                stmt.setInt(3, qty);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.buyorders OID:" + oid + ",BID:" + bid + ",QTY:" + qty + ",TID:" + tid + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "deleting trade.buyorders with QTY:" + qty + ",BID:" + bid + ",TID:" + tid + query);
                stmt.setInt(1, qty);
                stmt.setBigDecimal(2, bid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.buyorders QTY:" + qty + ",BID:" + bid + ",TID:" + tid + query);
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "deleting trade.buyorders with CID:" + cid + ",SID:" + sid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.buyorders CID:" + cid + ",SID:" + sid + query);
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "deleting trade.buyorders with OID:" + oid + ",BID:" + bid + ",QTY:" + qty + query);
                stmt.setInt(1, oid);
                stmt.setBigDecimal(2, bid);
                stmt.setInt(3, qty);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.buyorders OID:" + oid + ",BID:" + bid + ",QTY:" + qty + query);
                break;
            }
            case 5: {
                Log.getLogWriter().info(database + "deleting trade.buyorders with QTY:" + qty + ",BID:" + bid + query);
                stmt.setInt(1, qty);
                stmt.setBigDecimal(2, bid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.buyorders QTY:" + qty + ",BID:" + bid + query);
                break;
            }
            default: {
                throw new TestException(database + "incorrect delete statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    @Override
    public void put(Connection dConn, Connection gConn, int size) {
        if (testLoaderCreateRandomRow) {
            this.insertThruLoader(gConn, size);
            return;
        }
        int[] cid = new int[size];
        if (gConn == null) {
            this.getCids(dConn, cid);
        } else if (dConn != null && rand.nextBoolean()) {
            this.getCids(dConn, cid);
        } else {
            this.getCids(gConn, cid);
        }
        this.insert(dConn, gConn, size, cid, true);
    }
}

