/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.MasterController;
import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class TradeCustomerProfileDMLStmt
extends AbstractDMLStmt {
    protected static String insert = "insert into trade.customerprofile values (?,?,?,?)";
    protected static String put = "put into trade.customerprofile values (?,?,?,?)";
    protected static String[] update = new String[]{"update trade.customerprofile set rep = ? where cid=? and tid = ? and profile IS NULL", "update trade.customerprofile set profile = ? , rep = ? where cid IN (?,?) and tid =?", "update trade.customerprofile set profile = ?  where rep = ? and tid =? ", "update trade.customerprofile set rep = ? where cid=? and profile IS NULL", "update trade.customerprofile set profile = ? , rep = ? where cid IN (?,?) ", "update trade.customerprofile set profile = ?  where rep = ? "};
    protected static String[] select = new String[]{"select cid from trade.customerprofile where tid = ?", "select cid, rep from trade.customerprofile where tid=? and rep >?", "select cid, rep from trade.customerprofile where (cid =? or rep =?) and profile IS NOT NULL and tid = ?", "select min(cid) from trade.customerprofile where cid >? and rep >? and tid = ? group by rep having count(*) > 2", "select * from trade.customerprofile ", "select cid, profile from trade.customerprofile where rep >?", "select rep, profile from trade.customerprofile where (cid =? or rep =?) and profile IS NOT NULL ", "select min(cid) from trade.customerprofile where cid >? and rep > ? group by rep having count(*) > 2"};
    protected static String[] delete = new String[]{"delete from trade.customerprofile where rep = ? and profile is NOT NULL and tid = ?", "delete from trade.customerprofile where cid IN (?,?) and tid=?", "delete from trade.customerprofile where rep = ? and profile is NOT NULL ", "delete from trade.customerprofile where cid IN (?,?) "};
    protected static int maxNumOfTries = 2;
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();
    protected static ArrayList<String> partitionKeys = null;

    @Override
    public void delete(Connection dConn, Connection gConn) {
        int[] reps = this.getReps(gConn, 1);
        int[] cid = this.getCustProfCid(gConn, 1);
        int[] cid2 = this.getCustProfCid(gConn, 1);
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        int numOfNonUniqDelete = delete.length / 2;
        int whichDelete = this.getWhichOne(numOfNonUniqDelete, delete.length);
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (dConn != null && !useWriterForWriteThrough) {
            boolean success = this.deleteFromDerbyTable(dConn, cid[0], cid2[0], reps[0], whichDelete, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the op in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.deleteFromDerbyTable(dConn, cid[0], cid2[0], reps[0], whichDelete, exList);
            }
            this.deleteFromGFXDTable(gConn, cid[0], cid2[0], reps[0], whichDelete, exList);
            SQLHelper.handleMissedSQLException(exList);
        } else {
            this.deleteFromGFXDTable(gConn, cid[0], cid2[0], reps[0], whichDelete);
        }
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int initSize) {
        ArrayList<Integer> cid = new ArrayList<Integer>();
        this.getCustProfileCidsForInsert(gConn, cid);
        int size = cid.size();
        Log.getLogWriter().info("inserting to customerprofile " + size + " rows");
        int[] reps = this.getReps(gConn, size);
        Clob[] profile = this.getClob(size);
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        boolean success = false;
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (dConn != null && !useWriterForWriteThrough) {
            try {
                success = this.insertToDerbyTable(dConn, cid, reps, profile, size, exList);
                int count = 0;
                while (!success) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                        return;
                    }
                    MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                    exList.clear();
                    success = this.insertToDerbyTable(dConn, cid, reps, profile, size, exList);
                    ++count;
                }
                this.insertToGFXDTable(gConn, cid, reps, profile, size, exList);
                this.commit(dConn);
                this.commit(gConn);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                throw new TestException(" insert to trade.customerprofile fails\n" + TestHelper.getStackTrace((Throwable)se));
            }
        }
        try {
            this.insertToGFXDTable(gConn, cid, reps, profile, size);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("gemfirexd - insert to trade.customerprofile  fails\n" + TestHelper.getStackTrace((Throwable)se));
        }
    }

    @Override
    public void query(Connection dConn, Connection gConn) {
        int numOfNonUniq = select.length / 2;
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        int cid = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary));
        int[] rep = this.getReps(gConn, 1);
        if (dConn != null) {
            ResultSet discRS = this.getQuery(dConn, whichQuery, cid, rep[0]);
            if (discRS == null) {
                Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                return;
            }
            ResultSet gfxdRS = this.getQuery(gConn, whichQuery, cid, rep[0]);
            if (gfxdRS == null) {
                if (isHATest) {
                    Log.getLogWriter().info("Testing HA and did not get GFXD result set");
                    return;
                }
                throw new TestException("Not able to get gfxd result set after retry");
            }
            boolean success = ResultSetHelper.compareResultSets(discRS, gfxdRS);
            SQLHelper.closeResultSet(gfxdRS, gConn);
            if (!success) {
                Log.getLogWriter().info("Not able to compare results due to derby server error");
            }
        } else {
            ResultSet gfxdRS = this.getQuery(gConn, whichQuery, cid, rep[0]);
            if (gfxdRS != null) {
                ResultSetHelper.asList(gfxdRS, false);
            } else if (isHATest) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
            } else {
                throw new TestException("gfxd query returns null and not a HA test");
            }
            SQLHelper.closeResultSet(gfxdRS, gConn);
        }
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
        int[] cid = new int[size];
        int[] cid2 = new int[size];
        int[] reps = new int[size];
        Clob[] profile = new Clob[size];
        int[] whichUpdate = new int[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        this.getDataForUpdate(gConn, cid, cid2, reps, profile, whichUpdate, size);
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (dConn != null && !useWriterForWriteThrough) {
            int count = 0;
            boolean success = this.updateDerbyTable(dConn, cid, cid2, reps, profile, whichUpdate, size, exceptionList);
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish update in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                exceptionList.clear();
                success = this.updateDerbyTable(dConn, cid, cid2, reps, profile, whichUpdate, size, exceptionList);
                ++count;
            }
            this.updateGFXDTable(gConn, cid, cid2, reps, profile, whichUpdate, size, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.updateGFXDTable(gConn, cid, cid2, reps, profile, whichUpdate, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getCustProfileCidsForInsert(Connection gConn, ArrayList<Integer> cid) {
        String sql = "select cid from trade.customers where tid = " + TradeCustomerProfileDMLStmt.getMyTid() + " and cid NOT IN " + "(select cid from trade.customerprofile where tid = " + TradeCustomerProfileDMLStmt.getMyTid() + ")";
        List<Struct> results = null;
        ResultSet rs = null;
        try {
            rs = gConn.createStatement().executeQuery(sql);
            results = ResultSetHelper.asList(rs, false);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(gConn, se)) {
                Log.getLogWriter().info("could not get resultset due to derby locking issue");
            } else if (!SQLHelper.checkGFXDException(gConn, se)) {
                Log.getLogWriter().info("could not get resultset due to HA");
            } else {
                SQLHelper.handleSQLException(se);
            }
        }
        finally {
            SQLHelper.closeResultSet(rs, gConn);
        }
        if (results == null) {
            return;
        }
        for (Struct r : results) {
            cid.add((Integer)r.get("CID"));
        }
    }

    protected int[] getReps(Connection gConn, int size) {
        String sql = "select eid from emp.employees where tid =" + TradeCustomerProfileDMLStmt.getMyTid() + " and deptno IN (select deptid from emp.department d " + "where d.deptname IN ('sales', 'marketing', 'purchasing'))";
        int[] reps = new int[size];
        List<Struct> results = null;
        int sleepMs = 100;
        ResultSet rs = this.getResults(gConn, sql);
        results = ResultSetHelper.asList(rs, false);
        SQLHelper.closeResultSet(rs, gConn);
        while (results == null || results.size() == 0) {
            String newsql = "select eid from emp.employees where tid =" + TradeCustomerProfileDMLStmt.getMyTid();
            rs = this.getResults(gConn, newsql);
            results = ResultSetHelper.asList(rs, false);
            SQLHelper.closeResultSet(rs, gConn);
            Log.getLogWriter().info("does not get results set, will retry again");
            MasterController.sleepForMs((int)sleepMs);
        }
        for (int i = 0; i < size; ++i) {
            reps[i] = (Integer)results.get(rand.nextInt(results.size())).get("EID");
        }
        return reps;
    }

    protected ResultSet getResults(Connection gConn, String sql) {
        ResultSet rs = null;
        try {
            rs = gConn.createStatement().executeQuery(sql);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("0A000") && se.getMessage().contains("non-colocated tables")) {
                Log.getLogWriter().info("subquery requires colocated tables as well");
            }
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().warning("GFXD_NODE_SHUTDOWN happened and need to retry the query");
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected boolean insertToDerbyTable(Connection conn, List<Integer> cid, int[] reps, Clob[] profile, int size, List<SQLException> exceptions) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(insert);
        if (stmt == null) {
            return false;
        }
        int tid = TradeCustomerProfileDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, cid.get(i), reps[i], profile[i], tid);
                verifyRowCount.put(tid + "_insert" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected void insertToGFXDTable(Connection conn, List<Integer> cid, int[] reps, Clob[] profile, int size, List<SQLException> exceptions) throws SQLException {
        this.insertToGFXDTable(conn, cid, reps, profile, size, exceptions, false);
    }

    protected void insertToGFXDTable(Connection conn, List<Integer> cid, int[] reps, Clob[] profile, int size, List<SQLException> exceptions, boolean isPut) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(isPut ? put : insert);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeCustomerProfileDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            if (!SQLTest.hasTx && SQLTest.setTx && isHATest && this.getNodeFailureFlag()) {
                Log.getLogWriter().info("abort other ops in the txn in gfxd");
                return;
            }
            try {
                count = this.insertToTable(stmt, cid.get(i), reps[i], profile[i], tid, isPut);
                if (isHATest || count == verifyRowCount.get(tid + "_insert" + i)) continue;
                throw new TestException("Gfxd insert has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + count);
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void insertToGFXDTable(Connection conn, List<Integer> cid, int[] reps, Clob[] profile, int size) throws SQLException {
        this.insertToGFXDTable(conn, cid, reps, profile, size, false);
    }

    protected void insertToGFXDTable(Connection conn, List<Integer> cid, int[] reps, Clob[] profile, int size, boolean isPut) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(isPut ? put : insert);
        int tid = TradeCustomerProfileDMLStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, cid.get(i), reps[i], profile[i], tid, isPut);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, int cid, int rep, Clob profile, int tid) throws SQLException {
        return this.insertToTable(stmt, cid, rep, profile, tid, false);
    }

    protected int insertToTable(PreparedStatement stmt, int cid, int rep, Clob profile, int tid, boolean isPut) throws SQLException {
        String clob = null;
        clob = this.getStringFromClob(profile);
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.customerprofile with CID:" + cid + ",REP:" + rep + ",PROFILE:" + clob + ",TID:" + tid);
        stmt.setInt(1, cid);
        stmt.setInt(2, rep);
        if (profile == null) {
            stmt.setNull(3, 2005);
        } else {
            stmt.setClob(3, profile);
        }
        stmt.setInt(4, tid);
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows in trade.customerprofile CID:" + cid + ",REP:" + rep + ",PROFILE:" + clob + ",TID:" + tid);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    public ResultSet getQuery(Connection conn, int whichQuery, int cid, int rep) {
        int tid = TradeCustomerProfileDMLStmt.getMyTid();
        return TradeCustomerProfileDMLStmt.getQuery(conn, whichQuery, cid, rep, tid);
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, int cid, int rep, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = TradeCustomerProfileDMLStmt.getQuery(conn, whichQuery, cid, rep, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                if (SQLHelper.isDerbyConn(conn)) {
                    Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                }
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = TradeCustomerProfileDMLStmt.getQuery(conn, whichQuery, cid, rep, tid, success);
        }
        return rs;
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, int cid, int rep, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            String query = " QUERY: " + select[whichQuery];
            PreparedStatement stmt = conn.prepareStatement(select[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.customerprofile with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.customerprofile with REP:" + rep + ",TID:" + tid + query);
                    stmt.setInt(1, tid);
                    stmt.setInt(2, rep);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.customerprofile with CID:" + cid + ",REP:" + rep + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, rep);
                    stmt.setInt(3, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying trade.customerprofile with CID:" + cid + ",REP:" + rep + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, rep);
                    stmt.setInt(3, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.customerprofile with no data" + query);
                    break;
                }
                case 5: {
                    Log.getLogWriter().info(database + "querying trade.customerprofile with REP:" + rep + query);
                    stmt.setInt(1, rep);
                    break;
                }
                case 6: {
                    Log.getLogWriter().info(database + "querying trade.customerprofile with CID:" + cid + " rep: " + rep + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, rep);
                    break;
                }
                case 7: {
                    Log.getLogWriter().info(database + "querying trade.customerprofile with -- cid: " + cid + ",REP:" + rep + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, rep);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected void getDataForUpdate(Connection conn, int[] cid, int[] cid2, int[] reps, Clob[] profile, int[] whichUpdate, int size) {
        int numOfNonUniqUpdate = update.length / 2;
        reps = this.getReps(conn, size);
        profile = this.getClob(size);
        cid = this.getCustProfCid(conn, size);
        cid2 = this.getCustProfCid(conn, size);
        for (int i = 0; i < size; ++i) {
            whichUpdate[i] = this.getWhichOne(numOfNonUniqUpdate, update.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] getCustProfCid(Connection conn, int size) {
        String sql = "select cid from trade.customerprofile where tid = " + TradeCustomerProfileDMLStmt.getMyTid();
        List<Struct> list = null;
        ResultSet rs = null;
        int[] cids = new int[size];
        try {
            rs = conn.createStatement().executeQuery(sql);
            list = ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("could not get resultset due to derby locking issue");
            } else if (!SQLHelper.checkGFXDException(conn, se)) {
                Log.getLogWriter().info("could not get resultset due to HA");
            } else {
                SQLHelper.handleSQLException(se);
            }
        }
        finally {
            SQLHelper.closeResultSet(rs, conn);
        }
        if (list != null && list.size() > 0) {
            for (int cid : cids) {
                cid = (Integer)list.get(rand.nextInt(list.size())).get("CID");
            }
        }
        return cids;
    }

    protected boolean updateDerbyTable(Connection conn, int[] cid, int[] cid2, int[] reps, Clob[] profile, int[] whichUpdate, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = null;
        int tid = TradeCustomerProfileDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            block7: {
                stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i]) : TradeCustomerProfileDMLStmt.getStmt(conn, update[whichUpdate[i]]);
                if (stmt == null) {
                    try {
                        conn.prepareStatement(update[whichUpdate[i]]);
                    }
                    catch (SQLException se) {
                        if (!se.getSQLState().equals("08006") && !se.getSQLState().equals("08003")) break block7;
                        return false;
                    }
                }
            }
            try {
                if (stmt == null) continue;
                verifyRowCount.put(tid + "_update" + i, 0);
                count = this.updateTable(stmt, cid[i], cid2[i], reps[i], profile[i], tid, whichUpdate[i]);
                verifyRowCount.put(tid + "_update" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    Log.getLogWriter().info("detected the deadlock, will try it again");
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectStmt(conn, whichUpdate, partitionKeys);
    }

    protected void setPartitionKeys() {
        if (!isWanTest) {
            partitionKeys = new ArrayList();
        } else {
            int myWanSite = this.getMyWanSite();
            partitionKeys = (ArrayList)wanPartitionMap.get((Object)(myWanSite + "_employeesPartition"));
        }
        Log.getLogWriter().info("partition keys are " + partitionKeys);
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys) {
        PreparedStatement stmt = null;
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("rep")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomerProfileDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("profile") || partitionKeys.contains("rep")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomerProfileDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("profile")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomerProfileDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("rep")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomerProfileDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 4: {
                if (partitionKeys.contains("profile") || partitionKeys.contains("rep")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomerProfileDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 5: {
                if (partitionKeys.contains("profile")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeCustomerProfileDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected int updateTable(PreparedStatement stmt, int cid, int cid2, int rep, Clob profile, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        String clob = null;
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + update[whichUpdate];
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(database + "updating trade.customerprofile with REP:" + rep + " where CID:" + cid + ",TID:" + tid + query);
                stmt.setInt(1, rep);
                stmt.setInt(2, cid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.customerprofile REP:" + rep + " where CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 1: {
                BufferedReader reader;
                if (profile != null) {
                    if (profile.length() == 0L) {
                        clob = "empty profile";
                    } else {
                        reader = (BufferedReader)profile.getCharacterStream();
                        clob = ResultSetHelper.convertCharArrayToString(reader, (int)profile.length());
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            throw new TestException("could not close the BufferedReader" + TestHelper.getStackTrace((Throwable)e));
                        }
                    }
                }
                Log.getLogWriter().info(database + "updating trade.customerprofile with PROFILE:" + clob + ",REP:" + rep + " where 1_CID:" + cid + ",2_CID:" + cid2 + ",TID:" + tid + query);
                stmt.setClob(1, profile);
                stmt.setInt(2, rep);
                stmt.setInt(3, cid);
                stmt.setInt(4, cid2);
                stmt.setInt(5, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.customerprofile with PROFILE:" + clob + ",REP:" + rep + " where 1_CID:" + cid + ",2_CID:" + cid2 + ",TID:" + tid + query);
                break;
            }
            case 2: {
                BufferedReader reader;
                if (profile != null) {
                    if (profile.length() == 0L) {
                        clob = "empty profile";
                    } else {
                        reader = (BufferedReader)profile.getCharacterStream();
                        clob = ResultSetHelper.convertCharArrayToString(reader, (int)profile.length());
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            throw new TestException("could not close the BufferedReader" + TestHelper.getStackTrace((Throwable)e));
                        }
                    }
                }
                Log.getLogWriter().info(database + "updating trade.customerprofile with PROFILE:" + clob + " where REP:" + rep + ",TID:" + tid + query);
                stmt.setClob(1, profile);
                stmt.setInt(2, rep);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.customerprofile with PROFILE:" + clob + " where REP:" + rep + ",TID:" + tid + query);
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "updating trade.customerprofile with REP:" + rep + " where CID:" + cid + query);
                stmt.setInt(1, rep);
                stmt.setInt(2, cid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.customerprofile with REP:" + rep + " where CID:" + cid + query);
                break;
            }
            case 4: {
                BufferedReader reader;
                if (profile != null) {
                    if (profile.length() == 0L) {
                        clob = "empty profile";
                    } else {
                        reader = (BufferedReader)profile.getCharacterStream();
                        clob = ResultSetHelper.convertCharArrayToString(reader, (int)profile.length());
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            throw new TestException("could not close the BufferedReader" + TestHelper.getStackTrace((Throwable)e));
                        }
                    }
                }
                Log.getLogWriter().info(database + "updating trade.customerprofile with PROFILE:" + clob + ",REP:" + rep + " where 1_CID:" + cid + ",2_CID:" + cid2 + query);
                stmt.setClob(1, profile);
                stmt.setInt(2, rep);
                stmt.setInt(3, cid);
                stmt.setInt(4, cid2);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.customerprofile with PROFILE:" + clob + ",REP:" + rep + " where 1_CID:" + cid + ",2_CID:" + cid2 + query);
                break;
            }
            case 5: {
                if (profile != null) {
                    if (profile.length() == 0L) {
                        clob = "empty profile";
                    } else {
                        BufferedReader reader = (BufferedReader)profile.getCharacterStream();
                        clob = ResultSetHelper.convertCharArrayToString(reader, (int)profile.length());
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            throw new TestException("could not close the BufferedReader" + TestHelper.getStackTrace((Throwable)e));
                        }
                    }
                }
                Log.getLogWriter().info(database + "updating trade.customerprofile with PROFILE:" + clob + " where REP:" + rep + query);
                stmt.setClob(1, profile);
                stmt.setInt(2, rep);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.customerprofile with PROFILE:" + clob + " where REP:" + rep + query);
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void updateGFXDTable(Connection conn, int[] cid, int[] cid2, int[] reps, Clob[] profile, int[] whichUpdate, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = null;
        int tid = TradeCustomerProfileDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i]) : TradeCustomerProfileDMLStmt.getStmt(conn, update[whichUpdate[i]]);
            if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
                SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
                SQLSecurityTest.prepareStmtException.set(null);
                return;
            }
            try {
                if (stmt == null) continue;
                count = this.updateTable(stmt, cid[i], cid2[i], reps[i], profile[i], tid, whichUpdate[i]);
                if (isHATest || count == verifyRowCount.get(tid + "_update" + i)) continue;
                throw new TestException("Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + count);
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void updateGFXDTable(Connection conn, int[] cid, int[] cid2, int[] reps, Clob[] profile, int[] whichUpdate, int size) {
        PreparedStatement stmt = null;
        int tid = TradeCustomerProfileDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i]) : TradeCustomerProfileDMLStmt.getStmt(conn, update[whichUpdate[i]]);
            try {
                if (stmt == null) continue;
                count = this.updateTable(stmt, cid[i], cid2[i], reps[i], profile[i], tid, whichUpdate[i]);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected boolean deleteFromDerbyTable(Connection dConn, int cid, int cid2, int rep, int whichDelete, List<SQLException> exList) {
        int tid = TradeCustomerProfileDMLStmt.getMyTid();
        int count = -1;
        PreparedStatement stmt = TradeCustomerProfileDMLStmt.getStmt(dConn, delete[whichDelete]);
        if (stmt == null) {
            return false;
        }
        try {
            verifyRowCount.put(tid + "_delete", 0);
            count = this.deleteFromTable(stmt, cid, cid2, rep, tid, whichDelete);
            verifyRowCount.put(tid + "_delete", new Integer(count));
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void deleteFromGFXDTable(Connection gConn, int cid, int cid2, int rep, int whichDelete, List<SQLException> exList) {
        int tid = TradeCustomerProfileDMLStmt.getMyTid();
        int count = -1;
        PreparedStatement stmt = TradeCustomerProfileDMLStmt.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        try {
            count = this.deleteFromTable(stmt, cid, cid2, rep, tid, whichDelete);
            if (count != verifyRowCount.get(tid + "_delete") && !isHATest) {
                throw new TestException("Gfxd delete (customers) has different row count from that of derby derby deleted " + verifyRowCount.get(tid + "_delete") + " but gfxd deleted " + count);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void deleteFromGFXDTable(Connection gConn, int cid, int cid2, int rep, int whichDelete) {
        int tid = TradeCustomerProfileDMLStmt.getMyTid();
        PreparedStatement stmt = TradeCustomerProfileDMLStmt.getStmt(gConn, delete[whichDelete]);
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        try {
            this.deleteFromTable(stmt, cid, cid2, rep, tid, whichDelete);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23503")) {
                Log.getLogWriter().info("detected the foreign key constraint violation, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected int deleteFromTable(PreparedStatement stmt, int cid, int cid2, int rep, int tid, int whichDelete) throws SQLException {
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + delete[whichDelete];
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting  trade.customerprofile with REP:" + rep + ",TID:" + tid + query);
                stmt.setInt(1, rep);
                stmt.setInt(2, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.customerprofile REP:" + rep + ",TID:" + tid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting trade.customerprofile with CID:" + cid + "," + cid2 + ",TID:" + tid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, cid2);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.customerprofile with CID:" + cid + "," + cid2 + ",TID:" + tid + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "deleting trade.customerprofile with REP:" + rep + query);
                stmt.setInt(1, rep);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.customerprofile REP:" + rep + query);
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "deleting trade.customerprofile with 1_CID:" + cid + ",2_CID:" + cid2 + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, cid2);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.customerprofile  1_CID:" + cid + ",2_CID:" + cid2 + query);
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    @Override
    public void put(Connection dConn, Connection gConn, int initSize) {
        ArrayList<Integer> cid = new ArrayList<Integer>();
        this.getCustProfileCidsForInsert(gConn, cid);
        int size = cid.size();
        int[] reps = this.getReps(gConn, size);
        Clob[] profile = this.getClob(size);
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        boolean success = false;
        if (dConn != null && !useWriterForWriteThrough) {
            try {
                success = this.insertToDerbyTable(dConn, cid, reps, profile, size, exList);
                int count = 0;
                while (!success) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                        return;
                    }
                    MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                    exList.clear();
                    success = this.insertToDerbyTable(dConn, cid, reps, profile, size, exList);
                    ++count;
                }
                this.insertToGFXDTable(gConn, cid, reps, profile, size, exList, true);
                if (SQLTest.setTx) {
                    this.commit(gConn);
                    this.commit(dConn);
                }
                this.commit(dConn);
                this.commit(gConn);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                throw new TestException("put to trade.customerprofile fails\n" + TestHelper.getStackTrace((Throwable)se));
            }
        } else {
            try {
                this.insertToGFXDTable(gConn, cid, reps, profile, size, true);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                throw new TestException("put to trade.customerprofile in gfxd fails\n" + TestHelper.getStackTrace((Throwable)se));
            }
        }
    }
}

